 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                      CCCC   AAA    CCCC  H   H  EEEEE                       % O %                     C      A   A  C      H   H  E                           % O %                     C      AAAAA  C      HHHHH  EEE                         % O %                     C      A   A  C      H   H  E                           % O %                      CCCC  A   A   CCCC  H   H  EEEEE                       % O %                                                                             % O %                            IIIII     /  OOO                                 % O %                              I      /  O   O                                % O %                              I     /   O   O                                % O %                              I    /    O   O                                % O %                            IIIII /      OOO                                 % O %                                                                             % O %                                                                             % O %                    ImageMagick Pixel Cache I/O Methods                      % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                             William Radcliffe                               % O %                               November 1999                                 % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h" #if defined(HasPTHREADS) #include <pthread.h> #endif   /*   Typedef declarations.  */ typedef struct _CacheInfo  {    char     filename[MaxTextExtent];     FILE
     *file;     ClassType / #if defined(__cplusplus) || defined(c_plusplus)      c_class; #else 
     class; #endif     size_t     number_pixels;     unsigned int     columns,	     rows,      mapped;   
   PixelPacket      *pixels;  
   IndexPacket 
     *indexes;  } CacheInfo;   /*   Global declarations. */ static off_t(   cache_threshold = PixelCacheThreshold;   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C l o s e P i x e l C a c h e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method ClosePixelCache closes the file handle associated with a disk pixel 	 %  cache.  % / %  The format of the ClosePixelCache method is:  % 5 %      void ClosePixelCache(CacheHandle cache_handle)  % + %  A description of each parameter follows:  % D %    o cache_handle: Specifies a pointer to a CacheHandle structure. %  %  */5 Export void ClosePixelCache(CacheHandle cache_handle)  {    CacheInfo      *cache_info;  -   assert(cache_handle != (CacheHandle) NULL); (   cache_info=(CacheInfo *) cache_handle;(   if (cache_info->file != (FILE *) NULL)$     (void) fclose(cache_info->file);!   cache_info->file=(FILE *) NULL;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s t r o y C a c h e I n f o                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Method DestroyCacheInfo deallocates memory associated with the pixel cache. % 0 %  The format of the DestroyCacheInfo method is: % 6 %      void DestroyCacheInfo(CacheHandle cache_handle) % + %  A description of each parameter follows:  % D %    o cache_handle: Specifies a pointer to a CacheHandle structure. %  %  */6 Export void DestroyCacheInfo(CacheHandle cache_handle) {    CacheInfo      *cache_info;     size_t     length;   -   assert(cache_handle != (CacheHandle) NULL); (   cache_info=(CacheInfo *) cache_handle;    ClosePixelCache(cache_handle);   if (cache_info->mapped)      {        /*/         Unmap memory-mapped pixels and indexes.        */;       length=cache_info->number_pixels*sizeof(PixelPacket); +       if (cache_info->class == PseudoClass) >         length+=cache_info->number_pixels*sizeof(IndexPacket);2       (void) UnmapBlob(cache_info->pixels,length);.       cache_info->pixels=(PixelPacket *) NULL;/       cache_info->indexes=(IndexPacket *) NULL;      } $   if (*cache_info->filename != '\0')(     (void) remove(cache_info->filename);1   if (cache_info->pixels != (PixelPacket *) NULL)      {        /*         Free pixels.       */%       FreeMemory(cache_info->pixels); K       (void) GetCacheMemory(cache_info->number_pixels*sizeof(PixelPacket));      } 2   if (cache_info->indexes != (IndexPacket *) NULL)     {        /*         Free colormap indexes.       */&       FreeMemory(cache_info->indexes);K       (void) GetCacheMemory(cache_info->number_pixels*sizeof(IndexPacket));      }    FreeMemory(cache_info);    cache_handle=(void *) NULL;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t C a c h e C l a s s T y p e                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method GetCacheClassType returns the class type of the pixel cache. % 1 %  The format of the GetCacheClassType method is:  % < %      ClassType GetCacheClassType(CacheHandle cache_handle) % + %  A description of each parameter follows:  % I %    o type: Method GetCacheClassType returns DirectClass or PseudoClass.  % D %    o cache_handle: Specifies a pointer to a CacheHandle structure. %  %  */< Export ClassType GetCacheClassType(CacheHandle cache_handle) {    CacheInfo      *cache_info;  -   assert(cache_handle != (CacheHandle) NULL); (   cache_info=(CacheInfo *) cache_handle;   return(cache_info->class); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t C a c h e I n f o                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Method GetCacheInfo initializes the CacheHandle structure.  % , %  The format of the GetCacheInfo method is: % 3 %      void GetCacheInfo(CacheHandle *cache_handle)  % + %  A description of each parameter follows:  % D %    o cache_handle: Specifies a pointer to a CacheHandle structure. %  %  */3 Export void GetCacheInfo(CacheHandle *cache_handle)  {    CacheInfo      *cache_info;  /   assert(cache_handle != (CacheHandle *) NULL); =   cache_info=(CacheInfo *) AllocateMemory(sizeof(CacheInfo));    *cache_info->filename='\0'; !   cache_info->file=(FILE *) NULL; #   cache_info->class=UndefinedClass;    cache_info->mapped=False; *   cache_info->pixels=(PixelPacket *) NULL;+   cache_info->indexes=(IndexPacket *) NULL;    cache_info->number_pixels=0;   cache_info->rows=0;    cache_info->columns=0;   *cache_handle=cache_info;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t C a c h e M e m o r y                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method GetCacheMemory adjusts the amount of free cache memory and then  %  returns the resulting value.  % . %  The format of the GetCacheMemory method is: % ) %      off_t GetCacheMemory(off_t memory)  % + %  A description of each parameter follows:  % F %    o memory: Specifies the adjustment to the cache memory.  Use 0 to3 %      return the current free memory in the cache.  %  %  */) Export off_t GetCacheMemory(off_t memory)  {    static off_t0     free_memory = PixelCacheThreshold*1024*1024;   #if defined(HasPTHREADS)   static pthread_mutex_t-     memory_mutex = PTHREAD_MUTEX_INITIALIZER;   $   pthread_mutex_lock(&memory_mutex);   free_memory+=memory;&   pthread_mutex_unlock(&memory_mutex); #else    free_memory+=memory; #endif   return(free_memory); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t C a c h e T h e s h o l d                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method GetCacheThreshold gets the amount of free memory allocated for theM %  pixel cache.  Once this threshold is exceeded, all subsequent pixels cache  %  operations are to/from disk.  % 1 %  The format of the GetCacheThreshold method is:  %   %      off_t GetCacheThreshold() % + %  A description of each parameter follows:  % J %    o threshold: The number of megabytes of memory available to the pixel
 %      cache.  %  %  */  Export off_t GetCacheThreshold() {    return(cache_threshold); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I n i t i a l i z e P i x e l C a c h e                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ; %  Method InitializePixelCache initializes the pixel cache.  % 4 %  The format of the InitializePixelCache method is: % B %      unsigned int InitializePixelCache(CacheHandle cache_handle,K %        ClassType type,const unsigned int columns,const unsigned int rows)  % + %  A description of each parameter follows:  % J %    o status: Method InitializePixelCache returns True if the pixel cache3 %      is initialized successfully otherwise False.  % D %    o cache_handle: Specifies a pointer to a CacheHandle structure. % ( %    o type: DirectClass or PseudoClass. % J %    o columns: This unsigned integer defines the number of columns in the %      pixel cache.  % J %    o rows: This unsigned integer defines the number of rows in the pixel
 %      cache.  %  %  */B Export unsigned int InitializePixelCache(CacheHandle cache_handle,D   ClassType type,const unsigned int columns,const unsigned int rows) {    CacheInfo      *cache_info;     int      status;      off_t      number_pixels,     offset;      size_t     length;   -   assert(cache_handle != (CacheHandle) NULL); (   cache_info=(CacheInfo *) cache_handle;   number_pixels=columns*rows; 8   if (GetCacheClassType(cache_handle) == UndefinedClass)     { /       length=number_pixels*sizeof(PixelPacket);        if (type == PseudoClass)2         length+=number_pixels*sizeof(IndexPacket);&       if (length <= GetCacheMemory(0))	         {            /*)             Create in-memory pixel cache.            */,           cache_info->pixels=(PixelPacket *)>             AllocateMemory(number_pixels*sizeof(PixelPacket));9           if (cache_info->pixels != (PixelPacket *) NULL) 
             { :               SetCacheClassType(cache_handle,DirectClass);H               (void) GetCacheMemory(-number_pixels*sizeof(PixelPacket));&               if (type == PseudoClass)                 { 5                   cache_info->indexes=(IndexPacket *) F                     AllocateMemory(number_pixels*sizeof(IndexPacket));B                   if (cache_info->indexes != (IndexPacket *) NULL)                     { B                       SetCacheClassType(cache_handle,PseudoClass);P                       (void) GetCacheMemory(-number_pixels*sizeof(IndexPacket));                     }                  } 
             } 	         } <       if (GetCacheClassType(cache_handle) == UndefinedClass)	         {            char$             filename[MaxTextExtent];             /*'             Create pixel cache on disk.            */&           TemporaryFilename(filename);1           cache_info->file=fopen(filename,"wb+"); 0           if (cache_info->file != (FILE *) NULL)
             { ?               status=fseek(cache_info->file,length-1,SEEK_SET);                if (status == 0)                 { >                   SetCacheClassType(cache_handle,DirectClass);?                   (void) strcpy(cache_info->filename,filename); 3                   (void) fputc(0,cache_info->file); 2                   (void) fclose(cache_info->file);1                   cache_info->file=(FILE *) NULL; 4                   cache_info->pixels=(PixelPacket *)A                     MapBlob(cache_info->filename,IOMode,&length); A                   if (cache_info->pixels == (PixelPacket *) NULL)                      { .                       if (type == PseudoClass)D                         SetCacheClassType(cache_handle,PseudoClass);                     }                    else                     { .                       cache_info->mapped=True;.                       if (type == PseudoClass)                         { F                           SetCacheClassType(cache_handle,PseudoClass);=                           cache_info->indexes=(IndexPacket *) ?                             (cache_info->pixels+number_pixels);                          }                      }                  } 
             } 	         } .       cache_info->number_pixels=number_pixels;       cache_info->rows=rows;"       cache_info->columns=columns;     } 8   if (GetCacheClassType(cache_handle) == UndefinedClass)     return(False);   if (type == PseudoClass)     { 9       if (GetCacheClassType(cache_handle) != PseudoClass) 	         { .           if (cache_info->filename[0] == '\0')
             {                /*6                 Create in-memory colormap index cache.               */1               cache_info->indexes=(IndexPacket *) B                 AllocateMemory(number_pixels*sizeof(IndexPacket));>               if (cache_info->indexes != (IndexPacket *) NULL)                 { >                   SetCacheClassType(cache_handle,PseudoClass);L                   (void) GetCacheMemory(-number_pixels*sizeof(IndexPacket));                 } 
             }            else
             {                /*4                 Create colormap index cache on disk.               */4               if (cache_info->file == (FILE *) NULL)C                 cache_info->file=fopen(cache_info->filename,"rb+"); 4               if (cache_info->file != (FILE *) NULL)                 { ;                   length=number_pixels*sizeof(PixelPacket)+ 6                     number_pixels*sizeof(IndexPacket);C                   status=fseek(cache_info->file,length-1,SEEK_SET); "                   if (status == 0)                     { B                       SetCacheClassType(cache_handle,PseudoClass);7                       (void) fputc(0,cache_info->file); 6                       (void) fclose(cache_info->file);5                       cache_info->file=(FILE *) NULL; ?                       offset=number_pixels*sizeof(PixelPacket); -                       if (cache_info->mapped) D                         (void) UnmapBlob(cache_info->pixels,offset);8                       cache_info->pixels=(PixelPacket *)E                         MapBlob(cache_info->filename,IOMode,&length); )                       cache_info->mapped= C                         cache_info->pixels != (PixelPacket *) NULL; -                       if (cache_info->mapped) ;                         cache_info->indexes=(IndexPacket *) =                           (cache_info->pixels+number_pixels);                      }                  } 
             } 	         } 9       if (GetCacheClassType(cache_handle) != PseudoClass)          return(False);     } 5   if ((cache_info->pixels == (PixelPacket *) NULL) && *       (cache_info->file == (FILE *) NULL))     {        /*         Open disk pixel cache.       */9       cache_info->file=fopen(cache_info->filename,"rb+"); ,       if (cache_info->file == (FILE *) NULL)         return(False);     }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d C a c h e I n d e x e s                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method ReadCacheIndexes reads colormap indexes from the specified region  %  of the pixel cache. % 0 %  The format of the ReadCacheIndexes method is: % > %      unsigned int ReadCacheIndexes(CacheHandle cache_handle,9 %        RectangleInfo *region_info,IndexPacket *indexes)  % + %  A description of each parameter follows:  % L %    o status:  Method ReadCacheIndexes returns True if the colormap indexesC %      are successfully read from the pixel cache, otherwise False.  % @ %    o cache_info: Specifies a pointer to a CacheInfo structure. % J %    o region_info:  The address of a RectangleInfo structure that defines  %      the cache region to read. % M %    o indexes: The colormap indexes are copied from this IndexPacket address  %      to the pixel cache. %  %  */> Export unsigned int ReadCacheIndexes(CacheHandle cache_handle,2   RectangleInfo *region_info,IndexPacket *indexes) {    CacheInfo      *cache_info;     register int     y;     size_t
     count;     off_t      offset;   -   assert(cache_handle != (CacheHandle) NULL); (   cache_info=(CacheInfo *) cache_handle;;   offset=region_info->y*cache_info->columns+region_info->x; /   for (y=0; y < (int) region_info->height; y++)    { 4     if (cache_info->indexes != (IndexPacket *) NULL)7       (void) memcpy(indexes,cache_info->indexes+offset, 0         region_info->width*sizeof(IndexPacket));     else       { ?         count=fseek(cache_info->file,cache_info->number_pixels* C           sizeof(PixelPacket)+offset*sizeof(IndexPacket),SEEK_SET);          if (count != 0)            return(False);C         count=fread(indexes,sizeof(IndexPacket),region_info->width,            cache_info->file);(         if (count != region_info->width)           return(False);       }       indexes+=region_info->width;      offset+=cache_info->columns;   } $   if (y < (int) region_info->height)     return(False);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d C a c h e P i x e l s                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method ReadCachePixels reads pixels from the specified region of the pixel 	 %  cache.  % / %  The format of the ReadCachePixels method is:  % = %      unsigned int ReadCachePixels(CacheHandle cache_handle, 9 %        RectangleInfo *region_info,IndexPacket *indexes)  % + %  A description of each parameter follows:  % E %    o status:  Method ReadCachePixels returns True if the pixels are ? %      successfully read from the pixel cache, otherwise False.  % @ %    o cache_info: Specifies a pointer to a CacheInfo structure. % J %    o region_info:  The address of a RectangleInfo structure that defines  %      the cache region to read. % I %    o pixels: The pixels are copied from this PixelPacket address to the  %      pixel cache.  %  %  */= Export unsigned int ReadCachePixels(CacheHandle cache_handle, 1   RectangleInfo *region_info,PixelPacket *pixels)  {    register int     y;     size_t
     count;     off_t      offset;   3   CacheInfo *cache_info=(CacheInfo *) cache_handle; +   assert(cache_info != (CacheInfo *) NULL); ;   offset=region_info->y*cache_info->columns+region_info->x; /   for (y=0; y < (int) region_info->height; y++)    { 3     if (cache_info->pixels != (PixelPacket *) NULL) 5       (void) memcpy(pixels,cache_info->pixels+offset, 0         region_info->width*sizeof(PixelPacket));     else       { J         count=fseek(cache_info->file,offset*sizeof(PixelPacket),SEEK_SET);         if (count != 0)            return(False);B         count=fread(pixels,sizeof(PixelPacket),region_info->width,           cache_info->file);(         if (count != region_info->width)           return(False);       }      pixels+=region_info->width;       offset+=cache_info->columns;   } $   if (y < (int) region_info->height)     return(False);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S e t C a c h e C l a s s T y p e                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method SetCacheClassType sets the cache type:  DirectClass or PseudoClass.  % 1 %  The format of the SetCacheClassType method is:  % 7 %      void SetCacheClassType(CacheHandle cache_handle)  % + %  A description of each parameter follows:  % D %    o cache_handle: Specifies a pointer to a CacheHandle structure. % = %    o type: The pixel cache type DirectClass or PseudoClass.  %  %  */F Export void SetCacheClassType(CacheHandle cache_handle,ClassType type) {    CacheInfo      *cache_info;  -   assert(cache_handle != (CacheHandle) NULL); (   cache_info=(CacheInfo *) cache_handle;   cache_info->class=type;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S e t C a c h e T h e s h o l d                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method SetCacheThreshold sets the amount of free memory allocated for theM %  pixel cache.  Once this threshold is exceeded, all subsequent pixels cache  %  operations are to/from disk.  % 1 %  The format of the SetCacheThreshold method is:  % / %      void SetCacheThreshold(size_t threshold)  % + %  A description of each parameter follows:  % J %    o threshold: The number of megabytes of memory available to the pixel
 %      cache.  %  %  */. Export void SetCacheThreshold(off_t threshold) { >   (void) GetCacheMemory(-cache_threshold-threshold*1024*1024);   cache_threshold=threshold; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e C a c h e I n d e x e s                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method WriteCachePixels writes a colormap indexes to the specified region %  of the pixel cache. % 0 %  The format of the WriteCachePixels method is: % > %      unsigned int WriteCachePixels(CacheHandle cache_handle,9 %        RectangleInfo *region_info,IndexPacket *indexes)  % + %  A description of each parameter follows:  % L %    o status:  Method WriteCachePixels returns True if the colormap indexesD %      are successfully written to the pixel cache, otherwise False. % @ %    o cache_info: Specifies a pointer to a CacheInfo structure. % J %    o region_info:  The address of a RectangleInfo structure that defines! %      the cache region to write.  % L %    o indexes: The colormap indexes are copied from the pixel cache to this %      IndexPacket address.  %  %  */? Export unsigned int WriteCacheIndexes(CacheHandle cache_handle, 2   RectangleInfo *region_info,IndexPacket *indexes) {    CacheInfo      *cache_info;     register int     y;     size_t
     count;     off_t      offset;   -   assert(cache_handle != (CacheHandle) NULL); (   cache_info=(CacheInfo *) cache_handle;;   offset=region_info->y*cache_info->columns+region_info->x; /   for (y=0; y < (int) region_info->height; y++)    { 4     if (cache_info->indexes != (IndexPacket *) NULL)7       (void) memcpy(cache_info->indexes+offset,indexes, 0         region_info->width*sizeof(IndexPacket));     else       { ?         count=fseek(cache_info->file,cache_info->number_pixels* C           sizeof(PixelPacket)+offset*sizeof(IndexPacket),SEEK_SET);          if (count != 0)            return(False);D         count=fwrite(indexes,sizeof(IndexPacket),region_info->width,           cache_info->file);(         if (count != region_info->width)           return(False);       }       indexes+=region_info->width;      offset+=cache_info->columns;   } $   if (y < (int) region_info->height)     return(False);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e C a c h e P i x e l s                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method WriteCachePixels writes pixels to the specified region of the pixel 	 %  cache.  % 0 %  The format of the WriteCachePixels method is: % > %      unsigned int WriteCachePixels(CacheHandle cache_handle,8 %        RectangleInfo *region_info,PixelPacket *pixels) % + %  A description of each parameter follows:  % F %    o status:  Method WriteCachePixels returns True if the pixels are: %      successfully written to the cache, otherwise False. % @ %    o cache_info: Specifies a pointer to a CacheInfo structure. % J %    o region_info:  The address of a RectangleInfo structure that defines! %      the cache region to write.  % M %    o pixels: The pixels are copied from the pixel cache to this PixelPacket  %      address.  %  %  */> Export unsigned int WriteCachePixels(CacheHandle cache_handle,1   RectangleInfo *region_info,PixelPacket *pixels)  {    CacheInfo      *cache_info;     register int     y;     size_t
     count;     off_t      offset;   -   assert(cache_handle != (CacheHandle) NULL); (   cache_info=(CacheInfo *) cache_handle;;   offset=region_info->y*cache_info->columns+region_info->x; /   for (y=0; y < (int) region_info->height; y++)    { 3     if (cache_info->pixels != (PixelPacket *) NULL) 5       (void) memcpy(cache_info->pixels+offset,pixels, 0         region_info->width*sizeof(PixelPacket));     else       { J         count=fseek(cache_info->file,offset*sizeof(PixelPacket),SEEK_SET);         if (count != 0)            return(False);C         count=fwrite(pixels,sizeof(PixelPacket),region_info->width,            cache_info->file);(         if (count != region_info->width)           return(False);       }      pixels+=region_info->width;       offset+=cache_info->columns;   } $   if (y < (int) region_info->height)     return(False);   return(True);  } 