 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %           CCCC   OOO   M   M  PPPP   RRRR   EEEEE   SSSSS  SSSSS            % O %          C      O   O  MM MM  P   P  R   R  E       SS     SS               % O %          C      O   O  M M M  PPPP   RRRR   EEE      SSS    SSS             % O %          C      O   O  M   M  P      R R    E          SS     SS            % O %           CCCC   OOO   M   M  P      R  R   EEEEE   SSSSS  SSSSS            % O %                                                                             % O %                                                                             % O %                  Image Compression/Decompression Methods                    % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                              May  1993                                      % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h" #if defined(HasTIFF) #include "tiffio.h"  #endif #if defined(HasZLIB) #include "zlib.h"  #endif   /*   Define declarations. */- #define LoadImageText  "  Loading image...  " , #define SaveImageText  "  Saving image...  "   /*   Typedef declarations.  */ typedef struct HuffmanTable  {    int      id, 	     code,      length, 
     count; } HuffmanTable;    typedef struct _ScanlinePacket {    unsigned char 
     pixel;     int 
     state; } ScanlinePacket;    /*   Huffman coding declarations. */ #define TWId  23 #define MWId  24 #define TBId  25 #define MBId  26 #define EXId  27   static const HuffmanTable    MBTable[]=   { 4     { MBId, 0x0f, 10, 64 }, { MBId, 0xc8, 12, 128 },5     { MBId, 0xc9, 12, 192 }, { MBId, 0x5b, 12, 256 }, 5     { MBId, 0x33, 12, 320 }, { MBId, 0x34, 12, 384 }, 5     { MBId, 0x35, 12, 448 }, { MBId, 0x6c, 13, 512 }, 5     { MBId, 0x6d, 13, 576 }, { MBId, 0x4a, 13, 640 }, 5     { MBId, 0x4b, 13, 704 }, { MBId, 0x4c, 13, 768 }, 5     { MBId, 0x4d, 13, 832 }, { MBId, 0x72, 13, 896 }, 6     { MBId, 0x73, 13, 960 }, { MBId, 0x74, 13, 1024 },7     { MBId, 0x75, 13, 1088 }, { MBId, 0x76, 13, 1152 }, 7     { MBId, 0x77, 13, 1216 }, { MBId, 0x52, 13, 1280 }, 7     { MBId, 0x53, 13, 1344 }, { MBId, 0x54, 13, 1408 }, 7     { MBId, 0x55, 13, 1472 }, { MBId, 0x5a, 13, 1536 }, 7     { MBId, 0x5b, 13, 1600 }, { MBId, 0x64, 13, 1664 }, 2     { MBId, 0x65, 13, 1728 }, { MBId, 0x00, 0, 0 }   };   static const HuffmanTable    EXTable[]=   { 7     { EXId, 0x08, 11, 1792 }, { EXId, 0x0c, 11, 1856 }, 7     { EXId, 0x0d, 11, 1920 }, { EXId, 0x12, 12, 1984 }, 7     { EXId, 0x13, 12, 2048 }, { EXId, 0x14, 12, 2112 }, 7     { EXId, 0x15, 12, 2176 }, { EXId, 0x16, 12, 2240 }, 7     { EXId, 0x17, 12, 2304 }, { EXId, 0x1c, 12, 2368 }, 7     { EXId, 0x1d, 12, 2432 }, { EXId, 0x1e, 12, 2496 }, 2     { EXId, 0x1f, 12, 2560 }, { EXId, 0x00, 0, 0 }   };   static const HuffmanTable    MWTable[]=   { 2     { MWId, 0x1b, 5, 64 }, { MWId, 0x12, 5, 128 },3     { MWId, 0x17, 6, 192 }, { MWId, 0x37, 7, 256 }, 3     { MWId, 0x36, 8, 320 }, { MWId, 0x37, 8, 384 }, 3     { MWId, 0x64, 8, 448 }, { MWId, 0x65, 8, 512 }, 3     { MWId, 0x68, 8, 576 }, { MWId, 0x67, 8, 640 }, 3     { MWId, 0xcc, 9, 704 }, { MWId, 0xcd, 9, 768 }, 3     { MWId, 0xd2, 9, 832 }, { MWId, 0xd3, 9, 896 }, 4     { MWId, 0xd4, 9, 960 }, { MWId, 0xd5, 9, 1024 },5     { MWId, 0xd6, 9, 1088 }, { MWId, 0xd7, 9, 1152 }, 5     { MWId, 0xd8, 9, 1216 }, { MWId, 0xd9, 9, 1280 }, 5     { MWId, 0xda, 9, 1344 }, { MWId, 0xdb, 9, 1408 }, 5     { MWId, 0x98, 9, 1472 }, { MWId, 0x99, 9, 1536 }, 5     { MWId, 0x9a, 9, 1600 }, { MWId, 0x18, 6, 1664 }, 1     { MWId, 0x9b, 9, 1728 }, { MWId, 0x00, 0, 0 }    };   static const HuffmanTable    TBTable[]=   { F     { TBId, 0x37, 10, 0 }, { TBId, 0x02, 3, 1 }, { TBId, 0x03, 2, 2 },E     { TBId, 0x02, 2, 3 }, { TBId, 0x03, 3, 4 }, { TBId, 0x03, 4, 5 }, E     { TBId, 0x02, 4, 6 }, { TBId, 0x03, 5, 7 }, { TBId, 0x05, 6, 8 }, G     { TBId, 0x04, 6, 9 }, { TBId, 0x04, 7, 10 }, { TBId, 0x05, 7, 11 }, H     { TBId, 0x07, 7, 12 }, { TBId, 0x04, 8, 13 }, { TBId, 0x07, 8, 14 },J     { TBId, 0x18, 9, 15 }, { TBId, 0x17, 10, 16 }, { TBId, 0x18, 10, 17 },K     { TBId, 0x08, 10, 18 }, { TBId, 0x67, 11, 19 }, { TBId, 0x68, 11, 20 }, K     { TBId, 0x6c, 11, 21 }, { TBId, 0x37, 11, 22 }, { TBId, 0x28, 11, 23 }, K     { TBId, 0x17, 11, 24 }, { TBId, 0x18, 11, 25 }, { TBId, 0xca, 12, 26 }, K     { TBId, 0xcb, 12, 27 }, { TBId, 0xcc, 12, 28 }, { TBId, 0xcd, 12, 29 }, K     { TBId, 0x68, 12, 30 }, { TBId, 0x69, 12, 31 }, { TBId, 0x6a, 12, 32 }, K     { TBId, 0x6b, 12, 33 }, { TBId, 0xd2, 12, 34 }, { TBId, 0xd3, 12, 35 }, K     { TBId, 0xd4, 12, 36 }, { TBId, 0xd5, 12, 37 }, { TBId, 0xd6, 12, 38 }, K     { TBId, 0xd7, 12, 39 }, { TBId, 0x6c, 12, 40 }, { TBId, 0x6d, 12, 41 }, K     { TBId, 0xda, 12, 42 }, { TBId, 0xdb, 12, 43 }, { TBId, 0x54, 12, 44 }, K     { TBId, 0x55, 12, 45 }, { TBId, 0x56, 12, 46 }, { TBId, 0x57, 12, 47 }, K     { TBId, 0x64, 12, 48 }, { TBId, 0x65, 12, 49 }, { TBId, 0x52, 12, 50 }, K     { TBId, 0x53, 12, 51 }, { TBId, 0x24, 12, 52 }, { TBId, 0x37, 12, 53 }, K     { TBId, 0x38, 12, 54 }, { TBId, 0x27, 12, 55 }, { TBId, 0x28, 12, 56 }, K     { TBId, 0x58, 12, 57 }, { TBId, 0x59, 12, 58 }, { TBId, 0x2b, 12, 59 }, K     { TBId, 0x2c, 12, 60 }, { TBId, 0x5a, 12, 61 }, { TBId, 0x66, 12, 62 }, 0     { TBId, 0x67, 12, 63 }, { TBId, 0x00, 0, 0 }   };   static const HuffmanTable    TWTable[]=   { E     { TWId, 0x35, 8, 0 }, { TWId, 0x07, 6, 1 }, { TWId, 0x07, 4, 2 }, E     { TWId, 0x08, 4, 3 }, { TWId, 0x0b, 4, 4 }, { TWId, 0x0c, 4, 5 }, E     { TWId, 0x0e, 4, 6 }, { TWId, 0x0f, 4, 7 }, { TWId, 0x13, 5, 8 }, G     { TWId, 0x14, 5, 9 }, { TWId, 0x07, 5, 10 }, { TWId, 0x08, 5, 11 }, H     { TWId, 0x08, 6, 12 }, { TWId, 0x03, 6, 13 }, { TWId, 0x34, 6, 14 },H     { TWId, 0x35, 6, 15 }, { TWId, 0x2a, 6, 16 }, { TWId, 0x2b, 6, 17 },H     { TWId, 0x27, 7, 18 }, { TWId, 0x0c, 7, 19 }, { TWId, 0x08, 7, 20 },H     { TWId, 0x17, 7, 21 }, { TWId, 0x03, 7, 22 }, { TWId, 0x04, 7, 23 },H     { TWId, 0x28, 7, 24 }, { TWId, 0x2b, 7, 25 }, { TWId, 0x13, 7, 26 },H     { TWId, 0x24, 7, 27 }, { TWId, 0x18, 7, 28 }, { TWId, 0x02, 8, 29 },H     { TWId, 0x03, 8, 30 }, { TWId, 0x1a, 8, 31 }, { TWId, 0x1b, 8, 32 },H     { TWId, 0x12, 8, 33 }, { TWId, 0x13, 8, 34 }, { TWId, 0x14, 8, 35 },H     { TWId, 0x15, 8, 36 }, { TWId, 0x16, 8, 37 }, { TWId, 0x17, 8, 38 },H     { TWId, 0x28, 8, 39 }, { TWId, 0x29, 8, 40 }, { TWId, 0x2a, 8, 41 },H     { TWId, 0x2b, 8, 42 }, { TWId, 0x2c, 8, 43 }, { TWId, 0x2d, 8, 44 },H     { TWId, 0x04, 8, 45 }, { TWId, 0x05, 8, 46 }, { TWId, 0x0a, 8, 47 },H     { TWId, 0x0b, 8, 48 }, { TWId, 0x52, 8, 49 }, { TWId, 0x53, 8, 50 },H     { TWId, 0x54, 8, 51 }, { TWId, 0x55, 8, 52 }, { TWId, 0x24, 8, 53 },H     { TWId, 0x25, 8, 54 }, { TWId, 0x58, 8, 55 }, { TWId, 0x59, 8, 56 },H     { TWId, 0x5a, 8, 57 }, { TWId, 0x5b, 8, 58 }, { TWId, 0x4a, 8, 59 },H     { TWId, 0x4b, 8, 60 }, { TWId, 0x32, 8, 61 }, { TWId, 0x33, 8, 62 },/     { TWId, 0x34, 8, 63 }, { TWId, 0x00, 0, 0 }    };   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   A S C I I 8 5 E n c o d e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method ASCII85Encode encodes data in ASCII base-85 format.  ASCII base-85L %  encoding produces five ASCII printing characters from every four bytes of %  binary data.  % - %  The format of the ASCII85Encode method is:  % # %      void Ascii85Initialize(void)  % + %  A description of each parameter follows:  % : %    o code: a binary unsigned char to encode to ASCII 85. % < %    o file: write the encoded ASCII character to this file. %  %  */ #define MaxLineExtent  36   
 static int	   offset, 
   line_break;    static unsigned char   ascii85_buffer[10];   . static char *Ascii85Tuple(unsigned char *data) { 
   static char 
     tuple[6];      register unsigned int 	     word,      x;     register unsigned short      y;  E   word=(((data[0] << 8) | data[1]) << 16) | (data[2] << 8) | data[3];    if (word == 0L)      {        tuple[0]='z';        tuple[1]='\0';       return(tuple);     } )   x=(unsigned int) (word/(85L*85*85*85));    tuple[0]=x+'!';    word-=x*(85L*85*85*85); &   x=(unsigned int) (word/(85L*85*85));   tuple[1]=x+'!';    word-=x*(85L*85*85);"   x=(unsigned int) (word/(85*85));   tuple[2]=x+'!'; '   y=(unsigned short) (word-x*(85L*85));    tuple[3]=(y/85)+'!';   tuple[4]=(y % 85)+'!';   tuple[5]='\0';   return(tuple); }   # Export void Ascii85Initialize(void)  {     line_break=MaxLineExtent << 1;   offset=0;  }   & Export void Ascii85Flush(Image *image) {    register char      *tuple;   "   assert(image != (Image *) NULL);   if (offset > 0)      {        ascii85_buffer[offset]=0; !       ascii85_buffer[offset+1]=0; !       ascii85_buffer[offset+2]=0; )       tuple=Ascii85Tuple(ascii85_buffer); F       (void) WriteBlob(image,offset+1,*tuple == 'z' ? "!!!!" : tuple);     }    (void) WriteByte(image,'~');   (void) WriteByte(image,'>');   (void) WriteByte(image,'\n');  }   ? Export void Ascii85Encode(Image *image,const unsigned int code)  {    int      n;     register char      *q;      register unsigned char     *p;   "   assert(image != (Image *) NULL);   ascii85_buffer[offset]=code;   offset++;    if (offset < 4)      return;    p=ascii85_buffer;    for (n=offset; n >= 4; n-=4)   { $     for (q=Ascii85Tuple(p); *q; q++)     {        line_break--; .       if ((line_break < 0) && (*(q+1) != '%'))	         { '           (void) WriteByte(image,'\n'); %           line_break=2*MaxLineExtent; 	         } !       (void) WriteByte(image,*q);      } 	     p+=8;    }    offset=n;    p-=4;    for (n=0; n < 4; n++)      ascii85_buffer[n]=(*p++);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   H u f f m a n D e c o d e I m a g e                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method HuffmanDecodeImage uncompresses an image via Huffman-coding. % 2 %  The format of the HuffmanDecodeImage method is: % 4 %      unsigned int HuffmanDecodeImage(Image *image) % + %  A description of each parameter follows:  % L %    o status:  Method HuffmanDecodeImage returns True if all the pixels are1 %      compressed without error, otherwise False.  % 7 %    o image: The address of a structure of type Image.  %  %  */4 Export unsigned int HuffmanDecodeImage(Image *image) {  #define HashSize  1021 #define MBHashA  293 #define MBHashB  2695  #define MWHashA  3510  #define MWHashB  1178   - #define InitializeHashTable(hash,table,a,b) \  { \    entry=table; \   while (entry->code != 0) \   {  \R     hash[((entry->length+a)*(entry->code+b)) % HashSize]=(HuffmanTable *) entry; \     entry++; \   } \  }    #define InputBit(bit)  \ {  \   if ((mask & 0xff) == 0)  \     {  \       byte=ReadByte(image);  \       mask=0x80;  \      }  \   runlength++;  \    bit=byte & mask ? 1 : 0; \   mask>>=1;  \
   if (bit)  \      runlength=0;  \    if (EOFBlob(image))  \
     break;  \  }      const HuffmanTable     *entry;      HuffmanTable     **mb_hash,     **mw_hash;  
   IndexPacket 
     index;     int 	     bail, 	     code, 
     color,
     count,     length,      null_lines,      runlength,     y;     register int     i,     x;     register PixelPacket     *q;      register unsigned char     *p;      unsigned char      bit,	     byte, 	     mask,      *scanline;     /*     Allocate buffers.    */"   assert(image != (Image *) NULL);L   mb_hash=(HuffmanTable **) AllocateMemory(HashSize*sizeof(HuffmanTable *));L   mw_hash=(HuffmanTable **) AllocateMemory(HashSize*sizeof(HuffmanTable *));   scanline=(unsigned char *)9     AllocateMemory(image->columns*sizeof(unsigned char)); ,   if ((mb_hash == (HuffmanTable **) NULL) ||,       (mw_hash == (HuffmanTable **) NULL) ||+       (scanline == (unsigned char *) NULL))      { D       MagickWarning(ResourceLimitWarning,"Memory allocation failed",         (char *) NULL);        return(False);     }    /*     Initialize Huffman tables.   */   for (i=0; i < HashSize; i++)   { %     mb_hash[i]=(HuffmanTable *) NULL; %     mw_hash[i]=(HuffmanTable *) NULL;    } 7   InitializeHashTable(mw_hash,TWTable,MWHashA,MWHashB); 7   InitializeHashTable(mw_hash,MWTable,MWHashA,MWHashB); 7   InitializeHashTable(mw_hash,EXTable,MWHashA,MWHashB); 7   InitializeHashTable(mb_hash,TBTable,MBHashA,MBHashB); 7   InitializeHashTable(mb_hash,MBTable,MBHashA,MBHashB); 7   InitializeHashTable(mb_hash,EXTable,MBHashA,MBHashB);    /*6     Uncompress 1D Huffman to runlength encoded pixels.   */	   byte=0; 	   mask=0;    null_lines=0;    runlength=0;   while (runlength < 11)    InputBit(bit); )   do { InputBit(bit); } while (bit == 0);    image->x_resolution=204.0;   image->y_resolution=196.0;'   image->units=PixelsPerInchResolution; <   for (y=0; ((y < (int) image->rows) && (null_lines < 3)); )   {      /*#       Initialize scanline to white.      */     p=scanline; ,     for (x=0; x < (int) image->columns; x++)
       *p++=0;      /*&       Decode Huffman encoded scanline.     */     color=True;      code=0;      count=0;
     length=0;      runlength=0;     x=0;     for ( ; ; )      { $       if (x >= (int) image->columns)	         {             while (runlength < 11)            InputBit(bit); 1           do { InputBit(bit); } while (bit == 0);            break;	         }        bail=False;        do       {          if (runlength < 11)            InputBit(bit)          else           {              InputBit(bit);             if (bit)               {                  null_lines++;                  if (x != 0)                    null_lines=0;                  bail=True;                 break;               }            }          code=(code << 1)+bit;          length++;        } while (code <= 0);       if (bail)          break;       if (length > 13)	         {             while (runlength < 11)            InputBit(bit); 1           do { InputBit(bit); } while (bit == 0);            break;	         }        if (color)	         {            if (length < 4)              continue; F           entry=mw_hash[((length+MWHashA)*(code+MWHashB)) % HashSize];	         } 
       else	         {            if (length < 2)              continue; F           entry=mb_hash[((length+MBHashA)*(code+MBHashB)) % HashSize];	         }        if (!entry)          continue; =       if ((entry->length != length) || (entry->code != code))          continue;        switch (entry->id)       {          case TWId:         case TBId:	         {            count+=entry->count;/           if ((x+count) > (int) image->columns) #             count=image->columns-x;            if (count > 0)
             {                if (color)                 {                    x+=count;                    count=0;                 }                else+                 for ( ; count > 0; count--) "                   scanline[x++]=1;
             }            color=!color;            break;	         }          case MWId:         case MBId:         case EXId:	         {            count+=entry->count;           break;	         }          default:           break;       } 
       code=0;        length=0;      }      /*(       Transfer scanline to image pixels.     */     p=scanline; 0     q=SetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     { $       index=(unsigned short) (*p++);       image->indexes[x]=index;"       *q++=image->colormap[index];     }      if (!SyncPixelCache(image))        break;#     if (QuantumTick(y,image->rows)) 3       ProgressMonitor(LoadImageText,y,image->rows);      y++;   }    image->rows=Max(y-3,1); $   image->compression=FaxCompression;   /*     Free decoder memory.   */   FreeMemory(mw_hash);   FreeMemory(mb_hash);   FreeMemory(scanline);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   H u f f m a n E n c o d e I m a g e                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Method HuffmanEncodeImage compresses an image via Huffman-coding. % 2 %  The format of the HuffmanEncodeImage method is: % P %      unsigned int HuffmanEncodeImage(const ImageInfo *image_info,Image *image) % + %  A description of each parameter follows:  % L %    o status:  Method HuffmanEncodeImage returns True if all the pixels are1 %      compressed without error, otherwise False.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % 7 %    o image: The address of a structure of type Image.  %  */P Export unsigned int HuffmanEncodeImage(const ImageInfo *image_info,Image *image) { # #define HuffmanOutputCode(entry)  \  {  \!   mask=1 << (entry->length-1);  \    while (mask != 0)  \   {  \/     OutputBit((entry->code & mask ? 1 : 0));  \      mask>>=1;  \   }  \ }    #define OutputBit(count)  \  {  \   if(count > 0)  \     byte=byte | bit;  \ 
   bit>>=1;  \    if ((bit & 0xff) == 0)   \     {  \9       if (Latin1Compare(image_info->magick,"FAX") == 0) \ (         (void) WriteByte(image,byte);  \       else \3         Ascii85Encode(image,(unsigned int) byte); \        byte=0;  \       bit=0x80;  \     }  \ }      const HuffmanTable     *entry;      int      k,     runlength,     y;     Image      *huffman_image;      register int     i,     n,     x;     register unsigned char     *q;      register unsigned short 
     polarity;      unsigned char      bit,	     byte,      *scanline;     unsigned int	     mask, 
     width;     /*     Allocate scanline buffer.    */"   assert(image != (Image *) NULL);   width=image->columns; 3   if (Latin1Compare(image_info->magick,"FAX") == 0) #     width=Max(image->columns,1728); M   scanline=(unsigned char *) AllocateMemory((width+1)*sizeof(unsigned char)); )   if (scanline == (unsigned char *) NULL)      { D       MagickWarning(ResourceLimitWarning,"Memory allocation failed",         (char *) NULL);        return(False);     }     huffman_image=(Image *) image;(   if (!IsMonochromeImage(huffman_image))     {        QuantizeInfo         quantize_info;         /*$         Convert image to monochrome.       */F       huffman_image=CloneImage(image,image->columns,image->rows,True);*       if (huffman_image == (Image *) NULL)         return(False);&       GetQuantizeInfo(&quantize_info);$       quantize_info.number_colors=2;.       quantize_info.dither=image_info->dither;.       quantize_info.colorspace=GRAYColorspace;9       (void) QuantizeImage(&quantize_info,huffman_image);      } 	   byte=0;    bit=0x80; 3   if (Latin1Compare(image_info->magick,"FAX") != 0)      Ascii85Initialize();   else     {        /*         End of line.       */       for (k=0; k < 11; k++)         OutputBit(0);        OutputBit(1);      }    /*4     Compress runlength encoded to 1D Huffman pixels.   */
   polarity=0; !   if (huffman_image->colors == 2) 5     polarity=(Intensity(huffman_image->colormap[0]) > 5       Intensity(huffman_image->colormap[1]) ? 0 : 1); 
   q=scanline; !   for (i=0; i < (int) width; i++) "     *q++=(unsigned char) polarity;
   q=scanline; /   for (y=0; y < (int) huffman_image->rows; y++)    { C     if (!GetPixelCache(huffman_image,0,y,huffman_image->columns,1))        break;4     for (x=0; x < (int) huffman_image->columns; x++)     { A       *q=(unsigned char) (huffman_image->indexes[x] == polarity ? *         (int) polarity : (int) !polarity);
       q++;     }      /*       Huffman encode scanline.     */     q=scanline;      for (n=width; n > 0; )     {        /*         Output white run.        */;       for (runlength=0; ((*q == polarity) && (n > 0)); n--)        {          q++;         runlength++;       }        if (runlength >= 64)	         { +           entry=MWTable+((runlength/64)-1);             if (runlength >= 1792)8             entry=EXTable+(Min(runlength,2560)-1792)/64;"           runlength-=entry->count;#           HuffmanOutputCode(entry); 	         } &       entry=TWTable+Min(runlength,63);       HuffmanOutputCode(entry);        if (n != 0) 	         {            /*             Output black run.            */?           for (runlength=0; ((*q != polarity) && (n > 0)); n--)            {              q++;             runlength++;           }            if (runlength >= 64)
             { /               entry=MBTable+((runlength/64)-1); $               if (runlength >= 1792)<                 entry=EXTable+(Min(runlength,2560)-1792)/64;&               runlength-=entry->count;'               HuffmanOutputCode(entry); 
             } *           entry=TBTable+Min(runlength,63);#           HuffmanOutputCode(entry); 	         }      }      /*       End of line.     */     for (k=0; k < 11; k++)       OutputBit(0);      OutputBit(1);      q=scanline; 2     if (huffman_image->previous == (Image *) NULL)-       if (QuantumTick(y,huffman_image->rows)) =         ProgressMonitor(SaveImageText,y,huffman_image->rows);    }    /*     End of page.   */   for (i=0; i < 6; i++)    {      for (k=0; k < 11; k++)       OutputBit(0);      OutputBit(1);    }    /*     Flush bits.    */   if (bit != 0x80)     { 7       if (Latin1Compare(image_info->magick,"FAX") == 0) %         (void) WriteByte(image,byte); 
       else1         Ascii85Encode(image,(unsigned int) byte);      } 3   if (Latin1Compare(image_info->magick,"FAX") != 0)      Ascii85Flush(image);   if (huffman_image != image)       DestroyImage(huffman_image);   FreeMemory(scanline);    return(True);  }    #if defined(HasTIFF) /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   H u f f m a n 2 D E n c o d e I m a g e                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method Huffman2DEncodeImage compresses an image via two-dimensional %  Huffman-coding. % 4 %  The format of the Huffman2DEncodeImage method is: % L %      unsigned int Huffman2DEncodeImage(ImageInfo *image_info,Image *image) % + %  A description of each parameter follows:  % N %    o status:  Method Huffman2DEncodeImage returns True if all the pixels are1 %      compressed without error, otherwise False.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % 7 %    o image: The address of a structure of type Image.  %  */L Export unsigned int Huffman2DEncodeImage(ImageInfo *image_info,Image *image) {    char     filename[MaxTextExtent];     Image      *huffman_image;      ImageInfo      *local_info;     int 
     count;     register int     i,     j;     TIFF
     *tiff;       uint16     fillorder;     unsigned char      *buffer;     unsigned int     *byte_count,     status,      strip_size;      /*<     Write image as CCITTFax4 TIFF image to a temporary file.   */+   assert(image_info != (ImageInfo *) NULL); "   assert(image != (Image *) NULL);B   huffman_image=CloneImage(image,image->columns,image->rows,True);&   if (huffman_image == (Image *) NULL)     return(False);(   if (!IsMonochromeImage(huffman_image))     {        QuantizeInfo         quantize_info;         /*$         Convert image to monochrome.       */&       GetQuantizeInfo(&quantize_info);$       quantize_info.number_colors=2;.       quantize_info.dither=image_info->dither;.       quantize_info.colorspace=GRAYColorspace;9       (void) QuantizeImage(&quantize_info,huffman_image);      }    TemporaryFilename(filename);2   (void) strcpy(huffman_image->filename,filename);.   (void) strcpy(huffman_image->magick,"TIFF");(   local_info=CloneImageInfo(image_info);,   local_info->compression=Group4Compression;.   status=WriteImage(local_info,huffman_image);   DestroyImageInfo(local_info);    DestroyImage(huffman_image);   if (status == False)     return(False);)   tiff=TIFFOpen(filename,ReadBinaryType);    (void) remove(filename);   if (tiff == (TIFF *) NULL)     { P       MagickWarning(FileOpenWarning,"Unable to open file",image_info->filename);       return(False);     }    /*     Allocate raw strip buffer.   */9   TIFFGetField(tiff,TIFFTAG_STRIPBYTECOUNTS,&byte_count);    strip_size=byte_count[0]; 4   for (i=1; i < (int) TIFFNumberOfStrips(tiff); i++)#     if (byte_count[i] > strip_size)        strip_size=byte_count[i]; L   buffer=(unsigned char *) AllocateMemory(strip_size*sizeof(unsigned char));'   if (buffer == (unsigned char *) NULL)      { D       MagickWarning(ResourceLimitWarning,"Memory allocation failed",         (char *) NULL);        TIFFClose(tiff);       return(False);     }    /*4     Compress runlength encoded to 2D Huffman pixels.   */;   TIFFGetFieldDefaulted(tiff,TIFFTAG_FILLORDER,&fillorder); 4   for (i=0; i < (int) TIFFNumberOfStrips(tiff); i++)   {      Ascii85Initialize();8     count=TIFFReadRawStrip(tiff,i,buffer,byte_count[i]);'     if (fillorder == FILLORDER_LSB2MSB) $       TIFFReverseBits(buffer,count);     for (j=0; j < count; j++) 4       Ascii85Encode(image,(unsigned int) buffer[j]);     Ascii85Flush(image);   }    FreeMemory(buffer);    TIFFClose(tiff);   return(True);  }  #else L Export unsigned int Huffman2DEncodeImage(ImageInfo *image_info,Image *image) { "   assert(image != (Image *) NULL);G   MagickWarning(MissingDelegateWarning,"TIFF library is not available",      image->filename);    return(False); }  #endif   #if defined(HasLZW)  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   L Z W E n c o d e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method LZWEncodeImage compresses an image via LZW-coding specific to O %  Postscript Level II or Portable Document Format.  To ensure portability, the 1 %  binary LZW bytes are encoded as ASCII base-85.  % . %  The format of the LZWEncodeImage method is: % 0 %      unsigned int LZWEncodeImage(Image *image,@ %        const unsigned int number_pixels,unsigned char *pixels) % + %  A description of each parameter follows:  % H %    o status:  Method LZWEncodeImage returns True if all the pixels are1 %      compressed without error, otherwise False.  % 7 %    o image: The address of a structure of type Image.  % H %    o number_pixels:  An unsigned interger that specifies the number of %      pixels to compress. % L %    o pixels: The address of an unsigned array of characters containing the %      pixels to compress. %  %  */0 Export unsigned int LZWEncodeImage(Image *image,9   const unsigned int number_pixels,unsigned char *pixels)  { - #define LZWClr  256  /* Clear Table Marker */ - #define LZWEod  257  /* End of Data marker */  #define OutputCode(code) \ { \ @     accumulator+=((long) code) << (32-code_width-number_bits); \     number_bits+=code_width; \     while (number_bits >= 8) \     { \ B         Ascii85Encode(image,(unsigned int) (accumulator >> 24)); \'         accumulator=accumulator << 8; \          number_bits-=8; \      } \  }      typedef struct _TableType    { 	     short 
       prefix, 
       suffix,        next;    } TableType;     int 
     index;     register int     i;     short      number_bits,     code_width,      last_code,     next_index;      TableType      *table;      unsigned long      accumulator;     /*     Allocate string table.   */"   assert(image != (Image *) NULL);+   assert(pixels != (unsigned char *) NULL); B   table=(TableType *) AllocateMemory((1 << 12)*sizeof(TableType));"   if (table == (TableType *) NULL)     return(False);   /*     Initialize variables.    */   accumulator=0;   code_width=9;    number_bits=0;   last_code=0;   Ascii85Initialize();   OutputCode(LZWClr); %   for (index=0; index < 256; index++)    {      table[index].prefix=(-1);      table[index].suffix=index;     table[index].next=(-1);    }    next_index=LZWEod+1;   code_width=9;    last_code=pixels[0];)   for (i=1; i < (int) number_pixels; i++)    {      /*       Find string.     */     index=last_code;     while (index != -1) /       if ((table[index].prefix != last_code) || -           (table[index].suffix != pixels[i]))           index=table[index].next;
       else	         {            last_code=index;           break;	         }      if (last_code != index)        { 
         /*           Add string. 
         */         OutputCode(last_code);+         table[next_index].prefix=last_code; +         table[next_index].suffix=pixels[i]; 5         table[next_index].next=table[last_code].next; )         table[last_code].next=next_index;          next_index++; 
         /*0           Did we just move up to next bit width?
         */,         if ((next_index >> code_width) != 0)           {              code_width++;               if (code_width > 12)               {                  /*4                   Did we overflow the max bit width?                 */                 code_width--; #                 OutputCode(LZWClr); 3                 for (index=0; index < 256; index++)                  { +                   table[index].prefix=(-1); ,                   table[index].suffix=index;)                   table[index].next=(-1);                  } $                 next_index=LZWEod+1;                 code_width=9;                } 
             }            last_code=pixels[i];       }    }    /*     Flush tables.    */   OutputCode(last_code);   OutputCode(LZWEod);    if (number_bits != 0) +     Ascii85Encode(image,accumulator >> 24);    Ascii85Flush(image);   FreeMemory(table);   return(True);  }  #else 0 Export unsigned int LZWEncodeImage(Image *image,9   const unsigned int number_pixels,unsigned char *pixels)  { "   assert(image != (Image *) NULL);F   MagickWarning(MissingDelegateWarning,"LZW library is not available",     (char *) NULL);    return(False); }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   P a c k b i t s E n c o d e I m a g e                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method PackbitsEncodeImage compresses an image via Macintosh PackbitsL %  encoding specific to Postscript Level II or Portable Document Format.  ToN %  ensure portability, the binary Packbits bytes are encoded as ASCII Base-85. % 3 %  The format of the PackbitsEncodeImage method is:  % 5 %      unsigned int PackbitsEncodeImage(Image *image, @ %        const unsigned int number_pixels,unsigned char *pixels) % + %  A description of each parameter follows:  % M %    o status:  Method PackbitsEncodeImage returns True if all the pixels are 1 %      compressed without error, otherwise False.  % 7 %    o image: The address of a structure of type Image.  % G %    o number_pixels:  An unsigned integer that specifies the number of  %      pixels to compress. % L %    o pixels: The address of an unsigned array of characters containing the %      pixels to compress. %  %  */5 Export unsigned int PackbitsEncodeImage(Image *image, 9   const unsigned int number_pixels,unsigned char *pixels)  {    register int
     count,     i,     j;     unsigned char      *packbits;     /*+     Compress pixels with Packbits encoding.    */"   assert(image != (Image *) NULL);+   assert(pixels != (unsigned char *) NULL); G   packbits=(unsigned char *) AllocateMemory(128*sizeof(unsigned char)); )   if (packbits == (unsigned char *) NULL)      { D       MagickWarning(ResourceLimitWarning,"Memory allocation failed",         (char *) NULL);        return(False);     }    Ascii85Initialize();   i=number_pixels;   while (i != 0)   {      switch (i)     { 
       case 1:        {          i--;         Ascii85Encode(image,0); %         Ascii85Encode(image,*pixels);          break;       } 
       case 2:        { 
         i-=2;          Ascii85Encode(image,1); %         Ascii85Encode(image,*pixels); '         Ascii85Encode(image,pixels[1]);          break;       } 
       case 3:        { 
         i-=3; E         if ((*pixels == *(pixels+1)) && (*(pixels+1) == *(pixels+2)))            { +             Ascii85Encode(image,(256-3)+1); )             Ascii85Encode(image,*pixels);              break;           }          Ascii85Encode(image,2); %         Ascii85Encode(image,*pixels); '         Ascii85Encode(image,pixels[1]); '         Ascii85Encode(image,pixels[2]);          break;       }        default:       { E         if ((*pixels == *(pixels+1)) && (*(pixels+1) == *(pixels+2)))            {              /*               Packed run.              */             count=3;?             while ((count < i) && (*pixels == *(pixels+count))) 
             {                count++;               if (count >= 127)                  break;
             }              i-=count; /             Ascii85Encode(image,(256-count)+1); )             Ascii85Encode(image,*pixels);              pixels+=count;             break;           } 
         /*           Literal run.
         */         count=0;8         while ((*(pixels+count) != *(pixels+count+1)) ||8                (*(pixels+count+1) != *(pixels+count+2)))	         { *           packbits[count+1]=pixels[count];           count++;7           if ((count >= (int) (i-3)) || (count >= 127))              break;	         }          i-=count;          *packbits=count-1;"         for (j=0; j <= count; j++)+           Ascii85Encode(image,packbits[j]);          pixels+=count;         break;       }      }    } -   Ascii85Encode(image,128);  /* EOD marker */    Ascii85Flush(image);   FreeMemory(packbits);    return(True);  }    #if defined(HasZLIB) /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   Z L I B E n c o d e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method ZLIBEncodeImage compresses an image via ZLIB-coding specific to O %  Postscript Level II or Portable Document Format.  To ensure portability, the 2 %  binary ZLIB bytes are encoded as ASCII base-85. % / %  The format of the ZLIBEncodeImage method is:  % 1 %      unsigned int ZLIBEncodeImage(Image *image, F %        const unsigned long number_pixels,const unsigned int quality, %        unsigned char *pixels)  % + %  A description of each parameter follows:  % I %    o status:  Method ZLIBEncodeImage returns True if all the pixels are 1 %      compressed without error, otherwise False.  % J %    o file: The address of a structure of type FILE.  ZLIB encoded pixels  %      are written to this file. % G %    o number_pixels:  An unsigned integer that specifies the number of  %      pixels to compress. % . %    o quality: the compression level (0-100). % L %    o pixels: The address of an unsigned array of characters containing the %      pixels to compress. %  %  */1 Export unsigned int ZLIBEncodeImage(Image *image, ?   const unsigned long number_pixels,const unsigned int quality,    unsigned char *pixels) {    int      status;      register int     i;     unsigned char      *compressed_pixels;      unsigned long      compressed_packets;   
   z_stream     stream;   "   assert(image != (Image *) NULL);>   compressed_packets=(unsigned long) (1.001*number_pixels+12);%   compressed_pixels=(unsigned char *) =     AllocateMemory(compressed_packets*sizeof(unsigned char)); 2   if (compressed_pixels == (unsigned char *) NULL)     { D       MagickWarning(ResourceLimitWarning,"Memory allocation failed",         (char *) NULL);        return(False);     }    stream.next_in=pixels;    stream.avail_in=number_pixels;$   stream.next_out=compressed_pixels;&   stream.avail_out=compressed_packets;"   stream.zalloc=(alloc_func) NULL;    stream.zfree=(free_func) NULL;   stream.opaque=(voidpf) NULL;0   status=deflateInit(&stream,Min(quality/10,9));   if (status == Z_OK)      { '       status=deflate(&stream,Z_FINISH); !       if (status == Z_STREAM_END) #         status=deflateEnd(&stream); 
       else#         (void) deflateEnd(&stream); *       compressed_packets=stream.total_out;     } 
   if (status) P     MagickWarning(DelegateWarning,"Unable to Zip compress image",(char *) NULL);   else     {        Ascii85Initialize();2       for (i=0; i < (int) compressed_packets; i++)2         Ascii85Encode(image,compressed_pixels[i]);       Ascii85Flush(image);     }     FreeMemory(compressed_pixels);   return(!status); }  #else 1 Export unsigned int ZLIBEncodeImage(Image *image, ?   const unsigned long number_pixels,const unsigned int quality,    unsigned char *pixels) { "   assert(image != (Image *) NULL);G   MagickWarning(MissingDelegateWarning,"ZLIB library is not available",      image->filename);    return(False); }  #endif