 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %             DDDD   IIIII  SSSSS  PPPP   L       AAA   Y   Y                 % O %             D   D    I    SS     P   P  L      A   A   Y Y                  % O %             D   D    I     SSS   PPPP   L      AAAAA    Y                   % O %             D   D    I       SS  P      L      A   A    Y                   % O %             DDDD   IIIII  SSSSS  P      LLLLL  A   A    Y                   % O %                                                                             % O %                                                                             % O %            Methods to Interactively Display and Edit an Image               % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                              July 1992                                      % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*   Constant declaration.  */	 const int    RoiDelta = 8;    #if defined(HasX11)  #include "xwindows.h"  #include "display.h" /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X A n n o t a t e E d i t I m a g e                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ; %  Method XAnnotateEditImage annotates the image with text.  % 2 %  The format of the XAnnotateEditImage method is: % 8 %      unsigned int XAnnotateEditImage(Display *display,E %        XResourceInfo *resource_info,XWindows *windows,Image *image)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */8 static unsigned int XAnnotateEditImage(Display *display,>   XResourceInfo *resource_info,XWindows *windows,Image *image) {    static const char      *AnnotateMenu[]=     {        "Font Name",       "Font Color",        "Box Color",       "Rotate Text",
       "Help",        "Dismiss",       (char *) NULL      },     *TextMenu[]=     { 
       "Help",        "Apply",       (char *) NULL      };     static double      degrees = 0.0;     static const ModeType      AnnotateCommands[]=      {        AnnotateNameCommand,       AnnotateFontColorCommand, %       AnnotateBackgroundColorCommand,        AnnotateRotateCommand,       AnnotateHelpCommand,       AnnotateDismissCommand     },     TextCommands[]=      {        TextHelpCommand,       TextApplyCommand     };     static unsigned int      box_id = MaxNumberPens-2,      font_id = 0,     pen_id = 0,      transparent_box = True,      transparent_pen = False;     char      *ColorMenu[MaxNumberPens+1],     command[MaxTextExtent],      text[MaxTextExtent];     Cursor     cursor;      GC     annotate_context;      int      id,      pen_number,      x,     y;     KeySym     key_symbol;      register char      *p;      register int     i;     unsigned int     height,      status, 
     width;     unsigned long 
     state;     XAnnotateInfo      *annotate_info,      *previous_info;      XColor
     color;  
   XFontStruct      *font_info;      XEvent
     event,     text_event;      /*     Map Command widget.    */#   windows->command.name="Annotate";    windows->command.data=4;F   (void) XCommandWidget(display,windows,AnnotateMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask); 1   cursor=XCreateFontCursor(display,XC_left_side); 2   XDefineCursor(display,windows->image.id,cursor);   state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */L         FormatString(text," %+d%+d ",x+windows->image.x,y+windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */)     XScreenEvent(display,windows,&event); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */?         id=XCommandWidget(display,windows,AnnotateMenu,&event); 8         XDefineCursor(display,windows->image.id,cursor);         if (id < 0)            continue; %         switch (AnnotateCommands[id]) 	         { #           case AnnotateNameCommand:            {              char(               *FontMenu[MaxNumberFonts];               int                font_number;               /*)               Initialize menu selections.              */.             for (i=0; i < MaxNumberFonts; i++)6               FontMenu[i]=resource_info->font_name[i];4             FontMenu[MaxNumberFonts-2]="Browser...";5             FontMenu[MaxNumberFonts-1]=(char *) NULL;              /*6               Select a font name from the pop-up menu.             */E             font_number=XMenuWidget(display,windows,AnnotateMenu[id], 0               (const char **) FontMenu,command);              if (font_number < 0)               break;2             if (font_number == (MaxNumberFonts-2))               {                  static char 3                   font_name[MaxTextExtent]="fixed";                    /*4                   Select a font name from a browser.                 */@                 resource_info->font_name[font_number]=font_name;G                 XFontBrowserWidget(display,windows,"Select",font_name); '                 if (*font_name == '\0')                    break;               }              /*#               Initialize font info.              */             font_info=L               XLoadQueryFont(display,resource_info->font_name[font_number]);2             if (font_info == (XFontStruct *) NULL)               { E                 XNoticeWidget(display,windows,"Unable to load font:", 9                   resource_info->font_name[font_number]);                  break;               }               font_id=font_number;)             XFreeFont(display,font_info);              break;           } (           case AnnotateFontColorCommand:           {              /*)               Initialize menu selections.              */7             for (i=0; i < (int) (MaxNumberPens-2); i++) 8               ColorMenu[i]=resource_info->pen_colors[i];5             ColorMenu[MaxNumberPens-2]="transparent"; 4             ColorMenu[MaxNumberPens-1]="Browser...";3             ColorMenu[MaxNumberPens]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */D             pen_number=XMenuWidget(display,windows,AnnotateMenu[id],1               (const char **) ColorMenu,command);              if (pen_number < 0)                break;<             transparent_pen=pen_number == (MaxNumberPens-2);              if (transparent_pen)               break;0             if (pen_number == (MaxNumberPens-1))               {                  static char 5                   color_name[MaxTextExtent] = "gray";                    /*3                   Select a pen color from a dialog.                  */A                 resource_info->pen_colors[pen_number]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }              /*               Set pen color.             */C             (void) XParseColor(display,windows->map_info->colormap, <               resource_info->pen_colors[pen_number],&color);K             XBestPixel(display,windows->map_info->colormap,(XColor *) NULL, /               (unsigned int) MaxColors,&color); >             windows->pixel_info->pen_colors[pen_number]=color;             pen_id=pen_number;             break;           } .           case AnnotateBackgroundColorCommand:           {              /*)               Initialize menu selections.              */7             for (i=0; i < (int) (MaxNumberPens-2); i++) 8               ColorMenu[i]=resource_info->pen_colors[i];5             ColorMenu[MaxNumberPens-2]="transparent"; 4             ColorMenu[MaxNumberPens-1]="Browser...";3             ColorMenu[MaxNumberPens]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */D             pen_number=XMenuWidget(display,windows,AnnotateMenu[id],1               (const char **) ColorMenu,command);              if (pen_number < 0)                break;<             transparent_box=pen_number == (MaxNumberPens-2);              if (transparent_box)               break;0             if (pen_number == (MaxNumberPens-1))               {                  static char 5                   color_name[MaxTextExtent] = "gray";                    /*3                   Select a pen color from a dialog.                  */A                 resource_info->pen_colors[pen_number]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }              /*               Set pen color.             */C             (void) XParseColor(display,windows->map_info->colormap, <               resource_info->pen_colors[pen_number],&color);K             XBestPixel(display,windows->map_info->colormap,(XColor *) NULL, /               (unsigned int) MaxColors,&color); >             windows->pixel_info->pen_colors[pen_number]=color;             box_id=pen_number;             break;           } %           case AnnotateRotateCommand:            {              int                entry;               static char ,               angle[MaxTextExtent] = "30.0";               static const char                *RotateMenu[]=               {                  "-90",                 "-45",                 "-30",                 "0",                 "30",                  "45",                  "90",                  "180",                 (char *) NULL,                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */&             RotateMenu[8]="Dialog...";J             entry=XMenuWidget(display,windows,AnnotateMenu[id],RotateMenu,               command);              if (entry < 0)               break;             if (entry != 8)                { 0                 degrees=atof(RotateMenu[entry]);                 break;               } N             (void) XDialogWidget(display,windows,"OK","Enter rotation angle:",               angle);              if (*angle == '\0')                break;              degrees=atof(angle);             break;           } #           case AnnotateHelpCommand:            { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);             break;           } &           case AnnotateDismissCommand:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { ,         if (event.xbutton.button != Button1)           break;6         if (event.xbutton.window != windows->image.id)           break;
         /*'           Change to text entering mode. 
         */         x=event.xbutton.x;         y=event.xbutton.y;         state|=ExitState;          break;       }        case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       { 3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*E           Map and unmap Info widget as cursor crosses its boundaries. 
         */         x=event.xmotion.x;         y=event.xmotion.y;!         if (windows->info.mapped)            { D             if ((x < (int) (windows->info.x+windows->info.width)) &&C                 (y < (int) (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          elseB           if ((x > (int) (windows->info.x+windows->info.width)) ||A               (y > (int) (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);          break;       }        default:         break;     } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (state & EscapeState)     return(True);    /*0     Set font info and check boundary conditions.   */F   font_info=XLoadQueryFont(display,resource_info->font_name[font_id]);(   if (font_info == (XFontStruct *) NULL)     { ;       XNoticeWidget(display,windows,"Unable to load font:", +         resource_info->font_name[font_id]); #       font_info=windows->font_info;      } D   if ((x+font_info->max_bounds.width) >= (int) windows->image.width)7     x=windows->image.width-font_info->max_bounds.width; 7   if (y < (int) (font_info->ascent+font_info->descent)) +     y=font_info->ascent+font_info->descent; C   if ((font_info->max_bounds.width > (int) windows->image.width) || N       ((font_info->ascent+font_info->descent) >= (int) windows->image.height))     return(False);   /*"     Initialize annotate structure.   */H   annotate_info=(XAnnotateInfo *) AllocateMemory(sizeof(XAnnotateInfo));.   if (annotate_info == (XAnnotateInfo *) NULL)     return(False);"   XGetAnnotateInfo(annotate_info);   annotate_info->x=x;    annotate_info->y=y; +   if (!transparent_box && !transparent_pen) )     annotate_info->stencil=OpaqueStencil;    else     if (!transparent_box) /       annotate_info->stencil=BackgroundStencil;      else/       annotate_info->stencil=ForegroundStencil; =   annotate_info->height=font_info->ascent+font_info->descent; !   annotate_info->degrees=degrees; %   annotate_info->font_info=font_info; .   annotate_info->text=(char *) AllocateMemory(N     (windows->image.width/Max(font_info->min_bounds.width,1)+2)*sizeof(char));+   if (annotate_info->text == (char *) NULL)      return(False);   /**     Create cursor and set graphic context.   */.   cursor=XCreateFontCursor(display,XC_pencil);2   XDefineCursor(display,windows->image.id,cursor);3   annotate_context=windows->image.annotate_context; 4   XSetFont(display,annotate_context,font_info->fid);*   XSetBackground(display,annotate_context,3     windows->pixel_info->pen_colors[box_id].pixel); *   XSetForeground(display,annotate_context,3     windows->pixel_info->pen_colors[pen_id].pixel);    /*)     Begin annotating the image with text.    */   windows->command.name="Text";    windows->command.data=0;B   (void) XCommandWidget(display,windows,TextMenu,(XEvent *) NULL);   state=DefaultState; D   XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);F   text_event.xexpose.width=(unsigned int) font_info->max_bounds.width;9   text_event.xexpose.height=font_info->max_bounds.ascent+ "     font_info->max_bounds.descent;   p=annotate_info->text;   do   {      /*       Display text cursor.     */     *p='\0';F     XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);     /*       Wait for next event.     */)     XScreenEvent(display,windows,&event); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */0         XSetBackground(display,annotate_context,7           windows->pixel_info->background_color.pixel); 0         XSetForeground(display,annotate_context,7           windows->pixel_info->foreground_color.pixel); ?         id=XCommandWidget(display,windows,AnnotateMenu,&event); 0         XSetBackground(display,annotate_context,9           windows->pixel_info->pen_colors[box_id].pixel); 0         XSetForeground(display,annotate_context,9           windows->pixel_info->pen_colors[pen_id].pixel);          if (id < 0)            continue; !         switch (TextCommands[id]) 	         {            case TextHelpCommand:            { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);<             XDefineCursor(display,windows->image.id,cursor);             break;           }             case TextApplyCommand:           {              /*"               Finished annotating.             */J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               Extent(annotate_info->text)); @             XRefreshWindow(display,&windows->image,&text_event);             state|=ExitState;              break;           }            default:             break;	         }          continue;        }      /*       Erase text cursor.     */     text_event.xexpose.x=x; 8     text_event.xexpose.y=y-font_info->max_bounds.ascent;@     XClearArea(display,windows->image.id,x,text_event.xexpose.y,@       text_event.xexpose.width,text_event.xexpose.height,False);8     XRefreshWindow(display,&windows->image,&text_event);     switch (event.type)      {        case ButtonPress:        { 6         if (event.xbutton.window != windows->image.id)           break;,         if (event.xbutton.button == Button2)           {              /*(               Request primary selection.             */E             XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, -               windows->image.id,CurrentTime);              break;           }          break;       }        case Expose:       { %         if (event.xexpose.count == 0)            {              XAnnotateInfo                *text_info;                /*#               Refresh Image window.              */D             XRefreshWindow(display,&windows->image,(XEvent *) NULL);$             text_info=annotate_info;7             while (text_info != (XAnnotateInfo *) NULL) 
             { >               if (annotate_info->stencil == ForegroundStencil)G                 XDrawString(display,windows->image.id,annotate_context, <                   text_info->x,text_info->y,text_info->text,+                   Extent(text_info->text));                elseL                 XDrawImageString(display,windows->image.id,annotate_context,<                   text_info->x,text_info->y,text_info->text,+                   Extent(text_info->text)); ,               text_info=text_info->previous;
             } N             XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);           }          break;       }        case KeyPress:       {          int            length;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; N         if ((event.xkey.state & ControlMask) || (event.xkey.state & Mod1Mask))           state|=ModifierState; "         if (state & ModifierState)           switch (key_symbol)            {              case XK_u:             case XK_U:
             { '               key_symbol=DeleteCommand;                break;
             }              default:               break;           }          switch (key_symbol) 	         {            case XK_BackSpace:           {              /*"               Erase one character.             */)             if (p == annotate_info->text)                { F                 if (annotate_info->previous == (XAnnotateInfo *) NULL)                   break;                 else                   {                      /*=                       Go to end of the previous line of text.                      */:                     annotate_info=annotate_info->previous;*                     p=annotate_info->text;<                     x=annotate_info->x+annotate_info->width;'                     y=annotate_info->y; 2                     if (annotate_info->width != 0)5                       p+=Extent(annotate_info->text);                      break;                   }                }              p--;)             x-=XTextWidth(font_info,p,1); #             text_event.xexpose.x=x; @             text_event.xexpose.y=y-font_info->max_bounds.ascent;@             XRefreshWindow(display,&windows->image,&text_event);             break;           }            case XK_bracketleft:           { !             key_symbol=XK_Escape;              break;           }            case DeleteCommand:            {              /*,               Erase the entire line of text.             */,             while (p != annotate_info->text)
             {                p--;+               x-=XTextWidth(font_info,p,1); %               text_event.xexpose.x=x; B               XRefreshWindow(display,&windows->image,&text_event);
             }              break;           }            case XK_Escape:            case XK_F20:           {              /*"               Finished annotating.             */J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               Extent(annotate_info->text)); @             XRefreshWindow(display,&windows->image,&text_event);             state|=ExitState;              break;           }            default:           {              /*:               Draw a single character on the Image window.             */&             if (state & ModifierState)               break;!             if (*command == '\0')                break;             *p=(*command);<             if (annotate_info->stencil == ForegroundStencil)N               XDrawString(display,windows->image.id,annotate_context,x,y,p,1);             elseN               XDrawImageString(display,windows->image.id,annotate_context,x,y,                 p,1); )             x+=XTextWidth(font_info,p,1);              p++;M             if ((x+font_info->max_bounds.width) < (int) windows->image.width)                break;           }            case XK_Return:            case XK_KP_Enter:            {              /*/               Advance to the next line of text.              */             *p='\0';J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               Extent(annotate_info->text)); >             if (annotate_info->next != (XAnnotateInfo *) NULL)               {                  /*.                   Line of text already exists.                 */2                 annotate_info=annotate_info->next;#                 x=annotate_info->x; #                 y=annotate_info->y; &                 p=annotate_info->text;                 break;               } 1             annotate_info->next=(XAnnotateInfo *) 4               AllocateMemory(sizeof(XAnnotateInfo));>             if (annotate_info->next == (XAnnotateInfo *) NULL)               return(False);2             *annotate_info->next=(*annotate_info);8             annotate_info->next->previous=annotate_info;.             annotate_info=annotate_info->next;N             annotate_info->text=(char *) AllocateMemory((windows->image.width/B               Max(font_info->min_bounds.width,1)+2)*sizeof(char));5             if (annotate_info->text == (char *) NULL)                return(False);4             annotate_info->y+=annotate_info->height;?             if (annotate_info->y > (int) windows->image.height) 5               annotate_info->y=annotate_info->height; 7             annotate_info->next=(XAnnotateInfo *) NULL;              x=annotate_info->x;              y=annotate_info->y; "             p=annotate_info->text;             break;           } 	         }          break;       }        case KeyRelease:       { 
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);           state&=(~ModifierState);         break;       }        case SelectionNotify:        {          Atom           type;            int            format;            unsigned char            *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor, L           event.xselection.property,0L,MaxTextExtent-1,True,XA_STRING,&type,(           &format,&length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;
         /*7           Annotate Image window with primary selection. 
         */(         for (i=0; i < (int) length; i++)	         {            if (data[i] != '\n')
             {                /*<                 Draw a single character on the Image window.               */               *p=data[i]; N               XDrawString(display,windows->image.id,annotate_context,x,y,p,1);+               x+=XTextWidth(font_info,p,1);                p++;O               if ((x+font_info->max_bounds.width) < (int) windows->image.width)                  continue; 
             }            /*-             Advance to the next line of text.            */           *p='\0';H           annotate_info->width=XTextWidth(font_info,annotate_info->text,)             Extent(annotate_info->text)); <           if (annotate_info->next != (XAnnotateInfo *) NULL)
             {                /*,                 Line of text already exists.               */0               annotate_info=annotate_info->next;!               x=annotate_info->x; !               y=annotate_info->y; $               p=annotate_info->text;               continue; 
             } /           annotate_info->next=(XAnnotateInfo *) 2             AllocateMemory(sizeof(XAnnotateInfo));<           if (annotate_info->next == (XAnnotateInfo *) NULL)             return(False);0           *annotate_info->next=(*annotate_info);6           annotate_info->next->previous=annotate_info;,           annotate_info=annotate_info->next;L           annotate_info->text=(char *) AllocateMemory((windows->image.width/@             Max(font_info->min_bounds.width,1)+2)*sizeof(char));3           if (annotate_info->text == (char *) NULL)              return(False);2           annotate_info->y+=annotate_info->height;=           if (annotate_info->y > (int) windows->image.height) 3             annotate_info->y=annotate_info->height; 5           annotate_info->next=(XAnnotateInfo *) NULL;            x=annotate_info->x;            y=annotate_info->y;             p=annotate_info->text;	         }          XFree((void *) data);          break;       }        default:         break;     } !   } while (!(state & ExitState));    XFreeCursor(display,cursor);   /*2     Annotation is relative to image configuration.   */   width=image->columns;    height=image->rows;    x=0;   y=0;4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);    /*     Initialize annotated image.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);1   while (annotate_info != (XAnnotateInfo *) NULL)    { "     if (annotate_info->width == 0)       { 
         /*>           No text on this line--  go to the next line of text.
         */.         previous_info=annotate_info->previous;(         FreeMemory(annotate_info->text);"         FreeMemory(annotate_info);$         annotate_info=previous_info;         continue;        }      /*2       Determine pixel index for box and pen color.     */K     windows->pixel_info->box_color=windows->pixel_info->pen_colors[box_id]; )     if (windows->pixel_info->colors != 0) ;       for (i=0; i < (int) windows->pixel_info->colors; i++) -         if (windows->pixel_info->pixels[i] == :             windows->pixel_info->pen_colors[box_id].pixel)           { >             windows->pixel_info->box_index=(unsigned short) i;             break;           } K     windows->pixel_info->pen_color=windows->pixel_info->pen_colors[pen_id]; )     if (windows->pixel_info->colors != 0) ;       for (i=0; i < (int) windows->pixel_info->colors; i++) -         if (windows->pixel_info->pixels[i] == :             windows->pixel_info->pen_colors[pen_id].pixel)           { >             windows->pixel_info->pen_index=(unsigned short) i;             break;           }      /**       Define the annotate geometry string.     */     annotate_info->x= M       width*(annotate_info->x+windows->image.x)/windows->image.ximage->width; @     annotate_info->y=height*(annotate_info->y-font_info->ascent+6       windows->image.y)/windows->image.ximage->height;7     FormatString(annotate_info->geometry,"%ux%u%+d%+d", >       width*annotate_info->width/windows->image.ximage->width,A       height*annotate_info->height/windows->image.ximage->height, -       annotate_info->x+x,annotate_info->y+y);      /*       Annotate image with text.      */K     status=XAnnotateImage(display,windows->pixel_info,annotate_info,image);      if (status == 0)       return(False);     /*       Free up memory.      */*     previous_info=annotate_info->previous;$     FreeMemory(annotate_info->text);     FreeMemory(annotate_info);      annotate_info=previous_info;   } *   XSetForeground(display,annotate_context,1     windows->pixel_info->foreground_color.pixel); *   XSetBackground(display,annotate_context,1     windows->pixel_info->background_color.pixel); =   XSetFont(display,annotate_context,windows->font_info->fid); )   XSetCursorState(display,windows,False);    XFreeFont(display,font_info);    /*     Update image configuration.    */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X B a c k g r o u n d I m a g e                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method XBackgroundImage displays the image in the background of a window. % 0 %  The format of the XBackgroundImage method is: % 6 %      unsigned int XBackgroundImage(Display *display,F %        XResourceInfo *resource_info,XWindows *windows,Image **image) % + %  A description of each parameter follows:  % B %    o status: Method XBackgroundImage return True if the image isJ %      printed.  False is returned is there is a memory shortage or if the %      image fails to print. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */6 static unsigned int XBackgroundImage(Display *display,?   XResourceInfo *resource_info,XWindows *windows,Image **image)  { = #define BackgroundImageText  "  Backgrounding the image...  "   
   static char &     window_id[MaxTextExtent] = "root";     XResourceInfo      background_resources;      unsigned int     status;      /*     Put image in background.   */4   status=XDialogWidget(display,windows,"Background",H     "Enter window id (id 0x00 selects window with pointer):",window_id);   if (*window_id == '\0')      return(False);J   (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);3   XInfoWidget(display,windows,BackgroundImageText); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);(   background_resources=(*resource_info);+   background_resources.window_id=window_id; '   background_resources.backdrop=status; G   status=XDisplayBackgroundImage(display,&background_resources,*image); 
   if (status) C     XClientMessage(display,windows->image.id,windows->im_protocols, -       windows->im_retain_colors,CurrentTime); )   XSetCursorState(display,windows,False); I   (void) XMagickCommand(display,resource_info,windows,UndoCommand,image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X C h o p I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ' %  Method XChopImage chops the X image.  % * %  The format of the XChopImage method is: % K %    unsigned int XChopImage(Display *display,XResourceInfo *resource_info, ' %      XWindows *windows,Image **image)  % + %  A description of each parameter follows:  % < %    o status: Method XChopImage return True if the image isF %      cut.  False is returned is there is a memory shortage or if the %      image fails to cut. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */M static unsigned int XChopImage(Display *display,XResourceInfo *resource_info, "   XWindows *windows,Image **image) {    static const char      *ChopMenu[]=     {        "Direction",
       "Help",        "Dismiss",       (char *) NULL      };     static ModeType &     direction = HorizontalChopCommand;     static const ModeType      ChopCommands[]=      {        ChopDirectionCommand,        ChopHelpCommand,       ChopDismissCommand     },     DirectionCommands[]=     {        HorizontalChopCommand,       VerticalChopCommand      };     char     text[MaxTextExtent];     double     scale_factor;      Image      *chop_image;     int      id,      x,     y;     RectangleInfo      chop_info;     unsigned int
     distance,      height, 
     width;     unsigned long 
     state;     XEvent
     event;  
   XSegment     segment_info;      /*     Map Command widget.    */   windows->command.name="Chop";    windows->command.data=1;B   (void) XCommandWidget(display,windows,ChopMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */L         FormatString(text," %+d%+d ",x+windows->image.x,y+windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */)     XScreenEvent(display,windows,&event); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */;         id=XCommandWidget(display,windows,ChopMenu,&event);          if (id < 0)            continue; !         switch (ChopCommands[id]) 	         { $           case ChopDirectionCommand:           {              char%               command[MaxTextExtent];                static const char                *Directions[]=               {                  "horizontal",                  "vertical",                  (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */             id= K               XMenuWidget(display,windows,ChopMenu[id],Directions,command);              if (id >= 0).               direction=DirectionCommands[id];             break;           }            case ChopHelpCommand:            { @             XTextViewWidget(display,resource_info,windows,False,<               "Help Viewer - Image Chopping",ImageChopHelp);             break;           } "           case ChopDismissCommand:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { ,         if (event.xbutton.button != Button1)           break;6         if (event.xbutton.window != windows->image.id)           break;
         /*=           User has committed to start point of chopping line. 
         */(         segment_info.x1=event.xbutton.x;(         segment_info.x2=event.xbutton.x;(         segment_info.y1=event.xbutton.y;(         segment_info.y2=event.xbutton.y;         state|=ExitState;          break;       }        case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       {          char!           command[MaxTextExtent];            KeySym           key_symbol;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */?         (void) XLookupString((XKeyEvent *) &event.xkey,command, ?           sizeof(command),&key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,<               "Help Viewer - Image Chopping",ImageChopHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */         x=event.xmotion.x;         y=event.xmotion.y;!         if (windows->info.mapped)            { D             if ((x < (int) (windows->info.x+windows->info.width)) &&C                 (y < (int) (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          elseB           if ((x > (int) (windows->info.x+windows->info.width)) ||A               (y > (int) (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);        }      } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (state & EscapeState)     return(True);    /*B     Draw line as pointer moves until the mouse button is released.   */   chop_info.width=0;   chop_info.height=0;    chop_info.x=0;   chop_info.y=0;
   distance=0; B   XSetFunction(display,windows->image.highlight_context,GXinvert);   state=DefaultState;    do   {      if (distance > 9)        { 
         /*.           Display info and draw chopping line.
         */"         if (!windows->info.mapped)/           XMapWindow(display,windows->info.id); J         FormatString(text," %ux%u%+d%+d",chop_info.width,chop_info.height,#           chop_info.x,chop_info.y); *         XInfoWidget(display,windows,text);1         XHighlightLine(display,windows->image.id, :           windows->image.highlight_context,&segment_info);       }      else       if (windows->info.mapped) G         XWithdrawWindow(display,windows->info.id,windows->info.screen);      /*       Wait for next event.     */)     XScreenEvent(display,windows,&event);      if (distance > 9) /       XHighlightLine(display,windows->image.id, 8         windows->image.highlight_context,&segment_info);     switch (event.type)      {        case ButtonPress:        { (         segment_info.x2=event.xmotion.x;(         segment_info.y2=event.xmotion.y;         break;       }        case ButtonRelease:        { 
         /*.           User has committed to chopping line.
         */(         segment_info.x2=event.xbutton.x;(         segment_info.y2=event.xbutton.y;         state|=ExitState;          break;       }        case Expose:         break;       case MotionNotify:       { (         segment_info.x2=event.xmotion.x;(         segment_info.y2=event.xmotion.y;       }        default:         break;     }      /*        Check boundary conditions.     */     if (segment_info.x2 < 0)       segment_info.x2=0;     else9       if (segment_info.x2 > windows->image.ximage->width) 5         segment_info.x2=windows->image.ximage->width;      if (segment_info.y2 < 0)       segment_info.y2=0;     else:       if (segment_info.y2 > windows->image.ximage->height)6         segment_info.y2=windows->image.ximage->height;
     distance= L       ((segment_info.x2-segment_info.x1)*(segment_info.x2-segment_info.x1))+L       ((segment_info.y2-segment_info.y1)*(segment_info.y2-segment_info.y1));     /*        Compute chopping geometry.     */+     if (direction == HorizontalChopCommand)        { :         chop_info.width=segment_info.x2-segment_info.x1+1;5         chop_info.x=windows->image.x+segment_info.x1;          chop_info.height=0;          chop_info.y=0;4         if (segment_info.x1 > (int) segment_info.x2)           { >             chop_info.width=segment_info.x1-segment_info.x2+1;9             chop_info.x=windows->image.x+segment_info.x2;            }        }      else       {          chop_info.width=0;;         chop_info.height=segment_info.y2-segment_info.y1+1;          chop_info.x=0;5         chop_info.y=windows->image.y+segment_info.y1; .         if (segment_info.y1 > segment_info.y2)           { ?             chop_info.height=segment_info.y1-segment_info.y2+1; 9             chop_info.y=windows->image.y+segment_info.y2;            }        } !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (distance <= 9)     return(True);    /*6     Image chopping is relative to image configuration.   */J   (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);&   windows->image.window_changes.width=1     windows->image.ximage->width-chop_info.width; '   windows->image.window_changes.height= 3     windows->image.ximage->height-chop_info.height;    width=(*image)->columns;   height=(*image)->rows;   x=0;   y=0;4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=(double) width/windows->image.ximage->width;    chop_info.x+=x; '   chop_info.x=scale_factor*chop_info.x; /   chop_info.width=scale_factor*chop_info.width; =   scale_factor=(double) height/windows->image.ximage->height;    chop_info.y+=y; '   chop_info.y=scale_factor*chop_info.y; 1   chop_info.height=scale_factor*chop_info.height;    /*     Chop image.    */*   chop_image=ChopImage(*image,&chop_info);)   XSetCursorState(display,windows,False); #   if (chop_image == (Image *) NULL)      return(False);   DestroyImage(*image);    *image=chop_image;   /*     Update image configuration.    */@   XConfigureImageColormap(display,resource_info,windows,*image);?   (void) XConfigureImage(display,resource_info,windows,*image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X C o l o r E d i t I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Method XColorEditImage allows the user to interactively change K %  the color of one pixel for a DirectColor image or one colormap entry for  %  a PseudoClass image.  % / %  The format of the XColorEditImage method is:  % 5 %      unsigned int XColorEditImage(Display *display, F %        XResourceInfo *resource_info,XWindows *windows,Image **image) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */5 static unsigned int XColorEditImage(Display *display, ?   XResourceInfo *resource_info,XWindows *windows,Image **image)  {    static const char      *ColorEditMenu[]=      {        "Method",        "Pixel Color",       "Border Color", 
       "Fuzz", 
       "Undo", 
       "Help",        "Dismiss",       (char *) NULL      };     static const ModeType      ColorEditCommands[]=     {        ColorEditMethodCommand,        ColorEditColorCommand,       ColorEditBorderCommand,        ColorEditFuzzCommand,        ColorEditUndoCommand,        ColorEditHelpCommand,        ColorEditDismissCommand      };     static PaintMethod     method = PointMethod;      static unsigned int      pen_id = 0;      static XColor %     border_color = { 0, 0, 0, 0, 0 };      char     command[MaxTextExtent],      text[MaxTextExtent];     Cursor     cursor;      int 
     entry,     id,      x,
     x_offset,      y,
     y_offset;      register int     i;     register PixelPacket     *p,      *q;      unsigned int     height, 
     width;     unsigned long 
     state;     XColor
     color;     XEvent
     event;     /*     Map Command widget.    */%   windows->command.name="Color Edit";    windows->command.data=4;G   (void) XCommandWidget(display,windows,ColorEditMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*     Make cursor.   */K   cursor=XMakeCursor(display,windows->image.id,windows->map_info->colormap, E     resource_info->background_color,resource_info->foreground_color); 2   XDefineCursor(display,windows->image.id,cursor);   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */L         FormatString(text," %+d%+d ",x+windows->image.x,y+windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */)     XScreenEvent(display,windows,&event); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */@         id=XCommandWidget(display,windows,ColorEditMenu,&event);         if (id < 0)            { <             XDefineCursor(display,windows->image.id,cursor);             continue;            } &         switch (ColorEditCommands[id])	         { &           case ColorEditMethodCommand:           {              static const char                *MethodMenu[]=               {                  "point",                 "replace",                 "floodfill",                 "filltoborder",                  "reset",                 (char *) NULL,               };               /*3               Select a method from the pop-up menu.              */             entry=P               XMenuWidget(display,windows,ColorEditMenu[id],MethodMenu,command);             if (entry >= 0) )               method=(PaintMethod) entry;              break;           } %           case ColorEditColorCommand:            {              char(               *ColorMenu[MaxNumberPens];               int                pen_number;                /*)               Initialize menu selections.              */7             for (i=0; i < (int) (MaxNumberPens-2); i++) 8               ColorMenu[i]=resource_info->pen_colors[i];4             ColorMenu[MaxNumberPens-2]="Browser...";5             ColorMenu[MaxNumberPens-1]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */E             pen_number=XMenuWidget(display,windows,ColorEditMenu[id], 1               (const char **) ColorMenu,command);              if (pen_number < 0)                break;0             if (pen_number == (MaxNumberPens-2))               {                  static char 5                   color_name[MaxTextExtent] = "gray";                    /*3                   Select a pen color from a dialog.                  */A                 resource_info->pen_colors[pen_number]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }              /*               Set pen color.             */C             (void) XParseColor(display,windows->map_info->colormap, <               resource_info->pen_colors[pen_number],&color);K             XBestPixel(display,windows->map_info->colormap,(XColor *) NULL, /               (unsigned int) MaxColors,&color); >             windows->pixel_info->pen_colors[pen_number]=color;             pen_id=pen_number;             break;           } &           case ColorEditBorderCommand:           {              char(               *ColorMenu[MaxNumberPens];               int                pen_number;                /*)               Initialize menu selections.              */7             for (i=0; i < (int) (MaxNumberPens-2); i++) 8               ColorMenu[i]=resource_info->pen_colors[i];4             ColorMenu[MaxNumberPens-2]="Browser...";5             ColorMenu[MaxNumberPens-1]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */E             pen_number=XMenuWidget(display,windows,ColorEditMenu[id], 1               (const char **) ColorMenu,command);              if (pen_number < 0)                break;0             if (pen_number == (MaxNumberPens-2))               {                  static char 5                   color_name[MaxTextExtent] = "gray";                    /*3                   Select a pen color from a dialog.                  */A                 resource_info->pen_colors[pen_number]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }              /*               Set border color.              */C             (void) XParseColor(display,windows->map_info->colormap, C               resource_info->pen_colors[pen_number],&border_color);              break;           } $           case ColorEditFuzzCommand:           {              static char "               fuzz[MaxTextExtent];               static const char                *FuzzMenu[]=               {                  "0",                 "2",                 "4",                 "8",                 "16",                  (char *) NULL,                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */$             FuzzMenu[5]="Dialog...";I             entry=XMenuWidget(display,windows,ColorEditMenu[id],FuzzMenu,                command);              if (entry < 0)               break;             if (entry != 5)                { 5                 (*image)->fuzz=atoi(FuzzMenu[entry]);                  break;               } 5             (void) sprintf(fuzz,"%d",(*image)->fuzz); K             (void) XDialogWidget(display,windows,"Ok","Enter fuzz factor:",                fuzz);             if (*fuzz == '\0')               break;&             (*image)->fuzz=atoi(fuzz);             break;           } $           case ColorEditUndoCommand:           { L             (void) XMagickCommand(display,resource_info,windows,UndoCommand,               image);              break;           } $           case ColorEditHelpCommand:           default:           { @             XTextViewWidget(display,resource_info,windows,False,C               "Help Viewer - Image Annotation",ImageColorEditHelp);              break;           } '           case ColorEditDismissCommand:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           } 	         } 8         XDefineCursor(display,windows->image.id,cursor);         continue;        }      switch (event.type)      {        case ButtonPress:        { ,         if (event.xbutton.button != Button1)           break;:         if ((event.xbutton.window != windows->image.id) &&:             (event.xbutton.window != windows->magnify.id))           break;
         /*           Exit loop.
         */         x=event.xbutton.x;         y=event.xbutton.y;<         (void) XMagickCommand(display,resource_info,windows,)           SaveToUndoBufferCommand,image); (         state|=UpdateConfigurationState;         break;       }        case ButtonRelease:        { ,         if (event.xbutton.button != Button1)           break;:         if ((event.xbutton.window != windows->image.id) &&:             (event.xbutton.window != windows->magnify.id))           break;
         /*&           Update colormap information.
         */         x=event.xbutton.x;         y=event.xbutton.y;F         XConfigureImageColormap(display,resource_info,windows,*image);E         (void) XConfigureImage(display,resource_info,windows,*image); *         XInfoWidget(display,windows,text);8         XDefineCursor(display,windows->image.id,cursor);+         state&=(~UpdateConfigurationState);          break;       }        case Expose:         break;       case KeyPress:       {          KeySym           key_symbol;   5         if (event.xkey.window == windows->magnify.id)            {              Window               window;   '             window=windows->magnify.id; J             while (XCheckWindowEvent(display,window,KeyPressMask,&event));           } 3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,C               "Help Viewer - Image Annotation",ImageColorEditHelp);              break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*E           Map and unmap Info widget as cursor crosses its boundaries. 
         */         x=event.xmotion.x;         y=event.xmotion.y;!         if (windows->info.mapped)            { D             if ((x < (int) (windows->info.x+windows->info.width)) &&C                 (y < (int) (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          elseB           if ((x > (int) (windows->info.x+windows->info.width)) ||A               (y > (int) (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);          break;       }        default:         break;     } 1     if (event.xany.window == windows->magnify.id)        { .         x=windows->magnify.x-windows->image.x;.         y=windows->magnify.y-windows->image.y;       }      x_offset=x;      y_offset=y; )     if (state & UpdateConfigurationState)        {          int            x,           y;  
         /*8           Pixel edit is relative to image configuration.
         */I         XClearArea(display,windows->image.id,x_offset,y_offset,1,1,True); 6         color=windows->pixel_info->pen_colors[pen_id];G         XPutPixel(windows->image.ximage,x_offset,y_offset,color.pixel);           width=(*image)->columns;         height=(*image)->rows;         x=0;         y=0;:         if (windows->image.crop_geometry != (char *) NULL)C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,              &width,&height);         x_offset= K           width*(windows->image.x+x_offset)/windows->image.ximage->width+x;          y_offset= M           height*(windows->image.y+y_offset)/windows->image.ximage->height+y; -         if ((x_offset < 0) || (y_offset < 0))            continue; 4         if ((x_offset >= (int) (*image)->columns) ||/             (y_offset >= (int) (*image)->rows))            continue;          switch (method) 	         {            case PointMethod:            default:           {              /*=               Update color information using point algorithm.              */(             (*image)->class=DirectClass;:             p=GetPixelCache(*image,x_offset,y_offset,1,1);*             if (p == (PixelPacket *) NULL)               break;)             p->red=XDownScale(color.red); -             p->green=XDownScale(color.green); +             p->blue=XDownScale(color.blue); *             (void) SyncPixelCache(*image);             break;           }            case ReplaceMethod:            {              PixelPacket                target;                /*?               Update color information using replace algorithm.              */:             p=GetPixelCache(*image,x_offset,y_offset,1,1);*             if (p == (PixelPacket *) NULL)               break;             target=(*p);/             if ((*image)->class == DirectClass)                { 8                 for (y=0; y < (int) (*image)->rows; y++)                 { B                   q=GetPixelCache(*image,0,y,(*image)->columns,1);0                   if (q == (PixelPacket *) NULL)                     break;=                   for (x=0; x < (int) (*image)->columns; x++)                    { =                     if (ColorMatch(*q,target,(*image)->fuzz))                        { 5                         q->red=XDownScale(color.red); 9                         q->green=XDownScale(color.green); 7                         q->blue=XDownScale(color.blue);                        }                      q++;                   } .                   if (!SyncPixelCache(*image))                     break;                 }                }              else               { :                 for (i=0; i < (int) (*image)->colors; i++)N                   if (ColorMatch((*image)->colormap[i],target,(*image)->fuzz))                     { F                       (*image)->colormap[i].red=XDownScale(color.red);J                       (*image)->colormap[i].green=XDownScale(color.green);H                       (*image)->colormap[i].blue=XDownScale(color.blue);                     } "                 SyncImage(*image);               }              break;           }            case FloodfillMethod: "           case FillToBorderMethod:           {              AnnotateInfo               *annotate_info;                ImageInfo                *image_info;               PixelPacket                target;                /*A               Update color information using floodfill algorithm.              */<             if (GetPixelCache(*image,x_offset,y_offset,1,1)))               target=(*(*image)->pixels); -             if (method == FillToBorderMethod)                { 8                 target.red=XDownScale(border_color.red);<                 target.green=XDownScale(border_color.green);:                 target.blue=XDownScale(border_color.blue);               } A             image_info=CloneImageInfo(resource_info->image_info); 0             (void) CloneString(&image_info->pen,1               resource_info->pen_colors[pen_id]); N             annotate_info=CloneAnnotateInfo(image_info,(AnnotateInfo *) NULL);L             ColorFloodfillImage(*image,&target,annotate_info->tile,x_offset,               y_offset,method); /             DestroyAnnotateInfo(annotate_info); )             DestroyImageInfo(image_info);              break;           }            case ResetMethod:            {              /*=               Update color information using reset algorithm.              */(             (*image)->class=DirectClass;4             for (y=0; y < (int) (*image)->rows; y++)
             { >               q=SetPixelCache(*image,0,y,(*image)->columns,1);,               if (q == (PixelPacket *) NULL)                 break;9               for (x=0; x < (int) (*image)->columns; x++)                { -                 q->red=XDownScale(color.red); 1                 q->green=XDownScale(color.green); /                 q->blue=XDownScale(color.blue);                  q++;               } *               if (!SyncPixelCache(*image))                 break;
             }              break;           } 	         } +         state&=(~UpdateConfigurationState);        } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); )   XSetCursorState(display,windows,False);    XFreeCursor(display,cursor);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X C o m p o s i t e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method XCompositeImage requests an image name from the user, reads M %  the image and composites it with the X window image at a location the user  %  chooses with the pointer. % / %  The format of the XCompositeImage method is:  % 5 %      unsigned int XCompositeImage(Display *display, E %        XResourceInfo *resource_info,XWindows *windows,Image *image)  % + %  A description of each parameter follows:  % B %    o status: Method XCompositeImage returns True if the image isM %      composited.  False is returned is there is a memory shortage or if the $ %      image fails to be composited. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */5 static unsigned int XCompositeImage(Display *display, >   XResourceInfo *resource_info,XWindows *windows,Image *image) { 
   static char 3     displacement_geometry[MaxTextExtent] = "30x30", #     filename[MaxTextExtent] = "\0";      static const char      *CompositeMenu[]=      {        "Operators",       "Blend",       "Displace", 
       "Help",        "Dismiss",       (char *) NULL      };     static CompositeOperator!     compose = ReplaceCompositeOp;      static const ModeType      CompositeCommands[]=     {         CompositeOperatorsCommand,       CompositeBlendCommand,       CompositeDisplaceCommand,        CompositeHelpCommand,        CompositeDismissCommand      };     char     text[MaxTextExtent];     Cursor     cursor;      double
     blend,     scale_factor;      Image      *composite_image;      int      id,      x,     y;     RectangleInfo      highlight_info,      composite_info;      unsigned int     height, 
     width;     unsigned long 
     state;     XEvent
     event;     /*&     Request image file name from user.   */;   XFileBrowserWidget(display,windows,"Composite",filename);    if (*filename == '\0')     return(True);    /*     Read image.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);>   (void) strcpy(resource_info->image_info->filename,filename);7   composite_image=ReadImage(resource_info->image_info); )   XSetCursorState(display,windows,False); (   if (composite_image == (Image *) NULL)     { F       XNoticeWidget(display,windows,"Unable to read image:",filename);       return(False);     }    if (!composite_image->matte)     {        /*/         Request mask image file name from user.        */$       XNoticeWidget(display,windows,C         "Your image does not have the required matte information.", ?         "Press dismiss and choose an image to use as a mask."); ?       XFileBrowserWidget(display,windows,"Composite",filename);        if (*filename != '\0')	         {            char              size[MaxTextExtent];             Image              *mask_image;             ImageInfo              image_info;              /*             Read image.            */0           XSetCursorState(display,windows,True);0           XCheckRefreshWindows(display,windows);$           GetImageInfo(&image_info);6           (void) strcpy(image_info.filename,filename);4           (void) CloneString(&image_info.size,size);H           FormatString(image_info.size,"%ux%u",composite_image->columns,#             composite_image->rows); ,           mask_image=ReadImage(&image_info);1           XSetCursorState(display,windows,False); +           if (mask_image == (Image *) NULL) 
             { N               XNoticeWidget(display,windows,"Unable to read image:",filename);               return(False);
             } L           CompositeImage(composite_image,ReplaceMatteCompositeOp,mask_image,             0,0); #           DestroyImage(mask_image); (           DestroyImageInfo(&image_info);	         }      }    /*     Map Command widget.    */$   windows->command.name="Composite";   windows->command.data=1;G   (void) XCommandWidget(display,windows,CompositeMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask); &   composite_info.x=windows->image.x+x;&   composite_info.y=windows->image.y+y;   composite_info.width=0;    composite_info.height=0;0   cursor=XCreateFontCursor(display,XC_ul_angle);B   XSetFunction(display,windows->image.highlight_context,GXinvert);   blend=0.0;   state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */H         FormatString(text," %+d%+d ",composite_info.x,composite_info.y);*         XInfoWidget(display,windows,text);       } "     highlight_info=composite_info;7     highlight_info.x=composite_info.x-windows->image.x; 7     highlight_info.y=composite_info.y-windows->image.y; 2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);     /*       Wait for next event.     */)     XScreenEvent(display,windows,&event); 2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */@         id=XCommandWidget(display,windows,CompositeMenu,&event);         if (id < 0)            continue; &         switch (CompositeCommands[id])	         { )           case CompositeOperatorsCommand:            {              char%               command[MaxTextExtent];                static const char                *OperatorMenu[]=               {                  "Over",                  "In",                  "Out",                 "Atop",                  "Xor",                 "Plus",                  "Minus",                 "Add",                 "Subtract",                  "Difference",                  "Bumpmap",                 "Replace",                 "ReplaceRed",                  "ReplaceGreen",                  "ReplaceBlue",                 "ReplaceMatte",                  (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */E             compose=(CompositeOperator) (XMenuWidget(display,windows, 9               CompositeMenu[id],OperatorMenu,command)+1);              break;           } %           case CompositeBlendCommand:            {              static char -               factor[MaxTextExtent] = "20.0";                /*3               Blend the two images a given percent.              */J             XSetFunction(display,windows->image.highlight_context,GXcopy);9             (void) XDialogWidget(display,windows,"Blend", >               "Enter the blend factor (0.0 - 99.9%):",factor);L             XSetFunction(display,windows->image.highlight_context,GXinvert);              if (*factor == '\0')               break;             blend=atof(factor); %             compose=BlendCompositeOp;              break;           } (           case CompositeDisplaceCommand:           {              /*F               Get horizontal and vertical scale displacement geometry.             */J             XSetFunction(display,windows->image.highlight_context,GXcopy);<             (void) XDialogWidget(display,windows,"Displace",P               "Enter the horizontal and vertical scale:",displacement_geometry);L             XSetFunction(display,windows->image.highlight_context,GXinvert);/             if (*displacement_geometry == '\0')                break;(             compose=DisplaceCompositeOp;             break;           } $           case CompositeHelpCommand:           { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,D               "Help Viewer - Image Compositing",ImageCompositeHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           } '           case CompositeDismissCommand:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { !         if (resource_info->debug) B           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); ,         if (event.xbutton.button != Button1)           break;6         if (event.xbutton.window != windows->image.id)           break;
         /*           Change cursor.
         */6         composite_info.width=composite_image->columns;4         composite_info.height=composite_image->rows;8         XDefineCursor(display,windows->image.id,cursor);:         composite_info.x=windows->image.x+event.xbutton.x;:         composite_info.y=windows->image.y+event.xbutton.y;         break;       }        case ButtonRelease:        { !         if (resource_info->debug) D           (void) fprintf(stderr,"Button Release: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); ,         if (event.xbutton.button != Button1)           break;6         if (event.xbutton.window != windows->image.id)           break;H         if ((composite_info.width != 0) && (composite_info.height != 0))           {              /*D               User has selected the location of the composite image.             */>             composite_info.x=windows->image.x+event.xbutton.x;>             composite_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;            }          break;       }        case Expose:         break;       case KeyPress:       {          char!           command[MaxTextExtent];            KeySym           key_symbol;            int            length;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; !         if (resource_info->debug) J           (void) fprintf(stderr,"Key press: 0x%lx (%.1024s)\n",key_symbol,             command);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */*             DestroyImage(composite_image);             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,D               "Help Viewer - Image Compositing",ImageCompositeHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */         x=event.xmotion.x;         y=event.xmotion.y;!         if (windows->info.mapped)            { D             if ((x < (int) (windows->info.x+windows->info.width)) &&C                 (y < (int) (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          elseB           if ((x > (int) (windows->info.x+windows->info.width)) ||A               (y > (int) (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); ,         composite_info.x=windows->image.x+x;,         composite_info.y=windows->image.y+y;         break;       }        default:       { !         if (resource_info->debug) ?           (void) fprintf(stderr,"Event type: %d\n",event.type);          break;       }      } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); @   XSetFunction(display,windows->image.highlight_context,GXcopy);)   XSetCursorState(display,windows,False);    XFreeCursor(display,cursor);   if (state & EscapeState)     return(True);    /*9     Image compositing is relative to image configuration.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   width=image->columns;    height=image->rows;    x=0;   y=0;4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=(double) width/windows->image.ximage->width;    composite_info.x+=x;1   composite_info.x=scale_factor*composite_info.x; 9   composite_info.width=scale_factor*composite_info.width; =   scale_factor=(double) height/windows->image.ximage->height;    composite_info.y+=y;1   composite_info.y=scale_factor*composite_info.y; ;   composite_info.height=scale_factor*composite_info.height; ;   if ((composite_info.width != composite_image->columns) || 7       (composite_info.height != composite_image->rows))      {        Image          *zoomed_image;         /*         Scale composite image.       */B       zoomed_image=ZoomImage(composite_image,composite_info.width,         composite_info.height); $       DestroyImage(composite_image);)       if (zoomed_image == (Image *) NULL) 	         { 1           XSetCursorState(display,windows,False);            return(False);	         } #       composite_image=zoomed_image;      } %   if (compose == DisplaceCompositeOp) 4     composite_image->geometry=displacement_geometry;   if (blend != 0.0)      { 	       int 
         y;         register int
         x;         register PixelPacket         *q;          unsigned short         opacity;         /*#         Create mattes for blending.        */>       opacity=(Quantum) (((int) DownScale(MaxRGB)*blend)/100);)       MatteImage(composite_image,Opaque);        opacity=(Quantum) F         ((int) DownScale(MaxRGB)-((int) DownScale(MaxRGB)*blend)/100);       image->class=DirectClass;        image->matte=True;+       for (y=0; y < (int) image->rows; y++)        { 4         q=GetPixelCache(image,0,y,image->columns,1);&         if (q == (PixelPacket *) NULL)           break;0         for (x=0; x < (int) image->columns; x++)	         {            q->opacity=opacity;            q++;	         } #         if (!SyncPixelCache(image))            break;       }      }    /*(     Composite image with X Image window.   */@   CompositeImage(image,compose,composite_image,composite_info.x,     composite_info.y);    DestroyImage(composite_image);)   XSetCursorState(display,windows,False);    /*     Update image configuration.    */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X C o n f i g u r e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method XConfigureImage creates a new X image.  It also notifies theL %  window manager of the new image size and configures the transient widows. % / %  The format of the XConfigureImage method is:  % 5 %      unsigned int XConfigureImage(Display *display, E %        XResourceInfo *resource_info,XWindows *windows,Image *image)  % + %  A description of each parameter follows:  % C %    o status: Method XConfigureImage returns True if the window is J %      resized.  False is returned is there is a memory shortage or if the %      window fails to resize. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */5 static unsigned int XConfigureImage(Display *display, >   XResourceInfo *resource_info,XWindows *windows,Image *image) {    char     geometry[MaxTextExtent];     int      x,     y;     unsigned int     height, 	     mask,      stasis,      status, 
     width;     XSizeHints     *size_hints;     XWindowChanges     window_changes;      /**     Dismiss if window dimensions are zero.   */,   width=windows->image.window_changes.width;.   height=windows->image.window_changes.height;   if (resource_info->debug) <     (void) fprintf(stderr,"Configure Image: %dx%d=>%ux%u\n",O       windows->image.ximage->width,windows->image.ximage->height,width,height);    if ((width*height) == 0)     return(True);    /*0     Resize image to fit Image window dimensions.   */(   XSetCursorState(display,windows,True);   XFlush(display);9   stasis=((int) width == windows->image.ximage->width) && 4     ((int) height == windows->image.ximage->height);K   windows->magnify.x=width*windows->magnify.x/windows->image.ximage->width; M   windows->magnify.y=height*windows->magnify.y/windows->image.ximage->height; G   windows->image.x=width*windows->image.x/windows->image.ximage->width; I   windows->image.y=height*windows->image.y/windows->image.ximage->height; N   status=XMakeImage(display,resource_info,&windows->image,image,width,height);   if (status == False)A     XNoticeWidget(display,windows,"Unable to configure X image:",        windows->image.name);    /*3     Notify window manager of the new configuration.    */&   FormatString(geometry,"%ux%u+0+0>!",1     XDisplayWidth(display,windows->image.screen), 3     XDisplayHeight(display,windows->image.screen)); ;   (void) ParseImageGeometry(geometry,&x,&y,&width,&height);    window_changes.width=width;    window_changes.height=height;    mask=CWWidth | CWHeight;   if (resource_info->backdrop)     {        mask|=CWX | CWY;       window_changes.x= F         (XDisplayWidth(display,windows->image.screen) >> 1)-(width/2);       window_changes.y= H         (XDisplayHeight(display,windows->image.screen) >> 1)-(height/2);     } L   XReconfigureWMWindow(display,windows->image.id,windows->image.screen,mask,     &window_changes);    if (image->matte) ,     XClearWindow(display,windows->image.id);
   if (stasis) <     XRefreshWindow(display,&windows->image,(XEvent *) NULL);   /*(     Update Magnify window configuration.   */   if (windows->magnify.mapped)'     XMakeMagnifyImage(display,windows);    /*$     Update pan window configuration.   */:   windows->pan.crop_geometry=windows->image.crop_geometry;-   XBestIconSize(display,&windows->pan,image); A   while ((windows->pan.width < 96) && (windows->pan.height < 96))    {      windows->pan.width<<=1;      windows->pan.height<<=1;   } -   if (windows->pan.geometry != (char *) NULL) P     (void) XParseGeometry(windows->pan.geometry,&windows->pan.x,&windows->pan.y,0       &windows->pan.width,&windows->pan.height);*   window_changes.width=windows->pan.width;,   window_changes.height=windows->pan.height;   size_hints=XAllocSizeHints(); (   if (size_hints != (XSizeHints *) NULL)     {        /*         Set new size hints.        */4       size_hints->flags=PSize | PMinSize | PMaxSize;-       size_hints->width=window_changes.width; /       size_hints->height=window_changes.height; .       size_hints->min_width=size_hints->width;0       size_hints->min_height=size_hints->height;.       size_hints->max_width=size_hints->width;0       size_hints->max_height=size_hints->height;:       XSetNormalHints(display,windows->pan.id,size_hints);!       XFree((void *) size_hints);      } L   XReconfigureWMWindow(display,windows->pan.id,windows->pan.screen,CWWidth |     CWHeight,&window_changes);   if (windows->pan.mapped)7     XMakePanImage(display,resource_info,windows,image);    /*%     Update icon window configuration.    */;   windows->icon.crop_geometry=windows->image.crop_geometry; .   XBestIconSize(display,&windows->icon,image);+   window_changes.width=windows->icon.width; -   window_changes.height=windows->icon.height; E   XReconfigureWMWindow(display,windows->icon.id,windows->icon.screen, (     CWWidth | CWHeight,&window_changes);)   XSetCursorState(display,windows,False);    return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X C r o p I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method XCropImage allows the user to select a region of the image andI %  crop, copy, or cut it.  For copy or cut, the image can subsequently be . %  composited onto the image with XPasteImage. % * %  The format of the XCropImage method is: % M %      unsigned int XCropImage(Display *display,XResourceInfo *resource_info, A %        XWindows *windows,Image *image,const ClipboardMode mode)  % + %  A description of each parameter follows:  % = %    o status: Method XCropImage returns True if the image is I %      copied.  False is returned is there is a memory shortage or if the   %      image fails to be copied. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  % F %    o mode: This unsigned value specified whether the image should be %      cropped, copied, or cut.  %  %  */M static unsigned int XCropImage(Display *display,XResourceInfo *resource_info, :   XWindows *windows,Image *image,const ClipboardMode mode) {    static const char      *CropModeMenu[]=     { 
       "Help",        "Dismiss",       (char *) NULL      },     *RectifyModeMenu[]=      { 
       "Crop", 
       "Help",        "Dismiss",       (char *) NULL      };     static const ModeType      CropCommands[]=      {        CropHelpCommand,       CropDismissCommand     },     RectifyCommands[]=     {        RectifyCopyCommand,        RectifyHelpCommand,        RectifyDismissCommand      };     char     command[MaxTextExtent],      text[MaxTextExtent];     Cursor     cursor;      double     scale_factor;      int      id,      x,     y;     KeySym     key_symbol;      Image      *crop_image;     RectangleInfo      crop_info,     highlight_info;      register PixelPacket     *q;      unsigned int     height, 
     width;     unsigned long 
     state;     XEvent
     event;     /*     Map Command widget.    */   switch (mode)    {      case CopyMode:     { #       windows->command.name="Copy";        break;     }      case CropMode:     { #       windows->command.name="Crop";        break;     }      case CutMode:      { "       windows->command.name="Cut";       break;     }    } +   RectifyModeMenu[0]=windows->command.name;    windows->command.data=0;F   (void) XCommandWidget(display,windows,CropModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask); !   crop_info.x=windows->image.x+x; !   crop_info.y=windows->image.y+y;    crop_info.width=0;   crop_info.height=0; -   cursor=XCreateFontCursor(display,XC_fleur);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */>         FormatString(text," %+d%+d ",crop_info.x,crop_info.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */)     XScreenEvent(display,windows,&event); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */?         id=XCommandWidget(display,windows,CropModeMenu,&event);          if (id < 0)            continue; !         switch (CropCommands[id]) 	         {            case CropHelpCommand:            {              switch (mode) 
             {                case CopyMode:               { D                 XTextViewWidget(display,resource_info,windows,False,?                   "Help Viewer - Image Copying",ImageCopyHelp);                  break;               }                case CropMode:               { D                 XTextViewWidget(display,resource_info,windows,False,@                   "Help Viewer - Image Cropping",ImageCropHelp);                 break;               }                case CutMode:                { D                 XTextViewWidget(display,resource_info,windows,False,>                   "Help Viewer - Image Cutting",ImageCutHelp);                 break;               } 
             }              break;           } "           case CropDismissCommand:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { ,         if (event.xbutton.button != Button1)           break;6         if (event.xbutton.window != windows->image.id)           break;
         /*>           Note first corner of cropping rectangle-- exit loop.
         */8         XDefineCursor(display,windows->image.id,cursor);5         crop_info.x=windows->image.x+event.xbutton.x; 5         crop_info.y=windows->image.y+event.xbutton.y;          state|=ExitState;          break;       }        case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       { 3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            {              switch (mode) 
             {                case CopyMode:               { D                 XTextViewWidget(display,resource_info,windows,False,?                   "Help Viewer - Image Copying",ImageCopyHelp);                  break;               }                case CropMode:               { D                 XTextViewWidget(display,resource_info,windows,False,@                   "Help Viewer - Image Cropping",ImageCropHelp);                 break;               }                case CutMode:                { D                 XTextViewWidget(display,resource_info,windows,False,>                   "Help Viewer - Image Cutting",ImageCutHelp);                 break;               } 
             }              break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */         x=event.xmotion.x;         y=event.xmotion.y;!         if (windows->info.mapped)            { D             if ((x < (int) (windows->info.x+windows->info.width)) &&C                 (y < (int) (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          elseB           if ((x > (int) (windows->info.x+windows->info.width)) ||A               (y > (int) (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); '         crop_info.x=windows->image.x+x; '         crop_info.y=windows->image.y+y;          break;       }        default:         break;     } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);    if (state & EscapeState)     {        /*+         User want to exit without cropping.        */E       XWithdrawWindow(display,windows->info.id,windows->info.screen); "       XFreeCursor(display,cursor);       return(True);      } B   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {      /*I       Size rectangle as pointer moves until the mouse button is released.      */     x=crop_info.x;     y=crop_info.y;     crop_info.width=0;     crop_info.height=0;      state=DefaultState;      do     {        highlight_info=crop_info; 4       highlight_info.x=crop_info.x-windows->image.x;4       highlight_info.y=crop_info.y-windows->image.y;D       if ((highlight_info.width > 3) && (highlight_info.height > 3))	         {            /*5             Display info and draw cropping rectangle.            */$           if (!windows->info.mapped)1             XMapWindow(display,windows->info.id); L           FormatString(text," %ux%u%+d%+d",crop_info.width,crop_info.height,%             crop_info.x,crop_info.y); ,           XInfoWidget(display,windows,text);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);	         } 
       else!         if (windows->info.mapped) I           XWithdrawWindow(display,windows->info.id,windows->info.screen);        /*         Wait for next event.       */+       XScreenEvent(display,windows,&event); D       if ((highlight_info.width > 3) && (highlight_info.height > 3))6         XHighlightRectangle(display,windows->image.id,<           windows->image.highlight_context,&highlight_info);       switch (event.type)        {          case ButtonPress: 	         { 7           crop_info.x=windows->image.x+event.xbutton.x; 7           crop_info.y=windows->image.y+event.xbutton.y;            break;	         }          case ButtonRelease: 	         {            /*5             User has committed to cropping rectangle.            */7           crop_info.x=windows->image.x+event.xbutton.x; 7           crop_info.y=windows->image.y+event.xbutton.y; 1           XSetCursorState(display,windows,False);            state|=ExitState; B           if (Latin1Compare(windows->command.name,"Rectify") == 0)             break;*           windows->command.name="Rectify";"           windows->command.data=0;@           (void) XCommandWidget(display,windows,RectifyModeMenu,             (XEvent *) NULL);            break;	         }          case Expose:           break;         case MotionNotify:	         { 7           crop_info.x=windows->image.x+event.xmotion.x; 7           crop_info.y=windows->image.y+event.xmotion.y; 	         }          default:           break;       } L       if (((crop_info.x != x) && (crop_info.y != y)) || (state & ExitState))	         {            /*&             Check boundary conditions.           */           if (crop_info.x < 0)             crop_info.x=0;           else;             if (crop_info.x > windows->image.ximage->width) 7               crop_info.x=windows->image.ximage->width;            if (crop_info.x < x);             crop_info.width=(unsigned int) (x-crop_info.x);            else
             { =               crop_info.width=(unsigned int) (crop_info.x-x);                crop_info.x=x;
             }            if (crop_info.y < 0)             crop_info.y=0;           else<             if (crop_info.y > windows->image.ximage->height)8               crop_info.y=windows->image.ximage->height;           if (crop_info.y < y)<             crop_info.height=(unsigned int) (y-crop_info.y);           else
             { >               crop_info.height=(unsigned int) (crop_info.y-y);               crop_info.y=y;
             } 	         } #     } while (!(state & ExitState));      /*F       Wait for user to grab a corner of the rectangle or press return.     */     state=DefaultState;      do     {        if (windows->info.mapped) 	         {            /*%             Display pointer position.            */L           FormatString(text," %ux%u%+d%+d",crop_info.width,crop_info.height,%             crop_info.x,crop_info.y); ,           XInfoWidget(display,windows,text);	         }        highlight_info=crop_info; 4       highlight_info.x=crop_info.x-windows->image.x;4       highlight_info.y=crop_info.y-windows->image.y;F       if ((highlight_info.width <= 3) || (highlight_info.height <= 3))	         {            state|=EscapeState;            state|=ExitState;            break;	         } 4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);+       XScreenEvent(display,windows,&event); 3       if (event.xany.window == windows->command.id) 	         {            /*5             Select a command from the Command widget.            */H           XSetFunction(display,windows->image.highlight_context,GXcopy);D           id=XCommandWidget(display,windows,RectifyModeMenu,&event);J           XSetFunction(display,windows->image.highlight_context,GXinvert);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);           if (id >= 0)(             switch (RectifyCommands[id])
             { &               case RectifyCopyCommand:               { !                 state|=ExitState;                  break;               } &               case RectifyHelpCommand:               { N                 XSetFunction(display,windows->image.highlight_context,GXcopy);                 switch (mode)                  {                     case CopyMode:                   { H                     XTextViewWidget(display,resource_info,windows,False,C                       "Help Viewer - Image Copying",ImageCopyHelp);                      break;                   }                     case CropMode:                   { H                     XTextViewWidget(display,resource_info,windows,False,D                       "Help Viewer - Image Cropping",ImageCropHelp);                     break;                   }                    case CutMode:                    { H                     XTextViewWidget(display,resource_info,windows,False,B                       "Help Viewer - Image Cutting",ImageCutHelp);                     break;                   }                  } P                 XSetFunction(display,windows->image.highlight_context,GXinvert);                 break;               } )               case RectifyDismissCommand:                {                  /*#                   Prematurely exit.                  */#                 state|=EscapeState; !                 state|=ExitState;                  break;               }                default:                 break;
             }            continue; 	         } 4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);       switch (event.type)        {          case ButtonPress: 	         { .           if (event.xbutton.button != Button1)             break;8           if (event.xbutton.window != windows->image.id)             break;-           x=windows->image.x+event.xbutton.x; -           y=windows->image.y+event.xbutton.y; 3           if ((x < (int) (crop_info.x+RoiDelta)) && 3               (x > (int) (crop_info.x-RoiDelta)) && 3               (y < (int) (crop_info.y+RoiDelta)) && 1               (y > (int) (crop_info.y-RoiDelta))) 
             { 6               crop_info.x=crop_info.x+crop_info.width;7               crop_info.y=crop_info.y+crop_info.height; .               state|=UpdateConfigurationState;               break;
             } 3           if ((x < (int) (crop_info.x+RoiDelta)) && 3               (x > (int) (crop_info.x-RoiDelta)) && D               (y < (int) (crop_info.y+crop_info.height+RoiDelta)) &&B               (y > (int) (crop_info.y+crop_info.height-RoiDelta)))
             { 6               crop_info.x=crop_info.x+crop_info.width;.               state|=UpdateConfigurationState;               break;
             } C           if ((x < (int) (crop_info.x+crop_info.width+RoiDelta)) && C               (x > (int) (crop_info.x+crop_info.width-RoiDelta)) && 3               (y < (int) (crop_info.y+RoiDelta)) && 1               (y > (int) (crop_info.y-RoiDelta))) 
             { 7               crop_info.y=crop_info.y+crop_info.height; .               state|=UpdateConfigurationState;               break;
             } C           if ((x < (int) (crop_info.x+crop_info.width+RoiDelta)) && C               (x > (int) (crop_info.x+crop_info.width-RoiDelta)) && D               (y < (int) (crop_info.y+crop_info.height+RoiDelta)) &&B               (y > (int) (crop_info.y+crop_info.height-RoiDelta)))
             { .               state|=UpdateConfigurationState;               break;
             } 	         }          case ButtonRelease: 	         { 6           if (event.xbutton.window == windows->pan.id)E             if ((highlight_info.x != crop_info.x-windows->image.x) || C                 (highlight_info.y != crop_info.y-windows->image.y)) <               XHighlightRectangle(display,windows->image.id,B                 windows->image.highlight_context,&highlight_info);           break;	         }          case Expose:	         { 8           if (event.xexpose.window == windows->image.id))             if (event.xexpose.count == 0)                { 1                 event.xexpose.x=highlight_info.x; 1                 event.xexpose.y=highlight_info.y; 9                 event.xexpose.width=highlight_info.width; ;                 event.xexpose.height=highlight_info.height; ?                 XRefreshWindow(display,&windows->image,&event);                } 7           if (event.xexpose.window == windows->info.id) )             if (event.xexpose.count == 0) 0               XInfoWidget(display,windows,text);           break;	         }          case KeyPress:	         { 5           if (event.xkey.window != windows->image.id)              break;           /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command, A             sizeof(command),&key_symbol,(XComposeStatus *) NULL);            switch (key_symbol)            {              case XK_Escape:              case XK_F20:!               state|=EscapeState;              case XK_Return: 
             {                state|=ExitState;                break;
             }              case XK_F1:              case XK_Help: 
             { L               XSetFunction(display,windows->image.highlight_context,GXcopy);               switch (mode)                {                  case CopyMode:                 { F                   XTextViewWidget(display,resource_info,windows,False,A                     "Help Viewer - Image Copying",ImageCopyHelp);                    break;                 }                  case CropMode:                 { F                   XTextViewWidget(display,resource_info,windows,False,B                     "Help Viewer - Image Cropping",ImageCropHelp);                   break;                 }                  case CutMode:                  { F                   XTextViewWidget(display,resource_info,windows,False,@                     "Help Viewer - Image Cutting",ImageCutHelp);                   break;                 }                } N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }              default:
             {                XBell(display,0);                break;
             }            }            break;	         }          case KeyRelease:           break;         case MotionNotify:	         {            /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */           x=event.xmotion.x;           y=event.xmotion.y;#           if (windows->info.mapped) 
             { F               if ((x < (int) (windows->info.x+windows->info.width)) &&E                   (y < (int) (windows->info.y+windows->info.height))) O                 XWithdrawWindow(display,windows->info.id,windows->info.screen); 
             }            elseD             if ((x > (int) (windows->info.x+windows->info.width)) ||C                 (y > (int) (windows->info.y+windows->info.height))) 3               XMapWindow(display,windows->info.id);            break;	         }          default:           break;       } +       if (state & UpdateConfigurationState) 	         { (           XPutBackEvent(display,&event);:           XDefineCursor(display,windows->image.id,cursor);           break;	         } #     } while (!(state & ExitState)); !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);)   XSetCursorState(display,windows,False);    if (state & EscapeState)     return(True);    if (mode == CropMode) B     if (((int) crop_info.width != windows->image.ximage->width) ||B         ((int) crop_info.height != windows->image.ximage->height))       { 
         /*D           Reconfigure Image window as defined by cropping rectangle.
         */;         XSetCropGeometry(display,windows,&crop_info,image); <         windows->image.window_changes.width=crop_info.width;>         windows->image.window_changes.height=crop_info.height;D         (void) XConfigureImage(display,resource_info,windows,image);         return(True);        }    /*0     Copy image before applying image transforms.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   width=image->columns;    height=image->rows;    x=0;   y=0;4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=(double) width/windows->image.ximage->width;    crop_info.x+=x; '   crop_info.x=scale_factor*crop_info.x; /   crop_info.width=scale_factor*crop_info.width; =   scale_factor=(double) height/windows->image.ximage->height;    crop_info.y+=y; '   crop_info.y=scale_factor*crop_info.y; 1   crop_info.height=scale_factor*crop_info.height; )   crop_image=CropImage(image,&crop_info); )   XSetCursorState(display,windows,False); #   if (crop_image == (Image *) NULL)      return(False);2   if (resource_info->copy_image != (Image *) NULL),     DestroyImage(resource_info->copy_image);'   resource_info->copy_image=crop_image;    if (mode == CopyMode)      { B       (void) XConfigureImage(display,resource_info,windows,image);       return(True);      }    /*     Cut image.   */   image->class=DirectClass;    if (!image->matte)     MatteImage(image,Opaque); ,   for (y=0; y < (int) crop_info.height; y++)   { <     q=GetPixelCache(image,0,y+crop_info.y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;     q+=crop_info.x; -     for (x=0; x < (int) crop_info.width; x++)      {        q->opacity=Transparent; 
       q++;     }      if (!SyncPixelCache(image))        break;   }    /*     Update image configuration.    */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X D r a w I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method XDrawEditImage draws a graphic primitive (point, line, rectangle,  %  etc.) on the image. % . %  The format of the XDrawEditImage method is: % 4 %      unsigned int XDrawEditImage(Display *display,F %        XResourceInfo *resource_info,XWindows *windows,Image **image) % + %  A description of each parameter follows:  % F %    o status: Method XDrawEditImage return True if the image is drawnG %      upon.  False is returned is there is a memory shortage or if the   %      image cannot be drawn on. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */4 static unsigned int XDrawEditImage(Display *display,?   XResourceInfo *resource_info,XWindows *windows,Image **image)  {    static const char      *DrawMenu[]=     {        "Primitive",       "Color",       "Stipple",       "Width",
       "Undo", 
       "Help",        "Dismiss",       (char *) NULL      };     static PrimitiveType     primitive = PointPrimitive;      static const ModeType      DrawCommands[]=      {        DrawPrimitiveCommand,        DrawColorCommand,        DrawStippleCommand,        DrawWidthCommand,        DrawUndoCommand,       DrawHelpCommand,       DrawDismissCommand     };     static Pixmap      stipple = (Pixmap) NULL;     static unsigned int      pen_id = 0,      line_width = 1;      char     command[MaxTextExtent],      text[MaxTextExtent];     Cursor     cursor;      double     degrees;     int 
     entry,     id,      number_coordinates,      x,     y;     RectangleInfo      rectangle_info;      register int     i;     unsigned int
     distance,      height,      max_coordinates,     status, 
     width;     unsigned long 
     state;     Window     root_window;     XDrawInfo      draw_info;     XEvent
     event;     XPoint     *coordinate_info;   
   XSegment     line_info;     /*     Allocate polygon info.   */   max_coordinates=2048; L   coordinate_info=(XPoint *) AllocateMemory(max_coordinates*sizeof(XPoint));)   if (coordinate_info == (XPoint *) NULL)      { C       MagickWarning(ResourceLimitWarning,"Unable to draw on image", $         "Memory allocation failed");       return(False);     }    /*     Map Command widget.    */   windows->command.name="Draw";    windows->command.data=4;B   (void) XCommandWidget(display,windows,DrawMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*      Wait for first button press.   */;   root_window=XRootWindow(display,XDefaultScreen(display)); "   draw_info.stencil=OpaqueStencil;   status=True;.   cursor=XCreateFontCursor(display,XC_tcross);
   for ( ; ; )    { 4     XQueryPosition(display,windows->image.id,&x,&y);+     XSelectInput(display,windows->image.id, @       windows->image.attributes.event_mask | PointerMotionMask);4     XDefineCursor(display,windows->image.id,cursor);     state=DefaultState;      do     {        if (windows->info.mapped) 	         {            /*%             Display pointer position.            */N           FormatString(text," %+d%+d ",x+windows->image.x,y+windows->image.y);,           XInfoWidget(display,windows,text);	         }        /*         Wait for next event.       */+       XScreenEvent(display,windows,&event); 3       if (event.xany.window == windows->command.id) 	         {            /*5             Select a command from the Command widget.            */=           id=XCommandWidget(display,windows,DrawMenu,&event);            if (id < 0)              continue; #           switch (DrawCommands[id])            { &             case DrawPrimitiveCommand:
             {                static const char                  *Primitives[]=                 {                    "point",                   "line",                    "rectangle",#                   "fill rectangle",                    "circle",                     "fill circle",                   "ellipse",!                   "fill ellipse",                    "polygon",!                   "fill polygon",                     (char *) NULL,                 };                 /*6                 Select a command from the pop-up menu.               */E               primitive=(PrimitiveType) (XMenuWidget(display,windows, 4                 DrawMenu[id],Primitives,command)+1);               break;
             } "             case DrawColorCommand:
             {                char,                 *ColorMenu[MaxNumberPens+1];                 int                  pen_number;                  unsigned int                 transparent;                 XColor                 color;                 /*+                 Initialize menu selections.                */9               for (i=0; i < (int) (MaxNumberPens-2); i++) :                 ColorMenu[i]=resource_info->pen_colors[i];7               ColorMenu[MaxNumberPens-2]="transparent"; 6               ColorMenu[MaxNumberPens-1]="Browser...";5               ColorMenu[MaxNumberPens]=(char *) NULL;                /*8                 Select a pen color from the pop-up menu.               */B               pen_number=XMenuWidget(display,windows,DrawMenu[id],3                 (const char **) ColorMenu,command); !               if (pen_number < 0)                  break;:               transparent=pen_number == (MaxNumberPens-2);               if (transparent)                 { 7                   draw_info.stencil=TransparentStencil;                    break;                 } 2               if (pen_number == (MaxNumberPens-1))                 {                    static char 7                     color_name[MaxTextExtent] = "gray";                      /*5                     Select a pen color from a dialog.                    */C                   resource_info->pen_colors[pen_number]=color_name; K                   XColorBrowserWidget(display,windows,"Select",color_name); *                   if (*color_name == '\0')                     break;                 }                /*                 Set pen color.               */E               (void) XParseColor(display,windows->map_info->colormap, >                 resource_info->pen_colors[pen_number],&color);M               XBestPixel(display,windows->map_info->colormap,(XColor *) NULL, 1                 (unsigned int) MaxColors,&color); @               windows->pixel_info->pen_colors[pen_number]=color;                pen_id=pen_number;.               draw_info.stencil=OpaqueStencil;               break;
             } $             case DrawStippleCommand:
             {                Image                  *stipple_image;                  ImageInfo                  image_info;                  static char /                 filename[MaxTextExtent] = "\0";                  static const char                   *StipplesMenu[]=                 {                    "Brick",                   "Diagonal",                    "Scales",                    "Vertical",                    "Wavy",                     "Translucent",                   "Opaque",                     (char *) NULL,                    (char *) NULL,                 };                 /*6                 Select a command from the pop-up menu.               */(               StipplesMenu[7]="Open...";J               entry=XMenuWidget(display,windows,DrawMenu[id],StipplesMenu,                 command);                if (entry < 0)                 break;+               if (stipple != (Pixmap) NULL) -                 XFreePixmap(display,stipple); $               stipple=(Pixmap) NULL;               if (entry == 6)                  break;               if (entry != 7)                  {                     switch (entry)                   {                      case 0:                      { H                       stipple=XCreateBitmapFromData(display,root_window,H                         (char *) BricksBitmap,BricksWidth,BricksHeight);                       break;                     }                      case 1:                      { H                       stipple=XCreateBitmapFromData(display,root_window,N                         (char *) DiagonalBitmap,DiagonalWidth,DiagonalHeight);                       break;                     }                      case 2:                      { H                       stipple=XCreateBitmapFromData(display,root_window,H                         (char *) ScalesBitmap,ScalesWidth,ScalesHeight);                       break;                     }                      case 3:                      { H                       stipple=XCreateBitmapFromData(display,root_window,N                         (char *) VerticalBitmap,VerticalWidth,VerticalHeight);                       break;                     }                      case 4:                      { H                       stipple=XCreateBitmapFromData(display,root_window,B                         (char *) WavyBitmap,WavyWidth,WavyHeight);                       break;                     }                      case 5:                      default:                     { H                       stipple=XCreateBitmapFromData(display,root_window,@                         (char *) HighlightBitmap,HighlightWidth,)                         HighlightHeight);                        break;                     }                    }                    break;                 } E               XFileBrowserWidget(display,windows,"Stipple",filename); $               if (*filename == '\0')                 break;               /*                 Read image.                */4               XSetCursorState(display,windows,True);4               XCheckRefreshWindows(display,windows);(               GetImageInfo(&image_info);:               (void) strcpy(image_info.filename,filename);3               stipple_image=ReadImage(&image_info); 5               XSetCursorState(display,windows,False); 2               if (stipple_image == (Image *) NULL)                 { H                   XNoticeWidget(display,windows,"Unable to read image:",                     filename);                   break;                 } *               TemporaryFilename(filename);K               FormatString(stipple_image->filename,"xbm:%.1024s",filename); ;               status=WriteImage(&image_info,stipple_image); *               DestroyImage(stipple_image);,               DestroyImageInfo(&image_info);I               status=XReadBitmapFile(display,root_window,filename,&width, (                 &height,&stipple,&x,&y);&               (void) remove(filename);*               if (status != BitmapSuccess)O                 XNoticeWidget(display,windows,"Unable to read X bitmap image:",                    filename);               break;
             } "             case DrawWidthCommand:
             {                static char +                 width[MaxTextExtent] = "3";                  static const char                  *WidthsMenu[]=                 {                    "1",                   "2",                   "4",                   "8",                   "16",                     (char *) NULL,                    (char *) NULL,                 };                 /*6                 Select a command from the pop-up menu.               */(               WidthsMenu[5]="Dialog...";H               entry=XMenuWidget(display,windows,DrawMenu[id],WidthsMenu,                 command);                if (entry < 0)                 break;               if (entry != 5)                  { 5                   line_width=atoi(WidthsMenu[entry]);                    break;                 } L               (void) XDialogWidget(display,windows,"Ok","Enter line width:",                 width); !               if (*width == '\0')                  break;%               line_width=atoi(width);                break;
             } !             case DrawUndoCommand: 
             { N               (void) XMagickCommand(display,resource_info,windows,UndoCommand,                 image);                break;
             } !             case DrawHelpCommand: 
             { B               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Rotation",ImageDrawHelp);>               XDefineCursor(display,windows->image.id,cursor);               break;
             } $             case DrawDismissCommand:
             {                /*!                 Prematurely exit.                */!               state|=EscapeState;                state|=ExitState;                break;
             }              default:               break;           } :           XDefineCursor(display,windows->image.id,cursor);           continue; 	         }        switch (event.type)        {          case ButtonPress: 	         { .           if (event.xbutton.button != Button1)             break;8           if (event.xbutton.window != windows->image.id)             break;           /*             Exit loop.           */           x=event.xbutton.x;           y=event.xbutton.y;           state|=ExitState;            break;	         }          case ButtonRelease:            break;         case Expose:           break;         case KeyPress:	         {            KeySym             key_symbol;   5           if (event.xkey.window != windows->image.id)              break;           /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command, A             sizeof(command),&key_symbol,(XComposeStatus *) NULL);            switch (key_symbol)            {              case XK_Escape:              case XK_F20:
             {                /*!                 Prematurely exit.                */!               state|=EscapeState;                state|=ExitState;                break;
             }              case XK_F1:              case XK_Help: 
             { B               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Rotation",ImageDrawHelp);               break;
             }              default:
             {                XBell(display,0);                break;
             }            }            break;	         }          case MotionNotify:	         {            /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */           x=event.xmotion.x;           y=event.xmotion.y;#           if (windows->info.mapped) 
             { F               if ((x < (int) (windows->info.x+windows->info.width)) &&E                   (y < (int) (windows->info.y+windows->info.height))) O                 XWithdrawWindow(display,windows->info.id,windows->info.screen); 
             }S           elseD             if ((x > (int) (windows->info.x+windows->info.width)) ||C                 (y > (int) (windows->info.y+windows->info.height))) 3               XMapWindow(display,windows->info.id);            break;	         }I       } #     } while (!(state & ExitState)); +     XSelectInput(display,windows->image.id,P,       windows->image.attributes.event_mask);C     XWithdrawWindow(display,windows->info.id,windows->info.screen);      if (state & EscapeState)       break;     /*C       Draw primitive as pointer moves until the button is released.e     */     distance=0;t     degrees=0.0;     line_info.x1=x;      line_info.y1=y;      line_info.x2=x;      line_info.y2=y;      rectangle_info.x=x;      rectangle_info.y=y;      rectangle_info.width=0;      rectangle_info.height=0;     number_coordinates=1;      coordinate_info->x=x;      coordinate_info->y=y; D     XSetFunction(display,windows->image.highlight_context,GXinvert);     state=DefaultState;      do     {        switch (primitive)       {          case PointPrimitive:         default:	         { %           if (number_coordinates > 1) 
             { 3               XDrawLines(display,windows->image.id,2A                 windows->image.highlight_context,coordinate_info,t4                 number_coordinates,CoordModeOrigin);*               FormatString(text," %+d%+d",8                 coordinate_info[number_coordinates-1].x,9                 coordinate_info[number_coordinates-1].y); 0               XInfoWidget(display,windows,text);
             }            break;	         }g         case LinePrimitive:g	         {h           if (distance > 9)t
             {                /**                 Display angle of the line.               */E               degrees=RadiansToDegrees(-atan2((double) (line_info.y2-wE                 line_info.y1),(double) (line_info.x2-line_info.x1)));f1               FormatString(text," %.2f",degrees); 0               XInfoWidget(display,windows,text);7               XHighlightLine(display,windows->image.id, =                 windows->image.highlight_context,&line_info);r
             }a           else%             if (windows->info.mapped) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);p           break;	         }a          case RectanglePrimitive:$         case FillRectanglePrimitive:	         {tH           if ((rectangle_info.width > 3) && (rectangle_info.height > 3))
             {n               /*8                 Display info and draw drawing rectangle.               */D               FormatString(text," %ux%u%+d%+d",rectangle_info.width,I                 rectangle_info.height,rectangle_info.x,rectangle_info.y);h0               XInfoWidget(display,windows,text);<               XHighlightRectangle(display,windows->image.id,B                 windows->image.highlight_context,&rectangle_info);
             }E           else%             if (windows->info.mapped)eM               XWithdrawWindow(display,windows->info.id,windows->info.screen);t           break;	         }h         case CirclePrimitive:o!         case FillCirclePrimitive:          case EllipsePrimitive:"         case FillEllipsePrimitive:	         { H           if ((rectangle_info.width > 3) && (rectangle_info.height > 3))
             {                /*8                 Display info and draw drawing rectangle.               */D               FormatString(text," %ux%u%+d%+d",rectangle_info.width,I                 rectangle_info.height,rectangle_info.x,rectangle_info.y);=0               XInfoWidget(display,windows,text);:               XHighlightEllipse(display,windows->image.id,B                 windows->image.highlight_context,&rectangle_info);
             }            else%             if (windows->info.mapped) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            break;	         }          case PolygonPrimitive:"         case FillPolygonPrimitive:	         { %           if (number_coordinates > 1) 1             XDrawLines(display,windows->image.id, ?               windows->image.highlight_context,coordinate_info, 2               number_coordinates,CoordModeOrigin);           if (distance > 9) 
             {                /**                 Display angle of the line.               */E               degrees=RadiansToDegrees(-atan2((double) (line_info.y2-IE                 line_info.y1),(double) (line_info.x2-line_info.x1)));e1               FormatString(text," %.2f",degrees);t0               XInfoWidget(display,windows,text);7               XHighlightLine(display,windows->image.id, =                 windows->image.highlight_context,&line_info);y
             }o           else%             if (windows->info.mapped)iM               XWithdrawWindow(display,windows->info.id,windows->info.screen);r           break;	         }        }        /*         Wait for next event.       */+       XScreenEvent(display,windows,&event);        switch (primitive)       {          case PointPrimitive:         default:	         {p%           if (number_coordinates > 1)i1             XDrawLines(display,windows->image.id,a?               windows->image.highlight_context,coordinate_info, 2               number_coordinates,CoordModeOrigin);           break;	         }s         case LinePrimitive: 	         {x           if (distance > 9)"5             XHighlightLine(display,windows->image.id,t;               windows->image.highlight_context,&line_info);            break;	         }           case RectanglePrimitive:$         case FillRectanglePrimitive:	         {kH           if ((rectangle_info.width > 3) && (rectangle_info.height > 3)):             XHighlightRectangle(display,windows->image.id,@               windows->image.highlight_context,&rectangle_info);           break;	         }          case CirclePrimitive: !         case FillCirclePrimitive:          case EllipsePrimitive:"         case FillEllipsePrimitive:	         {rH           if ((rectangle_info.width > 3) && (rectangle_info.height > 3))8             XHighlightEllipse(display,windows->image.id,@               windows->image.highlight_context,&rectangle_info);           break;	         }e         case PolygonPrimitive:"         case FillPolygonPrimitive:	         { %           if (number_coordinates > 1)d1             XDrawLines(display,windows->image.id,t?               windows->image.highlight_context,coordinate_info,S2               number_coordinates,CoordModeOrigin);           if (distance > 9)a5             XHighlightLine(display,windows->image.id,t;               windows->image.highlight_context,&line_info);i           break;	         }E       }U       switch (event.type)w       {o         case ButtonPress:e           break;         case ButtonRelease:s	         {d           /*,             User has committed to primitive.           */'           line_info.x2=event.xbutton.x;s'           line_info.y2=event.xbutton.y;I+           rectangle_info.x=event.xbutton.x;.+           rectangle_info.y=event.xbutton.y;s@           coordinate_info[number_coordinates].x=event.xbutton.x;@           coordinate_info[number_coordinates].y=event.xbutton.y;1           if (((primitive != PolygonPrimitive) && G                (primitive != FillPolygonPrimitive)) || (distance <= 9)) 
             {x               state|=ExitState;+               break;
             }e           number_coordinates++; 9           if (number_coordinates < (int) max_coordinates)e
             {o+               line_info.x1=event.xbutton.x;n+               line_info.y1=event.xbutton.y;                break;
             }n           max_coordinates<<=1;$           coordinate_info=(XPoint *)M             ReallocateMemory(coordinate_info,max_coordinates*sizeof(XPoint)); 1           if (coordinate_info == (XPoint *) NULL)wI             MagickWarning(ResourceLimitWarning,"Unable to draw on image",d*               "Memory allocation failed");           break;	         }s         case Expose:           break;         case MotionNotify:	         { 8           if (event.xmotion.window != windows->image.id)             break;*           if (primitive != PointPrimitive)
             {-+               line_info.x2=event.xmotion.x;r+               line_info.y2=event.xmotion.y;M/               rectangle_info.x=event.xmotion.x; /               rectangle_info.y=event.xmotion.y;m               break;
             }t@           coordinate_info[number_coordinates].x=event.xbutton.x;@           coordinate_info[number_coordinates].y=event.xbutton.y;           number_coordinates++; 9           if (number_coordinates < (int) max_coordinates)              break;           max_coordinates<<=1;$           coordinate_info=(XPoint *)M             ReallocateMemory(coordinate_info,max_coordinates*sizeof(XPoint)); 1           if (coordinate_info == (XPoint *) NULL)_I             MagickWarning(ResourceLimitWarning,"Unable to draw on image",n*               "Memory allocation failed");           break;	         }          default:           break;       }        /*"         Check boundary conditions.       */       if (line_info.x2 < 0)=         line_info.x2=0;y
       else6         if (line_info.x2 > (int) windows->image.width),           line_info.x2=windows->image.width;       if (line_info.y2 < 0)t         line_info.y2=0;,
       else7         if (line_info.y2 > (int) windows->image.height)f-           line_info.y2=windows->image.height;        distance= F         ((line_info.x2-line_info.x1+1)*(line_info.x2-line_info.x1+1))+F         ((line_info.y2-line_info.y1+1)*(line_info.y2-line_info.y1+1));A       if (((rectangle_info.x != x) && (rectangle_info.y != y)) ||t           (state & ExitState))	         {0#           if (rectangle_info.x < 0)              rectangle_info.x=0;c           else>             if (rectangle_info.x > (int) windows->image.width)4               rectangle_info.x=windows->image.width;#           if (rectangle_info.x < x)(E             rectangle_info.width=(unsigned int) (x-rectangle_info.x);h           else
             { G               rectangle_info.width=(unsigned int) (rectangle_info.x-x); !               rectangle_info.x=x;,
             } #           if (rectangle_info.y < 0)              rectangle_info.y=0;r           else?             if (rectangle_info.y > (int) windows->image.height) 5               rectangle_info.y=windows->image.height;r#           if (rectangle_info.y < y) F             rectangle_info.height=(unsigned int) (y-rectangle_info.y);           else
             { H               rectangle_info.height=(unsigned int) (rectangle_info.y-y);!               rectangle_info.y=y;[
             }o	         } #     } while (!(state & ExitState));pB     XSetFunction(display,windows->image.highlight_context,GXcopy);K     if ((primitive == PointPrimitive) || (primitive == PolygonPrimitive) || ,         (primitive == FillPolygonPrimitive))       {)
         /*)           Determine polygon bounding box. 
         */,         rectangle_info.x=coordinate_info->x;,         rectangle_info.y=coordinate_info->y;         x=coordinate_info->x;          y=coordinate_info->y;x.         for (i=1; i < number_coordinates; i++)	         {r'           if (coordinate_info[i].x > x)p#             x=coordinate_info[i].x; '           if (coordinate_info[i].y > y)C#             y=coordinate_info[i].y; 6           if (coordinate_info[i].x < rectangle_info.x)9             rectangle_info.x=Max(coordinate_info[i].x,0);;6           if (coordinate_info[i].y < rectangle_info.y)9             rectangle_info.y=Max(coordinate_info[i].y,0);n	         } 0         rectangle_info.width=x-rectangle_info.x;1         rectangle_info.height=y-rectangle_info.y; .         for (i=0; i < number_coordinates; i++)	         {o1           coordinate_info[i].x-=rectangle_info.x;X1           coordinate_info[i].y-=rectangle_info.y; 	         }n       }*     else       if (distance <= 9)         continue; 
       else0         if ((primitive == RectanglePrimitive) ||N             (primitive == CirclePrimitive) || (primitive == EllipsePrimitive))           {f#             rectangle_info.width--; $             rectangle_info.height--;           }      /*1       Drawing is relative to image configuration.      */!     draw_info.x=rectangle_info.x;c!     draw_info.y=rectangle_info.y; P     (void) XMagickCommand(display,resource_info,windows,SaveToUndoBufferCommand,
       image);r     width=(*image)->columns;     height=(*image)->rows;     x=0;     y=0;6     if (windows->image.crop_geometry != (char *) NULL)O       (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);i1     draw_info.x+=windows->image.x-(line_width/2);      if (draw_info.x < 0)       draw_info.x=0;?     draw_info.x=width*draw_info.x/windows->image.ximage->width;>1     draw_info.y+=windows->image.y-(line_width/2);      if (draw_info.y < 0)       draw_info.y=0;A     draw_info.y=height*draw_info.y/windows->image.ximage->height;m;     draw_info.width=rectangle_info.width+(line_width << 1);t,     if (draw_info.width > (*image)->columns)(       draw_info.width=(*image)->columns;=     draw_info.height=rectangle_info.height+(line_width << 1); *     if (draw_info.height > (*image)->rows)&       draw_info.height=(*image)->rows;2     FormatString(draw_info.geometry,"%ux%u%+d%+d",9       width*draw_info.width/windows->image.ximage->width, <       height*draw_info.height/windows->image.ximage->height,#       draw_info.x+x,draw_info.y+y);,     /*$       Initialize drawing attributes.     */     draw_info.degrees=0.0;"     draw_info.primitive=primitive;     draw_info.stipple=stipple;$     draw_info.line_width=line_width;"     draw_info.line_info=line_info;,     if (line_info.x1 > (int) (line_width/2))*       draw_info.line_info.x1=line_width/2;,     if (line_info.y1 > (int) (line_width/2))*       draw_info.line_info.y1=line_width/2;D     draw_info.line_info.x2=line_info.x2-line_info.x1+(line_width/2);D     draw_info.line_info.y2=line_info.y2-line_info.y1+(line_width/2);E     if ((draw_info.line_info.x2 < 0) && (draw_info.line_info.y2 < 0))        {r9         draw_info.line_info.x2=(-draw_info.line_info.x2); 9         draw_info.line_info.y2=(-draw_info.line_info.y2);        } #     if (draw_info.line_info.x2 < 0)r       {i9         draw_info.line_info.x2=(-draw_info.line_info.x2);"<         Swap(draw_info.line_info.x1,draw_info.line_info.x2);       }A#     if (draw_info.line_info.y2 < 0)        { 9         draw_info.line_info.y2=(-draw_info.line_info.y2); <         Swap(draw_info.line_info.y1,draw_info.line_info.y2);       } ,     draw_info.rectangle_info=rectangle_info;:     if (draw_info.rectangle_info.x > (int) (line_width/2)).       draw_info.rectangle_info.x=line_width/2;:     if (draw_info.rectangle_info.y > (int) (line_width/2)).       draw_info.rectangle_info.y=line_width/2;4     draw_info.number_coordinates=number_coordinates;.     draw_info.coordinate_info=coordinate_info;K     windows->pixel_info->pen_color=windows->pixel_info->pen_colors[pen_id];      /*       Draw primitive on image.     */*     XSetCursorState(display,windows,True);*     XCheckRefreshWindows(display,windows);E     status=XDrawImage(display,windows->pixel_info,&draw_info,*image);.+     XSetCursorState(display,windows,False);      /*8       Update image colormap and return to image drawing.     */B     XConfigureImageColormap(display,resource_info,windows,*image);A     (void) XConfigureImage(display,resource_info,windows,*image);    } )   XSetCursorState(display,windows,False);X   FreeMemory(coordinate_info);   return(status);  }m r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%SO %                                                                             %XO %                                                                             %,O %                                                                             % O +   X D r a w P a n R e c t a n g l e                                         %iO %                                                                             % O %                                                                             %dO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method XDrawPanRectangle draws a rectangle in the pan window.  The pan J %  window displays a zoomed image and the rectangle shows which portion of. %  the image is displayed in the Image window. %e1 %  The format of the XDrawPanRectangle method is:> %n< %      XDrawPanRectangle(Display *display,XWindows *windows) %(+ %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. %p %d */A static void XDrawPanRectangle(Display *display,XWindows *windows)t {a   double     scale_factor;.     RectangleInfor     highlight_info;      /*2     Determine dimensions of the panning rectangle.   */H   scale_factor=(double) windows->pan.width/windows->image.ximage->width;1   highlight_info.x=scale_factor*windows->image.x;n9   highlight_info.width=scale_factor*windows->image.width;wJ   scale_factor=(double) windows->pan.height/windows->image.ximage->height;1   highlight_info.y=scale_factor*windows->image.y;x;   highlight_info.height=scale_factor*windows->image.height;    /*"     Display the panning rectangle.   */(   XClearWindow(display,windows->pan.id);L   XHighlightRectangle(display,windows->pan.id,windows->pan.annotate_context,     &highlight_info);w }h ( /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)O %                                                                             %tO %                                                                             %)O %                                                                             %oO +   X I m a g e C a c h e                                                     %tO %                                                                             % O %                                                                             %lO %                                                                             %hO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %nL %  Method XImageCache handles the creation, manipulation, and destruction of+ %  the image cache (undo and redo buffers).- %n+ %  The format of the XImageCache method is:o %eF %      void XImageCache(Display *display,XResourceInfo *resource_info,C %        XWindows *windows,const CommandType command,Image **image)y %_+ %  A description of each parameter follows:a %iD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %oK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.w %p< %    o windows: Specifies a pointer to a XWindows structure. %a/ %    o command: Specifies a command to perform.l %[D %    o image: Specifies a pointer to a Image structure;  XImageCache> %      may transform the image and return a new image pointer. %  %i */F static void XImageCache(Display *display,XResourceInfo *resource_info,<   XWindows *windows,const CommandType command,Image **image) {t   Image1     *cache_image;x     static Image!     *redo_image = (Image *) NULL,;!     *undo_image = (Image *) NULL;i     switch (command)   {      case FreeBuffersCommand:     {=       /*1         Free memory from the undo and redo cache.c       */*       while (undo_image != (Image *) NULL)       {i         cache_image=undo_image;1(         undo_image=undo_image->previous;(         DestroyImage(cache_image->list);"         DestroyImage(cache_image);       }>        undo_image=(Image *) NULL;'       if (redo_image != (Image *) NULL)m!         DestroyImage(redo_image);S        redo_image=(Image *) NULL;
       return;      }-     case UndoCommand:_     {i       /*+         Undo the last image transformation.,       */'       if (undo_image == (Image *) NULL)i	         {            XBell(display,0);,           return;u	         }        cache_image=undo_image;a&       undo_image=undo_image->previous;?       windows->image.window_changes.width=cache_image->columns;l=       windows->image.window_changes.height=cache_image->rows;[8       if (windows->image.crop_geometry != (char *) NULL)1         FreeMemory(windows->image.crop_geometry); 9       windows->image.crop_geometry=cache_image->geometry; '       if (redo_image != (Image *) NULL)d!         DestroyImage(redo_image);w       redo_image=(*image);       *image=cache_image->list;n        DestroyImage(cache_image);        if (windows->image.orphan)         return; D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);h
       return;t     }n     case CutCommand:     case PasteCommand:     case ApplyCommand:     case HalfSizeCommand:l     case OriginalSizeCommand:;     case DoubleSizeCommand:e     case ResizeCommand:      case TrimCommand:e     case CropCommand:a     case ChopCommand:      case FlipCommand:      case FlopCommand:c     case RotateRightCommand:     case RotateLeftCommand:t     case RotateCommand:a     case ShearCommand:     case RollCommand:s     case NegateCommand:e     case EqualizeCommand:x     case NormalizeCommand:     case HueCommand:     case SaturationCommand:d     case BrightnessCommand:      case GammaCommand:     case SpiffCommand:     case DullCommand:      case GrayscaleCommand:     case MapCommand:     case QuantizeCommand:f     case DespeckleCommand:     case EmbossCommand:      case ReduceNoiseCommand:     case AddNoiseCommand:      case SharpenCommand:     case BlurCommand:,     case ThresholdCommand:     case EdgeDetectCommand:i     case SpreadCommand:      case ShadeCommand:     case RaiseCommand:     case SegmentCommand:     case SolarizeCommand:v     case SwirlCommand:     case ImplodeCommand:     case WaveCommand:      case OilPaintCommand:       case CharcoalDrawingCommand:     case AnnotateCommand:      case AddBorderCommand:     case AddFrameCommand:(     case CompositeCommand:     case CommentCommand:     case LaunchCommand:_!     case RegionofInterestCommand: !     case SaveToUndoBufferCommand:o     case RedoCommand:o     {d       Image          *previous_image;         unsigned int         bytes;         bytes=(unsigned int)?         ((*image)->columns*(*image)->rows*sizeof(PixelPacket));x'       if (undo_image != (Image *) NULL) 	         {            /*>             Ensure the undo cache has enough memory available.           */$           previous_image=undo_image;2           while (previous_image != (Image *) NULL)           {eL             bytes+=previous_image->list->columns*previous_image->list->rows*"               sizeof(PixelPacket);;             if (bytes <= (resource_info->undo_cache << 20)):               { 8                 previous_image=previous_image->previous;                 continue;                } L             bytes-=previous_image->list->columns*previous_image->list->rows*"               sizeof(PixelPacket);-             if (previous_image == undo_image)m(               undo_image=(Image *) NULL;             else<               previous_image->next->previous=(Image *) NULL;             break;           } 2           while (previous_image != (Image *) NULL)           {              /*7               Delete any excess memory from undo cache.              */'             cache_image=previous_image;l4             previous_image=previous_image->previous;,             cache_image->file=(FILE *) NULL;,             DestroyImage(cache_image->list);&             DestroyImage(cache_image);           } 	         } 4       if (bytes > (resource_info->undo_cache << 20))         break;       /*6         Save image before transformations are applied.       */4       cache_image=AllocateImage((ImageInfo *) NULL);(       if (cache_image == (Image *) NULL)         break;,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       cache_image->list=A         CloneImage(*image,(*image)->columns,(*image)->rows,True); -       XSetCursorState(display,windows,False); .       if (cache_image->list == (Image *) NULL)	         { $           DestroyImage(cache_image);           break;	         }h8       cache_image->columns=windows->image.ximage->width;6       cache_image->rows=windows->image.ximage->height;9       cache_image->geometry=windows->image.crop_geometry;t8       if (windows->image.crop_geometry != (char *) NULL)	         { (           cache_image->geometry=(char *)7             AllocateMemory(MaxTextExtent*sizeof(char));i5           if (cache_image->geometry != (char *) NULL) N             (void) strcpy(cache_image->geometry,windows->image.crop_geometry);	         } '       if (undo_image == (Image *) NULL)t	         { !           undo_image=cache_image;            break;	         } #       undo_image->next=cache_image; ,       undo_image->next->previous=undo_image;"       undo_image=undo_image->next;       break;     }i     default:       break;   }e   if (command == RedoCommand)      {h       /*+         Redo the last image transformation.        */'       if (redo_image == (Image *) NULL)a	         {e           XBell(display,0);            return; 	         } >       windows->image.window_changes.width=redo_image->columns;<       windows->image.window_changes.height=redo_image->rows;8       if (windows->image.crop_geometry != (char *) NULL)1         FreeMemory(windows->image.crop_geometry); 8       windows->image.crop_geometry=redo_image->geometry;       DestroyImage(*image);        *image=redo_image;        redo_image=(Image *) NULL;        if (windows->image.orphan)         return; D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image); 
       return;(     }e   if (command != InfoCommand)n     return;    /*     Display image info.w   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);E   XDisplayImageInfo(display,resource_info,windows,undo_image,*image); )   XSetCursorState(display,windows,False);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%hO %                                                                             %eO %                                                                             %iO %                                                                             %dO +   X I m a g e W i n d o w C o m m a n d                                     %>O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %aL %  Method XImageWindowCommand makes a transform to the image or Image window: %  as specified by a user menu button or keyboard command. %z. %  The format of the XMagickCommand method is: %-8 %      CommandType XImageWindowCommand(Display *display,8 %        XResourceInfo *resource_info,XWindows *windows,B %        const unsigned int state,KeySym key_symbol,Image **image) %n+ %  A description of each parameter follows:  %oJ %    o loaded_image:  Method XImageWindowCommand returns an image when theI %      user chooses 'Open Image' from the command menu.  Otherwise a nullo %      image is returned.  %LD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.a %i< %    o windows: Specifies a pointer to a XWindows structure. %X %    o state: key mask.  % 2 %    o key_symbol: Specifies a command to perform. %-L %    o image: Specifies a pointer to a Image structure;  XImageWIndowCommand> %      may transform the image and return a new image pointer. %  %  */8 static CommandType XImageWindowCommand(Display *display,J   XResourceInfo *resource_info,XWindows *windows,const unsigned int state,"   KeySym key_symbol,Image **image) {S
   static char      delta[MaxTextExtent] = "";     static const char      Digits[]="01234567890";i     static KeySym      last_symbol = XK_0;   3   if ((key_symbol >= XK_0) && (key_symbol <= XK_9))d     { <       if (!((last_symbol >= XK_0) && (last_symbol <= XK_9)))	         {e           *delta='\0';#           resource_info->quantum=1;s	         }        last_symbol=key_symbol;s"       delta[Extent(delta)+1]='\0';3       delta[Extent(delta)]=Digits[key_symbol-XK_0];i)       resource_info->quantum=atoi(delta);        return(NullCommand);     }e   last_symbol=key_symbol;t   if (resource_info->immutable)a     {a       /*<         Immutable image window has a restricted command set.       */       switch(key_symbol)       {          case XK_question:            return(InfoCommand);         case XK_p:         case XK_Print:           return(PrintCommand);          case XK_space:           return(NextCommand);         case XK_q:	         { %           if (!(state & ControlMask))e             break;           return(QuitCommand);	         }          default:           break;       }n       return(NullCommand);     }    switch (key_symbol)i   {,     case XK_o:     {;!       if (!(state & ControlMask))a         break;       return(OpenCommand);     }      case XK_space:       return(NextCommand);     case XK_BackSpace:       return(FormerCommand);     case XK_s:     {        if (state & Mod1Mask)i         return(SwirlCommand);,!       if (!(state & ControlMask))x         return(ShearCommand);        return(SaveCommand);     }(     case XK_p:     case XK_Print:     {        if (state & Mod1Mask)           return(OilPaintCommand);       if (state & Mod4Mask)n         return(ColorCommand);;!       if (!(state & ControlMask))          return(NullCommand);       return(PrintCommand);a     }-     case XK_d:     {o       if (state & Mod4Mask)          return(DrawCommand);!       if (!(state & ControlMask))e         return(NullCommand);       return(DeleteCommand);     }=     case XK_Select:L     { !       if (!(state & ControlMask))a         return(NullCommand);       return(SelectCommand);     }-     case XK_n:     {;!       if (!(state & ControlMask))i         return(NullCommand);       return(NewCommand);t     }(     case XK_q:     case XK_Cancel:a     {i!       if (!(state & ControlMask))c         return(NullCommand);       return(QuitCommand);     }      case XK_z:     case XK_Undo:n     {i!       if (!(state & ControlMask))          return(NullCommand);       return(UndoCommand);     }      case XK_r:     case XK_Redo:o     {t!       if (!(state & ControlMask))X         return(RollCommand);       return(RedoCommand);     }      case XK_x:     { !       if (!(state & ControlMask))          return(NullCommand);       return(CutCommand);      }      case XK_c:     {        if (state & Mod1Mask)s'         return(CharcoalDrawingCommand);a!       if (!(state & ControlMask))          return(CropCommand);       return(CopyCommand);     }      case XK_v:     case XK_Insert:;     {(       if (state & Mod4Mask)!!         return(CompositeCommand);G!       if (!(state & ControlMask))y         return(FlipCommand);       return(PasteCommand);a     }      case XK_less:t       return(HalfSizeCommand);     case XK_minus:"       return(OriginalSizeCommand);     case XK_greater:        return(DoubleSizeCommand);     case XK_percent:       return(ResizeCommand);     case XK_at:e       return(RefreshCommand);.     case XK_bracketleft:       return(ChopCommand);     case XK_h:       return(FlopCommand);     case XK_slash:!       return(RotateRightCommand);a     case XK_backslash:        return(RotateLeftCommand);     case XK_asterisk:e       return(RotateCommand);     case XK_t:       return(TrimCommand);     case XK_H:       return(HueCommand);      case XK_S:        return(SaturationCommand);     case XK_L:        return(BrightnessCommand);     case XK_G:       return(GammaCommand);[     case XK_C:       return(SpiffCommand);c     case XK_Z:       return(DullCommand);     case XK_equal:       return(EqualizeCommand);     case XK_N:       return(NormalizeCommand);-     case XK_asciitilde:n       return(NegateCommand);     case XK_period:d       return(GrayscaleCommand);      case XK_numbersign:i       return(QuantizeCommand);     case XK_F2:d       return(DespeckleCommand);      case XK_F3:-       return(EmbossCommand);     case XK_F4: !       return(ReduceNoiseCommand);f     case XK_F5:i       return(AddNoiseCommand);     case XK_F6:        return(SharpenCommand);t     case XK_F7:.       return(BlurCommand);     case XK_F8:*       return(ThresholdCommand);x     case XK_F9:x        return(EdgeDetectCommand);     case XK_F10:       return(SpreadCommand);     case XK_F11:       return(ShadeCommand);h     case XK_F12:       return(RaiseCommand);y     case XK_F13:       return(SegmentCommand);h     case XK_i:     {>       if (!(state & Mod1Mask))         return(NullCommand);       return(ImplodeCommand);f     }a     case XK_w:     {        if (!(state & Mod1Mask))         return(NullCommand);       return(WaveCommand);     }i     case XK_m:     {)       if (!(state & Mod4Mask))         return(NullCommand);       return(MatteCommand);      }s     case XK_b:     {e       if (!(state & Mod4Mask))         return(NullCommand);       return(AddBorderCommand);=     }s     case XK_f:     {e       if (!(state & Mod4Mask))         return(NullCommand);       return(AddFrameCommand);     }d     case XK_exclam:t     {        if (!(state & Mod4Mask))         return(NullCommand);       return(CommentCommand);-     }n     case XK_a:     {r       if (state & Mod1Mask)          return(ApplyCommand);)       if (state & Mod4Mask)n          return(AnnotateCommand);!       if (!(state & ControlMask))i         return(NullCommand);&       return(RegionofInterestCommand);     };     case XK_question:        return(InfoCommand);     case XK_plus:%       return(ZoomCommand);     case XK_P:     {        if (!(state & ShiftMask))          return(NullCommand);!       return(ShowPreviewCommand);      }      case XK_Execute:       return(LaunchCommand);     case XK_F1:        return(HelpCommand);     case XK_Find: )       return(BrowseDocumentationCommand);      case XK_Menu:      { .       XMapRaised(display,windows->command.id);       return(NullCommand);     }      case XK_Next:      case XK_Prior:     case XK_Home:      case XK_KP_Home:     { 9       XTranslateImage(display,windows,*image,key_symbol);        return(NullCommand);     }%     case XK_Up:%     case XK_KP_Up:     case XK_Down:%     case XK_KP_Down:     case XK_Left:o     case XK_KP_Left:     case XK_Right:     case XK_KP_Right:      {r       if (state & Mod1Mask)e	         {            RectangleInfoc             crop_info;             /*.             Trim one pixel from edge of image.           */           crop_info.x=0;           crop_info.y=0;7           crop_info.width=windows->image.ximage->width; 9           crop_info.height=windows->image.ximage->height;s@           if ((key_symbol == XK_Up) || (key_symbol == XK_KP_Up))
             {pC               if (resource_info->quantum >= (int) crop_info.height)a:                 resource_info->quantum=crop_info.height-1;7               crop_info.height-=resource_info->quantum; 
             }iD           if ((key_symbol == XK_Down) || (key_symbol == XK_KP_Down))
             {eQ               if (resource_info->quantum >= (int) (crop_info.height-crop_info.y))yF                 resource_info->quantum=crop_info.height-crop_info.y-1;2               crop_info.y+=resource_info->quantum;7               crop_info.height-=resource_info->quantum;T
             }oD           if ((key_symbol == XK_Left) || (key_symbol == XK_KP_Left))
             { B               if (resource_info->quantum >= (int) crop_info.width)9                 resource_info->quantum=crop_info.width-1; 6               crop_info.width-=resource_info->quantum;
             } F           if ((key_symbol == XK_Right) || (key_symbol == XK_KP_Right))
             {iP               if (resource_info->quantum >= (int) (crop_info.width-crop_info.x))E                 resource_info->quantum=crop_info.width-crop_info.x-1;r2               crop_info.x+=resource_info->quantum;6               crop_info.width-=resource_info->quantum;
             } =           if ((int) (windows->image.x+windows->image.width) >m$               (int) crop_info.width)B             windows->image.x=crop_info.width-windows->image.width;>           if ((int) (windows->image.y+windows->image.height) >%               (int) crop_info.height)(D             windows->image.y=crop_info.height-windows->image.height;>           XSetCropGeometry(display,windows,&crop_info,*image);>           windows->image.window_changes.width=crop_info.width;@           windows->image.window_changes.height=crop_info.height;E           XSetWindowBackgroundPixmap(display,windows->image.id,None); G           (void) XConfigureImage(display,resource_info,windows,*image);            return(NullCommand);	         } 9       XTranslateImage(display,windows,*image,key_symbol);        return(NullCommand);     }      default:       return(NullCommand);   }    return(NullCommand); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %%O %                                                                             %rO %                                                                             %aO +   X M a g i c k C o m m a n d                                               % O %                                                                             %rO %                                                                             %hO %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n % G %  Method XMagickCommand makes a transform to the image or Image windows: %  as specified by a user menu button or keyboard command. %e. %  The format of the XMagickCommand method is: %eK %      Image *XMagickCommand(Display *display,XResourceInfo *resource_info,yC %        XWindows *windows,const CommandType command,Image **image)* %g+ %  A description of each parameter follows:= % E %    o loaded_image:  Method XMagickCommand returns an image when the I %      user chooses 'Load Image' from the command menu.  Otherwise a nulln %      image is returned.p % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %iK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.o %n< %    o windows: Specifies a pointer to a XWindows structure. %t/ %    o command: Specifies a command to perform.g % G %    o image: Specifies a pointer to a Image structure;  XMagickCommand > %      may transform the image and return a new image pointer. %  %t */K static Image *XMagickCommand(Display *display,XResourceInfo *resource_info,m<   XWindows *windows,const CommandType command,Image **image) {m   char     *argv[10],     geometry[MaxTextExtent],$     modulate_factors[MaxTextExtent];     Imaget     *loaded_image;     ImageInfon     image_info;;     intn     status,l     x,     y;  
   static charp"     color[MaxTextExtent] = "gray";     unsigned int     height, 
     width;     /*     Process user command.    */(   XCheckRefreshWindows(display,windows);;   XImageCache(display,resource_info,windows,command,image);t%   argv[0]=resource_info->client_name;o   loaded_image=(Image *) NULL;C   windows->image.window_changes.width=windows->image.ximage->width; E   windows->image.window_changes.height=windows->image.ximage->height;x   GetImageInfo(&image_info);   switch (command)   {      case OpenCommand:a     {w       /*         Load image.        */C       loaded_image=XOpenImage(display,resource_info,windows,False);        break;     }      case NextCommand:      {        /*         Display next image.a       */E       XClientMessage(display,windows->image.id,windows->im_protocols,w,         windows->im_next_image,CurrentTime);       break;     }      case FormerCommand:s     {        /*         Display former image.o       */E       XClientMessage(display,windows->image.id,windows->im_protocols, .         windows->im_former_image,CurrentTime);       break;     }      case SelectCommand:      {n       /*         Select image."       */2       (void) chdir(resource_info->home_directory);B       loaded_image=XOpenImage(display,resource_info,windows,True);       break;     }      case SaveCommand:M     {e       /*         Save image.D       */>       status=XSaveImage(display,resource_info,windows,*image);       if (status == False)	         {;C           XNoticeWidget(display,windows,"Unable to write X image:",               (*image)->filename);           break;	         }        break;     }r     case PrintCommand:     {p       /*         Print image.       */?       status=XPrintImage(display,resource_info,windows,*image);        if (status != False)	         { C           XNoticeWidget(display,windows,"Unable to print X image:",               (*image)->filename);           break;	         }        break;     }      case DeleteCommand:      {        static chare'         filename[MaxTextExtent] = "\0";          /*         Delete image file.       */<       XFileBrowserWidget(display,windows,"Delete",filename);       if (*filename == '\0')         break;       status=remove(filename);       if (status != False)O         XNoticeWidget(display,windows,"Unable to delete image file:",filename);v       break;     }      case NewCommand:     {o       static charn         *format = "gradation",&         color[MaxTextExtent] = "gray",,         geometry[MaxTextExtent] = "640x480";         /*'         Query user for canvas geometry.e       */I       status=XDialogWidget(display,windows,"New","Enter image geometry:",S         geometry);       if (*geometry == '\0')         break;       if (!status)         format="xc";:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')(         break;       /*         Create canvas.       */G       FormatString(image_info.filename,"%.1024s:%.1024s",format,color); 4       (void) CloneString(&image_info.size,geometry);*       loaded_image=ReadImage(&image_info);E       XClientMessage(display,windows->image.id,windows->im_protocols,a,         windows->im_next_image,CurrentTime);       break;     }       case VisualDirectoryCommand:     {e       /*         Visual Image directory.u       */H       loaded_image=XVisualDirectoryImage(display,resource_info,windows);       break;     }f     case QuitCommand:      {        /*         Exit program.a       */'       if (!resource_info->confirm_exit)oG         XClientMessage(display,windows->image.id,windows->im_protocols, (           windows->im_exit,CurrentTime);
       else	         {            /*!             Confirm program exit.            */M           status=XConfirmWidget(display,windows,"Do you really want to exit", (             resource_info->client_name);           if (status > 0) K             XClientMessage(display,windows->image.id,windows->im_protocols,a,               windows->im_exit,CurrentTime);	         }-       break;     }.     case CutCommand:     {y       /*         Cut image.       */F       (void) XCropImage(display,resource_info,windows,*image,CutMode);       break;     }      case CopyCommand:e     {        /*         Copy image.f       */G       (void) XCropImage(display,resource_info,windows,*image,CopyMode);f       break;     }      case PasteCommand:     {>       /*         Paste image.       */?       status=XPasteImage(display,resource_info,windows,*image);w       if (status == False)	         { B           XNoticeWidget(display,windows,"Unable to paste X image",              (*image)->filename);           break;	         }l       break;     }u     case HalfSizeCommand:l     {        /*         Half image size.       */I       windows->image.window_changes.width=windows->image.ximage->width/2;sK       windows->image.window_changes.height=windows->image.ximage->height/2;oC       (void) XConfigureImage(display,resource_info,windows,*image);a       break;     }i     case OriginalSizeCommand:f     {o       /*         Original image size.       */<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;C       (void) XConfigureImage(display,resource_info,windows,*image);g       break;     }s     case DoubleSizeCommand:w     {e       /*         Double the image size.       */L       windows->image.window_changes.width=windows->image.ximage->width << 1;N       windows->image.window_changes.height=windows->image.ximage->height << 1;C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }l     case ResizeCommand:      {i       unsigned int         height,n         width;         /*         Resize image.a       */)       width=windows->image.ximage->width;v+       height=windows->image.ximage->height;.
       x=0;
       y=0;6       FormatString(geometry,"%ux%u+0+0",width,height);4       status=XDialogWidget(display,windows,"Resize",@         "Enter resize geometry (e.g. 640x480, 200%):",geometry);       if (*geometry == '\0')         break;       if (!status)$         (void) strcat(geometry,"!");?       (void) ParseImageGeometry(geometry,&x,&y,&width,&height);m0       windows->image.window_changes.width=width;2       windows->image.window_changes.height=height;C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }x     case ApplyCommand:     {;
       char&         image_geometry[MaxTextExtent];  <       if ((windows->image.crop_geometry == (char *) NULL) &&F           ((int) (*image)->columns == windows->image.ximage->width) &&D           ((int) (*image)->rows == windows->image.ximage->height) &&=           (resource_info->quantize_info->number_colors == 0))e         break;       /*'         Apply size transforms to image.n       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       /**         Crop and/or scale displayed image.       */H       FormatString(image_geometry,"%dx%d!",windows->image.ximage->width,'         windows->image.ximage->height);dH       TransformImage(image,windows->image.crop_geometry,image_geometry);8       if (windows->image.crop_geometry != (char *) NULL)	         { 3           FreeMemory(windows->image.crop_geometry);-5           windows->image.crop_geometry=(char *) NULL;a	         }t       windows->image.x=0;        windows->image.y=0; ;       if (resource_info->quantize_info->number_colors != 0)i	         {e           /*5             Reduce the number of colors in the image.i           */1           if (((*image)->class == DirectClass) ||nQ               ((*image)->colors > resource_info->quantize_info->number_colors) ||1K               (resource_info->quantize_info->colorspace == GRAYColorspace)) F             (void) QuantizeImage(resource_info->quantize_info,*image);	         }.D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }g     case RefreshCommand:     {oC       (void) XConfigureImage(display,resource_info,windows,*image);C       break;     }t     case RestoreCommand:     {;       /*2         Restore Image window to its original size.       */8       if ((windows->image.width == (*image)->columns) &&6           (windows->image.height == (*image)->rows) &&:           (windows->image.crop_geometry == (char *) NULL))	         {;           XBell(display,0);            break;	         }i<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;8       if (windows->image.crop_geometry != (char *) NULL)	         {.3           FreeMemory(windows->image.crop_geometry);h5           windows->image.crop_geometry=(char *) NULL;a           windows->image.x=0;m           windows->image.y=0;f	         } D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);I       break;     }o     case CropCommand:i     {i       /*         Crop image.e       */G       (void) XCropImage(display,resource_info,windows,*image,CropMode);m       break;     }e     case ChopCommand:      {        /*         Chop image.,       */=       status=XChopImage(display,resource_info,windows,image);_       if (status == False)	         { @           XNoticeWidget(display,windows,"Unable to cut X image",              (*image)->filename);           break;	         }        break;     }      case FlopCommand:      {        /*         Flop image scanlines.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-flop";;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False); 8       if (windows->image.crop_geometry != (char *) NULL)	         {            /*             Flop crop geometry.            */"           width=(*image)->columns;            height=(*image)->rows;C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,%             &width,&height);H           FormatString(windows->image.crop_geometry,"%ux%u%+d%+d",width,<             height,(int) (*image)->columns-(int) width-x,y);	         }d        if (windows->image.orphan)         break;C       (void) XConfigureImage(display,resource_info,windows,*image);d       break;     }e     case FlipCommand:f     {o       /*         Flip image scanlines.r       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-flip";;       MogrifyImage(resource_info->image_info,2,argv,image);1-       XSetCursorState(display,windows,False); 8       if (windows->image.crop_geometry != (char *) NULL)	         {f           /*             Flip crop geometry.o           */"           width=(*image)->columns;            height=(*image)->rows;C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,              &width,&height);H           FormatString(windows->image.crop_geometry,"%ux%u%+d%+d",width,:             height,x,(int) (*image)->rows-(int) height-y);	         }         if (windows->image.orphan)         break;C       (void) XConfigureImage(display,resource_info,windows,*image);M       break;     }      case RotateRightCommand:     {i       /**         Rotate image 90 degrees clockwise.       */D       status=XRotateImage(display,resource_info,windows,90.0,image);       if (status == False)	         { C           XNoticeWidget(display,windows,"Unable to rotate X image",               (*image)->filename);           break;	         }        break;     }T     case RotateLeftCommand:t     {;       /*2         Rotate image 90 degrees counter-clockwise.       */E       status=XRotateImage(display,resource_info,windows,-90.0,image);t       if (status == False)	         { C           XNoticeWidget(display,windows,"Unable to rotate X image",;              (*image)->filename);           break;	         }a       break;     }      case RotateCommand:m     {r       /*         Rotate image.=       */C       status=XRotateImage(display,resource_info,windows,0.0,image);        if (status == False)	         {;C           XNoticeWidget(display,windows,"Unable to rotate X image",               (*image)->filename);           break;	         }r       break;     }X     case ShearCommand:     {g       static charn.         geometry[MaxTextExtent] = "45.0x45.0";         /*0         Query user for shear color and geometry.       */:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')o         break;K       (void) XDialogWidget(display,windows,"Shear","Enter shear geometry:",m         geometry);       if (*geometry == '\0')         break;       /*         Shear image.       */N       (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-bordercolor";e       argv[2]=color;       argv[3]="-shear";n       argv[4]=geometry;e;       MogrifyImage(resource_info->image_info,5,argv,image);n-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }r     case RollCommand:      {        static charc)         geometry[MaxTextExtent] = "+2+2";          /*)         Query user for the roll geometry.        */I       (void) XDialogWidget(display,windows,"Roll","Enter roll geometry:",          geometry);       if (*geometry == '\0')         break;       /*         Roll image.        */N       (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-roll";       argv[2]=geometry;y;       MogrifyImage(resource_info->image_info,3,argv,image);t-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);m       break;     }.     case TrimCommand:n     {m       /*         Trim image.        */>       status=XTrimImage(display,resource_info,windows,*image);       if (status == False)	         {iA           XNoticeWidget(display,windows,"Unable to trim X image",               (*image)->filename);           break;	         }        break;     }      case HueCommand:     {x       static char )         hue_percent[MaxTextExtent] = "3";          /**         Query user for percent hue change.       */3       (void) XDialogWidget(display,windows,"Apply", :         "Enter percent change in image hue:",hue_percent);       if (*hue_percent == '\0')a         break;       /*         Vary the image hue.w       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);1       (void) strcpy(modulate_factors,"0.0/0.0/");o2       (void) strcat(modulate_factors,hue_percent);       argv[1]="-modulate";       argv[2]=modulate_factors;i;       MogrifyImage(resource_info->image_info,3,argv,image);d-       XSetCursorState(display,windows,False);U        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }o     case SaturationCommand:      {        static char 1         saturation_percent[MaxTextExtent] = "10";          /*1         Query user for percent saturation change.a       */3       (void) XDialogWidget(display,windows,"Apply", H         "Enter percent change in color saturation:",saturation_percent);&       if (*saturation_percent == '\0')         break;       /*         Vary color saturation.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);-       (void) strcpy(modulate_factors,"0.0/");g9       (void) strcat(modulate_factors,saturation_percent);t       argv[1]="-modulate";       argv[2]=modulate_factors;0;       MogrifyImage(resource_info->image_info,3,argv,image);u-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);e       break;     }_     case BrightnessCommand:      {        static char(0         brightness_percent[MaxTextExtent] = "3";         /*1         Query user for percent brightness change.        */3       (void) XDialogWidget(display,windows,"Apply", H         "Enter percent change in color brightness:",brightness_percent);&       if (*brightness_percent == '\0')         break;       /*"         Vary the color brightness.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);9       (void) strcpy(modulate_factors,brightness_percent);        argv[1]="-modulate";       argv[2]=modulate_factors;0;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);;       break;     }M     case GammaCommand:     {E       static charu&         factor[MaxTextExtent] = "1.6";         /*#         Query user for gamma value.        */3       (void) XDialogWidget(display,windows,"Gamma",>8         "Enter gamma value (e.g. 1.0/1.0/1.6):",factor);       if (*factor == '\0')         break;       /*         Gamma correct image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-gamma";        argv[2]=factor; ;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);e       break;     }      case SpiffCommand:     {p       /*#         Sharpen the image contrast.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-contrast";;       MogrifyImage(resource_info->image_info,2,argv,image);t-       XSetCursorState(display,windows,False);a        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);.       break;     }      case DullCommand:      {        /*          Dull the image contrast.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="+contrast";;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False);=        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }l     case EqualizeCommand:f     {.       /*4         Perform histogram equalization on the image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-equalize";;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }i     case NormalizeCommand:     {        /*5         Perform histogram normalization on the image.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-normalize";.;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);;       break;     }      case NegateCommand:r     {        /*         Negate colors in image.y       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-negate";;       MogrifyImage(resource_info->image_info,2,argv,image);:-       XSetCursorState(display,windows,False);r        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);e       break;     }f     case GrayscaleCommand:     {l       /*#         Convert image to grayscale.)       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-colorspace";       argv[2]="gray"; ;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);r        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);.       break;     })     case MapCommand:     {n       static char+'         filename[MaxTextExtent] = "\0";W         /**         Request image file name from user.       */9       XFileBrowserWidget(display,windows,"Map",filename);-       if (*filename == '\0')         break;       /*         Map image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-map";        argv[2]=filename;(;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case QuantizeCommand:o     {t       static char &         colors[MaxTextExtent] = "256";         /*0         Query user for maximum number of colors.       */6       status=XDialogWidget(display,windows,"Quantize",,         "Maximum number of colors:",colors);       if (*colors == '\0')         break;       /*         Color reduce the image.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-colors";       argv[2]=colors;t-       argv[3]=status ? "-dither" : "+dither";s;       MogrifyImage(resource_info->image_info,4,argv,image); -       XSetCursorState(display,windows,False);y        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }w     case DespeckleCommand:     {        /*         Despeckle image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-despeckle";t;       MogrifyImage(resource_info->image_info,2,argv,image);;-       XSetCursorState(display,windows,False);_        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);u       break;     }u     case EmbossCommand:S     {l       /*         Emboss image scanlines.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-emboss";;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False);x        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case ReduceNoiseCommand:     {        /*"         Reduce noise in the image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-noise"; ;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False);a        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }l     case AddNoiseCommand:      {        static char /         noise_type[MaxTextExtent] = "Gaussian";f         /*         Add noise to the image.        */E       XListBrowserWidget(display,windows,&windows->widget,NoiseTypes, O         "Add Noise","Select a type of noise to add to your image:",noise_type);f       if (*noise_type == '\0')         break;,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="+noise";        argv[2]=noise_type;m;       MogrifyImage(resource_info->image_info,3,argv,image);*-       XSetCursorState(display,windows,False);;        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }n     case SharpenCommand:     {t       static char '         factor[MaxTextExtent] = "60.0";;         /*&         Query user for sharpen factor.       */5       (void) XDialogWidget(display,windows,"Sharpen",f=         "Enter the sharpening factor (0.0 - 99.9%):",factor);a       if (*factor == '\0')         break;       /*          Sharpen image scanlines.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-sharpen";        argv[2]=factor;l;       MogrifyImage(resource_info->image_info,3,argv,image);e-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);l       break;     }_     case BlurCommand:U     {        static chard'         factor[MaxTextExtent] = "60.0";i         /*#         Query user for blur factor.        */2       (void) XDialogWidget(display,windows,"Blur",;         "Enter the blurring factor (0.0 - 99.9%):",factor);        if (*factor == '\0')         break;       /*         Blur an image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-blur";       argv[2]=factor;o;       MogrifyImage(resource_info->image_info,3,argv,image);e-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }(     case ThresholdCommand:     {b       static charr&         factor[MaxTextExtent] = "128";         /*'         Query user for threshold value.        */7       (void) XDialogWidget(display,windows,"Threshold", )         "Enter threshold value:",factor);n       if (*factor == '\0')         break;       /*         Gamma correct image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-threshold";u       argv[2]=factor; ;       MogrifyImage(resource_info->image_info,3,argv,image);%-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case EdgeDetectCommand:      {        static char '         factor[MaxTextExtent] = "60.0";          /*#         Query user for edge factor.        */:       (void) XDialogWidget(display,windows,"Detect Edges",>         "Enter the edge detect factor (0.0 - 99.9%):",factor);       if (*factor == '\0')         break;       /*         Detect edge in image.%       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-edge";       argv[2]=factor;a;       MogrifyImage(resource_info->image_info,3,argv,image);e-       XSetCursorState(display,windows,False);r        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);i       break;     }f     case SpreadCommand:u     {o       static chare$         amount[MaxTextExtent] = "2";         /*%         Query user for spread amount.o       */4       (void) XDialogWidget(display,windows,"Spread",1         "Enter the displacement amount:",amount);        if (*amount == '\0')         break;       /*1         Displace image pixels by a random amount.o       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-spread";       argv[2]=amount;o;       MogrifyImage(resource_info->image_info,3,argv,image);e-       XSetCursorState(display,windows,False);u        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);i       break;     }      case ShadeCommand:     {,       static char *         geometry[MaxTextExtent] = "30x30";         /**         Query user for the shade geometry.       */3       status=XDialogWidget(display,windows,"Shade", I         "Enter the azimuth and elevation of the light source:",geometry);s       if (*geometry == '\0')         break;       /*         Shade image pixels.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);+       argv[1]=status ? "-shade" : "+shade";m       argv[2]=geometry;e;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);n        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);p       break;     }      case RaiseCommand:     {u       static char *         bevel_width[MaxTextExtent] = "10";         /*#         Query user for bevel width.y       */O       (void) XDialogWidget(display,windows,"Raise","Bevel width:",bevel_width);g       if (*bevel_width == '\0')i         break;       /*         Raise an image.        */N       (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-raise";        argv[2]=bevel_width;;       MogrifyImage(resource_info->image_info,3,argv,image);,-       XSetCursorState(display,windows,False);d        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }r     case SegmentCommand:     {;       static char )         threshold[MaxTextExtent] = "1.5";g         /*+         Query user for smoothing threshold.        */L       (void) XDialogWidget(display,windows,"Segment","Smoothing threshold:",         threshold);o       if (*threshold == '\0')          break;       /*         Segment an image.m       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-segment";"       argv[2]=threshold;;       MogrifyImage(resource_info->image_info,3,argv,image);R-       XSetCursorState(display,windows,False);t        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);n       break;     }      case SolarizeCommand:e     {i       static chart%         factor[MaxTextExtent] = "60";,         /*'         Query user for solarize factor.        */6       (void) XDialogWidget(display,windows,"Solarize",9         "Enter the solarize factor (0 - 99.9%):",factor);;       if (*factor == '\0')         break;       /*         Solarize image pixels.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-solarize";       argv[2]=factor;w;       MogrifyImage(resource_info->image_info,3,argv,image);i-       XSetCursorState(display,windows,False);o        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);w       break;     }      case SwirlCommand:     {p       static char;&         degrees[MaxTextExtent] = "60";         /*#         Query user for swirl angle..       */L       (void) XDialogWidget(display,windows,"Swirl","Enter the swirl angle:",         degrees);d       if (*degrees == '\0')          break;       /*,         Swirl image pixels about the center.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-swirl";i       argv[2]=degrees;;       MogrifyImage(resource_info->image_info,3,argv,image);o-       XSetCursorState(display,windows,False);g        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }l     case ImplodeCommand:     {        static charg'         factor[MaxTextExtent] = "30.0";(         /*&         Query user for implode factor.       */5       (void) XDialogWidget(display,windows,"Implode", H         "Enter the implosion/explosion factor (-99.9 - 99.9%):",factor);       if (*factor == '\0')         break;       /*.         Implode image pixels about the center.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-implode";        argv[2]=factor; ;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);e       break;     }      case WaveCommand:      {R       static char +         geometry[MaxTextExtent] = "25x150";e         /**         Query user for the shade geometry.       */2       (void) XDialogWidget(display,windows,"Wave",@         "Enter the amplitude and length of the wave:",geometry);       if (*geometry == '\0')         break;       /*         Shade image pixels.s       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-wave";       argv[2]=geometry; ;       MogrifyImage(resource_info->image_info,3,argv,image);x-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);"       break;     }      case OilPaintCommand:0     {.       static char $         radius[MaxTextExtent] = "3";         /*4         Query user for circular neighborhood radius.       */7       (void) XDialogWidget(display,windows,"Oil Paint", )         "Enter the mask radius:",radius);        if (*radius == '\0')         break;       /*!         OilPaint image scanlines.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-paint";n       argv[2]=radius;o;       MogrifyImage(resource_info->image_info,3,argv,image);o-       XSetCursorState(display,windows,False);n        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }       case CharcoalDrawingCommand:     {        static char %         factor[MaxTextExtent] = "50";          /*#         Query user for bevel width.n       */>       (void) XDialogWidget(display,windows,"Charcoal Drawing",9         "Enter the charcoal factor (0 - 99.9%):",factor);-       if (*factor == '\0')         break;       /*         Raise an image.o       */N       (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-charcoal";       argv[2]=factor; ;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);%       break;     }      case AnnotateCommand:w     {x       /*%         Annotate the image with text..       */F       status=XAnnotateEditImage(display,resource_info,windows,*image);       if (status == False)	         {-E           XNoticeWidget(display,windows,"Unable to annotate X image",               (*image)->filename);           break;	         }        break;     }o     case DrawCommand:-     {        /*         Draw image.i       */A       status=XDrawEditImage(display,resource_info,windows,image);t       if (status == False)	         {sH           XNoticeWidget(display,windows,"Unable to draw on the X image",              (*image)->filename);           break;	         }        break;     },     case ColorCommand:     {d       /*         Color edit..       */B       status=XColorEditImage(display,resource_info,windows,image);       if (status == False)	         {tG           XNoticeWidget(display,windows,"Unable to pixel edit X image",e              (*image)->filename);           break;	         }        break;     }i     case MatteCommand:     {        /*         Matte edit.s       */B       status=XMatteEditImage(display,resource_info,windows,image);       if (status == False)	         {bG           XNoticeWidget(display,windows,"Unable to matte edit X image",               (*image)->filename);           break;	         }        break;     }p     case CompositeCommand:     {y       /*         Composite image.       */C       status=XCompositeImage(display,resource_info,windows,*image);        if (status == False)	         { F           XNoticeWidget(display,windows,"Unable to composite X image",              (*image)->filename);           break;	         }        break;     }(     case AddBorderCommand:     {z       static char (         geometry[MaxTextExtent] = "6x6";         /*1         Query user for border color and geometry.-       */:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')          break;8       (void) XDialogWidget(display,windows,"Add Border",+         "Enter border geometry:",geometry);        if (*geometry == '\0')         break;       /*"         Add a border to the image.       */N       (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-bordercolor";y       argv[2]=color;       argv[3]="-border";       argv[4]=geometry;i;       MogrifyImage(resource_info->image_info,5,argv,image);r-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }t     case AddFrameCommand:d     {        static char (         geometry[MaxTextExtent] = "6x6";         /*0         Query user for frame color and geometry.       */:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')w         break;O       (void) XDialogWidget(display,windows,"Add Frame","Enter frame geometry:",s         geometry);       if (*geometry == '\0')         break;       /*1         Surround image with an ornamental border.        */N       (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-mattecolor";       argv[2]=color;       argv[3]="-frame";f       argv[4]=geometry; ;       MogrifyImage(resource_info->image_info,5,argv,image);)-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);g       break;     }t     case CommentCommand:     {/       /*         Edit image comment.e       */-       TemporaryFilename(image_info.filename);g.       if ((*image)->comments != (char *) NULL)	         {(           FILE             *file;             register chars             *p;-  :           file=fopen(image_info.filename,WriteBinaryType);$           if (file == (FILE *) NULL)
             {sK               XNoticeWidget(display,windows,"Unable to edit image comment",t%                 image_info.filename);o               break;
             }g5           for (p=(*image)->comments; *p != '\0'; p++)='             (void) putc((int) *p,file);s!           (void) putc('\n',file);h           (void) fclose(file);	         }f,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);E       status=InvokeDelegate(&image_info,*image,"edit",(char *) NULL);        if (status != False)E         XNoticeWidget(display,windows,"Unable to edit image comment",m           (char *) NULL); 
       else	         {            char#             command[MaxTextExtent];m  ?           FormatString(command,"@%.1024s",image_info.filename);('           CommentImage(*image,command);n	         } )       (void) remove(image_info.filename);e-       XSetCursorState(display,windows,False);p       break;     }g     case LaunchCommand:g     {;       /*         Launch program.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);/       (void) strcpy((*image)->magick,"LAUNCH"); ,       TemporaryFilename((*image)->filename);,       status=WriteImage(&image_info,*image);       if (status != False)F         XNoticeWidget(display,windows,"Unable to launch image editor",           (char *) NULL);t
       else	         {n<           loaded_image=ReadImage(resource_info->image_info);I           XClientMessage(display,windows->image.id,windows->im_protocols,e0             windows->im_next_image,CurrentTime);	         }i(       (void) remove((*image)->filename);-       XSetCursorState(display,windows,False);        break;     }-!     case RegionofInterestCommand:      {        /*D         Apply an image processing technique to a region of interest.       */<       (void) XROIImage(display,resource_info,windows,image);       break;     }i     case InfoCommand:        break;     case ZoomCommand:e     {i       /*         Zoom image.i       */"       if (windows->magnify.mapped)2         XRaiseWindow(display,windows->magnify.id);
       else	         {d           /*             Make magnify image.r           */0           XSetCursorState(display,windows,True);2           XMapRaised(display,windows->magnify.id);1           XSetCursorState(display,windows,False); 	         }        break;     }      case ShowPreviewCommand:     {        static char .         preview_type[MaxTextExtent] = "Gamma";         register int
         i;         /*&         Select preview type from menu.       */G       XListBrowserWidget(display,windows,&windows->widget,PreviewTypes, I         "Preview","Select an enhancement, effect, or F/X:",preview_type);         if (*preview_type == '\0')         break;6       for (i=0; PreviewTypes[i] != (char *) NULL; i++)=         if (Latin1Compare(PreviewTypes[i],preview_type) == 0)%           break;+       if (PreviewTypes[i] == (char *) NULL)%	         { M           XNoticeWidget(display,windows,"unknown preview type",preview_type);n           break;	         }s       /*         Show image preview..       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);2       image_info.preview_type=(PreviewType) (i+1);)       image_info.group=windows->image.id;d#       LabelImage(*image,"Preview"); ,       TemporaryFilename((*image)->filename);3       status=WritePREVIEWImage(&image_info,*image);i-       (void) strcpy((*image)->magick,"SHOW");t,       status=WriteImage(&image_info,*image);       if (status) E         XNoticeWidget(display,windows,"Unable to show image preview",            (*image)->filename);       XDelay(display,1500);o-       XSetCursorState(display,windows,False);o       break;     }t     case ShowHistogramCommand:     {        /*         Show image histogram.r       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);)       image_info.group=windows->image.id;e%       LabelImage(*image,"Histogram");e,       TemporaryFilename((*image)->filename);5       status=WriteHISTOGRAMImage(&image_info,*image);t-       (void) strcpy((*image)->magick,"SHOW");i,       status=WriteImage(&image_info,*image);       if (status)sA         XNoticeWidget(display,windows,"Unable to show histogram",o           (*image)->filename);       XDelay(display,1500);h-       XSetCursorState(display,windows,False);r       break;     }e     case ShowMatteCommand:     {d       if (!(*image)->matte)o	         {i(           XNoticeWidget(display,windows,L             "Image does not have any matte information",(*image)->filename);           break;	         }s       /*         Show image matte.u       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);)       image_info.group=windows->image.id;y!       LabelImage(*image,"Matte");-,       TemporaryFilename((*image)->filename);1       status=WriteMATTEImage(&image_info,*image);g-       (void) strcpy((*image)->magick,"SHOW");/,       status=WriteImage(&image_info,*image);       if (status)-A         XNoticeWidget(display,windows,"Unable to show histogram",a           (*image)->filename);       XDelay(display,1500);t-       XSetCursorState(display,windows,False);w       break;     }e     case BackgroundCommand:i     {m       /*         Background image.        */C       status=XBackgroundImage(display,resource_info,windows,image);D       if (status == False)         break;L       loaded_image=CloneImage(*image,(*image)->columns,(*image)->rows,True);)       if (loaded_image != (Image *) NULL)iG         XClientMessage(display,windows->image.id,windows->im_protocols,d.           windows->im_next_image,CurrentTime);       break;     }W     case SlideShowCommand:     {        static chard#         delay[MaxTextExtent] = "5";1         /*)         Display next image after pausing.a       */       resource_info->delay=0; 8       (void) XDialogWidget(display,windows,"Slide Show",E         "Pause how many 1/100ths of a second between images:",delay);f       if (*delay == '\0')r         break;'       resource_info->delay=atoi(delay);RE       XClientMessage(display,windows->image.id,windows->im_protocols,e,         windows->im_next_image,CurrentTime);       break;     })     case PreferencesCommand:     {w       /*         Set user preferences.r       */?       status=XPreferencesWidget(display,resource_info,windows);        if (status == False)         break;L       loaded_image=CloneImage(*image,(*image)->columns,(*image)->rows,True);)       if (loaded_image != (Image *) NULL)nG         XClientMessage(display,windows->image.id,windows->im_protocols,v.           windows->im_next_image,CurrentTime);       break;     }a     case HelpCommand:a     {,       /*         User requested help.       */:       XTextViewWidget(display,resource_info,windows,False,-         "Help Viewer - Display",DisplayHelp);e       break;     } $     case BrowseDocumentationCommand:     {i
       Atom         mozilla_atom;n         Window         mozilla_window,          root_window;         /*-         Browse the ImageMagick documentation.n       */?       root_window=XRootWindow(display,XDefaultScreen(display));nA       mozilla_atom=XInternAtom(display,"_MOZILLA_VERSION",False);eI       mozilla_window=XWindowByProperty(display,root_window,mozilla_atom);t*       if (mozilla_window != (Window) NULL)	         {            char#             command[MaxTextExtent];M             /*@             Display documentation using Netscape remote control.           */E           FormatString(command,"openURL(%.1024s,new-window,noraise)",wE             "http://www.wizards.dupont.com/cristy/ImageMagick.html");wE           mozilla_atom=XInternAtom(display,"_MOZILLA_COMMAND",False);iJ           XChangeProperty(display,mozilla_window,mozilla_atom,XA_STRING,8,G             PropModeReplace,(unsigned char *) command,Extent(command));s1           XSetCursorState(display,windows,False);W           break;	         }g,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);G       status=InvokeDelegate(&image_info,*image,"browse",(char *) NULL);        if (status != False)G         XNoticeWidget(display,windows,"Unable to browse documentation",            (char *) NULL);        XDelay(display,1500); -       XSetCursorState(display,windows,False);        break;     }      case VersionCommand:     { C       XNoticeWidget(display,windows,MagickVersion,MagickCopyright);        break;     } !     case SaveToUndoBufferCommand:        break;     default:     {        XBell(display,0);        break;     }    }    return(loaded_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             %wO %                                                                             %pO %                                                                             %eO +   X M a g n i f y I m a g e                                                 %CO %                                                                             %oO %                                                                             %rO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %eD %  Method XMagnifyImage magnifies portions of the image as indicatedL %  by the pointer.  The magnified portion is displayed in a separate window. %e- %  The format of the XMagnifyImage method is:  % K %      void XMagnifyImage(Display *display,XWindows *windows,XEvent *event)e %p+ %  A description of each parameter follows:n %fE %    o display: Specifies a connection to an X server;  returned fromd %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. % H %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.o %m %) */K static void XMagnifyImage(Display *display,XWindows *windows,XEvent *event)D {i   char     text[MaxTextExtent];     register int     x,     y;     unsigned long 
     state;     /*>     Update magnified image until the mouse button is released.   */C   XDefineCursor(display,windows->image.id,windows->magnify.cursor);s   state=DefaultState;e   x=event->xbutton.x;    y=event->xbutton.y;a(   windows->magnify.x=windows->image.x+x;(   windows->magnify.y=windows->image.y+y;   do   {a     /*F       Map and unmap Info widget as text cursor crosses its boundaries.     */     if (windows->info.mapped)        { @         if ((x < (int) (windows->info.x+windows->info.width)) &&?             (y < (int) (windows->info.y+windows->info.height)))iI           XWithdrawWindow(display,windows->info.id,windows->info.screen);        }l     else>       if ((x > (int) (windows->info.x+windows->info.width)) ||=           (y > (int) (windows->info.y+windows->info.height))) -         XMapWindow(display,windows->info.id);      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */L         FormatString(text," %+d%+d ",windows->magnify.x,windows->magnify.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */(     XScreenEvent(display,windows,event);     switch (event->type)     {w       case ButtonPress:C         break;       case ButtonRelease:o       {o
         /*-           User has finished magnifying image.*
         */         x=event->xbutton.x;s         y=event->xbutton.y;d         state|=ExitState;,         break;       }l       case Expose:         break;       case MotionNotify:       {e         x=event->xmotion.x;=         y=event->xmotion.y;i         break;       }        default:         break;     }g     /*        Check boundary conditions.     */     if (x < 0)
       x=0;     else*       if (x >= (int) windows->image.width)!         x=windows->image.width-1;n     if (y < 0)
       y=0;     else*      if (y >= (int) windows->image.height)!        y=windows->image.height-1;a!   } while (!(state & ExitState));    /*     Display magnified image.   */)   XSetCursorState(display,windows,False);f }v . /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%dO %                                                                             %,O %                                                                             %hO %                                                                             % O +   X M a g n i f y W i n d o w C o m m a n d                                 % O %                                                                             % O %                                                                             %rO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l %iK %  Method XMagnifyWindowCommand moves the image within an Magnify window by , %  one pixel as specified by the key symbol. % 5 %  The format of the XMagnifyWindowCommand method is:, %dE %      void XMagnifyWindowCommand(Display *display,XWindows *windows,p: %        const unsigned int state,const KeySym key_symbol) % + %  A description of each parameter follows:e %oD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %/< %    o windows: Specifies a pointer to a XWindows structure. %  %    o state: key mask.  % M %    o key_symbol: Specifies a KeySym which indicates which side of the image  %      to trim.h %v %. */E static void XMagnifyWindowCommand(Display *display,XWindows *windows,o3   const unsigned int state,const KeySym key_symbol)v {.   unsigned int     quantum;     /*0     User specified a magnify factor or position.   */   quantum=1;   if (state & Mod1Mask)      quantum=10;    switch (key_symbol)i   {-     case QuitCommand:      {pK       XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);e       break;     }      case XK_Home:S     case XK_KP_Home:     { 0       windows->magnify.x=windows->image.width/2;1       windows->magnify.y=windows->image.height/2;s       break;     }      case XK_Left:o     case XK_KP_Left:     { !       if (windows->magnify.x > 0) $         windows->magnify.x-=quantum;       break;     }o     case XK_Up:v     case XK_KP_Up:     {s!       if (windows->magnify.y > 0)m$         windows->magnify.y-=quantum;       break;     }      case XK_Right:     case XK_KP_Right:      { >       if (windows->magnify.x < (int) (windows->image.width-1))$         windows->magnify.x+=quantum;       break;     }e     case XK_Down:t     case XK_KP_Down:     {r?       if (windows->magnify.y < (int) (windows->image.height-1))p$         windows->magnify.y+=quantum;       break;     }      case XK_0:     case XK_1:     case XK_2:     case XK_3:     case XK_4:     case XK_5:     case XK_6:     case XK_7:     case XK_8:     case XK_9:     {,=       windows->magnify.data=(unsigned int) (key_symbol-XK_0);        break;     }d     case XK_KP_0:      case XK_KP_1:T     case XK_KP_2:a     case XK_KP_3:d     case XK_KP_4:      case XK_KP_5:w     case XK_KP_6:"     case XK_KP_7:      case XK_KP_8:;     case XK_KP_9:      { @       windows->magnify.data=(unsigned int) (key_symbol-XK_KP_0);       break;     }e     default:       break;   } %   XMakeMagnifyImage(display,windows);g }t p /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %oO %                                                                             %rO +   X M a k e P a n I m a g e                                                 %.O %                                                                             %<O %                                                                             %dO %                                                                             %wO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%> %nK %  Method XMakePanImage creates a thumbnail of the image and displays it inw %  the Pan icon window.e %t- %  The format of the XMakePanImage method is:n %iJ %        void XMakePanImage(Display *display,XResourceInfo *resource_info,* %          XWindows *windows,Image *image) %e+ %  A description of each parameter follows:s %eE %    o display: Specifies a connection to an X server;  returned fromg %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.h % < %    o windows: Specifies a pointer to a XWindows structure. %.F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %t */H static void XMakePanImage(Display *display,XResourceInfo *resource_info,!   XWindows *windows,Image *image)  {e   unsigned int     status;e     /*.     Create and display image for panning icon.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);"   windows->pan.x=windows->image.x;"   windows->pan.y=windows->image.y;>   status=XMakeImage(display,resource_info,&windows->pan,image,,     windows->pan.width,windows->pan.height);   if (status == False)C     MagickWarning(XServerWarning,"Unable to create Pan icon image",        (char *) NULL); J   XSetWindowBackgroundPixmap(display,windows->pan.id,windows->pan.pixmap);(   XClearWindow(display,windows->pan.id);%   XDrawPanRectangle(display,windows);d)   XSetCursorState(display,windows,False);. }r i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(O %                                                                             %hO %                                                                             %WO %                                                                             % O +   X M a t t a E d i t I m a g e                                             % O %                                                                             %gO %                                                                             %tO %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %rA %  Method XMatteEditImage allows the user to interactively change M %  the Matte channel of an image.  If the image is PseudoClass it is promotedr9 %  to DirectClass before the matte information is stored.  % / %  The format of the XMatteEditImage method is:  % 5 %      unsigned int XMatteEditImage(Display *display, F %        XResourceInfo *resource_info,XWindows *windows,Image **image) % + %  A description of each parameter follows:d %mE %    o display: Specifies a connection to an X server;  returned from= %      XOpenDisplay. %dK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.M %M< %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %p */5 static unsigned int XMatteEditImage(Display *display,i?   XResourceInfo *resource_info,XWindows *windows,Image **image)a {:
   static chara     matte[MaxTextExtent] = "0";f     static const char.     *MatteEditMenu[]=i     {)       "Method",        "Border Color",h
       "Fuzz",n       "Matte Value",
       "Undo",(
       "Help",)       "Dismiss",       (char *) NULL      };     static const ModeType      MatteEditCommands[]=     {        MatteEditMethod,       MatteEditBorderCommand,        MatteEditFuzzCommand,)       MatteEditValueCommand,       MatteEditUndoCommand,)       MatteEditHelpCommand,        MatteEditDismissCommandi     };     static PaintMethod     method = PointMethod;f     static XColor %     border_color = { 0, 0, 0, 0, 0 };      char     command[MaxTextExtent],      text[MaxTextExtent];     Cursor     cursor;-     int 
     entry,     id,f     x,
     x_offset,g     y,
     y_offset;f     register int     i;     register PixelPacket     *p,t     *q;_     unsigned int     height, 
     width;     unsigned longf
     state;     XEvent
     event;     /*     Map Command widget.;   */%   windows->command.name="Matte Edit";s   windows->command.data=3;G   (void) XCommandWidget(display,windows,MatteEditMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*     Make cursor.   */K   cursor=XMakeCursor(display,windows->image.id,windows->map_info->colormap,,E     resource_info->background_color,resource_info->foreground_color); 2   XDefineCursor(display,windows->image.id,cursor);   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask ||     PointerMotionMask);    state=DefaultState;    do   {;     if (windows->info.mapped)e       {i
         /*#           Display pointer position.h
         */L         FormatString(text," %+d%+d ",x+windows->image.x,y+windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */)     XScreenEvent(display,windows,&event); 1     if (event.xany.window == windows->command.id)i       {x
         /*3           Select a command from the Command widget.d
         */@         id=XCommandWidget(display,windows,MatteEditMenu,&event);         if (id < 0)            {e<             XDefineCursor(display,windows->image.id,cursor);             continue;h           } &         switch (MatteEditCommands[id])	         {C           case MatteEditMethod:            {e             static const char                *MethodMenu[]=               {                  "point",                 "replace",                 "floodfill",                 "filltoborder",u                 "reset",                 (char *) NULL,               };               /*3               Select a method from the pop-up menu.              */             entry=P               XMenuWidget(display,windows,MatteEditMenu[id],MethodMenu,command);             if (entry >= 0)g)               method=(PaintMethod) entry;              break;           } &           case MatteEditBorderCommand:           {              char(               *ColorMenu[MaxNumberPens];               int                pen_number;o               /*)               Initialize menu selections.              */7             for (i=0; i < (int) (MaxNumberPens-2); i++) 8               ColorMenu[i]=resource_info->pen_colors[i];4             ColorMenu[MaxNumberPens-2]="Browser...";5             ColorMenu[MaxNumberPens-1]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */E             pen_number=XMenuWidget(display,windows,MatteEditMenu[id], 1               (const char **) ColorMenu,command);              if (pen_number < 0)                break;0             if (pen_number == (MaxNumberPens-2))               {e                 static chari5                   color_name[MaxTextExtent] = "gray";                    /*3                   Select a pen color from a dialog.n                 */A                 resource_info->pen_colors[pen_number]=color_name;-I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }u             /*               Set border color.b             */C             (void) XParseColor(display,windows->map_info->colormap,eC               resource_info->pen_colors[pen_number],&border_color);              break;           }+$           case MatteEditFuzzCommand:           {.             static char "               fuzz[MaxTextExtent];               static const char)               *FuzzMenu[]=               {                  "0",                 "2",                 "4",                 "8",                 "16",                  (char *) NULL,                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */$             FuzzMenu[5]="Dialog...";I             entry=XMenuWidget(display,windows,MatteEditMenu[id],FuzzMenu,(               command);f             if (entry < 0)               break;             if (entry != 5)p               { 5                 (*image)->fuzz=atoi(FuzzMenu[entry]);                  break;               }x5             (void) sprintf(fuzz,"%d",(*image)->fuzz); K             (void) XDialogWidget(display,windows,"Ok","Enter fuzz factor:",                fuzz);             if (*fuzz == '\0')               break;&             (*image)->fuzz=atoi(fuzz);             break;           }+%           case MatteEditValueCommand:|           {u             /*0               Request matte value from the user.             */N             (void) XDialogWidget(display,windows,"Matte","Enter matte value:",               matte);)             break;           }r$           case MatteEditUndoCommand:           { L             (void) XMagickCommand(display,resource_info,windows,UndoCommand,               image);C             break;           } $           case MatteEditHelpCommand:           {t@             XTextViewWidget(display,resource_info,windows,False,=               "Help Viewer - Matte Edit",ImageMatteEditHelp);x             break;           } '           case MatteEditDismissCommand:n           {)             /*               Prematurely exit.d             */             state|=EscapeState;g             state|=ExitState;;             break;           }            default:             break;	         }.8         XDefineCursor(display,windows->image.id,cursor);         continue;0       }      switch (event.type)      {.       case ButtonPress:x       { ,         if (event.xbutton.button != Button1)           break;:         if ((event.xbutton.window != windows->image.id) &&:             (event.xbutton.window != windows->magnify.id))           break;
         /*           Update matte data.
         */         x=event.xbutton.x;         y=event.xbutton.y;<         (void) XMagickCommand(display,resource_info,windows,)           SaveToUndoBufferCommand,image);a(         state|=UpdateConfigurationState;         break;       }v       case ButtonRelease:>       { ,         if (event.xbutton.button != Button1)           break;:         if ((event.xbutton.window != windows->image.id) &&:             (event.xbutton.window != windows->magnify.id))           break;
         /*&           Update colormap information.
         */         x=event.xbutton.x;         y=event.xbutton.y;F         XConfigureImageColormap(display,resource_info,windows,*image);E         (void) XConfigureImage(display,resource_info,windows,*image);;*         XInfoWidget(display,windows,text);8         XDefineCursor(display,windows->image.id,cursor);+         state&=(~UpdateConfigurationState);_         break;       }        case Expose:         break;       case KeyPress:       {d         char!           command[MaxTextExtent];e           KeySym           key_symbol;s  5         if (event.xkey.window == windows->magnify.id)g           {              Window               window;   '             window=windows->magnify.id; J             while (XCheckWindowEvent(display,window,KeyPressMask,&event));           } 3         if (event.xkey.window != windows->image.id)e           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),d/           &key_symbol,(XComposeStatus *) NULL);a         switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {S             /*               Prematurely exit.x             */             state|=ExitState;              break;           }            case XK_F1:B           case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,=               "Help Viewer - Matte Edit",ImageMatteEditHelp);:             break;           }            default:           {s             XBell(display,0);r             break;           }v	         }.         break;       }t       case MotionNotify:       {.
         /*E           Map and unmap Info widget as cursor crosses its boundaries.f
         */         x=event.xmotion.x;         y=event.xmotion.y;!         if (windows->info.mapped)W           {(D             if ((x < (int) (windows->info.x+windows->info.width)) &&C                 (y < (int) (windows->info.y+windows->info.height))).M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          elseB           if ((x > (int) (windows->info.x+windows->info.width)) ||A               (y > (int) (windows->info.y+windows->info.height)))r1             XMapWindow(display,windows->info.id);i         break;       }        default:         break;     },1     if (event.xany.window == windows->magnify.id)        {&.         x=windows->magnify.x-windows->image.x;.         y=windows->magnify.y-windows->image.y;       }x     x_offset=x;t     y_offset=y;a)     if (state & UpdateConfigurationState)t       {e         int            x,           y;  
         /*8           Matte edit is relative to image configuration.
         */I         XClearArea(display,windows->image.id,x_offset,y_offset,1,1,True); :         XPutPixel(windows->image.ximage,x_offset,y_offset,7           windows->pixel_info->background_color.pixel);s          width=(*image)->columns;         height=(*image)->rows;         x=0;         y=0;:         if (windows->image.crop_geometry != (char *) NULL)C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,              &width,&height);         x_offset=bK           width*(windows->image.x+x_offset)/windows->image.ximage->width+x;e         y_offset=WM           height*(windows->image.y+y_offset)/windows->image.ximage->height+y;=-         if ((x_offset < 0) || (y_offset < 0))!           continue; 4         if ((x_offset >= (int) (*image)->columns) ||/             (y_offset >= (int) (*image)->rows))t           continue;g$         (*image)->class=DirectClass;         if (!(*image)->matte)x$           MatteImage(*image,Opaque);         switch (method)a	         {e           case PointMethod:e           default:           {              /*=               Update matte information using point algorithm.f             */:             q=GetPixelCache(*image,x_offset,y_offset,1,1);*             if (q == (PixelPacket *) NULL)               break;*             q->opacity=atoi(matte) & 0xff;*             (void) SyncPixelCache(*image);             break;           }r           case ReplaceMethod:            {=             PixelPacket                target;e               /*?               Update matte information using replace algorithm.              */:             p=GetPixelCache(*image,x_offset,y_offset,1,1);*             if (p == (PixelPacket *) NULL)               break;             target=(*p);4             for (y=0; y < (int) (*image)->rows; y++)
             { >               q=GetPixelCache(*image,0,y,(*image)->columns,1);,               if (q == (PixelPacket *) NULL)                 break;9               for (x=0; x < (int) (*image)->columns; x++)                {*9                 if (ColorMatch(*q,target,(*image)->fuzz))C0                   q->opacity=atoi(matte) & 0xff;                 q++;               }_*               if (!SyncPixelCache(*image))                 break;
             }%             break;           }%           case FloodfillMethod: "           case FillToBorderMethod:           {              PixelPacket                target;                /*A               Update matte information using floodfill algorithm.              */:             p=GetPixelCache(*image,x_offset,y_offset,1,1);*             if (p == (PixelPacket *) NULL)               break;             target=(*p);-             if (method == FillToBorderMethod)                { 8                 target.red=XDownScale(border_color.red);<                 target.green=XDownScale(border_color.green);:                 target.blue=XDownScale(border_color.blue);               }%K             MatteFloodfillImage(*image,&target,atoi(matte) & 0xff,x_offset,o               y_offset,method);o             break;           }f           case ResetMethod::           {u             /*=               Update matte information using reset algorithm.i             */(             (*image)->class=DirectClass;4             for (y=0; y < (int) (*image)->rows; y++)
             {e>               q=SetPixelCache(*image,0,y,(*image)->columns,1);,               if (q == (PixelPacket *) NULL)                 break;9               for (x=0; x < (int) (*image)->columns; x++)X               { .                 q->opacity=atoi(matte) & 0xff;                 q++;               }o*               if (!SyncPixelCache(*image))                 break;
             }r/             if ((atoi(matte) & 0xff) == Opaque)a$               (*image)->matte=False;             break;           }s	         }D+         state&=(~UpdateConfigurationState);f       }c!   } while (!(state & ExitState));aO   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); )   XSetCursorState(display,windows,False);,   XFreeCursor(display,cursor);   return(True);, }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %dO %                                                                             % O %                                                                             %;O +   X O p e n I m a g e                                                       % O %                                                                             %eO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 0 %  Method XOpenImage loads an image from a file. %i* %  The format of the XOpenImage method is: %wF %     Image *XOpenImage(Display *display,XResourceInfo *resource_info,5 %       XWindows *windows,const unsigned int command)  %i+ %  A description of each parameter follows:  %/H %    o loaded_image: Method XOpenImage returns an image if can be loaded9 %      successfully.  Otherwise a null image is returned.P %tD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.o %n< %    o windows: Specifies a pointer to a XWindows structure. %mK %    o command: A value other than zero indicates that the file is selectedL+ %      from the command line argument list.; %  %i */G static Image *XOpenImage(Display *display,XResourceInfo *resource_info,_/   XWindows *windows,const unsigned int command)f {t   Imager     *loaded_image;     ImageInfoo     *image_info;     MonitorHandler     handler;  
   static chari#     filename[MaxTextExtent] = "\0";o     /*      Request file name from user.   */   if (!command)i8     XFileBrowserWidget(display,windows,"Open",filename);   else     {>
       char         **filelist,a         **files;  	       into         count,         status;p         register int
         i,
         j;         /*0         Select next image from the command line.       */B       status=XGetCommand(display,windows->image.id,&files,&count);       if (!status)	         { @           MagickWarning(XServerWarning,"Unable to select image","             "XGetCommand failed");!           return((Image *) NULL);x	         } >       filelist=(char **) AllocateMemory(count*sizeof(char *));%       if (filelist == (char **) NULL)d	         { F           MagickWarning(ResourceLimitWarning,"Unable to select image",(             "Memory allocation failed");!           XFreeStringList(files); !           return((Image *) NULL); 	         } 
       j=0;       for (i=1; i < count; i++)          if (*files[i] != '-')i!           filelist[j++]=files[i];         filelist[j]=(char *) NULL;:       XListBrowserWidget(display,windows,&windows->widget,J         (const char **) filelist,"Load","Select Image to Load:",filename);       FreeMemory(filelist);n       XFreeStringList(files);l     }    if (*filename == '\0')     return((Image *) NULL);p7   image_info=CloneImageInfo(resource_info->image_info); /   (void) strcpy(image_info->filename,filename); !   SetImageInfo(image_info,False); 1   if (Latin1Compare(image_info->magick,"X") == 0)      {t
       char         seconds[MaxTextExtent];          /*8         User may want to delay the X server screen grab.       */!       (void) strcpy(seconds,"0");eP       (void) XDialogWidget(display,windows,"Grab","Enter any delay in seconds:",         seconds);        if (*seconds == '\0')          return((Image *) NULL);s)       XDelay(display,1000*atoi(seconds));      }b8   if ((Latin1Compare(image_info->magick,"CMYK") == 0) ||8       (Latin1Compare(image_info->magick,"GRAY") == 0) ||7       (Latin1Compare(image_info->magick,"MAP") == 0) ||o9       (Latin1Compare(image_info->magick,"MATTE") == 0) ||M7       (Latin1Compare(image_info->magick,"RGB") == 0) ||u8       (Latin1Compare(image_info->magick,"RGBA") == 0) ||8       (Latin1Compare(image_info->magick,"TEXT") == 0) ||8       (Latin1Compare(image_info->magick,"TILE") == 0) ||8       (Latin1Compare(image_info->magick,"UYVY") == 0) ||6       (Latin1Compare(image_info->magick,"XC") == 0) ||5       (Latin1Compare(image_info->magick,"YUV") == 0))D     {[
       char          geometry[MaxTextExtent];         /*)         Request image size from the user.        */(       (void) strcpy(geometry,"512x512");,       if (image_info->size != (char *) NULL)1         (void) strcpy(geometry,image_info->size);rN       (void) XDialogWidget(display,windows,"Load","Enter the image geometry:",         geometry);5       (void) CloneString(&image_info->size,geometry);      }    /*     Load the image.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);/   (void) strcpy(image_info->filename,filename);     handler=(MonitorHandler) NULL;1   if (Latin1Compare(image_info->magick,"X") == 0) 5     handler=SetMonitorHandler((MonitorHandler) NULL);S%   loaded_image=ReadImage(image_info); 1   if (Latin1Compare(image_info->magick,"X") == 0);&     (void) SetMonitorHandler(handler);)   XSetCursorState(display,windows,False); %   if (loaded_image != (Image *) NULL)dC     XClientMessage(display,windows->image.id,windows->im_protocols,p*       windows->im_next_image,CurrentTime);   else     {s
       char         *text,         **textlist;   
       FILE         *file;  	       int&
         c;         register charx         *p;c         unsigned int         length;          /*         Unknown image format..       */(       file=(FILE *) fopen(filename,"r");        if (file == (FILE *) NULL)         return((Image *) NULL);        length=MaxTextExtent; 8       text=(char *) AllocateMemory(length*sizeof(char));/       for (p=text ; text != (char *) NULL; p++)        {          c=fgetc(file);         if (c == EOF)            break;'         if ((p-text+1) >= (int) length)[           {              *p='\0';             length<<=1; N             text=(char *) ReallocateMemory((char *) text,length*sizeof(char));&             if (text == (char *) NULL)               break;              p=text+Extent(text);           }          *p=(unsigned char) c;        }a       (void) fclose(file);        if (text == (char *) NULL)         return((Image *) NULL);o       *p='\0';"       textlist=StringToList(text);%       if (textlist != (char **) NULL)=	         {(           char!             title[MaxTextExtent];              register int             i;  A           FormatString(title,"Unknown format: %.1024s",filename); C           XTextViewWidget(display,resource_info,windows,True,title, &             (const char **) textlist);6           for (i=0; textlist[i] != (char *) NULL; i++)$             FreeMemory(textlist[i]);           FreeMemory(textlist); 	         }        FreeMemory(text);      }0   DestroyImageInfo(image_info);    return(loaded_image);C }t t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             % O %                                                                             %eO %                                                                             %BO +   X P a n I m a g e                                                         % O %                                                                             % O %                                                                             %cO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method XPanImage pans the image until the mouse button is released. % ) %  The format of the XPanImage method is:i %,G %      void XPanImage(Display *display,XWindows *windows,XEvent *event)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %c< %    o windows: Specifies a pointer to a XWindows structure. %rH %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.  %  */G static void XPanImage(Display *display,XWindows *windows,XEvent *event)  {    char     text[MaxTextExtent];     Cursor     cursor;      double
     x_factor,H
     y_factor;      RectangleInfoa
     pan_info;      unsigned long 
     state;     /*     Define cursor.   */D   if ((windows->image.ximage->width > (int) windows->image.width) &&D       (windows->image.ximage->height > (int) windows->image.height))/     cursor=XCreateFontCursor(display,XC_fleur);a   elseB     if (windows->image.ximage->width > (int) windows->image.width)=       cursor=XCreateFontCursor(display,XC_sb_h_double_arrow);      elseF       if (windows->image.ximage->height > (int) windows->image.height)?         cursor=XCreateFontCursor(display,XC_sb_v_double_arrow); 
       else3         cursor=XCreateFontCursor(display,XC_arrow); 0   XDefineCursor(display,windows->pan.id,cursor);   /*B     Pan image as pointer moves until the mouse button is released.   */D   x_factor=(double) windows->image.ximage->width/windows->pan.width;F   y_factor=(double) windows->image.ximage->height/windows->pan.height;   pan_info.width=eI     windows->pan.width*windows->image.width/windows->image.ximage->width;(   pan_info.height=L     windows->pan.height*windows->image.height/windows->image.ximage->height;!   state=UpdateConfigurationState;    do   {d     switch (event->type)     {l       case ButtonPress:        {i
         /*.           User choose an initial pan location.
         */$         pan_info.x=event->xbutton.x;$         pan_info.y=event->xbutton.y;(         state|=UpdateConfigurationState;         break;       };       case ButtonRelease:        { 
         /*.           User has finished panning the image.
         */$         pan_info.x=event->xbutton.x;$         pan_info.y=event->xbutton.y;4         state|=UpdateConfigurationState | ExitState;         break;       }        case MotionNotify:       { $         pan_info.x=event->xmotion.x;$         pan_info.y=event->xmotion.y;(         state|=UpdateConfigurationState;       }c       default:         break;     } )     if (state & UpdateConfigurationState)a       {h
         /*$           Check boundary conditions.
         */2         if (pan_info.x < (int) (pan_info.width/2))           pan_info.x=0;d         else>           pan_info.x=x_factor*(pan_info.x-(pan_info.width/2));         if (pan_info.x < 0)f           pan_info.x=0;          else7           if ((int) (pan_info.x+windows->image.width) > +               windows->image.ximage->width) I             pan_info.x=windows->image.ximage->width-windows->image.width; 3         if (pan_info.y < (int) (pan_info.height/2))'           pan_info.y=0;;         else?           pan_info.y=y_factor*(pan_info.y-(pan_info.height/2));          if (pan_info.y < 0)a           pan_info.y=0;          else8           if ((int) (pan_info.y+windows->image.height) >,               windows->image.ximage->height)K             pan_info.y=windows->image.ximage->height-windows->image.height; /         if ((windows->image.x != pan_info.x) ||i-             (windows->image.y != pan_info.y))a           {I             /*'               Display image pan offset.w             */(             windows->image.x=pan_info.x;(             windows->image.y=pan_info.y;C             FormatString(text," %ux%u%+d%+d ",windows->image.width, G               windows->image.height,windows->image.x,windows->image.y);E.             XInfoWidget(display,windows,text);             /*#               Refresh Image window.              *//             XDrawPanRectangle(display,windows); D             XRefreshWindow(display,&windows->image,(XEvent *) NULL);           }e+         state&=(~UpdateConfigurationState);n       }.     /*       Wait for next event.     */     if (!(state & ExitState))!*       XScreenEvent(display,windows,event);!   } while (!(state & ExitState));    /*     Restore cursor.v   */=   XDefineCursor(display,windows->pan.id,windows->pan.cursor);a   XFreeCursor(display,cursor);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);p }:   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_O %                                                                             %rO %                                                                             % O %                                                                             %cO +   X P a s t e I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             %;O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method XPasteImage pastes an image previously saved with XCropImageI %  in the X window image at a location the user chooses with the pointer.  %a+ %  The format of the XPasteImage method is:  % N %      unsigned int XPasteImage(Display *display,XResourceInfo *resource_info,( %        XWindows *windows,Image *image) % + %  A description of each parameter follows:  %*> %    o status: Method XPasteImage returns True if the image isI %      pasted.  False is returned is there is a memory shortage or if then  %      image fails to be pasted. %iE %    o display: Specifies a connection to an X server;  returned fromf %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. %sE %    o image: Specifies a pointer to a Image structure; returned fromi %      ReadImage.w %i */N static unsigned int XPasteImage(Display *display,XResourceInfo *resource_info,!   XWindows *windows,Image *image)w {o   static const char      *PasteMenu[]=      {        "Operator",!
       "Help",a       "Dismiss",       (char *) NULLs     };     static const ModeTypea     PasteCommands[]=     {W       PasteOperatorsCommand,       PasteHelpCommand,r       PasteDismissCommanda     };     static CompositeOperator#     operation = ReplaceCompositeOp;      char     text[MaxTextExtent];     Cursor     cursor;e     double     scale_factor;      Image.     *paste_image;f     int      id,i     x,     y;     RectangleInfo      highlight_info,y     paste_info;l     unsigned int     height,_
     width;     unsigned longd
     state;     XEvent
     event;     /*     Copy image.y   */2   if (resource_info->copy_image == (Image *) NULL)     return(False);3   paste_image=CloneImage(resource_info->copy_image,(M     resource_info->copy_image->columns,resource_info->copy_image->rows,True);    /*     Map Command widget.t   */    windows->command.name="Paste";   windows->command.data=1;C   (void) XCommandWidget(display,windows,PasteMenu,(XEvent *) NULL);t*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);s   /*,     Track pointer until button 1 is pressed.   */)   XSetCursorState(display,windows,False);,2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask); "   paste_info.x=windows->image.x+x;"   paste_info.y=windows->image.y+y;   paste_info.width=0;i   paste_info.height=0;0   cursor=XCreateFontCursor(display,XC_ul_angle);B   XSetFunction(display,windows->image.highlight_context,GXinvert);   state=DefaultState;)   do   {      if (windows->info.mapped)w       { 
         /*#           Display pointer position.g
         */@         FormatString(text," %+d%+d ",paste_info.x,paste_info.y);*         XInfoWidget(display,windows,text);       }f     highlight_info=paste_info;3     highlight_info.x=paste_info.x-windows->image.x;e3     highlight_info.y=paste_info.y-windows->image.y;a2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);     /*       Wait for next event.     */)     XScreenEvent(display,windows,&event); 2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);1     if (event.xany.window == windows->command.id)e       {n
         /*3           Select a command from the Command widget.w
         */<         id=XCommandWidget(display,windows,PasteMenu,&event);         if (id < 0)-           continue;e"         switch (PasteCommands[id])	         { %           case PasteOperatorsCommand:p           {              char%               command[MaxTextExtent];n               static const char                *OperatorMenu[]=               {                  "Over",                  "In",r                 "Out",                 "Atop",                  "Xor",                 "Plus",&                 "Minus",                 "Add",                 "Subtract",                  "Difference",                  "Bumpmap",                 "Replace",                 "ReplaceRed",i                 "ReplaceGreen",n                 "ReplaceBlue",                 "ReplaceMatte",                  (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */G             operation=(CompositeOperator) (XMenuWidget(display,windows,f5               PasteMenu[id],OperatorMenu,command)+1);(             break;           }>            case PasteHelpCommand:           { @             XTextViewWidget(display,resource_info,windows,False,@               "Help Viewer - Image Compositing",ImagePasteHelp);             break;           }d#           case PasteDismissCommand:l           {c             /*               Prematurely exit.s             */             state|=EscapeState;              state|=ExitState;*             break;           }f           default:             break;	         }=         continue;t       }l     switch (event.type)      {        case ButtonPress:(       {.!         if (resource_info->debug) B           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y);i,         if (event.xbutton.button != Button1)           break;6         if (event.xbutton.window != windows->image.id)           break;
         /*=           Paste rectangle is relative to image configuration. 
         */         width=image->columns;n         height=image->rows;S         x=0;         y=0;:         if (windows->image.crop_geometry != (char *) NULL)C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,o             &width,&height);A         scale_factor=(double) windows->image.ximage->width/width;h;         paste_info.width=scale_factor*paste_image->columns;dC         scale_factor=(double) windows->image.ximage->height/height;L9         paste_info.height=scale_factor*paste_image->rows; 8         XDefineCursor(display,windows->image.id,cursor);6         paste_info.x=windows->image.x+event.xbutton.x;6         paste_info.y=windows->image.y+event.xbutton.y;         break;       }l       case ButtonRelease:        { !         if (resource_info->debug))D           (void) fprintf(stderr,"Button Release: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y);a,         if (event.xbutton.button != Button1)           break;6         if (event.xbutton.window != windows->image.id)           break;@         if ((paste_info.width != 0) && (paste_info.height != 0))           {e             /*@               User has selected the location of the paste image.             */:             paste_info.x=windows->image.x+event.xbutton.x;:             paste_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;            }          break;       }1       case Expose:         break;       case KeyPress:       {          char!           command[MaxTextExtent];o           KeySym           key_symbol;d           int            length;e  3         if (event.xkey.window != windows->image.id)g           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),t/           &key_symbol,(XComposeStatus *) NULL);R         *(command+length)='\0';*!         if (resource_info->debug) S           (void) fprintf(stderr,"Key press: 0x%lx (%.1024s)\n",key_symbol,command);f         switch (key_symbol) 	         {l           case XK_Escape:            case XK_F20:           {t             /*               Prematurely exit.t             */&             DestroyImage(paste_image);             state|=EscapeState;              state|=ExitState;l             break;           }            case XK_F1:g           case XK_Help:e           { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,@               "Help Viewer - Image Compositing",ImagePasteHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {;             XBell(display,0);o             break;           }o	         }t         break;       }z       case MotionNotify:       {i
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */         x=event.xmotion.x;         y=event.xmotion.y;!         if (windows->info.mapped)a           { D             if ((x < (int) (windows->info.x+windows->info.width)) &&C                 (y < (int) (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);2           }n         elseB           if ((x > (int) (windows->info.x+windows->info.width)) ||A               (y > (int) (windows->info.y+windows->info.height)))m1             XMapWindow(display,windows->info.id);o(         paste_info.x=windows->image.x+x;(         paste_info.y=windows->image.y+y;         break;       }b       default:       {r!         if (resource_info->debug)b?           (void) fprintf(stderr,"Event type: %d\n",event.type);          break;       };     } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); @   XSetFunction(display,windows->image.highlight_context,GXcopy);)   XSetCursorState(display,windows,False);o   XFreeCursor(display,cursor);   if (state & EscapeState)     return(True);    /*5     Image pasting is relative to image configuration.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   width=image->columns;    height=image->rows;>   x=0;   y=0;4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=(double) width/windows->image.ximage->width;    paste_info.x+=x;)   paste_info.x=scale_factor*paste_info.x; 1   paste_info.width=scale_factor*paste_info.width;n=   scale_factor=(double) height/windows->image.ximage->height;2   paste_info.y+=y;6   paste_info.y=scale_factor*paste_info.y*scale_factor;3   paste_info.height=scale_factor*paste_info.height;0   /*$     Paste image with X Image window.   */H   CompositeImage(image,operation,paste_image,paste_info.x,paste_info.y);   DestroyImage(paste_image);)   XSetCursorState(display,windows,False);g   /*     Update image colormap.   */?   XConfigureImageColormap(display,resource_info,windows,image);g>   (void) XConfigureImage(display,resource_info,windows,image);   return(True);( }i d /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %eO %                                                                             % O %                                                                             % O +   X P r i n t I m a g e                                                     %lO %                                                                             %_O %                                                                             % O %                                                                             %_O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %t> %  Method XPrintImage prints an image to a Postscript printer. % + %  The format of the XPrintImage method is:g %xN %      unsigned int XPrintImage(Display *display,XResourceInfo *resource_info,( %        XWindows *windows,Image *image) %a+ %  A description of each parameter follows:  % > %    o status: Method XPrintImage return False if the image isI %      printed.  True is returned is there is a memory shortage or if the  %      image fails to print. %yD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %)K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.o %i< %    o windows: Specifies a pointer to a XWindows structure. %MF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */N static unsigned int XPrintImage(Display *display,XResourceInfo *resource_info,!   XWindows *windows,Image *image)i {e   char     geometry[MaxTextExtent];     Imagea     *print_image;n     ImageInfo      *image_info;     unsigned int     status;<     /*/     Request Postscript page geometry from user.i   */7   image_info=CloneImageInfo(resource_info->image_info);r"   FormatString(geometry,"Letter");(   if (image_info->page != (char *) NULL)-     (void) strcpy(geometry,image_info->page);hI   XListBrowserWidget(display,windows,&windows->widget,PageSizes,"Select",a1     "Select Postscript Page Geometry:",geometry);    if (*geometry == '\0')     return(False);0   image_info->page=PostscriptGeometry(geometry);   /*     Apply image transforms.r   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);@   print_image=CloneImage(image,image->columns,image->rows,True);$   if (print_image == (Image *) NULL)     return(True);)>   FormatString(geometry,"%dx%d!",windows->image.ximage->width,#     windows->image.ximage->height);;E   TransformImage(&print_image,windows->image.crop_geometry,geometry); 7   if (resource_info->quantize_info->number_colors != 0)r     {.       /*1         Reduce the number of colors in the image.o       */0       if ((print_image->class == DirectClass) ||P           (print_image->colors > resource_info->quantize_info->number_colors) ||G           (resource_info->quantize_info->colorspace == GRAYColorspace))eG         (void) QuantizeImage(resource_info->quantize_info,print_image);w     }    /*     Print image.   */2   TemporaryFilename(print_image->magick_filename);0   (void) strcpy(print_image->filename,"print:");<   TemporaryFilename(print_image->filename+strlen("print:"));,   status=WriteImage(image_info,print_image);   DestroyImage(print_image);   DestroyImageInfo(image_info); )   XSetCursorState(display,windows,False);m   return(status);  }r i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %.O %                                                                             %iO %                                                                             %iO +   X R O I I m a g e                                                         %;O %                                                                             %rO %                                                                             %iO %                                                                             %<O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %wE %  Method XROIImage applies an image processing technique to a regionr %  of interest.. %<) %  The format of the XROIImage method is:. %(L %      unsigned int XROIImage(Display *display,XResourceInfo *resource_info,) %        XWindows *windows,Image **image)l %n+ %  A description of each parameter follows:l %n< %    o status: Method XROIImage returns True if the image isJ %      cropped.  False is returned is there is a memory shortage or if the! %      image fails to be cropped.n %iD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %rK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.o %p< %    o windows: Specifies a pointer to a XWindows structure. %tE %    o image: Specifies a pointer to a Image structure; returned fromn %      ReadImage.X %w %g */L static unsigned int XROIImage(Display *display,XResourceInfo *resource_info,"   XWindows *windows,Image **image) {a #define ApplyMenus  7t     static const char/     *ROIMenu[]=m     {r
       "Help",o       "Dismiss",       (char *) NULLX     },     *ApplyMenu[]=u     {o
       "File",)
       "Edit",t       "Transform",       "Enhance",       "Effects",       "F/X",       "Miscellany",m
       "Help",%       "Dismiss",       (char *) NULL%     },     *FileMenu[]=     {S       "Save...",       "Print...",        (char *) NULL      },     *EditMenu[]=     { 
       "Undo", 
       "Redo",        (char *) NULL      },     *TransformMenu[]=      { 
       "Flop", 
       "Flip",        "Rotate Right",        "Rotate Left",       (char *) NULL      },     *EnhanceMenu[]=      {        "Hue...",        "Saturation...",       "Brightness...",       "Gamma...",        "Spiff",
       "Dull",        "Equalize",        "Normalize",       "Negate",        "Grayscale",       "Map...",        "Quantize...",       (char *) NULL%     },     *EffectsMenu[]=%     {%       "Despeckle",       "Emboss",        "Reduce Noise",t       "Add Noise",       "Sharpen...",.       "Blur...",       "Threshold...",m       "Edge Detect...",w       "Spread...",       "Shade...",p       "Raise...",w       "Segment...",r       (char *) NULLc     },     *FXMenu[]=     {X       "Solarize...",       "Swirl...",s       "Implode...",d       "Wave...",       "Oil Painting...",       "Charcoal Drawing...",       (char *) NULLe     },     *MiscellanyMenu[]=     {.       "Image Info",        "Zoom Image",o       "Show Preview...",       "Show Histogram",a       "Show Matte",        (char *) NULLn     };     static const char_     **Menus[ApplyMenus]=     {        FileMenu,        EditMenu,m       TransformMenu,       EnhanceMenu,       EffectsMenu,
       FXMenu,w       MiscellanyMenu     };     static const CommandType     ApplyCommands[]=     {e       NullCommand,       NullCommand,       NullCommand,       NullCommand,       NullCommand,       NullCommand,       NullCommand,       HelpCommand,       QuitCommandw     },     FileCommands[]=o     {=       SaveCommand,       PrintCommand     },     EditCommands[]=e     {.       UndoCommand,       RedoCommand>     },     TransformCommands[]=     {i       FlopCommand,       FlipCommand,       RotateRightCommand,w       RotateLeftCommand%     },     EnhanceCommands[]=     {%       HueCommand,%       SaturationCommand,       BrightnessCommand,       GammaCommand,        SpiffCommand,        DullCommand,       EqualizeCommand,       NormalizeCommand,        NegateCommand,       GrayscaleCommand,        MapCommand,        QuantizeCommand      },     EffectsCommands[]=     {        DespeckleCommand,        EmbossCommand,       ReduceNoiseCommand,        AddNoiseCommand,       SharpenCommand,        BlurCommand,       EdgeDetectCommand,       SpreadCommand,       ShadeCommand,        RaiseCommand,        SegmentCommand     },     FXCommands[]=      {%       SolarizeCommand,       SwirlCommand,%       ImplodeCommand,%       WaveCommand,       OilPaintCommand,       CharcoalDrawingCommand     },     MiscellanyCommands[]=o     {d       InfoCommand,       ZoomCommand,       ShowPreviewCommand,        ShowHistogramCommand,a       ShowMatteCommand     },     ROICommands[]=     {        ROIHelpCommand,y       ROIDismissCommandy     };     static const CommandType     *Commands[ApplyMenus]=     {p       FileCommands,t       EditCommands,e       TransformCommands,       EnhanceCommands,       EffectsCommands,       FXCommands,e       MiscellanyCommands     };     char     command[MaxTextExtent],t     text[MaxTextExtent];  
   CommandTypeo     command_type;      Cursor     cursor;e     double     scale_factor;e     Imagec     *roi_image;a     inte
     entry,     id,e     x,     y;     MonitorHandler     handler;     RectangleInfoy     crop_info,     highlight_info,n
     roi_info;o     unsigned int     height,*
     width;     unsigned longe
     state;     XEvent
     event;     /*     Map Command widget.u   */   windows->command.name="ROI";   windows->command.data=0;A   (void) XCommandWidget(display,windows,ROIMenu,(XEvent *) NULL);e*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols,o+     windows->im_update_widget,CurrentTime);i   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |r     PointerMotionMask);i    roi_info.x=windows->image.x+x;    roi_info.y=windows->image.y+y;   roi_info.width=0;    roi_info.height=0;-   cursor=XCreateFontCursor(display,XC_fleur);i   state=DefaultState;i   do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position.e
         */<         FormatString(text," %+d%+d ",roi_info.x,roi_info.y);*         XInfoWidget(display,windows,text);       }a     /*       Wait for next event.     */)     XScreenEvent(display,windows,&event); 1     if (event.xany.window == windows->command.id)r       {r
         /*3           Select a command from the Command widget. 
         */:         id=XCommandWidget(display,windows,ROIMenu,&event);         if (id < 0)e           continue;a          switch (ROICommands[id])	         {c           case ROIHelpCommand:           { @             XTextViewWidget(display,resource_info,windows,False,?               "Help Viewer - Region of Interest",ImageROIHelp);c             break;           }e!           case ROIDismissCommand::           {s             /*               Prematurely exit.S             */             state|=EscapeState;              state|=ExitState;a             break;           }C           default:             break;	         }a         continue;C       }      switch (event.type)      {R       case ButtonPress:a       {L,         if (event.xbutton.button != Button1)           break;6         if (event.xbutton.window != windows->image.id)           break;
         /*H           Note first corner of region of interest rectangle-- exit loop.
         */8         XDefineCursor(display,windows->image.id,cursor);4         roi_info.x=windows->image.x+event.xbutton.x;4         roi_info.y=windows->image.y+event.xbutton.y;         state|=ExitState;          break;       }        case ButtonRelease::         break;       case Expose:         break;       case KeyPress:       {          KeySym           key_symbol;t  3         if (event.xkey.window != windows->image.id)o           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);o         switch (key_symbol)a	         {a           case XK_Escape:a           case XK_F20:           {i             /*               Prematurely exit.u             */             state|=EscapeState;              state|=ExitState;d             break;           }d           case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,?               "Help Viewer - Region of Interest",ImageROIHelp);e             break;           }            default:           {t             XBell(display,0);              break;           } 	         }i         break;       }        case MotionNotify:       {)
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */         x=event.xmotion.x;         y=event.xmotion.y;!         if (windows->info.mapped)2           { D             if ((x < (int) (windows->info.x+windows->info.width)) &&C                 (y < (int) (windows->info.y+windows->info.height)))uM               XWithdrawWindow(display,windows->info.id,windows->info.screen);a           }          elseB           if ((x > (int) (windows->info.x+windows->info.width)) ||A               (y > (int) (windows->info.y+windows->info.height)))m1             XMapWindow(display,windows->info.id); &         roi_info.x=windows->image.x+x;&         roi_info.y=windows->image.y+y;         break;       }c       default:         break;     } !   } while (!(state & ExitState));oO   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);h   if (state & EscapeState)     {        /*5         User want to exit without region of interest.c       */E       XWithdrawWindow(display,windows->info.id,windows->info.screen);c"       XFreeCursor(display,cursor);       return(True);b     }rB   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {o     /*I       Size rectangle as pointer moves until the mouse button is released.s     */     x=roi_info.x;e     y=roi_info.y;r     roi_info.width=0;o     roi_info.height=0;     state=DefaultState;e     do     {)       highlight_info=roi_info;3       highlight_info.x=roi_info.x-windows->image.x; 3       highlight_info.y=roi_info.y-windows->image.y; D       if ((highlight_info.width > 3) && (highlight_info.height > 3))	         {_           /*?             Display info and draw region of interest rectangle.i           */$           if (!windows->info.mapped)1             XMapWindow(display,windows->info.id);aJ           FormatString(text," %ux%u%+d%+d",roi_info.width,roi_info.height,#             roi_info.x,roi_info.y);o,           XInfoWidget(display,windows,text);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);	         } 
       else!         if (windows->info.mapped) I           XWithdrawWindow(display,windows->info.id,windows->info.screen);        /*         Wait for next event.       */+       XScreenEvent(display,windows,&event);aD       if ((highlight_info.width > 3) && (highlight_info.height > 3))6         XHighlightRectangle(display,windows->image.id,<           windows->image.highlight_context,&highlight_info);       switch (event.type)*       {          case ButtonPress:(	         { 6           roi_info.x=windows->image.x+event.xbutton.x;6           roi_info.y=windows->image.y+event.xbutton.y;           break;	         }r         case ButtonRelease:i	         {e           /*?             User has committed to region of interest rectangle.r           */6           roi_info.x=windows->image.x+event.xbutton.x;6           roi_info.y=windows->image.y+event.xbutton.y;1           XSetCursorState(display,windows,False);e           state|=ExitState; @           if (Latin1Compare(windows->command.name,"Apply") == 0)             break;(           windows->command.name="Apply";+           windows->command.data=ApplyMenus;nK           (void) XCommandWidget(display,windows,ApplyMenu,(XEvent *) NULL);t           break;	         }r         case Expose:           break;         case MotionNotify:	         {o6           roi_info.x=windows->image.x+event.xmotion.x;6           roi_info.y=windows->image.y+event.xmotion.y;	         }%         default:           break;       }%J       if (((roi_info.x != x) && (roi_info.y != y)) || (state & ExitState))	         {e           /*&             Check boundary conditions.           */           if (roi_info.x < 0)              roi_info.x=0;            else:             if (roi_info.x > windows->image.ximage->width)6               roi_info.x=windows->image.ximage->width;           if (roi_info.x < x) 9             roi_info.width=(unsigned int) (x-roi_info.x);            else
             { ;               roi_info.width=(unsigned int) (roi_info.x-x);                roi_info.x=x; 
             }            if (roi_info.y < 0)%             roi_info.y=0;%           else;             if (roi_info.y > windows->image.ximage->height)o7               roi_info.y=windows->image.ximage->height;u           if (roi_info.y < y)z:             roi_info.height=(unsigned int) (y-roi_info.y);           else
             {d<               roi_info.height=(unsigned int) (roi_info.y-y);               roi_info.y=y;t
             }t	         }k#     } while (!(state & ExitState));s     /*F       Wait for user to grab a corner of the rectangle or press return.     */     state=DefaultState;t     command_type=NullCommand;m     do     {o       if (windows->info.mapped) 	         {i           /*%             Display pointer position.i           */J           FormatString(text," %ux%u%+d%+d",roi_info.width,roi_info.height,#             roi_info.x,roi_info.y);r,           XInfoWidget(display,windows,text);	         }i       highlight_info=roi_info;3       highlight_info.x=roi_info.x-windows->image.x;m3       highlight_info.y=roi_info.y-windows->image.y;eF       if ((highlight_info.width <= 3) || (highlight_info.height <= 3))	         {t           state|=EscapeState;            state|=ExitState;g           break;	         }a$       if (state & UpdateRegionState)	         {oH           XSetFunction(display,windows->image.highlight_context,GXcopy);           switch (command_type)n           {              case UndoCommand:]             case RedoCommand:y
             {sO               (void) XMagickCommand(display,resource_info,windows,command_type,                  image);                break;
             }              default:
             {                /*F                 Region of interest is relative to image configuration.               */?               handler=SetMonitorHandler((MonitorHandler) NULL);e!               crop_info=roi_info; &               width=(*image)->columns;$               height=(*image)->rows;               x=0;               y=0;@               if (windows->image.crop_geometry != (char *) NULL)I                 (void) XParseGeometry(windows->image.crop_geometry,&x,&y, "                   &width,&height);G               scale_factor=(double) width/windows->image.ximage->width;                crop_info.x+=x;n3               crop_info.x=scale_factor*crop_info.x; ;               crop_info.width=scale_factor*crop_info.width; I               scale_factor=(double) height/windows->image.ximage->height;                crop_info.y+=y;;3               crop_info.y=scale_factor*crop_info.y;:=               crop_info.height=scale_factor*crop_info.height; 5               roi_image=CropImage(*image,&crop_info); 0               (void) SetMonitorHandler(handler);.               if (roi_image == (Image *) NULL)                 continue;1               /*K                 Apply image processing technique to the region of interest.r               */)               windows->image.orphan=True;:O               (void) XMagickCommand(display,resource_info,windows,command_type,n                 &roi_image);?               handler=SetMonitorHandler((MonitorHandler) NULL);oB               (void) XMagickCommand(display,resource_info,windows,/                 SaveToUndoBufferCommand,image);t*               windows->image.orphan=False;A               CompositeImage(*image,ReplaceCompositeOp,roi_image,;)                 crop_info.x,crop_info.y); &               DestroyImage(roi_image);0               (void) SetMonitorHandler(handler);               break;
             }-           }_*           if (command_type != InfoCommand)
             {uL               XConfigureImageColormap(display,resource_info,windows,*image);K               (void) XConfigureImage(display,resource_info,windows,*image);C
             } 0           XCheckRefreshWindows(display,windows);,           XInfoWidget(display,windows,text);J           XSetFunction(display,windows->image.highlight_context,GXinvert);&           state&=(~UpdateRegionState);	         } 4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);+       XScreenEvent(display,windows,&event); 3       if (event.xany.window == windows->command.id) 	         {            /*5             Select a command from the Command widget.a           */H           XSetFunction(display,windows->image.highlight_context,GXcopy);#           command_type=NullCommand; >           id=XCommandWidget(display,windows,ApplyMenu,&event);           if (id >= 0)
             {m3               (void) strcpy(command,ApplyMenu[id]);e-               command_type=ApplyCommands[id];a"               if (id < ApplyMenus)                 {a                   /*8                     Select a command from a pop-up menu.                   */B                   entry=XMenuWidget(display,windows,ApplyMenu[id],7                     (const char **) Menus[id],command);e!                   if (entry >= 0)C                     {:>                       (void) strcpy(command,Menus[id][entry]);7                       command_type=Commands[id][entry];n                     }                  }e
             }RJ           XSetFunction(display,windows->image.highlight_context,GXinvert);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);*           if (command_type == HelpCommand)
             {eL               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,A                 "Help Viewer - Region of Interest",ImageROIHelp); N               XSetFunction(display,windows->image.highlight_context,GXinvert);               continue;i
             }Q*           if (command_type == QuitCommand)
             {o               /*                 Exit.E               */!               state|=EscapeState;N               state|=ExitState;                continue;a
             }X*           if (command_type != NullCommand)%             state|=UpdateRegionState;;           continue; 	         }T4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);       switch (event.type)        {S         case ButtonPress:_	         {            x=windows->image.x;e           y=windows->image.y;o.           if (event.xbutton.button != Button1)             break;8           if (event.xbutton.window != windows->image.id)             break;-           x=windows->image.x+event.xbutton.x; -           y=windows->image.y+event.xbutton.y;m2           if ((x < (int) (roi_info.x+RoiDelta)) &&2               (x > (int) (roi_info.x-RoiDelta)) &&2               (y < (int) (roi_info.y+RoiDelta)) &&0               (y > (int) (roi_info.y-RoiDelta)))
             {d3               roi_info.x=roi_info.x+roi_info.width;e4               roi_info.y=roi_info.y+roi_info.height;.               state|=UpdateConfigurationState;               break;
             } 2           if ((x < (int) (roi_info.x+RoiDelta)) &&2               (x > (int) (roi_info.x-RoiDelta)) &&B               (y < (int) (roi_info.y+roi_info.height+RoiDelta)) &&@               (y > (int) (roi_info.y+roi_info.height-RoiDelta)))
             {a3               roi_info.x=roi_info.x+roi_info.width;u.               state|=UpdateConfigurationState;               break;
             }nA           if ((x < (int) (roi_info.x+roi_info.width+RoiDelta)) &&oA               (x > (int) (roi_info.x+roi_info.width-RoiDelta)) && 2               (y < (int) (roi_info.y+RoiDelta)) &&0               (y > (int) (roi_info.y-RoiDelta)))
             {C4               roi_info.y=roi_info.y+roi_info.height;.               state|=UpdateConfigurationState;               break;
             } A           if ((x < (int) (roi_info.x+roi_info.width+RoiDelta)) &&nA               (x > (int) (roi_info.x+roi_info.width-RoiDelta)) && B               (y < (int) (roi_info.y+roi_info.height+RoiDelta)) &&@               (y > (int) (roi_info.y+roi_info.height-RoiDelta)))
             {e.               state|=UpdateConfigurationState;               break;
             }e	         }a         case ButtonRelease:i	         {a6           if (event.xbutton.window == windows->pan.id)E             if ((highlight_info.x != crop_info.x-windows->image.x) || C                 (highlight_info.y != crop_info.y-windows->image.y)) <               XHighlightRectangle(display,windows->image.id,B                 windows->image.highlight_context,&highlight_info);           break;	         }e         case Expose:	         { 8           if (event.xexpose.window == windows->image.id))             if (event.xexpose.count == 0)i               {g1                 event.xexpose.x=highlight_info.x;n1                 event.xexpose.y=highlight_info.y;r9                 event.xexpose.width=highlight_info.width;o;                 event.xexpose.height=highlight_info.height; ?                 XRefreshWindow(display,&windows->image,&event);h               } 7           if (event.xexpose.window == windows->info.id)r)             if (event.xexpose.count == 0)s0               XInfoWidget(display,windows,text);           break;	         }          case KeyPress:	         {s           KeySym             key_symbol;e  5           if (event.xkey.window != windows->image.id)a             break;           /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command, A             sizeof(command),&key_symbol,(XComposeStatus *) NULL);P           switch (key_symbol)            {e             case XK_Shift_L:             case XK_Shift_R:               break;             case XK_Escape:w             case XK_F20:!               state|=EscapeState;o             case XK_Return:p
             {s               state|=ExitState;                break;
             }g             case XK_F1:              case XK_Help:p
             { L               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,A                 "Help Viewer - Region of Interest",ImageROIHelp);hN               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }n             default:
             { M               command_type=XImageWindowCommand(display,resource_info,windows,i3                 event.xkey.state,key_symbol,image); .               if (command_type != NullCommand))                 state|=UpdateRegionState;n               break;
             }a           }i           break;	         }o         case KeyRelease:           break;         case MotionNotify:	         { 8           if (event.xbutton.window != windows->image.id)             break;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */           x=event.xmotion.x;           y=event.xmotion.y;#           if (windows->info.mapped) 
             { F               if ((x < (int) (windows->info.x+windows->info.width)) &&E                   (y < (int) (windows->info.y+windows->info.height))) O                 XWithdrawWindow(display,windows->info.id,windows->info.screen); 
             }            elseD             if ((x > (int) (windows->info.x+windows->info.width)) ||C                 (y > (int) (windows->info.y+windows->info.height)))n3               XMapWindow(display,windows->info.id);%           break;	         }          default:           break;       }m+       if (state & UpdateConfigurationState)e	         { (           XPutBackEvent(display,&event);:           XDefineCursor(display,windows->image.id,cursor);           break;	         }p#     } while (!(state & ExitState)); !   } while (!(state & ExitState));a@   XSetFunction(display,windows->image.highlight_context,GXcopy);)   XSetCursorState(display,windows,False);e   if (state & EscapeState)     return(True);    return(True);e }L   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %pO %                                                                             %uO %                                                                             %oO +   X R o t a t e I m a g e                                                   % O %                                                                             % O %                                                                             %RO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%f %oE %  Method XRotateImage rotates the X image.  If the degrees parameter L %  if zero, the rotation angle is computed from the slope of a line drawn by %  the user. %], %  The format of the XRotateImage method is: %iO %      unsigned int XRotateImage(Display *display,XResourceInfo *resource_info,n8 %        XWindows *windows,double degrees,Image **image) %m+ %  A description of each parameter follows:o % > %    o status: Method XRotateImage return True if the image isJ %      rotated.  False is returned is there is a memory shortage or if the %      image fails to rotate.  %eD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.i %,< %    o windows: Specifies a pointer to a XWindows structure. % D %    o degrees: Specifies the number of degrees to rotate the image. %aF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.t %e %  */O static unsigned int XRotateImage(Display *display,XResourceInfo *resource_info,m1   XWindows *windows,double degrees,Image **image)w {o   static const char>     *RotateMenu[]=     {d       "Pixel Color",       "Direction",
       "Help",        "Dismiss",       (char *) NULL      };     static ModeType (     direction = HorizontalRotateCommand;     static const ModeTyped     DirectionCommands[]=     {r       HorizontalRotateCommand,       VerticalRotateCommandm     },     RotateCommands[]=      {i       RotateColorCommand,t       RotateDirectionCommand,i       RotateCropCommand,       RotateSharpenCommand,        RotateHelpCommand,       RotateDismissCommand     };     static unsigned int      pen_id = 0;e     char     command[MaxTextExtent],      text[MaxTextExtent];     double     normalized_degrees;      Imageg     *rotated_image;t     intn     id,s     x,     y;     register int     i;     unsigned int     height,      rotations,
     width;     if (degrees == 0.0)o     {X       unsigned int         distance;a         unsigned long          state;         XEvent         event;         XSegment         rotate_info;         /*         Map Command widget.        */%       windows->command.name="Rotate";        windows->command.data=4;H       (void) XCommandWidget(display,windows,RotateMenu,(XEvent *) NULL);.       XMapRaised(display,windows->command.id);E       XClientMessage(display,windows->image.id,windows->im_protocols,m/         windows->im_update_widget,CurrentTime);        /*$         Wait for first button press.       */F       XSetFunction(display,windows->image.highlight_context,GXinvert);6       XQueryPosition(display,windows->image.id,&x,&y);       rotate_info.x1=x;t       rotate_info.y1=y;t       rotate_info.x2=x;w       rotate_info.y2=y;        state=DefaultState;t       do       {o1         XHighlightLine(display,windows->image.id, 9           windows->image.highlight_context,&rotate_info);d
         /*           Wait for next event.
         */-         XScreenEvent(display,windows,&event); 1         XHighlightLine(display,windows->image.id,49           windows->image.highlight_context,&rotate_info);_5         if (event.xany.window == windows->command.id)g           {              /*7               Select a command from the Command widget.              */A             id=XCommandWidget(display,windows,RotateMenu,&event);o             if (id < 0)                continue;dJ             XSetFunction(display,windows->image.highlight_context,GXcopy);'             switch (RotateCommands[id]) 
             {m&               case RotateColorCommand:               {/                 char,                   *ColorMenu[MaxNumberPens];                   intd                   pen_number;                    XColor                   color;                   /*-                   Initialize menu selections./                 */;                 for (i=0; i < (int) (MaxNumberPens-2); i++) <                   ColorMenu[i]=resource_info->pen_colors[i];8                 ColorMenu[MaxNumberPens-2]="Browser...";9                 ColorMenu[MaxNumberPens-1]=(char *) NULL;C                 /*:                   Select a pen color from the pop-up menu.                 */F                 pen_number=XMenuWidget(display,windows,RotateMenu[id],5                   (const char **) ColorMenu,command);m#                 if (pen_number < 0)y                   break;4                 if (pen_number == (MaxNumberPens-2))                   {r                     static charn9                       color_name[MaxTextExtent] = "gray";                        /*7                       Select a pen color from a dialog.s                     */E                     resource_info->pen_colors[pen_number]=color_name; M                     XColorBrowserWidget(display,windows,"Select",color_name);a,                     if (*color_name == '\0')                       break;                   }w                 /*                    Set pen color.                 */G                 (void) XParseColor(display,windows->map_info->colormap,o@                   resource_info->pen_colors[pen_number],&color);O                 XBestPixel(display,windows->map_info->colormap,(XColor *) NULL,e3                   (unsigned int) MaxColors,&color);.B                 windows->pixel_info->pen_colors[pen_number]=color;"                 pen_id=pen_number;                 break;               }**               case RotateDirectionCommand:               { !                 static const chare                    *Directions[]=                   {n!                     "horizontal",d                     "vertical",n"                     (char *) NULL,                   };                   /*8                   Select a command from the pop-up menu.                 */>                 id=XMenuWidget(display,windows,RotateMenu[id],&                   Directions,command);                 if (id >= 0)2                   direction=DirectionCommands[id];                 break;               } %               case RotateHelpCommand:%               {eD                 XTextViewWidget(display,resource_info,windows,False,B                   "Help Viewer - Image Rotation",ImageRotateHelp);                 break;               } (               case RotateDismissCommand:               {v                 /*#                   Prematurely exit.                  */#                 state|=EscapeState;i!                 state|=ExitState;h                 break;               }l               default:                 break;
             }aL             XSetFunction(display,windows->image.highlight_context,GXinvert);             continue;m           }e         switch (event.type) 	         {)           case ButtonPress:-           {-0             if (event.xbutton.button != Button1)               break;:             if (event.xbutton.window != windows->image.id)               break;             /*               Exit loop.             */J             XSetFunction(display,windows->image.highlight_context,GXcopy);+             rotate_info.x1=event.xbutton.x; +             rotate_info.y1=event.xbutton.y;              state|=ExitState;r             break;           }>           case ButtonRelease:x             break;           case Expose:             break;           case KeyPress:           {i             char%               command[MaxTextExtent];                KeySym               key_symbol;)  7             if (event.xkey.window != windows->image.id)                break;             /**               Respond to a user key press.             */C             (void) XLookupString((XKeyEvent *) &event.xkey,command, C               sizeof(command),&key_symbol,(XComposeStatus *) NULL);f             switch (key_symbol))
             {                case XK_Escape:e               case XK_F20:               {                  /*#                   Prematurely exit.A                 */#                 state|=EscapeState;_!                 state|=ExitState;                  break;               }a               case XK_F1:a               case XK_Help:I               {uN                 XSetFunction(display,windows->image.highlight_context,GXcopy);D                 XTextViewWidget(display,resource_info,windows,False,B                   "Help Viewer - Image Rotation",ImageRotateHelp);P                 XSetFunction(display,windows->image.highlight_context,GXinvert);                 break;               }                default:               {)!                 XBell(display,0);g                 break;               } 
             }              break;           }a           case MotionNotify:           {_+             rotate_info.x1=event.xmotion.x;w+             rotate_info.y1=event.xmotion.y;;           }i	         }e&         rotate_info.x2=rotate_info.x1;&         rotate_info.y2=rotate_info.y1;1         if (direction == HorizontalRotateCommand)e           rotate_info.x2+=32;          else           rotate_info.y2-=32;a%       } while (!(state & ExitState));mD       XSetFunction(display,windows->image.highlight_context,GXcopy);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);o       if (state & EscapeState)         return(True);p       /*F         Draw line as pointer moves until the mouse button is released.       */       distance=0; F       XSetFunction(display,windows->image.highlight_context,GXinvert);       state=DefaultState;g       do       {i         if (distance > 9)            {              /*2               Display info and draw rotation line.             */&             if (!windows->info.mapped)3               XMapWindow(display,windows->info.id);a&             FormatString(text," %.2f",K               direction == VerticalRotateCommand ? degrees-90.0 : degrees);r.             XInfoWidget(display,windows,text);5             XHighlightLine(display,windows->image.id,_=               windows->image.highlight_context,&rotate_info);,           })         else#           if (windows->info.mapped) K             XWithdrawWindow(display,windows->info.id,windows->info.screen); 
         /*           Wait for next event.
         */-         XScreenEvent(display,windows,&event);e         if (distance > 9)m3           XHighlightLine(display,windows->image.id, ;             windows->image.highlight_context,&rotate_info);,         switch (event.type)i	         {m           case ButtonPress:              break;           case ButtonRelease:;           {)             /*2               User has committed to rotation line.             */+             rotate_info.x2=event.xbutton.x; +             rotate_info.y2=event.xbutton.y;u             state|=ExitState;;             break;           }l           case Expose:             break;           case MotionNotify:           {g+             rotate_info.x2=event.xmotion.x;d+             rotate_info.y2=event.xmotion.y;e           }a           default:             break;	         }l
         /*$           Check boundary conditions.
         */         if (rotate_info.x2 < 0)-           rotate_info.x2=0;s         else:           if (rotate_info.x2 > (int) windows->image.width)0             rotate_info.x2=windows->image.width;         if (rotate_info.y2 < 0)            rotate_info.y2=0;-         else;           if (rotate_info.y2 > (int) windows->image.height) 1             rotate_info.y2=windows->image.height;u
         /*<           Compute rotation angle from the slope of the line.
         */         degrees=0.0;         distance=eP           ((rotate_info.x2-rotate_info.x1+1)*(rotate_info.x2-rotate_info.x1+1))+P           ((rotate_info.y2-rotate_info.y1+1)*(rotate_info.y2-rotate_info.y1+1));         if (distance > 9) C           degrees=RadiansToDegrees(-atan2((double) (rotate_info.y2- G             rotate_info.y1),(double) (rotate_info.x2-rotate_info.x1)));*%       } while (!(state & ExitState));eD       XSetFunction(display,windows->image.highlight_context,GXcopy);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);        if (distance <= 9)         return(True);t     }g)   if (direction == VerticalRotateCommand)      degrees-=90.0;   if (degrees == 0.0)      return(True);C   /*     Rotate image.*   */   normalized_degrees=degrees; $   while (normalized_degrees < -45.0)     normalized_degrees+=360.0;;   for (rotations=0; normalized_degrees > 45.0; rotations++)(     normalized_degrees-=90.0;t    if (normalized_degrees != 0.0)L     (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   (*image)->border_color.red=s<     XDownScale(windows->pixel_info->pen_colors[pen_id].red);   (*image)->border_color.green=c>     XDownScale(windows->pixel_info->pen_colors[pen_id].green);   (*image)->border_color.blue==     XDownScale(windows->pixel_info->pen_colors[pen_id].blue);(-   (*image)->border_color.opacity=Transparent; ,   rotated_image=RotateImage(*image,degrees);)   XSetCursorState(display,windows,False);p&   if (rotated_image == (Image *) NULL)     return(False);   DestroyImage(*image);W   *image=rotated_image; 4   if (windows->image.crop_geometry != (char *) NULL)     {r       /*         Rotate crop geometry.e       */       width=(*image)->columns;       height=(*image)->rows;O       (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);        switch (rotations % 4)       {n         default:         case 0:            break;         case 1:t	         {r           /*             Rotate 90 degrees.           */B           FormatString(windows->image.crop_geometry,"%ux%u%+d%+d",C             height,width,(int) (*image)->columns-(int) height-y,x);            break;	         }          case 2:x	         {+           /*             Rotate 180 degrees.l           */B           FormatString(windows->image.crop_geometry,"%ux%u%+d%+d",7             width,height,(int) width-x,(int) height-y);            break;	         }          case 3:l	         {            /*             Rotate 270 degrees.o           */B           FormatString(windows->image.crop_geometry,"%ux%u%+d%+d",?             height,width,y,(int) (*image)->rows-(int) width-x);-           break;	         }y       }      }I   if (windows->image.orphan)     return(True);     if (normalized_degrees != 0.0)     {)       /*         Update image colormap.       */<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;8       if (windows->image.crop_geometry != (char *) NULL)	         {;           /*:             Obtain dimensions of image from crop geometry.           */C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,              &width,&height);4           windows->image.window_changes.width=width;6           windows->image.window_changes.height=height;	         }wD       XConfigureImageColormap(display,resource_info,windows,*image);     }a   else9     if (((rotations % 4) == 1) || ((rotations % 4) == 3))        {tJ         windows->image.window_changes.width=windows->image.ximage->height;J         windows->image.window_changes.height=windows->image.ximage->width;       }s   /*     Update image configuration.g   */?   (void) XConfigureImage(display,resource_info,windows,*image);    return(True);* }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %/O %                                                                             %uO %                                                                             %_O +   X S a v e I m a g e                                                       %iO %                                                                             %rO %                                                                             %oO %                                                                             %tO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %u. %  Method XSaveImage saves an image to a file. % * %  The format of the XSaveImage method is: %lM %      unsigned int XSaveImage(Display *display,XResourceInfo *resource_info, ( %        XWindows *windows,Image *image) % + %  A description of each parameter follows:t %.< %    o status: Method XSaveImage return True if the image isJ %      written.  False is returned is there is a memory shortage or if the %      image fails to write. %(D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %oK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.t %s< %    o windows: Specifies a pointer to a XWindows structure. %)F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %v %) */M static unsigned int XSaveImage(Display *display,XResourceInfo *resource_info, !   XWindows *windows,Image *image)  {    char     filename[MaxTextExtent],     geometry[MaxTextExtent];     Image      *save_image;     ImageInfon     *image_info;     int      status;l     /*      Request file name from user.   */5   if (resource_info->write_filename != (char *) NULL)e:     (void) strcpy(filename,resource_info->write_filename);   else     { 
       char)         working_directory[MaxTextExtent];s         register char,         *p;   2       p=image->filename+Extent(image->filename)-1;C       while ((p > image->filename) && !IsBasenameSeparator(*(p-1)))e         p--;        (void) strcpy(filename,p);7       (void) strcpy(working_directory,image->filename); 0       working_directory[p-image->filename]='\0';       if (p != image->filename) (         (void) chdir(working_directory);     }o6   XFileBrowserWidget(display,windows,"Save",filename);   if (*filename == '\0')     return(True);    if (IsAccessible(filename))a     {:       /*@         File exists-- seek user's permission before overwriting.       */B       status=XConfirmWidget(display,windows,"Overwrite",filename);       if (status <= 0)         return(True);m     }e7   image_info=CloneImageInfo(resource_info->image_info);)/   (void) strcpy(image_info->filename,filename); !   SetImageInfo(image_info,False);t8   if ((Latin1Compare(image_info->magick,"JPEG") == 0) ||5       (Latin1Compare(image_info->magick,"JPG") == 0))=     { 
       char         quality[MaxTextExtent];o         /*'         Request JPEG quality from user.w       */5       FormatString(quality,"%u",image_info->quality); H       status=XDialogWidget(display,windows,"Save","Enter JPEG quality:",         quality);e       if (*quality == '\0')s         return(True);;(       image_info->quality=atoi(quality);B       image_info->interlace=status ? NoInterlace : PlaneInterlace;     }t7   if ((Latin1Compare(image_info->magick,"EPS") == 0) ||s7       (Latin1Compare(image_info->magick,"PDF") == 0) ||I6       (Latin1Compare(image_info->magick,"PS") == 0) ||5       (Latin1Compare(image_info->magick,"PS2") == 0))w     {e
       char          geometry[MaxTextExtent];         /*(         Request page geometry from user.       */,       FormatString(geometry,PSPageGeometry);7       if (Latin1Compare(image_info->magick,"PDF") == 0) .         FormatString(geometry,PSPageGeometry);,       if (image_info->page != (char *) NULL)1         (void) strcpy(geometry,image_info->page);oM       XListBrowserWidget(display,windows,&windows->widget,PageSizes,"Select",2*         "Select page geometry:",geometry);       if (*geometry != '\0')6         image_info->page=PostscriptGeometry(geometry);     }l   /*     Apply image transforms.,   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);?   save_image=CloneImage(image,image->columns,image->rows,True); #   if (save_image == (Image *) NULL)      return(False);>   FormatString(geometry,"%dx%d!",windows->image.ximage->width,#     windows->image.ximage->height);1D   TransformImage(&save_image,windows->image.crop_geometry,geometry);7   if (resource_info->quantize_info->number_colors != 0)      {(       /*1         Reduce the number of colors in the image.C       *//       if ((save_image->class == DirectClass) ||)O           (save_image->colors > resource_info->quantize_info->number_colors) || G           (resource_info->quantize_info->colorspace == GRAYColorspace))mF         (void) QuantizeImage(resource_info->quantize_info,save_image);     };   /*     Write image.   *//   (void) strcpy(save_image->filename,filename); +   status=WriteImage(image_info,save_image);a   if (status == True)t     image->tainted=False;,   DestroyImage(save_image);i   DestroyImageInfo(image_info); )   XSetCursorState(display,windows,False);i   return(status);; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %sO %                                                                             %_O +   X S c r e e n E v e n t                                                   %iO %                                                                             %rO %                                                                             %oO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%d %,H %  Method XScreenEvent handles global events associated with the Pan and %  Magnify windows.2 %g. %  The format of the XScreenEvent function is: %oJ %      void XScreenEvent(Display *display,XWindows *windows,XEvent *event) %d+ %  A description of each parameter follows:n %uL %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %n< %    o windows: Specifies a pointer to a XWindows structure. % < %    o event: Specifies a pointer to a X11 XEvent structure. %" %  */  / #if defined(__cplusplus) || defined(c_plusplus)  extern "C" { #endif  @ static int XPredicate(Display *display,XEvent *event,char *data) {'   register XWindows 
     *windows;      windows=(XWindows *) data;'   if ((event->type == ClientMessage) && 3       (event->xclient.window == windows->image.id))1     return(False);   return(True);  }   / #if defined(__cplusplus) || defined(c_plusplus)g }  #endif  J static void XScreenEvent(Display *display,XWindows *windows,XEvent *event) {    MonitorHandler     handler;     register int     x,     y;  6   XIfEvent(display,event,XPredicate,(char *) windows);0   if (event->xany.window == windows->command.id)     return;z   switch (event->type)   {t     case ButtonPress:s     case ButtonRelease:      { /       if ((event->xbutton.button == Button3) &&r,           (event->xbutton.state & Mod1Mask))	         {"           /*+             Convert Alt-Button3 to Button2.            */(           event->xbutton.button=Button2;,           event->xbutton.state&=(~Mod1Mask);	         }t8       if (event->xbutton.window == windows->backdrop.id)	         {sF           XSetInputFocus(display,event->xbutton.window,RevertToParent,!             event->xbutton.time);            break;	         }m3       if (event->xbutton.window == windows->pan.id)a	         {a+           XPanImage(display,windows,event);            break;	         }m5       if (event->xbutton.window == windows->image.id) -         if (event->xbutton.button == Button2)w           {)             /*%               Update magnified image.              */             x=event->xbutton.x;/             y=event->xbutton.y;i             if (x < 0)               x=0;             else2               if (x >= (int) windows->image.width))                 x=windows->image.width-1; 2             windows->magnify.x=windows->image.x+x;             if (y < 0)               y=0;             else2              if (y >= (int) windows->image.height))                y=windows->image.height-1;n2             windows->magnify.y=windows->image.y+y;)             if (!windows->magnify.mapped) 6               XMapRaised(display,windows->magnify.id);=             handler=SetMonitorHandler((MonitorHandler) NULL);n/             XMakeMagnifyImage(display,windows);a.             (void) SetMonitorHandler(handler);-             if (event->type == ButtonRelease) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);i             break;           }e       break;     }f     case ClientMessage:c     {w       /*.         If client window delete message, exit.       */?       if (event->xclient.message_type != windows->wm_protocols)          break;D       if (*event->xclient.data.l != (int) windows->wm_delete_window)         break;7       if (event->xclient.window == windows->magnify.id)n	         {mO           XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);o           break;	         }        break;     }a     case ConfigureNotify:d     {a:       if (event->xconfigure.window == windows->magnify.id)	         {)           unsigned int             magnify;             /*3             Magnify window has a new configuration.            */9           windows->magnify.width=event->xconfigure.width; ;           windows->magnify.height=event->xconfigure.height;T'           if (!windows->magnify.mapped)e             break;           magnify=1;:           while ((int) magnify <= event->xconfigure.width)             magnify<<=1;;           while ((int) magnify <= event->xconfigure.height)              magnify<<=1;           magnify>>=1;;           if (((int) magnify != event->xconfigure.width) ||*:               ((int) magnify != event->xconfigure.height))
             {o               XWindowChanges                 window_changes;e  +               window_changes.width=magnify;f,               window_changes.height=magnify;?               XReconfigureWMWindow(display,windows->magnify.id, L                 windows->magnify.screen,CWWidth | CWHeight,&window_changes);               break;
             } -           XMakeMagnifyImage(display,windows);"           break;	         }e       break;     }.     case Expose:     { 5       if (event->xexpose.window == windows->image.id) 	         { 8           XRefreshWindow(display,&windows->image,event);           break;	         }e3       if (event->xexpose.window == windows->pan.id)e&         if (event->xexpose.count == 0)           {u/             XDrawPanRectangle(display,windows);u             break;           } 7       if (event->xexpose.window == windows->magnify.id) &         if (event->xexpose.count == 0)           {,/             XMakeMagnifyImage(display,windows);s             break;           }        break;     }      case KeyPress:     { 
       char         command[MaxTextExtent];e         KeySym         key_symbol;u  4       if (event->xkey.window != windows->magnify.id)         break;       /*$         Respond to a user key press.       */N       (void) XLookupString((XKeyEvent *) &event->xkey,command,sizeof(command),-         &key_symbol,(XComposeStatus *) NULL);tJ       XMagnifyWindowCommand(display,windows,event->xkey.state,key_symbol);       break;     }      case MapNotify:o     { 4       if (event->xmap.window == windows->magnify.id)	         {t'           windows->magnify.mapped=True; I           XWithdrawWindow(display,windows->info.id,windows->info.screen);(           break;	         },1       if (event->xmap.window == windows->info.id)u	         {n$           windows->info.mapped=True;           break;	         }        break;     }a     case MotionNotify:     {t>       while (XCheckMaskEvent(display,ButtonMotionMask,event));5       if (event->xmotion.window == windows->image.id)"$         if (windows->magnify.mapped)           {o             /*%               Update magnified image.              */             x=event->xmotion.x;              y=event->xmotion.y;r             if (x < 0)               x=0;             else2               if (x >= (int) windows->image.width))                 x=windows->image.width-1;,2             windows->magnify.x=windows->image.x+x;             if (y < 0)               y=0;             else2              if (y >= (int) windows->image.height))                y=windows->image.height-1;s2             windows->magnify.y=windows->image.y+y;/             XMakeMagnifyImage(display,windows);            }        break;     }e     case UnmapNotify:      {*6       if (event->xunmap.window == windows->magnify.id)	         {l(           windows->magnify.mapped=False;           break;	         }t3       if (event->xunmap.window == windows->info.id)=	         { %           windows->info.mapped=False;g           break;	         }        break;     }a     default:       break;   }r }W o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %wO %                                                                             %gO %                                                                             %sO +   X S e t C r o p G e o m e t r y                                           %dO %                                                                             % O %                                                                             %lO %                                                                             %fO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %oF %  Method XSetCropGeometry accepts a cropping geometry relative to theH %  Image window and translates it to a cropping geometry relative to the	 %  image.u %o0 %  The format of the XSetCropGeometry method is: %,@ %      void XSetCropGeometry(Display *display,XWindows *windows,/ %        RectangleInfo *crop_info,Image *image)C %i+ %  A description of each parameter follows:w %iD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. %eL %    o crop_info:  A pointer to a RectangleInfo that defines a region of the %      Image window to crop. %s7 %    o image: Specifies a pointer to a Image structure.t %a %u */@ static void XSetCropGeometry(Display *display,XWindows *windows,(   RectangleInfo *crop_info,Image *image) {    char     text[MaxTextExtent];     double     scale_factor;d     int;     x,     y;     unsigned int     height, 
     width;     if (windows->info.mapped)m     {        /*+         Display info on cropping rectangle.m       */J       FormatString(text," %ux%u%+d%+d",crop_info->width,crop_info->height,#         crop_info->x,crop_info->y); (       XInfoWidget(display,windows,text);     }f   /*@     Cropping geometry is relative to any previous crop geometry.   */   x=0;   y=0;   width=image->columns;e   height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);i   else     {t       /*&         Allocate crop geometry string.       */+       windows->image.crop_geometry=(char *) 3         AllocateMemory(MaxTextExtent*sizeof(char));v8       if (windows->image.crop_geometry == (char *) NULL)@         MagickError(ResourceLimitError,"Unable to crop X image",           windows->image.name);o     }    /*@     Define the crop geometry string from the cropping rectangle.   */;   scale_factor=(double) width/windows->image.ximage->width;p   if (crop_info->x > 0) !     x+=scale_factor*crop_info->x; &   width=scale_factor*crop_info->width;   if (width == 0)f     width=1;=   scale_factor=(double) height/windows->image.ximage->height;s   if (crop_info->y > 0) .     y+=scale_factor*crop_info->y*scale_factor;(   height=scale_factor*crop_info->height;   if (height == 0)
     height=1; L   FormatString(windows->image.crop_geometry,"%ux%u%+d%+d",width,height,x,y); }y n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %tO %                                                                             % O %                                                                             %_O +   X T i l e I m a g e                                                       % O %                                                                             %iO %                                                                             %cO %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %rC %  Method XTileImage loads or deletes a selected tile from a visualsF %  image directory.  The load or delete command is chosen from a menu. %f* %  The format of the XTileImage method is: %rG %      Image *XTileImage(Display *display,XResourceInfo *resource_info,r6 %        XWindows *windows,Image *image,XEvent *event) %s+ %  A description of each parameter follows:  % @ %    o tiled_image:  XTileImage reads or deletes the tiled imageD %      and returns it.  A null image is returned if an error occurs. %iE %    o display: Specifies a connection to an X server;  returned fromp %      XOpenDisplay. %,K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.w % < %    o windows: Specifies a pointer to a XWindows structure. %cE %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.e % H %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.  %( %g */G static Image *XTileImage(Display *display,XResourceInfo *resource_info,e/   XWindows *windows,Image *image,XEvent *event), {d   static const chare     *VerbMenu[]=     {w
       "Load", 
       "Next","       "Former",=       "Delete",o       "Update",c       (char *) NULL,     };     static const ModeType(     TileCommands[]=)     {        TileLoadCommand,       TileNextCommand,       TileFormerCommand,       TileDeleteCommand,       TileUpdateCommandi     };     char     command[MaxTextExtent],s     filename[MaxTextExtent];     double     scale_factor;      Image      *tiled_image;      intM     id,e     status,(	     tile,*     x,     y;     register charc     *p,      *q;      register int     i;     unsigned int     height, 
     width;     /*:     Tile image is relative to montage image configuration.   */   x=0;   y=0;   width=image->columns;    height=image->rows;a4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);=;   scale_factor=(double) width/windows->image.ximage->width;u%   event->xbutton.x+=windows->image.x; 3   event->xbutton.x=scale_factor*event->xbutton.x+x;f=   scale_factor=(double) height/windows->image.ximage->height;C%   event->xbutton.y+=windows->image.y;i3   event->xbutton.y=scale_factor*event->xbutton.y+y;_   /*K     Determine size and location of each tile in the visual image directory.    */   width=image->columns;M   height=image->rows;"   x=0;   y=0;=   (void) XParseGeometry(image->montage,&x,&y,&width,&height);i@   tile=((event->xbutton.y-y)/height)*((image->columns-x)/width)+     (event->xbutton.x-x)/width;m   if (tile < 0)(     {r       /*)         Button press is outside any tile.m       */       XBell(display,0);u       return((Image *) NULL);;     }    /*0     Determine file name from the tile directory.   */   p=image->directory;y*   for (i=tile; (i != 0) && (*p != '\0'); )   {3     if (*p == '\n') 
       i--;     p++;   }d   if (*p == '\0')      {d       /*)         Button press is outside any tile.m       */       XBell(display,0);i       return((Image *) NULL);o     }I   /**     Select a command from the pop-up menu.   */?   id=XMenuWidget(display,windows,"Tile Verb",VerbMenu,command); 
   if (id < 0)s     return((Image *) NULL);    q=p;&   while ((*q != '\n') && (*q != '\0'))     q++;!   (void) strncpy(filename,p,q-p);g   filename[q-p]='\0';    /**     Perform command for the selected tile.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   tiled_image=(Image *) NULL;t   switch (TileCommands[id])    {C     case TileLoadCommand:w     {;       /*         Load tile image.       */,       XCheckRefreshWindows(display,windows);>       (void) strcpy(resource_info->image_info->magick,"MIFF");B       (void) strcpy(resource_info->image_info->filename,filename);7       tiled_image=ReadImage(resource_info->image_info); E       XWithdrawWindow(display,windows->info.id,windows->info.screen);        break;     }      case TileNextCommand:n     {        /*         Display next image.M       */E       XClientMessage(display,windows->image.id,windows->im_protocols,/,         windows->im_next_image,CurrentTime);       break;     }      case TileFormerCommand:t     {        /*         Display former image.'       */E       XClientMessage(display,windows->image.id,windows->im_protocols,X.         windows->im_former_image,CurrentTime);       break;     }      case TileDeleteCommand:d     {e       /*         Delete tile image.       */"       if (!IsAccessible(filename))	         {tO           XNoticeWidget(display,windows,"Image file does not exist:",filename);s           break;	         })K       status=XConfirmWidget(display,windows,"Really delete tile",filename);l       if (status <= 0)         break;       status=remove(filename);       if (status != False)	         {)G           XNoticeWidget(display,windows,"Unable to delete image file:",              filename);           break;	         }      }X     case TileUpdateCommand:o     {f	       inti         x_offset,t         y_offset;          register int
         j;         register PixelPacket         *r;          /*$         Ensure all the images exist.       */
       tile=0;a/       for (p=image->directory; *p != '\0'; p++)        {          q=p;,         while ((*q != '\n') && (*q != '\0'))           q++;'         (void) strncpy(filename,p,q-p);s         filename[q-p]='\0';t         p=q;#         if (IsAccessible(filename))i           {              tile++;a             continue;            } 
         /*/           Overwrite tile with background color. 
         */=         x_offset=width*(tile % ((image->columns-x)/width))+x;c<         y_offset=height*(tile/((image->columns-x)/width))+y;(         for (i=0; i < (int) height; i++)	         {pA           r=image->pixels+((y_offset+i)*image->columns+x_offset);r)           for (j=0; j < (int) width; j++) "             *r++=(*image->pixels);	         }a         tile++;        } 9       windows->image.window_changes.width=image->columns;;7       windows->image.window_changes.height=image->rows;cC       XConfigureImageColormap(display,resource_info,windows,image); B       (void) XConfigureImage(display,resource_info,windows,image);       break;     }i     default:       break;   } )   XSetCursorState(display,windows,False);s   return(tiled_image); }s c /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%dO %                                                                             %eO %                                                                             %:O %                                                                             %*O +   X T r a n s l a t e I m a g e                                             %eO %                                                                             %aO %                                                                             %eO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%, %oE %  Method XTranslateImage translates the image within an Image windowiM %  by one pixel as specified by the key symbol.  If the image has a `montage'dM %  string the translation is respect to the width and height contained withint %  the string. %I/ %  The format of the XTranslateImage method is:  % ? %      void XTranslateImage(Display *display,XWindows *windows,e. %        Image *image,const KeySym key_symbol) %o+ %  A description of each parameter follows:d %-D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %f< %    o windows: Specifies a pointer to a XWindows structure. %_F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.t %cM %    o key_symbol: Specifies a KeySym which indicates which side of the imagef %      to trim.d %o %r */? static void XTranslateImage(Display *display,XWindows *windows,r'   Image *image,const KeySym key_symbol)r {;   char     text[MaxTextExtent];     ints     x,     y;     unsigned int
     x_offset,e
     y_offset;      /*)     User specified a pan position offset.    */    x_offset=windows->image.width;!   y_offset=windows->image.height;a&   if (image->montage != (char *) NULL)D     (void) XParseGeometry(image->montage,&x,&y,&x_offset,&y_offset);   switch (key_symbol)o   {s     case XK_Home:      case XK_KP_Home:     { .       windows->image.x=windows->image.width/2;/       windows->image.y=windows->image.height/2;_       break;     }g     case XK_Left:S     case XK_KP_Left:     {,!       windows->image.x-=x_offset;o       break;     };     case XK_Next:a     case XK_Up:.     case XK_KP_Up:     { !       windows->image.y-=y_offset;e       break;     }      case XK_Right:     case XK_KP_Right:r     {,!       windows->image.x+=x_offset;f       break;     }s     case XK_Prior:     case XK_Down:a     case XK_KP_Down:     {o!       windows->image.y+=y_offset;d       break;     }      default:
       return;m   }g   /*     Check boundary conditions.   */   if (windows->image.x < 0)      windows->image.x=0;    else7     if ((int) (windows->image.x+windows->image.width) > %         windows->image.ximage->width)WI       windows->image.x=windows->image.ximage->width-windows->image.width;    if (windows->image.y < 0)a     windows->image.y=0;    else8     if ((int) (windows->image.y+windows->image.height) >&         windows->image.ximage->height)K       windows->image.y=windows->image.ximage->height-windows->image.height;p   /*     Refresh Image window.\   */9   FormatString(text," %ux%u%+d%+d ",windows->image.width,t=     windows->image.height,windows->image.x,windows->image.y);d$   XInfoWidget(display,windows,text);(   XCheckRefreshWindows(display,windows);%   XDrawPanRectangle(display,windows); :   XRefreshWindow(display,&windows->image,(XEvent *) NULL);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);  }  r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%mO %                                                                             % O %                                                                             %)O %                                                                             %nO +   X T r i m I m a g e                                                       %kO %                                                                             % O %                                                                             %fO %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ; %  Method XTrimImage trims the edges from the Image window.  % * %  The format of the XTrimImage method is: %oM %      unsigned int XTrimImage(Display *display,XResourceInfo *resource_info,i( %        XWindows *windows,Image *image) % + %  A description of each parameter follows:  % = %    o status: Method XTrimImage returns True if the image is J %      cropped.  False is returned is there is a memory shortage or if the! %      image fails to be cropped.d %lD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %(< %    o windows: Specifies a pointer to a XWindows structure. %a7 %    o image: Specifies a pointer to a Image structure.  %  %e */M static unsigned int XTrimImage(Display *display,XResourceInfo *resource_info, !   XWindows *windows,Image *image)> {n   RectangleInfo      trim_info;     register int     x,     y;     unsigned long      background,S
     pixel;     /*     Trim edges from image.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   /*     Crop the left edge.    */2   background=XGetPixel(windows->image.ximage,0,0);/   trim_info.width=windows->image.ximage->width;e2   for (x=0; x < windows->image.ximage->width; x++)   {p5     for (y=0; y < windows->image.ximage->height; y++)      {o1       pixel=XGetPixel(windows->image.ximage,x,y);        if (pixel != background)         break;     }0*     if (y < windows->image.ximage->height)       break;   }L   trim_info.x=x;2   if (trim_info.x == windows->image.ximage->width)     {"-       XSetCursorState(display,windows,False);        return(False);     }p   /*     Crop the right edge.   */O   background=XGetPixel(windows->image.ximage,windows->image.ximage->width-1,0);m4   for (x=windows->image.ximage->width-1; x > 0; x--)   {o5     for (y=0; y < windows->image.ximage->height; y++)e     { 1       pixel=XGetPixel(windows->image.ximage,x,y);        if (pixel != background)         break;     } *     if (y < windows->image.ximage->height)       break;   }g"   trim_info.width=x-trim_info.x+1;   /*     Crop the top edge.   */2   background=XGetPixel(windows->image.ximage,0,0);1   trim_info.height=windows->image.ximage->height;o3   for (y=0; y < windows->image.ximage->height; y++)    {a4     for (x=0; x < windows->image.ximage->width; x++)     { 1       pixel=XGetPixel(windows->image.ximage,x,y);t       if (pixel != background)         break;     }W)     if (x < windows->image.ximage->width)g       break;   }.   trim_info.y=y;   /*     Crop the bottom edge.    */P   background=XGetPixel(windows->image.ximage,0,windows->image.ximage->height-1);5   for (y=windows->image.ximage->height-1; y > 0; y--)    { 4     for (x=0; x < windows->image.ximage->width; x++)     { 1       pixel=XGetPixel(windows->image.ximage,x,y);        if (pixel != background)         break;     }l)     if (x < windows->image.ximage->width)i       break;   })#   trim_info.height=y-trim_info.y+1;o2   if ((trim_info.width != windows->image.width) ||2       (trim_info.height != windows->image.height))     {        /*F         Reconfigure Image window as defined by the trimming rectangle.       */9       XSetCropGeometry(display,windows,&trim_info,image); :       windows->image.window_changes.width=trim_info.width;<       windows->image.window_changes.height=trim_info.height;B       (void) XConfigureImage(display,resource_info,windows,image);     }*)   XSetCursorState(display,windows,False);I   return(True);* }g g /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%,O %                                                                             %oO %                                                                             % O %                                                                             %oO +   X V i s u a l D i r e c t o r y I m a g e                                 %sO %                                                                             %sO %                                                                             %eO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %CA %  Method XVisualDirectoryImage creates a Visual Image Directory.  % 5 %  The format of the XVisualDirectoryImage method is:1 % 5 %      Image *XVisualDirectoryImage(Display *display, 8 %        XResourceInfo *resource_info,XWindows *windows) %i+ %  A description of each parameter follows:P %eH %    o loaded_image: Method XVisualDirectoryImage returns a visual imageK %      directory if it can be created successfully.  Otherwise a null imageC %      is returned.w %oD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %;K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.e %e< %    o windows: Specifies a pointer to a XWindows structure. %e %f */5 static Image *XVisualDirectoryImage(Display *display, 1   XResourceInfo *resource_info,XWindows *windows)s {i. #define LoadImageText  "  Loading images...  "3 #define TileImageText  "  Scaling image tiles...  "s #define XClientName  "montage"     char     *commands[10],     **filelist,e     window_id[MaxTextExtent];a     Imagea     *image,      *montage_image,r     *next_image;     ImageInfo      *local_info;     into     number_files;a     MonitorHandler     handler;  
   MontageInfoe     montage_info;      register int     i;  
   static char #     filename[MaxTextExtent] = "\0",m#     filenames[MaxTextExtent] = "*";i     unsigned int
     backdrop,      status;      XResourceInfoa     background_resources;      /*      Request file name from user.   */<   XFileBrowserWidget(display,windows,"Directory",filenames);   if (*filenames == '\0')      return((Image *) NULL);y   /*     Expand the filenames.l   */4   filelist=(char **) AllocateMemory(sizeof(char *));!   if (filelist == (char **) NULL)      {[D       MagickWarning(ResourceLimitWarning,"Memory allocation failed",         (char *) NULL);o       return((Image *) NULL);m     }g   number_files=1;.   filelist[0]=filenames;2   status=ExpandFilenames(&number_files,&filelist);/   if ((status == False) || (number_files == 0))n     {mI       MagickWarning(OptionWarning,"No image files were found",filenames);i       return((Image *) NULL);N     }    /*#     Set image background resources.    */(   background_resources=(*resource_info);+   background_resources.window_id=window_id;aI   FormatString(background_resources.window_id,"0x%lx",windows->image.id);e%   background_resources.backdrop=True;t   /*/     Read each image and convert them to a tile.)   */8   backdrop=(windows->visual_info->class == TrueColor) ||0    (windows->visual_info->class == DirectColor);7   local_info=CloneImageInfo(resource_info->image_info); '   if (local_info == (ImageInfo *) NULL))     return((Image *) NULL);    image=(Image *) NULL; )   commands[0]=resource_info->client_name;i   commands[1]="-label";)(   commands[2]=(char *) DefaultTileLabel;   commands[3]="-geometry";+   commands[4]=(char *) DefaultTileGeometry;a(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);"   for (i=0; i < number_files; i++)   {%5     handler=SetMonitorHandler((MonitorHandler) NULL); 4     (void) strcpy(local_info->filename,filelist[i]);     *local_info->magick='\0'; >     (void) CloneString(&local_info->size,DefaultTileGeometry);%     next_image=ReadImage(local_info); !     if (filelist[i] != filenames)        FreeMemory(filelist[i]);%     if (next_image != (Image *) NULL)        { 9         MogrifyImages(local_info,5,commands,&next_image);           next_image->matte=False;         if (backdrop)            { I             (void) XDisplayBackgroundImage(display,&background_resources,                next_image);2             XSetCursorState(display,windows,True);           }%$         if (image == (Image *) NULL)           image=next_image;o         else           { #             image->next=next_image;o(             image->next->previous=image;             image=image->next;           }        } &     (void) SetMonitorHandler(handler);2     ProgressMonitor(LoadImageText,i,number_files);   }    DestroyImageInfo(local_info);    FreeMemory(filelist);o   if (image == (Image *) NULL)     {d-       XSetCursorState(display,windows,False);cE       MagickWarning(OptionWarning,"No images were loaded",filenames);        return((Image *) NULL);      }s+   while (image->previous != (Image *) NULL)o     image=image->previous;   /*&     Create the Visual Image Directory.   */    GetMontageInfo(&montage_info);0   (void) strcpy(montage_info.filename,filename);I   (void) CloneString(&montage_info.font,resource_info->image_info->font);e>   montage_info.pointsize=resource_info->image_info->pointsize;3   montage_image=MontageImages(image,&montage_info);l$   DestroyMontageInfo(&montage_info);   DestroyImages(image);d)   XSetCursorState(display,windows,False);w&   if (montage_image == (Image *) NULL)     return(montage_image);A   XClientMessage(display,windows->image.id,windows->im_protocols, (     windows->im_next_image,CurrentTime);   return(montage_image); }- f /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %)O %                                                                             %)O %                                                                             %pO %   X D i s p l a y B a c k g r o u n d I m a g e                             % O %                                                                             %xO %                                                                             %,O %                                                                             %EO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%P %sJ %  Method XDisplayBackgroundImage displays an image in the background of a
 %  window. %n7 %  The format of the XDisplayBackgroundImage method is:u %n= %      unsigned int XDisplayBackgroundImage(Display *display, 3 %        XResourceInfo *resource_info,Image *image)  %a+ %  A description of each parameter follows:  %=A %    o status: Method XDisplayBackgroundImage returns True if the , %      designated window is the root window. % E %    o display: Specifies a connection to an X server;  returned from= %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %)E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.. %g %1 */= Export unsigned int XDisplayBackgroundImage(Display *display, ,   XResourceInfo *resource_info,Image *image) {a   char     geometry[MaxTextExtent],     visual_type[MaxTextExtent];%     static XPixelInfo%
     pixel;     static XStandardColormap     *map_info;     static XVisualInfo(     *visual_info = (XVisualInfo *) NULL;     static XWindowInfo     window_info;     unsigned int     height,      status, 
     width;     Window     root_window;     XGCValues      context_values;      XResourceInfo      resources;     XWindowAttributes      window_attributes;     /*     Determine target window.   */   resources=(*resource_info);    window_info.id=(Window) NULL; ;   root_window=XRootWindow(display,XDefaultScreen(display)); 5   if (Latin1Compare(resources.window_id,"root") == 0)%     window_info.id=root_window;%   else     {%.       if (isdigit((int) *resources.window_id))7         window_info.id=XWindowByID(display,root_window, J           (Window) strtol((char *) resources.window_id,(char **) NULL,0));*       if (window_info.id == (Window) NULL)         window_info.id=XA           XWindowByName(display,root_window,resources.window_id);k     }o&   if (window_info.id == (Window) NULL)     {oG       MagickWarning(OptionWarning,"No window with specified id exists",          resources.window_id);        return(False);     }o   /*     Determine window visual id.    */I   window_attributes.width=XDisplayWidth(display,XDefaultScreen(display));hK   window_attributes.height=XDisplayHeight(display,XDefaultScreen(display));d'   (void) strcpy(visual_type,"default");oI   status=XGetWindowAttributes(display,window_info.id,&window_attributes);i   if (status != False)%     FormatString(visual_type,"0x%lx",r5       XVisualIDFromVisual(window_attributes.visual)); *   if (visual_info == (XVisualInfo *) NULL)     {        /*#         Allocate standard colormap.n       */(       map_info=XAllocStandardColormap();1       if (map_info == (XStandardColormap *) NULL) F         MagickError(XServerError,"Unable to create standard colormap",&           "Memory allocation failed");)       map_info->colormap=(Colormap) NULL; *       pixel.pixels=(unsigned long *) NULL;&       pixel.gamma_map=(XColor *) NULL;       /*         Initialize visual info.r       */'       resources.map_type=(char *) NULL; (       resources.visual_type=visual_type;?       visual_info=XBestVisualInfo(display,map_info,&resources); .       if (visual_info == (XVisualInfo *) NULL)O         MagickError(XServerError,"Unable to get visual",resources.visual_type);m       /*         Initialize window info.        */)       window_info.ximage=(XImage *) NULL; .       window_info.matte_image=(XImage *) NULL;'       window_info.pixmap=(Pixmap) NULL;u-       window_info.matte_pixmap=(Pixmap) NULL;      }X   /*     Free previous root colors.   */$   if (window_info.id == root_window).     XDestroyWindowColors(display,root_window);   /*!     Initialize Standard Colormap.u   */$   resources.colormap=SharedColormap;F   XMakeStandardColormap(display,visual_info,&resources,image,map_info,     &pixel);   /*     Graphic context superclass.P   */9   context_values.background=pixel.background_color.pixel; 9   context_values.foreground=pixel.foreground_color.pixel;sH   pixel.annotate_context=XCreateGC(display,window_info.id,GCBackground |"     GCForeground,&context_values);*   if (pixel.annotate_context == (GC) NULL)O     MagickError(XServerError,"Unable to create graphic context",(char *) NULL);    /*'     Initialize Image window attributes.    */J   XGetWindowInfo(display,visual_info,map_info,&pixel,(XFontStruct *) NULL,     &resources,&window_info);    /*     Create the X image.    */#   window_info.width=image->columns; !   window_info.height=image->rows; =   FormatString(geometry,"%ux%u+0+0>",window_attributes.width,      window_attributes.height);C   (void) ParseImageGeometry(geometry,&window_info.x,&window_info.y, ,     &window_info.width,&window_info.height);L   status=XMakeImage(display,&resources,&window_info,image,window_info.width,     window_info.height);   if (status == False)G     MagickError(XServerError,"Unable to create X image",(char *) NULL);n   window_info.x=0;   window_info.y=0;   if (resources.debug)     {TH       (void) fprintf(stderr,"Image: %.1024s[%u] %ux%u ",image->filename,1         image->scene,image->columns,image->rows);        if (image->colors != 0)e4         (void) fprintf(stderr,"%uc ",image->colors);7       (void) fprintf(stderr,"%.1024s\n",image->magick);s     }    /*I     Adjust image dimensions as specified by backdrop or geometry options.e   */   width=window_info.width;   height=window_info.height;   if (resources.backdrop)      {r       /*         Center image on window.o       */0       window_info.x=(window_attributes.width/2)-&         (window_info.ximage->width/2);1       window_info.y=(window_attributes.height/2)-s'         (window_info.ximage->height/2);i$       width=window_attributes.width;&       height=window_attributes.height;     }t0   if (resources.image_geometry != (char *) NULL)     {s
       char(         default_geometry[MaxTextExtent];  	       intp         flags,         gravity;         XSizeHints         *size_hints;         /*          User specified geometry.       */#       size_hints=XAllocSizeHints();a,       if (size_hints == (XSizeHints *) NULL)E         MagickError(ResourceLimitError,"Unable to display on window",y&           "Memory allocation failed");$       size_hints->flags=(long) NULL;:       FormatString(default_geometry,"%ux%u",width,height);M       flags=XWMGeometry(display,visual_info->screen,resources.image_geometry,%L         default_geometry,window_info.border_width,size_hints,&window_info.x,@         &window_info.y,(int *) &width,(int *) &height,&gravity);$       if (flags & (XValue | YValue))	         { (           width=window_attributes.width;*           height=window_attributes.height;	         } !       XFree((void *) size_hints);      }    /*     Create the X pixmap.   */   window_info.pixmap= I     XCreatePixmap(display,window_info.id,width,height,window_info.depth); *   if (window_info.pixmap == (Pixmap) NULL)H     MagickError(XServerError,"Unable to create X pixmap",(char *) NULL);   /*!     Display pixmap on the window.%   */C   if ((width > window_info.width) || (height > window_info.height))oK     XFillRectangle(display,window_info.pixmap,window_info.annotate_context,n       0,0,width,height);D   XPutImage(display,window_info.pixmap,window_info.annotate_context,I     window_info.ximage,0,0,window_info.x,window_info.y,window_info.width,s     window_info.height);H   XSetWindowBackgroundPixmap(display,window_info.id,window_info.pixmap);'   XClearWindow(display,window_info.id);    if (resources.delay != 0)t'     XDelay(display,10*resources.delay);e   XSync(display,False);r(   return(window_info.id == root_window); }d   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %eO %                                                                             %tO %                                                                             %oO %   X D i s p l a y I m a g e                                                 %=O %                                                                             % O %                                                                             % O %                                                                             %TO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %CJ %  Method XDisplayImage displays an image via X11.  A new image is createdI %  and returned if the user interactively transforms the displayed image.s %m- %  The format of the XDisplayImage method is:d %PJ %      Image *XDisplayImage(Display *display,XResourceInfo *resource_info,A %        char **argv,int argc,Image **image,unsigned long *state)  %s+ %  A description of each parameter follows:d % D %    o loaded_image:  Method XDisplayImage returns an image when theF %      user chooses 'Open Image' from the command menu or picks a tileE %      from the image directory.  Otherwise a null image is returned.v %;E %    o display: Specifies a connection to an X server;  returned frome %      XOpenDisplay. %aK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.N %)7 %    o argv: Specifies the application's argument list.M %a/ %    o argc: Specifies the number of arguments.s % G %    o image: Specifies an address to an address of an Image structure;/ %      returned from ReadImage.n %s %m */J Export Image *XDisplayImage(Display *display,XResourceInfo *resource_info,:   char **argv,int argc,Image **image,unsigned long *state) {i4 #define MagnifySize  256  /* must be a power of 2 */ #define MagickMenus  10Q #define MaxWindows  10 #define MagickTitle  "Commands"I     static const charm     *CommandMenu[]=.     {t
       "File",|
       "Edit",t
       "View",t       "Transform",       "Enhance",       "Effects",       "F/X",       "Image Edit",        "Miscellany",o
       "Help",        (char *) NULLt     },     *FileMenu[]=     {m       "Open...",
       "Next",        "Former",p       "Select...",       "Save...",       "Print...",        "Delete...",       "New...",l       "Visual Directory...",
       "Quit",o       (char *) NULL.     },     *EditMenu[]=     { 
       "Undo",m
       "Redo",o       "Cut",
       "Copy",        "Paste",       (char *) NULLw     },     *ViewMenu[]=     {        "Half Size",       "Original Size",       "Double Size",       "Resize...",       "Apply",       "Refresh",       "Restore",       (char *) NULLd     },     *TransformMenu[]=a     {e
       "Crop", 
       "Chop", 
       "Flop",c
       "Flip",        "Rotate Right",=       "Rotate Left",       "Rotate...",       "Shear...",        "Roll...",       "Trim Edges",,       (char *) NULLl     },     *EnhanceMenu[]=      {,       "Hue...",        "Saturation...",       "Brightness...",       "Gamma...",e       "Spiff",
       "Dull",e       "Equalize",/       "Normalize",       "Negate",M       "Grayscale",       "Map...",n       "Quantize...",       (char *) NULL(     },     *EffectsMenu[]=e     {a       "Despeckle",       "Emboss",;       "Reduce Noise",        "Add Noise...",o       "Sharpen...",        "Blur...",       "Threshold...",u       "Edge Detect...",        "Spread...",       "Shade...",        "Raise...",        "Segment...",e       (char *) NULL      },     *FXMenu[]=     {i       "Solarize...",       "Swirl...",        "Implode...",[       "Wave...",       "Oil Painting...",       "Charcoal Drawing...",       (char *) NULL      },     *ImageEditMenu[]=(     {        "Annotate...",       "Draw...",       "Color...",o       "Matte...",        "Composite...",        "Add Border...",       "Add Frame...",e       "Comment...",        "Launch...",       "Region of Interest...",       (char *) NULL<     },     *MiscellanyMenu[]=     {        "Image Info",x       "Zoom Image",        "Show Preview...",       "Show Histogram",        "Show Matte",x       "Background...",       "Slide Show...",       "Preferences...",p       (char *) NULLg     },     *HelpMenu[]=     {        "Overview",-       "Browse Documentation",a       "About Display",       (char *) NULLp     },     *ShortCutsMenu[]=)     { 
       "Next",(       "Former",0       "Open...",       "Save...",       "Print...", 
       "Undo",        "Restore",       "Image Info",/
       "Quit",v       (char *) NULLl     },     *ImmutableMenu[]=e     {        "Image Info",-       "Print",
       "Next",_
       "Quit",        (char *) NULL      };     static const charu     **Menus[MagickMenus]=      {        FileMenu,        EditMenu,M       ViewMenu,        TransformMenu,       EnhanceMenu,       EffectsMenu,
       FXMenu,        ImageEditMenu,       MiscellanyMenu,        HelpMenu     };     static CommandType     CommandMenus[]=      {        NullCommand,       NullCommand,       NullCommand,       NullCommand,       NullCommand,       NullCommand,       NullCommand,       NullCommand,       NullCommand,       NullCommand,     },     FileCommands[]=p     {d       OpenCommand,       NextCommand,       FormerCommand,       SelectCommand,       SaveCommand,       PrintCommand,(       DeleteCommand,       NewCommand,        VisualDirectoryCommand,e       QuitCommand      },     EditCommands[]=      {        UndoCommand,       RedoCommand,       CutCommand,        CopyCommand,       PasteCommand     },     ViewCommands[]=      {        HalfSizeCommand,       OriginalSizeCommand,       DoubleSizeCommand,       ResizeCommand,       ApplyCommand,        RefreshCommand,        RestoreCommand     },     TransformCommands[]=     {        CropCommand,       ChopCommand,       FlopCommand,       FlipCommand,       RotateRightCommand,l       RotateLeftCommand,       RotateCommand,       ShearCommand,        RollCommand,       TrimCommand      },     EnhanceCommands[]=     {        HueCommand,)       SaturationCommand,       BrightnessCommand,       GammaCommand,        SpiffCommand,        DullCommand,       EqualizeCommand,       NormalizeCommand,        NegateCommand,       GrayscaleCommand,e       MapCommand,,       QuantizeCommandi     },     EffectsCommands[]=     {x       DespeckleCommand,        EmbossCommand,       ReduceNoiseCommand,n       AddNoiseCommand,       SharpenCommand,r       BlurCommand,       ThresholdCommand,        EdgeDetectCommand,       SpreadCommand,       ShadeCommand,a       RaiseCommand,        SegmentCommand     },     FXCommands[]=      {D       SolarizeCommand,       SwirlCommand,;       ImplodeCommand,        WaveCommand,       OilPaintCommand,       CharcoalDrawingCommand     },     ImageEditCommands[]=     {u       AnnotateCommand,       DrawCommand,       ColorCommand,n       MatteCommand,        CompositeCommand,w       AddBorderCommand,.       AddFrameCommand,       CommentCommand,p       LaunchCommand,       RegionofInterestCommand.     },     MiscellanyCommands[]=      {i       InfoCommand,       ZoomCommand,       ShowPreviewCommand,n       ShowHistogramCommand,        ShowMatteCommand,a       BackgroundCommand,       SlideShowCommand,t       PreferencesCommand     },     HelpCommands[]=n     {t       HelpCommand,!       BrowseDocumentationCommand,o       VersionCommand     },     ShortCutsCommands[]=     {=       NextCommand,       FormerCommand,       OpenCommand,       SaveCommand,       PrintCommand,/       UndoCommand,       RestoreCommand,n       InfoCommand,       QuitCommandl     },     ImmutableCommands[]=     {e       InfoCommand,       PrintCommand,y       NextCommand,       QuitCommand      };     static CommandType     *Commands[MagickMenus]=i     {i       FileCommands,r       EditCommands,U       ViewCommands,t       TransformCommands,       EnhanceCommands,       EffectsCommands,       FXCommands,        ImageEditCommands,       MiscellanyCommands,e       HelpCommands     };     char     command[MaxTextExtent],y     geometry[MaxTextExtent],!     resource_name[MaxTextExtent];w  
   CommandTypei     command_type;      ErrorHandler     warning_handler;     ImageX     *displayed_image,y     *loaded_image;     int;
     entry,     id,      status;k     KeySym     key_symbol;d     MonitorHandler     handler,     monitor_handler;     register int     i;  
   static char)%     working_directory[MaxTextExtent];y     static XPointm
     vid_info;      static XWindowInfo      *magick_windows[MaxWindows];     static unsigned int      number_windows;a  
   struct stata     file_info;     time_t
     timer,     timestamp,     update_time;     unsigned int     context_mask;E     Window     root_window;     XClassHint     *class_hints;1     XEvent
     event;  
   XFontStruct      *font_info;x     XGCValuesp     context_values;d     XPixelInfo     *icon_pixel,     *pixel;E     XResourceInfoH     *icon_resources;     XStandardColormap      *icon_map,     *map_info;  
   XVisualInfoi     *icon_visual,      *visual_info;      XWindowChanges     window_changes;t  
   XWindows
     *windows;   
   XWMHints     *manager_hints;n     displayed_image=(*image);r3   TransformRGBImage(displayed_image,RGBColorspace);m(   monitor_handler=(MonitorHandler) NULL;&   warning_handler=(ErrorHandler) NULL;'   windows=XSetWindows((XWindows *) ~0);-#   if (windows != (XWindows *) NULL)      { &       (void) chdir(working_directory);:       monitor_handler=SetMonitorHandler(XProgressMonitor);7       warning_handler=resource_info->display_warnings ? M         SetWarningHandler(XWarning) : SetWarningHandler((ErrorHandler) NULL); +       (void) signal(SIGINT,XSignalHandler);-,       (void) signal(SIGSEGV,XSignalHandler);     }o   else     {        /*#         Allocate windows structure.        */4       resource_info->colors=displayed_image->colors;E       windows=XSetWindows(XInitializeWindows(display,resource_info)); '       if (windows == (XWindows *) NULL) >         MagickError(XServerError,"Unable to create X windows",&           "Memory allocation failed");       /*         Initialize window id's.        */       number_windows=0;i8       magick_windows[number_windows++]=(&windows->icon);<       magick_windows[number_windows++]=(&windows->backdrop);9       magick_windows[number_windows++]=(&windows->image); 8       magick_windows[number_windows++]=(&windows->info);;       magick_windows[number_windows++]=(&windows->command); :       magick_windows[number_windows++]=(&windows->widget);9       magick_windows[number_windows++]=(&windows->popup);(;       magick_windows[number_windows++]=(&windows->magnify);g7       magick_windows[number_windows++]=(&windows->pan);..       for (i=0; i < (int) number_windows; i++),         magick_windows[i]->id=(Window) NULL;       vid_info.x=0;o       vid_info.y=0;g     }    /*     Initialize font info.o   */1   if (windows->font_info != (XFontStruct *) NULL) *     XFreeFont(display,windows->font_info);<   windows->font_info=XBestFont(display,resource_info,False);1   if (windows->font_info == (XFontStruct *) NULL)iH     MagickError(XServerError,"Unable to load font",resource_info->font);   /*!     Initialize Standard Colormap.h   */   map_info=windows->map_info;    icon_map=windows->icon_map; #   visual_info=windows->visual_info;a#   icon_visual=windows->icon_visual;    pixel=windows->pixel_info;!   icon_pixel=windows->icon_pixel;(   font_info=windows->font_info; )   icon_resources=windows->icon_resources;(#   class_hints=windows->class_hints;n'   manager_hints=windows->manager_hints; 7   root_window=XRootWindow(display,visual_info->screen);=   loaded_image=(Image *) NULL;   if (resource_info->debug)      { 8       (void) fprintf(stderr,"Image: %.1024s[%u] %ux%u ",9         displayed_image->filename,displayed_image->scene,x8         displayed_image->columns,displayed_image->rows);'       if (displayed_image->colors != 0) >         (void) fprintf(stderr,"%uc ",displayed_image->colors);A       (void) fprintf(stderr,"%.1024s\n",displayed_image->magick);a     }lJ   XMakeStandardColormap(display,visual_info,resource_info,displayed_image,     map_info,pixel);!   displayed_image->tainted=False;x   /*     Initialize graphic context.    */$   windows->context.id=(Window) NULL;>   XGetWindowInfo(display,visual_info,map_info,pixel,font_info,%     resource_info,&windows->context); %   class_hints->res_name="superclass"; #   class_hints->res_class="Display"; -   manager_hints->flags=InputHint | StateHint;i   manager_hints->input=False;T.   manager_hints->initial_state=WithdrawnState;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->context);o   if (resource_info->debug) N     (void) fprintf(stderr,"Window id: 0x%lx (context)\n",windows->context.id);:   context_values.background=pixel->background_color.pixel;%   context_values.font=font_info->fid;d:   context_values.foreground=pixel->foreground_color.pixel;*   context_values.graphics_exposures=False;J   context_mask=GCBackground | GCFont | GCForeground | GCGraphicsExposures;+   if (pixel->annotate_context != (GC) NULL) -     XFreeGC(display,pixel->annotate_context);(   pixel->annotate_context=H     XCreateGC(display,windows->context.id,context_mask,&context_values);+   if (pixel->annotate_context == (GC) NULL) O     MagickError(XServerError,"Unable to create graphic context",(char *) NULL);r5   context_values.background=pixel->depth_color.pixel;e)   if (pixel->widget_context != (GC) NULL)*+     XFreeGC(display,pixel->widget_context);    pixel->widget_context=H     XCreateGC(display,windows->context.id,context_mask,&context_values);)   if (pixel->widget_context == (GC) NULL)xO     MagickError(XServerError,"Unable to create graphic context",(char *) NULL);i:   context_values.background=pixel->foreground_color.pixel;:   context_values.foreground=pixel->background_color.pixel;   context_values.plane_mask=:     context_values.background ^ context_values.foreground;,   if (pixel->highlight_context != (GC) NULL).     XFreeGC(display,pixel->highlight_context);A   pixel->highlight_context=XCreateGC(display,windows->context.id,a0     context_mask | GCPlaneMask,&context_values);,   if (pixel->highlight_context == (GC) NULL)O     MagickError(XServerError,"Unable to create graphic context",(char *) NULL); .   XDestroyWindow(display,windows->context.id);   /*     Initialize icon window.%   */N   XGetWindowInfo(display,icon_visual,icon_map,icon_pixel,(XFontStruct *) NULL,#     icon_resources,&windows->icon); 6   windows->icon.geometry=resource_info->icon_geometry;8   XBestIconSize(display,&windows->icon,displayed_image);$   windows->icon.attributes.colormap=2     XDefaultColormap(display,icon_visual->screen);I   windows->icon.attributes.event_mask=ExposureMask | StructureNotifyMask;    class_hints->res_name="icon"; -   manager_hints->flags=InputHint | StateHint;    manager_hints->input=False; +   manager_hints->initial_state=IconicState; F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->icon);   if (resource_info->debug)aH     (void) fprintf(stderr,"Window id: 0x%lx (icon)\n",windows->icon.id);   /*/     Initialize graphic context for icon window.o   */0   if (icon_pixel->annotate_context != (GC) NULL)2     XFreeGC(display,icon_pixel->annotate_context);?   context_values.background=icon_pixel->background_color.pixel;e?   context_values.foreground=icon_pixel->foreground_color.pixel;sB   icon_pixel->annotate_context=XCreateGC(display,windows->icon.id,1     GCBackground | GCForeground,&context_values);p0   if (icon_pixel->annotate_context == (GC) NULL)O     MagickError(XServerError,"Unable to create graphic context",(char *) NULL);a>   windows->icon.annotate_context=icon_pixel->annotate_context;   /*     Initialize Image window.   */)   if (windows->image.id != (Window) NULL)      { &       FreeMemory(windows->image.name);+       FreeMemory(windows->image.icon_name);o     }d>   XGetWindowInfo(display,visual_info,map_info,pixel,font_info,#     resource_info,&windows->image); >   windows->image.shape=True;  /* non-rectangular shape hint */@   windows->image.shared_memory=resource_info->use_shared_memory;J   windows->image.name=(char *) AllocateMemory(MaxTextExtent*sizeof(char));O   windows->image.icon_name=(char *) AllocateMemory(MaxTextExtent*sizeof(char)); J   if ((windows->image.name == NULL) || (windows->image.icon_name == NULL))C     MagickError(ResourceLimitError,"Unable to create Image window",n"       "Memory allocation failed");O   if ((resource_info->title != (char *) NULL) && !(*state & MontageImageState))      {a       /*#         User specified window name.a       */7       LabelImage(displayed_image,resource_info->title);)@       (void) strcpy(windows->image.name,displayed_image->label);E       (void) strcpy(windows->image.icon_name,displayed_image->label);      }    else     {(       register char"         *p;e         register Image         *q;a         unsigned int         count;         /*0         Window name is the base of the filename.       */F       p=displayed_image->filename+Extent(displayed_image->filename)-1;M       while ((p > displayed_image->filename) && !IsBasenameSeparator(*(p-1)))o         p--;D       FormatString(windows->image.name,"ImageMagick: %.1024s[%u]",p,          displayed_image->scene);       q=displayed_image;+       while (q->previous != (Image *) NULL)          q=q->previous;7       for (count=1; q->next != (Image *) NULL; count++)I         q=q->next;J       FormatString(windows->image.name,"ImageMagick: %.1024s[%u of %u]",p,&         displayed_image->scene,count);:       if ((displayed_image->previous == (Image *) NULL) &&6           (displayed_image->next == (Image *) NULL) &&(           (displayed_image->scene == 0))C         FormatString(windows->image.name,"ImageMagick: %.1024s",p);i0       (void) strcpy(windows->image.icon_name,p);     },   if (resource_info->immutable)s"     windows->image.immutable=True;6   windows->image.use_pixmap=resource_info->use_pixmap;8   windows->image.geometry=resource_info->image_geometry;0   windows->image.width=displayed_image->columns;.   windows->image.height=displayed_image->rows;&   FormatString(geometry,"%ux%u+0+0>!",/     XDisplayWidth(display,visual_info->screen), 1     XDisplayHeight(display,visual_info->screen));)I   (void) ParseImageGeometry(geometry,&windows->image.x,&windows->image.y,n2     &windows->image.width,&windows->image.height);K   windows->image.attributes.event_mask=ButtonMotionMask | ButtonPressMask |eG     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask |X<     KeyReleaseMask | LeaveWindowMask | OwnerGrabButtonMask |F     PropertyChangeMask | StructureNotifyMask | SubstructureNotifyMask;>   XGetWindowInfo(display,visual_info,map_info,pixel,font_info,&     resource_info,&windows->backdrop);K   if ((resource_info->backdrop) || (windows->backdrop.id != (Window) NULL))i     {z       /*#         Initialize backdrop window.s       */       windows->backdrop.x=0;       windows->backdrop.y=0;4       windows->backdrop.name="ImageMagick Backdrop";2       windows->backdrop.flags=USSize | USPosition;I       windows->backdrop.width=XDisplayWidth(display,visual_info->screen);rK       windows->backdrop.height=XDisplayHeight(display,visual_info->screen);('       windows->backdrop.border_width=0;0'       windows->backdrop.immutable=True;rJ       windows->backdrop.attributes.do_not_propagate_mask=ButtonPressMask |         ButtonReleaseMask;N       windows->backdrop.attributes.event_mask=ButtonPressMask | KeyPressMask |         StructureNotifyMask;:       windows->backdrop.attributes.override_redirect=True;'       class_hints->res_name="backdrop";wB       manager_hints->flags=IconWindowHint | InputHint | StateHint;2       manager_hints->icon_window=windows->icon.id;        manager_hints->input=True;#       manager_hints->initial_state= :         resource_info->iconic ? IconicState : NormalState;J       XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,         &windows->backdrop);       if (resource_info->debug))>         (void) fprintf(stderr,"Window id: 0x%lx (backdrop)\n",            windows->backdrop.id);/       XMapWindow(display,windows->backdrop.id); 1       XClearWindow(display,windows->backdrop.id); -       if (windows->image.id != (Window) NULL)t	         { 4           XDestroyWindow(display,windows->image.id);*           windows->image.id=(Window) NULL;	         }r       /*2         Position image in the center the backdrop.       */'       windows->image.flags|=USPosition;EF       windows->image.x=(XDisplayWidth(display,visual_info->screen)/2)-!         (windows->image.width/2);(G       windows->image.y=(XDisplayHeight(display,visual_info->screen)/2)- "         (windows->image.height/2);     }f+   if (resource_info->name == (char *) NULL) 5     class_hints->res_name=resource_info->client_name;    else.     class_hints->res_name=resource_info->name;>   manager_hints->flags=IconWindowHint | InputHint | StateHint;.   manager_hints->icon_window=windows->icon.id;   manager_hints->input=True;   manager_hints->initial_state=i6     resource_info->iconic ? IconicState : NormalState;0   if (windows->group_leader.id != (Window) NULL)     {        /*         Follow the leader.       */,       manager_hints->flags|=WindowGroupHint;;       manager_hints->window_group=windows->group_leader.id;%I       XSelectInput(display,windows->group_leader.id,StructureNotifyMask);        if (resource_info->debug) B         (void) fprintf(stderr,"Window id: 0x%lx (group leader)\n",$           windows->group_leader.id);     }    XMakeWindow(display,L     (Window) (resource_info->backdrop ? windows->backdrop.id : root_window),9     argv,argc,class_hints,manager_hints,&windows->image); N   XChangeProperty(display,windows->image.id,windows->im_protocols,XA_STRING,8,.     PropModeReplace,(unsigned char *) NULL,0);0   if (windows->group_leader.id != (Window) NULL)M     XSetTransientForHint(display,windows->image.id,windows->group_leader.id);%   if (resource_info->debug)%J     (void) fprintf(stderr,"Window id: 0x%lx (image)\n",windows->image.id);   /*     Initialize Info widget.f   */>   XGetWindowInfo(display,visual_info,map_info,pixel,font_info,"     resource_info,&windows->info);   windows->info.name="Info";!   windows->info.icon_name="Info";    windows->info.border_width=1;n   windows->info.x=2;   windows->info.y=2;!   windows->info.flags|=PPosition;c4   windows->info.attributes.win_gravity=UnmapGravity;&   windows->info.attributes.event_mask=9     ButtonPressMask | ExposureMask | StructureNotifyMask;h   class_hints->res_name="info";g?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=False;u+   manager_hints->initial_state=NormalState;H0   manager_hints->window_group=windows->image.id;L   XMakeWindow(display,windows->image.id,argv,argc,class_hints,manager_hints,     &windows->info);@   windows->info.highlight_stipple=XCreateBitmapFromData(display,N     windows->info.id,(char *) HighlightBitmap,HighlightWidth,HighlightHeight);=   windows->info.shadow_stipple=XCreateBitmapFromData(display,nE     windows->info.id,(char *) ShadowBitmap,ShadowWidth,ShadowHeight);hC   XSetTransientForHint(display,windows->info.id,windows->image.id);    if (windows->image.mapped)C     XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (resource_info->debug)eH     (void) fprintf(stderr,"Window id: 0x%lx (info)\n",windows->info.id);   /*     Initialize Command widget.   */>   XGetWindowInfo(display,visual_info,map_info,pixel,font_info,%     resource_info,&windows->command);a$   windows->command.data=MagickMenus;E   (void) XCommandWidget(display,windows,CommandMenu,(XEvent *) NULL);dK   FormatString(resource_name,"%.1024s.command",resource_info->client_name);oO   windows->command.geometry=XGetResourceClass(resource_info->resource_database,i,     resource_name,"geometry",(char *) NULL);$   windows->command.name=MagickTitle;"   windows->command.border_width=0;$   windows->command.flags|=PPosition;M   windows->command.attributes.event_mask=ButtonMotionMask | ButtonPressMask | J     ButtonReleaseMask | EnterWindowMask | ExposureMask | LeaveWindowMask |.     OwnerGrabButtonMask | StructureNotifyMask;"   class_hints->res_name="command";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;n   manager_hints->input=False; +   manager_hints->initial_state=NormalState;U0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->command);aE   windows->command.highlight_stipple=windows->info.highlight_stipple; ?   windows->command.shadow_stipple=windows->info.shadow_stipple;pF   XSetTransientForHint(display,windows->command.id,windows->image.id);   if (windows->command.mapped),     XMapRaised(display,windows->command.id);   if (resource_info->debug) N     (void) fprintf(stderr,"Window id: 0x%lx (command)\n",windows->command.id);   /*     Initialize Widget window._   */*   if (windows->widget.id != (Window) NULL)%     FreeMemory(windows->widget.name); >   XGetWindowInfo(display,visual_info,map_info,pixel,font_info,$     resource_info,&windows->widget);J   FormatString(resource_name,"%.1024s.widget",resource_info->client_name);N   windows->widget.geometry=XGetResourceClass(resource_info->resource_database,,     resource_name,"geometry",(char *) NULL);K   windows->widget.name=(char *) AllocateMemory(MaxTextExtent*sizeof(char));d#   if (windows->widget.name == NULL)iC     MagickError(ResourceLimitError,"Unable to create Image window",i"       "Memory allocation failed");   *windows->widget.name='\0'; !   windows->widget.border_width=0;n#   windows->widget.flags|=PPosition; 6   windows->widget.attributes.backing_store=WhenMapped;-   windows->widget.attributes.save_under=True;iL   windows->widget.attributes.event_mask=ButtonMotionMask | ButtonPressMask |G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask |w<     KeyReleaseMask | LeaveWindowMask | OwnerGrabButtonMask |     StructureNotifyMask;!   class_hints->res_name="widget"; ?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;P   manager_hints->input=True;+   manager_hints->initial_state=NormalState;-0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->widget);D   windows->widget.highlight_stipple=windows->info.highlight_stipple;>   windows->widget.shadow_stipple=windows->info.shadow_stipple;E   XSetTransientForHint(display,windows->widget.id,windows->image.id);    if (resource_info->debug) L     (void) fprintf(stderr,"Window id: 0x%lx (widget)\n",windows->widget.id);   /*     Initialize popup window.   */)   if (windows->popup.id != (Window) NULL) $     FreeMemory(windows->popup.name);>   XGetWindowInfo(display,visual_info,map_info,pixel,font_info,#     resource_info,&windows->popup); J   windows->popup.name=(char *) AllocateMemory(MaxTextExtent*sizeof(char));"   if (windows->popup.name == NULL)C     MagickError(ResourceLimitError,"Unable to create Image window", "       "Memory allocation failed");   *windows->popup.name='\0';    windows->popup.border_width=0;"   windows->popup.flags|=PPosition;5   windows->popup.attributes.backing_store=WhenMapped; ,   windows->popup.attributes.save_under=True;K   windows->popup.attributes.event_mask=ButtonMotionMask | ButtonPressMask |%G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask |d;     KeyReleaseMask | LeaveWindowMask | StructureNotifyMask;u    class_hints->res_name="popup";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;e   manager_hints->input=True;+   manager_hints->initial_state=NormalState;X0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->popup); C   windows->popup.highlight_stipple=windows->info.highlight_stipple;r=   windows->popup.shadow_stipple=windows->info.shadow_stipple; D   XSetTransientForHint(display,windows->popup.id,windows->image.id);   if (resource_info->debug)nK     (void) fprintf(stderr,"Window id: 0x%lx (pop up)\n",windows->popup.id);s   /*)     Initialize Magnify window and cursor.s   */+   if (windows->magnify.id != (Window) NULL)c&     FreeMemory(windows->magnify.name);>   XGetWindowInfo(display,visual_info,map_info,pixel,font_info,%     resource_info,&windows->magnify);iB   windows->magnify.shared_memory=resource_info->use_shared_memory;K   FormatString(resource_name,"%.1024s.magnify",resource_info->client_name);NO   windows->magnify.geometry=XGetResourceClass(resource_info->resource_database,t,     resource_name,"geometry",(char *) NULL);L   windows->magnify.name=(char *) AllocateMemory(MaxTextExtent*sizeof(char));$   if (windows->magnify.name == NULL)E     MagickError(ResourceLimitError,"Unable to create Magnify window",_"       "Memory allocation failed");K   FormatString(windows->magnify.name,"Magnify %uX",resource_info->magnify);n@   windows->magnify.cursor=XMakeCursor(display,windows->image.id,7     map_info->colormap,resource_info->background_color, %     resource_info->foreground_color);e/   if (windows->magnify.cursor == (Cursor) NULL)eF     MagickError(XServerError,"Unable to create cursor",(char *) NULL);%   windows->magnify.width=MagnifySize;u&   windows->magnify.height=MagnifySize;$   windows->magnify.flags|=PPosition;)   windows->magnify.min_width=MagnifySize;m*   windows->magnify.min_height=MagnifySize;)   windows->magnify.width_inc=MagnifySize;M*   windows->magnify.height_inc=MagnifySize;/   windows->magnify.data=resource_info->magnify;m=   windows->magnify.attributes.cursor=windows->magnify.cursor;*N   windows->magnify.attributes.event_mask=ButtonPressMask | ButtonReleaseMask |H     ExposureMask | KeyPressMask | KeyReleaseMask | OwnerGrabButtonMask |     StructureNotifyMask;"   class_hints->res_name="magnify";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;>   manager_hints->input=True;+   manager_hints->initial_state=NormalState;a0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->magnify);e   if (resource_info->debug) N     (void) fprintf(stderr,"Window id: 0x%lx (magnify)\n",windows->magnify.id);F   XSetTransientForHint(display,windows->magnify.id,windows->image.id);   /*     Initialize panning window.   */>   XGetWindowInfo(display,visual_info,map_info,pixel,font_info,!     resource_info,&windows->pan);i   windows->pan.name="Pan Icon";s)   windows->pan.width=windows->icon.width;t+   windows->pan.height=windows->icon.height;iG   FormatString(resource_name,"%.1024s.pan",resource_info->client_name);nK   windows->pan.geometry=XGetResourceClass(resource_info->resource_database,t,     resource_name,"geometry",(char *) NULL);N   (void) XParseGeometry(windows->pan.geometry,&windows->pan.x,&windows->pan.y,.     &windows->pan.width,&windows->pan.height);    windows->pan.flags|=PPosition;   windows->pan.immutable=True;I   windows->pan.attributes.event_mask=ButtonMotionMask | ButtonPressMask |0F     ButtonReleaseMask | ExposureMask | KeyPressMask | KeyReleaseMask |     StructureNotifyMask;   class_hints->res_name="pan";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=True;+   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->pan);"   if (resource_info->debug) F     (void) fprintf(stderr,"Window id: 0x%lx (pan)\n",windows->pan.id);B   XSetTransientForHint(display,windows->pan.id,windows->image.id);   if (windows->info.mapped)"C     XWithdrawWindow(display,windows->info.id,windows->info.screen); H   if (!windows->image.mapped || (windows->backdrop.id != (Window) NULL))*     XMapWindow(display,windows->image.id);   /*2     Set our progress monitor and warning handlers.   *//   if (monitor_handler == (MonitorHandler) NULL)l8     monitor_handler=SetMonitorHandler(XProgressMonitor);-   if (warning_handler == (ErrorHandler) NULL) 5     warning_handler=resource_info->display_warnings ? K       SetWarningHandler(XWarning) : SetWarningHandler((ErrorHandler) NULL);i'   (void) signal(SIGINT,XSignalHandler);;(   (void) signal(SIGSEGV,XSignalHandler);   /**     Initialize Image and Magnify X images.   */   windows->image.x=0;m   windows->image.y=0; J   status=XMakeImage(display,resource_info,&windows->image,displayed_image,4     displayed_image->columns,displayed_image->rows);   if (status == False)G     MagickError(XServerError,"Unable to create X image",(char *) NULL);    if (windows->image.mapped)<     XRefreshWindow(display,&windows->image,(XEvent *) NULL);"   SignatureImage(displayed_image);3   handler=SetMonitorHandler((MonitorHandler) NULL);nK   status=XMakeImage(display,resource_info,&windows->magnify,(Image *) NULL,b4     windows->magnify.width,windows->magnify.height);$   (void) SetMonitorHandler(handler);   if (status == False)O     MagickError(XServerError,"Unable to create X magnify image",(char *) NULL);    if (windows->magnify.mapped),     XMapRaised(display,windows->magnify.id);   if (windows->image.mapped)F     if (((int) windows->image.width < windows->image.ximage->width) ||F         ((int) windows->image.height < windows->image.ximage->height))*       XMapRaised(display,windows->pan.id);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);*   XSync(display,False);    /*     Respond to events.   */;   timer=time((time_t *) NULL)+(resource_info->delay/100)+1;l   update_time=0;   if (resource_info->update)     {p       /*3         Determine when file data was last modified.m       */8       status=stat(displayed_image->filename,&file_info);       if (status == 0)'         update_time=file_info.st_mtime;      }    *state&=(~FormerImageState);   *state&=(~MontageImageState);d   *state&=(~NextImageState);   do   {      /*       Handle a window event.     */6     if (windows->image.mapped && resource_info->delay)       { *         if (timer < time((time_t *) NULL))           { '             if (!resource_info->update)-1               *state|=NextImageState | ExitState;f             else               {                  /*7                   Determine if image file was modified.a                 */B                 status=stat(displayed_image->filename,&file_info);                  if (status == 0)8                   if (update_time != file_info.st_mtime)                     {                        /*(                         Redisplay image.                       */G                       FormatString(resource_info->image_info->filename, B                         "%.1024s:%.1024s",displayed_image->magick,3                         displayed_image->filename); H                       loaded_image=ReadImage(resource_info->image_info);9                       if (loaded_image != (Image *) NULL)a;                         *state|=NextImageState | ExitState;)                     }mI                 timer=time((time_t *) NULL)+(resource_info->delay/100)+1;r               }p           }%9         if (XEventsQueued(display,QueuedAfterFlush) == 0)l           {l             /*(               Do not block if delay > 0.             */-             XDelay(display,SuspendTime << 2);              continue;            }p       }e$     timestamp=time((time_t *) NULL);     XNextEvent(display,&event);      if (!windows->image.stasis) B       windows->image.stasis=(time((time_t *) NULL)-timestamp) > 0;1     if (event.xany.window == windows->command.id)_       {X
         /*3           Select a command from the Command widget.,
         */>         id=XCommandWidget(display,windows,CommandMenu,&event);         if (id < 0)n           continue;g/         (void) strcpy(command,CommandMenu[id]);;&         command_type=CommandMenus[id];         if (id < MagickMenus)p           {              /*2               Select a command from a pop-up menu.             */H             entry=XMenuWidget(display,windows,CommandMenu[id],Menus[id],               command);d             if (entry < 0)               continue; 4             (void) strcpy(command,Menus[id][entry]);-             command_type=Commands[id][entry];i           }+(         if (command_type != NullCommand)D           loaded_image=XMagickCommand(display,resource_info,windows,+             command_type,&displayed_image);s         continue;        }n     switch (event.type)      {>       case ButtonPress:i       {f!         if (resource_info->debug)nB           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y);m0         if ((event.xbutton.button == Button3) &&-             (event.xbutton.state & Mod1Mask))            {i             /*-               Convert Alt-Button3 to Button2.a             */)             event.xbutton.button=Button2; -             event.xbutton.state&=(~Mod1Mask);>           }t9         if (event.xbutton.window == windows->backdrop.id)h           {,G             XSetInputFocus(display,event.xbutton.window,RevertToParent,a"               event.xbutton.time);             break;           } 6         if (event.xbutton.window == windows->image.id)           {r)             switch (event.xbutton.button)s
             {y               case Button1:l               {i-                 if (resource_info->immutable)a                   {c                     /*?                       Select a command from the Immutable menu.)                     */O                     entry=XMenuWidget(display,windows,"Commands",ImmutableMenu,e                       command);n#                     if (entry >= 0)hH                       loaded_image=XMagickCommand(display,resource_info,K                         windows,ImmutableCommands[entry],&displayed_image);_                     break;                   }*                 /*+                   Map/unmap Command widget.a                 */,                 if (windows->command.mapped)>                   XWithdrawWindow(display,windows->command.id,-                     windows->command.screen);u                 else                   {wF                     (void) XCommandWidget(display,windows,CommandMenu,'                       (XEvent *) NULL);%<                     XMapRaised(display,windows->command.id);                   }                  break;               }                case Button2:                {                  /*8                   User pressed the image magnify button.                 */P                 (void) XMagickCommand(display,resource_info,windows,ZoomCommand,$                   &displayed_image);6                 XMagnifyImage(display,windows,&event);                 break;               }                case Button3:                { -                 if (resource_info->immutable)                    {                      /*?                       Select a command from the Immutable menu.%                     */O                     entry=XMenuWidget(display,windows,"Commands",ImmutableMenu,                        command);t#                     if (entry >= 0)iH                       loaded_image=XMagickCommand(display,resource_info,K                         windows,ImmutableCommands[entry],&displayed_image);                      break;                   } >                 if (displayed_image->montage != (char *) NULL)                   {h                     /*J                       Open or delete a tile from a visual image directory.                     */J                     loaded_image=XTileImage(display,resource_info,windows,.                       displayed_image,&event);7                     if (loaded_image != (Image *) NULL) M                       *state|=MontageImageState | NextImageState | ExitState; 0                     vid_info.x=windows->image.x;0                     vid_info.y=windows->image.y;                     break;                   }x                 /*<                   Select a command from the Short Cuts menu.                 */M                 entry=XMenuWidget(display,windows,"Short Cuts",ShortCutsMenu,o                   command);-                 if (entry >= 0)oL                   loaded_image=XMagickCommand(display,resource_info,windows,?                     ShortCutsCommands[entry],&displayed_image);s                 break;               }                default:                 break;
             }r             break;           } 8         if (event.xbutton.window == windows->magnify.id)           {r             int                factor;a               static const charW               *MagnifyMenu[]=n               {e                 "2",                 "4",                 "5",                 "6",                 "7",                 "8",                 "9",                 "3",                 (char *) NULL,               };               static KeySymm                MagnifyCommands[]=               {o                 XK_2,                  XK_4,                  XK_5,c                 XK_6,                  XK_7,t                 XK_8,C                 XK_9,i                 XK_3               };               /*;               Select a magnify factor from the pop-up menu.              */N             factor=XMenuWidget(display,windows,"Magnify",MagnifyMenu,command);             if (factor >= 0)O               XMagnifyWindowCommand(display,windows,0,MagnifyCommands[factor]);_             break;           }p4         if (event.xbutton.window == windows->pan.id)           {i.             XPanImage(display,windows,&event);             break;           }oA         timer=time((time_t *) NULL)+(resource_info->delay/100)+1;n         break;       }%       case ButtonRelease:%       {%!         if (resource_info->debug)%D           (void) fprintf(stderr,"Button Release: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y);          break;       }        case ClientMessage:        { !         if (resource_info->debug) I           (void) fprintf(stderr,"Client Message: 0x%lx 0x%lx %d 0x%lx\n", <             event.xclient.window,event.xclient.message_type,J             event.xclient.format,(unsigned long) event.xclient.data.l[0]);@         if (event.xclient.message_type == windows->im_protocols)           { I             if (*event.xclient.data.l == (int) windows->im_update_widget)%               { 2                 windows->command.name=MagickTitle;2                 windows->command.data=MagickMenus;B                 (void) XCommandWidget(display,windows,CommandMenu,#                   (XEvent *) NULL);e                 break;               }IK             if (*event.xclient.data.l == (int) windows->im_update_colormap)s               {I                 /*=                   Update graphic context and window colormap.a                 */8                 for (i=0; i < (int) number_windows; i++)                 {o@                   if (magick_windows[i]->id == windows->icon.id)                     continue; J                   context_values.background=pixel->background_color.pixel;J                   context_values.foreground=pixel->foreground_color.pixel;H                   XChangeGC(display,magick_windows[i]->annotate_context,2                     context_mask,&context_values);F                   XChangeGC(display,magick_windows[i]->widget_context,2                     context_mask,&context_values);J                   context_values.background=pixel->foreground_color.pixel;J                   context_values.foreground=pixel->background_color.pixel;,                   context_values.plane_mask=J                     context_values.background ^ context_values.foreground;I                   XChangeGC(display,magick_windows[i]->highlight_context,"@                     context_mask | GCPlaneMask,&context_values);A                   magick_windows[i]->attributes.background_pixel=o2                     pixel->background_color.pixel;=                   magick_windows[i]->attributes.border_pixel=L.                     pixel->border_color.pixel;L                   magick_windows[i]->attributes.colormap=map_info->colormap;H                   XChangeWindowAttributes(display,magick_windows[i]->id,L                     magick_windows[i]->mask,&magick_windows[i]->attributes);                 }%(                 if (windows->pan.mapped)                   { G                     XSetWindowBackgroundPixmap(display,windows->pan.id,.+                       windows->pan.pixmap);m:                     XClearWindow(display,windows->pan.id);7                     XDrawPanRectangle(display,windows);c                   } :                 if (windows->backdrop.id != (Window) NULL)?                   XInstallColormap(display,map_info->colormap);.                 break;               } H             if (*event.xclient.data.l == (int) windows->im_former_image)               {m5                 *state|=FormerImageState | ExitState;"                 break;               }NF             if (*event.xclient.data.l == (int) windows->im_next_image)               { 3                 *state|=NextImageState | ExitState;M                 break;               } I             if (*event.xclient.data.l == (int) windows->im_retain_colors)d               { *                 *state|=RetainColorsState;                 break;               }l@             if (*event.xclient.data.l == (int) windows->im_exit)               {m"                 *state|=ExitState;                 break;               }m             break;           }eA         if (event.xclient.message_type == windows->dnd_protocols)f           {=             Atom               selection,               type;h               into               format;,               unsigned char                *data;               unsigned long                after,               length;                /*A               Display image named by the Drag-and-Drop selection.a             */7             if (((int) (*event.xclient.data.l) != 2) && 7                 ((int) (*event.xclient.data.l) != 128))                break;@             selection=XInternAtom(display,"DndSelection",False);G             status=XGetWindowProperty(display,root_window,selection,0L,eI               MaxTextExtent-1,False,(Atom) AnyPropertyType,&type,&format,d$               &length,&after,&data);5             if ((status != Success) || (length == 0))w               break;3             if ((int) (*event.xclient.data.l) == 2)m               {o                 /*                   Offix DND.                 */B                 (void) strcpy(resource_info->image_info->filename,!                   (char *) data);t               }              else               {O                 /*                   XDND.                  */<                 if (strncmp((char *) data, "file:", 5) != 0)                   {o)                     XFree((void *) data);n                     break;                   }oB                 (void) strcpy(resource_info->image_info->filename,%                   ((char *) data)+5);;               }o>             loaded_image=ReadImage(resource_info->image_info);/             if (loaded_image != (Image *) NULL) 1               *state|=NextImageState | ExitState;i!             XFree((void *) data);n             break;           }h
         /*0           If client window delete message, exit.
         */L         if ((int) event.xclient.message_type != (int) windows->wm_protocols)           break;E         if (*event.xclient.data.l != (int) windows->wm_delete_window)o           break;J         XWithdrawWindow(display,event.xclient.window,visual_info->screen);6         if (event.xclient.window == windows->image.id)           {s             *state|=ExitState;             break;           } 4         if (event.xclient.window == windows->pan.id)           {w             /*E               Restore original image size when pan window is deleted.b             */M             windows->image.window_changes.width=windows->image.ximage->width;nO             windows->image.window_changes.height=windows->image.ximage->height;tA             (void) XConfigureImage(display,resource_info,windows,                displayed_image);            }*         break;       }e       case ConfigureNotify:        {t!         if (resource_info->debug)oK           (void) fprintf(stderr,"Configure Notify: 0x%lx %dx%d+%d+%d %d\n", ;             event.xconfigure.window,event.xconfigure.width,oJ             event.xconfigure.height,event.xconfigure.x,event.xconfigure.y,)             event.xconfigure.send_event); 9         if (event.xconfigure.window == windows->image.id)(           {w             /*3               Image window has a new configuration.              */1             if (event.xconfigure.send_event != 0)n               {                  XWindowChanges!                   window_changes;                    /*N                   Position the transient windows relative of the Image window.                 */?                 if (windows->command.geometry == (char *) NULL)l/                   if (!windows->command.mapped)p                     {t)                       windows->command.x= E                         event.xconfigure.x-windows->command.width-25;t<                       windows->command.y=event.xconfigure.y;J                       XConstrainWindowPosition(display,&windows->command);:                       window_changes.x=windows->command.x;:                       window_changes.y=windows->command.y;G                       XReconfigureWMWindow(display,windows->command.id, K                         windows->command.screen,CWX | CWY,&window_changes);>                     };>                 if (windows->widget.geometry == (char *) NULL).                   if (!windows->widget.mapped)                     {:(                       windows->widget.x=E                         event.xconfigure.x+event.xconfigure.width/10;e(                       windows->widget.y=F                         event.xconfigure.y+event.xconfigure.height/10;I                       XConstrainWindowPosition(display,&windows->widget); 9                       window_changes.x=windows->widget.x;m9                       window_changes.y=windows->widget.y;aF                       XReconfigureWMWindow(display,windows->widget.id,J                         windows->widget.screen,CWX | CWY,&window_changes);                     }S?                 if (windows->magnify.geometry == (char *) NULL) /                   if (!windows->magnify.mapped)_                     { )                       windows->magnify.x=iE                         event.xconfigure.x+event.xconfigure.width+25;a<                       windows->magnify.y=event.xconfigure.y;J                       XConstrainWindowPosition(display,&windows->magnify);:                       window_changes.x=windows->magnify.x;:                       window_changes.y=windows->magnify.y;G                       XReconfigureWMWindow(display,windows->magnify.id,=K                         windows->magnify.screen,CWX | CWY,&window_changes);d                     } ;                 if (windows->pan.geometry == (char *) NULL)&+                   if (!windows->pan.mapped)+                     {u%                       windows->pan.x=,E                         event.xconfigure.x+event.xconfigure.width+25; %                       windows->pan.y=+F                         event.xconfigure.y+windows->magnify.height+50;F                       XConstrainWindowPosition(display,&windows->pan);6                       window_changes.x=windows->pan.x;6                       window_changes.y=windows->pan.y;C                       XReconfigureWMWindow(display,windows->pan.id,oG                         windows->pan.screen,CWX | CWY,&window_changes);t                     }                } I             if ((event.xconfigure.width == (int) windows->image.width) && I                 (event.xconfigure.height == (int) windows->image.height))                {(*                 if (windows->image.mapped)J                   XRefreshWindow(display,&windows->image,(XEvent *) NULL);                 break;               }o8             windows->image.width=event.xconfigure.width;:             windows->image.height=event.xconfigure.height;             windows->image.x=0;t             windows->image.y=0;):             if (displayed_image->montage != (char *) NULL)               {i,                 windows->image.x=vid_info.x;,                 windows->image.y=vid_info.y;               }l?             if (windows->image.mapped && windows->image.stasis)p               {                  /*4                   Update Image window configuration.                 */K                 windows->image.window_changes.width=event.xconfigure.width;%M                 windows->image.window_changes.height=event.xconfigure.height; E                 (void) XConfigureImage(display,resource_info,windows,l#                   displayed_image);                }eJ             if ((event.xconfigure.width < windows->image.ximage->width) ||J                 (event.xconfigure.height < windows->image.ximage->height))               {)4                 XMapRaised(display,windows->pan.id);3                 XDrawPanRectangle(display,windows);f               }.             else&               if (windows->pan.mapped)M                 XWithdrawWindow(display,windows->pan.id,windows->pan.screen);n             break;           }t;         if (event.xconfigure.window == windows->magnify.id)            {              unsigned int               magnify;               /*5               Magnify window has a new configuration.              */:             windows->magnify.width=event.xconfigure.width;<             windows->magnify.height=event.xconfigure.height;)             if (!windows->magnify.mapped).               break;             magnify=1;;             while ((int) magnify <= event.xconfigure.width)a               magnify<<=1;<             while ((int) magnify <= event.xconfigure.height)               magnify<<=1;             magnify>>=1;<             if (((int) magnify != event.xconfigure.width) ||;                 ((int) magnify != event.xconfigure.height))d               {v-                 window_changes.width=magnify; .                 window_changes.height=magnify;A                 XReconfigureWMWindow(display,windows->magnify.id,+N                   windows->magnify.screen,CWWidth | CWHeight,&window_changes);                 break;               } =             handler=SetMonitorHandler((MonitorHandler) NULL); F             status=XMakeImage(display,resource_info,&windows->magnify,N               displayed_image,windows->magnify.width,windows->magnify.height);/             XMakeMagnifyImage(display,windows);o.             (void) SetMonitorHandler(handler);             break;           }e7         if (event.xconfigure.window == windows->pan.id)_           {n             /*6               Pan icon window has a new configuration.             */1             if (event.xconfigure.send_event != 0)o               { 2                 windows->pan.x=event.xconfigure.x;2                 windows->pan.y=event.xconfigure.y;               }o6             windows->pan.width=event.xconfigure.width;8             windows->pan.height=event.xconfigure.height;             break;           }u8         if (event.xconfigure.window == windows->icon.id)           {              /*2               Icon window has a new configuration.             */7             windows->icon.width=event.xconfigure.width;e9             windows->icon.height=event.xconfigure.height;e             break;           }          break;       }        case DestroyNotify:d       {o
         /*"           Group leader has exited.
         */!         if (resource_info->debug)e:           (void) fprintf(stderr,"Destroy Notify: 0x%lx\n",)             event.xdestroywindow.window); D         if (event.xdestroywindow.window == windows->group_leader.id)           {              *state|=ExitState;             break;           }x         break;       }e       case EnterNotify:o       {f
         /*'           Selectively install colormap.t
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab) 8             XInductColormap(display,map_info->colormap);         break;       }o       case Expose:       {X!         if (resource_info->debug)y>           (void) fprintf(stderr,"Expose: 0x%lx %dx%d+%d+%d\n",J             event.xexpose.window,event.xexpose.width,event.xexpose.height,-             event.xexpose.x,event.xexpose.y); 
         /*/           Refresh windows that are now exposed. 
         */6         if (event.xexpose.window == windows->image.id)$           if (windows->image.mapped)
             {.=               XRefreshWindow(display,&windows->image,&event);nG               timer=time((time_t *) NULL)+(resource_info->delay/100)+1;i               break;
             } 8         if (event.xexpose.window == windows->magnify.id)'           if (event.xexpose.count == 0)o(             if (windows->magnify.mapped)               {G3                 XMakeMagnifyImage(display,windows);                  break;               } 4         if (event.xexpose.window == windows->pan.id)'           if (event.xexpose.count == 0) 
             {i1               XDrawPanRectangle(display,windows);p               break;
             }d5         if (event.xexpose.window == windows->icon.id)s'           if (event.xexpose.count == 0)r
             { <               XRefreshWindow(display,&windows->icon,&event);               break;
             }r         break;       }        case KeyPress:       {e         int            length;i  
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);e         *(command+length)='\0'; !         if (resource_info->debug) B           (void) fprintf(stderr,"Key press: %d 0x%lx (%.1024s)\n",1             event.xkey.state,key_symbol,command); 3         if (event.xkey.window == windows->image.id)o           { K             command_type=XImageWindowCommand(display,resource_info,windows,o<               event.xkey.state,key_symbol,&displayed_image);,             if (command_type != NullCommand)H               loaded_image=XMagickCommand(display,resource_info,windows,/                 command_type,&displayed_image);            }S5         if (event.xkey.window == windows->magnify.id) M           XMagnifyWindowCommand(display,windows,event.xkey.state,key_symbol); 1         if (event.xkey.window == windows->pan.id)e           {i#             if (key_symbol == XK_q)XK               XWithdrawWindow(display,windows->pan.id,windows->pan.screen);              elseC               if ((key_symbol == XK_F1) || (key_symbol == XK_Help));D                 XTextViewWidget(display,resource_info,windows,False,>                   "Help Viewer - Image Panning",ImagePanHelp);               elseC                 XTranslateImage(display,windows,*image,key_symbol);t           }nA         timer=time((time_t *) NULL)+(resource_info->delay/100)+1;.         break;       }o       case KeyRelease:       { 
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);d!         if (resource_info->debug)lG           (void) fprintf(stderr,"Key release: 0x%lx (%c)\n",key_symbol,i             *command);         break;       }        case LeaveNotify:s       { 
         /*)           Selectively uninstall colormap. 
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab)d:             XUninductColormap(display,map_info->colormap);         break;       }        case MapNotify:0       { !         if (resource_info->debug) I           (void) fprintf(stderr,"Map Notify: 0x%lx\n",event.xmap.window);_6         if (event.xmap.window == windows->backdrop.id)           {eD             XSetInputFocus(display,event.xmap.window,RevertToParent,               CurrentTime); *             windows->backdrop.mapped=True;             break;           }e3         if (event.xmap.window == windows->image.id)o           { 6             if (windows->backdrop.id != (Window) NULL);               XInstallColormap(display,map_info->colormap); C             if (Latin1Compare(displayed_image->magick,"LOGO") == 0)                {-M                 if (Latin1Compare(displayed_image->filename,"Untitled") == 0)sO                   loaded_image=XOpenImage(display,resource_info,windows,False);                  else5                   *state|=NextImageState | ExitState;                }tN             if (((int) windows->image.width < windows->image.ximage->width) ||N                 ((int) windows->image.height < windows->image.ximage->height))2               XMapRaised(display,windows->pan.id);'             windows->image.mapped=True;              break;           }i5         if (event.xmap.window == windows->magnify.id)e           {_/             XMakeMagnifyImage(display,windows); )             windows->magnify.mapped=True; K             XWithdrawWindow(display,windows->info.id,windows->info.screen);b             break;           } 1         if (event.xmap.window == windows->pan.id)i           {iI             XMakePanImage(display,resource_info,windows,displayed_image); %             windows->pan.mapped=True;y             break;           }_2         if (event.xmap.window == windows->info.id)           {t&             windows->info.mapped=True;             break;           } 2         if (event.xmap.window == windows->icon.id)           {              unsigned int               tainted;               /*#               Create an icon image.              */-             tainted=displayed_image->tainted; E             XMakeStandardColormap(display,icon_visual,icon_resources, 3               displayed_image,icon_map,icon_pixel); D             (void) XMakeImage(display,icon_resources,&windows->icon,H               displayed_image,windows->icon.width,windows->icon.height);-             displayed_image->tainted=tainted; @             XSetWindowBackgroundPixmap(display,windows->icon.id,$               windows->icon.pixmap);3             XClearWindow(display,windows->icon.id); K             XWithdrawWindow(display,windows->info.id,windows->info.screen); &             windows->icon.mapped=True;             break;           }y5         if (event.xmap.window == windows->command.id)r           {_)             windows->command.mapped=True;n             break;           }r3         if (event.xmap.window == windows->popup.id)n           {.'             windows->popup.mapped=True;(             break;           }o4         if (event.xmap.window == windows->widget.id)           {R(             windows->widget.mapped=True;             break;           })         break;       }        case MappingNotify:u       {t1         XRefreshKeyboardMapping(&event.xmapping);a         break;       }a       case NoExpose:         break;       case PropertyNotify:       {          Atom           type;            intw           format;            unsigned charg           *data;           unsigned long            after,           length;i  !         if (resource_info->debug) D           (void) fprintf(stderr,"Property Notify: 0x%lx 0x%lx %d\n",O             event.xproperty.window,event.xproperty.atom,event.xproperty.state);d?         if (event.xproperty.atom != windows->im_remote_command)0           break;
         /*=           Display image named by the remote command protocol.n
         */A         status=XGetWindowProperty(display,event.xproperty.window,nO           event.xproperty.atom,0L,MaxTextExtent-1,False,(Atom) AnyPropertyType, .           &type,&format,&length,&after,&data);1         if ((status != Success) || (length == 0))p           break;I         (void) strcpy(resource_info->image_info->filename,(char *) data);I:         loaded_image=ReadImage(resource_info->image_info);+         if (loaded_image != (Image *) NULL) -           *state|=NextImageState | ExitState;          XFree((void *) data);o         break;       }        case ReparentNotify:       {e!         if (resource_info->debug) B           (void) fprintf(stderr,"Reparent Notify: 0x%lx=>0x%lx\n",;             event.xreparent.parent,event.xreparent.window);          break;       }t       case UnmapNotify:        { !         if (resource_info->debug) M           (void) fprintf(stderr,"Unmap Notify: 0x%lx\n",event.xunmap.window); 8         if (event.xunmap.window == windows->backdrop.id)           {X+             windows->backdrop.mapped=False;t             break;           }a5         if (event.xunmap.window == windows->image.id)            {p(             windows->image.mapped=False;             break;           }i7         if (event.xunmap.window == windows->magnify.id)a           {f*             windows->magnify.mapped=False;             break;           }H3         if (event.xunmap.window == windows->pan.id)m           {_&             windows->pan.mapped=False;             break;           }a4         if (event.xunmap.window == windows->info.id)           {d'             windows->info.mapped=False;              break;           }o4         if (event.xunmap.window == windows->icon.id)           { 9             if (map_info->colormap == icon_map->colormap) D               XConfigureImageColormap(display,resource_info,windows,!                 displayed_image); K             XFreeStandardColormap(display,icon_visual,icon_map,icon_pixel);d'             windows->icon.mapped=False;              break;           } 7         if (event.xunmap.window == windows->command.id)            { *             windows->command.mapped=False;             break;           }i5         if (event.xunmap.window == windows->popup.id)n           {i6             if (windows->backdrop.id != (Window) NULL)F               XSetInputFocus(display,windows->image.id,RevertToParent,                 CurrentTime);d(             windows->popup.mapped=False;             break;           }x6         if (event.xunmap.window == windows->widget.id)           {y6             if (windows->backdrop.id != (Window) NULL)F               XSetInputFocus(display,windows->image.id,RevertToParent,                 CurrentTime); )             windows->widget.mapped=False;a             break;           }          break;       }(       default:       { !         if (resource_info->debug)a?           (void) fprintf(stderr,"Event type: %d\n",event.type);e         break;       }l     }a   }E    while (!(*state & ExitState));   if (!(*state & ExitState))K     (void) XMagickCommand(display,resource_info,windows,FreeBuffersCommand,a       &displayed_image);   else     {u       /*(         Query user if image has changed.       */&       SignatureImage(displayed_image);@       if (!resource_info->immutable && displayed_image->tainted)	         {pF           status=XConfirmWidget(display,windows,"Your image changed.",&             "Do you want to save it");           if (status == 0)!             *state&=(~ExitState);            else             if (status > 0) N               (void) XMagickCommand(display,resource_info,windows,SaveCommand,"                 &displayed_image);	         }      } 3   if ((windows->visual_info->class == GrayScale) || 5       (windows->visual_info->class == PseudoColor) || 3       (windows->visual_info->class == DirectColor))%     {%       /*(         Withdraw pan and Magnify window.       */       if (windows->info.mapped)IG         XWithdrawWindow(display,windows->info.id,windows->info.screen); "       if (windows->magnify.mapped)M         XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);n"       if (windows->command.mapped)M         XWithdrawWindow(display,windows->command.id,windows->command.screen);m     }m   if (windows->pan.mapped)A     XWithdrawWindow(display,windows->pan.id,windows->pan.screen);r   if (!resource_info->backdrop)d!     if (windows->backdrop.mapped)m       {rO         XWithdrawWindow(display,windows->backdrop.id,windows->backdrop.screen);o5         XDestroyWindow(display,windows->backdrop.id);p+         windows->backdrop.id=(Window) NULL;oI         XWithdrawWindow(display,windows->image.id,windows->image.screen);o2         XDestroyWindow(display,windows->image.id);(         windows->image.id=(Window) NULL;       }.(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);M   if (!resource_info->immutable || (displayed_image->next != (Image *) NULL))sA     if ((*state & FormerImageState) || (*state & NextImageState))e       *state&=(~ExitState);t   if (*state & ExitState)      {        /*         Destroy X windows.       */        if (windows->image.mapped)I         XWithdrawWindow(display,windows->image.id,windows->image.screen);a"       XDelay(display,SuspendTime);.       for (i=0; i < (int) number_windows; i++)       {a9         if (magick_windows[i]->ximage != (XImage *) NULL)e           { 3             magick_windows[i]->shared_memory=False;tF             (void) XMakeImage(display,resource_info,magick_windows[i],"               (Image *) NULL,1,1);5             XDestroyImage(magick_windows[i]->ximage);e           } 7         if (magick_windows[i]->pixmap != (Pixmap) NULL)e9           XFreePixmap(display,magick_windows[i]->pixmap); 3         if (magick_windows[i]->id != (Window) NULL) 8           XDestroyWindow(display,magick_windows[i]->id);       }i       /*         Free Standard Colormap.        */E       XFreeStandardColormap(display,icon_visual,icon_map,icon_pixel);t3       if (resource_info->map_type == (char *) NULL)tB         XFreeStandardColormap(display,visual_info,map_info,pixel);       /*         Free X resources.R       */"       if (resource_info->backdrop)6         XFreeCursor(display,windows->backdrop.cursor);=       if (windows->widget.highlight_stipple != (Pixmap) NULL) ?         XFreePixmap(display,windows->widget.highlight_stipple);s=       if (windows->widget.highlight_stipple != (Pixmap) NULL) <         XFreePixmap(display,windows->widget.shadow_stipple);-       XFreeGC(display,pixel->widget_context);X0       XFreeGC(display,pixel->highlight_context);/       XFreeGC(display,pixel->annotate_context);o4       XFreeGC(display,icon_pixel->annotate_context);#       XFreeFont(display,font_info);a"       XFree((void *) class_hints);$       XFree((void *) manager_hints);"       XFree((void *) icon_visual);"       XFree((void *) visual_info);       XFree((void *) icon_map);.       XFree((void *) map_info);t&       FreeMemory(windows->popup.name);'       FreeMemory(windows->widget.name); (       FreeMemory(windows->magnify.name);+       FreeMemory(windows->image.icon_name); &       FreeMemory(windows->image.name);6       if (resource_info->copy_image != (Image *) NULL)0         DestroyImage(resource_info->copy_image);*       FreeMemory(windows->icon_resources);&       FreeMemory(windows->icon_pixel);&       FreeMemory(windows->pixel_info);%       (void) signal(SIGSEGV,SIG_DFL);o$       (void) signal(SIGINT,SIG_DFL);,       (void) XSetWindows((XWindows *) NULL);     }e   XSync(display,False);    /*6     Restore our progress monitor and warning handlers.   */,   (void) SetMonitorHandler(monitor_handler);,   (void) SetWarningHandler(warning_handler);   /*     Change to home directory.    */3   (void) getcwd(working_directory,MaxTextExtent-1);/.   (void) chdir(resource_info->home_directory);   *image=displayed_image;;   return(loaded_image);  }o #endif