 /*5   Methods to Interactively Display and Edit an Image.  */ #ifndef _DISPLAY_H #define _DISPLAY_H  / #if defined(__cplusplus) || defined(c_plusplus)  extern "C" { #endif   /*   Define declarations. */? #define MaxColors  Min(windows->visual_info->colormap_size,256)    /*   Constant declarations. */ static const unsigned char   HighlightBitmap[8] =   { 2     0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55   },   ShadowBitmap[8] =    { 2     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   };  
 const char   *NoiseTypes[] =    {      "Uniform",     "Gaussian",      "Multiplicative",      "Impulse",     "Lapacian",      "Poisson",     (char *) NULL    },   *PageSizes[]=    { 
     "Letter",      "Tabloid",
     "Ledger",      "Legal",     "Statement",     "Executive",	     "A3", 	     "A4", 	     "A5", 	     "B4", 	     "B5",      "Folio",
     "Quarto",      "10x14",     (char *) NULL    },   *PreviewTypes[] =    { 
     "Rotate",      "Shear",     "Roll", 
     "Hue",     "Saturation",      "Brightness",      "Gamma",     "Spiff",     "Dull",      "Grayscale",     "Quantize",      "Despeckle",     "Reduce Noise",      "Add Noise",     "Sharpen",     "Blur",      "Threshold",     "Edge Detect",
     "Spread",      "Solarize",      "Shade",     "Raise",     "Segment",     "Swirl",     "Implode",     "Wave",      "Oil Paint",     "Charcoal Drawing",      "JPEG",      (char *) NULL    };   /*   Help widget declarations.  */
 const char   *ImageAnnotateHelp[]=    { >     "In annotate mode, the Command widget has these options:",     "",      "    Font Name",     "      fixed",     "      variable",      "      5x8",     "      6x10",      "      7x13bold",      "      8x13bold",      "      9x15bold",      "      10x20",     "      12x24",     "      Browser...",      "    Font Color",      "      black",     "      blue",      "      cyan",      "      green",     "      gray",      "      red",     "      magenta",     "      yellow",      "      white",     "      transparent",     "      Browser...",      "    Font Color",      "      black",     "      blue",      "      cyan",      "      green",     "      gray",      "      red",     "      magenta",     "      yellow",      "      white",     "      transparent",     "      Browser...",      "    Rotate Text",     "      -90",     "      -45",     "      -30",     "      0",     "      30",      "      45",      "      90",      "      180",     "      Dialog...",     "    Help",      "    Dismiss",     "", B     "Choose a font name from the Font Name sub-menu.  Additional",B     "font names can be specified with the font browser.  You can",=     "change the menu names by setting the X resources font1",      "through font9.",      "", 8     "Choose a font color from the Font Color sub-menu.",=     "Additional font colors can be specified with the color", @     "browser.  You can change the menu colors by setting the X",#     "resources pen1 through pen9.",      "", >     "If you select the color browser and press Grab, you can",A     "choose the font color by moving the pointer to the desired", 0     "color on the screen and press any button.",     "", D     "If you choose to rotate the text, choose Rotate Text from the",A     "menu and select an angle.  Typically you will only want to", E     "rotate one line of text at a time.  Depending on the angle you", B     "choose, subsequent lines may end up overwriting each other.",     "", C     "Choosing a font and its color is optional.  The default font", B     "is fixed and the default color is black.  However, you must",C     "choose a location to begin entering text and press button 1.", A     "An underscore character will appear at the location of the", C     "pointer.  The cursor changes to a pencil to indicate you are", 9     "in text mode.  To exit immediately, press Dismiss.",      "", B     "In text mode, any key presses will display the character at",@     "the location of the underscore and advance the underscore",A     "cursor.  Enter your text and once completed press Apply to", B     "finish your image annotation.  To correct errors press BACK",C     "SPACE.  To delete an entire line of text, press DELETE.  Any", >     "text that exceeds the boundaries of the image window is",2     "automatically continued onto the next line.",     "", @     "The actual color you request for the font is saved in the",C     "image.  However, the color that appears in your image window", A     "may be different.  For example, on a monochrome screen the", C     "text will appear black or white even if you choose the color", A     "red as the font color.  However, the image saved to a file", @     "with -write is written with red lettering.  To assure the",C     "correct color text in the final image, any PseudoClass image", <     "is promoted to DirectClass (see miff(5)).  To force a",<     "PseudoClass image to remain PseudoClass, use -colors.",     (char *) NULL,   },   *ImageChopHelp[]=    { :     "In chop mode, the Command widget has these options:",     "",      "    Direction",     "      horizontal",      "      vertical",      "    Help",      "    Dismiss",     "", >     "If the you choose the horizontal direction (this is the",A     "default), the area of the image between the two horizontal", B     "endpoints of the chop line is removed.  Otherwise, the area",B     "of the image between the two vertical endpoints of the chop",     "line is removed.",      "", D     "Select a location within the image window to begin your chop,",<     "press and hold any button.  Next, move the pointer to",>     "another location in the image.  As you move a line will",>     "connect the initial location and the pointer.  When you",?     "release the button, the area within the image to chop is", @     "determined by which direction you choose from the Command",     "widget.",     "", A     "To cancel the image chopping, move the pointer back to the", 9     "starting point of the line and release the button.",      (char *) NULL,   },   *ImageColorEditHelp[]=   { @     "In color edit mode, the Command widget has these options:",     "",      "    Method",      "      point",     "      replace",     "      floodfill",     "      filltoborder",      "      reset",     "    Pixel Color",     "      black",     "      blue",      "      cyan",      "      green",     "      gray",      "      red",     "      magenta",     "      yellow",      "      white",     "      Browser...",      "    Border Color",      "      black",     "      blue",      "      cyan",      "      green",     "      gray",      "      red",     "      magenta",     "      yellow",      "      white",     "      Browser...",      "    Fuzz",      "      0",     "      2",     "      4",     "      8",     "      16",      "      Dialog...",     "    Undo",      "    Help",      "    Dismiss",     "", =     "Choose a color editing method from the Method sub-menu", B     "of the Command widget.  The point method recolors any pixel",C     "selected with the pointer until the button is released.  The", B     "replace method recolors any pixel that matches the color of",D     "the pixel you select with a button press.  Floodfill recolors",D     "any pixel that matches the color of the pixel you select with",G     "a button press and is a neighbor.  Whereas filltoborder recolors", F     "any neighbor pixel that is not the border color.  Finally reset",8     "changes the entire image to the designated color.",     "", @     "Next, choose a pixel color from the Pixel Color sub-menu.",>     "Additional pixel colors can be specified with the color",@     "browser.  You can change the menu colors by setting the X",#     "resources pen1 through pen9.",      "", C     "Now press button 1 to select a pixel within the image window", B     "to change its color.  Additional pixels may be recolored as",+     "prescribed by the method you choose.",      "", H     "If the Magnify widget is mapped, it can be helpful in positioning",9     "your pointer within the image (refer to button 2).",      "", B     "The actual color you request for the pixels is saved in the",C     "image.  However, the color that appears in your image window", A     "may be different.  For example, on a monochrome screen the", >     "pixel will appear black or white even if you choose the",C     "color red as the pixel color.  However, the image saved to a", B     "file with -write is written with red pixels.  To assure the",C     "correct color text in the final image, any PseudoClass image", <     "is promoted to DirectClass (see miff(5)).  To force a",<     "PseudoClass image to remain PseudoClass, use -colors.",     (char *) NULL,   },   *ImageCompositeHelp[]=   { D     "First a widget window is displayed requesting you to enter an",=     "image name. Press Composite, Grab or type a file name.", B     "Press Cancel if you choose not to create a composite image.",C     "When you choose Grab, move the pointer to the desired window",      "and press any button.",     "", B     "If the Composite image does not have any matte information,",@     "you are informed and the file browser is displayed again.",>     "Enter the name of a mask image.  The image is typically",B     "grayscale and the same size as the composite image.  If the",C     "image is not grayscale, it is converted to grayscale and the", ;     "resulting intensities are used as matte information.",      "", C     "A small window appears showing the location of the cursor in", @     "the image window. You are now in composite mode.  To exit",B     "immediately, press Dismiss.  In composite mode, the Command",      "widget has these options:",     "",      "    Operators",     "      Over",      "      In",      "      Out",     "      Atop",      "      Xor",     "      Plus",      "      Minus",     "      Add",     "      Subtract",      "      Difference",      "      Bumpmap",     "      Replace",     "      ReplaceRed",      "      ReplaceGreen",      "      ReplaceBlue",     "      ReplaceMatte",      "    Blend",     "    Displace",      "    Help",      "    Dismiss",     "", B     "Choose a composite operation from the Operators sub-menu of",B     "the Command widget.  How each operator behaves is described",?     "below.  Image window is the image currently displayed on", B     "your X server and image is the image obtained with the File",     "Browser widget.",     "", @     "Over     The result is the union of the two image shapes,",B     "         with image obscuring image window in the region of",     "         overlap.",     "", >     "In       The result is simply image cut by the shape of",>     "         image window.  None of the image data of image",(     "         window is in the result.",     "", >     "Out      The resulting image is image with the shape of",%     "         image window cut out.",      "", C     "Atop     The result is the same shape as image image window,", A     "         with image obscuring image window where the image", <     "         shapes overlap.  Note this differs from over",C     "         because the portion of image outside image window's", 4     "         shape does not appear in the result.",     "", @     "Xor      The result is the image data from both image and",@     "         image window that is outside the overlap region.",,     "         The overlap region is blank.",     "", =     "Plus     The result is just the sum of the image data.", ?     "         Output values are cropped to 255 (no overflow).", :     "         This operation is independent of the matte",     "         channels.",      "", B     "Minus    The result of image - image window, with underflow",C     "         cropped to zero.  The matte channel is ignored (set", '     "         to 255, full coverage).",      "", A     "Add      The result of image + image window, with overflow", *     "         wrapping around (mod 256).",     "", B     "Subtract The result of image - image window, with underflow",@     "         wrapping around (mod 256).  The add and subtract",;     "         operators can be used to perform reversible",       "         transformations.",     "",      "Difference", A     "         The result of abs(image - image window).  This is", =     "         useful for comparing two very similar images.",      "", @     "Bumpmap  The result of surface normals from image * image",     "         window.",      "", A     "Replace  The resulting image is image window replaced with", >     "         image.  Here the matte information is ignored.",     "",      "ReplaceRed", A     "         The red layer of the image window is replace with", A     "         the red layer of the image.  The other layers are",      "         untouched.",     "",      "ReplaceGreen", C     "         The green layer of the image window is replace with", C     "         the green layer of the image.  The other layers are",      "         untouched.",     "",      "ReplaceBlue",B     "         The blue layer of the image window is replace with",B     "         the blue layer of the image.  The other layers are",     "         untouched.",     "",      "ReplaceMatte", C     "         The matte layer of the image window is replace with", C     "         the matte layer of the image.  The other layers are",      "         untouched.",     "", A     "The image compositor requires a matte, or alpha channel in", A     "the image for some operations.  This extra channel usually", @     "defines a mask which represents a sort of a cookie-cutter",?     "for the image.  This is the case when matte is 255 (full", ?     "coverage) for pixels inside the shape, zero outside, and", ?     "between zero and 255 on the boundary.  If image does not", C     "have a matte channel, it is initialized with 0 for any pixel", @     "matching in color to pixel location (0,0), otherwise 255.",     "", E     "If you choose Blend, the composite operator becomes Over.  The", I     "image matte channel percent transparency is initialized to factor.", K     "The image window is initialized to (100-factor). Where factor is the", .     "value you specify in the Dialog widget.",     "", D     "Displace shifts the image pixels as defined by a displacement",C     "map.  With this option, image is used as a displacement map.", @     "Black, within the displacement map, is a maximum positive",B     "displacement.  White is a maximum negative displacement and",G     "middle gray is neutral.  The displacement is scaled to determine", I     "the pixel shift.  By default, the displacement applies in both the", K     "horizontal and vertical directions.  However, if you specify a mask,", E     "image is the horizontal X displacement and mask the vertical Y",      "displacement.",     "", C     "Note that matte information for image window is not retained", :     "for colormapped X server visuals (e.g. StaticColor,",A     "StaticColor, GrayScale, PseudoColor).  Correct compositing", B     "behavior may require a TrueColor or DirectColor visual or a",     "Standard Colormap.",      "", >     "Choosing a composite operator is optional.  The default",C     "operator is replace.  However, you must choose a location to", C     "composite your image and press button 1.  Press and hold the", ?     "button before releasing and an outline of the image will", 1     "appear to help you identify your location.",      "", C     "The actual colors of the composite image is saved.  However,", ?     "the color that appears in image window may be different.", C     "For example, on a monochrome screen image window will appear", @     "black or white even though your composited image may have",B     "many colors.  If the image is saved to a file it is written",A     "with the correct colors.  To assure the correct colors are", B     "saved in the final image, any PseudoClass image is promoted",B     "to DirectClass (see miff(5)).  To force a PseudoClass image",*     "to remain PseudoClass, use -colors.",     (char *) NULL,   },   *ImageCutHelp[]=   { 9     "In cut mode, the Command widget has these options:",      "",      "    Help",      "    Dismiss",     "", <     "To define a cut region, press button 1 and drag.  The",<     "cut region is defined by a highlighted rectangle that",@     "expands or contracts as it follows the pointer.  Once you",=     "are satisfied with the cut region, release the button.", A     "You are now in rectify mode.  In rectify mode, the Command",       "widget has these options:",     "",      "    Cut",     "    Help",      "    Dismiss",     "", C     "You can make adjustments by moving the pointer to one of the", >     "cut rectangle corners, pressing a button, and dragging.",9     "Finally, press Cut to commit your copy region.  To", 5     "exit without cutting the image, press Dismiss.",      (char *) NULL,   },   *ImageCopyHelp[]=    { :     "In copy mode, the Command widget has these options:",     "",      "    Help",      "    Dismiss",     "", =     "To define a copy region, press button 1 and drag.  The", =     "copy region is defined by a highlighted rectangle that", @     "expands or contracts as it follows the pointer.  Once you",>     "are satisfied with the copy region, release the button.",A     "You are now in rectify mode.  In rectify mode, the Command",       "widget has these options:",     "",      "    Copy",      "    Help",      "    Dismiss",     "", C     "You can make adjustments by moving the pointer to one of the", ?     "copy rectangle corners, pressing a button, and dragging.", :     "Finally, press Copy to commit your copy region.  To",5     "exit without copying the image, press Dismiss.",      (char *) NULL,   },   *ImageCropHelp[]=    { :     "In crop mode, the Command widget has these options:",     "",      "    Help",      "    Dismiss",     "", A     "To define a cropping region, press button 1 and drag.  The", A     "cropping region is defined by a highlighted rectangle that", @     "expands or contracts as it follows the pointer.  Once you",B     "are satisfied with the cropping region, release the button.",A     "You are now in rectify mode.  In rectify mode, the Command",       "widget has these options:",     "",      "    Crop",      "    Help",      "    Dismiss",     "", C     "You can make adjustments by moving the pointer to one of the", C     "cropping rectangle corners, pressing a button, and dragging.", >     "Finally, press Crop to commit your cropping region.  To",6     "exit without cropping the image, press Dismiss.",     (char *) NULL,   },   *ImageDrawHelp[]=    { ?     "The cursor changes to a crosshair to indicate you are in", E     "draw mode.  To exit immediately, press Dismiss.  In draw mode,", ,     "the Command widget has these options:",     "",      "    Primitive",     "      point",     "      line",      "      rectangle",     "      fill rectangle",      "      circle",      "      fill circle",     "      ellipse",     "      fill ellipse",      "      polygon",     "      fill polygon",      "    Color",     "      black",     "      blue",      "      cyan",      "      green",     "      gray",      "      red",     "      magenta",     "      yellow",      "      white",     "      transparent",     "      Browser...",      "    Stipple",     "      Brick",     "      Diagonal",      "      Scales",      "      Vertical",      "      Wavy",      "      Translucent",     "      Opaque",      "      Open...",     "    Width",     "      1",     "      2",     "      4",     "      8",     "      16",      "      Dialog...",     "    Undo",      "    Help",      "    Dismiss",     "", >     "Choose a drawing primitive from the Primitive sub-menu.",     "", :     "Choose a color from the Color sub-menu.  Additional",6     "colors can be specified with the color browser.",     "", >     "If you choose the color browser and press Grab, you can",<     "select the color by moving the pointer to the desired",A     "color on the screen and press any button.  The transparent", >     "color updates the image matte channel and is useful for",     "image compositing.",      "", C     "Choose a stipple, if appropriate, from the Stipple sub-menu.", B     "Additional stipples can be specified with the file browser.",E     "Stipples obtained from the file browser must be on disk in the",      "X11 bitmap format.",      "", C     "Choose a width, if appropriate, from the Width sub-menu.  To", 8     "choose a specific width select the Dialog widget.",     "", @     "Choose a point in the Image window and press button 1 and",?     "hold.  Next, move the pointer to another location in the", D     "image.  As you move, a line connects the initial location and",>     "the pointer.  When you release the button, the image is",C     "updated with the primitive you just drew.  For polygons, the", E     "image is updated when you press and release the button without",      "moving the pointer.",     "", <     "To cancel image drawing, move the pointer back to the",9     "starting point of the line and release the button.",      (char *) NULL,   },   *DisplayHelp[]=    {      "BUTTONS",D     "  The effects of each button press is described below.  Three",?     "  buttons are required.  If you have a two button mouse,", @     "  button 1 and 3 are returned.  Press ALT and button 3 to",     "  simulate button 2.",      "", C     "  1    Press this button to map or unmap the Command widget.",      "", ?     "  2    Press and drag to define a region of the image to",      "       magnify.",     "", E     "  3    Press and drag to choose from a select set of commands.", @     "       This button behaves differently if the image being",D     "       displayed is a visual image directory.  Here, choose a",H     "       particular tile of the directory and press this button and",G     "       drag to select a command from a pop-up menu.  Choose from",      "       these menu items:",      "",      "           Open",     "           Next",     "           Former",     "           Delete",     "           Update",     "", F     "       If you choose Open, the image represented by the tile is",I     "       displayed.  To return to the visual image directory, choose", I     "       Next from the Command widget.  Next and Former moves to the", I     "       next or former image respectively.  Choose Delete to delete", A     "       a particular image tile.  Finally, choose Update to", C     "       synchronize all the image tiles with their respective",      "       images.",      "",      "COMMAND WIDGET", E     "  The Command widget lists a number of sub-menus and commands.",      "  They are",      "",      "      File",      "        Open...",     "        Next",      "        Former",      "        Select...",     "        Save...",     "        Print...",      "        Delete...",     "        New...", "     "        Visual Directory...",     "        Quit",      "      Edit",      "        Undo",      "        Redo",      "        Cut",     "        Copy",      "        Paste",     "      View",      "        Half Size",     "        Original Size",     "        Double Size",     "        Resize...",     "        Apply",     "        Refresh",     "        Restore",     "      Transform",     "        Crop",      "        Chop",      "        Flop",      "        Flip",      "        Rotate Right",      "        Rotate Left",     "        Rotate...",     "        Shear...",      "        Roll...",     "        Trim Edges",      "      Enhance",     "        Brightness...",     "        Saturation...",     "        Hue...",      "        Gamma...",      "        Sharpen...",      "        Dull",      "        Equalize",      "        Normalize",     "        Negate",      "        Grayscale",     "        Map...",      "        Quantize...",     "      Effects",     "        Despeckle",     "        Emboss",      "        Reduce Noise",      "        Add Noise",     "        Sharpen...",      "        Blur...",     "        Threshold...",      "        Edge Detect...",      "        Spread...",     "        Shade...",      "        Painting...",     "        Segment...",      "      F/X",     "        Solarize...",     "        Swirl...",      "        Implode...",      "        Wave...",     "        Oil Painting...","     "        Charcoal Drawing...",     "      Image Edit",      "        Annotate...",     "        Draw...",     "        Color...",      "        Matte...",      "        Composite...",      "        Add Border...",     "        Add Frame...",      "        Comment...",      "        Launch...",$     "        Region of Interest...",     "      Miscellany",      "        Image Info",      "        Zoom Image",      "        Show Preview...",     "        Show Histogram",      "        Show Matte",      "        Background...",     "        Slide Show",      "        Preferences...",      "      Help",      "        Overview", #     "        Browse Documentation",      "        About Display",     "", C     "  Menu items with a indented triangle have a sub-menu.  They", B     "  are represented above as the indented items.  To access a",D     "  sub-menu item, move the pointer to the appropriate menu and",E     "  press a button and drag.  When you find the desired sub-menu", D     "  item, release the button and the command is executed.  Move",@     "  the pointer away from the sub-menu if you decide not to",&     "  execute a particular command.",     "",      "KEYBOARD ACCELERATORS",>     "  Accelerators are one or two key presses that effect a",<     "  particular command.  The keyboard accelerators that",#     "  display(1) understands is:",      "", 6     "  Ctl+O     Press to open an image from a file.",     "", 3     "  space     Press to display the next image.",      "", N     "            If the image is a multi-paged document such as a Postscript",K     "            document, you can skip ahead several pages by preceeding", J     "            this command with a number.  For example to display the",A     "            fourth page beyond the current page, press 4n.",      "", 5     "  backspace Press to display the former image.",      "", N     "            If the image is a multi-paged document such as a Postscript",L     "            document, you can skip behind several pages by preceeding",J     "            this command with a number.  For example to display the",I     "            fourth page preceeding the current page, press 4space.",      "", 6     "  Ctl+S     Press to write the image to a file.",     "", D     "  Ctl+P     Press to print the image to a Postscript printer.",     "", 1     "  Ctl+D     Press to delete an image file.",      "", 2     "  Ctl+N     Press to create a blank canvas.",     "", @     "  Ctl+Q     Press to discard all images and exit program.",     "", ;     "  Ctl+Z     Press to undo last image transformation.",      "", ;     "  Ctl+R     Press to redo last image transformation.",      "", 6     "  Ctl+X     Press to cut a region of the image.",     "", 7     "  Ctl+C     Press to copy a region of the image.",      "", 8     "  Ctl+V     Press to paste a region to the image.",     "", 0     "  <         Press to half the image size.",     "", >     "  -         Press to return to the original image size.",     "", 2     "  >         Press to double the image size.",     "", F     "  %         Press to resize the image to a width and height you",     "            specify.",      "", D     "Cmd-A       Press to make any image transformations permanent."     "", I     "            By default, any image size transformations are applied", I     "            to the original image to create the image displayed on", F     "            the X server.  However, the transformations are not",E     "            permanent (i.e. the original image does not change", D     "            size only the X image does).  For example, if you",E     "            press > the X image will appear to double in size,", L     "            but the original image will in fact remain the same size.",I     "            To force the original image to double in size, press >", %     "            followed by Cmd-A.",      "", 5     "  @         Press to refresh the image window.",      "", +     "  C         Press to crop the image.",      "", +     "  [         Press to chop the image.",      "", C     "  H         Press to flop image in the horizontal direction.",      "", A     "  V         Press to flip image in the vertical direction.",      "", B     "  /         Press to rotate the image 90 degrees clockwise.",     "", J     " \\         Press to rotate the image 90 degrees counter-clockwise.",     "", F     "  *         Press to rotate the image the number of degrees you",     "            specify.",      "", E     "  S         Press to shear the image the number of degrees you",      "            specify.",      "", +     "  R         Press to roll the image.",      "", 1     "  T         Press to trim the image edges.",      "", /     "  Shft-H    Press to vary the image hue.",      "", 6     "  Shft-S    Press to vary the color saturation.",     "", 6     "  Shft-L    Press to vary the color brightness.",     "", 4     "  Shft-G    Press to gamma correct the image.",     "", 7     "  Shft-C    Press to sharpen the image contrast.",      "", 4     "  Shft-Z    Press to dull the image contrast.",     "", H     "  =         Press to perform histogram equalization on the image.",     "", I     "  Shft-N    Press to perform histogram normalization on the image.",      "", ;     "  Shft-~    Press to negate the colors of the image.",      "", =     "  .         Press to convert the image colors to gray.",      "", J     "  Shft-#    Press to set the maximum number of unique colors in the",     "            image.",      "", <     "  F2        Press to reduce the speckles in an image.",     "", ?     "  F3        Press to eliminate peak noise from an image.",      "", 2     "  F4        Press to add noise to an image.",     "", -     "  F5        Press to sharpen an image.",      "", 1     "  F6        Press to delete an image file.",      "", 0     "  F7        Press to threshold the image.",     "", 9     "  F8        Press to detect edges within an image.",      "", ,     "  F9        Press to emboss an image.",     "", ?     "  F10       Press to displace pixels by a random amount.",      "", H     "  F11       Press to negate all pixels above the threshold level.",     "", I     "  F12       Press to shade the image using a distant light source.",      "", Q     "  F13       Press to lighten or darken image edges to create a 3-D effect.",      "", 7     "  F14       Press to segment the image by color.",      "", @     "  Meta-S    Press to swirl image pixels about the center.",     "", B     "  Meta-I    Press to implode image pixels about the center.",     "", =     "  Meta-W    Press to alter an image along a sine wave.",      "", 5     "  Meta-P    Press to simulate an oil painting.",      "", 8     "  Meta-C    Press to simulate a charcoal drawing.",     "", 9     "  Alt-A     Press to annotate the image with text.",      "", -     "  Alt-D     Press to draw on an image.",      "", 6     "  Alt-P     Press to edit an image pixel color.",     "", =     "  Alt-M     Press to edit the image matte information.",      "", =     "  Alt-V     Press to composite the image with another.",      "", 6     "  Alt-B     Press to add a border to the image.",     "", B     "  Alt-F     Press to add an ornamental border to the image.",     "", 1     "  Shft-!    Press to add an image comment.",      "", I     "  Ctl-A     Press to apply image processing techniques to a region",      "            of interest.",      "", @     "  Shft-?    Press to display information about the image.",     "", 6     "  Shft-+    Press to map the zoom image window.",     "", I     "  Shft-P    Press to preview an image enhancement, effect, or f/x.",      "", I     "  F1        Press to display helpful information about display(1).",      "", C     "  Find      Press to browse documentation about ImageMagick.",      "", >     "  1-9       Press to change the level of magnification.",     "", A     "  Use the arrow keys to move the image one pixel up, down,", D     "  left, or right within the magnify window.  Be sure to first",5     "  map the magnify window by pressing button 2.",      "", B     "  Press ALT and one of the arrow keys to trim off one pixel",$     "  from any side of the image.",     (char *) NULL,   },   *ImageMatteEditHelp[]=   { ;     "Matte information within an image is useful for some", 6     "operations such as image compositing (See IMAGE",?     "COMPOSITING).  This extra channel usually defines a mask", @     "which represents a sort of a cookie-cutter for the image.",=     "This is the case when matte is 255 (full coverage) for", B     "pixels inside the shape, zero outside, and between zero and",     "255 on the boundary.",      "", C     "A small window appears showing the location of the cursor in", A     "the image window. You are now in matte edit mode.  To exit", C     "immediately, press Dismiss.  In matte edit mode, the Command",       "widget has these options:",     "",      "    Method",      "      point",     "      replace",     "      floodfill",     "      filltoborder",      "      reset",     "    Border Color",      "      black",     "      blue",      "      cyan",      "      green",     "      gray",      "      red",     "      magenta",     "      yellow",      "      white",     "      Browser...",      "    Fuzz",      "      0",     "      2",     "      4",     "      8",     "      16",      "      Dialog...",     "    Matte",     "    Undo",      "    Help",      "    Dismiss",     "", @     "Choose a matte editing method from the Method sub-menu of",D     "the Command widget.  The point method changes the matte value",A     "of any pixel selected with the pointer until the button is", B     "is released.  The replace method changes the matte value of",D     "any pixel that matches the color of the pixel you select with",F     "a button press.  Floodfill changes the matte value of any pixel",C     "that matches the color of the pixel you select with a button", G     "press and is a neighbor.  Whereas filltoborder changes the matte", F     "value any neighbor pixel that is not the border color.  Finally",D     "reset changes the entire image to the designated matte value.",     "", A     "Choose Matte Value and a dialog appears requesting a matte", >     "value.  Enter a value between 0 and 255.  This value is",C     "assigned as the matte value of the selected pixel or pixels.",      "", ?     "Now, press any button to select a pixel within the image", (     "window to change its matte value.",     "", H     "If the Magnify widget is mapped, it can be helpful in positioning",9     "your pointer within the image (refer to button 2).",      "", >     "Matte information is only valid in a DirectClass image.",B     "Therefore, any PseudoClass image is promoted to DirectClass",B     "(see miff(5)).  Note that matte information for PseudoClass",=     "is not retained for colormapped X server visuals (e.g.", C     "StaticColor, StaticColor, GrayScale, PseudoColor) unless you", >     "immediately save your image to a file (refer to Write).",@     "Correct matte editing behavior may require a TrueColor or",1     "DirectColor visual or a Standard Colormap.",      (char *) NULL,   },   *ImagePanHelp[]=   { @     "When an image exceeds the width or height of the X server",@     "screen, display maps a small panning icon.  The rectangle",?     "within the panning icon shows the area that is currently", B     "displayed in the the image window.  To pan about the image,",?     "press any button and drag the pointer within the panning", >     "icon.  The pan rectangle moves with the pointer and the",=     "image window is updated to reflect the location of the", A     "rectangle within the panning icon.  When you have selected", B     "the area of the image you wish to view, release the button.",     "", >     "Use the arrow keys to pan the image one pixel up, down,",.     "left, or right within the image window.",     "", A     "The panning icon is withdrawn if the image becomes smaller", 2     "than the dimensions of the X server screen.",     (char *) NULL,   },   *ImagePasteHelp[]=   { C     "A small window appears showing the location of the cursor in", <     "the image window. You are now in paste mode.  To exit",>     "immediately, press Dismiss.  In paste mode, the Command",      "widget has these options:",     "",      "    Operators",     "      over",      "      in",      "      out",     "      atop",      "      xor",     "      plus",      "      minus",     "      add",     "      subtract",      "      difference",      "      replace",     "    Help",      "    Dismiss",     "", B     "Choose a composite operation from the Operators sub-menu of",B     "the Command widget.  How each operator behaves is described",?     "below.  Image window is the image currently displayed on", B     "your X server and image is the image obtained with the File",     "Browser widget.",     "", @     "Over     The result is the union of the two image shapes,",B     "         with image obscuring image window in the region of",     "         overlap.",     "", >     "In       The result is simply image cut by the shape of",>     "         image window.  None of the image data of image",(     "         window is in the result.",     "", >     "Out      The resulting image is image with the shape of",%     "         image window cut out.",      "", C     "Atop     The result is the same shape as image image window,", A     "         with image obscuring image window where the image", <     "         shapes overlap.  Note this differs from over",C     "         because the portion of image outside image window's", 4     "         shape does not appear in the result.",     "", @     "Xor      The result is the image data from both image and",@     "         image window that is outside the overlap region.",,     "         The overlap region is blank.",     "", =     "Plus     The result is just the sum of the image data.", ?     "         Output values are cropped to 255 (no overflow).", :     "         This operation is independent of the matte",     "         channels.",      "", B     "Minus    The result of image - image window, with underflow",C     "         cropped to zero.  The matte channel is ignored (set", '     "         to 255, full coverage).",      "", A     "Add      The result of image + image window, with overflow", *     "         wrapping around (mod 256).",     "", B     "Subtract The result of image - image window, with underflow",@     "         wrapping around (mod 256).  The add and subtract",;     "         operators can be used to perform reversible",       "         transformations.",     "",      "Difference", A     "         The result of abs(image - image window).  This is", =     "         useful for comparing two very similar images.",      "", A     "Replace  The resulting image is image window replaced with", >     "         image.  Here the matte information is ignored.",     "",      "ReplaceRed", A     "         The red layer of the image window is replace with", A     "         the red layer of the image.  The other layers are",      "         untouched.",     "",      "ReplaceGreen", C     "         The green layer of the image window is replace with", C     "         the green layer of the image.  The other layers are",      "         untouched.",     "",      "ReplaceBlue",B     "         The blue layer of the image window is replace with",B     "         the blue layer of the image.  The other layers are",     "         untouched.",     "",      "ReplaceMatte", C     "         The matte layer of the image window is replace with", C     "         the matte layer of the image.  The other layers are",      "         untouched.",     "", A     "The image compositor requires a matte, or alpha channel in", A     "the image for some operations.  This extra channel usually", @     "defines a mask which represents a sort of a cookie-cutter",?     "for the image.  This is the case when matte is 255 (full", ?     "coverage) for pixels inside the shape, zero outside, and", ?     "between zero and 255 on the boundary.  If image does not", C     "have a matte channel, it is initialized with 0 for any pixel", @     "matching in color to pixel location (0,0), otherwise 255.",     "", C     "Note that matte information for image window is not retained", :     "for colormapped X server visuals (e.g. StaticColor,",A     "StaticColor, GrayScale, PseudoColor).  Correct compositing", B     "behavior may require a TrueColor or DirectColor visual or a",     "Standard Colormap.",      "", >     "Choosing a composite operator is optional.  The default",C     "operator is replace.  However, you must choose a location to", ?     "paste your image and press button 1.  Press and hold the", ?     "button before releasing and an outline of the image will", 1     "appear to help you identify your location.",      "", @     "The actual colors of the pasted image is saved.  However,",?     "the color that appears in image window may be different.", C     "For example, on a monochrome screen image window will appear", <     "black or white even though your pasted image may have",B     "many colors.  If the image is saved to a file it is written",A     "with the correct colors.  To assure the correct colors are", B     "saved in the final image, any PseudoClass image is promoted",B     "to DirectClass (see miff(5)).  To force a PseudoClass image",*     "to remain PseudoClass, use -colors.",     (char *) NULL,   },   *ImageROIHelp[]=   { ?     "In region of interest mode, the Command widget has these",      "options:",      "",      "    Help",      "    Dismiss",     "", ?     "To define a region of interest, press button 1 and drag.", C     "The region of interest is defined by a highlighted rectangle", A     "that expands or contracts as it follows the pointer.  Once", A     "you are satisfied with the region of interest, release the", =     "button.  You are now in apply mode.  In apply mode the", (     "Command widget has these options:",     "",      "      File",      "        Save...",     "        Print...",      "      Edit",      "        Undo",      "        Redo",      "      Transform",     "        Flop",      "        Flip",      "        Rotate Right",      "        Rotate Left",     "      Enhance",     "        Hue...",      "        Saturation...",     "        Brightness...",     "        Gamma...",      "        Spiff",     "        Dull",      "        Equalize",      "        Normalize",     "        Negate",      "        Grayscale",     "        Map...",      "        Quantize...",     "      Effects",     "        Despeckle",     "        Emboss",      "        Reduce Noise",      "        Sharpen...",      "        Blur...",     "        Threshold...",      "        Edge Detect...",      "        Spread...",     "        Shade...",      "        Raise...",      "        Segment...",      "      F/X",     "        Solarize...",     "        Swirl...",      "        Implode...",      "        Wave...",     "        Oil Painting...","     "        Charcoal Drawing...",     "      Miscellany",      "        Image Info",      "        Zoom Image",      "        Show Preview...",     "        Show Histogram",      "        Show Matte",      "      Help",      "      Dismiss",     "", C     "You can make adjustments to the region of interest by moving", >     "the pointer to one of the rectangle corners, pressing a",A     "button, and dragging.  Finally, choose an image processing", C     "technique from the Command widget.  You can choose more than", :     "one image processing technique to apply to an area.",@     "Alternatively, you can move the region of interest before",C     "applying another image processing technique.  To exit, press",      "Dismiss.",      (char *) NULL,   },   *ImageRotateHelp[]=    { <     "In rotate mode, the Command widget has these options:",     "",      "    Pixel Color",     "      black",     "      blue",      "      cyan",      "      green",     "      gray",      "      red",     "      magenta",     "      yellow",      "      white",     "      Browser...",      "    Direction",     "      horizontal",      "      vertical",      "    Crop",      "      false",     "      true",      "    Sharpen",     "      false",     "      true",      "    Help",      "    Dismiss",     "", ?     "Choose a background color from the Pixel Color sub-menu.", C     "Additional background colors can be specified with the color", @     "browser.  You can change the menu colors by setting the X",#     "resources pen1 through pen9.",      "", >     "If you choose the color browser and press Grab, you can",?     "select the background color by moving the pointer to the", 8     "desired color on the screen and press any button.",     "", C     "Choose a point in the image window and press this button and", ?     "hold.  Next, move the pointer to another location in the", C     "image.  As you move a line connects the initial location and", ?     "the pointer.  When you release the button, the degree of", @     "image rotation is determined by the slope of the line you",=     "just drew.  The slope is relative to the direction you", @     "choose from the Direction sub-menu of the Command widget.",     "", A     "To cancel the image rotation, move the pointer back to the", 9     "starting point of the line and release the button.",      (char *) NULL,   };   /*   Enumeration declarations.  */ typedef enum {    CopyMode,    CropMode, 	   CutMode  } ClipboardMode;   typedef enum {    OpenCommand,   NextCommand,   FormerCommand,   SelectCommand,   SaveCommand,   PrintCommand,    DeleteCommand,
   NewCommand,    VisualDirectoryCommand,    QuitCommand,   UndoCommand,   RedoCommand,
   CutCommand,    CopyCommand,   PasteCommand,    HalfSizeCommand,   OriginalSizeCommand,   DoubleSizeCommand,   ResizeCommand,   ApplyCommand,    RefreshCommand,    RestoreCommand,    CropCommand,   ChopCommand,   FlopCommand,   FlipCommand,   RotateRightCommand,    RotateLeftCommand,   RotateCommand,   ShearCommand,    RollCommand,   TrimCommand,
   HueCommand,    SaturationCommand,   BrightnessCommand,   GammaCommand,    SpiffCommand,    DullCommand,   EqualizeCommand,   NormalizeCommand,    NegateCommand,   GrayscaleCommand, 
   MapCommand,    QuantizeCommand,   DespeckleCommand,    EmbossCommand,   ReduceNoiseCommand,    AddNoiseCommand,   SharpenCommand,    BlurCommand,   ThresholdCommand,    EdgeDetectCommand,   SpreadCommand,   ShadeCommand,    RaiseCommand,    SegmentCommand,    SolarizeCommand,   SwirlCommand,    ImplodeCommand,    WaveCommand,   OilPaintCommand,   CharcoalDrawingCommand,    AnnotateCommand,   DrawCommand,   ColorCommand,    MatteCommand,    CompositeCommand,    AddBorderCommand,    AddFrameCommand,   CommentCommand,    LaunchCommand,   RegionofInterestCommand,   ROIHelpCommand,    ROIDismissCommand,   InfoCommand,   ZoomCommand,   ShowPreviewCommand,    ShowHistogramCommand,    ShowMatteCommand,    BackgroundCommand,   SlideShowCommand,    PreferencesCommand,    HelpCommand,   BrowseDocumentationCommand,    VersionCommand,    SaveToUndoBufferCommand,   FreeBuffersCommand, 
   NullCommand  } CommandType;   typedef enum {    AnnotateNameCommand,   AnnotateFontColorCommand, !   AnnotateBackgroundColorCommand,    AnnotateRotateCommand,   AnnotateHelpCommand,   AnnotateDismissCommand,    TextHelpCommand,   TextApplyCommand,    ChopDirectionCommand,    ChopHelpCommand,   ChopDismissCommand,    HorizontalChopCommand,   VerticalChopCommand,   ColorEditMethodCommand,    ColorEditColorCommand,   ColorEditBorderCommand,    ColorEditFuzzCommand,    ColorEditUndoCommand,    ColorEditHelpCommand,    ColorEditDismissCommand,   CompositeOperatorsCommand,   CompositeBlendCommand,   CompositeDisplaceCommand,    CompositeHelpCommand,    CompositeDismissCommand,   CropHelpCommand,   CropDismissCommand,    RectifyCopyCommand,    RectifyHelpCommand,    RectifyDismissCommand,   DrawPrimitiveCommand,    DrawColorCommand,    DrawStippleCommand,    DrawWidthCommand,    DrawUndoCommand,   DrawHelpCommand,   DrawDismissCommand,    MatteEditMethod,   MatteEditBorderCommand,    MatteEditFuzzCommand,    MatteEditValueCommand,   MatteEditUndoCommand,    MatteEditHelpCommand,    MatteEditDismissCommand,   PasteOperatorsCommand,   PasteHelpCommand,    PasteDismissCommand,   RotateColorCommand,    RotateDirectionCommand,    RotateCropCommand,   RotateSharpenCommand,    RotateHelpCommand,   RotateDismissCommand,    HorizontalRotateCommand,   VerticalRotateCommand,   TileLoadCommand,   TileNextCommand,   TileFormerCommand,   TileDeleteCommand,   TileUpdateCommand  } ModeType;    /*   Stipples.  */ #define BricksWidth  20  #define BricksHeight  20 #define DiagonalWidth  16  #define DiagonalHeight  16 #define HighlightWidth  8  #define HighlightHeight  8 #define ScalesWidth  16  #define ScalesHeight  16 #define ShadowWidth  8 #define ShadowHeight  8  #define VerticalWidth  16  #define VerticalHeight  16 #define WavyWidth  16  #define WavyHeight  16   const unsigned char    BricksBitmap[] =   { K     0xff, 0xff, 0x0f, 0x03, 0x0c, 0x00, 0x03, 0x0c, 0x00, 0x03, 0x0c, 0x00, K     0x03, 0x0c, 0x00, 0xff, 0xff, 0x0f, 0x60, 0x80, 0x01, 0x60, 0x80, 0x01, K     0x60, 0x80, 0x01, 0x60, 0x80, 0x01, 0xff, 0xff, 0x0f, 0x03, 0x0c, 0x00, K     0x03, 0x0c, 0x00, 0x03, 0x0c, 0x00, 0x03, 0x0c, 0x00, 0xff, 0xff, 0x0f, J     0x60, 0x80, 0x01, 0x60, 0x80, 0x01, 0x60, 0x80, 0x01, 0x60, 0x80, 0x01   },   DiagonalBitmap[] =   { K     0x44, 0x44, 0x88, 0x88, 0x11, 0x11, 0x22, 0x22, 0x44, 0x44, 0x88, 0x88, K     0x11, 0x11, 0x22, 0x22, 0x44, 0x44, 0x88, 0x88, 0x11, 0x11, 0x22, 0x22, 2     0x44, 0x44, 0x88, 0x88, 0x11, 0x11, 0x22, 0x22   },   ScalesBitmap[] =   { K     0x08, 0x08, 0x08, 0x08, 0x14, 0x14, 0xe3, 0xe3, 0x80, 0x80, 0x80, 0x80, K     0x41, 0x41, 0x3e, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x14, 0x14, 0xe3, 0xe3, 2     0x80, 0x80, 0x80, 0x80, 0x41, 0x41, 0x3e, 0x3e   },   VerticalBitmap[] =   { K     0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, K     0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 2     0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11   },   WavyBitmap[] =   { K     0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfd, 0xff, 0xfd, 0xff, 0xfb, 0xff, K     0xe7, 0xff, 0x1f, 0xff, 0xff, 0xf8, 0xff, 0xe7, 0xff, 0xdf, 0xff, 0xbf, 2     0xff, 0xbf, 0xff, 0x7f, 0xff, 0x7f, 0xff, 0x7f   };   /*   Function prototypes. */ static CommandTypeN   XImageWindowCommand(Display *,XResourceInfo *,XWindows *,const unsigned int,     KeySym,Image **);    static ImageI   *XMagickCommand(Display *,XResourceInfo *,XWindows *,const CommandType,      Image **),G   *XOpenImage(Display *,XResourceInfo *,XWindows *,const unsigned int), E   *XTileImage(Display *,XResourceInfo *,XWindows *,Image *,XEvent *), ?   *XVisualDirectoryImage(Display *,XResourceInfo *,XWindows *);    static unsigned int C   XAnnotateEditImage(Display *,XResourceInfo *,XWindows *,Image *), @   XDrawEditImage(Display *,XResourceInfo *,XWindows *,Image **),<   XChopImage(Display *,XResourceInfo *,XWindows *,Image **),O   XCropImage(Display *,XResourceInfo *,XWindows *,Image *,const ClipboardMode), B   XBackgroundImage(Display *,XResourceInfo *,XWindows *,Image **),A   XColorEditImage(Display *,XResourceInfo *,XWindows *,Image **), @   XCompositeImage(Display *,XResourceInfo *,XWindows *,Image *),@   XConfigureImage(Display *,XResourceInfo *,XWindows *,Image *),A   XMatteEditImage(Display *,XResourceInfo *,XWindows *,Image **), <   XPasteImage(Display *,XResourceInfo *,XWindows *,Image *),<   XPrintImage(Display *,XResourceInfo *,XWindows *,Image *),E   XRotateImage(Display *,XResourceInfo *,XWindows *,double,Image **), ;   XROIImage(Display *,XResourceInfo *,XWindows *,Image **), ;   XSaveImage(Display *,XResourceInfo *,XWindows *,Image *), ;   XTrimImage(Display *,XResourceInfo *,XWindows *,Image *);    static void *   XDrawPanRectangle(Display *,XWindows *),O   XImageCache(Display *,XResourceInfo *,XWindows *,const CommandType,Image **), /   XMagnifyImage(Display *,XWindows *,XEvent *), >   XMakePanImage(Display *,XResourceInfo *,XWindows *,Image *),+   XPanImage(Display *,XWindows *,XEvent *), N   XMagnifyWindowCommand(Display *,XWindows *,const unsigned int,const KeySym),A   XSetCropGeometry(Display *,XWindows *,RectangleInfo *,Image *), .   XScreenEvent(Display *,XWindows *,XEvent *),=   XTranslateImage(Display *,XWindows *,Image *,const KeySym);   / #if defined(__cplusplus) || defined(c_plusplus)  }  #endif   #endif