 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            DDDD   PPPP   SSSSS                              % O %                            D   D  P   P  SS                                 % O %                            D   D  PPPP    SSS                               % O %                            D   D  P         SS                              % O %                            DDDD   P      SSSSS                              % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   #if defined(HasDPS)  #include "xwindows.h"  #include <DPS/dpsXclient.h>  #include <DPS/dpsXpreview.h> /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d D P S I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Method ReadDPSImage reads a Adobe Postscript image file and returns it.  ItK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % , %  The format of the ReadDPSImage method is: % 7 %      Image *ReadDPSImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadDPSImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadDPSImage(const ImageInfo *image_info)  {    char     *client_name;   	   Display 
     *display;      float      pixels_per_point;      Image      *image;      int 	     sans,      status,      x,     y;     Pixmap     pixmap;      register int     i;     register PixelPacket     *q;      register unsigned long
     pixel;     Screen     *screen;     XColor     *colors;     XImage     *dps_image;      XRectangle     page_info,     bits_per_pixel;      XResourceInfo      resource_info;  
   XrmDatabase      resource_database;     XStandardColormap      *map_info;  
   XVisualInfo      *visual_info;      /*     Open X server connection.    */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     return((Image *) NULL);    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)     return((Image *) NULL);    /*/     Get user defaults from X resource database.    */+   client_name=SetClientName((char *) NULL); >   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);    /*     Allocate standard colormap.    */$   map_info=XAllocStandardColormap();#   visual_info=(XVisualInfo *) NULL; -   if (map_info == (XStandardColormap *) NULL) L     MagickWarning(ResourceLimitWarning,"Unable to create standard colormap","       "Memory allocation failed");   else     {        /*         Initialize visual info.        */?       (void) CloneString(&resource_info.visual_type,"default"); C       visual_info=XBestVisualInfo(display,map_info,&resource_info); )       map_info->colormap=(Colormap) NULL;      } 1   if ((map_info == (XStandardColormap *) NULL) || ,       (visual_info == (XVisualInfo *) NULL))     {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*7     Create a pixmap the appropriate size for the image.    */6   screen=ScreenOfDisplay(display,visual_info->screen);.   pixels_per_point=XDPSPixelsPerPoint(screen);C   if ((image->x_resolution != 0.0) && (image->y_resolution != 0.0)) G     pixels_per_point=Min(image->x_resolution,image->y_resolution)/72.0; F   status=XDPSCreatePixmapForEPSF((DPSContext) NULL,screen,image->file,L     visual_info->depth,pixels_per_point,&pixmap,&bits_per_pixel,&page_info);L   if ((status == dps_status_failure) || (status == dps_status_no_extension))     {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*'     Rasterize the file into the pixmap.    */O   status=XDPSImageFileIntoDrawable((DPSContext) NULL,screen,pixmap,image->file, E     bits_per_pixel.height,visual_info->depth,&page_info,-page_info.x, 9     -page_info.y,pixels_per_point,True,False,True,&sans); #   if (status != dps_status_success)      {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*     Initialize DPS X image.    */>   dps_image=XGetImage(display,pixmap,0,0,bits_per_pixel.width,-     bits_per_pixel.height,AllPlanes,ZPixmap);    XFreePixmap(display,pixmap);#   if (dps_image == (XImage *) NULL)      {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*     Get the colormap colors.   */N   colors=(XColor *) AllocateMemory(visual_info->colormap_size*sizeof(XColor));    if (colors == (XColor *) NULL)     {        DestroyImage(image);       XDestroyImage(dps_image); F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      } ,   if ((visual_info->class != DirectColor) &&(       (visual_info->class != TrueColor))2     for (i=0; i < visual_info->colormap_size; i++)     {        colors[i].pixel=i;       colors[i].pad=0;     }    else     {        unsigned long 
         blue,          blue_bit,          green,         green_bit,         red,         red_bit;         /*(         DirectColor or TrueColor visual.       */       red=0;       green=0;
       blue=0; C       red_bit=visual_info->red_mask & (~(visual_info->red_mask)+1); I       green_bit=visual_info->green_mask & (~(visual_info->green_mask)+1); F       blue_bit=visual_info->blue_mask & (~(visual_info->blue_mask)+1);4       for (i=0; i < visual_info->colormap_size; i++)       { +         colors[i].pixel=red | green | blue;          colors[i].pad=0;         red+=red_bit; (         if (red > visual_info->red_mask)           red=0;         green+=green_bit; ,         if (green > visual_info->green_mask)           green=0;         blue+=blue_bit; *         if (blue > visual_info->blue_mask)           blue=0;        }      } L   XQueryColors(display,XDefaultColormap(display,visual_info->screen),colors,      visual_info->colormap_size);   /*#     Convert X image to MIFF format.    */*   if ((visual_info->class != TrueColor) &&*       (visual_info->class != DirectColor))     image->class=PseudoClass; "   image->columns=dps_image->width;    image->rows=dps_image->height;   switch (image->class)    {      case DirectClass:      default:     {        register unsigned long         color,         index;         unsigned long          blue_mask,         blue_shift,          green_mask,          green_shift,         red_mask,          red_shift;         /*:         Determine shift and mask for red, green, and blue.       */%       red_mask=visual_info->red_mask;        red_shift=0;$       while ((red_mask & 0x01) == 0)       {          red_mask>>=1;          red_shift++;       } )       green_mask=visual_info->green_mask;        green_shift=0;&       while ((green_mask & 0x01) == 0)       {          green_mask>>=1;          green_shift++;       } '       blue_mask=visual_info->blue_mask;        blue_shift=0; %       while ((blue_mask & 0x01) == 0)        {          blue_mask>>=1;         blue_shift++;        }        /*/         Convert X image to DirectClass packets.        */-       if ((visual_info->colormap_size > 0) && .           (visual_info->class == DirectColor))-         for (y=0; y < (int) image->rows; y++) 	         { 6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           { +             pixel=XGetPixel(dps_image,x,y); 2             index=(pixel >> red_shift) & red_mask;1             q->red=XDownScale(colors[index].red); 6             index=(pixel >> green_shift) & green_mask;5             q->green=XDownScale(colors[index].green); 4             index=(pixel >> blue_shift) & blue_mask;3             q->blue=XDownScale(colors[index].blue);              q++;           } %           if (!SyncPixelCache(image))              break;)           if (QuantumTick(y,image->rows)) 9             ProgressMonitor(LoadImageText,y,image->rows); 	         } 
       else-         for (y=0; y < (int) image->rows; y++) 	         { 6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           { +             pixel=XGetPixel(dps_image,x,y); 2             color=(pixel >> red_shift) & red_mask;7             q->red=XDownScale((color*65535L)/red_mask); 6             color=(pixel >> green_shift) & green_mask;;             q->green=XDownScale((color*65535L)/green_mask); 4             color=(pixel >> blue_shift) & blue_mask;9             q->blue=XDownScale((color*65535L)/blue_mask);              q++;           } %           if (!SyncPixelCache(image))              break;)           if (QuantumTick(y,image->rows)) 9             ProgressMonitor(LoadImageText,y,image->rows); 	         }        break;     }      case PseudoClass:      {        /*         Create colormap.       *//       image->colors=visual_info->colormap_size; %       image->colormap=(PixelPacket *) :         AllocateMemory(image->colors*sizeof(PixelPacket));2       if (image->colormap == (PixelPacket *) NULL)	         {            DestroyImage(image);           FreeMemory(colors); #           XDestroyImage(dps_image); J           XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,F             (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);!           return((Image *) NULL); 	         } -       for (i=0; i < (int) image->colors; i++)        { G         image->colormap[colors[i].pixel].red=XDownScale(colors[i].red); K         image->colormap[colors[i].pixel].green=XDownScale(colors[i].green); I         image->colormap[colors[i].pixel].blue=XDownScale(colors[i].blue);        }        /*/         Convert X image to PseudoClass packets.        */+       for (y=0; y < (int) image->rows; y++)        { 7         if (!SetPixelCache(image,0,y,image->columns,1))            break;0         for (x=0; x < (int) image->columns; x++)F           image->indexes[x]=(unsigned short) XGetPixel(dps_image,x,y);#         if (!SyncPixelCache(image))            break;'         if (QuantumTick(y,image->rows)) 7           ProgressMonitor(LoadImageText,y,image->rows);        }        break;     }    }    FreeMemory(colors);    XDestroyImage(dps_image); "   if (image->class == PseudoClass)     SyncImage(image);    /*     Rasterize matte image.   */H   status=XDPSCreatePixmapForEPSF((DPSContext) NULL,screen,image->file,1,9     pixels_per_point,&pixmap,&bits_per_pixel,&page_info); L   if ((status != dps_status_failure) && (status != dps_status_no_extension))     { G       status=XDPSImageFileIntoDrawable((DPSContext) NULL,screen,pixmap, D         image->file,bits_per_pixel.height,1,&page_info,-page_info.x,<         -page_info.y,pixels_per_point,True,True,True,&sans);'       if (status == dps_status_success) 	         {            XImage             *matte_image;              /*#             Initialize image matte.            */H           matte_image=XGetImage(display,pixmap,0,0,bits_per_pixel.width,5             bits_per_pixel.height,AllPlanes,ZPixmap); &           XFreePixmap(display,pixmap);-           if (matte_image != (XImage *) NULL) 
             { '               image->class=DirectClass;                 image->matte=True;3               for (y=0; y < (int) image->rows; y++)                { <                 q=SetPixelCache(image,0,y,image->columns,1);.                 if (q == (PixelPacket *) NULL)                   break;8                 for (x=0; x < (int) image->columns; x++)                 { $                   q->opacity=Opaque;2                   if (!XGetPixel(matte_image,x,y))+                     q->opacity=Transparent;                    q++;                 } +                 if (!SyncPixelCache(image))                    break;               } )               XDestroyImage(matte_image); 
             } 	         }      }    /*     Free resources.    */B   XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,>     (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);   CloseBlob(image);    return(image); }  #else 7 Export Image *ReadDPSImage(const ImageInfo *image_info)  { @   MagickWarning(MissingDelegateWarning,"Cannot read DPS images",     image_info->filename);   return((Image *) NULL);  }  #endif