 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                EEEEE  FFFFF  FFFFF  EEEEE  CCCC  TTTTT  SSSSS               % O %                E      F      F      E     C        T    SS                  % O %                EEE    FFF    FFF    EEE   C        T     SSS                % O %                E      F      F      E     C        T       SS               % O %                EEEEE  F      F      EEEEE  CCCC    T    SSSSS               % O %                                                                             % O %                                                                             % O %                      ImageMagick Image Effects Methods                      % O %                                                                             % O %                                                                             % O %                               Software Design                               % O %                                 John Cristy                                 % O %                                 October 1996                                % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     A d d N o i s e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method AddNoiseImage creates a new image that is a copy of an existing M %  one with noise added.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % - %  The format of the AddNoiseImage method is:  % D %      Image *AddNoiseImage(Image *image,const NoiseType noise_type) % + %  A description of each parameter follows:  % M %    o noisy_image: Method AddNoiseImage returns a pointer to the image after L %      the noise is minified.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % I %    o noise_type:  The type of noise: Gaussian, multiplicative Gaussian, & %      impulse, laplacian, or Poisson. %  %  */D Export Image *AddNoiseImage(Image *image,const NoiseType noise_type) { = #define AddNoiseImageText  "  Adding noise to the image...  "      Image      *noisy_image;      int      y;     register int     x;     register PixelPacket     *p,      *q;      /*&     Initialize noisy image attributes.   */"   assert(image != (Image *) NULL);@   noisy_image=CloneImage(image,image->columns,image->rows,True);$   if (noisy_image == (Image *) NULL)     { B       MagickWarning(ResourceLimitWarning,"Unable to reduce noise",$         "Memory allocation failed");       return((Image *) NULL);      } !   noisy_image->class=DirectClass;    /*     Add noise in each row.   */'   for (y=0; y < (int) image->rows; y++)    { 0     p=GetPixelCache(image,0,y,image->columns,1);<     q=SetPixelCache(noisy_image,0,y,noisy_image->columns,1);C     if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))        break;,     for (x=0; x < (int) image->columns; x++)     { .       q->red=GenerateNoise(p->red,noise_type);2       q->green=GenerateNoise(p->green,noise_type);0       q->blue=GenerateNoise(p->blue,noise_type);
       q++;     } %     if (!SyncPixelCache(noisy_image))        break;#     if (QuantumTick(y,image->rows)) 7       ProgressMonitor(AddNoiseImageText,y,image->rows);    }    return(noisy_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     B l u r I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method BlurImage creates a new image that is a copy of an existing J %  one with the pixels blurred.  It allocates the memory necessary for the> %  new Image structure and returns a pointer to the new image. % F %  BlurImage convolves the pixel neighborhood with this blurring mask: % 
 %     1  2  1 
 %     2  W  2 
 %     1  2  1  % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % ) %  The format of the BlurImage method is:  % 9 %      Image *BlurImage(Image *image,const double factor)  % + %  A description of each parameter follows:  % B %    o blur_image: Method BlurImage returns a pointer to the imageJ %      after it is blurred.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o factor:  An double value reflecting the percent weight to give to the( %      center pixel of the neighborhood. %  %  */9 Export Image *BlurImage(Image *image,const double factor)  {  #define Blur(weight) \   total_red+=(weight)*s->red; \ #   total_green+=(weight)*s->green; \ !   total_blue+=(weight)*s->blue; \    s++;. #define BlurImageText  "  Blurring image...  "     double     total_blue,      total_green,     total_red,     weight;      Image      *blur_image;     int      y;     register int     x;     register PixelPacket     *p,      *q,      *s;      unsigned int     quantum;  "   assert(image != (Image *) NULL);0   if ((image->columns < 3) || (image->rows < 3))     return((Image *) NULL);    /*     Clone blurred image.   */?   blur_image=CloneImage(image,image->columns,image->rows,True); #   if (blur_image == (Image *) NULL)      { @       MagickWarning(ResourceLimitWarning,"Unable to blur image",$         "Memory allocation failed");       return((Image *) NULL);      }     blur_image->class=DirectClass;   /*     Blur image.    */   weight=(100.0-factor)/2;*   quantum=(unsigned int) Max(weight+12,1);'   for (y=0; y < (int) image->rows; y++)    { L     p=GetPixelCache(image,0,Min(Max(y-1,0),image->rows-3),image->columns,3);:     q=SetPixelCache(blur_image,0,y,blur_image->columns,1);C     if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))        break;     /*       Blur this row of pixels.     */     *q++=(*(p+image->columns)); 0     for (x=1; x < (int) (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0.0;       total_green=0.0;       total_blue=0.0; 
       s=p;!       Blur(1);  Blur(2); Blur(1);        s=p+image->columns; %       Blur(2); Blur(weight); Blur(2);        s=p+2*image->columns; !       Blur(1);  Blur(2); Blur(1); -       q->red=(total_red+(quantum/2))/quantum; 1       q->green=(total_green+(quantum/2))/quantum; /       q->blue=(total_blue+(quantum/2))/quantum; -       q->opacity=(p+image->columns)->opacity; 
       p++;
       q++;     }      p++;     *q++=(*p);$     if (!SyncPixelCache(blur_image))       break;#     if (QuantumTick(y,image->rows)) 3       ProgressMonitor(BlurImageText,y,image->rows);    }    return(blur_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     C o l o r i z e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method ColorizeImage creates a new image that is a copy of an existing G %  one with the image pixels colorized.  The colorization is controlled - %  with the pen color and the opacity levels.  % - %  The format of the ColorizeImage method is:  % = %      Image *ColorizeImage(Image *image,const char *opacity,  %        const char *pen_color)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % H %    o opacity:  A character string indicating the level of opacity as a %      percentage (0-100). % ! %      pen_color: A color string.  %  %  */= Export Image *ColorizeImage(Image *image,const char *opacity,    const char *pen_color) { 8 #define ColorizeImageText  "  Colorizing the image...  "     Image      *colorize_image;     int      y;     long     blue_opacity, 
     count,     green_opacity,     red_opacity;  
   PixelPacket      target;      register int     x;     register PixelPacket     *p,      *q;      /*     Allocate colorized image.    */"   assert(image != (Image *) NULL);C   colorize_image=CloneImage(image,image->columns,image->rows,True); '   if (colorize_image == (Image *) NULL)      { E       MagickWarning(ResourceLimitWarning,"Unable to colorized image", $         "Memory allocation failed");       return((Image *) NULL);      } $   colorize_image->class=DirectClass;   /**     Determine RGB values of the pen color.   *//   (void) QueryColorDatabase(pen_color,&target);    red_opacity=100;   green_opacity=100;   blue_opacity=100; P   count=sscanf(opacity,"%ld/%ld/%ld",&red_opacity,&green_opacity,&blue_opacity);   if (count == 1)      {        if (red_opacity == 0)          return(colorize_image);         green_opacity=red_opacity;       blue_opacity=red_opacity;      }    /*     Colorize DirectClass image.    */'   for (y=0; y < (int) image->rows; y++)    { 0     p=GetPixelCache(image,0,y,image->columns,1);B     q=SetPixelCache(colorize_image,0,y,colorize_image->columns,1);C     if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))        break;,     for (x=0; x < (int) image->columns; x++)     { '       q->red=(Quantum) ((unsigned long) ?         (p->red*(100-red_opacity)+target.red*red_opacity)/100); )       q->green=(Quantum) ((unsigned long) G         (p->green*(100-green_opacity)+target.green*green_opacity)/100); (       q->blue=(Quantum) ((unsigned long)C         (p->blue*(100-blue_opacity)+target.blue*blue_opacity)/100); 
       p++;
       q++;     } (     if (!SyncPixelCache(colorize_image))       break;#     if (QuantumTick(y,image->rows)) 7       ProgressMonitor(ColorizeImageText,y,image->rows);    }    return(colorize_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     D e s p e c k l e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method DespeckleImage creates a new image that is a copy of an existingI %  one with the speckle noise minified.  It uses the eight hull algorithm O %  described in Applied Optics, Vol. 24, No. 10, 15 May 1985, "Geometric filter L %  for Speckle Reduction", by Thomas R Crimmins.  Each pixel in the image isN %  replaced by one of its eight of its surrounding pixels using a polarity andM %  negative hull function.  DespeckleImage allocates the memory necessary for B %  the new Image structure and returns a pointer to the new image. % . %  The format of the DespeckleImage method is: % * %      Image *DespeckleImage(Image *image) % + %  A description of each parameter follows:  % L %    o despeckle_image: Method DespeckleImage returns a pointer to the imageM %      after it is despeckled.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */* Export Image *DespeckleImage(Image *image) { 6 #define DespeckleImageText  "  Despeckling image...  "     Image      *despeckle_image;      int      y;  	   Quantum      *blue_channel,     *buffer,     *green_channel,      *matte_channel,      *red_channel;      register int     i,     j,     x;     register PixelPacket     *p,      *q;      static const int     X[4]= {0, 1, 1,-1},      Y[4]= {1, 0, 1, 1};      unsigned int     packets;     /*     Allocate despeckled image.   */"   assert(image != (Image *) NULL);D   despeckle_image=CloneImage(image,image->columns,image->rows,True);(   if (despeckle_image == (Image *) NULL)     { E       MagickWarning(ResourceLimitWarning,"Unable to despeckle image", $         "Memory allocation failed");       return((Image *) NULL);      } %   despeckle_image->class=DirectClass;    /*     Allocate image buffers.    */-   packets=(image->columns+2)*(image->rows+2); B   red_channel=(Quantum *) AllocateMemory(packets*sizeof(Quantum));D   green_channel=(Quantum *) AllocateMemory(packets*sizeof(Quantum));C   blue_channel=(Quantum *) AllocateMemory(packets*sizeof(Quantum)); D   matte_channel=(Quantum *) AllocateMemory(packets*sizeof(Quantum));=   buffer=(Quantum *) AllocateMemory(packets*sizeof(Quantum)); *   if ((red_channel == (Quantum *) NULL) ||,       (green_channel == (Quantum *) NULL) ||+       (blue_channel == (Quantum *) NULL) || ,       (matte_channel == (Quantum *) NULL) ||#       (buffer == (Quantum *) NULL))      { E       MagickWarning(ResourceLimitWarning,"Unable to despeckle image", $         "Memory allocation failed");$       DestroyImage(despeckle_image);       return((Image *) NULL);      }    /*     Zero image buffers.    */#   for (i=0; i < (int) packets; i++)    {      red_channel[i]=0;      green_channel[i]=0;      blue_channel[i]=0;     matte_channel[i]=0;      buffer[i]=0;   }    /*0     Copy image pixels to color component buffers   */   j=image->columns+2; '   for (y=0; y < (int) image->rows; y++)    { 0     p=GetPixelCache(image,0,y,image->columns,1);"     if (p == (PixelPacket *) NULL)       break;     j++;,     for (x=0; x < (int) image->columns; x++)     {        red_channel[j]=p->red;        green_channel[j]=p->green;       blue_channel[j]=p->blue;"       matte_channel[j]=p->opacity;
       p++;
       j++;     }      j++;   }    /*"     Reduce speckle in red channel.   */   for (i=0; i < 4; i++)    { -     ProgressMonitor(DespeckleImageText,i,12); D     Hull(X[i],Y[i],1,image->columns,image->rows,red_channel,buffer);F     Hull(-X[i],-Y[i],1,image->columns,image->rows,red_channel,buffer);G     Hull(-X[i],-Y[i],-1,image->columns,image->rows,red_channel,buffer); E     Hull(X[i],Y[i],-1,image->columns,image->rows,red_channel,buffer);    }    /*$     Reduce speckle in green channel.   */#   for (i=0; i < (int) packets; i++)      buffer[i]=0;   for (i=0; i < 4; i++)    { /     ProgressMonitor(DespeckleImageText,i+4,12); F     Hull(X[i],Y[i],1,image->columns,image->rows,green_channel,buffer);H     Hull(-X[i],-Y[i],1,image->columns,image->rows,green_channel,buffer);I     Hull(-X[i],-Y[i],-1,image->columns,image->rows,green_channel,buffer); G     Hull(X[i],Y[i],-1,image->columns,image->rows,green_channel,buffer);    }    /*#     Reduce speckle in blue channel.    */#   for (i=0; i < (int) packets; i++)      buffer[i]=0;   for (i=0; i < 4; i++)    { /     ProgressMonitor(DespeckleImageText,i+8,12); E     Hull(X[i],Y[i],1,image->columns,image->rows,blue_channel,buffer); G     Hull(-X[i],-Y[i],1,image->columns,image->rows,blue_channel,buffer); H     Hull(-X[i],-Y[i],-1,image->columns,image->rows,blue_channel,buffer);F     Hull(X[i],Y[i],-1,image->columns,image->rows,blue_channel,buffer);   }    /*5     Copy color component buffers to despeckled image.    */   j=image->columns+2; '   for (y=0; y < (int) image->rows; y++)    { D     q=SetPixelCache(despeckle_image,0,y,despeckle_image->columns,1);"     if (q == (PixelPacket *) NULL)       break;     j++;,     for (x=0; x < (int) image->columns; x++)     {        q->red=red_channel[j];        q->green=green_channel[j];       q->blue=blue_channel[j];"       q->opacity=matte_channel[j];
       q++;
       j++;     } )     if (!SyncPixelCache(despeckle_image))        break;     j++;   }    /*     Free memory.   */   FreeMemory(buffer);    FreeMemory(matte_channel);   FreeMemory(blue_channel);    FreeMemory(green_channel);   FreeMemory(red_channel);   return(despeckle_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E d g e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method EdgeImage creates a new image that is a copy of an existing M %  one with the edges highlighted.  It allocates the memory necessary for the > %  new Image structure and returns a pointer to the new image. % L %  EdgeImage convolves the pixel neighborhood with this edge detection mask: % 
 %    -1 -1 -1 
 %    -1  W -1 
 %    -1 -1 -1  % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % ) %  The format of the EdgeImage method is:  % 9 %      Image *EdgeImage(Image *image,const double factor)  % + %  A description of each parameter follows:  % B %    o edge_image: Method EdgeImage returns a pointer to the imageG %      after it is edge.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o factor:  An double value reflecting the percent weight to give to the( %      center pixel of the neighborhood. %  %  */9 Export Image *EdgeImage(Image *image,const double factor)  {  #define Edge(weight) \   total_red+=(weight)*s->red; \ #   total_green+=(weight)*s->green; \ !   total_blue+=(weight)*s->blue; \ '   total_opacity+=(weight)*s->opacity; \    s++;5 #define EdgeImageText  "  Detecting image edges...  "      double     total_blue,      total_green,     total_opacity,     total_red,     weight;      Image      *edge_image;     int      y;     register int     x;     register PixelPacket     *p,      *q,      *s;   "   assert(image != (Image *) NULL);0   if ((image->columns < 3) || (image->rows < 3))     return((Image *) NULL);    /*%     Initialize edge image attributes.    */?   edge_image=CloneImage(image,image->columns,image->rows,True); #   if (edge_image == (Image *) NULL)      { B       MagickWarning(ResourceLimitWarning,"Unable to detect edges",$         "Memory allocation failed");       return((Image *) NULL);      }     edge_image->class=DirectClass;   /*     Edge detect image.   */   weight=factor/8.0;'   for (y=0; y < (int) image->rows; y++)    { L     p=GetPixelCache(image,0,Min(Max(y-1,0),image->rows-3),image->columns,3);:     q=SetPixelCache(edge_image,0,y,edge_image->columns,1);C     if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))        break;     /*%       Edge detect this row of pixels.      */     *q++=(*(p+image->columns)); 0     for (x=1; x < (int) (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0.0;       total_green=0.0;       total_blue=0.0;        total_opacity=0.0;
       s=p;7       Edge(-weight/8); Edge(-weight/8) Edge(-weight/8);        s=p+image->columns; 5       Edge(-weight/8); Edge(weight); Edge(-weight/8);        s=p+2*image->columns; 8       Edge(-weight/8); Edge(-weight/8); Edge(-weight/8);M       q->red=(total_red < 0) ? 0 : (total_red > MaxRGB) ? MaxRGB : total_red;        q->green= N         (total_green < 0) ? 0 : (total_green > MaxRGB) ? MaxRGB : total_green;       q->blue=K         (total_blue < 0) ? 0 : (total_blue > MaxRGB) ? MaxRGB : total_blue; ?       q->opacity=((total_opacity < Transparent) ? Transparent : ;         (total_opacity > Opaque) ? Opaque : total_opacity); 
       p++;
       q++;     }      p++;     *q++=(*p);$     if (!SyncPixelCache(edge_image))       break;#     if (QuantumTick(y,image->rows)) 5       ProgressMonitor(EdgeImageText,y,image->rows-1);    }    /*     Normalize image.   */   NormalizeImage(edge_image);    return(edge_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E m b o s s I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method EmbossImage creates a new image that is a copy of an existing L %  one with the edge highlighted.  It allocates the memory necessary for the> %  new Image structure and returns a pointer to the new image. % N %  EmbossImage convolves the pixel neighborhood with this edge detection mask: % 
 %    -1 -2  0 
 %    -2  0  2 
 %     0  2  1  % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % + %  The format of the EmbossImage method is:  % ' %      Image *EmbossImage(Image *image)  % + %  A description of each parameter follows:  % F %    o emboss_image: Method EmbossImage returns a pointer to the imageK %      after it is embossed.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */' Export Image *EmbossImage(Image *image)  { 1 #define EmbossImageText  "  Embossing image...  "  #define Emboss(weight) \   total_red+=(weight)*s->red; \ #   total_green+=(weight)*s->green; \ !   total_blue+=(weight)*s->blue; \    s++;     double     total_blue,      total_green,     total_red;     Image      *emboss_image;     int      y;     register int     x;     register PixelPacket     *p,      *q,      *s;   "   assert(image != (Image *) NULL);0   if ((image->columns < 3) || (image->rows < 3))     return((Image *) NULL);    /*)     Initialize embossed image attributes.    */A   emboss_image=CloneImage(image,image->columns,image->rows,True); %   if (emboss_image == (Image *) NULL)      { C       MagickWarning(ResourceLimitWarning,"Unable to enhance image", $         "Memory allocation failed");       return((Image *) NULL);      } "   emboss_image->class=DirectClass;   /*     Emboss image.    */'   for (y=0; y < (int) image->rows; y++)    { L     p=GetPixelCache(image,0,Min(Max(y-1,0),image->rows-3),image->columns,3);>     q=SetPixelCache(emboss_image,0,y,emboss_image->columns,1);C     if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))        break;     /*        Emboss this row of pixels.     */     *q++=(*(p+image->columns)); 0     for (x=1; x < (int) (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0.0;       total_green=0.0;       total_blue=0.0; 
       s=p;)       Emboss(-1); Emboss(-2); Emboss( 0);        s=p+image->columns; )       Emboss(-2); Emboss( 0); Emboss( 2);        s=p+2*image->columns; )       Emboss( 0); Emboss( 2); Emboss( 1);        total_red+=(MaxRGB+1)/2;M       q->red=(total_red < 0) ? 0 : (total_red > MaxRGB) ? MaxRGB : total_red;         total_green+=(MaxRGB+1)/2;       q->green= N         (total_green < 0) ? 0 : (total_green > MaxRGB) ? MaxRGB : total_green;       total_blue+=(MaxRGB+1)/2;        q->blue=K         (total_blue < 0) ? 0 : (total_blue > MaxRGB) ? MaxRGB : total_blue; -       q->opacity=(p+image->columns)->opacity; 
       p++;
       q++;     }      p++;     *q++=(*p);&     if (!SyncPixelCache(emboss_image))       break;#     if (QuantumTick(y,image->rows)) 7       ProgressMonitor(EmbossImageText,y,image->rows-1);    }    /*-     Convert image to grayscale and normalize.    */"   emboss_image->class=DirectClass;#   (void) IsGrayImage(emboss_image);    NormalizeImage(emboss_image);    return(emboss_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E n h a n c e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method EnhanceImage creates a new image that is a copy of an existingN %  one with the noise minified.  It allocates the memory necessary for the new: %  Image structure and returns a pointer to the new image. % K %  EnhanceImage does a weighted average of pixels in a 5x5 cell around each L %  target pixel.  Only pixels in the 5x5 cell that are within a RGB distance. %  threshold of the target pixel are averaged. % G %  Weights assume that the importance of neighboring pixels is negately F %  proportional to the square of their distance from the target pixel. % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % , %  The format of the EnhanceImage method is: % ( %      Image *EnhanceImage(Image *image) % + %  A description of each parameter follows:  % H %    o enhance_image: Method EnhanceImage returns a pointer to the imageK %      after it is enhanced.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */( Export Image *EnhanceImage(Image *image) {  #define Enhance(weight) \    mean=(int) (s->red+red)/2; \   distance=s->red-(int) red; \   distance_squared= \ B     (2.0*(MaxRGB+1)+mean)*squares[distance]/(double) (MaxRGB+1); \"   distance=s->green-(int) green; \,   distance_squared+=4.0*squares[distance]; \    distance=s->blue-(int) blue; \   distance_squared+= \F     (3.0*(MaxRGB+1)-1.0-mean)*squares[distance]/(double) (MaxRGB+1); \%   if (distance_squared < Threshold) \      { \ #       total_red+=(weight)*s->red; \ '       total_green+=(weight)*s->green; \ %       total_blue+=(weight)*s->blue; \        total_weight+=(weight); \      } \    s++;2 #define EnhanceImageText  "  Enhancing image...  " #define Threshold  2500      double     distance_squared, 	     mean,      total_blue,      total_green,     total_red,     total_weight;      Image      *enhance_image;      int      y;     long
     distance;   	   Quantum 	     blue, 
     green,     red;     register int     i,     x;     register PixelPacket     *p,      *q,      *s;      register unsigned int 
     *squares;   "   assert(image != (Image *) NULL);0   if ((image->columns < 5) || (image->rows < 5))     return((Image *) NULL);    /*)     Initialize enhanced image attributes.    */B   enhance_image=CloneImage(image,image->columns,image->rows,True);&   if (enhance_image == (Image *) NULL)     { C       MagickWarning(ResourceLimitWarning,"Unable to enhance image", $         "Memory allocation failed");       return((Image *) NULL);      } #   enhance_image->class=DirectClass;    /*      Allocate the squares buffer.   */   squares=(unsigned int *);     AllocateMemory((MaxRGB+MaxRGB+1)*sizeof(unsigned int)); '   if (squares == (unsigned int *) NULL)      { C       MagickWarning(ResourceLimitWarning,"Unable to enhance image", $         "Memory allocation failed");"       DestroyImage(enhance_image);       return((Image *) NULL);      }    squares+=MaxRGB;%   for (i=(-MaxRGB); i <= MaxRGB; i++)      squares[i]=i*i;    /*     Enhance image.   */'   for (y=0; y < (int) image->rows; y++)    {      /*       Read another scan line.      */L     p=GetPixelCache(image,0,Min(Max(y-2,0),image->rows-5),image->columns,5);@     q=SetPixelCache(enhance_image,0,y,enhance_image->columns,1);C     if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))        break;     /*.       Transfer first 2 pixels of the scanline.     */!     *q++=(*(p+2*image->columns)); #     *q++=(*(p+2*image->columns+1)); 0     for (x=2; x < (int) (image->columns-2); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0.0;       total_green=0.0;       total_blue=0.0;        total_weight=0.0;        s=p+2*image->columns+2;        red=s->red;        green=s->green;        blue=s->blue; 
       s=p;E       Enhance(5);  Enhance(8);  Enhance(10); Enhance(8);  Enhance(5);        s=p+image->columns; E       Enhance(8);  Enhance(20); Enhance(40); Enhance(20); Enhance(8);        s=p+2*image->columns; F       Enhance(10); Enhance(40); Enhance(80); Enhance(40); Enhance(10);       s=p+3*image->columns; E       Enhance(8);  Enhance(20); Enhance(40); Enhance(20); Enhance(8);        s=p+4*image->columns; E       Enhance(5);  Enhance(8);  Enhance(10); Enhance(8);  Enhance(5); 9       q->red=(total_red+(total_weight/2)-1)/total_weight; =       q->green=(total_green+(total_weight/2)-1)/total_weight; ;       q->blue=(total_blue+(total_weight/2)-1)/total_weight; /       q->opacity=(p+2*image->columns)->opacity; 
       q++;     }      p++;     *q++=(*p);     p++;     *q++=(*p);'     if (!SyncPixelCache(enhance_image))        break;#     if (QuantumTick(y,image->rows)) 8       ProgressMonitor(EnhanceImageText,y,image->rows-2);   }    /*     Free memory resources.   */   squares-=MaxRGB;   FreeMemory(squares);   return(enhance_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     I m p l o d e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method ImplodeImage creates a new image that is a copy of an existingG %  one with the image pixels "implode" by the specified percentage.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % , %  The format of the ImplodeImage method is: % < %      Image *ImplodeImage(Image *image,const double factor) % + %  A description of each parameter follows:  % H %    o implode_image: Method ImplodeImage returns a pointer to the imageJ %      after it is implode.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % H %    o factor:  A double value that defines the extent of the implosion. %  %  */< Export Image *ImplodeImage(Image *image,const double factor) { 2 #define ImplodeImageText  "  Imploding image...  "     double     amount, 
     distance,      radius, 
     x_center,      x_distance,      x_scale,
     y_center,      y_distance,      y_scale;     Image      *implode_image;      int      y;     register PixelPacket     *p,      *q;      register unsigned int      x;     /*(     Initialize implode image attributes.   */"   assert(image != (Image *) NULL);   if (!image->matte)     MatteImage(image,Opaque); B   implode_image=CloneImage(image,image->columns,image->rows,True);&   if (implode_image == (Image *) NULL)     { C       MagickWarning(ResourceLimitWarning,"Unable to implode image", $         "Memory allocation failed");       return((Image *) NULL);      }    /*     Compute scaling factor.    */   x_scale=1.0;   y_scale=1.0;'   x_center=(double) image->columns/2.0; $   y_center=(double) image->rows/2.0;   radius=x_center;#   if (image->columns > image->rows) 0     y_scale=(double) image->columns/image->rows;   else%     if (image->columns < image->rows)        { 4         x_scale=(double) image->rows/image->columns;         radius=y_center;       }    amount=factor/10.0;    if (amount >= 0)     amount/=10.0;    /*     Implode each row.    */!   for (y=0; y < image->rows; y++)    { 0     p=GetPixelCache(image,0,y,image->columns,1);@     q=SetPixelCache(implode_image,0,y,implode_image->columns,1);C     if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))        break;$     y_distance=y_scale*(y-y_center);&     for (x=0; x < image->columns; x++)     {        /*4         Determine if the pixel is within an ellipse.       */       *q=(*p);&       x_distance=x_scale*(x-x_center);;       distance=x_distance*x_distance+y_distance*y_distance; %       if (distance < (radius*radius)) 	         {            double             factor;              /*             Implode the pixel.           */           factor=1.0;            if (distance > 0.0) D             factor=pow(sin(0.5*M_PI*sqrt(distance)/radius),-amount);G           *q=InterpolateColor(image,factor*x_distance/x_scale+x_center, 0             factor*y_distance/y_scale+y_center);	         } 
       p++;
       q++;     } '     if (!SyncPixelCache(implode_image))        break;#     if (QuantumTick(y,image->rows)) 6       ProgressMonitor(ImplodeImageText,y,image->rows);   }    return(implode_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     M e d i a n F i l t e r I m a g e                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method MedianFilterImage creates a new image that is a copy of an existing D %  one with each pixel component replaced with the median color in a %  circular neighborhood.  % 1 %  The format of the MedianFilterImage method is:  % G %      Image *MedianFilterImage(Image *image,const unsigned int radius)  % + %  A description of each parameter follows:  % L %    o median_image: Method MedianFilterImage returns a pointer to the imageM %      after it is `filtered'.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % A %    o radius: An unsigned int that is the radius of the circular  %      neighborhood. %  %  */  5 static int MedianCompare(const void *x,const void *y)  { 
   PixelPacket 
     *color_1, 
     *color_2;      color_1=(PixelPacket *) x;   color_2=(PixelPacket *) y;>   return((int) Intensity(*color_1)-(int) Intensity(*color_2)); }   G Export Image *MedianFilterImage(Image *image,const unsigned int radius)  { Q #define MedianFilterImageText  "  Filtering image with neighborhood ranking...  "      Image      *median_image;     int      y;  
   PixelPacket      *neighbors;      register int     i,     x;     register PixelPacket     *p,      *q,      *s,      *t;      unsigned int     length;   "   assert(image != (Image *) NULL);F   if ((image->columns < (2*radius+1)) || (image->rows < (2*radius+1)))     { @       MagickWarning(ResourceLimitWarning,"Unable to oil median",%         "image smaller than radius");        return((Image *) NULL);      }    /*'     Initialize median image attributes.    */A   median_image=CloneImage(image,image->columns,image->rows,True); %   if (median_image == (Image *) NULL)      { B       MagickWarning(ResourceLimitWarning,"Unable to reduce noise",$         "Memory allocation failed");       return((Image *) NULL);      } "   median_image->class=DirectClass;   /*$     Allocate neighbors and scanline.   */8   length=M_PI*(radius+1)*(radius+1)*sizeof(PixelPacket);G   neighbors=(PixelPacket *) AllocateMemory(length*sizeof(PixelPacket)); (   if (neighbors == (PixelPacket *) NULL)     { B       MagickWarning(ResourceLimitWarning,"Unable to reduce noise",$         "Memory allocation failed");!       DestroyImage(median_image);        return((Image *) NULL);      }    /*      Paint each row of the image.   */5   for (y=radius; y < (int) (image->rows-radius); y++)    { @     p=GetPixelCache(image,0,y-radius,image->columns,2*radius+1);>     q=GetPixelCache(median_image,0,y,median_image->columns,1);C     if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))        break;$     p+=radius*image->columns+radius;     q+=radius;:     for (x=radius; x < (int) (image->columns-radius); x++)     {        /*&         Determine most frequent color.       */       t=neighbors;&       for (i=0; i < (int) radius; i++)       { *         s=p-(radius-i)*image->columns-i-1;7         (void) memcpy(t,s,(2*i+1)*sizeof(PixelPacket));          t+=2*i+1; *         s=p+(radius-i)*image->columns-i-1;7         (void) memcpy(t,s,(2*i+1)*sizeof(PixelPacket));          t+=2*i+1;        }        s=p-radius; ?       (void) memcpy(t,s,(radius+radius+1)*sizeof(PixelPacket));        t+=radius+radius+1; ?       qsort((void *) neighbors,t-neighbors,sizeof(PixelPacket), =         (int (*)(const void *, const void *)) MedianCompare);        t-=(t-neighbors)/2;        *q=(*t);
       p++;
       q++;     } &     if (!SyncPixelCache(median_image))       break;#     if (QuantumTick(y,image->rows)) ;       ProgressMonitor(MedianFilterImageText,y,image->rows);    }    FreeMemory(neighbors);   return(median_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     M o r p h I m a g e s                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method MorphImages morphs a set of images.  Both the image pixels and size L %  are linearly interpolated to give the appearance of a meta-morphosis from %  one image to the next.  % * %  The format of the MorphImage method is: % I %      Image *MorphImages(Image *images,const unsigned int number_frames)  % + %  A description of each parameter follows:  % G %    o morphed_image: Method MorphImages returns an image sequence that J %      has linearly interpolated pixels and size between two input images. % G %    o images: The address of a structure of type Image;  returned from  %      ReadImage.  % N %    o number_frames:  This unsigned integer reflects the number of in-betweenD %      images to generate.  The more in-between frames, the smoother %      the morph.  %  %  */I Export Image *MorphImages(Image *images,const unsigned int number_frames)  { 8 #define MorphImageText  "  Morphing image sequence...  "     double
     alpha,	     beta;      Image      *image,      *morphed_image,      *morphed_images;     int      y;     MonitorHandler     handler;     register int     i,     x;     register PixelPacket     *p,      *q;      unsigned int
     scene;  #   assert(images != (Image *) NULL); %   if (images->next == (Image *) NULL)      { :       MagickWarning(OptionWarning,"Unable to morph image",#         "image sequence required");        return((Image *) NULL);      }    /*"     Clone first frame in sequence.   */F   morphed_images=CloneImage(images,images->columns,images->rows,True);'   if (morphed_images == (Image *) NULL)      { J       MagickWarning(ResourceLimitWarning,"Unable to morph image sequence",$         "Memory allocation failed");       return((Image *) NULL);      }    /*     Morph image.   */
   scene=0;F   for (image=images; image->next != (Image *) NULL; image=image->next)   { 5     handler=SetMonitorHandler((MonitorHandler) NULL); +     for (i=0; i < (int) number_frames; i++)      { 0       beta=(double) (i+1.0)/(number_frames+1.0);       alpha=1.0-beta; +       morphed_images->next=ZoomImage(image, L         (unsigned int) (alpha*image->columns+beta*image->next->columns+0.5),G         (unsigned int) (alpha*image->rows+beta*image->next->rows+0.5)); 1       if (morphed_images->next == (Image *) NULL) 	         { N           MagickWarning(ResourceLimitWarning,"Unable to morph image sequence",(             "Memory allocation failed");           break;	         } 4       morphed_images->next->previous=morphed_images;*       morphed_images=morphed_images->next;B       morphed_image=ZoomImage(image->next,morphed_images->columns,         morphed_images->rows);*       if (morphed_image == (Image *) NULL)	         { N           MagickWarning(ResourceLimitWarning,"Unable to morph image sequence",(             "Memory allocation failed");           break;	         } (       morphed_images->class=DirectClass;4       for (y=0; y < (int) morphed_images->rows; y++)       { D         p=GetPixelCache(morphed_image,0,y,morphed_image->columns,1);F         q=SetPixelCache(morphed_images,0,y,morphed_images->columns,1);G         if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))            break;9         for (x=0; x < (int) morphed_images->columns; x++) 	         { :           q->red=(Quantum) (alpha*q->red+beta*p->red+0.5);@           q->green=(Quantum) (alpha*q->green+beta*p->green+0.5);=           q->blue=(Quantum) (alpha*q->blue+beta*p->blue+0.5); F           q->opacity=(Quantum) (alpha*q->opacity+beta*p->opacity+0.5);           p++;           q++;	         } ,         if (!SyncPixelCache(morphed_images))           break;       } "       DestroyImage(morphed_image);     }      /*#       Clone last frame in sequence.      */     morphed_images->next= J       CloneImage(image->next,image->next->columns,image->next->rows,True);/     if (morphed_images->next == (Image *) NULL)        { L         MagickWarning(ResourceLimitWarning,"Unable to morph image sequence",&           "Memory allocation failed");         break;       } 2     morphed_images->next->previous=morphed_images;(     morphed_images=morphed_images->next;&     (void) SetMonitorHandler(handler);B     ProgressMonitor(MorphImageText,scene,GetNumberScenes(images));     scene++;   } 4   while (morphed_images->previous != (Image *) NULL),     morphed_images=morphed_images->previous;$   if (image->next != (Image *) NULL)     { $       DestroyImages(morphed_images);       return((Image *) NULL);      }    return(morphed_images);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     O i l P a i n t I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method OilPaintImage creates a new image that is a copy of an existing N %  one with each pixel component replaced with the color of greatest frequency %  in a circular neighborhood. % - %  The format of the OilPaintImage method is:  % C %      Image *OilPaintImage(Image *image,const unsigned int radius)  % + %  A description of each parameter follows:  % G %    o paint_image: Method OilPaintImage returns a pointer to the image L %      after it is `painted'.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % A %    o radius: An unsigned int that is the radius of the circular  %      neighborhood. %  %  */C Export Image *OilPaintImage(Image *image,const unsigned int radius)  { 6 #define OilPaintImageText  "  Oil painting image...  "     Image      *paint_image;      int 
     count,     j,     k,     y;     register int     i,     x;     register PixelPacket     *p,      *q,      *s;      unsigned int     *histogram;   "   assert(image != (Image *) NULL);F   if ((image->columns < (2*radius+1)) || (image->rows < (2*radius+1)))     { ?       MagickWarning(ResourceLimitWarning,"Unable to oil paint", %         "image smaller than radius");        return((Image *) NULL);      }    /*(     Initialize painted image attributes.   */@   paint_image=CloneImage(image,image->columns,image->rows,True);$   if (paint_image == (Image *) NULL)     { ?       MagickWarning(ResourceLimitWarning,"Unable to oil paint", $         "Memory allocation failed");       return((Image *) NULL);      } !   paint_image->class=DirectClass;    /*$     Allocate histogram and scanline.   */M   histogram=(unsigned int *) AllocateMemory((MaxRGB+1)*sizeof(unsigned int)); )   if (histogram == (unsigned int *) NULL)      { ?       MagickWarning(ResourceLimitWarning,"Unable to oil paint", $         "Memory allocation failed");        DestroyImage(paint_image);       return((Image *) NULL);      }    /*      Paint each row of the image.   */   k=0;5   for (y=radius; y < (int) (image->rows-radius); y++)    { @     p=GetPixelCache(image,0,y-radius,image->columns,2*radius+1);<     q=SetPixelCache(paint_image,0,y,paint_image->columns,1);C     if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))        break;$     p+=radius*image->columns+radius;     q+=radius;:     for (x=radius; x < (int) (image->columns-radius); x++)     {        /*&         Determine most frequent color.       */       count=0;*       for (i=0; i < (int) (MaxRGB+1); i++)         histogram[i]=0; &       for (i=0; i < (int) radius; i++)       { *         s=p-(radius-i)*image->columns-i-1;#         for (j=0; j < (2*i+1); j++) 	         {            k=Intensity(*s);           histogram[k]++; )           if ((int) histogram[k] > count) 
             {                *q=(*s);!               count=histogram[k]; 
             }            s++;	         } *         s=p+(radius-i)*image->columns-i-1;#         for (j=0; j < (2*i+1); j++) 	         {            k=Intensity(*s);           histogram[k]++; )           if ((int) histogram[k] > count) 
             {                *q=(*s);!               count=histogram[k]; 
             }            s++;	         }        }        s=p-radius; 1       for (j=0; j < (int) (radius+radius+1); j++)        {          k=Intensity(*s);         histogram[k]++; '         if ((int) histogram[k] > count)            {              *q=(*s);             count=histogram[k];            }          s++;       } 
       p++;
       q++;     } %     if (!SyncPixelCache(paint_image))        break;#     if (QuantumTick(y,image->rows)) 7       ProgressMonitor(OilPaintImageText,y,image->rows);    }    FreeMemory(histogram);   return(paint_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     P l a s m a I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method PlasmaImage initializes an image with plasma fractal values.  The N %  image must be initialized with a base color and the random number generator' %  seeded before this method is called.  % + %  The format of the PlasmaImage method is:  % H %      unsigned int PlasmaImage(Image *image,const SegmentInfo *segment,! %        int attenuate,int depth)  % + %  A description of each parameter follows:  % G %    o status: Method PlasmaImage returns True when the fractal process 1 %      is complete.  Otherwise False is returned.  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % G %    o segment:  specifies a structure of type SegmentInfo that defines H %      the boundaries of the area where the plasma fractals are applied. % ; %    o attenuate:  specifies the plasma attenuation factor.  % D %    o depth: this integer values define the plasma recursion depth. %  %  */  A static Quantum PlasmaPixel(const double pixel,const double noise)  {    double
     value;  G   value=pixel+(noise/2.0)-((int) noise ? (rand() % (int) noise) : 0.0);    if (value < 0.0)     return(0);   if (value > MaxRGB)      return(MaxRGB);     return((Quantum) (value+0.5)); }   H Export unsigned int PlasmaImage(Image *image,const SegmentInfo *segment,   int attenuate,int depth) {    double     plasma, 
     x_mid,
     y_mid;  
   PixelPacket      pixel_1,     pixel_2;     register PixelPacket     *q;   "   assert(image != (Image *) NULL);   if (depth != 0)      {        SegmentInfo          local_info;          /*3         Divide the area into quadrants and recurse.        */       depth--;       attenuate++;(       x_mid=(segment->x1+segment->x2)/2;(       y_mid=(segment->y1+segment->y2)/2;       local_info=(*segment);       local_info.x2=x_mid;       local_info.y2=y_mid;<       (void) PlasmaImage(image,&local_info,attenuate,depth);       local_info=(*segment);       local_info.y1=y_mid;       local_info.x2=x_mid;<       (void) PlasmaImage(image,&local_info,attenuate,depth);       local_info=(*segment);       local_info.x1=x_mid;       local_info.y2=y_mid;<       (void) PlasmaImage(image,&local_info,attenuate,depth);       local_info=(*segment);       local_info.x1=x_mid;       local_info.y1=y_mid;=       return(PlasmaImage(image,&local_info,attenuate,depth));      } $   x_mid=(segment->x1+segment->x2)/2;$   y_mid=(segment->y1+segment->y2)/2;9   if ((segment->x1 == x_mid) && (segment->x2 == x_mid) && 7       (segment->y1 == y_mid) && (segment->y2 == y_mid))      return(False);   /*$     Average pixels and apply plasma.   */-   plasma=(MaxRGB+1)/(2.0*(double) attenuate); 7   if ((segment->x1 != x_mid) || (segment->x2 != x_mid))      {        /*         Left pixel.        */G       if (GetPixelCache(image,(int) segment->x1,(int) segment->y1,1,1)) !         pixel_1=(*image->pixels); G       if (GetPixelCache(image,(int) segment->x1,(int) segment->y2,1,1)) !         pixel_2=(*image->pixels); A       if (SetPixelCache(image,(int) segment->x1,(int) y_mid,1,1)) 	         {            q=image->pixels;G           q->red=PlasmaPixel((int) (pixel_1.red+pixel_2.red)/2,plasma); M           q->green=PlasmaPixel((int) (pixel_1.green+pixel_2.green)/2,plasma); J           q->blue=PlasmaPixel((int) (pixel_1.blue+pixel_2.blue)/2,plasma);'           (void) SyncPixelCache(image); 	         } %       if (segment->x1 != segment->x2) 	         {            /*             Right pixel.           */K           if (GetPixelCache(image,(int) segment->x2,(int) segment->y1,1,1)) %             pixel_1=(*image->pixels); K           if (GetPixelCache(image,(int) segment->x2,(int) segment->y2,1,1)) %             pixel_2=(*image->pixels); E           if (SetPixelCache(image,(int) segment->x2,(int) y_mid,1,1)) 
             {                q=image->pixels;K               q->red=PlasmaPixel((int) (pixel_1.red+pixel_2.red)/2,plasma);                q->green= J                 PlasmaPixel((int) (pixel_1.green+pixel_2.green)/2,plasma);N               q->blue=PlasmaPixel((int) (pixel_1.blue+pixel_2.blue)/2,plasma);+               (void) SyncPixelCache(image); 
             } 	         }      } 7   if ((segment->y1 != y_mid) || (segment->y2 != y_mid))      { ;       if ((segment->x1 != x_mid) || (segment->y2 != y_mid)) 	         {            /*             Bottom pixel.            */K           if (GetPixelCache(image,(int) segment->x1,(int) segment->y2,1,1)) %             pixel_1=(*image->pixels); K           if (GetPixelCache(image,(int) segment->x2,(int) segment->y2,1,1)) %             pixel_2=(*image->pixels); E           if (SetPixelCache(image,(int) x_mid,(int) segment->y2,1,1)) 
             {                q=image->pixels;K               q->red=PlasmaPixel((int) (pixel_1.red+pixel_2.red)/2,plasma);                q->green= J                 PlasmaPixel((int) (pixel_1.green+pixel_2.green)/2,plasma);N               q->blue=PlasmaPixel((int) (pixel_1.blue+pixel_2.blue)/2,plasma);+               (void) SyncPixelCache(image); 
             } 	         } %       if (segment->y1 != segment->y2) 	         {            /*             Top pixel.           */K           if (GetPixelCache(image,(int) segment->x1,(int) segment->y1,1,1)) %             pixel_1=(*image->pixels); K           if (GetPixelCache(image,(int) segment->x2,(int) segment->y1,1,1)) %             pixel_2=(*image->pixels); E           if (SetPixelCache(image,(int) x_mid,(int) segment->y1,1,1)) 
             {                q=image->pixels;K               q->red=PlasmaPixel((int) (pixel_1.red+pixel_2.red)/2,plasma);                q->green= J                 PlasmaPixel((int) (pixel_1.green+pixel_2.green)/2,plasma);N               q->blue=PlasmaPixel((int) (pixel_1.blue+pixel_2.blue)/2,plasma);+               (void) SyncPixelCache(image); 
             } 	         }      } %   if ((segment->x1 != segment->x2) || #       (segment->y1 != segment->y2))      {        /*         Middle pixel.        */G       if (GetPixelCache(image,(int) segment->x1,(int) segment->y1,1,1)) !         pixel_1=(*image->pixels); G       if (GetPixelCache(image,(int) segment->x2,(int) segment->y2,1,1)) !         pixel_2=(*image->pixels); ;       if (SetPixelCache(image,(int) x_mid,(int) y_mid,1,1)) 	         {            q=image->pixels;G           q->red=PlasmaPixel((int) (pixel_1.red+pixel_2.red)/2,plasma); M           q->green=PlasmaPixel((int) (pixel_1.green+pixel_2.green)/2,plasma); J           q->blue=PlasmaPixel((int) (pixel_1.blue+pixel_2.blue)/2,plasma);	         } #       (void) SyncPixelCache(image);      } M   if (((segment->x2-segment->x1) < 3.0) && ((segment->y2-segment->y1) < 3.0))      return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     R e d u c e N o i s e I m a g e                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method ReduceNoiseImage creates a new image that is a copy of an existingH %  one with the noise minified with a noise peak elimination filter.  ItK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % K %  The principal function of noise peak elimination filter is to smooth the F %  objects within an image without losing edge information and withoutJ %  creating undesired structures.  The central idea of the algorithm is toI %  replace a pixel with its next neighbor in value within a 3 x 3 window, I %  if this pixel has been found to be noise.  A pixel is defined as noise E %  if and only if this pixel is a maximum or minimum within the 3 x 3 
 %  window. % 0 %  The format of the ReduceNoiseImage method is: % , %      Image *ReduceNoiseImage(Image *image) % + %  A description of each parameter follows:  % J %    o noisy_image: Method ReduceNoiseImage returns a pointer to the imageK %      after the noise is minified.  A null image is returned if there is a  %      memory shortage.  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */  : static int ReduceNoiseCompare(const void *x,const void *y) { 
   PixelPacket 
     *color_1, 
     *color_2;      color_1=(PixelPacket *) x;   color_2=(PixelPacket *) y;>   return((int) Intensity(*color_1)-(int) Intensity(*color_2)); }   , Export Image *ReduceNoiseImage(Image *image) { ? #define ReduceNoiseImageText  "  Reducing the image noise...  "      Image      *noisy_image;      int      y;     register int     i,     x;     register PixelPacket     *p,      *q,      *s;   
   PixelPacket 
     pixel,     window[9];  "   assert(image != (Image *) NULL);0   if ((image->columns < 3) || (image->rows < 3))     return((Image *) NULL);    /*&     Initialize noisy image attributes.   */@   noisy_image=CloneImage(image,image->columns,image->rows,True);$   if (noisy_image == (Image *) NULL)     { B       MagickWarning(ResourceLimitWarning,"Unable to reduce noise",$         "Memory allocation failed");       return((Image *) NULL);      } !   noisy_image->class=DirectClass;    /*     Reduce noise in image.   */'   for (y=0; y < (int) image->rows; y++)    {      /*       Read another scan line.      */L     p=GetPixelCache(image,0,Min(Max(y-1,0),image->rows-3),image->columns,3);<     q=SetPixelCache(noisy_image,0,y,noisy_image->columns,1);C     if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))        break;     /*       Reduce noise in this row.      */     *q++=(*(p+image->columns)); 0     for (x=1; x < (int) (image->columns-1); x++)     {        /*3         Sort window pixels by increasing intensity.        */
       s=p;       window[0]=(*s++);        window[1]=(*s++);        window[2]=(*s++);        s=p+image->columns;        window[3]=(*s++);        window[4]=(*s++);        window[5]=(*s++);        s=p+2*image->columns;        window[6]=(*s++);        window[7]=(*s++);        window[8]=(*s++);        pixel=window[4];2       qsort((void *) window,9,sizeof(PixelPacket),B         (int (*)(const void *, const void *)) ReduceNoiseCompare);3       if (Intensity(pixel) == Intensity(window[0])) 	         {            /*H             Pixel is minimum noise; replace with next neighbor in value.           */           for (i=1; i < 8; i++) =             if (Intensity(window[i]) != Intensity(window[0]))                break;           pixel=window[i];	         } 
       else5         if (Intensity(pixel) == Intensity(window[8]))            {              /*J               Pixel is maximum noise; replace with next neighbor in value.             */!             for (i=7; i > 0; i--) ?               if (Intensity(window[i]) != Intensity(window[8]))                  break;             pixel=window[i];           } 
       p++;
       q++;     }      p++;     *q++=(*p);     if (!SyncPixelCache(image))        break;#     if (QuantumTick(y,image->rows)) <       ProgressMonitor(ReduceNoiseImageText,y,image->rows-1);   }    return(noisy_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     S h a d e I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method ShadeImage creates a new image that is a copy of an existingF %  one with the image pixels shaded using a distance light source.  ItK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % * %  The format of the ShadeImage method is: % G %      Image *ShadeImage(Image *image,const unsigned int color_shading, ) %        double azimuth,double elevation)  % + %  A description of each parameter follows:  % D %    o shade_image: Method ShadeImage returns a pointer to the imageI %      after it is shaded.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % M %    o color_shading: A value other than zero shades the red, green, and blue  %      components of the image.  % J %    o azimuth, elevation:  A double value that indicates the light source %      direction.  %  %  */G Export Image *ShadeImage(Image *image,const unsigned int color_shading, "   double azimuth,double elevation) { . #define ShadeImageText  "  Shading image...  "     double
     distance,      normal_distance,
     shade;     Image      *shade_image;   
   IndexPacket 
     index;     int      y;     PointInfo 
     light,     normal;      register int     i,     x;     register PixelPacket     *p,      *s0,     *s1,     *s2,     *q;      /*'     Initialize shaded image attributes.    */"   assert(image != (Image *) NULL);@   shade_image=CloneImage(image,image->columns,image->rows,True);$   if (shade_image == (Image *) NULL)     { A       MagickWarning(ResourceLimitWarning,"Unable to shade image", $         "Memory allocation failed");       return((Image *) NULL);      } !   shade_image->class=DirectClass;    if (!color_shading)      {        /*)         Initialize shaded image colormap.        */%       shade_image->class=PseudoClass; #       shade_image->colors=MaxRGB+1; 8       if (shade_image->colormap != (PixelPacket *) NULL)*         FreeMemory(shade_image->colormap);+       shade_image->colormap=(PixelPacket *) @         AllocateMemory(shade_image->colors*sizeof(PixelPacket));8       if (shade_image->colormap == (PixelPacket *) NULL)	         { E           MagickWarning(ResourceLimitWarning,"Unable to shade image", (             "Memory allocation failed");$           DestroyImage(shade_image);!           return((Image *) NULL); 	         } 3       for (i=0; i < (int) shade_image->colors; i++)        { '         shade_image->colormap[i].red=i; )         shade_image->colormap[i].green=i; (         shade_image->colormap[i].blue=i;       }      }    /*     Compute the light vector.    */$   azimuth=DegreesToRadians(azimuth);(   elevation=DegreesToRadians(elevation);-   light.x=MaxRGB*cos(azimuth)*cos(elevation); -   light.y=MaxRGB*sin(azimuth)*cos(elevation);     light.z=MaxRGB*sin(elevation);8   normal.z=2*MaxRGB;  /* constant Z of surface normal */   /*     Shade image.   */'   for (y=0; y < (int) image->rows; y++)    { L     p=GetPixelCache(image,0,Min(Max(y-1,0),image->rows-3),image->columns,3);<     q=SetPixelCache(shade_image,0,y,shade_image->columns,1);C     if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))        break;     /*       Shade this row of pixels.      */     *q++=(*(p+image->columns));      p++;	     s0=p;      s1=p+image->columns;     s2=p+2*image->columns;0     for (x=1; x < (int) (image->columns-1); x++)     {        /*9         Determine the surface normal and compute shading.        */H       normal.x=Intensity(*(s0-1))+Intensity(*(s1-1))+Intensity(*(s2-1))-A         Intensity(*(s0+1))-Intensity(*(s1+1))-Intensity(*(s2+1)); D       normal.y=Intensity(*(s2-1))+Intensity(*s2)+Intensity(*(s2+1))-=         Intensity(*(s0-1))-Intensity(*s0)-Intensity(*(s0+1)); -       if ((normal.x == 0) && (normal.y == 0))          shade=light.z;
       else	         {            shade=0.0;F           distance=normal.x*light.x+normal.y*light.y+normal.z*light.z;           if (distance > 0.0) 
             {                normal_distance=F                 normal.x*normal.x+normal.y*normal.y+normal.z*normal.z;=               if (AbsoluteValue(normal_distance) > 0.0000001) 5                 shade=distance/sqrt(normal_distance); 
             } 	         } ,       if (shade_image->class == DirectClass)	         { ,           q->red=(shade*s1->red)/(MaxRGB+1);0           q->green=(shade*s1->green)/(MaxRGB+1);.           q->blue=(shade*s1->blue)/(MaxRGB+1);!           q->opacity=s1->opacity; 	         } 
       else	         {            index=shade;(           shade_image->indexes[x]=index;2           q->red=shade_image->colormap[index].red;6           q->green=shade_image->colormap[index].green;4           q->blue=shade_image->colormap[index].blue;	         }        s0++;        s1++;        s2++; 
       q++;     }      *q++=(*s1); %     if (!SyncPixelCache(shade_image))        break;#     if (QuantumTick(y,image->rows)) 4       ProgressMonitor(ShadeImageText,y,image->rows);   }    return(shade_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     S h a r p e n I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method SharpenImage creates a new image that is a copy of an existingL %  one with the pixels sharpened.  It allocates the memory necessary for the> %  new Image structure and returns a pointer to the new image. % K %  SharpenImage convolves the pixel neighborhood with this sharpening mask:  % 
 %    -1 -2 -1 
 %    -2  W -2 
 %    -1 -2 -1  % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % , %  The format of the SharpenImage method is: % < %      Image *SharpenImage(Image *image,const double factor) % + %  A description of each parameter follows:  % H %    o sharpen_image: Method SharpenImage returns a pointer to the imageL %      after it is sharpened.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o factor:  An double value reflecting the percent weight to give to the( %      center pixel of the neighborhood. %  %  */< Export Image *SharpenImage(Image *image,const double factor) {  #define Sharpen(weight) \    total_red+=(weight)*s->red; \ #   total_green+=(weight)*s->green; \ !   total_blue+=(weight)*s->blue; \ '   total_opacity+=(weight)*s->opacity; \    s++;3 #define SharpenImageText  "  Sharpening image...  "      double     total_blue,      total_green,     total_opacity,     total_red,     weight;      Image      *sharpen_image;      int      y;     register int     x;     register PixelPacket     *p,      *q,      *s;      unsigned int     quantum;  "   assert(image != (Image *) NULL);0   if ((image->columns < 3) || (image->rows < 3))     return((Image *) NULL);    /**     Initialize sharpened image attributes.   */B   sharpen_image=CloneImage(image,image->columns,image->rows,True);&   if (sharpen_image == (Image *) NULL)     { C       MagickWarning(ResourceLimitWarning,"Unable to sharpen image", $         "Memory allocation failed");       return((Image *) NULL);      } #   sharpen_image->class=DirectClass;    /*     Sharpen image.   */   weight=((100.0-factor)/2+13); *   quantum=(unsigned int) Max(weight-12,1);'   for (y=0; y < (int) image->rows; y++)    { L     p=GetPixelCache(image,0,Min(Max(y-1,0),image->rows-3),image->columns,3);@     q=SetPixelCache(sharpen_image,0,y,sharpen_image->columns,1);C     if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))        break;     /*!       Sharpen this row of pixels.      */     *q++=(*(p+image->columns)); 0     for (x=1; x < (int) (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0.0;       total_green=0.0;       total_blue=0.0;        total_opacity=0.0;
       s=p;,       Sharpen(-1); Sharpen(-2); Sharpen(-1);       s=p+image->columns; 0       Sharpen(-2); Sharpen(weight); Sharpen(-2);       s=p+2*image->columns; ,       Sharpen(-1); Sharpen(-2); Sharpen(-1);       if (total_red < 0)         q->red=0; 
       else/         if (total_red > (int) (MaxRGB*quantum))            q->red=MaxRGB;         else@           q->red=(Quantum) ((total_red+(quantum >> 1))/quantum);       if (total_green < 0)         q->green=0; 
       else1         if (total_green > (int) (MaxRGB*quantum))            q->green=MaxRGB;         elseD           q->green=(Quantum) ((total_green+(quantum >> 1))/quantum);       if (total_blue < 0)          q->blue=0;
       else0         if (total_blue > (int) (MaxRGB*quantum))           q->blue=MaxRGB;          elseB           q->blue=(Quantum) ((total_blue+(quantum >> 1))/quantum);       if (total_opacity < 0)         q->opacity=0; 
       else3         if (total_opacity > (int) (MaxRGB*quantum))            q->opacity=MaxRGB;         elseH           q->opacity=(Quantum) ((total_opacity+(quantum >> 1))/quantum);
       p++;
       q++;     }      p++;     *q++=(*p);'     if (!SyncPixelCache(sharpen_image))        break;%     if (QuantumTick(y,image->rows-1)) 8       ProgressMonitor(SharpenImageText,y,image->rows-1);   }    return(sharpen_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     S o l a r i z e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method SolarizeImage produces a 'solarization' effect seen when exposing ? %  a photographic film to light during the development process.  % - %  The format of the SolarizeImage method is:  % ; %      void SolarizeImage(Image *image,const double factor)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o factor:  An double value that defines the extent of the solarization. %  %  */; Export void SolarizeImage(Image *image,const double factor)  { ? #define SolarizeImageText  "  Solarizing the image colors...  "      int      y;     register int     i,     x;     register PixelPacket     *q;      unsigned int     threshold;  "   assert(image != (Image *) NULL);5   threshold=(unsigned int) (factor*(MaxRGB+1)/100.0);    switch (image->class)    {      case DirectClass:      default:     {        /*%         Solarize DirectClass packets.        */+       for (y=0; y < (int) image->rows; y++)        { 4         q=GetPixelCache(image,0,y,image->columns,1);&         if (q == (PixelPacket *) NULL)           break;0         for (x=0; x < (int) image->columns; x++)	         { =           q->red=q->red > threshold ? MaxRGB-q->red : q->red; E           q->green=q->green > threshold ? MaxRGB-q->green : q->green; A           q->blue=q->blue > threshold ? MaxRGB-q->blue : q->blue;            q++;	         } #         if (!SyncPixelCache(image))            break;'         if (QuantumTick(y,image->rows)) ;           ProgressMonitor(SolarizeImageText,y,image->rows);        }        break;     }      case PseudoClass:      {        /*%         Solarize PseudoClass packets.        */-       for (i=0; i < (int) image->colors; i++)        { C         image->colormap[i].red=image->colormap[i].red > threshold ? A           MaxRGB-image->colormap[i].red : image->colormap[i].red; G         image->colormap[i].green=image->colormap[i].green > threshold ? E           MaxRGB-image->colormap[i].green : image->colormap[i].green; E         image->colormap[i].blue=image->colormap[i].blue > threshold ? C           MaxRGB-image->colormap[i].blue : image->colormap[i].blue;        }        SyncImage(image);        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     S p r e a d I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method SpreadImage creates a new image that is a copy of an existing I %  one with the image pixels randomly displaced.  It allocates the memory I %  necessary for the new Image structure and returns a pointer to the new 	 %  image.  % + %  The format of the SpreadImage method is:  % A %      Image *SpreadImage(Image *image,const unsigned int amount)  % + %  A description of each parameter follows:  % F %    o spread_image: Method SpreadImage returns a pointer to the imageI %      after it is spread.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % J %    o amount:  An unsigned value constraining the "vicinity" for choosing %      a random pixel to swap. %  %  */A Export Image *SpreadImage(Image *image,const unsigned int amount)  { 1 #define SpreadImageText  "  Spreading image...  "      Image      *spread_image;     int      quantum,     y;     long     x_distance,      y_distance;      register int     x;     register PixelPacket     *q;   "   assert(image != (Image *) NULL);0   if ((image->columns < 3) || (image->rows < 3))     return((Image *) NULL);    /*'     Initialize spread image attributes.    */A   spread_image=CloneImage(image,image->columns,image->rows,True); %   if (spread_image == (Image *) NULL)      { C       MagickWarning(ResourceLimitWarning,"Unable to enhance image", $         "Memory allocation failed");       return((Image *) NULL);      } "   spread_image->class=DirectClass;   /*     Convolve each row.   */   quantum=(amount+1) >> 1;!   for (y=0; y < image->rows; y++)    { >     q=SetPixelCache(spread_image,0,y,spread_image->columns,1);"     if (q == (PixelPacket *) NULL)       break;&     for (x=0; x < image->columns; x++)     { /       x_distance=(rand() & (amount+1))-quantum; /       y_distance=(rand() & (amount+1))-quantum; B       if (!GetPixelCache(image,Min(x+x_distance,image->columns-1),-         Min(y+y_distance,image->rows-1),1,1))          break;       *q++=(*image->pixels);     } &     if (!SyncPixelCache(spread_image))       break;#     if (QuantumTick(y,image->rows)) 5       ProgressMonitor(SpreadImageText,y,image->rows);    }    return(spread_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S t e g a n o I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % B %  Method SteganoImage hides a digital watermark within the image. % , %  The format of the SteganoImage method is: % 9 %      Image *SteganoImage(Image *image,Image *watermark)  % + %  A description of each parameter follows:  % B %    o stegano_image: Method SteganoImage returns a pointer to theG %      steganographic image with the watermark hidden.  A null image is . %      returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.  % ; %    o watermark: The address of a structure of type Image.  %  %  */9 Export Image *SteganoImage(Image *image,Image *watermark)  {  #define EmbedBit(byte) \ { \ P   if (!GetPixelCache(watermark,j%watermark->columns,j/watermark->columns,1,1)) \
     break;  \    (byte)&=(~0x01); \<   (byte)|=(Intensity(*watermark->pixels) >> shift) & 0x01; \   j++; \2   if (j == (watermark->columns*watermark->rows)) \     { \        j=0; \       shift--; \       if (shift < 0) \         break; \     } \  } / #define SteganoImageText  "  Hiding image...  "      Image      *stegano_image;      int      j,
     shift,     y;     register int     i,     x;     register PixelPacket     *p;      /*/     Initialize steganographic image attributes.    */"   assert(image != (Image *) NULL);&   assert(watermark != (Image *) NULL);B   stegano_image=CloneImage(image,image->columns,image->rows,True);&   if (stegano_image == (Image *) NULL)     { )       MagickWarning(ResourceLimitWarning, L         "Unable to create steganographic image","Memory allocation failed");       return((Image *) NULL);      } *   if (stegano_image->class == PseudoClass)     { 4       if (stegano_image->colors > ((MaxRGB+1) >> 1)))         stegano_image->class=DirectClass; 
       else	         {            /*?             Shift colormap to make room for information hiding.            */$           stegano_image->colors<<=1;K           stegano_image->colormap=(PixelPacket *) ReallocateMemory((char *) O             stegano_image->colormap,stegano_image->colors*sizeof(PixelPacket)); >           if (stegano_image->colormap == (PixelPacket *) NULL)
             { 1               MagickWarning(ResourceLimitWarning, 8                 "Unable to create steganographic image",,                 "Memory allocation failed");*               DestroyImage(stegano_image);%               return((Image *) NULL); 
             } 6           for (i=stegano_image->colors-1; i >= 0; i--)G             stegano_image->colormap[i]=stegano_image->colormap[i >> 1]; 7           for (y=0; y < (int) stegano_image->rows; y++)            { K             if (!GetPixelCache(stegano_image,0,y,stegano_image->columns,1))                break;<             for (x=0; x < (int) stegano_image->columns; x++),               stegano_image->indexes[x]<<=1;/             if (!SyncPixelCache(stegano_image))                break;           } 	         }      }    /*.     Hide watermark in low-order bits of image.   */   i=image->offset;   j=0;   shift=QuantumDepth-1; '   for (y=0; y < (int) image->rows; y++)    { ,     for (x=0; x < (int) image->columns; x++)     { <       if (i == (stegano_image->columns*stegano_image->rows))         i=0;?       p=GetPixelCache(stegano_image,i % stegano_image->columns, &         i/stegano_image->columns,1,1);$       if (p == (PixelPacket *) NULL)         break;.       if (stegano_image->class == PseudoClass))         EmbedBit(*stegano_image->indexes) 
       else	         { /           EmbedBit(stegano_image->pixels->red); 1           EmbedBit(stegano_image->pixels->green); 0           EmbedBit(stegano_image->pixels->blue);	         } )       if (!SyncPixelCache(stegano_image))          break;
       i++;     }      if (shift < 0)       break;#     if (QuantumTick(y,image->rows)) 6       ProgressMonitor(SteganoImageText,y,image->rows);   } *   if (stegano_image->class == PseudoClass)     SyncImage(stegano_image);    return(stegano_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S t e r e o I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method StereoImage combines two images and produces a single image thatI %  is the composite of a left and right image of a stereo pair.  The left I %  image is converted to gray scale and written to the red channel of the O %  stereo image.  The right image is converted to gray scale and written to the L %  blue channel of the stereo image.  View the composite image with red-blue% %  glasses to create a stereo effect.  % + %  The format of the StereoImage method is:  % ? %      Image *StereoImage(Image *left_image,Image *right_image)  % + %  A description of each parameter follows:  % G %    o stereo_image: Method StereoImage returns a pointer to the stereo F %      image.  A null image is returned if there is a memory shortage. % < %    o left_image: The address of a structure of type Image. % = %    o right_image: The address of a structure of type Image.  %  %  */? Export Image *StereoImage(Image *left_image,Image *right_image)  { . #define StereoImageText  "  Stereo image...  "     Image      *stereo_image;     int      y;     register int     x;     register PixelPacket     *p,      *q,      *r;   '   assert(left_image != (Image *) NULL); (   assert(right_image != (Image *) NULL);6   if ((left_image->columns != right_image->columns) ||.       (left_image->rows != right_image->rows))     { I       MagickWarning(ResourceLimitWarning,"Unable to create stereo image", -         "left and right image sizes differ");        return((Image *) NULL);      }    /*'     Initialize stereo image attributes.    */   stereo_image= E     CloneImage(left_image,left_image->columns,left_image->rows,True); %   if (stereo_image == (Image *) NULL)      { I       MagickWarning(ResourceLimitWarning,"Unable to create stereo image", $         "Memory allocation failed");       return((Image *) NULL);      } "   stereo_image->class=DirectClass;   /*C     Copy left image to red channel and right image to blue channel.    */.   for (y=0; y < (int) stereo_image->rows; y++)   { :     p=GetPixelCache(left_image,0,y,left_image->columns,1);<     q=GetPixelCache(right_image,0,y,right_image->columns,1);>     r=SetPixelCache(stereo_image,0,y,stereo_image->columns,1);E     if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL) || $         (r == (PixelPacket *) NULL))       break;3     for (x=0; x < (int) stereo_image->columns; x++)      {        r->red=Intensity(*p);        r->green=0;        r->blue=Intensity(*q);       r->opacity=0; 
       p++;
       q++;
       r++;     } &     if (!SyncPixelCache(stereo_image))       break;*     if (QuantumTick(y,stereo_image->rows))<       ProgressMonitor(StereoImageText,y,stereo_image->rows);   }    return(stereo_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     S w i r l I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method SwirlImage creates a new image that is a copy of an existingL %  one with the image pixels "swirl" at a specified angle.  It allocates theL %  memory necessary for the new Image structure and returns a pointer to the
 %  new image.  % * %  The format of the SwirlImage method is: % 5 %      Image *SwirlImage(Image *image,double degrees)  % + %  A description of each parameter follows:  % D %    o swirl_image: Method SwirlImage returns a pointer to the imageH %      after it is swirl.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o degrees:  An double value that defines the tightness of the swirling. %  %  */5 Export Image *SwirlImage(Image *image,double degrees)  { / #define SwirlImageText  "  Swirling image...  "      double     cosine, 
     distance,      factor,      radius, 	     sine, 
     x_center,      x_distance,      x_scale,
     y_center,      y_distance,      y_scale;     int      y;     Image      *swirl_image;      register int     x;     register PixelPacket     *p,      *q;      /*&     Initialize swirl image attributes.   */"   assert(image != (Image *) NULL);   if (!image->matte)     MatteImage(image,Opaque); @   swirl_image=CloneImage(image,image->columns,image->rows,True);$   if (swirl_image == (Image *) NULL)     { A       MagickWarning(ResourceLimitWarning,"Unable to swirl image", $         "Memory allocation failed");       return((Image *) NULL);      }    /*     Compute scaling factor.    */   x_center=image->columns/2.0;   y_center=image->rows/2.0;     radius=Max(x_center,y_center);   x_scale=1.0;   y_scale=1.0;#   if (image->columns > image->rows) 0     y_scale=(double) image->columns/image->rows;   else%     if (image->columns < image->rows) 2       x_scale=(double) image->rows/image->columns;$   degrees=DegreesToRadians(degrees);   /*     Swirl each row.    */!   for (y=0; y < image->rows; y++)    { 0     p=GetPixelCache(image,0,y,image->columns,1);<     q=SetPixelCache(swirl_image,0,y,swirl_image->columns,1);C     if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))        break;$     y_distance=y_scale*(y-y_center);&     for (x=0; x < image->columns; x++)     {        /*4         Determine if the pixel is within an ellipse.       */       *q=(*p);&       x_distance=x_scale*(x-x_center);;       distance=x_distance*x_distance+y_distance*y_distance; %       if (distance < (radius*radius)) 	         {            /*             Swirl the pixel.           */+           factor=1.0-sqrt(distance)/radius; *           sine=sin(degrees*factor*factor);,           cosine=cos(degrees*factor*factor);$           *q=InterpolateColor(image,A             (cosine*x_distance-sine*y_distance)/x_scale+x_center, B             (sine*x_distance+cosine*y_distance)/y_scale+y_center);	         } 
       p++;
       q++;     } %     if (!SyncPixelCache(swirl_image))        break;#     if (QuantumTick(y,image->rows)) 4       ProgressMonitor(SwirlImageText,y,image->rows);   }    return(swirl_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     T h r e s h o l d I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 8 %  Method ThresholdImage thresholds the reference image. % . %  The format of the ThresholdImage method is: % ? %      void ThresholdImage(Image *image,const double threshold)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % : %    o threshold: A double indicating the threshold value. %  %  */? Export void ThresholdImage(Image *image,const double threshold)  { 8 #define ThresholdImageText  "  Threshold the image...  "  
   IndexPacket 
     index;     int      y;  
   PixelPacket      *colormap;     register int     x;     register PixelPacket     *q;      /*     Threshold image.   */"   assert(image != (Image *) NULL);A   colormap=(PixelPacket *) AllocateMemory(2*sizeof(PixelPacket)); '   if (colormap == (PixelPacket *) NULL)      { D       MagickWarning(ResourceLimitWarning,"Unable to allocate image",$         "Memory allocation failed");
       return;      } .   if (image->colormap != (PixelPacket *) NULL)      FreeMemory(image->colormap);   image->class=PseudoClass;    image->colors=2;   image->colormap=colormap;    image->colormap[0].red=0;    image->colormap[0].green=0;    image->colormap[0].blue=0;    image->colormap[1].red=MaxRGB;"   image->colormap[1].green=MaxRGB;!   image->colormap[1].blue=MaxRGB; '   for (y=0; y < (int) image->rows; y++)    { 0     q=GetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     { .       index=Intensity(*q) < threshold ? 0 : 1;       image->indexes[x]=index;"       *q++=image->colormap[index];     }      if (!SyncPixelCache(image))        break;#     if (QuantumTick(y,image->rows)) 8       ProgressMonitor(ThresholdImageText,y,image->rows);   }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     W a v e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method WaveImage creates a new image that is a copy of an existing I %  one with the image pixels altered along a sine wave.  It allocates the H %  memory necessary for the new Image structure and returns a pointer to %  the new image.  % ) %  The format of the WaveImage method is:  % < %      Image *WaveImage(Image *image,const double amplitude,! %        const double wavelength)  % + %  A description of each parameter follows:  % C %    o shade_image: Method WaveImage returns a pointer to the image I %      after it is shaded.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % I %    o amplitude, frequency:  A double value that indicates the amplitude ' %      and wavelength of the sine wave.  %  %  */< Export Image *WaveImage(Image *image,const double amplitude,   const double wavelength) { , #define WaveImageText  "  Waving image...  "     double     *sine_map;     Image      *wave_image;     int      y;     register int     x;     register PixelPacket     *q;      /*&     Initialize waved image attributes.   */"   assert(image != (Image *) NULL);   if (!image->matte)     MatteImage(image,Opaque); 9   wave_image=CloneImage(image,image->columns,image->rows+ -     (int) (2*AbsoluteValue(amplitude)),True); #   if (wave_image == (Image *) NULL)      { @       MagickWarning(ResourceLimitWarning,"Unable to wave image",$         "Memory allocation failed");       return((Image *) NULL);      }    /*     Allocate sine map.   */I   sine_map=(double *) AllocateMemory(wave_image->columns*sizeof(double)); "   if (sine_map == (double *) NULL)     { @       MagickWarning(ResourceLimitWarning,"Unable to wave image",$         "Memory allocation failed");       DestroyImage(wave_image);        return((Image *) NULL);      } /   for (x=0; x < (int) wave_image->columns; x++) N     sine_map[x]=AbsoluteValue(amplitude)+amplitude*sin((2*M_PI*x)/wavelength);   /*     Wave image.    */,   for (y=0; y < (int) wave_image->rows; y++)   { :     q=SetPixelCache(wave_image,0,y,wave_image->columns,1);"     if (q == (PixelPacket *) NULL)       break;1     for (x=0; x < (int) wave_image->columns; x++)      { 9       *q=InterpolateColor(image,x,(int) (y-sine_map[x])); 
       q++;     } $     if (!SyncPixelCache(wave_image))       break;(     if (QuantumTick(y,wave_image->rows))8       ProgressMonitor(WaveImageText,y,wave_image->rows);   }    FreeMemory(sine_map);    return(wave_image);  } 