 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                      EEEEE  RRRR   RRRR   OOO   RRRR                        % O %                      E      R   R  R   R O   O  R   R                       % O %                      EEE    RRRR   RRRR  O   O  RRRR                        % O %                      E      R R    R R   O   O  R R                         % O %                      EEEEE  R  R   R  R   OOO   R  R                        % O %                                                                             % O %                                                                             % O %                         ImageMagick Error Methods                           % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1993                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*   Forward declarations.  *// #if defined(__cplusplus) || defined(c_plusplus)  extern "C" { #endif   static void D   DefaultErrorHandler(const unsigned int,const char *,const char *),F   DefaultWarningHandler(const unsigned int,const char *,const char *);  / #if defined(__cplusplus) || defined(c_plusplus)  }  #endif   /*   Global declarations. */ static ErrorHandler &   error_handler = DefaultErrorHandler,*   warning_handler = DefaultWarningHandler;   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   D e f a u l t E r r o r H a n d l e r                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method DefaultErrorHandler displays an error message and then terminates  %  the program.  % 3 %  The format of the DefaultErrorHandler method is:  % E %      void MagickError(const unsigned int error,const char *message,  %        const char *qualifier)  % + %  A description of each parameter follows:  % 3 %    o error: Specifies the numeric error category.  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */M static void DefaultErrorHandler(const unsigned int error,const char *message,    const char *qualifier) {    DestroyDelegateInfo();   if (message == (char *) NULL)      Exit(error % 100);H   (void) fprintf(stderr,"%.1024s: %.1024s",SetClientName((char *) NULL),
     message); !   if (qualifier != (char *) NULL) 2     (void) fprintf(stderr," (%.1024s)",qualifier);   if (errno)8     (void) fprintf(stderr," [%.1024s]",strerror(errno));   (void) fprintf(stderr,".\n");    Exit(error % 100); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   D e f a u l t W a r n i n g H a n d l e r                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ; %  Method DefaultWarningHandler displays a warning message.  % 5 %  The format of the DefaultWarningHandler method is:  % 7 +      DefaultWarningHandler(warning,message,qualifier)  % + %  A description of each parameter follows:  % 7 %    o warning: Specifies the numeric warning category.  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */= static void DefaultWarningHandler(const unsigned int warning, ,   const char *message,const char *qualifier) {    if (message == (char *) NULL)      return; H   (void) fprintf(stderr,"%.1024s: %.1024s",SetClientName((char *) NULL),
     message); !   if (qualifier != (char *) NULL) 2     (void) fprintf(stderr," (%.1024s)",qualifier);   (void) fprintf(stderr,".\n");  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   M a g i c k E r r o r                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method MagickError calls the error handler methods with an error message. % + %  The format of the MagickError method is:  % + %      MagickError(error,message,qualifier)  % + %  A description of each parameter follows:  % 3 %    o error: Specifies the numeric error category.  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */E Export void MagickError(const unsigned int error,const char *message,    const char *qualifier) { +   if (error_handler != (ErrorHandler) NULL) .     (*error_handler)(error,message,qualifier);
   errno=0; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   M a g i c k W a r n i n g                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method MagickWarning calls the warning handler methods with a warning %  message.  % - %  The format of the MagickWarning method is:  % I %      void MagickWarning(const unsigned int warning,const char *message,  %        const char *qualifier)  % + %  A description of each parameter follows:  % 7 %    o warning: Specifies the numeric warning category.  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */I Export void MagickWarning(const unsigned int warning,const char *message,    const char *qualifier) { -   if (warning_handler != (ErrorHandler) NULL) 2     (*warning_handler)(warning,message,qualifier); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S e t E r r o r H a n d l e r                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method SetErrorHandler sets the error handler to the specified method* %  and returns the previous error handler. % / %  The format of the SetErrorHandler method is:  % 9 %      ErrorHandler SetErrorHandler(ErrorHandler handler)  % + %  A description of each parameter follows:  % A %    o handler: Specifies a pointer to a method to handle errors.  %  %  */9 Export ErrorHandler SetErrorHandler(ErrorHandler handler)  {    ErrorHandler     previous_handler;   !   previous_handler=error_handler;    error_handler=handler;   return(previous_handler);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S e t W a r n i n g H a n d l e r                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method SetWarningHandler sets the warning handler to the specified method, %  and returns the previous warning handler. % 1 %  The format of the SetWarningHandler method is:  % ; %      ErrorHandler SetWarningHandler(ErrorHandler handler)  % + %  A description of each parameter follows:  % C %    o handler: Specifies a pointer to a method to handle warnings.  %  %  */; Export ErrorHandler SetWarningHandler(ErrorHandler handler)  {    ErrorHandler     previous_handler;   #   previous_handler=warning_handler;    warning_handler=handler;   return(previous_handler);  } 