 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            FFFFF  PPPP   X   X                              % O %                            F      P   P   X X                               % O %                            FFF    PPPP     X                                % O %                            F      P       X X                               % O %                            F      P      X   X                              % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   #if defined(HasFPX)  #include "Fpxlib.h"  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d F P X I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method ReadFPXImage reads a FlashPix image file and returns it.  ItK %  allocates the memory necessary for the new Image structure and returns a N %  pointer to the new image.  This method was contributed by BillR@corbis.com. % , %  The format of the ReadFPXImage method is: % 7 %      Image *ReadFPXImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadFPXImage returns a pointer to the image after L %      reading. A null image is returned if there is a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadFPXImage(const ImageInfo *image_info)  {    FPXColorspace      colorspace;      FPXImageComponentDesc      *alpha_component,      *blue_component,     *green_component,      *red_component;      FPXImageDesc
     fpx_info;      FPXImageHandle     *flashpix;     FPXStatus      fpx_status;      FPXSummaryInformation      summary_info;      Image      *image;   
   IndexPacket 
     index;     int      y;     register int     i,     x;     register long      packets;     register PixelPacket     *q;      register unsigned char     *a,      *b,      *g,      *r;      unsigned char      *scanline;     unsigned int     status, 
     subimage;      unsigned long      height,      memory_limit,      tile_width,      tile_height,
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image.    */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);,   if ((image->file == stdin) || image->pipe)     { 
       FILE         *file;  	       int 
         c;         /*6         Copy standard input or pipe to temporary file.       */7       TemporaryFilename((char *) image_info->filename); 7       file=fopen(image_info->filename,WriteBinaryType);         if (file == (FILE *) NULL)A         ReaderExit(FileOpenWarning,"Unable to write file",image);        c=ReadByte(image);       while (c != EOF)       {          (void) putc(c,file);         c=ReadByte(image);       }        (void) fclose(file);:       (void) strcpy(image->filename,image_info->filename);       image->temporary=True;     }    CloseBlob(image);    /*     Initialize FPX toolkit.    */   memory_limit=20000000;6   fpx_status=FPX_SetToolkitMemoryLimit(&memory_limit);   if (fpx_status != FPX_OK) I     ReaderExit(DelegateWarning,"Unable to initialize FPX library",image);    tile_width=64;   tile_height=64; #   flashpix=(FPXImageHandle *) NULL;    {  #if defined(macintosh)
     FSSpec
       fsspec;   .     FilenameToFSSpec(image->filename,&fsspec);?     fpx_status=FPX_OpenImageByFilename((const FSSpec &) fsspec,  #else 7     fpx_status=FPX_OpenImageByFilename(image->filename,  #endifJ       NULL,&width,&height,&tile_width,&tile_height,&colorspace,&flashpix);   } )   if (fpx_status == FPX_LOW_MEMORY_ERROR)      {        FPX_ClearSystem();H       ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);     }    if (fpx_status != FPX_OK)      {        FPX_ClearSystem();B       ReaderExit(FileOpenWarning,"Unable to open FPX file",image);     } (   if (image_info->view == (char *) NULL)     {        float          aspect_ratio;          /*         Get the aspect ratio.        */(       aspect_ratio=(float) width/height;G       fpx_status=FPX_GetImageResultAspectRatio(flashpix,&aspect_ratio);        if (fpx_status != FPX_OK) D         MagickWarning(DelegateWarning,"Unable to read aspect ratio",            image_info->filename);?       if (width != (unsigned long) ((aspect_ratio*height)+0.5))          Swap(width,height);      } ?   fpx_status=FPX_GetSummaryInformation(flashpix,&summary_info);    if (fpx_status != FPX_OK)      {        FPX_ClearSystem();F       ReaderExit(FileOpenWarning,"Unable to read summary info",image);     }    if (summary_info.title_valid) +     if ((summary_info.title.length != 0) && ;         (summary_info.title.ptr != (unsigned char *) NULL))        { 
         /*           Note image label. 
         */;         image->label=(char *) AllocateMemory((unsigned int) 6           (summary_info.title.length+1)*sizeof(char));*         if (image->label == (char *) NULL)C           MagickWarning(DelegateWarning,"Memory allocation failed", "             image_info->filename);         else           { H             (void) strncpy(image->label,(char *) summary_info.title.ptr,)               summary_info.title.length); 9             image->label[summary_info.title.length]='\0';            }        } "   if (summary_info.comments_valid).     if ((summary_info.comments.length != 0) &&>         (summary_info.comments.ptr != (unsigned char *) NULL))       { 
         /*           Note image comment. 
         */>         image->comments=(char *) AllocateMemory((unsigned int)9           (summary_info.comments.length+1)*sizeof(char)); -         if (image->comments == (char *) NULL) C           MagickWarning(DelegateWarning,"Memory allocation failed", "             image_info->filename);         else           { N             (void) strncpy(image->comments,(char *) summary_info.comments.ptr,,               summary_info.comments.length);?             image->comments[summary_info.comments.length]='\0';            }        }    /*3     Determine resolution by subimage specification.    */   for (i=1; ; i++)&     if (((width >> i) < tile_width) ||&         ((height >> i) < tile_height))       break;
   subimage=i;     if (image_info->subrange != 0)+     while (subimage > image_info->subimage)      {        width>>=1;       height>>=1;        subimage--;      } (   if (image_info->size != (char *) NULL)>     while ((width > image->columns) || (height > image->rows))     {        width>>=1;       height>>=1;        subimage--;      }    image->columns=width;    image->rows=height; /   if ((colorspace.numberOfComponents % 2) == 0)      image->matte=True;)   if (colorspace.numberOfComponents == 1)      {        /*         Create linear colormap.        */       image->class=PseudoClass;        image->colors=MaxRGB+1; %       image->colormap=(PixelPacket *) :         AllocateMemory(image->colors*sizeof(PixelPacket));2       if (image->colormap == (PixelPacket *) NULL)	         {            FPX_ClearSystem();L           ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);	         } -       for (i=0; i < (int) image->colors; i++)        { +         image->colormap[i].red=(Quantum) i; -         image->colormap[i].green=(Quantum) i; ,         image->colormap[i].blue=(Quantum) i;       }      }    if (image_info->ping)      {        CloseBlob(image);        return(image);     }    /*3     Allocate memory for the image and pixel buffer.    */   packets=0;J   scanline=(unsigned char *) AllocateMemory(colorspace.numberOfComponents*:     image->columns*(tile_height+1)*sizeof(unsigned char));   image->pixels=(PixelPacket *) C     AllocateMemory(image->columns*image->rows*sizeof(PixelPacket)); 0   if ((image->pixels == (PixelPacket *) NULL) ||+       (scanline == (unsigned char *) NULL))      {        FPX_ClearSystem();&       (void) FPX_CloseImage(flashpix);H       ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);     }    /**     Initialize FlashPix image description.   */<   fpx_info.numberOfComponents=colorspace.numberOfComponents;   for (i=0; i < 4; i++)    { J     fpx_info.components[i].myColorType.myDataType=DATA_TYPE_UNSIGNED_BYTE;/     fpx_info.components[i].horzSubSampFactor=1; /     fpx_info.components[i].vertSubSampFactor=1; (     fpx_info.components[i].columnStride=8       fpx_info.numberOfComponents*sizeof(unsigned char);&     fpx_info.components[i].lineStride=9       image->columns*fpx_info.components[i].columnStride; .     fpx_info.components[i].theData=scanline+i;   } -   fpx_info.components[0].myColorType.myColor= <     fpx_info.numberOfComponents > 2 ? NIFRGB_R : MONOCHROME;*   red_component=(&fpx_info.components[0]);-   fpx_info.components[1].myColorType.myColor= 7     fpx_info.numberOfComponents > 2 ? NIFRGB_G : ALPHA; ,   green_component=(&fpx_info.components[1]);6   fpx_info.components[2].myColorType.myColor=NIFRGB_B;+   blue_component=(&fpx_info.components[2]); 3   fpx_info.components[3].myColorType.myColor=ALPHA; H   alpha_component=(&fpx_info.components[fpx_info.numberOfComponents-1]);2   FPX_SetResampleMethod(FPX_LINEAR_INTERPOLATION);   /*     Initialize image pixels.   */'   for (y=0; y < (int) image->rows; y++)    { 0     q=SetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;     if ((y % tile_height) == 0)        { 
         /*C           Read FPX image tile (with or without viewing transform).. 
         */.         if (image_info->view != (char *) NULL)J           fpx_status=FPX_ReadImageRectangle(flashpix,0,y,image->columns,y+.             tile_height-1,subimage,&fpx_info);         elseM           fpx_status=FPX_ReadImageTransformRectangle(flashpix,0.0F,(float) y/ F             image->rows,(float) image->columns/image->rows,(float) (y+P             tile_height-1)/image->rows,(long) image->columns,(long) tile_height,             &fpx_info); /         if (fpx_status == FPX_LOW_MEMORY_ERROR)            { !             FreeMemory(scanline); ,             (void) FPX_CloseImage(flashpix);             FPX_ClearSystem();N             ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);           }        }      /*       Transfer a FPX scanline.     */I     r=red_component->theData+(y % tile_height)*red_component->lineStride; M     g=green_component->theData+(y % tile_height)*green_component->lineStride; K     b=blue_component->theData+(y % tile_height)*blue_component->lineStride; M     a=alpha_component->theData+(y % tile_height)*alpha_component->lineStride; ,     for (x=0; x < (int) image->columns; x++)     { *       if (fpx_info.numberOfComponents > 2)	         {            q->red=UpScale(*r);            q->green=UpScale(*g);            q->blue=UpScale(*b);	         } 
       else	         {            index=UpScale(*r);"           image->indexes[x]=index;           q->red=index;            q->green=index;            q->blue=index;	         }        if (image->matte)          q->opacity=UpScale(*a); 
       q++;%       r+=red_component->columnStride; '       g+=green_component->columnStride; &       b+=blue_component->columnStride;'       a+=alpha_component->columnStride;      }      if (!SyncPixelCache(image))        break;#     if (QuantumTick(y,image->rows)) 3       ProgressMonitor(LoadImageText,y,image->rows);    }    FreeMemory(scanline); "   (void) FPX_CloseImage(flashpix);   FPX_ClearSystem();   if (image->temporary)      { %       (void) remove(image->filename);        image->temporary=False;      }    return(image); }  #else 7 Export Image *ReadFPXImage(const ImageInfo *image_info)  { F   MagickWarning(MissingDelegateWarning,"FPX library is not available",     image_info->filename);   return((Image *) NULL);  }  #endif   #if defined(HasFPX)  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e F P X I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method WriteFPXImage writes an image in the FlashPix image format.  This . %  method was contributed by BillR@corbis.com. % - %  The format of the WriteFPXImage method is:  % K %      unsigned int WriteFPXImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % L %    o fpx_status: Method WriteFPXImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */  9 static void ColorTwistMultiply(FPXColorTwistMatrix first, >   FPXColorTwistMatrix second,FPXColorTwistMatrix *color_twist) {    /*     Matrix multiply.   */6   assert(color_twist != (FPXColorTwistMatrix *) NULL);O   color_twist->byy=(first.byy*second.byy)+(first.byc1*second.bc1y)+(first.byc2* 8     second.bc2y)+(first.dummy1_zero*second.dummy4_zero);F   color_twist->byc1=(first.byy*second.byc1)+(first.byc1*second.bc1c1)+E     (first.byc2*second.bc2c1)+(first.dummy1_zero*second.dummy5_zero); F   color_twist->byc2=(first.byy*second.byc2)+(first.byc1*second.bc1c2)+E     (first.byc2*second.bc2c2)+(first.dummy1_zero*second.dummy6_zero); F   color_twist->dummy1_zero=(first.byy*second.dummy1_zero)+(first.byc1*K     second.dummy2_zero)+(first.byc2*second.dummy3_zero)+(first.dummy1_zero*      second.dummy7_one); F   color_twist->bc1y=(first.bc1y*second.byy)+(first.bc1c1*second.bc1y)+E     (first.bc1c2*second.bc2y)+(first.dummy2_zero*second.dummy4_zero); I   color_twist->bc1c1=(first.bc1y*second.byc1)+(first.bc1c1*second.bc1c1)+ F     (first.bc1c2*second.bc2c1)+(first.dummy2_zero*second.dummy5_zero);I   color_twist->bc1c2=(first.bc1y*second.byc2)+(first.bc1c1*second.bc1c2)+ F     (first.bc1c2*second.bc2c2)+(first.dummy2_zero*second.dummy6_zero);H   color_twist->dummy2_zero=(first.bc1y*second.dummy1_zero)+(first.bc1c1*L     second.dummy2_zero)+(first.bc1c2*second.dummy3_zero)+(first.dummy2_zero*     second.dummy7_one); F   color_twist->bc2y=(first.bc2y*second.byy)+(first.bc2c1*second.bc1y)+E     (first.bc2c2*second.bc2y)+(first.dummy3_zero*second.dummy4_zero); I   color_twist->bc2c1=(first.bc2y*second.byc1)+(first.bc2c1*second.bc1c1)+ F     (first.bc2c2*second.bc2c1)+(first.dummy3_zero*second.dummy5_zero);I   color_twist->bc2c2=(first.bc2y*second.byc2)+(first.bc2c1*second.bc1c2)+ F     (first.bc2c2*second.bc2c2)+(first.dummy3_zero*second.dummy6_zero);H   color_twist->dummy3_zero=(first.bc2y*second.dummy1_zero)+(first.bc2c1*L     second.dummy2_zero)+(first.bc2c2*second.dummy3_zero)+(first.dummy3_zero*     second.dummy7_one); M   color_twist->dummy4_zero=(first.dummy4_zero*second.byy)+(first.dummy5_zero* C     second.bc1y)+(first.dummy6_zero*second.bc2y)+(first.dummy7_one*      second.dummy4_zero);N   color_twist->dummy5_zero=(first.dummy4_zero*second.byc1)+(first.dummy5_zero*E     second.bc1c1)+(first.dummy6_zero*second.bc2c1)+(first.dummy7_one*      second.dummy5_zero);N   color_twist->dummy6_zero=(first.dummy4_zero*second.byc2)+(first.dummy5_zero*E     second.bc1c2)+(first.dummy6_zero*second.bc2c2)+(first.dummy7_one*      second.dummy6_zero);A   color_twist->dummy7_one=(first.dummy4_zero*second.dummy1_zero)+ >     (first.dummy5_zero*second.dummy2_zero)+(first.dummy6_zero*=     second.dummy3_zero)+(first.dummy7_one*second.dummy7_one);  }   M static void SetBrightness(double brightness,FPXColorTwistMatrix *color_twist)  {    FPXColorTwistMatrix      effect,      result;      /*/     Set image brightness in color twist matrix.    */6   assert(color_twist != (FPXColorTwistMatrix *) NULL);'   brightness=sqrt((double) brightness);    effect.byy=brightness;   effect.byc1=0.0;   effect.byc2=0.0;   effect.dummy1_zero=0.0;    effect.bc1y=0.0;   effect.bc1c1=brightness;   effect.bc1c2=0.0;    effect.dummy2_zero=0.0;    effect.bc2y=0.0;   effect.bc2c1=0.0;    effect.bc2c2=brightness;   effect.dummy3_zero=0.0;    effect.dummy4_zero=0.0;    effect.dummy5_zero=0.0;    effect.dummy6_zero=0.0;    effect.dummy7_one=1.0;2   ColorTwistMultiply(*color_twist,effect,&result);   *color_twist=result; }   @ static void SetColorBalance(double red,double green,double blue,#   FPXColorTwistMatrix *color_twist)  {    FPXColorTwistMatrix      blue_effect,     green_effect,      result,      rgb_effect,      rg_effect,     red_effect;      /*2     Set image color balance in color twist matrix.   */6   assert(color_twist != (FPXColorTwistMatrix *) NULL);   red=sqrt((double) red)-1.0; !   green=sqrt((double) green)-1.0;    blue=sqrt((double) blue)-1.0;    red_effect.byy=1.0;    red_effect.byc1=0.0;   red_effect.byc2=0.299*red;   red_effect.dummy1_zero=0.0;    red_effect.bc1y=(-0.299)*red; !   red_effect.bc1c1=1.0-0.299*red;     red_effect.bc1c2=(-0.299)*red;   red_effect.dummy2_zero=0.0;    red_effect.bc2y=0.701*red;   red_effect.bc2c1=0.0; !   red_effect.bc2c2=1.0+0.402*red;    red_effect.dummy3_zero=0.0;    red_effect.dummy4_zero=0.0;    red_effect.dummy5_zero=0.0;    red_effect.dummy6_zero=0.0;    red_effect.dummy7_one=1.0;   green_effect.byy=1.0; #   green_effect.byc1=(-0.114)*green; #   green_effect.byc2=(-0.299)*green;    green_effect.dummy1_zero=0.0; #   green_effect.bc1y=(-0.587)*green; %   green_effect.bc1c1=1.0-0.473*green; !   green_effect.bc1c2=0.299*green;    green_effect.dummy2_zero=0.0; #   green_effect.bc2y=(-0.587)*green; !   green_effect.bc2c1=0.114*green; %   green_effect.bc2c2=1.0-0.288*green;    green_effect.dummy3_zero=0.0;    green_effect.dummy4_zero=0.0;    green_effect.dummy5_zero=0.0;    green_effect.dummy6_zero=0.0;    green_effect.dummy7_one=1.0;   blue_effect.byy=1.0;   blue_effect.byc1=0.114*blue;   blue_effect.byc2=0.0;    blue_effect.dummy1_zero=0.0;   blue_effect.bc1y=0.886*blue;#   blue_effect.bc1c1=1.0+0.772*blue;    blue_effect.bc1c2=0.0;   blue_effect.dummy2_zero=0.0;!   blue_effect.bc2y=(-0.114)*blue; "   blue_effect.bc2c1=(-0.114)*blue;#   blue_effect.bc2c2=1.0-0.114*blue;    blue_effect.dummy3_zero=0.0;   blue_effect.dummy4_zero=0.0;   blue_effect.dummy5_zero=0.0;   blue_effect.dummy6_zero=0.0;   blue_effect.dummy7_one=1.0; 9   ColorTwistMultiply(red_effect,green_effect,&rg_effect); 8   ColorTwistMultiply(rg_effect,blue_effect,&rgb_effect);6   ColorTwistMultiply(*color_twist,rgb_effect,&result);   *color_twist=result; }   M static void SetSaturation(double saturation,FPXColorTwistMatrix *color_twist)  {    FPXColorTwistMatrix      effect,      result;      /*/     Set image saturation in color twist matrix.    */6   assert(color_twist != (FPXColorTwistMatrix *) NULL);   effect.byy=1.0;    effect.byc1=0.0;   effect.byc2=0.0;   effect.dummy1_zero=0.0;    effect.bc1y=0.0;   effect.bc1c1=saturation;   effect.bc1c2=0.0;    effect.dummy2_zero=0.0;    effect.bc2y=0.0;   effect.bc2c1=0.0;    effect.bc2c2=saturation;   effect.dummy3_zero=0.0;    effect.dummy4_zero=0.0;    effect.dummy5_zero=0.0;    effect.dummy6_zero=0.0;    effect.dummy7_one=1.0;2   ColorTwistMultiply(*color_twist,effect,&result);   *color_twist=result; }   K Export unsigned int WriteFPXImage(const ImageInfo *image_info,Image *image)  {    FPXBackground      background_color;      FPXColorspace      colorspace =     {        TRUE, 4,(       NIFRGB_R, DATA_TYPE_UNSIGNED_BYTE,(       NIFRGB_G, DATA_TYPE_UNSIGNED_BYTE,(       NIFRGB_B, DATA_TYPE_UNSIGNED_BYTE,$       ALPHA, DATA_TYPE_UNSIGNED_BYTE     };     FPXCompressionOption     compression;     FPXImageDesc
     fpx_info;      FPXImageHandle     *flashpix;     FPXStatus      fpx_status;      FPXSummaryInformation      summary_info;      Image      fpx_image;     int      y;     register int     i;     unsigned char      *pixels;     unsigned int     status;      unsigned long      memory_limit,      tile_height,     tile_width;      /*     Open input file.   */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);.   if ((image->file != stdout) && !image->pipe)#     (void) remove(image->filename);    else     {        /*8         Write standard output or pipe to temporary file.       */       fpx_image=(*image); )       TemporaryFilename(image->filename);        image->temporary=True;     }    CloseBlob(image); )   TransformRGBImage(image,RGBColorspace);    /*     Initialize FPX toolkit.    */   memory_limit=20000000;6   fpx_status=FPX_SetToolkitMemoryLimit(&memory_limit);   if (fpx_status != FPX_OK) N     WriterExit(ResourceLimitWarning,"Unable to initialize FPX library",image);   tile_width=64;   tile_height=64; "   colorspace.numberOfComponents=3;   if (image->matte) $     colorspace.numberOfComponents=4;   if (IsGrayImage(image))      { &       colorspace.numberOfComponents=1;5       colorspace.theComponents[0].myColor=MONOCHROME;      } "   background_color.color1_value=0;"   background_color.color2_value=0;"   background_color.color3_value=0;"   background_color.color4_value=0;   compression=NONE; 1   if (image_info->compression == JPEGCompression) !     compression=JPEG_UNSPECIFIED;    {  #if defined(macintosh)
     FSSpec
       fsspec;   .     FilenameToFSSpec(image->filename,&fsspec);A     fpx_status=FPX_CreateImageByFilename((const FSSpec &) fsspec,  #else 9     fpx_status=FPX_CreateImageByFilename(image->filename,  #endifA     image->columns,image->rows,tile_width,tile_height,colorspace, ,     background_color,compression,&flashpix);   }    if (fpx_status != FPX_OK) <     WriterExit(FileOpenWarning,"Unable to open file",image);1   if (image_info->compression == JPEGCompression)      {        /*C         Initialize the compression by quality for the entire image.        */       fpx_status= P         FPX_SetJPEGCompression(flashpix,(unsigned short) (image_info->quality));       if (fpx_status != FPX_OK) P         MagickWarning(DelegateWarning,"Unable to set JPEG level",(char *) NULL);     }    /*     Set image summary info.    */!   summary_info.title_valid=False; #   summary_info.subject_valid=False; "   summary_info.author_valid=False;$   summary_info.comments_valid=False;$   summary_info.keywords_valid=False;'   summary_info.OLEtemplate_valid=False; '   summary_info.last_author_valid=False; &   summary_info.rev_number_valid=False;%   summary_info.edit_time_valid=False; (   summary_info.last_printed_valid=False;&   summary_info.create_dtm_valid=False;)   summary_info.last_save_dtm_valid=False; &   summary_info.page_count_valid=False;&   summary_info.word_count_valid=False;&   summary_info.char_count_valid=False;%   summary_info.thumbnail_valid=False; #   summary_info.appname_valid=False; $   summary_info.security_valid=False;$   if (image->label != (char *) NULL)     {        /*         Note image label.        */$       summary_info.title_valid=True;5       summary_info.title.length=strlen(image->label); .       summary_info.title.ptr=(unsigned char *)G         AllocateMemory((strlen(image->label)+1)*sizeof(unsigned char)); ;       if (summary_info.title.ptr != (unsigned char *) NULL) D         (void) strcpy((char *) summary_info.title.ptr,image->label);
       elseB         MagickWarning(DelegateWarning,"Unable to set image title",           (char *) NULL);      } '   if (image->comments != (char *) NULL)      {        /*         Note image comment.        */'       summary_info.comments_valid=True; ;       summary_info.comments.length=strlen(image->comments); 1       summary_info.comments.ptr=(unsigned char *) J         AllocateMemory((strlen(image->comments)+1)*sizeof(unsigned char));>       if (summary_info.comments.ptr != (unsigned char *) NULL)J         (void) strcpy((char *) summary_info.comments.ptr,image->comments);
       elseE         MagickWarning(DelegateWarning,"Unable to set image comments",            (char *) NULL);      } ?   fpx_status=FPX_SetSummaryInformation(flashpix,&summary_info);    if (fpx_status != FPX_OK) N     MagickWarning(DelegateWarning,"Unable to set summary info",(char *) NULL);   /*     Allocate pixels.   */H   pixels=(unsigned char *) AllocateMemory(colorspace.numberOfComponents**     image->columns*sizeof(unsigned char));'   if (pixels == (unsigned char *) NULL)      { &       (void) FPX_CloseImage(flashpix);       FPX_ClearSystem();H       WriterExit(ResourceLimitWarning,"Memory allocation failed",image);     }    /**     Initialize FlashPix image description.   */<   fpx_info.numberOfComponents=colorspace.numberOfComponents;1   for (i=0; i < fpx_info.numberOfComponents; i++)    { J     fpx_info.components[i].myColorType.myDataType=DATA_TYPE_UNSIGNED_BYTE;/     fpx_info.components[i].horzSubSampFactor=1; /     fpx_info.components[i].vertSubSampFactor=1; (     fpx_info.components[i].columnStride=8       fpx_info.numberOfComponents*sizeof(unsigned char);&     fpx_info.components[i].lineStride=9       image->columns*fpx_info.components[i].columnStride; ,     fpx_info.components[i].theData=pixels+i;   } -   fpx_info.components[0].myColorType.myColor= =     fpx_info.numberOfComponents != 1 ? NIFRGB_R : MONOCHROME; 6   fpx_info.components[1].myColorType.myColor=NIFRGB_G;6   fpx_info.components[2].myColorType.myColor=NIFRGB_B;3   fpx_info.components[3].myColorType.myColor=ALPHA;    /*     Write image scanlines.   */'   for (y=0; y < (int) image->rows; y++)    { 3     if (!GetPixelCache(image,0,y,image->columns,1))        break;)     if (fpx_info.numberOfComponents == 1) 0       WritePixelCache(image,GrayQuantum,pixels);     else       if (!image->matte)1         WritePixelCache(image,RGBQuantum,pixels); 
       else2         WritePixelCache(image,RGBAQuantum,pixels);6     fpx_status=FPX_WriteImageLine(flashpix,&fpx_info);     if (fpx_status != FPX_OK)        break;#     if (QuantumTick(y,image->rows)) 3       ProgressMonitor(SaveImageText,y,image->rows);    } (   if (image_info->view != (char *) NULL)     {        FPXAffineMatrix          affine;          FPXColorTwistMatrix          color_twist;         FPXContrastAdjustment          contrast;          FPXFilteringValue          sharpen;         FPXResultAspectRatio         aspect_ratio;          FPXROI         view_rect;         unsigned int         affine_valid,          aspect_ratio_valid,          color_twist_valid,         contrast_valid,          sharpen_valid,         view_rect_valid;         /*.         Initialize default viewing parameters.       */       contrast=1.0;        contrast_valid=False;        color_twist.byy=1.0;       color_twist.byc1=0.0;        color_twist.byc2=0.0; "       color_twist.dummy1_zero=0.0;       color_twist.bc1y=0.0;        color_twist.bc1c1=1.0;       color_twist.bc1c2=0.0;"       color_twist.dummy2_zero=0.0;       color_twist.bc2y=0.0;        color_twist.bc2c1=0.0;       color_twist.bc2c2=1.0;"       color_twist.dummy3_zero=0.0;"       color_twist.dummy4_zero=0.0;"       color_twist.dummy5_zero=0.0;"       color_twist.dummy6_zero=0.0;!       color_twist.dummy7_one=1.0;        color_twist_valid=False;       sharpen=0.0;       sharpen_valid=False;7       aspect_ratio=(double) image->columns/image->rows;        aspect_ratio_valid=False;        view_rect.left=0.1; '       view_rect.width=aspect_ratio-0.2;        view_rect.top=0.1;       view_rect.height=1.0-0.2;        view_rect_valid=False;       affine.a11=1.0;        affine.a12=0.0;        affine.a13=0.0;        affine.a14=0.0;        affine.a21=0.0;        affine.a22=1.0;        affine.a23=0.0;        affine.a24=0.0;        affine.a31=0.0;        affine.a32=0.0;        affine.a33=1.0;        affine.a34=0.0;        affine.a41=0.0;        affine.a42=0.0;        affine.a43=0.0;        affine.a44=1.0;        affine_valid=False;        if (0)	         {            /*             Color color_twist.           */*           SetBrightness(0.5,&color_twist);*           SetSaturation(0.5,&color_twist);4           SetColorBalance(0.5,1.0,1.0,&color_twist);!           color_twist_valid=True; 	         }        if (affine_valid) 	         { @           fpx_status=FPX_SetImageAffineMatrix(flashpix,&affine);#           if (fpx_status != FPX_OK) H             MagickWarning(DelegateWarning,"Unable to set affine matrix",               (char *) NULL); 	         }        if (aspect_ratio_valid) 	         { K           fpx_status=FPX_SetImageResultAspectRatio(flashpix,&aspect_ratio); #           if (fpx_status != FPX_OK) G             MagickWarning(DelegateWarning,"Unable to set aspect ratio",                (char *) NULL); 	         }        if (color_twist_valid)	         { I           fpx_status=FPX_SetImageColorTwistMatrix(flashpix,&color_twist); #           if (fpx_status != FPX_OK) L             MagickWarning(DelegateWarning,"Unable to set color color twist",               (char *) NULL); 	         }        if (contrast_valid) 	         { H           fpx_status=FPX_SetImageContrastAdjustment(flashpix,&contrast);#           if (fpx_status != FPX_OK) C             MagickWarning(DelegateWarning,"Unable to set contrast",                (char *) NULL); 	         }        if (sharpen_valid)	         { C           fpx_status=FPX_SetImageFilteringValue(flashpix,&sharpen); #           if (fpx_status != FPX_OK) J             MagickWarning(DelegateWarning,"Unable to set filtering value",               (char *) NULL); 	         }        if (view_rect_valid)	         { ;           fpx_status=FPX_SetImageROI(flashpix, &view_rect); #           if (fpx_status != FPX_OK) M             MagickWarning(DelegateWarning,"Unable to set region of interest",                (char *) NULL); 	         }      } "   (void) FPX_CloseImage(flashpix);   FPX_ClearSystem();   FreeMemory(pixels);    if (image->temporary)      { 
       FILE         *file;  	       int 
         c;         /*7         Copy temporary file to standard output or pipe.        */1       file=fopen(image->filename,ReadBinaryType);         if (file == (FILE *) NULL)@         WriterExit(FileOpenWarning,"Unable to open file",image);2       for (c=fgetc(file); c != EOF; c=fgetc(file))&         (void) putc(c,fpx_image.file);       (void) fclose(file);%       (void) remove(image->filename);        image->temporary=False;        CloseBlob(&fpx_image);     }    return(True);  }  #else K Export unsigned int WriteFPXImage(const ImageInfo *image_info,Image *image)  { F   MagickWarning(MissingDelegateWarning,"FPX library is not available",     image->filename);    return(False); }  #endif