 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                             GGGG  IIIII  FFFFF                              % O %                            G        I    F                                  % O %                            G  GG    I    FFF                                % O %                            G   G    I    F                                  % O %                             GGG   IIIII  F                                  % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e c o d e I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ; %  Method DecodeImage uncompresses an image via GIF-coding.  % + %  The format of the DecodeImage method is:  % D %      unsigned int DecodeImag(Image *image,const short int opacity) % + %  A description of each parameter follows:  % E %    o status:  Method DecodeImage returns True if all the pixels are 3 %      uncompressed without error, otherwise False.  % 7 %    o image: The address of a structure of type Image.  % C %    o opacity:  The colormap index associated with the transparent 
 %      color.  %  %  */E static unsigned int DecodeImage(Image *image,const short int opacity)  {  #define MaxStackSize  4096 #define NullCode  (-1)  
   IndexPacket 
     index;     int      available,	     bits, 	     code, 
     clear,     code_mask,     code_size,
     count,     end_of_information,      in_code,
     old_code,      y;     register int     i,     x;     register PixelPacket     *q;      register unsigned char     *c;      register unsigned int 
     datum;     short      *prefix;     unsigned char      data_size,
     first,     *packet,     *pixel_stack,      *suffix,     *top_stack;      /*     Allocate decoder tables.   */"   assert(image != (Image *) NULL);E   packet=(unsigned char *) AllocateMemory(256*sizeof(unsigned char)); >   prefix=(short *) AllocateMemory(MaxStackSize*sizeof(short));N   suffix=(unsigned char *) AllocateMemory(MaxStackSize*sizeof(unsigned char));   pixel_stack=(unsigned char *) ;     AllocateMemory((MaxStackSize+1)*sizeof(unsigned char)); +   if ((packet == (unsigned char *) NULL) || #       (prefix == (short *) NULL) || +       (suffix == (unsigned char *) NULL) || .       (pixel_stack == (unsigned char *) NULL))     { D       MagickWarning(ResourceLimitWarning,"Memory allocation failed",         image->filename);        return(False);     }    /*'     Initialize GIF data stream decoder.    */   data_size=ReadByte(image);   clear=1 << data_size;    end_of_information=clear+1;    available=clear+2;   old_code=NullCode;   code_size=data_size+1;   code_mask=(1 << code_size)-1; $   for (code=0; code < clear; code++)   {      prefix[code]=0; &     suffix[code]=(unsigned char) code;   }    /*     Decode GIF pixel stream.   */
   datum=0;	   bits=0;    c=0;
   count=0;
   first=0;   top_stack=pixel_stack;'   for (y=0; y < (int) image->rows; y++)    { 0     q=SetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;)     for (x=0; x < (int) image->columns; )      { #       if (top_stack == pixel_stack) 	         {            if (bits < code_size) 
             {                /*A                 Load bytes until there is enough bits for a code.                */               if (count == 0)                  {                    /**                     Read a new data block.                   */=                   count=ReadBlobBlock(image,(char *) packet); !                   if (count <= 0)                      break;                   c=packet;                  } "               datum+=(*c) << bits;               bits+=8;               c++;               count--;               continue; 
             }            /*             Get the next code.           */!           code=datum & code_mask;            datum>>=code_size;           bits-=code_size;           /*             Interpret the code           */A           if ((code > available) || (code == end_of_information))              break;           if (code == clear)
             {                /*                 Reset decoder.               */$               code_size=data_size+1;+               code_mask=(1 << code_size)-1;                 available=clear+2;                old_code=NullCode;               continue; 
             } #           if (old_code == NullCode) 
             { (               *top_stack++=suffix[code];               old_code=code;)               first=(unsigned char) code;                continue; 
             }            in_code=code;             if (code == available)
             { !               *top_stack++=first;                code=old_code;
             }            while (code > clear)           { &             *top_stack++=suffix[code];             code=prefix[code];           }            first=suffix[code];            /*1             Add a new string to the string table,            */(           if (available >= MaxStackSize)             break;           *top_stack++=first; %           prefix[available]=old_code; "           suffix[available]=first;           available++;K           if (((available & code_mask) == 0) && (available < MaxStackSize)) 
             {                code_size++;#               code_mask+=available; 
             }            old_code=in_code; 	         }        /*(         Pop a pixel off the pixel stack.       */       top_stack--;       index=(*top_stack);         image->indexes[x++]=index;        *q=image->colormap[index];9       q->opacity=index == opacity ? Transparent : Opaque; 
       q++;     }      if (!SyncPixelCache(image))        break;*     if (image->previous == (Image *) NULL)%       if (QuantumTick(y,image->rows)) 5         ProgressMonitor(LoadImageText,y,image->rows);    } $   image->compression=LZWCompression;   image->matte=opacity >= 0;   /*     Free decoder memory.   */   FreeMemory(pixel_stack);   FreeMemory(suffix);    FreeMemory(prefix);    FreeMemory(packet); &   if (image->interlace != NoInterlace)     {        Image          *interlace_image;   	       int 
         pass, 
         y;         register PixelPacket         *p,          *q;          static const int+         interlace_rate[4] = { 8, 8, 4, 2 }, ,         interlace_start[4] = { 0, 4, 2, 1 };         /*         Interlace image.       */H       interlace_image=CloneImage(image,image->columns,image->rows,True);,       if (interlace_image == (Image *) NULL)         return(False);
       i=0;$       for (pass=0; pass < 4; pass++)       {           y=interlace_start[pass];%         while (y < (int) image->rows) 	         { J           p=GetPixelCache(interlace_image,0,i,interlace_image->columns,1);6           q=SetPixelCache(image,0,y,image->columns,1);I           if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))              break;@           (void) memcpy(image->indexes,interlace_image->indexes,0             image->columns*sizeof(IndexPacket));@           (void) memcpy(q,p,image->columns*sizeof(PixelPacket));%           if (!SyncPixelCache(image))              break;           i++;"           y+=interlace_rate[pass];	         }        } $       DestroyImage(interlace_image);     }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   E n c o d e I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 9 %  Method EncodeImage compresses an image via GIF-coding.  % + %  The format of the EncodeImage method is:  % I %      unsigned int EncodeImage(const ImageInfo *image_info,Image *image, & %        const unsigned int data_size) % + %  A description of each parameter follows:  % E %    o status:  Method EncodeImage returns True if all the pixels are 1 %      compressed without error, otherwise False.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % 7 %    o image: The address of a structure of type Image.  % ? %    o data_size:  The number of bits in the compressed packet.  %  %  */I static unsigned int EncodeImage(const ImageInfo *image_info,Image *image,    const unsigned int data_size)  { 6 #define MaxCode(number_bits)  ((1 << (number_bits))-1) #define MaxHashTable  5003 #define MaxGIFBits  12 #if defined(HasLZW) & #define MaxGIFTable  (1 << MaxGIFBits) #else  #define MaxGIFTable  max_code  #endif #define GIFOutputCode(code) \  { \    /*  \      Emit a code. \   */ \   if (bits > 0) \ #     datum|=((long) code << bits); \    else \     datum=(long) code; \   bits+=number_bits; \   while (bits >= 8) \    { \ 	     /*  \ *       Add a character to current packet. \     */ \:     packet[byte_count++]=(unsigned char) (datum & 0xff); \     if (byte_count >= 254) \	       { \ -         (void) WriteByte(image,byte_count); \ =         (void) WriteBlob(image,byte_count,(char *) packet); \          byte_count=0; \ 	       } \      datum>>=8; \     bits-=8; \   } \    if (free_code > max_code)  \     { \        number_bits++; \&       if (number_bits == MaxGIFBits) \         max_code=MaxGIFTable; \        else \(         max_code=MaxCode(number_bits); \     } \  }      int 	     bits,      byte_count,      displacement,      k,     next_pixel,      number_bits,     y;     long
     datum;     register int     i,     x;     register PixelPacket     *p;      short      clear_code,      end_of_information_code,     free_code,     *hash_code,      *hash_prefix, 
     index,
     max_code,      waiting_code;      unsigned char      *packet,     *hash_suffix;      /*     Allocate encoder tables.   */"   assert(image != (Image *) NULL);E   packet=(unsigned char *) AllocateMemory(256*sizeof(unsigned char)); A   hash_code=(short *) AllocateMemory(MaxHashTable*sizeof(short)); C   hash_prefix=(short *) AllocateMemory(MaxHashTable*sizeof(short));    hash_suffix=(unsigned char *) 7     AllocateMemory(MaxHashTable*sizeof(unsigned char)); L   if ((packet == (unsigned char *) NULL) || (hash_code == (short *) NULL) ||(       (hash_prefix == (short *) NULL) ||.       (hash_suffix == (unsigned char *) NULL))     return(False);   /*     Initialize GIF encoder.    */   number_bits=data_size;    max_code=MaxCode(number_bits);*   clear_code=((short) 1 << (data_size-1));'   end_of_information_code=clear_code+1;    free_code=clear_code+2;    byte_count=0; 
   datum=0;	   bits=0; "   for (i=0; i < MaxHashTable; i++)     hash_code[i]=0;    GIFOutputCode(clear_code);   /*     Encode pixels.   */   waiting_code=0; '   for (y=0; y < (int) image->rows; y++)    { 0     p=GetPixelCache(image,0,y,image->columns,1);"     if (p == (PixelPacket *) NULL)       break;     if (y == 0) %       waiting_code=(*image->indexes); ;     for (x=(y == 0) ? 1 : 0; x < (int) image->columns; x++)      {        /*         Probe hash table.        */%       index=image->indexes[x] & 0xff; 
       p++;;       k=(int) ((int) index << (MaxGIFBits-8))+waiting_code;        if (k >= MaxHashTable)         k-=MaxHashTable; #if defined(HasLZW) K       if ((image_info->compression != NoCompression) && (hash_code[k] > 0)) 	         { L           if ((hash_prefix[k] == waiting_code) && (hash_suffix[k] == index))
             { (               waiting_code=hash_code[k];               continue; 
             }            if (k == 0)              displacement=1;            else(             displacement=MaxHashTable-k;           next_pixel=False;            for ( ; ; )            {              k-=displacement;             if (k < 0)               k+=MaxHashTable;"             if (hash_code[k] == 0)               break;N             if ((hash_prefix[k] == waiting_code) && (hash_suffix[k] == index))               { *                 waiting_code=hash_code[k];                  next_pixel=True;                 break;               }            } !           if (next_pixel == True)              continue; 	         }  #endif"       GIFOutputCode(waiting_code);"       if (free_code < MaxGIFTable)	         { #           hash_code[k]=free_code++; &           hash_prefix[k]=waiting_code;/           hash_suffix[k]=(unsigned char) index; 	         } 
       else	         {            /*3             Fill the hash table with empty entries.            */*           for (k=0; k < MaxHashTable; k++)             hash_code[k]=0;            /*4             Reset compressor and issue a clear code.           */!           free_code=clear_code+2; $           GIFOutputCode(clear_code);            number_bits=data_size;(           max_code=MaxCode(number_bits);	         }        waiting_code=index;      } *     if (image->previous == (Image *) NULL)%       if (QuantumTick(y,image->rows)) 5         ProgressMonitor(SaveImageText,y,image->rows);    }    /*      Flush out the buffered code.   */   GIFOutputCode(waiting_code);)   GIFOutputCode(end_of_information_code);    if (bits > 0)      {        /**         Add a character to current packet.       */:       packet[byte_count++]=(unsigned char) (datum & 0xff);       if (byte_count >= 254)	         { -           (void) WriteByte(image,byte_count); =           (void) WriteBlob(image,byte_count,(char *) packet);            byte_count=0; 	         }      }    /*     Flush accumulated data.    */   if (byte_count > 0)      { )       (void) WriteByte(image,byte_count); 9       (void) WriteBlob(image,byte_count,(char *) packet);      }    /*     Free encoder memory.   */   FreeMemory(hash_suffix);   FreeMemory(hash_prefix);   FreeMemory(hash_code);   FreeMemory(packet);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s G I F                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method IsGIF returns True if the image format type, identified by the %  magick string, is GIF.  % , %  The format of the ReadGIFImage method is: % 6 %      unsigned int IsGIF(const unsigned char *magick,# %        const unsigned int length)  % + %  A description of each parameter follows:  % J %    o status:  Method IsGIF returns True if the image format type is GIF. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */P Export unsigned int IsGIF(const unsigned char *magick,const unsigned int length) {    if (length < 4)      return(False);-   if (strncmp((char *) magick,"GIF8",4) == 0)      return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d G I F I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method ReadGIFImage reads a Compuserve Graphics image file and returns it. N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % , %  The format of the ReadGIFImage method is: % 7 %      Image *ReadGIFImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadGIFImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or %      an error occurs.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadGIFImage(const ImageInfo *image_info)  { 5 #define BitSet(byte,bit)  (((byte) & (bit)) == (bit)) . #define LSBFirstOrder(x,y)  (((y) << 8) | (x))     Image      *image;      int      status;      RectangleInfo      page_info;     register int     i;     register unsigned char     *p;      short int      opacity;     unsigned char      background,      c,	     flag,      *global_colormap,      header[MaxTextExtent],     magick[12];      unsigned int
     delay,     dispose,     global_colors,     image_count,     iterations;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*$     Determine if this is a GIF file.   */+   status=ReadBlob(image,6,(char *) magick); H   if ((status == False) || ((strncmp((char *) magick,"GIF87",5) != 0) &&1       (strncmp((char *) magick,"GIF89",5) != 0))) A     ReaderExit(CorruptImageWarning,"Not a GIF image file",image);    global_colors=0;)   global_colormap=(unsigned char *) NULL; +   page_info.width=LSBFirstReadShort(image); ,   page_info.height=LSBFirstReadShort(image);   flag=ReadByte(image);    background=ReadByte(image); $   c=ReadByte(image);  /* reserved */   if (BitSet(flag,0x80))     {        /*          opacity global colormap.       */+       global_colors=1 << ((flag & 0x07)+1); '       global_colormap=(unsigned char *) >         AllocateMemory(3*global_colors*sizeof(unsigned char));4       if (global_colormap == (unsigned char *) NULL)M         ReaderExit(ResourceLimitWarning,"Unable to read image colormap file",            image); F       (void) ReadBlob(image,3*global_colors,(char *) global_colormap);     } 
   delay=0;   dispose=0;   iterations=1;    opacity=(-1);    image_count=0;
   for ( ; ; )    { )     status=ReadBlob(image,1,(char *) &c);      if (status == False)       break;     if (c == ';')        break;  /* terminator */     if (c == '!')        { 
         /*           GIF Extension block.
         */-         status=ReadBlob(image,1,(char *) &c);          if (status == False)J           ReaderExit(CorruptImageWarning,"Unable to read extension block",             image);          switch (c)	         {            case 0xf9:           {              /*.               Read Graphics Control extension.             */=             while (ReadBlobBlock(image,(char *) header) > 0); #             dispose=header[0] >> 2; /             delay=(header[2] << 8) | header[1]; (             if ((header[0] & 0x01) == 1)                opacity=header[3];             break;           }            case 0xfe:           {              int                length;                /*%               Read Comment extension.              */             for ( ; ; ) 
             { :               length=ReadBlobBlock(image,(char *) header);               if (length <= 0)                 break;3               if (image->comments != (char *) NULL)                  { D                   image->comments=(char *) ReallocateMemory((char *)G                     image->comments,(Extent(image->comments)+length+1)* "                     sizeof(char));                 }                else                 { *                   image->comments=(char *)<                     AllocateMemory((length+1)*sizeof(char));7                   if (image->comments != (char *) NULL) *                     *image->comments='\0';                 } 3               if (image->comments == (char *) NULL) K                 ReaderExit(ResourceLimitWarning,"Memory allocation failed",                    image); "               header[length]='\0';=               (void) strcat(image->comments,(char *) header); 
             }              break;           }            case 0xff:           {              /*+               Read Netscape Loop extension.              */             int (               found_netscape_loop=False;  9             if (ReadBlobBlock(image,(char *) header) > 0) M               found_netscape_loop=!strncmp((char *) header,"NETSCAPE2.0",11); <             while (ReadBlobBlock(image,(char *) header) > 0)$             if (found_netscape_loop)               {                  /*&                   Look for terminator.                 */8                 iterations=(header[2] << 8) | header[1];               }              break;           }            default:           { =             while (ReadBlobBlock(image,(char *) header) > 0);              break;           } 	         }        }      if (c != ',')        continue;      if (image_count != 0)        { 
         /*(           Allocate next image structure.
         */,         AllocateNextImage(image_info,image);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            }          image=image->next;F         ProgressMonitor(LoadImagesText,(unsigned int) TellBlob(image),*           (unsigned int) image->filesize);       }      image_count++;     /*       Read image attributes.     */     image->class=PseudoClass; )     page_info.x=LSBFirstReadShort(image); )     page_info.y=LSBFirstReadShort(image); ,     image->columns=LSBFirstReadShort(image);)     image->rows=LSBFirstReadShort(image);      flag=ReadByte(image); F     image->interlace=BitSet(flag,0x40) ? PlaneInterlace : NoInterlace;N     image->colors=!BitSet(flag,0x80) ? global_colors : 1 << ((flag & 0x07)+1);+     image->page_info.width=page_info.width; -     image->page_info.height=page_info.height; #     image->page_info.y=page_info.y; #     image->page_info.x=page_info.x; +     if (image_info->delay == (char *) NULL)        image->delay=delay; -     if (image_info->dispose == (char *) NULL)        image->dispose=dispose; 0     if (image_info->iterations == (char *) NULL)#       image->iterations=iterations;      delay=0;     dispose=0;     iterations=1;      if (image_info->ping)        {          if (opacity >= 0)            image->matte=True;         CloseBlob(image);          return(image);       } 4     if ((image->columns == 0) || (image->rows == 0))>       ReaderExit(CorruptImageWarning,"image size is 0",image);     /*       Inititialize colormap.     */.     if (image->pixels != (PixelPacket *) NULL)        FreeMemory(image->pixels);#     image->colormap=(PixelPacket *) 8       AllocateMemory(image->colors*sizeof(PixelPacket));0     if (image->colormap == (PixelPacket *) NULL)H       ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);     if (!BitSet(flag,0x80))        { 
         /*           Use global colormap.
         */         p=global_colormap;/         for (i=0; i < (int) image->colors; i++) 	         { /           image->colormap[i].red=UpScale(*p++); 1           image->colormap[i].green=UpScale(*p++); 0           image->colormap[i].blue=UpScale(*p++);	         }           image->background_color=;           image->colormap[Min(background,image->colors-1)];        }      else       {          unsigned char            *colormap;  
         /*           Read local colormap.
         */"         colormap=(unsigned char *)@           AllocateMemory(3*image->colors*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL) L           ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);A         (void) ReadBlob(image,3*image->colors,(char *) colormap);          p=colormap; /         for (i=0; i < (int) image->colors; i++) 	         { /           image->colormap[i].red=UpScale(*p++); 1           image->colormap[i].green=UpScale(*p++); 0           image->colormap[i].blue=UpScale(*p++);	         }          FreeMemory(colormap);        }      /*       Decode image.      */&     status=DecodeImage(image,opacity);     if (status == False)       { O         MagickWarning(CorruptImageWarning,"Corrupt GIF image",image->filename);          break;       } "     if (image_info->subrange != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;   } 0   if (global_colormap != (unsigned char *) NULL)      FreeMemory(global_colormap);,   if (image->pixels == (PixelPacket *) NULL)M     ReaderExit(CorruptImageWarning,"Corrupt GIF image or subimage not found", 
       image); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseBlob(image);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e G I F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method WriteGIFImage writes an image to a file in the Compuserve Graphics %  image format. % - %  The format of the WriteGIFImage method is:  % K %      unsigned int WriteGIFImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % H %    o status: Method WriteGIFImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K Export unsigned int WriteGIFImage(const ImageInfo *image_info,Image *image)  {    Image      *next_image;     int      j,     y;     QuantizeInfo     quantize_info;     RectangleInfo      page_info;     register int     i,     x;     register PixelPacket     *p;      register unsigned char     *q;      unsigned char      bits_per_pixel,      c,     *colormap,     *global_colormap;      unsigned int     interlace,     opacity,
     scene,     status;      /*     Open output image file.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);   /*!     Determine image bounding box.    */!   page_info.width=image->columns;    page_info.height=image->rows;    page_info.x=0;   page_info.y=0;8   for (next_image=image; next_image != (Image *) NULL; )   { (     page_info.x=next_image->page_info.x;(     page_info.y=next_image->page_info.y;<     if ((next_image->columns+page_info.x) > page_info.width)6       page_info.width=next_image->columns+page_info.x;:     if ((next_image->rows+page_info.y) > page_info.height)4       page_info.height=next_image->rows+page_info.y;      next_image=next_image->next;   }    /*     Allocate colormap.   */N   global_colormap=(unsigned char *) AllocateMemory(768*sizeof(unsigned char));G   colormap=(unsigned char *) AllocateMemory(768*sizeof(unsigned char)); 4   if ((global_colormap == (unsigned char *) NULL) ||+       (colormap == (unsigned char *) NULL)) F     WriterExit(ResourceLimitWarning,"Memory allocation failed",image);   for (i=0; i < 768; i++)      colormap[i]=0;   /*     Write GIF header.    */B   if ((image->comments == (char *) NULL) && !image_info->adjoin &&       !image->matte)'     (void) WriteBlob(image,6,"GIF87a");    else7     if (Latin1Compare(image_info->magick,"GIF87") == 0) )       (void) WriteBlob(image,6,"GIF87a");      else)       (void) WriteBlob(image,6,"GIF89a"); F   if ((image->page_info.width != 0) && (image->page_info.height != 0))     page_info=image->page_info; ,   LSBFirstWriteShort(image,page_info.width);-   LSBFirstWriteShort(image,page_info.height);    page_info.x=0;   page_info.y=0;   /*     Write images to file.    */"   interlace=image_info->interlace;<   if (image_info->adjoin && (image->next != (Image *) NULL))     interlace=NoInterlace;   opacity=0;
   scene=0;   do   { +     TransformRGBImage(image,RGBColorspace);      if (!IsPseudoClass(image))       { 
         /*5           GIF requires that the image is colormapped. 
         */(         GetQuantizeInfo(&quantize_info);0         quantize_info.dither=image_info->dither;=         quantize_info.number_colors=image->matte ? 255 : 256; 3         (void) QuantizeImage(&quantize_info,image);          if (image->matte)            {              /*$               Set transparent pixel.             */$             opacity=image->colors++;M             image->colormap=(PixelPacket *) ReallocateMemory(image->colormap, 1               image->colors*sizeof(PixelPacket)); 8             if (image->colormap == (PixelPacket *) NULL)               { ,                 FreeMemory(global_colormap);%                 FreeMemory(colormap); K                 WriterExit(ResourceLimitWarning,"Memory allocation failed",                    image);                } =             image->colormap[opacity]=image->background_color; 1             for (y=0; y < (int) image->rows; y++) 
             { :               p=GetPixelCache(image,0,y,image->columns,1);,               if (p == (PixelPacket *) NULL)                 break;6               for (x=0; x < (int) image->columns; x++)               { .                 if (p->opacity == Transparent),                   image->indexes[x]=opacity;                 p++;               } )               if (!SyncPixelCache(image))                  break;
             }            }        }      else       if (image->matte) 	         {            /*-             Identify transparent pixel index.            *//           for (y=0; y < (int) image->rows; y++)            { 8             p=GetPixelCache(image,0,y,image->columns,1);*             if (p == (PixelPacket *) NULL)               break;4             for (x=0; x < (int) image->columns; x++)
             { ,               if (p->opacity == Transparent)                 { ,                   opacity=image->indexes[x];                   break;                 }                p++;
             } )             if (x < (int) image->columns)                break;           } 	         } @     for (bits_per_pixel=1; bits_per_pixel < 8; bits_per_pixel++)7       if ((1 << bits_per_pixel) >= (int) image->colors)          break;     q=colormap; +     for (i=0; i < (int) image->colors; i++)      { -       *q++=DownScale(image->colormap[i].red); /       *q++=DownScale(image->colormap[i].green); .       *q++=DownScale(image->colormap[i].blue);     } 1     for ( ; i < (int) (1 << bits_per_pixel); i++)      {        *q++=(Quantum) 0x0;        *q++=(Quantum) 0x0;        *q++=(Quantum) 0x0;      } C     if ((image->previous == (Image *) NULL) || !image_info->adjoin)        { 
         /*            Write global colormap.
         */         c=0x80; .         c|=(8-1) << 4;  /* color resolution */>         c|=(bits_per_pixel-1);   /* size of global colormap */)         (void) WriteByte(image,(char) c); 3         for (j=0; j < (int) (image->colors-1); j++) G           if (ColorMatch(image->background_color,image->colormap[j],0))              break;:         (void) WriteByte(image,j);  /* background color */4         (void) WriteByte(image,0x0);  /* reserved */J         (void) WriteBlob(image,3*(1 << bits_per_pixel),(char *) colormap);         for (j=0; j < 768; j++) )           global_colormap[j]=colormap[j];        } 7     if (Latin1Compare(image_info->magick,"GIF87") != 0)        { 
         /*+           Write Graphics Control extension. 
         */%         (void) WriteByte(image,0x21); %         (void) WriteByte(image,0xf9); %         (void) WriteByte(image,0x04);          c=image->dispose << 2;         if (image->matte)            c|=0x01;"         (void) WriteByte(image,c);/         LSBFirstWriteShort(image,image->delay); /         (void) WriteByte(image,(char) opacity); %         (void) WriteByte(image,0x00); -         if (image->comments != (char *) NULL)            {              register char                *p;   !             register unsigned int                count;               /*&               Write Comment extension.             */)             (void) WriteByte(image,0x21); )             (void) WriteByte(image,0xfe);              p=image->comments;!             while (Extent(p) > 0) 
             { '               count=Min(Extent(p),255); ,               (void) WriteByte(image,count);-               for (i=0; i < (int) count; i++) -                 (void) WriteByte(image,*p++); 
             } (             (void) WriteByte(image,0x0);           } 2         if ((image->previous == (Image *) NULL) &&H             (image->next != (Image *) NULL) && (image->iterations != 1))           {              /*,               Write Netscape Loop extension.             */)             (void) WriteByte(image,0x21); )             (void) WriteByte(image,0xff); )             (void) WriteByte(image,0x0b); 5             (void) WriteBlob(image,11,"NETSCAPE2.0"); )             (void) WriteByte(image,0x03); )             (void) WriteByte(image,0x01); 8             LSBFirstWriteShort(image,image->iterations);)             (void) WriteByte(image,0x00);            }        } 7     (void) WriteByte(image,',');  /* image separator */      /*       Write the image header.      */H     if ((image->page_info.width != 0) && (image->page_info.height != 0))!       page_info=image->page_info; *     LSBFirstWriteShort(image,page_info.x);*     LSBFirstWriteShort(image,page_info.y);-     LSBFirstWriteShort(image,image->columns); *     LSBFirstWriteShort(image,image->rows);     c=0x00; !     if (interlace != NoInterlace) .       c|=0x40;  /* pixel data is interlaced *//     for (j=0; j < (int) (3*image->colors); j++) ,       if (colormap[j] != global_colormap[j])         break;%     if (j == (int) (3*image->colors)) '       (void) WriteByte(image,(char) c);      else       {          c|=0x80;=         c|=(bits_per_pixel-1);   /* size of local colormap */ )         (void) WriteByte(image,(char) c); J         (void) WriteBlob(image,3*(1 << bits_per_pixel),(char *) colormap);       }      /*       Write the image data.      */     c=Max(bits_per_pixel,2);%     (void) WriteByte(image,(char) c); !     if (interlace == NoInterlace) C       status=EncodeImage(image_info,image,Max(bits_per_pixel,2)+1);      else       { 
         Image            *interlace_image;            int            pass;            register PixelPacket
           *q;            static const int-           interlace_rate[4] = { 8, 8, 4, 2 }, .           interlace_start[4] = { 0, 4, 2, 1 };  
         /*           Interlace image.
         */J         interlace_image=CloneImage(image,image->columns,image->rows,True);.         if (interlace_image == (Image *) NULL)           { (             FreeMemory(global_colormap);!             FreeMemory(colormap); N             WriterExit(ResourceLimitWarning,"Memory allocation failed",image);           }          i=0;&         for (pass=0; pass < 4; pass++)	         { "           y=interlace_start[pass];'           while (y < (int) image->rows)            { 8             p=GetPixelCache(image,0,y,image->columns,1);L             q=SetPixelCache(interlace_image,0,i,interlace_image->columns,1);K             if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))                break;B             (void) memcpy(interlace_image->indexes,image->indexes,2               image->columns*sizeof(IndexPacket));B             (void) memcpy(q,p,image->columns*sizeof(PixelPacket));1             if (!SyncPixelCache(interlace_image))                break;             i++;$             y+=interlace_rate[pass];           } 	         } *         interlace_image->file=image->file;O         status=EncodeImage(image_info,interlace_image,Max(bits_per_pixel,2)+1); ,         interlace_image->file=(FILE *) NULL;&         DestroyImage(interlace_image);       }      if (status == False)       { $         FreeMemory(global_colormap);         FreeMemory(colormap); J         WriterExit(ResourceLimitWarning,"Memory allocation failed",image);       }       (void) WriteByte(image,0x0);&     if (image->next == (Image *) NULL)       break;     image=GetNextImage(image);C     ProgressMonitor(SaveImagesText,scene++,GetNumberScenes(image));    } while (image_info->adjoin); /   (void) WriteByte(image,';'); /* terminator */    FreeMemory(global_colormap);   FreeMemory(colormap);    if (image_info->adjoin) -     while (image->previous != (Image *) NULL)        image=image->previous;   CloseBlob(image);    return(True);  } 