 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                        IIIII  PPPP   TTTTT   CCCC                           % O %                          I    P   P    T    C                               % O %                          I    PPPP     T    C                               % O %                          I    P        T    C                               % O %                        IIIII  P        T     CCCC                           % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s I P T C                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method IsIPTC returns True if the image format type, identified by the  %  magick string, is IPTC. % - %  The format of the ReadIPTCImage method is:  % 7 %      unsigned int IsIPTC(const unsigned char *magick, # %        const unsigned int length)  % + %  A description of each parameter follows:  % L %    o status:  Method IsIPTC returns True if the image format type is IPTC. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */7 Export unsigned int IsIPTC(const unsigned char *magick,    const unsigned int length) {    if (length < 2)      return(False);1   if (strncmp((char *) magick,"\034\002",2) == 0)      return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d I P T C I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Method ReadIPTCImage reads an image file in the IPTC format and returns it.N %  It allocates the memory necessary for the new Image structure and returns aH %  pointer to the new image.  This method differs from the other decoderE %  methods in that only the iptc profile information is useful in the  %  returned image. % - %  The format of the ReadIPTCImage method is:  % 8 %      Image *ReadIPTCImage(const ImageInfo *image_info) % + %  A description of each parameter follows:  % H %    o image:  Method ReadIPTCImage returns a pointer to the image afterL %      reading. A null image is returned if there is a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 Export Image *ReadIPTCImage(const ImageInfo *image_info) {    Image      *image;      int      c;     register unsigned char     *q;      unsigned char 
     *data;     unsigned int     tag_length,      length,      status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*     Read IPTC image.   */   length=MaxTextExtent;    tag_length=12;   data=(unsigned char *)5     AllocateMemory((length+2)*sizeof(unsigned char)); %   if (data == (unsigned char *) NULL) F     WriterExit(ResourceLimitWarning,"Memory allocation failed",image);C   (void) memcpy((char *) data,"8BIM\04\04\0\0\0\0\0\0",tag_length); 	   q=data;    q+=tag_length;   while (1)    {      c=ReadByte(image);     if (c == EOF)        break;#     if ((q-data+1) >= (int) length)        { *         image->iptc_profile.length=q-data;         length<<=1; 8         data=(unsigned char *) ReallocateMemory((char *)1           data,(length+2)*sizeof(unsigned char)); +         if (data == (unsigned char *) NULL)            break;*         q=data+image->iptc_profile.length;       }      *q++=(unsigned char) c;    }    image->iptc_profile.length=0; %   if (data != (unsigned char *) NULL)      { (       image->iptc_profile.length=q-data;3       length=image->iptc_profile.length-tag_length;        data[10]=length >> 8;        data[11]=length & 0xff; $       image->iptc_profile.info=data;     }    CloseBlob(image);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e I P T C I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % < %  Method WriteIPTCImage writes an image in the IPTC format. % ! %  Contributed by Bill Radcliffe.  % . %  The format of the WriteIPTCImage method is: % L %      unsigned int WriteIPTCImage(const ImageInfo *image_info,Image *image) % + %  A description of each parameter follows.  % I %    o status: Method WriteIPTCImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */  ; static long GetIPTCStream(unsigned char **info,long length)  {    register unsigned char     *p;      unsigned char      c;     unsigned int     info_length,     marker,      tag_length;      /*(     Find the beginning of the IPTC info.   */   p=(*info);   tag_length=0;    info_length=0;   marker=False;    while (length > 0)   { 
     c=(*p++); 
     length--;      if (length <= 0)
       break;       if (c == 0x1c)       {          p--;5         *info=p; /* let the caller know were it is */          break;       }    }    /**     Determine the length of the IPTC info.   */   while (length > 0)   { 
     c=(*p++); 
     length--;      if (length <= 0)
       break;       if (c == 0x1c)       marker=True;     else       if (marker)          break;  
       else         continue;      info_length++;     /*B       Found the 0x1c tag; skip the dataset and record number tags.     */     p++; /* dataset */
     length--;      if (length <= 0)
       break;       info_length++;     p++; /* record number */
     length--;      if (length <= 0)
       break;       info_length++;     /*N       Then we decode the length of the block that follows - long or short fmt.     */
     c=(*p++); 
     length--;      if (length <= 0)
       break;       info_length++;!     if (c & (unsigned char) 0x80)        {          unsigned char            buffer[4];           int            i;           for (i=0; i < 4; i++) 	         {            buffer[i]=(*p++);            length--;            if (length <= 0)             break;             info_length++;	         } L         tag_length=(((long) buffer[0]) << 24) | (((long) buffer[1]) << 16) |;           (((long) buffer[2]) << 8) | (((long) buffer[3]));        }      else       { #         tag_length=((long) c) << 8;          c=(*p++);          length--;          if (length <= 0)           break;           info_length++;         tag_length|=(long) c;        }      p+=tag_length;     length-=tag_length;      info_length+=tag_length;     }    return(info_length); }   L Export unsigned int WriteIPTCImage(const ImageInfo *image_info,Image *image) {    unsigned int     status;      unsigned char 
     *info;     long     length;   &   if (image->iptc_profile.length == 0)B     WriterExit(FileOpenWarning,"No IPTC profile available",image);    info=image->iptc_profile.info;$   length=image->iptc_profile.length;%   length=GetIPTCStream(&info,length);    if (length <= 0)?     WriterExit(FileOpenWarning,"No IPTC info was found",image);    /*     Open image file.   */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);,   (void) WriteBlob(image,(int) length,info);   CloseBlob(image);    return(True);  } 