 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                     L       AAA   BBBB   EEEEE  L                           % O %                     L      A   A  B   B  E      L                           % O %                     L      AAAAA  BBBB   EEE    L                           % O %                     L      A   A  B   B  E      L                           % O %                     LLLLL  A   A  BBBB   EEEEE  LLLLL                       % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h" #if defined(HasX11)  #include "xwindows.h"  #endif #if defined(HasTTF)  #include "freetype.h"  #endif   /*   Font declaration.  */ Export const char I   *DefaultXFont = "-adobe-helvetica-medium-r-*-*-14-*-*-*-*-*-iso8859-*";    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d L A B E L I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method ReadLABELImage reads a LABEL image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadLABELImage method is: % 9 %      Image *ReadLABELImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % I %    o image:  Method ReadLABELImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */  0 static char *EscapeParenthesis(const char *text) {    int      escapes;     register char      *p;      register int     i;  
   static char      buffer[MaxTextExtent];     escapes=0;   p=buffer; G   for (i=0; i < Min((int) strlen(text),(MaxTextExtent-escapes-1)); i++)    { -     if ((text[i] == '(') || (text[i] == ')'))        {          *p++='\\';         escapes++;       }      *p++=text[i];    } 
   *p='\0';   return(buffer);  }    #if defined(HasTTF) I static void GetFontInfo(TT_Face face,TT_Face_Properties *face_properties,    Image *image)  {    char
     *name;     static const unsigned short      ids[] = { 4, 5, 0, 7 };      register char      *p;      register int     i,     j;     unsigned short
     encoding,      id, 
     language,      length, 
     platform;      /*$     Note font info as image comment.   */&   if (face_properties->num_Names == 0)     return;    image->label=(char *) L     AllocateMemory((face_properties->num_Names*MaxTextExtent)*sizeof(char));$   if (image->label == (char *) NULL)     return;    *image->label='\0'; @   for (i=0; i < (int) (sizeof(ids)/sizeof(unsigned short)); i++)   { B     TT_Get_Name_ID(face,ids[i],&platform,&encoding,&language,&id);/     if (((platform != 0) || (language != 0)) && M         ((platform != 3) || (encoding > 1) || ((language & 0x3FF) != 0x009)))        continue; 2     TT_Get_Name_String(face,ids[i],&name,&length);(     p=image->label+strlen(image->label);8     for (j=1; j < (int) Min(length,MaxTextExtent); j+=2)       *p++=name[j];      *p='\0';
     break;   } 1   image->label=(char *) ReallocateMemory((char *) 8     image->label,(strlen(image->label)+1)*sizeof(char)); }   G static void RenderGlyph(TT_Raster_Map *canvas,TT_Raster_Map *character, K   TT_Glyph glyph,int x_offset,int y_offset,TT_Glyph_Metrics *glyph_metrics)  {    int      y;     register int     i,     x;     register unsigned char     *p,      *q;   
   SegmentInfo      bounds;      /*     Render Glyph.    */(   q=(unsigned char *) character->bitmap;%   for (i=0; i < character->size; i++)      *q++=0; H   TT_Get_Glyph_Pixmap(glyph,character,-(glyph_metrics->bbox.xMin & -64),'     -(glyph_metrics->bbox.yMin & -64));    /*"     Composite character on canvas.   */0   x_offset+=(glyph_metrics->bbox.xMin & -64)/64;;   y_offset=(-(glyph_metrics->bbox.yMin & -64)/64)-y_offset; )   bounds.x1=x_offset < 0 ? -x_offset : 0; )   bounds.y1=y_offset < 0 ? -y_offset : 0; "   bounds.x2=canvas->cols-x_offset;"   if (bounds.x2 > character->cols)     bounds.x2=character->cols;"   bounds.y2=canvas->rows-y_offset;"   if (bounds.y2 > character->rows)     bounds.y2=character->rows;   if (bounds.x1 >= bounds.x2)      return; 3   for (y=(int) bounds.y1; y < (int) bounds.y2; y++)    { N     p=((unsigned char *) character->bitmap)+y*character->cols+(int) bounds.x1;C     q=((unsigned char *) canvas->bitmap)+(y+y_offset)*canvas->cols+        (int) bounds.x1+x_offset; /     for (x=(int) bounds.x1; x < bounds.x2; x++)        *q++|=(*p++);    }  }  #endif  9 Export Image *ReadLABELImage(const ImageInfo *image_info)  {  #define MaxGlyphs  65535     char     filename[MaxTextExtent],     geometry[MaxTextExtent],     text[MaxTextExtent],     page[MaxTextExtent];  
   PixelPacket      pen_color;     FILE
     *file;     Image      *image;      ImageInfo      *local_info;     int      y;     RectangleInfo      crop_info;     register int     x;     register PixelPacket     *p,      *q;   
   PixelPacket      corner;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Create image label.    */(   local_info=CloneImageInfo(image_info);(   if (local_info->font == (char *) NULL)7     (void) CloneString(&local_info->font,DefaultXFont); +   (void) strcpy(text,local_info->filename); 0   (void) QueryColorDatabase("black",&pen_color);'   if (local_info->pen != (char *) NULL) :     (void) QueryColorDatabase(local_info->pen,&pen_color);   if (*local_info->font == '@')      {  #if defined(HasTTF) 
       char         *path,         *path_end;  	       int          character_map,         length,          number_glyphs;         register int
         i;         register unsigned char         *p;          TT_CharMap         char_map;          TT_Engine          engine;          TT_Error         error;  
       TT_Face 
         face;          TT_Face_Properties         face_properties;         TT_Glyph         *glyphs;         TT_Glyph_Metrics         glyph_metrics;         TT_Instance          instance;          TT_Instance_Metrics          instance_metrics;          TT_Raster_Map          canvas,          character;         TT_UShort 
         code;          unsigned short         encoding,          platform,          *unicode;          /*         Initialize font engine.        */&       error=TT_Init_FreeType(&engine);       if (error)I         ReaderExit(DelegateWarning,"Cannot initialize TTF engine",image);        /**         Search for Truetype font filename.       */       error=True; "       path=getenv("TT_FONT_PATH");        if (path != (char *) NULL)	         {            /*.             Environment variable TT_FONT_PATH.           */           for ( ; ; )            { 9             path_end=strchr(path,DirectoryListSeparator); *             if (path_end == (char *) NULL)+               (void) strcpy(filename,path);              else               { (                 i=(int) (path_end-path);0                 (void) strncpy(filename,path,i);!                 filename[i]='\0';                }              i=strlen(filename); A             if ((i > 0) && (!IsBasenameSeparator(filename[i-1]))) 9               (void) strcat(filename,DirectorySeparator); 7             (void) strcat(filename,local_info->font+1); 6             error=TT_Open_Face(engine,filename,&face);M             if (!error || (path_end == (char *) NULL) || (*path_end == '\0'))                break;             path=path_end+1;           }         } #if defined(TT_FONT_PATH)        if (error)	         {            /**             Configured Truetype font path.           */           path=TT_FONT_PATH;           for ( ; ; )            { 9             path_end=strchr(path,DirectoryListSeparator); *             if (path_end == (char *) NULL)+               (void) strcpy(filename,path);              else               { '                 i=(int)(path_end-path); 0                 (void) strncpy(filename,path,i);!                 filename[i]='\0';                }              i=strlen(filename); A             if ((i > 0) && (!IsBasenameSeparator(filename[i-1]))) 9               (void) strcat(filename,DirectorySeparator); 7             (void) strcat(filename,local_info->font+1); 6             error=TT_Open_Face(engine,filename,&face);M             if (!error || (path_end == (char *) NULL) || (*path_end == '\0'))                break;             path=path_end+1;           } 	         }  #endif       if (error)<         error=TT_Open_Face(engine,local_info->font+1,&face);       if (error)	         {            /*             Use default font.            */B           MagickWarning(DelegateWarning,"Unable to open TTF font",              local_info->font+1);           DestroyImage(image);=           (void) CloneString(&local_info->font,DefaultXFont); +           image=ReadLABELImage(local_info); '           DestroyImageInfo(local_info);            return(image);	         } 4       TT_Get_Face_Properties(face,&face_properties);%       if (strcmp(text,Alphabet) == 0) 1         GetFontInfo(face,&face_properties,image); ,       error=TT_New_Instance(face,&instance);G       if ((image->x_resolution == 0.0) || (image->y_resolution == 0.0)) 	         { #           image->x_resolution=96.0; #           image->y_resolution=96.0; 	         } B       error|=TT_Set_Instance_Resolutions(instance,(unsigned short)B         image->x_resolution,(unsigned short) image->y_resolution);
       error|= N         TT_Set_Instance_CharSize(instance,(int) (64.0*local_info->pointsize));       if (error)K         ReaderExit(DelegateWarning,"Cannot initialize TTF instance",image); K       for (code=0; (int) code < (int) face_properties.num_CharMaps; code++)        { 9         TT_Get_CharMap_ID(face,code,&platform,&encoding); 3         if (((platform == 3) && (encoding == 1)) || 1             ((platform == 0) && (encoding == 0)))            { 0             TT_Get_CharMap(face,code,&char_map);             break;           }        }        number_glyphs=0;       character_map=True; /       if (code == face_properties.num_CharMaps) 	         { 8           TT_Get_Face_Properties(face,&face_properties);3           number_glyphs=face_properties.num_Glyphs;            character_map=False;	         } E       glyphs=(TT_Glyph *) AllocateMemory(MaxGlyphs*sizeof(TT_Glyph)); &       if (glyphs == (TT_Glyph *) NULL)E         ReaderExit(DelegateWarning,"Memory allocation failed",image); #       for (i=0; i < MaxGlyphs; i++) &         glyphs[i].z=(TT_Glyph *) NULL;1       unicode=ConvertTextToUnicode(text,&length); -       if (unicode == (unsigned short *) NULL) E         ReaderExit(DelegateWarning,"Memory allocation failed",image);         for (i=0; i < length; i++)       { 6         if (glyphs[unicode[i]].z != (TT_Glyph *) NULL)           continue;          if (character_map)2           code=TT_Char_Index(char_map,unicode[i]);         else           { M             code=((int) unicode[i]-' '+1) < 0 ? 0 : ((int) unicode[i]-' '+1); ,             if ((int) code >= number_glyphs)               code=0;            } 5         error=TT_New_Glyph(face,&glyphs[unicode[i]]); >         error|=TT_Load_Glyph(instance,glyphs[unicode[i]],code,2           TTLOAD_SCALE_GLYPH | TTLOAD_HINT_GLYPH);         if (error)J           ReaderExit(DelegateWarning,"Cannot initialize TTF glyph",image);       } 4       TT_Get_Face_Properties(face,&face_properties);:       TT_Get_Instance_Metrics(instance,&instance_metrics);       canvas.width=0;         for (i=0; i < length; i++)       { 6         if (glyphs[unicode[i]].z == (TT_Glyph *) NULL)           continue; @         TT_Get_Glyph_Metrics(glyphs[unicode[i]],&glyph_metrics);/         canvas.width+=glyph_metrics.advance/64;        } )       canvas.width=(canvas.width+3) & -4; P       canvas.rows=instance_metrics.y_ppem*(face_properties.horizontal->Ascender-/         face_properties.horizontal->Descender)/ -         face_properties.header->Units_Per_EM;        canvas.flow=TT_Flow_Down;        canvas.cols=canvas.width; +       canvas.size=canvas.rows*canvas.width; 9       canvas.bitmap=(void *) AllocateMemory(canvas.size);        if (!canvas.bitmap) E         ReaderExit(DelegateWarning,"Memory allocation failed",image); (       p=(unsigned char *) canvas.bitmap;%       for (i=0; i < canvas.size; i++)          *p++=0; !       character.rows=canvas.rows; :       character.width=(instance_metrics.x_ppem+32+3) & -4;"       character.flow=TT_Flow_Down;%       character.cols=character.width; 4       character.size=character.rows*character.width;?       character.bitmap=(void *) AllocateMemory(character.size);        if (!character.bitmap)E         ReaderExit(DelegateWarning,"Memory allocation failed",image); 
       x=0;I       y=(-instance_metrics.y_ppem*face_properties.horizontal->Descender)/ /         face_properties.header->Units_Per_EM+1;         for (i=0; i < length; i++)       { 6         if (glyphs[unicode[i]].z == (TT_Glyph *) NULL)           continue; @         TT_Get_Glyph_Metrics(glyphs[unicode[i]],&glyph_metrics);N         RenderGlyph(&canvas,&character,glyphs[unicode[i]],x,y,&glyph_metrics);$         x+=glyph_metrics.advance/64;       }        /**         Render label with a TrueType font.       */       image->matte=True;"       image->columns=canvas.width;       image->rows=canvas.rows;(       p=(unsigned char *) canvas.bitmap;+       for (y=0; y < (int) image->rows; y++)        { 4         q=SetPixelCache(image,0,y,image->columns,1);&         if (q == (PixelPacket *) NULL)           break;0         for (x=0; x < (int) image->columns; x++)	         {            q->red=pen_color.red; #           q->green=pen_color.green; !           q->blue=pen_color.blue; $           if (local_info->antialias)2             q->opacity=(int) (Opaque*Min(*p,4))/4;           else7             q->opacity=(*p) > 1 ? Opaque : Transparent; (           if (q->opacity == Transparent)
             {                q->red=(~q->red); #               q->green=(~q->green); !               q->blue=(~q->blue); 
             }            p++;           q++;	         } #         if (!SyncPixelCache(image))            break;&         if ((image->columns % 2) != 0)           p++;       }        /*          Free TrueType resources.       */        FreeMemory(canvas.bitmap);#       FreeMemory(character.bitmap); #       for (i=0; i < MaxGlyphs; i++) !         TT_Done_Glyph(glyphs[i]);        FreeMemory(glyphs);        FreeMemory(unicode);!       TT_Done_Instance(instance);        TT_Close_Face(face);       TT_Done_FreeType(engine); #       DestroyImageInfo(local_info);        return(image); #else O       MagickWarning(MissingDelegateWarning,"FreeType library is not available",          (char *) NULL);  #endif     }    if (*local_info->font == '-')      {  #if defined(HasX11) 	       int          status;          static Display$         *display = (Display *) NULL;         static ImageInfo         cache_info;          static XAnnotateInfo         annotate_info;         static XFontStruct         *font_info;          static XPixelInfo          pixel;         static XResourceInfo         resource_info;         static XrmDatabase         resource_database;         static XStandardColormap         *map_info;         static XVisualInfo         *visual_info;          /*!         Allocate image structure.        */&       if (display == (Display *) NULL)	         {            /*%             Open X server connection.            */8           display=XOpenDisplay(local_info->server_name);*           if (display != (Display *) NULL)
             {                char                 *client_name;                  /*;                 Get user defaults from X resource database.                */'               XSetErrorHandler(XError); 7               client_name=SetClientName((char *) NULL); J               resource_database=XGetResourceDatabase(display,client_name);M               XGetResourceInfo(resource_database,client_name,&resource_info); /               resource_info.close_server=False; 5               resource_info.colormap=PrivateColormap; B               resource_info.font=AllocateString(local_info->font);E               resource_info.background_color=AllocateString("black"); E               resource_info.foreground_color=AllocateString("white"); 0               map_info=XAllocStandardColormap();9               if (map_info == (XStandardColormap *) NULL) K                 ReaderExit(ResourceLimitWarning,"Memory allocation failed",                    image);                /*'                 Initialize visual info.                */K               visual_info=XBestVisualInfo(display,map_info,&resource_info); 6               if (visual_info == (XVisualInfo *) NULL)H                 ReaderExit(XServerWarning,"Unable to get visual",image);1               map_info->colormap=(Colormap) NULL; 2               pixel.pixels=(unsigned long *) NULL;.               pixel.gamma_map=(XColor *) NULL;               /*2                 Initialize Standard Colormap info.               */?               XGetMapInfo(visual_info,XDefaultColormap(display, /                 visual_info->screen),map_info); J               XGetPixelPacket(display,visual_info,map_info,&resource_info,'                 (Image *) NULL,&pixel); %               pixel.annotate_context= 8                 XDefaultGC(display,visual_info->screen);               /*%                 Initialize font info.                */@               font_info=XBestFont(display,&resource_info,False);4               if (font_info == (XFontStruct *) NULL)G                 ReaderExit(XServerWarning,"Unable to load font",image); =               if ((map_info == (XStandardColormap *) NULL) || :                   (visual_info == (XVisualInfo *) NULL) ||6                   (font_info == (XFontStruct *) NULL))                 { E                   XFreeResources(display,visual_info,map_info,&pixel, C                     font_info,&resource_info,(XWindowInfo *) NULL); +                   display=(Display *) NULL;                  } '               cache_info=(*local_info); 
             } 	         } &       if (display == (Display *) NULL)	         {            /*             Use default font.            */A           MagickWarning(XServerWarning,"Unable to open X server", %             local_info->server_name);            DestroyImage(image);<           (void) CloneString(&local_info->font,"Helvetica");+           image=ReadLABELImage(local_info); '           DestroyImageInfo(local_info);            return(image);	         }        /*!         Initialize annotate info.        */'       XGetAnnotateInfo(&annotate_info); *       annotate_info.stencil=OpaqueStencil;.       if (cache_info.font != local_info->font)	         {            /*"             Font name has changed.           */'           XFreeFont(display,font_info); C           (void) CloneString(&resource_info.font,local_info->font); <           font_info=XBestFont(display,&resource_info,False);0           if (font_info == (XFontStruct *) NULL)I             ReaderExit(ResourceLimitWarning,"Unable to load font",image); 	         } (       annotate_info.font_info=font_info;       annotate_info.text=text;B       annotate_info.width=XTextWidth(font_info,text,Extent(text));@       annotate_info.height=font_info->ascent+font_info->descent;L       (void) sprintf(annotate_info.geometry,"%ux%u+0+0",annotate_info.width,         annotate_info.height);       cache_info=(*local_info);        /*,         Render label with a X11 server font.       */       image->matte=True;)       image->columns=annotate_info.width; '       image->rows=annotate_info.height; 2       image->background_color=image->border_color;A       status=XAnnotateImage(display,&pixel,&annotate_info,image);        if (status == 0)J         ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);+       for (y=0; y < (int) image->rows; y++)        { 4         q=GetPixelCache(image,0,y,image->columns,1);&         if (q == (PixelPacket *) NULL)           break;0         for (x=0; x < (int) image->columns; x++)	         { #           q->opacity=Intensity(*q);            q->red=pen_color.red; #           q->green=pen_color.green; !           q->blue=pen_color.blue; (           if (q->opacity == Transparent)
             {                q->red=(~q->red); #               q->green=(~q->green); !               q->blue=(~q->blue); 
             }            q++;	         } #         if (!SyncPixelCache(image))            break;       } #       DestroyImageInfo(local_info);        return(image); #else J       MagickWarning(MissingDelegateWarning,"X11 library is not available",         (char *) NULL);  #endif     }    /*(     Render label with a Postscript font.   */$   local_info->density=(char *) NULL;#   (void) sprintf(page,"%ux%u+0+0!", <     (unsigned int) ceil(local_info->pointsize*Extent(text)),2     (unsigned int) ceil(2*local_info->pointsize));-   (void) CloneString(&local_info->page,page);    TemporaryFilename(filename);'   file=fopen(filename,WriteBinaryType);    if (file == (FILE *) NULL)<     ReaderExit(FileOpenWarning,"Unable to open file",image);+   (void) fprintf(file,"%%!PS-Adobe-3.0\n"); )   (void) fprintf(file,"/ReencodeFont\n");    (void) fprintf(file,"{\n"); 1   (void) fprintf(file,"  findfont dup length\n");    (void) fprintf(file,H     "  dict begin { 1 index /FID ne {def} {pop pop} ifelse } forall\n");   (void) fprintf(file,J     "  /Encoding ISOLatin1Encoding def currentdict end definefont pop\n");&   (void) fprintf(file,"} bind def\n");   (void) fprintf(file,M     "/%.1024s-ISO dup /%.1024s ReencodeFont findfont %f scalefont setfont\n", =     local_info->font,local_info->font,local_info->pointsize); 3   (void) fprintf(file,"0.0 0.0 0.0 setrgbcolor\n"); -   (void) fprintf(file,"0 0 %u %u rectfill\n", <     (unsigned int) ceil(local_info->pointsize*Extent(text)),2     (unsigned int) ceil(2*local_info->pointsize));3   (void) fprintf(file,"1.0 1.0 1.0 setrgbcolor\n"); K   (void) fprintf(file,"0 %f moveto (%.1024s) show\n",local_info->pointsize,      EscapeParenthesis(text)); $   (void) fprintf(file,"showpage\n");   (void) fclose(file);/   (void) strcpy(local_info->filename,filename);    DestroyImage(image);    image=ReadPSImage(local_info);   (void) remove(filename);   /*-     Set bounding box to the image dimensions.    */   crop_info.width=0;/   crop_info.height=ceil(local_info->pointsize);    crop_info.x=0;&   crop_info.y=local_info->pointsize/4;   DestroyImageInfo(local_info);    if (image == (Image *) NULL)     return(image);   corner.red=0;    corner.green=0;    corner.blue=0;'   for (y=0; y < (int) image->rows; y++)    { 0     p=GetPixelCache(image,0,y,image->columns,1);"     if (p == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     { #       if (!ColorMatch(*p,corner,0)) &         if (x > (int) crop_info.width)           crop_info.width=x;
       p++;     }    }    crop_info.width++;I   (void) sprintf(geometry,"%ux%u%+d%+d",crop_info.width,crop_info.height,      crop_info.x,crop_info.y); 0   TransformImage(&image,geometry,(char *) NULL);   image->matte=True;'   for (y=0; y < (int) image->rows; y++)    { 0     q=GetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     {        q->opacity=Intensity(*q);        q->red=pen_color.red;        q->green=pen_color.green;        q->blue=pen_color.blue; $       if (q->opacity == Transparent)	         {            q->red=(~q->red);            q->green=(~q->green);            q->blue=(~q->blue); 	         } 
       q++;     }      if (!SyncPixelCache(image))        break;   }    return(image); } 