 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            M   M   AAA    CCCC                              % O %                            MM MM  A   A  C                                  % O %                            M M M  AAAAA  C                                  % O %                            M   M  A   A  C                                  % O %                            M   M  A   A   CCCC                              % O %                                                                             % O %                                                                             % O %                   Macintosh Utility Methods for ImageMagick                 % O %                                                                             % O %                                                                             % O %                               Software Design                               % O %                                 John Cristy                                 % O %                                September 1996                               % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  The directory methods are strongly based on similar methods writtenL %  by Steve Summit, scs@eskimo.com.  The Ghostscript launch code is strongly7 %  based on Dave Schooley's Mac Gnuplot and provided by H %  schindall@wave14i.nrl.navy.mil.  Mac-centric improvements provided by %  leonardr@digapp.com.  %  %  */   #if defined(macintosh) /*   Include declarations.  */ #define _X_H #define _WIDGET_H  #include "magick.h"  #include "defines.h" #include "mac.h" #include <AppleEvents.h> #include <AERegistry.h>  #include <AEObjects.h> #include <AEPackObject.h>  #include <Processes.h> #include <QuickDraw.h> #include <QDOffscreen.h> #include <Palettes.h>  #include <ImageCompression.h>  #include <PictUtils.h> #include <Files.h> #include <Gestalt.h> #include <TextUtils.h>   /*   Global declaractions.  */ ImageDescriptionHandle   image_description = nil;   /*   Forward declaractions. */ static Boolean.   SearchForFile(OSType,OSType,FSSpec *,short);   static pascal void)   ArcMethod(GrafVerb,Rect *,short,short), 5   BitsMethod(BitMap *,Rect *,Rect *,short,RgnHandle), 8   FilenameToFSSpec(const char *filename,FSSpec *fsspec),   LineMethod(Point),   OvalMethod(GrafVerb,Rect *),"   PolyMethod(GrafVerb,PolyHandle),+   RRectMethod(GrafVerb,Rect *,short,short),    RectMethod(GrafVerb,Rect *),#   RegionMethod(GrafVerb,RgnHandle), L   StandardPixmap(PixMapPtr,Rect *,MatrixRecordPtr,short,RgnHandle,PixMapPtr,     Rect *,short),$   TextMethod(short,Ptr,Point,Point);   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   B o t t l e n e c k T e s t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % : %  Method BottleneckTest intercepts any compressed images. % . %  The format of the BottleneckTest method is: % 2 %      int ImageFormatConflict(const char *magick) % + %  A description of each parameter follows:  % = %    o picture: Specifies a pointer to a PicHandle structure.  % L %    o codec: The code type is returned in this CodecType pointer structure. % @ %    o depth: The image depth is returned as an integer pointer. % F %    o colormap_id: The colormap ID is returned in this short pointer. %  %  */  D static pascal void ArcMethod(GrafVerb verb,Rect *r,short startAngle,   short arcAngle)  { + #pragma unused (verb,r,startAngle,arcAngle)  }   D static pascal void BitsMethod(BitMap *bitPtr,Rect *source_rectangle,-   Rect *dstRect,short mode,RgnHandle maskRgn)  { = #pragma unused (bitPtr,source_rectangle,dstRect,mode,maskRgn)  }   * static pascal void LineMethod(Point newPt) {  #pragma unused (newPt) }   4 static pascal void OvalMethod(GrafVerb verb,Rect *r) {  #pragma unused (verb,r)  }   < static pascal void PolyMethod(GrafVerb verb,PolyHandle poly) {  #pragma unused (verb,poly) }   4 static pascal void RectMethod(GrafVerb verb,Rect *r) {  #pragma unused (verb,r)  }   < static pascal void RegionMethod(GrafVerb verb,RgnHandle rgn) {  #pragma unused (verb,rgn)  }   E static pascal void RRectMethod(GrafVerb verb,Rect *r,short ovalWidth,    short ovalHeight)  { , #pragma unused (verb,r,ovalWidth,ovalHeight) }   J static pascal void StandardPixmap(PixMapPtr source,Rect *source_rectangle,C   MatrixRecordPtr matrix,short mode,RgnHandle mask,PixMapPtr matte, $   Rect *matte_rectangle,short flags) { N #pragma unused (source_rectangle,matrix,mode,mask,matte,matte_rectangle,flags)     long	     size;      Ptr 	     data;   I   GetCompressedPixMapInfo(source,&image_description,&data,&size,nil,nil);  }   F static pascal void TextMethod(short byteCount,Ptr textBuf,Point numer,   Point denom) { . #pragma unused (byteCount,textBuf,numer,denom) }   J static short BottleneckTest(PicHandle picture,CodecType *codec,int *depth,   short *colormap_id)  { 
   CQDProcs     bottlenecks;     int      status;      long     version;     Rect     rectangle;  ,   status=Gestalt(gestaltQuickTime,&version);   if (status != noErr)     { N       ParamText("\pQuickTime not installed.  Please install, then try again.",         "\p", "\p", "\p" );        Alert(128,nil);        return(-1);      }    /*-     Define our own bottlenecks to do nothing.    */   SetStdCProcs(&bottlenecks); 2   bottlenecks.textProc=NewQDTextProc(&TextMethod);2   bottlenecks.lineProc=NewQDLineProc(&LineMethod);2   bottlenecks.rectProc=NewQDRectProc(&RectMethod);5   bottlenecks.rRectProc=NewQDRRectProc(&RRectMethod); 2   bottlenecks.ovalProc=NewQDOvalProc(&OvalMethod);/   bottlenecks.arcProc=NewQDArcProc(&ArcMethod); 2   bottlenecks.polyProc=NewQDPolyProc(&PolyMethod);2   bottlenecks.rgnProc=NewQDRgnProc(&RegionMethod);2   bottlenecks.bitsProc=NewQDBitsProc(&BitsMethod); #if GENERATINGCFM 6   bottlenecks.newProc1=NewStdPixProc(&StandardPixmap); #else 9   bottlenecks.newProc1=(UniversalProcPtr) StandardPixmap;  #endif   /*F     Install our custom bottlenecks to intercept any compressed images.   */5   (*(qd.thePort)).grafProcs=(QDProcs *) &bottlenecks; /   DrawPicture(picture,&((**picture).picFrame));    PaintRect(&rectangle);   (*(qd.thePort)).grafProcs=0L;    /*!     Initialize our return values.    */   *codec='unkn';   *depth=0;    *colormap_id=(-1);   if (image_description != nil)      { )       *codec=(**image_description).cType; )       *depth=(**image_description).depth; 0       *colormap_id=(**image_description).clutID;     }  #if GENERATINGCFM 1   DisposeRoutineDescriptor(bottlenecks.textProc); 1   DisposeRoutineDescriptor(bottlenecks.lineProc); 1   DisposeRoutineDescriptor(bottlenecks.rectProc); 2   DisposeRoutineDescriptor(bottlenecks.rRectProc);1   DisposeRoutineDescriptor(bottlenecks.ovalProc); 0   DisposeRoutineDescriptor(bottlenecks.arcProc);1   DisposeRoutineDescriptor(bottlenecks.polyProc); 0   DisposeRoutineDescriptor(bottlenecks.rgnProc);1   DisposeRoutineDescriptor(bottlenecks.bitsProc); 1   DisposeRoutineDescriptor(bottlenecks.newProc1);  #endif   return(0); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   c l o s e d i r                                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method closedir closes the named directory stream and frees the DIR
 %  structure.  % ( %  The format of the closedir method is: %  %      closedir(entry) % + %  A description of each parameter follows:  % 5 %    o entry: Specifies a pointer to a DIR structure.  %  %  */ void closedir(DIR *entry)  {     assert(entry != (DIR *) NULL);   FreeMemory((void *) entry);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   E x i t                                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ! %  Method Exit exits the process.  % $ %  The format of the Exit method is: %  %      Exit(status)  % + %  A description of each parameter follows:  % J %    o status: an integer value representing the status of the terminating %      process.  %  %  */ int Exit(int status) { 8   (void) fprintf(stderr,"Select File->Quit to exit.\n");   exit(status);    return(0); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   F i l e n a m e T o F S S p e c                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % : %  Method FilenameToFSSpec sets the file type of an image. % 0 %  The format of the FilenameToFSSpec method is: % ( %      FilenameToFSSpec(filename,fsspec) % + %  A description of each parameter follows:  % 0 %    o filename: Specifies the name of the file. % ( %    o fsspec: A pointer to type FSSpec. %  %  */A void pascal FilenameToFSSpec(const char *filename,FSSpec *fsspec)  {    Str255	     name;   $   assert(filename != (char *) NULL);(   (void) strcpy((char *) name,filename);   c2pstr((char *) name);    FSMakeFSSpec(0,0,name,fsspec); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I m a g e F o r m a t C o n f l i c t                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method ImageFormatConflict returns true if the image format conflicts with  %  a logical drive (.e.g. X:). % : %  Contributed by Mark Gavin of Digital Applications, Inc. % 3 %  The format of the ImageFormatConflict method is:  % ) %      status=ImageFormatConflict(magick)  % + %  A description of each parameter follows:  % J %    o status: Method ImageFormatConflict returns true if the image format& %      conflicts with a logical drive. % * %    o magick: Specifies the image format. %  %  */2 Export int ImageFormatConflict(const char *magick) {    long     number_bytes;      OSErr      status,      volume;      short 
     index;     Str255     volume_name;     StringPtr      p;  "   assert(magick != (char *) NULL);   p=(StringPtr) &volume_name;    for (index=(-1); ; index--)    { 3     status=GetVInfo(index,p,&volume,&number_bytes);      if (status)        return(False);-     if (Latin1Compare(p2cstr(p),magick) == 0)        return(True);    }    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   M A C E r r o r H a n d l e r                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method MACErrorHandler displays an error message and then terminates  %  the program.  % / %  The format of the MACErrorHandler method is:  % I %      void MACErrorHandler(const unsigned int error,const char *message,  %        const char *qualifier)  % + %  A description of each parameter follows:  % 3 %    o error: Specifies the numeric error category.  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */I Export void MACErrorHandler(const unsigned int error,const char *message,    const char *qualifier) {    char     buffer[3*MaxTextExtent];     if (message == (char *) NULL)      Exit(0);,   if ((qualifier != (char *) NULL) && errno)B     FormatString(buffer,"%.1024s: %.1024s (%.1024s) [%.1024s].\n",F       SetClientName((char *) NULL),message,qualifier,strerror(errno));   else#     if (qualifier != (char *) NULL) :       FormatString(buffer,"%.1024s: %.1024s (%.1024s).\n",8         SetClientName((char *) NULL),message,qualifier);     else       if (errno)<         FormatString(buffer,"%.1024s: %.1024s [%.1024s].\n",@           SetClientName((char *) NULL),message,strerror(errno));
       elseO         FormatString(buffer,"%.1024s: %.1024s.\n",SetClientName((char *) NULL),            message);    puts(buffer); 
   Exit(0); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   M a c G S E x e c u t e C o m m a n d                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ? %  Method MacGSExecuteCommand executes the Ghostscript command.  %  %  */A static OSErr MacGSExecuteCommand(const char *command,long length)  {    AEAddressDesc      event_descriptor;      AEDesc     reply = {typeNull, NULL};      AppleEvent     event = {typeNull, NULL};   
   DescType     descriptor_type;     int 
     error;     OSType     id = 'gsVR';     Size     actualSize;      /*     Send the Apple Event.    */J   (void) AECreateDesc(typeApplSignature,&id,sizeof(id),&event_descriptor);M   (void) AECreateAppleEvent(id,'exec',&event_descriptor,-1,kAnyTransactionID,      &event);G   (void) AEPutParamPtr(&event,keyDirectObject,typeChar,command,length); N   (void) AESend(&event,&reply,kAEWaitReply+kAENeverInteract,kAENormalPriority,     kNoTimeOut,NULL,NULL);   /*     Handle the reply and exit.   */K   (void) AEGetParamPtr(&reply,keyDirectObject,typeInteger,&descriptor_type, &     &error,sizeof(error),&actualSize);*   (void) AEDisposeDesc(&event_descriptor);   (void) AEDisposeDesc(&event); #   if (reply.descriptorType != NULL)      AEDisposeDesc(&reply);   return((OSErr) error); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   M a c G S L a u n c h A p p l i c a t i o n C o r e                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method MacGSLaunchApplicationCore launches the Ghostscript command. %  %  */3 static OSErr MacGSLaunchApplicationCore(long flags)  {    FSSpec     file_info;     LaunchParamBlockRec      launch_info;     OSErr 
     error;  1   if (!SearchForFile('gsVR','APPL',&file_info,1))      return(-43);*   launch_info.launchBlockID=extendedBlock;/   launch_info.launchEPBLength=extendedBlockLen;     launch_info.launchFileFlags=0;H   launch_info.launchControlFlags=launchContinue+launchNoFileFlags+flags;)   launch_info.launchAppSpec=(&file_info); &   launch_info.launchAppParameters=nil;(   error=LaunchApplication(&launch_info);   return(error); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   M a c G S L a u n c h A p p l i c a t i o n                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % B %  Method MacGSLaunchApplication launches the Ghostscript command. %  %  */) static OSErr MacGSLaunchApplication(void)  { 7   return(MacGSLaunchApplicationCore(launchDontSwitch));  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   M a c G S L a u n c h A p p l i c a t i o n T o F r o n t                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method MacGSLaunchApplicationToFront moves the Ghostscript window to the 	 %  front.  %  %  */0 static OSErr MacGSLaunchApplicationToFront(void) { (   return(MacGSLaunchApplicationCore(0)); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   M a c G S Q u i t A p p l i c a t i o n                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Method MacGSQuitApplication quits the Ghostscript application.  %  %  */& static void MacGSQuitApplication(void) {    AEAddressDesc      event_descriptor;      AEDesc     reply = {typeNull, NULL};      AppleEvent     event = {typeNull, NULL};      OSType     id = 'GPLT';     /*     Send the Apple Event.    */J   (void) AECreateDesc(typeApplSignature,&id,sizeof(id),&event_descriptor);>   (void) AECreateAppleEvent(typeAppleEvent,kAEQuitApplication,3     &event_descriptor,-1,kAnyTransactionID,&event); K   (void) AESend(&event,&reply,kAENoReply,kAENormalPriority,kNoTimeOut,NULL, 
     NULL);   /*     Clean up and exit.   */*   (void) AEDisposeDesc(&event_descriptor);   (void) AEDisposeDesc(&event); #   if (reply.descriptorType != NULL)      AEDisposeDesc(&reply); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   M a c G S S e t W o r k i n g F o l d e r                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Method MacGSSetWorkingFolder set the Ghostscript working folder.  %  %  */3 static OSErr MacGSSetWorkingFolder(char *directory)  {    AEDesc     application_descriptor,      event_descriptor,      object,      path_descriptor,     type_descriptor,
     reply;     AppleEvent
     event;  
   DescType     folder_type = 'wfdr';      OSErr 
     error;     OSType     id = 'GPLT';     /*     Send the Apple Event.    */8   AECreateDesc(typeNull,NULL,0,&application_descriptor);F   AECreateDesc(typeChar,directory,strlen(directory),&path_descriptor);O   (void) AECreateDesc(typeType,&folder_type,sizeof(DescType),&type_descriptor); F   CreateObjSpecifier(cProperty,&application_descriptor,formPropertyID,      &type_descriptor,0,&object);J   (void) AECreateDesc(typeApplSignature,&id,sizeof(id),&event_descriptor);I   (void) AECreateAppleEvent(kAECoreSuite,kAESetData,&event_descriptor,-1,      kAnyTransactionID,&event);8   (void) AEPutParamDesc(&event,keyDirectObject,&object);;   (void) AEPutParamDesc(&event,keyAEData,&path_descriptor); K   error=AESend(&event,&reply,kAENoReply+kAENeverInteract,kAENormalPriority,      kNoTimeOut,NULL,NULL);   (void) AEDisposeDesc(&event); *   (void) AEDisposeDesc(&event_descriptor);    (void) AEDisposeDesc(&object);)   (void) AEDisposeDesc(&type_descriptor); )   (void) AEDisposeDesc(&path_descriptor); 0   (void) AEDisposeDesc(&application_descriptor);   return(error); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   M A C S y s t e m C o m m a n d                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %   Method MACSystemCommand executes the specified command and waits until it F %   terminates.  The returned value is the exit status of the command. % 0 %  The format of the MACSystemCommand method is: % M %      void MACWarningHandler(const unsigned int warning,const char *message,  %        const char *qualifier)  % + %  A description of each parameter follows:  % 6 %    o command: This string is the command to execute. %  %  */* int MACSystemCommand(const char * command) {    /*+     We only know how to launch Ghostscript.    */&   if (MacGSLaunchApplicationToFront())     return(-1); 7   return(MacGSExecuteCommand(command,strlen(command)));  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   M A C W a r n i n g H a n d l e r                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 7 %  Method MACWarningHandler displays a warning message.  % 1 %  The format of the MACWarningHandler method is:  % 3 +      MACWarningHandler(warning,message,qualifier)  % + %  A description of each parameter follows:  % 7 %    o warning: Specifies the numeric warning category.  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */M Export void MACWarningHandler(const unsigned int warning,const char *message,    const char *qualifier) {    char     buffer[1664];      if (message == (char *) NULL)      return; !   if (qualifier == (char *) NULL) .     FormatString(buffer,"%.1024s: %.1024s.\n",,       SetClientName((char *) NULL),message);   else8     FormatString(buffer,"%.1024s: %.1024s (%.1024s).\n",6       SetClientName((char *) NULL),message,qualifier);   puts(buffer);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   o p e n d i r                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method opendir opens the directory named by filename and associates a %  directory stream with it. % ' %  The format of the opendir method is:  % 2 %      void ProcessPendingEvents(const char *text) % + %  A description of each parameter follows:  % 5 %    o entry: Specifies a pointer to a DIR structure.  %  %  */ DIR *opendir(char *path) {    char     pathname[1664];      CInfoPBRec     search_info;     DIR      *entry;      int 
     error;  $   search_info.hFileInfo.ioNamePtr=0;1   if ((path != (char *) NULL) || (*path != '\0')) .     if ((path[0] != '.') || (path[1] != '\0'))D       search_info.hFileInfo.ioNamePtr=c2pstr(strcpy(pathname,path));'   search_info.hFileInfo.ioCompletion=0; $   search_info.hFileInfo.ioVRefNum=0;&   search_info.hFileInfo.ioFDirIndex=0;"   search_info.hFileInfo.ioDirID=0;'   error=PBGetCatInfoSync(&search_info);    if (error != noErr)      {        errno=error;       return((DIR *) NULL);      } ,   entry=(DIR *) AllocateMemory(sizeof(DIR));   if (entry == (DIR *) NULL)     return((DIR *) NULL); 3   entry->d_VRefNum=search_info.hFileInfo.ioVRefNum; /   entry->d_DirID=search_info.hFileInfo.ioDirID;    entry->d_index=1;    return(entry); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   P r o c e s s P e n d i n g E v e n t s                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method ProcessPendingEvents processes any pending events.  This prevents / %  ImageMagick from monopolizing the processor.  % 4 %  The format of the ProcessPendingEvents method is: % ! %      ProcessPendingEvents(text)  % + %  A description of each parameter follows:  % A %    o text: A character string representing the current process.  %  %  */2 Export void ProcessPendingEvents(const char *text) { 
   static char      *mark = (char *) NULL;  
   EventRecord 
     event;  1   while (WaitNextEvent(everyEvent,&event,0L,nil))       SIOUXHandleOneEvent(&event);-   if (isatty(STDIN_FILENO) && (text != mark))      {        (void) puts(text);       mark=text;     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   r e a d d i r                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Method readdir returns a pointer to a structure representing the E %  directory entry at the current position in the directory stream to  %  which entry refers. %  %  The format of the readdir %  %      readdir(entry)  % + %  A description of each parameter follows:  % 5 %    o entry: Specifies a pointer to a DIR structure.  %  %  */" struct dirent *readdir(DIR *entry) {    CInfoPBRec     search_info;     int 
     error;     static struct dirent     dir_entry;     static unsigned char     pathname[1664];      if (entry == (DIR *) NULL)#     return((struct dirent *) NULL); '   search_info.hFileInfo.ioCompletion=0; +   search_info.hFileInfo.ioNamePtr=pathname; $   search_info.hFileInfo.ioVRefNum=0;3   search_info.hFileInfo.ioFDirIndex=entry->d_index; /   search_info.hFileInfo.ioDirID=entry->d_DirID; '   error=PBGetCatInfoSync(&search_info);    if (error != noErr)      {        errno=error;%       return((struct dirent *) NULL);      }    entry->d_index++; J   (void) strcpy(dir_entry.d_name,p2cstr(search_info.hFileInfo.ioNamePtr));.   dir_entry.d_namlen=strlen(dir_entry.d_name);   return(&dir_entry);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d P I C T I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method ReadPICTImage reads an Apple Macintosh QuickDraw/PICT image G %  file using MacOS QuickDraw methods and returns it.  It allocates the H %  memory necessary for the new Image structure and returns a pointer to %  the new image.  % F %  This method was written and contributed by spd@daphne.cps.unizar.es; %  (feel free to copy and use it as you want. No warranty).  % - %  The format of the ReadPICTImage method is:  % 2 %      void ProcessPendingEvents(const char *text) % + %  A description of each parameter follows:  % H %    o image:  Method ReadPICTImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */1 Image *ReadPICTImage(const ImageInfo *image_info)  { - #define LoadImageText  "  Loading image...  "  #define PICTHeaderSize    512 . #define PrematureExit(warning,message,image) \ { \ 3   MagickWarning(warning,message,image->filename); \    DestroyImages(image); \    return((Image *) NULL); \  }      CodecType 
     codec;  
   GDHandle     device;      GWorldPtr      graphic_world,	     port;      Image      *image;      int 
     depth,     status,      y;     PicHandle      picture_handle;   
   PictInfo     picture_info;      QDErr      theErr = noErr;      Rect     rectangle;     register int     x;     register PixelPacket     *q;   
   RGBColor
     Pixel;     short      colormap_id;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)?     PrematureExit(FileOpenWarning,"Unable to open file",image);    picture_handle=(PicHandle)B     NewHandle(Max(image->filesize-PICTHeaderSize,PICTHeaderSize));   if (picture_handle == nil)J     PrematureExit(ResourceLimitWarning,"Unable to allocate memory",image);!   HLock((Handle) picture_handle); B   (void) ReadBlob(image,PICTHeaderSize,*(char **) picture_handle);	   status= M     ReadBlob(image,image->filesize-PICTHeaderSize,*(char **) picture_handle);    if (status == False)     { -       DisposeHandle((Handle) picture_handle); K       PrematureExit(CorruptImageWarning,"Unable to read image data",image);      }    GetGWorld(&port,&device); I   theErr=NewGWorld(&graphic_world,0,&(**picture_handle).picFrame,nil,nil,      useTempMem|keepLocal);.   if (theErr != noErr && graphic_world == nil)     { -       DisposeHandle((Handle) picture_handle); L       PrematureExit(ResourceLimitWarning,"Unable to allocate memory",image);     } #   HUnlock((Handle) picture_handle);    SetGWorld(graphic_world,nil); F   theErr=GetPictInfo(picture_handle,&picture_info,0,1,systemMethod,0);   if (theErr != noErr)     { #       DisposeGWorld(graphic_world); -       DisposeHandle((Handle) picture_handle); K       PrematureExit(CorruptImageWarning,"Unable to read image data",image);      } <   BottleneckTest(picture_handle,&codec,&depth,&colormap_id);   switch (codec)   {      case 'rpza':     case 'jpeg':     case 'rle ':     case 'raw ':     case 'smc ':     {        if (depth > 32) 	         {            depth-=32;<           picture_info.theColorTable=GetCTable(colormap_id);	         }        break;     }      default:     {        depth=picture_info.depth;        if (depth <= 8) I         (void) GetPictInfo(picture_handle,&picture_info,returnColorTable, <           (short) (1 << picture_info.depth),systemMethod,0);       break;     }    } 0   image->x_resolution=(picture_info.hRes) >> 16;0   image->y_resolution=(picture_info.vRes) >> 16;'   image->units=PixelsPerInchResolution; L   image->columns=picture_info.sourceRect.right-picture_info.sourceRect.left;I   image->rows=picture_info.sourceRect.bottom-picture_info.sourceRect.top; E   if ((depth <= 8) && ((*(picture_info.theColorTable))->ctSize != 0))      {        /*         Colormapped PICT image.        */       image->class=PseudoClass; <       image->colors=(*(picture_info.theColorTable))->ctSize;%       image->colormap=(PixelPacket *) :         AllocateMemory(image->colors*sizeof(PixelPacket));2       if (image->colormap == (PixelPacket *) NULL)	         { 0           if (picture_info.theColorTable != nil)?             DisposeHandle((Handle) picture_info.theColorTable); '           DisposeGWorld(graphic_world); 1           DisposeHandle((Handle) picture_handle); P           PrematureExit(ResourceLimitWarning,"Unable to allocate memory",image);	         } '       for (x=0; x < image->colors; x++)        {          image->colormap[x].red= >           (*(picture_info.theColorTable))->ctTable[x].rgb.red;!         image->colormap[x].green= @           (*(picture_info.theColorTable))->ctTable[x].rgb.green;          image->colormap[x].blue=?           (*(picture_info.theColorTable))->ctTable[x].rgb.blue;        }      } 5   SetRect(&rectangle,0,0,image->columns,image->rows); 6   (void) UpdateGWorld(&graphic_world,depth,&rectangle,&     picture_info.theColorTable,nil,0);(   LockPixels(graphic_world->portPixMap);   EraseRect(&rectangle);)   DrawPicture(picture_handle,&rectangle); *   if ((depth <= 8) && (colormap_id == -1))     { 9       DisposeHandle((Handle) picture_info.theColorTable); %       picture_info.theColorTable=nil;      } )   DisposeHandle((Handle) picture_handle);    /*)     Convert PICT pixels to pixel packets.    */!   for (y=0; y < image->rows; y++)    { 0     q=SetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;&     for (x=0; x < image->columns; x++)     {        GetCPixel(x,y,&Pixel);'       q->red=UpScale(Pixel.red & 0xff); +       q->green=UpScale(Pixel.green & 0xff); )       q->blue=UpScale(Pixel.blue & 0xff); &       if (image->class == PseudoClass)?         image->indexes[x]=(unsigned short) Color2Index(&Pixel); 
       q++;     }      if (!SyncPixelCache(image))        break;#     if (QuantumTick(y,image->rows)) 3       ProgressMonitor(LoadImageText,y,image->rows);    } *   UnlockPixels(graphic_world->portPixMap);   SetGWorld(port,device); (   if (picture_info.theColorTable != nil)7     DisposeHandle((Handle) picture_info.theColorTable);    DisposeGWorld(graphic_world);    CloseBlob(image);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S e a r c h F o r F i l e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % , %  Method SearchForFile searches for a file. %  %  */O static Boolean SearchForFile(OSType creator_type,OSType file_type,FSSpec *file,    short count) {    char     *buffer;     CInfoPBRec     search1_info,      search2_info;      FSSpec     application;     HParamBlockRec     parameter_info;      long     buffer_size = 16384;     OSErr 
     error;     ProcessInfoRec     application_info;      ProcessSerialNumber      serial_number;  -   serial_number.lowLongOfPSN=kCurrentProcess;     serial_number.highLongOfPSN=0;<   application_info.processInfoLength=sizeof(ProcessInfoRec);$   application_info.processName=NULL;1   application_info.processAppSpec=(&application); :   GetProcessInformation(&serial_number,&application_info);   buffer=NewPtr(buffer_size);    if (buffer == (char *) NULL)     return(false);+   parameter_info.csParam.ioCompletion=NULL; (   parameter_info.csParam.ioNamePtr=NULL;7   parameter_info.csParam.ioVRefNum=application.vRefNum; )   parameter_info.csParam.ioMatchPtr=file; /   parameter_info.csParam.ioReqMatchCount=count; 5   parameter_info.csParam.ioSearchBits=fsSBFlFndrInfo; 5   parameter_info.csParam.ioSearchInfo1=&search1_info; 5   parameter_info.csParam.ioSearchInfo2=&search2_info; (   parameter_info.csParam.ioSearchTime=0;4   parameter_info.csParam.ioCatPosition.initialize=0;,   parameter_info.csParam.ioOptBuffer=buffer;2   parameter_info.csParam.ioOptBufSize=buffer_size;(   search1_info.hFileInfo.ioNamePtr=NULL;7   search1_info.hFileInfo.ioFlFndrInfo.fdType=file_type; =   search1_info.hFileInfo.ioFlFndrInfo.fdCreator=creator_type; &   search1_info.hFileInfo.ioFlAttrib=0;%   search1_info.hFileInfo.ioFlParID=0;    search2_info=search1_info;)   search2_info.hFileInfo.ioFlAttrib=0x10; =   search2_info.hFileInfo.ioFlFndrInfo.fdCreator=creator_type; 2   search2_info.hFileInfo.ioFlFndrInfo.fdType=(-1);0   search2_info.hFileInfo.ioFlFndrInfo.fdFlags=0;5   search2_info.hFileInfo.ioFlFndrInfo.fdLocation.h=0; 5   search2_info.hFileInfo.ioFlFndrInfo.fdLocation.v=0; /   search2_info.hFileInfo.ioFlFndrInfo.fdFldr=0; %   search2_info.hFileInfo.ioFlParID=0; 6   error=PBCatSearchSync((CSParamPtr) &parameter_info);   DisposePtr(buffer); /   if (parameter_info.csParam.ioReqMatchCount == -       parameter_info.csParam.ioActMatchCount)      error=eofErr; 2   if (parameter_info.csParam.ioActMatchCount == 0)     error=0;   return(error == eofErr); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   s e e k d i r                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Method seekdir sets the position of the next readdir() operation  %  on the directory stream.  % ' %  The format of the seekdir method is:  %  %      seekdir(entry,position) % + %  A description of each parameter follows:  % 5 %    o entry: Specifies a pointer to a DIR structure.  % E %    o position: specifies the position associated with the directory  %      stream. %  %  %  */& void seekdir(DIR *entry,long position) {     assert(entry != (DIR *) NULL);   entry->d_index=position; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S e t A p p l i c a t i o n T y p e                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % < %  Method SetApplicationType sets the file type of an image. % 2 %  The format of the SetApplicationType method is: % 6 %      SetApplicationType(filename,magick,application) % + %  A description of each parameter follows:  % 0 %    o filename: Specifies the name of the file. % ) %    o filename: Specifies the file type.  % : %    o application: Specifies the type of the application. %  %  */@ void SetApplicationType(const char *filename,const char *magick,   OSType application)  {    OSType
     filetype;      Str255	     name;   $   assert(filename != (char *) NULL);(   (void) strcpy((char *) name,filename);   c2pstr((char *) name);   filetype='    ';B   (void) strncpy((char *) &filetype,magick,Min(Extent(magick),4));&   Create(name,0,application,filetype); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   t e l l d i r                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %   Method telldir returns the current location associated  with  the  %   named directory stream.  % ' %  The format of the telldir method is:  %  %      telldir(entry)  % + %  A description of each parameter follows:  % 5 %    o entry: Specifies a pointer to a DIR structure.  %  %  */ long telldir(DIR *entry) {    return(entry->d_index);  }  #endif