 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                  M   M   AAA    GGGG  IIIII   CCCC  K   K                   % O %                  MM MM  A   A  G        I    C      K  K                    % O %                  M M M  AAAAA  G GGG    I    C      KKK                     % O %                  M   M  A   A  G   G    I    C      K  K                    % O %                  M   M  A   A   GGGG  IIIII   CCCC  K   K                   % O %                                                                             % O %                                                                             % O %               Methods to Read or List ImageMagick Image formats             % O %                                                                             % O %                                                                             % O %                            Software Design                                  % O %                            Bob Friesenhahn                                  % O %                              John Cristy                                    % O %                             November 1998                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*   Global declarations. */ static MagickInfo %   *magick_info = (MagickInfo *) NULL;    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s t r o y M a g i c k I n f o                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method DestroyMagickInfo deallocates memory associated MagickInfo list. % 1 %  The format of the DestroyMagickInfo method is:  %  %      void DestroyMagickInfo()  %  */ Export void DestroyMagickInfo()  {    MagickInfo     *entry;      register MagickInfo      *p;   B   for (p=GetMagickInfo((char *) NULL); p != (MagickInfo *) NULL; )   {      entry=p;     p=p->next;$     if (entry->tag != (char *) NULL)       FreeMemory(entry->tag); ,     if (entry->description != (char *) NULL)%       FreeMemory(entry->description);      FreeMemory(entry);   }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t M a g i c k L i s t                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method GetMagickInfo returns a pointer MagickInfo structure that matches K %  the specified tag.  If tag is NULL, the head of the image format list is  %  returned. % - %  The format of the GetMagickInfo method is:  % 1 %      MagickInfo *GetMagickInfo(const char *tag)  % + %  A description of each parameter follows:  % E %    o magick_info: Method GetMagickInfo returns a pointer MagickInfo 0 %      structure that matches the specified tag. % F %    o tag: a character string that represents the image format we are %      looking for.  %  %  */1 Export MagickInfo *GetMagickInfo(const char *tag)  {    register MagickInfo      *p;   )   if (magick_info == (MagickInfo *) NULL)      {        MagickInfo         *entry;   "       entry=SetMagickInfo("8BIM");#       entry->decoder=Read8BIMImage; $       entry->encoder=Write8BIMImage;       entry->magick=Is8BIM;        entry->adjoin=False;E       entry->description=AllocateString("Photoshop resource format");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("AVS"); "       entry->decoder=ReadAVSImage;#       entry->encoder=WriteAVSImage; 7       entry->description=AllocateString("AVS X image");         RegisterMagickInfo(entry); #if defined(HasJBIG)!       entry=SetMagickInfo("BIE"); #       entry->decoder=ReadJBIGImage; $       entry->encoder=WriteJBIGImage;       entry->adjoin=False;       entry->description= P         AllocateString("Joint Bi-level Image experts Group interchange format");        RegisterMagickInfo(entry); #endif!       entry=SetMagickInfo("BMP"); "       entry->decoder=ReadBMPImage;#       entry->encoder=WriteBMPImage;        entry->magick=IsBMP;J       entry->description=AllocateString("Microsoft Windows bitmap image");        RegisterMagickInfo(entry);#       entry=SetMagickInfo("BMP24"); "       entry->decoder=ReadBMPImage;#       entry->encoder=WriteBMPImage;        entry->description= @         AllocateString("Microsoft Windows 24-bit bitmap image");        RegisterMagickInfo(entry);"       entry=SetMagickInfo("CMYK");#       entry->decoder=ReadCMYKImage; $       entry->encoder=WriteCMYKImage;       entry->adjoin=False;       entry->raw=True;       entry->description= E         AllocateString("Raw cyan, magenta, yellow, and black bytes");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("DCM"); "       entry->decoder=ReadDCMImage;       entry->magick=IsDCM;       entry->adjoin=False;       entry->description= O         AllocateString("Digital Imaging and Communications in Medicine image");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("DCX"); "       entry->decoder=ReadPCXImage;#       entry->encoder=WritePCXImage;        entry->magick=IsDCX;       entry->description= =         AllocateString("ZSoft IBM PC multi-page Paintbrush");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("DIB"); "       entry->decoder=ReadBMPImage;#       entry->encoder=WriteBMPImage;        entry->description= 9         AllocateString("Microsoft Windows bitmap image");         RegisterMagickInfo(entry);"       entry=SetMagickInfo("EPDF");"       entry->decoder=ReadPDFImage;#       entry->encoder=WritePDFImage;        entry->adjoin=False;       entry->description= @         AllocateString("Encapsulated Portable Document Format");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("EPI"); !       entry->decoder=ReadPSImage;        entry->adjoin=False;       entry->description= K         AllocateString("Adobe Encapsulated PostScript Interchange format");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("EPS"); !       entry->decoder=ReadPSImage; "       entry->encoder=WritePSImage;       entry->adjoin=False;I       entry->description=AllocateString("Adobe Encapsulated PostScript");         RegisterMagickInfo(entry);"       entry=SetMagickInfo("EPS2");!       entry->decoder=ReadPSImage; #       entry->encoder=WritePS2Image;        entry->adjoin=False;       entry->description= A         AllocateString("Adobe Level II Encapsulated PostScript");         RegisterMagickInfo(entry);"       entry=SetMagickInfo("EPSF");!       entry->decoder=ReadPSImage; "       entry->encoder=WritePSImage;       entry->adjoin=False;I       entry->description=AllocateString("Adobe Encapsulated PostScript");         RegisterMagickInfo(entry);"       entry=SetMagickInfo("EPSI");!       entry->decoder=ReadPSImage; "       entry->encoder=WritePSImage;       entry->adjoin=False;       entry->description= K         AllocateString("Adobe Encapsulated PostScript Interchange format");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("EPT"); !       entry->decoder=ReadPSImage; #       entry->encoder=WriteEPTImage;        entry->magick=IsEPT;       entry->adjoin=False;       entry->description= J         AllocateString("Adobe Encapsulated PostScript with TIFF preview");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("FAX"); "       entry->decoder=ReadFAXImage;#       entry->encoder=WriteFAXImage;        entry->magick=IsFAX;7       entry->description=AllocateString("Group 3 FAX");         RegisterMagickInfo(entry);"       entry=SetMagickInfo("FITS");#       entry->decoder=ReadFITSImage; $       entry->encoder=WriteFITSImage;       entry->magick=IsFITS;        entry->adjoin=False;       entry->description= :         AllocateString("Flexible Image Transport System");        RegisterMagickInfo(entry); #if defined(HasFPX) !       entry=SetMagickInfo("FPX"); "       entry->decoder=ReadFPXImage;#       entry->encoder=WriteFPXImage;        entry->adjoin=False;;       entry->description=AllocateString("FlashPix Format");         RegisterMagickInfo(entry); #endif        entry=SetMagickInfo("G3");"       entry->decoder=ReadFAXImage;       entry->adjoin=False;7       entry->description=AllocateString("Group 3 FAX");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("GIF"); "       entry->decoder=ReadGIFImage;#       entry->encoder=WriteGIFImage;        entry->magick=IsGIF;       entry->description= A         AllocateString("CompuServe graphics interchange format");         RegisterMagickInfo(entry);#       entry=SetMagickInfo("GIF87"); "       entry->decoder=ReadGIFImage;#       entry->encoder=WriteGIFImage;        entry->adjoin=False;       entry->description= O         AllocateString("CompuServe graphics interchange format (version 87a)");         RegisterMagickInfo(entry);'       entry=SetMagickInfo("GRADATION"); (       entry->decoder=ReadGRADATIONImage;       entry->adjoin=False;       entry->description= D         AllocateString("Gradual passing from one shade to another");        RegisterMagickInfo(entry);%       entry=SetMagickInfo("GRANITE"); #       entry->decoder=ReadLOGOImage; $       entry->encoder=WriteLOGOImage;       entry->adjoin=False;;       entry->description=AllocateString("Granite texture");         RegisterMagickInfo(entry);"       entry=SetMagickInfo("GRAY");#       entry->decoder=ReadGRAYImage; $       entry->encoder=WriteGRAYImage;       entry->raw=True;:       entry->description=AllocateString("Raw gray bytes");        RegisterMagickInfo(entry);       entry=SetMagickInfo("H"); #       entry->decoder=ReadLOGOImage; $       entry->encoder=WriteLOGOImage;       entry->adjoin=False;;       entry->description=AllocateString("Internal format");         RegisterMagickInfo(entry); #if defined(HasHDF) !       entry=SetMagickInfo("HDF"); "       entry->decoder=ReadHDFImage;#       entry->encoder=WriteHDFImage;        entry->magick=IsHDF;        entry->blob_support=False;D       entry->description=AllocateString("Hierarchical Data Format");        RegisterMagickInfo(entry); #endif'       entry=SetMagickInfo("HISTOGRAM"); (       entry->decoder=ReadHISTOGRAMImage;)       entry->encoder=WriteHISTOGRAMImage;        entry->adjoin=False;B       entry->description=AllocateString("Histogram of the image");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("HTM"); $       entry->encoder=WriteHTMLImage;       entry->magick=IsHTML;        entry->adjoin=False;       entry->description= P         AllocateString("Hypertext Markup Language and a client-side image map");        RegisterMagickInfo(entry);"       entry=SetMagickInfo("HTML");$       entry->encoder=WriteHTMLImage;       entry->adjoin=False;       entry->description= P         AllocateString("Hypertext Markup Language and a client-side image map");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("ICB"); "       entry->decoder=ReadTGAImage;#       entry->encoder=WriteTGAImage; B       entry->description=AllocateString("Truevision Targa image");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("ICC"); "       entry->decoder=ReadICCImage;#       entry->encoder=WriteICCImage;        entry->adjoin=False;=       entry->description=AllocateString("ICC Color Profile");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("ICO"); #       entry->decoder=ReadICONImage;        entry->adjoin=False;:       entry->description=AllocateString("Microsoft icon");        RegisterMagickInfo(entry);&       entry=SetMagickInfo("IMPLICIT");;       entry->description=AllocateString("Internal format");         RegisterMagickInfo(entry);"       entry=SetMagickInfo("IPTC");#       entry->decoder=ReadIPTCImage; $       entry->encoder=WriteIPTCImage;       entry->magick=IsIPTC;        entry->adjoin=False;:       entry->description=AllocateString("IPTC Newsphoto");        RegisterMagickInfo(entry); #if defined(HasJBIG)!       entry=SetMagickInfo("JBG"); #       entry->decoder=ReadJBIGImage; $       entry->encoder=WriteJBIGImage;       entry->description= P         AllocateString("Joint Bi-level Image experts Group interchange format");        RegisterMagickInfo(entry);"       entry=SetMagickInfo("JBIG");#       entry->decoder=ReadJBIGImage; $       entry->encoder=WriteJBIGImage;       entry->description= P         AllocateString("Joint Bi-level Image experts Group interchange format");        RegisterMagickInfo(entry); #endif #if defined(HasJPEG)!       entry=SetMagickInfo("JPG"); #       entry->decoder=ReadJPEGImage; $       entry->encoder=WriteJPEGImage;       entry->adjoin=False;       entry->description= G         AllocateString("Joint Photographic Experts Group JFIF format");         RegisterMagickInfo(entry);"       entry=SetMagickInfo("JPEG");#       entry->decoder=ReadJPEGImage; $       entry->encoder=WriteJPEGImage;       entry->magick=IsJPEG;        entry->adjoin=False;       entry->description= G         AllocateString("Joint Photographic Experts Group JFIF format");         RegisterMagickInfo(entry);$       entry=SetMagickInfo("JPEG24");#       entry->decoder=ReadJPEGImage; $       entry->encoder=WriteJPEGImage;       entry->adjoin=False;       entry->description= G         AllocateString("Joint Photographic Experts Group JFIF format");         RegisterMagickInfo(entry); #endif#       entry=SetMagickInfo("LABEL"); $       entry->decoder=ReadLABELImage;       entry->adjoin=False;=       entry->description=AllocateString("Text image format");         RegisterMagickInfo(entry);"       entry=SetMagickInfo("LOGO");#       entry->decoder=ReadLOGOImage; $       entry->encoder=WriteLOGOImage;       entry->adjoin=False;<       entry->description=AllocateString("ImageMagick Logo");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("MAP"); "       entry->decoder=ReadMAPImage;#       entry->encoder=WriteMAPImage;        entry->adjoin=False;       entry->raw=True;       entry->description= ;         AllocateString("Colormap intensities and indices");         RegisterMagickInfo(entry);#       entry=SetMagickInfo("MATTE"); #       entry->decoder=ReadMIFFImage; %       entry->encoder=WriteMATTEImage;        entry->raw=True;8       entry->description=AllocateString("Matte format");        RegisterMagickInfo(entry);"       entry=SetMagickInfo("MIFF");#       entry->decoder=ReadMIFFImage; $       entry->encoder=WriteMIFFImage;       entry->magick=IsMIFF; ?       entry->description=AllocateString("Magick image format");         RegisterMagickInfo(entry); #if defined(HasPNG) !       entry=SetMagickInfo("MNG"); "       entry->decoder=ReadPNGImage;#       entry->encoder=WritePNGImage;        entry->magick=IsMNG;K       entry->description=AllocateString("Multiple-image Network Graphics");         RegisterMagickInfo(entry); #endif"       entry=SetMagickInfo("MONO");#       entry->decoder=ReadMONOImage; $       entry->encoder=WriteMONOImage;       entry->adjoin=False;       entry->description= P         AllocateString("Bi-level bitmap in least-significant-byte first order");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("MTV"); "       entry->decoder=ReadMTVImage;#       entry->encoder=WriteMTVImage; G       entry->description=AllocateString("MTV Raytracing image format");         RegisterMagickInfo(entry);&       entry=SetMagickInfo("NETSCAPE");#       entry->decoder=ReadLOGOImage; $       entry->encoder=WriteLOGOImage;       entry->adjoin=False;C       entry->description=AllocateString("Netscape 216 color cube");         RegisterMagickInfo(entry);"       entry=SetMagickInfo("NULL");#       entry->decoder=ReadNULLImage;        entry->adjoin=False;6       entry->description=AllocateString("NULL image");        RegisterMagickInfo(entry);        entry=SetMagickInfo("P7");"       entry->decoder=ReadPNMImage;#       entry->encoder=WritePNMImage; ?       entry->description=AllocateString("Xv thumbnail format");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("PBM"); "       entry->decoder=ReadPNMImage;#       entry->encoder=WritePNMImage;        entry->description= C         AllocateString("Portable bitmap format (black and white)");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("PCD"); "       entry->decoder=ReadPCDImage;#       entry->encoder=WritePCDImage;        entry->magick=IsPCD;       entry->adjoin=False;4       entry->description=AllocateString("Photo CD");        RegisterMagickInfo(entry);"       entry=SetMagickInfo("PCDS");"       entry->decoder=ReadPCDImage;#       entry->encoder=WritePCDImage;        entry->adjoin=False;4       entry->description=AllocateString("Photo CD");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("PCL"); "       entry->decoder=ReadPCLImage;#       entry->encoder=WritePCLImage;        entry->magick=IsPCL;       entry->adjoin=False;A       entry->description=AllocateString("Page Control Language");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("PCT"); $       entry->encoder=WritePICTImage;       entry->adjoin=False;J       entry->description=AllocateString("Apple Macintosh QuickDraw/PICT");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("PCX"); "       entry->decoder=ReadPCXImage;#       entry->encoder=WritePCXImage;        entry->magick=IsPCX;       entry->adjoin=False;C       entry->description=AllocateString("ZSoft IBM PC Paintbrush");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("PDF"); "       entry->decoder=ReadPDFImage;#       entry->encoder=WritePDFImage;        entry->magick=IsPDF;D       entry->description=AllocateString("Portable Document Format");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("PIC"); #       entry->decoder=ReadPICTImage; $       entry->encoder=WritePICTImage;       entry->adjoin=False;J       entry->description=AllocateString("Apple Macintosh QuickDraw/PICT");        RegisterMagickInfo(entry);"       entry=SetMagickInfo("PICT");#       entry->decoder=ReadPICTImage; $       entry->encoder=WritePICTImage;       entry->adjoin=False;J       entry->description=AllocateString("Apple Macintosh QuickDraw/PICT");        RegisterMagickInfo(entry);$       entry=SetMagickInfo("PICT24");#       entry->decoder=ReadPICTImage; $       entry->encoder=WritePICTImage;       entry->adjoin=False;       entry->description= @         AllocateString("24-bit Apple Macintosh QuickDraw/PICT");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("PIX"); "       entry->decoder=ReadPIXImage;       entry->description= ;         AllocateString("Alias/Wavefront RLE image format");         RegisterMagickInfo(entry);$       entry=SetMagickInfo("PLASMA");%       entry->decoder=ReadPLASMAImage;        entry->adjoin=False;@       entry->description=AllocateString("Plasma fractal image");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("PGM"); "       entry->decoder=ReadPNMImage;#       entry->encoder=WritePNMImage;        entry->description= ?         AllocateString("Portable graymap format (gray scale)");         RegisterMagickInfo(entry);        entry=SetMagickInfo("PM");"       entry->decoder=ReadXPMImage;#       entry->encoder=WriteXPMImage;        entry->adjoin=False;K       entry->description=AllocateString("X Windows system pixmap (color)");         RegisterMagickInfo(entry); #if defined(HasPNG) !       entry=SetMagickInfo("PNG"); "       entry->decoder=ReadPNGImage;#       entry->encoder=WritePNGImage;        entry->magick=IsPNG;       entry->adjoin=False;E       entry->description=AllocateString("Portable Network Graphics");         RegisterMagickInfo(entry); #endif!       entry=SetMagickInfo("PNM"); "       entry->decoder=ReadPNMImage;#       entry->encoder=WritePNMImage;        entry->magick=IsPNM;;       entry->description=AllocateString("Portable anymap");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("PPM"); "       entry->decoder=ReadPNMImage;#       entry->encoder=WritePNMImage; J       entry->description=AllocateString("Portable pixmap format (color)");        RegisterMagickInfo(entry);%       entry=SetMagickInfo("PREVIEW"); '       entry->encoder=WritePREVIEWImage;        entry->adjoin=False;       entry->description= N         AllocateString("Show a preview an image enhancement, effect, or f/x");        RegisterMagickInfo(entry);        entry=SetMagickInfo("PS");!       entry->decoder=ReadPSImage; "       entry->encoder=WritePSImage;       entry->magick=IsPS; <       entry->description=AllocateString("Adobe PostScript");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("PS2"); #       entry->encoder=WritePS2Image; E       entry->description=AllocateString("Adobe Level II PostScript");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("PS3"); #       entry->encoder=WritePS3Image; F       entry->description=AllocateString("Adobe Level III PostScript");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("PSD"); "       entry->decoder=ReadPSDImage;#       entry->encoder=WritePSDImage;        entry->magick=IsPSD;       entry->adjoin=False;B       entry->description=AllocateString("Adobe Photoshop bitmap");        RegisterMagickInfo(entry); #if defined(HasTIFF)"       entry=SetMagickInfo("PTIF");#       entry->decoder=ReadTIFFImage; $       entry->encoder=WriteTIFFImage;        entry->blob_support=False;@       entry->description=AllocateString("Pyramid encoded TIFF");        RegisterMagickInfo(entry); #endif!       entry=SetMagickInfo("PWP"); "       entry->decoder=ReadPWPImage;       entry->magick=IsPWP;>       entry->description=AllocateString("Seattle Film Works");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("RAS"); "       entry->decoder=ReadSUNImage;#       entry->encoder=WriteSUNImage;        entry->magick=IsSUN;:       entry->description=AllocateString("SUN Rasterfile");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("RGB"); "       entry->decoder=ReadRGBImage;#       entry->encoder=WriteRGBImage;        entry->raw=True;J       entry->description=AllocateString("Raw red, green, and blue bytes");        RegisterMagickInfo(entry);"       entry=SetMagickInfo("RGBA");"       entry->decoder=ReadRGBImage;#       entry->encoder=WriteRGBImage;        entry->raw=True;       entry->description= @         AllocateString("Raw red, green, blue, and matte bytes");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("RLA"); "       entry->decoder=ReadRLAImage;       entry->adjoin=False;A       entry->description=AllocateString("Alias/Wavefront image");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("RLE"); "       entry->decoder=ReadRLEImage;       entry->magick=IsRLE;       entry->adjoin=False;I       entry->description=AllocateString("Utah Run length encoded image");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("SCT"); "       entry->decoder=ReadSCTImage;       entry->magick=IsSCT;       entry->adjoin=False;<       entry->description=AllocateString("Scitex HandShake");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("SFW"); "       entry->decoder=ReadSFWImage;       entry->magick=IsSFW;       entry->adjoin=False;>       entry->description=AllocateString("Seattle Film Works");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("SGI"); "       entry->decoder=ReadSGIImage;#       entry->encoder=WriteSGIImage;        entry->magick=IsSGI;:       entry->description=AllocateString("Irix RGB image");        RegisterMagickInfo(entry);#       entry=SetMagickInfo("SHTML"); $       entry->encoder=WriteHTMLImage;       entry->adjoin=False;       entry->description= P         AllocateString("Hypertext Markup Language and a client-side image map");        RegisterMagickInfo(entry);%       entry=SetMagickInfo("STEGANO"); &       entry->decoder=ReadSTEGANOImage;@       entry->description=AllocateString("Steganographic image");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("SUN"); "       entry->decoder=ReadSUNImage;#       entry->encoder=WriteSUNImage; :       entry->description=AllocateString("SUN Rasterfile");        RegisterMagickInfo(entry);"       entry=SetMagickInfo("TEXT");"       entry->decoder=ReadTXTImage;#       entry->encoder=WriteTXTImage;        entry->raw=True;4       entry->description=AllocateString("Raw text");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("TGA"); "       entry->decoder=ReadTGAImage;#       entry->encoder=WriteTGAImage; B       entry->description=AllocateString("Truevision Targa image");        RegisterMagickInfo(entry); #if defined(HasTIFF)!       entry=SetMagickInfo("TIF"); #       entry->decoder=ReadTIFFImage; $       entry->encoder=WriteTIFFImage;        entry->blob_support=False;D       entry->description=AllocateString("Tagged Image File Format");        RegisterMagickInfo(entry);"       entry=SetMagickInfo("TIFF");#       entry->decoder=ReadTIFFImage; $       entry->encoder=WriteTIFFImage;       entry->magick=IsTIFF;         entry->blob_support=False;D       entry->description=AllocateString("Tagged Image File Format");        RegisterMagickInfo(entry);$       entry=SetMagickInfo("TIFF24");#       entry->decoder=ReadTIFFImage; $       entry->encoder=WriteTIFFImage;        entry->blob_support=False;K       entry->description=AllocateString("24-bit Tagged Image File Format");         RegisterMagickInfo(entry); #endif"       entry=SetMagickInfo("TILE");#       entry->decoder=ReadTILEImage;        entry->raw=True;E       entry->description=AllocateString("Tile image with a texture");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("TIM"); "       entry->decoder=ReadTIMImage;3       entry->description=AllocateString("PSX TIM");         RegisterMagickInfo(entry); #if defined(HasTTF) !       entry=SetMagickInfo("TTF"); "       entry->decoder=ReadTTFImage;       entry->adjoin=False;9       entry->description=AllocateString("TrueType font");         RegisterMagickInfo(entry); #endif!       entry=SetMagickInfo("TXT"); "       entry->decoder=ReadTXTImage;#       entry->encoder=WriteTXTImage; 4       entry->description=AllocateString("Raw text");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("UIL"); "       entry->decoder=ReadUILImage;#       entry->encoder=WriteUILImage;        entry->adjoin=False;=       entry->description=AllocateString("X-Motif UIL table");         RegisterMagickInfo(entry);"       entry=SetMagickInfo("UYVY");#       entry->decoder=ReadUYVYImage; $       entry->encoder=WriteUYVYImage;       entry->adjoin=False;       entry->raw=True;G       entry->description=AllocateString("16bit/pixel interleaved YUV");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("VDA"); "       entry->decoder=ReadTGAImage;#       entry->encoder=WriteTGAImage; B       entry->description=AllocateString("Truevision Targa image");        RegisterMagickInfo(entry);#       entry=SetMagickInfo("VICAR"); $       entry->decoder=ReadVICARImage;%       entry->encoder=WriteVICARImage;        entry->magick=IsVICAR;       entry->adjoin=False;C       entry->description=AllocateString("VICAR rasterfile format");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("VID"); "       entry->decoder=ReadVIDImage;$       entry->encoder=WriteMIFFImage;B       entry->description=AllocateString("Visual Image Directory");        RegisterMagickInfo(entry);"       entry=SetMagickInfo("VIFF");#       entry->decoder=ReadVIFFImage; $       entry->encoder=WriteVIFFImage;       entry->magick=IsVIFF; F       entry->description=AllocateString("Khoros Visualization image");        RegisterMagickInfo(entry);!       entry=SetMagickInfo("VST"); "       entry->decoder=ReadTGAImage;#       entry->encoder=WriteTGAImage; B       entry->description=AllocateString("Truevision Targa image");        RegisterMagickInfo(entry); #if defined(HasX11)        entry=SetMagickInfo("X");         entry->decoder=ReadXImage;!       entry->encoder=WriteXImage;        entry->adjoin=False;3       entry->description=AllocateString("X Image");         RegisterMagickInfo(entry); #endif!       entry=SetMagickInfo("XBM"); "       entry->decoder=ReadXBMImage;#       entry->encoder=WriteXBMImage;        entry->magick=IsXBM;       entry->adjoin=False;       entry->description= D         AllocateString("X Windows system bitmap (black and white)");        RegisterMagickInfo(entry);        entry=SetMagickInfo("XC");!       entry->decoder=ReadXCImage;        entry->adjoin=False;       entry->raw=True;       entry->description= ;         AllocateString("Constant image of X server color");         RegisterMagickInfo(entry);!       entry=SetMagickInfo("XPM"); "       entry->decoder=ReadXPMImage;#       entry->encoder=WriteXPMImage;        entry->magick=IsXPM;       entry->adjoin=False;K       entry->description=AllocateString("X Windows system pixmap (color)");         RegisterMagickInfo(entry);        entry=SetMagickInfo("XV");#       entry->decoder=ReadVIFFImage; $       entry->encoder=WriteVIFFImage;F       entry->description=AllocateString("Khoros Visualization image");        RegisterMagickInfo(entry); #if defined(HasX11) !       entry=SetMagickInfo("XWD"); "       entry->decoder=ReadXWDImage;#       entry->encoder=WriteXWDImage;        entry->magick=IsXWD;       entry->adjoin=False;       entry->description= ?         AllocateString("X Windows system window dump (color)");         RegisterMagickInfo(entry); #endif!       entry=SetMagickInfo("YUV"); "       entry->decoder=ReadYUVImage;#       entry->encoder=WriteYUVImage;        entry->adjoin=False;       entry->raw=True;:       entry->description=AllocateString("CCIR 601 4:1:1");        RegisterMagickInfo(entry);     }    if (tag == (char *) NULL)      return(magick_info);:   for (p=magick_info; p != (MagickInfo *) NULL; p=p->next)'     if (Latin1Compare(p->tag,tag) == 0)        return(p);   return((MagickInfo *) NULL); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  L i s t M a g i c k I n f o                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ; %  Method ListMagickInfo lists the image formats to a file.  % . %  The format of the ListMagickInfo method is: % & %      void ListMagickInfo(FILE *file) % + %  A description of each parameter follows.  % + %    o file: A pointer to a FILE structure.  %  %  */& Export void ListMagickInfo(FILE *file) {    register MagickInfo      *p;      if (file == (FILE *) NULL)     file=stdout;H   (void) fprintf(file,"\nHere is a list of image formats recognized by "G     "ImageMagick.  Mode 'rw+'\nmeans ImageMagick can read, write, and " M     "save more than one image of a\nsequence to the same blob or file.\n\n"); 9   (void) fprintf(file,"    Format  Mode  Description\n"); P   (void) fprintf(file,"--------------------------------------------------------"     "-----------------\n"); K   for (p=GetMagickInfo((char *) NULL); p != (MagickInfo *) NULL; p=p->next) D     (void) fprintf(file,"%10s%c  %c%c%c  %s\n",p->tag ? p->tag : "",P       p->blob_support ? '*' : ' ',p->decoder ? 'r' : '-',p->encoder ? 'w' : '-',P       p->encoder && p->adjoin ? '+' : '-',p->description ? p->description : "");5   (void) fprintf(file,"\n* native blob support\n\n");    (void) fflush(file); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e g i s t e r M a g i c k I n f o                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method RegisterMagickInfo adds attributes for a particular image format to O %  the list of supported formats.  The attributes include the image format tag, H %  a method to read and/or write the format, whether the format supportsJ %  the saving of more than one frame to the same file or blob, whether theO %  format supports native in-memory I/O, and a brief description of the format.  % 2 %  The format of the RegisterMagickInfo method is: % 8 %      MagickInfo *RegisterMagickInfo(MagickInfo *entry) % + %  A description of each parameter follows:  % J %    o magick_info: Method RegisterMagickInfo returns a pointer MagickInfo6 %      structure that contains the specified tag info. %  %    o entry:  %  */8 Export MagickInfo *RegisterMagickInfo(MagickInfo *entry) {    register MagickInfo      *p;      /**     Add tag info to the image format list.   */   p=(MagickInfo*) NULL; )   if (magick_info != (MagickInfo *) NULL)      { D       for (p=magick_info; p->next != (MagickInfo *) NULL; p=p->next)       { 2         if (Latin1Compare(p->tag,entry->tag) >= 0)           { 6             if (Latin1Compare(p->tag,entry->tag) == 0)               {                  p=p->previous;1                 UnregisterMagickInfo(entry->tag);                }              break;           }        }      } )   if (magick_info == (MagickInfo *) NULL)      {        magick_info=entry;       return(entry);     }    entry->previous=p;   entry->next=p->next;   p->next=entry;   return(entry); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S e t M a g i c k I n f o                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method SetMagickInfo allocates a MagickInfo structure and initializes the %  members to default values.  % - %  The format of the SetMagickInfo method is:  % 1 %      MagickInfo *SetMagickInfo(const char *tag)  % + %  A description of each parameter follows:  % N %    o magick_info: Method SetMagickInfo returns the allocated and initialized %      MagickInfo structure. % J %    o tag: a character string that represents the image format associated% %      with the MagickInfo structure.  %  %  */1 Export MagickInfo *SetMagickInfo(const char *tag)  {    MagickInfo     *entry;   :   entry=(MagickInfo *) AllocateMemory(sizeof(MagickInfo));#   if (entry == (MagickInfo *) NULL) @     MagickError(ResourceLimitWarning,"Unable to allocate image","       "Memory allocation failed");!   entry->tag=AllocateString(tag); 6   entry->decoder=(Image *(*)(const ImageInfo *)) NULL;D   entry->encoder=(unsigned int (*)(const ImageInfo *,Image *)) NULL;   entry->magick=F     (unsigned int (*)(const unsigned char *,const unsigned int)) NULL;   entry->adjoin=True;    entry->blob_support=True;    entry->raw=False; #   entry->description=(char *) NULL;    entry->data=(void *) NULL;&   entry->previous=(MagickInfo *) NULL;"   entry->next=(MagickInfo *) NULL;   return(entry); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U n r e g i s t e r M a g i c k I n f o                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method UnregisterMagickInfo removes a tag from the magick info list.  It F %  returns False if the tag does not exist in the list otherwise True. % 4 %  The format of the UnregisterMagickInfo method is: % 9 %      unsigned int UnregisterMagickInfo(const char *tag)  % + %  A description of each parameter follows:  % L %    o status: Method UnregisterMagickInfo returns False if the tag does not( %      exist in the list otherwise True. % F %    o tag: a character string that represents the image format we are %      looking for.  %  */9 Export unsigned int UnregisterMagickInfo(const char *tag)  {    register MagickInfo      *p;   K   for (p=GetMagickInfo((char *) NULL); p != (MagickInfo *) NULL; p=p->next)    { '     if (Latin1Compare(p->tag,tag) == 0)        { $         if (p->tag != (char *) NULL)           FreeMemory(p->tag); ,         if (p->description != (char *) NULL)%           FreeMemory(p->description); /         if (p->previous != (MagickInfo *) NULL) $           p->previous->next=p->next;         else           {               magick_info=p->next;2             p->next->previous=(MagickInfo *) NULL;           } *         if (p->next != (MagickInfo*) NULL)(           p->next->previous=p->previous;         FreeMemory(p);         return(True);      }    }    return(False); } 