 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                     M   M   AAA   TTTTT  TTTTT  EEEEE                       % O %                     MM MM  A   A    T      T    E                           % O %                     M M M  AAAAA    T      T    EEE                         % O %                     M   M  A   A    T      T    E                           % O %                     M   M  A   A    T      T    EEEEE                       % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M A T T E I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function WriteMATTEImage writes an image of matte bytes to a file.  It C %  consists of data from the matte component of the image [0..255].  % / %  The format of the WriteMATTEImage method is:  % M %      unsigned int WriteMATTEImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % L %    o status: Function WriteMATTEImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */M Export unsigned int WriteMATTEImage(const ImageInfo *image_info,Image *image)  {    Image      *matte_image;      register int     i;     unsigned int     status;      if (!image->matte)J     WriterExit(ResourceLimitWarning,"Image does not have a matte channel",
       image); @   matte_image=CloneImage(image,image->columns,image->rows,True);$   if (matte_image == (Image *) NULL)F     WriterExit(ResourceLimitWarning,"Memory allocation failed",image);!   matte_image->class=PseudoClass; -   matte_image->colors=(Opaque-Transparent)+1; '   matte_image->colormap=(PixelPacket *) <     AllocateMemory(matte_image->colors*sizeof(PixelPacket));4   if (matte_image->colormap == (PixelPacket *) NULL)F     WriterExit(ResourceLimitWarning,"Memory allocation failed",image);'   for (i=Transparent; i <= Opaque; i++)    { -     matte_image->colormap[i].red=(Quantum) i; /     matte_image->colormap[i].green=(Quantum) i; .     matte_image->colormap[i].blue=(Quantum) i;   }    SyncImage(matte_image); 0   status=WriteMIFFImage(image_info,matte_image);   DestroyImage(matte_image);   return(status);  } 