 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                    M   M  EEEEE  M   M   OOO   RRRR   Y   Y                 % O %                    MM MM  E      MM MM  O   O  R   R   Y Y                  % O %                    M M M  EEE    M M M  O   O  RRRR     Y                   % O %                    M   M  E      M   M  O   O  R R      Y                   % O %                    M   M  EEEEE  M   M   OOO   R  R     Y                   % O %                                                                             % O %                                                                             % O %                    ImageMagick Memory Allocation Methods                    % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1998                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   A l l o c a t e M e m o r y                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method AllocateMemory returns a pointer to a block of at least size bytes  %  suitably aligned for any use. % . %  The format of the AllocateMemory method is: % . %      void *AllocateMemory(const size_t size) % + %  A description of each parameter follows:  % G %    o memory: Method AllocateMemory returns a pointer to a block of at 5 %      least size bytes suitably aligned for any use.  % 8 %    o size: Specifies the size of the memory to return. %  %  */. Export void *AllocateMemory(const size_t size) {    void     *allocation;     assert(size > 0);    allocation=malloc(size);"   if (allocation != (void *) NULL)%     (void) memset(allocation,0,size);    return(allocation);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   F r e e M e m o r y                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % B %  Method FreeMemory frees memory that has already been allocated. % * %  The format of the FreeMemory method is: % $ %      void FreeMemory(void *memory) % + %  A description of each parameter follows:  % G %    o span: Specifies the pointer to a block memory to free for reuse.  %  %  */$ Export void FreeMemory(void *memory) {    if (memory == (void *) NULL)     return;    free(memory);    memory=(void *) NULL;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a l l o c a t e M e m o r y                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method ReallocateMemory changes the size of the memory and returns a L %  pointer to the (possibly moved) block.  The contents will be unchanged up+ %  to the lesser  of the new and old sizes.  % 0 %  The format of the ReallocateMemory method is: % = %      void *ReallocateMemory(void *memory,const size_t size)  % + %  A description of each parameter follows:  % I %    o memory: Method ReallocateMemory returns a pointer to a block of at 5 %      least size bytes suitably aligned for any use.  % 8 %    o size: Specifies the size of the memory to return. %  %  */= Export void *ReallocateMemory(void *memory,const size_t size)  {    void     *new_memory;     new_memory=(void *) NULL;    if (size) $     new_memory=realloc(memory,size);"   if (new_memory == (void *) NULL)     FreeMemory(memory);    return(new_memory);  } 