 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %               M   M   OOO   N   N  IIIII  TTTTT   OOO   RRRR                % O %               MM MM  O   O  NN  N    I      T    O   O  R   R               % O %               M M M  O   O  N N N    I      T    O   O  RRRR                % O %               M   M  O   O  N  NN    I      T    O   O  R R                 % O %               M   M   OOO   N   N  IIIII    T     OOO   R  R                % O %                                                                             % O %                                                                             % O %                    ImageMagick Progress Monitor Methods                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                               December 1995                                 % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*   Global declarations. */ static MonitorHandler *   monitor_handler = (MonitorHandler) NULL;   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   P r o g r e s s M o n i t o r                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method ProgressMonitor calls the monitor handler methods with a text > %  string that describes the task and a measure of completion. % / %  The format of the ProgressMonitor method is:  % H %      void ProgressMonitor(const char *text,const unsigned int quantum,! %        const unsigned int span)  % + %  A description of each parameter follows:  % O %    o quantum: Specifies the quantum position within the span which represents < %      how much progress has been made in completing a task. % > %    o span: Specifies the span relative to completing a task. %  %  */H Export void ProgressMonitor(const char *text,const unsigned int quantum,   const unsigned int span) {    ProcessPendingEvents(text); /   if (monitor_handler != (MonitorHandler) NULL) *     (*monitor_handler)(text,quantum,span); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S e t M o n i t o r H a n d l e r                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method SetMonitorHandler sets the monitor handler to the specified method, %  and returns the previous monitor handler. % 1 %  The format of the SetMonitorHandler method is:  % ? %      MonitorHandler SetMonitorHandler(MonitorHandler handler)  % + %  A description of each parameter follows:  % C %    o handler: Specifies a pointer to a method to handle monitors.  %  %  */? Export MonitorHandler SetMonitorHandler(MonitorHandler handler)  {    MonitorHandler     previous_handler;   #   previous_handler=monitor_handler;    monitor_handler=handler;   return(previous_handler);  } 