 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            PPPP   IIIII  X   X                              % O %                            P   P    I     X X                               % O %                            PPPP     I      X                                % O %                            P        I     X X                               % O %                            P      IIIII  X   X                              % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d P I X I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method ReadPIXImage reads a Alias/Wavefront RLE image file and returns it. N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % , %  The format of the ReadPIXImage method is: % 7 %      Image *ReadPIXImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadPIXImage returns a pointer to the image after L %      reading. A null image is returned if there is a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadPIXImage(const ImageInfo *image_info)  {    Image      *image;   
   IndexPacket 
     index;     int      y;  	   Quantum 	     blue, 
     green,     red;     register int     x;     register PixelPacket     *q;      unsigned int     bits_per_pixel,      status;      unsigned long      height,      length, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*     Read PIX image.    */!   width=MSBFirstReadShort(image); "   height=MSBFirstReadShort(image);2   (void) MSBFirstReadShort(image);  /* x-offset */2   (void) MSBFirstReadShort(image);  /* y-offset */*   bits_per_pixel=MSBFirstReadShort(image);H   if ((width == (unsigned long) ~0) || (height == (unsigned long) ~0) ||8       ((bits_per_pixel != 8) && (bits_per_pixel != 24)))A     ReaderExit(CorruptImageWarning,"Not a PIX image file",image);    do   {      /*!       Initialize image structure.      */     image->columns=width;      image->rows=height;      if (bits_per_pixel == 8)       {          register int           i;  
         /*!           Create linear colormap. 
         */!         image->class=PseudoClass;          image->colors=MaxRGB+1; '         image->colormap=(PixelPacket *) <           AllocateMemory(image->colors*sizeof(PixelPacket));4         if (image->colormap == (PixelPacket *) NULL)L           ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);/         for (i=0; i < (int) image->colors; i++) 	         { 6           image->colormap[i].red=(Quantum) UpScale(i);8           image->colormap[i].green=(Quantum) UpScale(i);7           image->colormap[i].blue=(Quantum) UpScale(i); 	         }        }      if (image_info->ping)        {          CloseBlob(image);          return(image);       }      /*0       Convert PIX raster image to pixel packets.     */
     red=0;     green=0;     blue=0;      index=0;
     length=0; )     for (y=0; y < (int) image->rows; y++)      { 2       q=SetPixelCache(image,0,y,image->columns,1);$       if (q == (PixelPacket *) NULL)         break;.       for (x=0; x < (int) image->columns; x++)       {          if (length == 0)           { #             length=ReadByte(image); $             if (bits_per_pixel == 8)-               index=UpScale(ReadByte(image));              else               { .                 blue=UpScale(ReadByte(image));/                 green=UpScale(ReadByte(image)); -                 red=UpScale(ReadByte(image));                }            }          q->blue=blue;          q->green=green;          q->red=red;           image->indexes[x]=index;         length--;          q++;       } !       if (!SyncPixelCache(image))          break;,       if (image->previous == (Image *) NULL)5         ProgressMonitor(LoadImageText,y,image->rows);      } $     if (image->class == PseudoClass)       SyncImage(image);      /*       Proceed to next image.     */"     if (image_info->subrange != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;"     width=MSBFirstReadLong(image);#     height=MSBFirstReadLong(image); $     (void) MSBFirstReadShort(image);$     (void) MSBFirstReadShort(image);,     bits_per_pixel=MSBFirstReadShort(image);M     status=(width != (unsigned long) ~0) && (height == (unsigned long) ~0) && 8       ((bits_per_pixel == 8) || (bits_per_pixel == 24));     if (status == True)        { 
         /*(           Allocate next image structure.
         */,         AllocateNextImage(image_info,image);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            }          image=image->next;F         ProgressMonitor(LoadImagesText,(unsigned int) TellBlob(image),*           (unsigned int) image->filesize);       }    } while (status == True); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseBlob(image);    return(image); } 