 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                 PPPP   L       AAA   SSSSS  M   M   AAA                     % O %                 P   P  L      A   A  SS     MM MM  A   A                    % O %                 PPPP   L      AAAAA   SSS   M M M  AAAAA                    % O %                 P      L      A   A     SS  M   M  A   A                    % O %                 P      LLLLL  A   A  SSSSS  M   M  A   A                    % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d P L A S M A I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method ReadPLASMAImage creates a plasma fractal image.  The image is E %  initialized to to the X server color as specified by the filename.  % / %  The format of the ReadPLASMAImage method is:  % : %      Image *ReadPLASMAImage(const ImageInfo *image_info) % + %  A description of each parameter follows:  % J %    o image:  Method ReadPLASMAImage returns a pointer to the image afterJ %      creating it. A null image is returned if there is a memory shortage& %      or if the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */: Export Image *ReadPLASMAImage(const ImageInfo *image_info) { 7 #define PlasmaImageText  "  Applying image plasma...  "  #define PlasmaPixel(x,y) \ { \ /   q=GetPixelCache(image,(int) x,(int) y,1,1); \ "   if (q != (PixelPacket *) NULL) \     { \ /       q->red=(Quantum) (rand() % (MaxRGB+1)); \ 1       q->green=(Quantum) (rand() % (MaxRGB+1)); \ 0       q->blue=(Quantum) (rand() % (MaxRGB+1)); \$      (void) SyncPixelCache(image); \     } \  }      Image      *image;      int      y;     register int     i,     x;     register PixelPacket     *q;   
   SegmentInfo      segment_info;      unsigned int
     depth,     max_depth;     /**     Recursively apply plasma to the image.   */'   image=ReadGRADATIONImage(image_info);    if (image == (Image *) NULL)     return(image);   image->class=DirectClass; '   for (y=0; y < (int) image->rows; y++)    { 0     q=GetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     { +       q->opacity=(Opaque-Transparent) >> 1; 
       q++;     }      if (!SyncPixelCache(image))        break;   }    segment_info.x1=0;   segment_info.y1=0;#   segment_info.x2=image->columns-1;     segment_info.y2=image->rows-1;   srand(time(0)); 9   if (Latin1Compare(image_info->filename,"fractal") == 0)      {        /*%         Seed pixels before recursion.        */3       PlasmaPixel(segment_info.x1,segment_info.y1); G       PlasmaPixel(segment_info.x1,(segment_info.y1+segment_info.y2)/2); 3       PlasmaPixel(segment_info.x1,segment_info.y2); G       PlasmaPixel((segment_info.x1+segment_info.x2)/2,segment_info.y1); 6       PlasmaPixel((segment_info.x1+segment_info.x2)/2,-         (segment_info.y1+segment_info.y2)/2); G       PlasmaPixel((segment_info.x1+segment_info.x2)/2,segment_info.y2); 3       PlasmaPixel(segment_info.x2,segment_info.y1); G       PlasmaPixel(segment_info.x2,(segment_info.y1+segment_info.y2)/2); 3       PlasmaPixel(segment_info.x2,segment_info.y2);      } )   i=Max(image->columns,image->rows) >> 1; (   for (max_depth=0; i != 0; max_depth++)
     i>>=1;   for (depth=1; ; depth++)   { 5     ProgressMonitor(PlasmaImageText,depth,max_depth); 1     if (PlasmaImage(image,&segment_info,0,depth))        break;   }    return(image); } 