 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                               PPPP   SSSSS                                  % O %                               P   P  SS                                     % O %                               PPPP    SSS                                   % O %                               P         SS                                  % O %                               P      SSSSS                                  % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*   Constant declarations. */
 const char   *AppendBinaryType = "ab",    *PSDensityGeometry = "72x72",    *PSPageGeometry = "612x792>";    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s P S                                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method IsPS returns True if the image format type, identified by the  %  magick string, is PS. % + %  The format of the ReadPSImage method is:  % 5 %      unsigned int IsPS(const unsigned char *magick, # %        const unsigned int length)  % + %  A description of each parameter follows:  % H %    o status:  Method IsPS returns True if the image format type is PS. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */O Export unsigned int IsPS(const unsigned char *magick,const unsigned int length)  {    if (length < 3)      return(False);/   if (strncmp((char *) magick,"\004%!",3) == 0)      return(True); +   if (strncmp((char *) magick,"%!",2) == 0)      return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d P S I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method ReadPSImage reads a Adobe Postscript image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % + %  The format of the ReadPSImage method is:  % 6 %      Image *ReadPSImage(const ImageInfo *image_info) % + %  A description of each parameter follows:  % F %    o image:  Method ReadPSImage returns a pointer to the image afterJ %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */6 Export Image *ReadPSImage(const ImageInfo *image_info) { % #define BoundingBox  "%%BoundingBox:" ) #define DocumentMedia  "%%DocumentMedia:" - #define PageBoundingBox  "%%PageBoundingBox:"   #define PostscriptLevel  "%!PS-" #define ShowPage  "showpage"     char     density[MaxTextExtent],      command[MaxTextExtent],      filename[MaxTextExtent],     geometry[MaxTextExtent],     options[MaxTextExtent], '     postscript_filename[MaxTextExtent], &     translate_geometry[MaxTextExtent];     DelegateInfo     delegate_info;     double     dx_resolution,     dy_resolution;     FILE
     *file;     Image      *image,      *next_image;     ImageInfo      *local_info;     int      c,
     count,     status;   
   long int
     filesize;      RectangleInfo      box,     page_info;     register char      *p;      register int     i;  
   SegmentInfo      bounding_box;      unsigned int     eps_level,     height, 
     level,
     width;     if (image_info->monochrome)      { C       if (!GetDelegateInfo("gs-mono",(char *) NULL,&delegate_info))          return((Image *) NULL);      }    elseB     if (!GetDelegateInfo("gs-color",(char *) NULL,&delegate_info))       return((Image *) NULL);    /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*     Open temporary output file.    */)   TemporaryFilename(postscript_filename); 2   file=fopen(postscript_filename,WriteBinaryType);   if (file == (FILE *) NULL)=     ReaderExit(FileOpenWarning,"Unable to write file",image); M   FormatString(translate_geometry,"%f %f translate\n              ",0.0,0.0); (   (void) fputs(translate_geometry,file);   /*     Set the page geometry.   */   dx_resolution=72.0;    dy_resolution=72.0; C   if ((image->x_resolution == 0.0) || (image->y_resolution == 0.0))      { /       (void) strcpy(density,PSDensityGeometry); P       count=sscanf(density,"%lfx%lf",&image->x_resolution,&image->y_resolution);       if (count != 2) 0         image->y_resolution=image->x_resolution;     } H   FormatString(density,"%gx%g",image->x_resolution,image->y_resolution);   page_info.width=612;   page_info.height=792;    page_info.x=0;   page_info.y=0;E   (void) ParseImageGeometry(PSPageGeometry,&page_info.x,&page_info.y, (     &page_info.width,&page_info.height);   /*=     Determine page geometry from the Postscript bounding box.    */
   filesize=0; 3   if (Latin1Compare(image_info->magick,"EPT") == 0)      {        /*         Dos binary file header.        */%       (void) LSBFirstReadLong(image); $       count=LSBFirstReadLong(image);'       filesize=LSBFirstReadLong(image); $       for (i=0; i < (count-12); i++)         (void) ReadByte(image);      }    box.width=0;   box.height=0;    /*&     Copy Postscript to temporary file.   */
   level=0;   eps_level=0;   p=command;P   for (i=0; (Latin1Compare(image_info->magick,"EPT") != 0) || i < filesize; i++)   {      c=ReadByte(image);     if (c == EOF)        break;     (void) fputc(c,file);      *p++=c; H     if ((c != '\n') && (c != '\r') && ((p-command) < (MaxTextExtent-1)))       continue;      *p='\0';     p=command;F     if (strncmp(PostscriptLevel,command,Extent(PostscriptLevel)) == 0)L       (void) sscanf(command,"%%!PS-Adobe-%d.0 EPSF-%d.0",&level,&eps_level);8     if (strncmp(ShowPage,command,Extent(ShowPage)) == 0)       eps_level=0;     /*%       Parse a bounding box statement.      */     count=0;>     if (strncmp(BoundingBox,command,Extent(BoundingBox)) == 0)O       count=sscanf(command,"%%%%BoundingBox: %lf %lf %lf %lf",&bounding_box.x1, <         &bounding_box.y1,&bounding_box.x2,&bounding_box.y2);B     if (strncmp(DocumentMedia,command,Extent(DocumentMedia)) == 0)M       count=sscanf(command,"%%%%DocumentMedia: %*s %lf %lf",&bounding_box.x2,          &bounding_box.y2)+2;F     if (strncmp(PageBoundingBox,command,Extent(PageBoundingBox)) == 0)B       count=sscanf(command,"%%%%PageBoundingBox: %lf %lf %lf %lf",M         &bounding_box.x1,&bounding_box.y1,&bounding_box.x2,&bounding_box.y2);      if (count != 4)        continue; .     if ((bounding_box.x1 > bounding_box.x2) ||,         (bounding_box.y1 > bounding_box.y2))       continue;      /*%       Set Postscript render geometry.      */I     FormatString(translate_geometry,"%f %f translate\n",-bounding_box.x1,        -bounding_box.y1);;     width=(unsigned int) (bounding_box.x2-bounding_box.x1); ;     if ((float) ((int) bounding_box.x2) != bounding_box.x2)        width++;<     height=(unsigned int) (bounding_box.y2-bounding_box.y1);;     if ((float) ((int) bounding_box.y2) != bounding_box.y2)        height++; 7     if ((width <= box.width) && (height <= box.height))        continue;      page_info.width=width;     page_info.height=height;     box=page_info;   }    if (eps_level != 0) $     (void) fputs("showpage\n",file);(   if (image_info->page != (char *) NULL)I     (void) ParseImageGeometry(image_info->page,&page_info.x,&page_info.y, *       &page_info.width,&page_info.height);    FormatString(geometry,"%ux%u",M     (unsigned int) ((page_info.width*image->x_resolution+0.5)/dx_resolution), O     (unsigned int) ((page_info.height*image->y_resolution+0.5)/dy_resolution));    if (ferror(file))      { L       MagickWarning(FileOpenWarning,"An error has occurred writing to file",         postscript_filename);        (void) fclose(file);       return((Image *) NULL);      } !   (void) fseek(file,0L,SEEK_SET); (   (void) fputs(translate_geometry,file);   (void) fclose(file);   CloseBlob(image);    filesize=image->filesize;    DestroyImage(image);   /*0     Use Ghostscript to convert Postscript image.   */   *options='\0';    if (image_info->subrange != 0)8     FormatString(options,"-dFirstPage=%u -dLastPage=%u",H       image_info->subimage+1,image_info->subimage+image_info->subrange);/   (void) strcpy(filename,image_info->filename); 3   TemporaryFilename((char *) image_info->filename); L   FormatString(command,delegate_info.commands,image_info->antialias ? 4 : 1,P     image_info->antialias ? 4 : 1,geometry,density,options,image_info->filename,     postscript_filename); ,   ProgressMonitor(RenderPostscriptText,0,8);4   status=SystemCommand(image_info->verbose,command);*   if (!IsAccessible(image_info->filename))     {        /*1         Ghostscript requires a showpage operator.        */7       file=fopen(postscript_filename,AppendBinaryType);         if (file == (FILE *) NULL)A         ReaderExit(FileOpenWarning,"Unable to write file",image); &       (void) fputs("showpage\n",file);       (void) fclose(file);8       status=SystemCommand(image_info->verbose,command);     } %   (void) remove(postscript_filename); ,   ProgressMonitor(RenderPostscriptText,7,8);
   if (status)      {        /*F         Ghostscript has failed-- try the Display Postscript Extension.       */<       (void) strcpy((char *) image_info->filename,filename);%       image=ReadDPSImage(image_info); "       if (image != (Image *) NULL)         return(image);G       MagickWarning(CorruptImageWarning,"Postscript delegation failed",          image_info->filename);       return((Image *) NULL);      } (   local_info=CloneImageInfo(image_info);(   GetBlobInfo(&(local_info->blob_info));!   image=ReadPNMImage(local_info);    DestroyImageInfo(local_info); &   (void) remove(image_info->filename);   if (image == (Image *) NULL)     { G       MagickWarning(CorruptImageWarning,"Postscript delegation failed",          image_info->filename);       return((Image *) NULL);      } 8   (void) strcpy((char *) image_info->filename,filename);   do   { &     (void) strcpy(image->magick,"PS");8     (void) strcpy(image->filename,image_info->filename);     image->filesize=filesize;      next_image=image->next; %     if (next_image != (Image *) NULL)        image=next_image; )   } while (next_image != (Image *) NULL); +   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P S I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method WritePSImage translates an image to encapsulated Postscript H %  Level I for printing.  If the supplied geometry is null, the image isJ %  centered on the Postscript page.  Otherwise, the image is positioned as %  specified by the geometry.  % , %  The format of the WritePSImage method is: % J %      unsigned int WritePSImage(const ImageInfo *image_info,Image *image) % + %  A description of each parameter follows:  % G %    o status: Method WritePSImage return True if the image is printed. I %      False is returned if the image file cannot be opened for printing.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */J Export unsigned int WritePSImage(const ImageInfo *image_info,Image *image) {    static const char      *PostscriptProlog[]=     {        "%%BeginProlog",
       "%",E       "% Display a color image.  The image is displayed in color on", G       "% Postscript viewers or printers that support color, otherwise", (       "% it is displayed as grayscale.",
       "%",       "/buffer 512 string def",        "/byte 1 string def", #       "/color_packet 3 string def",        "/pixels 768 string def", 	       "",        "/DirectClassPacket", 
       "{",       "  %",&       "  % Get a DirectClass packet.",       "  %",       "  % Parameters:",       "  %   red.",        "  %   green.",        "  %   blue.",K       "  %   length: number of pixels minus one of this color (optional).",        "  %",9       "  currentfile color_packet readhexstring pop pop",        "  compression 0 gt",        "  {",!       "    /number_pixels 3 def",        "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get", 0       "    /number_pixels exch 1 add 3 mul def",       "  } ifelse", "       "  0 3 number_pixels 1 sub",       "  {",1       "    pixels exch color_packet putinterval",        "  } for",-       "  pixels 0 number_pixels getinterval",        "} bind def", 	       "",        "/DirectClassImage",
       "{",       "  %",)       "  % Display a DirectClass image.",        "  %",'       "  systemdict /colorimage known",        "  {",       "    columns rows 8",        "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",5       "    { DirectClassPacket } false 3 colorimage",        "  }",       "  {",       "    %",=       "    % No colorimage operator;  convert to grayscale.",        "    %",       "    columns rows 8",        "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",,       "    { GrayDirectClassPacket } image",       "  } ifelse",        "} bind def", 	       "",        "/GrayDirectClassPacket", 
       "{",       "  %",=       "  % Get a DirectClass packet;  convert to grayscale.",        "  %",       "  % Parameters:",       "  %   red",       "  %   green",       "  %   blue", K       "  %   length: number of pixels minus one of this color (optional).",        "  %",9       "  currentfile color_packet readhexstring pop pop", '       "  color_packet 0 get 0.299 mul", +       "  color_packet 1 get 0.587 mul add", +       "  color_packet 2 get 0.114 mul add",        "  cvi",        "  /gray_packet exch def",       "  compression 0 gt",        "  {",!       "    /number_pixels 1 def",        "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get", *       "    /number_pixels exch 1 add def",       "  } ifelse", "       "  0 1 number_pixels 1 sub",       "  {",(       "    pixels exch gray_packet put",       "  } for",-       "  pixels 0 number_pixels getinterval",        "} bind def", 	       "",        "/GrayPseudoClassPacket", 
       "{",       "  %",=       "  % Get a PseudoClass packet;  convert to grayscale.",        "  %",       "  % Parameters:",.       "  %   index: index into the colormap.",K       "  %   length: number of pixels minus one of this color (optional).",        "  %",3       "  currentfile byte readhexstring pop 0 get", !       "  /offset exch 3 mul def", :       "  /color_packet colormap offset 3 getinterval def",'       "  color_packet 0 get 0.299 mul", +       "  color_packet 1 get 0.587 mul add", +       "  color_packet 2 get 0.114 mul add",        "  cvi",        "  /gray_packet exch def",       "  compression 0 gt",        "  {",!       "    /number_pixels 1 def",        "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get", *       "    /number_pixels exch 1 add def",       "  } ifelse", "       "  0 1 number_pixels 1 sub",       "  {",(       "    pixels exch gray_packet put",       "  } for",-       "  pixels 0 number_pixels getinterval",        "} bind def", 	       "",        "/PseudoClassPacket", 
       "{",       "  %",&       "  % Get a PseudoClass packet.",       "  %",       "  % Parameters:",.       "  %   index: index into the colormap.",K       "  %   length: number of pixels minus one of this color (optional).",        "  %",3       "  currentfile byte readhexstring pop 0 get", !       "  /offset exch 3 mul def", :       "  /color_packet colormap offset 3 getinterval def",       "  compression 0 gt",        "  {",!       "    /number_pixels 3 def",        "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get", 0       "    /number_pixels exch 1 add 3 mul def",       "  } ifelse", "       "  0 3 number_pixels 1 sub",       "  {",1       "    pixels exch color_packet putinterval",        "  } for",-       "  pixels 0 number_pixels getinterval",        "} bind def", 	       "",        "/PseudoClassImage",
       "{",       "  %",)       "  % Display a PseudoClass image.",        "  %",       "  % Parameters:",3       "  %   class: 0-PseudoClass or 1-Grayscale.",        "  %",*       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",       "  class 0 gt",        "  {",,       "    currentfile buffer readline pop",*       "    token pop /depth exch def pop",G       "    /grays columns 8 add depth sub depth mul 8 idiv string def",        "    columns rows depth",        "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",:       "    { currentfile grays readhexstring pop } image",       "  }",       "  {",       "    %",       "    % Parameters:",:       "    %   colors: number of colors in the colormap.",:       "    %   colormap: red, green, blue color packets.",       "    %",,       "    currentfile buffer readline pop",+       "    token pop /colors exch def pop", %       "    /colors colors 3 mul def", (       "    /colormap colors string def",7       "    currentfile colormap readhexstring pop pop", )       "    systemdict /colorimage known",        "    {",       "      columns rows 8",        "      [",       "        columns 0 0",        "        rows neg 0 rows",       "      ]",7       "      { PseudoClassPacket } false 3 colorimage",        "    }",       "    {",       "      %",?       "      % No colorimage operator;  convert to grayscale.",        "      %",       "      columns rows 8",        "      [",       "        columns 0 0",        "        rows neg 0 rows",       "      ]",.       "      { GrayPseudoClassPacket } image",       "    } ifelse",        "  } ifelse",        "} bind def", 	       "",        "/DisplayImage",
       "{",       "  %",8       "  % Display a DirectClass or PseudoClass image.",       "  %",       "  % Parameters:",!       "  %   x & y translation.",        "  %   x & y scale.",        "  %   label pointsize.",        "  %   image label.", $       "  %   image columns & rows.",5       "  %   class: 0-DirectClass or 1-PseudoClass.", M       "  %   compression: 0-RunlengthEncodedCompression or 1-NoCompression.", !       "  %   hex color packets.",        "  %",       "  gsave",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",       "  x y translate",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",*       "  currentfile buffer readline pop",,       "  token pop /pointsize exch def pop",:       "  /Helvetica findfont pointsize scalefont setfont",       (char *) NULL      },     *PostscriptEpilog[]=     {        "  x y scale",*       "  currentfile buffer readline pop",&       "  token pop /columns exch def",'       "  token pop /rows exch def pop", *       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",*       "  currentfile buffer readline pop",.       "  token pop /compression exch def pop",F       "  class 0 gt { PseudoClassImage } { DirectClassImage } ifelse",       "  grestore",        (char *) NULL      };     char     buffer[MaxTextExtent],     date[MaxTextExtent],     density[MaxTextExtent],      geometry[MaxTextExtent],
     **labels;      const char     **q;     double     dx_resolution,     dy_resolution,     x_resolution,      x_scale,     y_resolution,      y_scale;  
   IndexPacket 
     index;     int      length,      max_runlength,     x,     y;  
   PixelPacket 
     pixel;     register PixelPacket     *p;      register int     i;  
   SegmentInfo      bounding_box;      time_t
     timer;     unsigned int     bit,	     byte, 
     count,     height, 	     page, 
     polarity, 
     scene,     status,      text_size,
     width;     /*     Open output image file.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);	   page=1; 
   scene=0;   do   {      /*-       Scale image to size of Postscript page.      */+     TransformRGBImage(image,RGBColorspace);      text_size=0;&     if (image->label != (char *) NULL)G       text_size=MultilineCensus(image->label)*image_info->pointsize+12;      width=image->columns;      height=image->rows;      x=0;     y=text_size;>     FormatString(geometry,"%ux%u",image->columns,image->rows);*     if (image_info->page != (char *) NULL)/       (void) strcpy(geometry,image_info->page);      elseJ       if ((image->page_info.width != 0) && (image->page_info.height != 0))J         (void) FormatString(geometry,"%ux%u%+d%+d",image->page_info.width,B 	  image->page_info.height,image->page_info.x,image->page_info.y);
       else8         if (Latin1Compare(image_info->magick,"PS") == 0)1           (void) strcpy(geometry,PSPageGeometry); =     (void) ParseImageGeometry(geometry,&x,&y,&width,&height);      /*&       Scale relative to dots-per-inch.     */     dx_resolution=72.0;      dy_resolution=72.0;      x_resolution=72.0;-     (void) strcpy(density,PSDensityGeometry); @     count=sscanf(density,"%lfx%lf",&x_resolution,&y_resolution);     if (count != 2)         y_resolution=x_resolution;-     if (image_info->density != (char *) NULL)        { P         count=sscanf(image_info->density,"%lfx%lf",&x_resolution,&y_resolution);         if (count != 2) $           y_resolution=x_resolution;       } /     x_scale=(width*dx_resolution)/x_resolution; '     width=(unsigned int) (x_scale+0.5); 0     y_scale=(height*dy_resolution)/y_resolution;(     height=(unsigned int) (y_scale+0.5);     if (page == 1)       { 
         /*#           Output Postscript header. 
         */8         if (Latin1Compare(image_info->magick,"PS") == 0)3           (void) strcpy(buffer,"%!PS-Adobe-3.0\n");          else<           (void) strcpy(buffer,"%!PS-Adobe-3.0 EPSF-3.0\n");6         (void) WriteBlob(image,strlen(buffer),buffer);;         (void) strcpy(buffer,"%%Creator: (ImageMagick)\n"); 6         (void) WriteBlob(image,strlen(buffer),buffer);H         (void) sprintf(buffer,"%%%%Title: (%.1024s)\n",image->filename);6         (void) WriteBlob(image,strlen(buffer),buffer);$         timer=time((time_t *) NULL);!         (void) localtime(&timer); *         (void) strcpy(date,ctime(&timer));"         date[Extent(date)-1]='\0';D         (void) sprintf(buffer,"%%%%CreationDate: (%.1024s)\n",date);6         (void) WriteBlob(image,strlen(buffer),buffer);         bounding_box.x1=x;         bounding_box.y1=y;$         bounding_box.x2=x+x_scale-1;/         bounding_box.y2=y+(height+text_size)-1; B         if (image_info->adjoin && (image->next != (Image *) NULL))=           (void) strcpy(buffer,"%%%%BoundingBox: (atend)\n");          elseA           (void) sprintf(buffer,"%%%%BoundingBox: %g %g %g %g\n", M             bounding_box.x1,bounding_box.y1,bounding_box.x2,bounding_box.y2); 6         (void) WriteBlob(image,strlen(buffer),buffer);*         if (image->label != (char *) NULL)           { !             (void) strcpy(buffer, ?               "%%%%DocumentNeededResources: font Helvetica\n"); :             (void) WriteBlob(image,strlen(buffer),buffer);           } <         (void) strcpy(buffer,"%%DocumentData: Clean7Bit\n");6         (void) WriteBlob(image,strlen(buffer),buffer);5         (void) strcpy(buffer,"%%LanguageLevel: 1\n"); 6         (void) WriteBlob(image,strlen(buffer),buffer);8         if (Latin1Compare(image_info->magick,"PS") != 0)           { 1             (void) strcpy(buffer,"%%Pages: 0\n"); :             (void) WriteBlob(image,strlen(buffer),buffer);           }          else           {              Image                *next_image;               unsigned int               pages;               /**               Compute the number of pages.             */>             (void) strcpy(buffer,"%%Orientation: Portrait\n");:             (void) WriteBlob(image,strlen(buffer),buffer);:             (void) strcpy(buffer,"%%PageOrder: Ascend\n");:             (void) WriteBlob(image,strlen(buffer),buffer);             pages=1;#             if (image_info->adjoin) J               for (next_image=image->next; next_image != (Image *) NULL; )               { ,                 next_image=next_image->next;                 pages++;               } ;             (void) sprintf(buffer,"%%%%Pages: %u\n",pages); :             (void) WriteBlob(image,strlen(buffer),buffer);           } 0         (void) strcpy(buffer,"%%EndComments\n");6         (void) WriteBlob(image,strlen(buffer),buffer);4         (void) strcpy(buffer,"\n%%BeginDefaults\n");6         (void) WriteBlob(image,strlen(buffer),buffer);>         (void) strcpy(buffer,"%%PageOrientation: Portrait\n");6         (void) WriteBlob(image,strlen(buffer),buffer);2         (void) strcpy(buffer,"%%EndDefaults\n\n");6         (void) WriteBlob(image,strlen(buffer),buffer);=         if ((Latin1Compare(image_info->magick,"EPI") == 0) || =             (Latin1Compare(image_info->magick,"EPT") == 0) || <             (Latin1Compare(image_info->magick,"EPSI") == 0))           {              Image                *preview_image;                /*#               Create preview image.              */L             preview_image=CloneImage(image,image->columns,image->rows,True);0             if (preview_image == (Image *) NULL)P               WriterExit(ResourceLimitWarning,"Memory allocation failed",image);             /*#               Dump image as bitmap.              */2             if (!IsMonochromeImage(preview_image))               {                  QuantizeInfo                    quantize_info;  0                 GetQuantizeInfo(&quantize_info);.                 quantize_info.number_colors=2;8                 quantize_info.dither=image_info->dither;8                 quantize_info.colorspace=GRAYColorspace;C                 (void) QuantizeImage(&quantize_info,preview_image);                } K             polarity=Intensity(preview_image->colormap[0]) < (MaxRGB >> 1); +             if (preview_image->colors == 2) >               polarity=Intensity(preview_image->colormap[0]) >6                 Intensity(preview_image->colormap[1]);H             (void) sprintf(buffer,"%%%%BeginPreview: %u %u %u %u\n%%  ",J               preview_image->columns,preview_image->rows,(unsigned int) 1,M               (((preview_image->columns+7) >> 3)*preview_image->rows+35)/36); :             (void) WriteBlob(image,strlen(buffer),buffer);             count=0;1             for (y=0; y < (int) image->rows; y++) 
             { M               if (!GetPixelCache(preview_image,0,y,preview_image->columns,1))                  break;               bit=0;               byte=0; >               for (x=0; x < (int) preview_image->columns; x++)               {                  byte<<=1; 2                 if (image->indexes[x] == polarity)                   byte|=0x01;                  bit++;                 if (bit == 8)                    { >                     (void) sprintf(buffer,"%02x",byte & 0xff);B                     (void) WriteBlob(image,strlen(buffer),buffer);                     count++;$                     if (count == 36)                       { 7                         (void) strcpy(buffer,"\n%%  "); F                         (void) WriteBlob(image,strlen(buffer),buffer);                          count=0;                       };                     bit=0;                     byte=0;                    }                }                if (bit != 0)                  { !                   byte<<=(8-bit); <                   (void) sprintf(buffer,"%02x",byte & 0xff);@                   (void) WriteBlob(image,strlen(buffer),buffer);                   count++;"                   if (count == 36)                     { 5                       (void) strcpy(buffer,"\n%%  "); D                       (void) WriteBlob(image,strlen(buffer),buffer);                       count=0;                     };                 };
             } 5             (void) strcpy(buffer,"\n%%EndPreview\n"); :             (void) WriteBlob(image,strlen(buffer),buffer);(             DestroyImage(preview_image);           } 
         /*%           Output Postscript commands. 
         */)         for (q=PostscriptProlog; *q; q++) 	         { /           (void) sprintf(buffer,"%.255s\n",*q); 8           (void) WriteBlob(image,strlen(buffer),buffer);	         } <         for (i=MultilineCensus(image->label)-1; i >= 0; i--)	         { <           (void) strcpy(buffer,"  /label 512 string def\n");8           (void) WriteBlob(image,strlen(buffer),buffer);E           (void) strcpy(buffer,"  currentfile label readline pop\n"); 8           (void) WriteBlob(image,strlen(buffer),buffer);G           (void) sprintf(buffer,"  0 y %f add moveto label show pop\n", (             i*image_info->pointsize+12);8           (void) WriteBlob(image,strlen(buffer),buffer);	         } )         for (q=PostscriptEpilog; *q; q++) 	         { /           (void) sprintf(buffer,"%.255s\n",*q); 8           (void) WriteBlob(image,strlen(buffer),buffer);	         } 8         if (Latin1Compare(image_info->magick,"PS") == 0)           { 1             (void) strcpy(buffer,"  showpage\n"); :             (void) WriteBlob(image,strlen(buffer),buffer);           } -         (void) strcpy(buffer,"} bind def\n"); 6         (void) WriteBlob(image,strlen(buffer),buffer);.         (void) strcpy(buffer,"%%EndProlog\n");6         (void) WriteBlob(image,strlen(buffer),buffer);       } 6     (void) sprintf(buffer,"%%%%Page:  1 %u\n",page++);2     (void) WriteBlob(image,strlen(buffer),buffer);C     (void) sprintf(buffer,"%%%%PageBoundingBox: %d %d %d %d\n",x,y, 0       x+(int) width,y+(int) (height+text_size));2     (void) WriteBlob(image,strlen(buffer),buffer);     if (x < bounding_box.x1)       bounding_box.x1=x;     if (y < bounding_box.y1)       bounding_box.y1=y;,     if ((x+(int) width-1) > bounding_box.x2)        bounding_box.x2=x+width-1;9     if ((y+(int) (height+text_size)-1) > bounding_box.y2) -       bounding_box.y2=y+(height+text_size)-1; &     if (image->label != (char *) NULL)       { D         (void) strcpy(buffer,"%%%%PageResources: font Helvetica\n");6         (void) WriteBlob(image,strlen(buffer),buffer);       } 4     if (Latin1Compare(image_info->magick,"PS") != 0)       { 1         (void) strcpy(buffer,"userdict begin\n"); 6         (void) WriteBlob(image,strlen(buffer),buffer);       } +     (void) strcpy(buffer,"%%BeginData:\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);+     (void) strcpy(buffer,"DisplayImage\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);     /*       Output image data.     */&     labels=StringToList(image->label);C     (void) sprintf(buffer,"%d %d\n%g %g\n%f\n",x,y,x_scale,y_scale,        image_info->pointsize); 2     (void) WriteBlob(image,strlen(buffer),buffer);!     if (labels != (char **) NULL)        { 2         for (i=0; labels[i] != (char *) NULL; i++)	         { 8           (void) sprintf(buffer,"%.1024s \n",labels[i]);8           (void) WriteBlob(image,strlen(buffer),buffer);            FreeMemory(labels[i]);	         }          FreeMemory(labels);        }      GetPixelPacket(&pixel);      i=0;     index=0;
     length=0;      max_runlength=255;     x=0;5     if (!IsPseudoClass(image) && !IsGrayImage(image))        { 
         /*!           Dump DirectClass image. 
         */0         (void) sprintf(buffer,"%u %u\n%d\n%d\n",I           image->columns,image->rows,(int) (image->class == PseudoClass), <           (int) (image_info->compression == NoCompression));6         (void) WriteBlob(image,strlen(buffer),buffer);(         switch (image_info->compression)	         { +           case RunlengthEncodedCompression:            default:           {              /*9               Dump runlength-encoded DirectColor packets.              */1             for (y=0; y < (int) image->rows; y++) 
             { :               p=GetPixelCache(image,0,y,image->columns,1);,               if (p == (PixelPacket *) NULL)                 break;               if (y == 0)                  {                    pixel=(*p); 2                   if (image->class == PseudoClass),                     index=(*image->indexes);                 } 6               for (x=0; x < (int) image->columns; x++)               { 6                 if ((x == (int) (image->columns-1)) &&1                     (y == (int) (image->rows-1))) "                   max_runlength=0;I                 if ((p->red == pixel.red) && (p->green == pixel.green) && O                     (p->blue == pixel.blue) && (p->opacity == pixel.opacity) && -                     (length < max_runlength))                    length++;                  else                   { D                     if (image->matte && (p->opacity == Transparent))G                       (void) sprintf(buffer,"ffffff%02x",(unsigned int) *                         Min(length,0xff));                     elseC                       (void) sprintf(buffer,"%02lx%02lx%02lx%02lx", D                         DownScale(pixel.red),DownScale(pixel.green),.                         DownScale(pixel.blue),:                         (unsigned long) Min(length,0xff));B                     (void) WriteBlob(image,strlen(buffer),buffer);                     i++;                     if (i == 9)                        { 3                         (void) strcpy(buffer,"\n");                          i=0;                       }                      length=0;                    }                  pixel=(*p++);                } 4               if (image->previous == (Image *) NULL)/                 if (QuantumTick(y,image->rows)) ?                   ProgressMonitor(SaveImageText,y,image->rows); 
             }              break;           }            case NoCompression:            {              /*4               Dump uncompressed DirectColor packets.             */             i=0;1             for (y=0; y < (int) image->rows; y++) 
             { :               p=GetPixelCache(image,0,y,image->columns,1);,               if (p == (PixelPacket *) NULL)                 break;6               for (x=0; x < (int) image->columns; x++)               { @                 if (image->matte && (p->opacity == Transparent))1                   (void) strcpy(buffer,"ffffff");                  else:                   (void) sprintf(buffer,"%02lx%02lx%02lx",N                     DownScale(p->red),DownScale(p->green),DownScale(p->blue));>                 (void) WriteBlob(image,strlen(buffer),buffer);                 i++;                 if (i == 12)                   {                      i=0;1                     (void) WriteByte(image,'\n');                    }                  p++;               } 4               if (image->previous == (Image *) NULL)/                 if (QuantumTick(y,image->rows)) ?                   ProgressMonitor(SaveImageText,y,image->rows); 
             }              break;           } 	         } #         (void) strcpy(buffer,"\n");        }      else       if (IsGrayImage(image)) 	         { 7           (void) sprintf(buffer,"%u %u\n1\n1\n1\n%d\n", I             image->columns,image->rows,IsMonochromeImage(image) ? 1 : 8); 8           (void) WriteBlob(image,strlen(buffer),buffer);(           if (!IsMonochromeImage(image))
             {                /*(                 Dump image as grayscale.               */               i++;3               for (y=0; y < (int) image->rows; y++)                { <                 p=GetPixelCache(image,0,y,image->columns,1);.                 if (p == (PixelPacket *) NULL)                   break;8                 for (x=0; x < (int) image->columns; x++)                 { >                   (void) sprintf(buffer,"%02x",Intensity(*p));@                   (void) WriteBlob(image,strlen(buffer),buffer);                   i++;                   if (i == 36)                     { 3                       (void) WriteByte(image,'\n');                        i=0;                     }                    p++;                 } 6                 if (image->previous == (Image *) NULL)1                   if (QuantumTick(y,image->rows)) A                     ProgressMonitor(SaveImageText,y,image->rows);                } 
             }            else
             {                int                  y;                 /*%                 Dump image as bitmap.                */E               polarity=Intensity(image->colormap[0]) > (MaxRGB >> 1); %               if (image->colors == 2)                  polarity= P                   Intensity(image->colormap[1]) > Intensity(image->colormap[0]);               count=0;3               for (y=0; y < (int) image->rows; y++)                { ?                 if (!GetPixelCache(image,0,y,image->columns,1))                    break;                 bit=0;                 byte=0; 8                 for (x=0; x < (int) image->columns; x++)                 {                    byte<<=1; 4                   if (image->indexes[x] == polarity)                     byte|=0x01;                    bit++;                   if (bit == 8)                      { @                       (void) sprintf(buffer,"%02x",byte & 0xff);D                       (void) WriteBlob(image,strlen(buffer),buffer);                       count++;&                       if (count == 36)                         { 7                           (void) WriteByte(image,'\n'); "                           count=0;                         };                       bit=0;                       byte=0;                      }                    p++;                 }                  if (bit != 0)                    { #                     byte<<=(8-bit); >                     (void) sprintf(buffer,"%02x",byte & 0xff);B                     (void) WriteBlob(image,strlen(buffer),buffer);                     count++;$                     if (count == 36)                       { 5                         (void) WriteByte(image,'\n');                           count=0;                       };                   };6                 if (image->previous == (Image *) NULL)1                   if (QuantumTick(y,image->rows)) A                     ProgressMonitor(SaveImageText,y,image->rows);                } 
             }            if (count != 0) )             (void) WriteByte(image,'\n'); 	         } 
       else	         {            /*#             Dump PseudoClass image.            */5           (void) sprintf(buffer,"%u %u\n%d\n%d\n0\n", K             image->columns,image->rows,(int) (image->class == PseudoClass), >             (int) (image_info->compression == NoCompression));8           (void) WriteBlob(image,strlen(buffer),buffer);           /*/             Dump number of colors and colormap.            */6           (void) sprintf(buffer,"%u\n",image->colors);8           (void) WriteBlob(image,strlen(buffer),buffer);1           for (i=0; i < (int) image->colors; i++)            { 6             (void) sprintf(buffer,"%02lx%02lx%02lx\n",0               DownScale(image->colormap[i].red),2               DownScale(image->colormap[i].green),2               DownScale(image->colormap[i].blue));:             (void) WriteBlob(image,strlen(buffer),buffer);           } *           switch (image_info->compression)           { -             case RunlengthEncodedCompression:              default:
             {                /*;                 Dump runlength-encoded PseudoColor packets.                */               i=0;3               for (y=0; y < (int) image->rows; y++)                { <                 p=GetPixelCache(image,0,y,image->columns,1);.                 if (p == (PixelPacket *) NULL)                   break;                 if (y == 0)                    {                      pixel=(*p); ,                     index=(*image->indexes);                   } 8                 for (x=0; x < (int) image->columns; x++)                 { 8                   if ((x == (int) (image->columns-1)) &&3                       (y == (int) (image->rows-1))) $                     max_runlength=0;O                   if ((index == image->indexes[x]) && (length < max_runlength))                      length++;                    else                     { E                       (void) sprintf(buffer,"%02x%02x",(unsigned int) ?                         index,(unsigned int) Min(length,0xff)); D                       (void) WriteBlob(image,strlen(buffer),buffer);                       i++;"                       if (i == 18)                         { 7                           (void) WriteByte(image,'\n');                            i=0;                         }                        length=0;                      } *                   index=image->indexes[x];                   pixel=(*p++);                  } 6                 if (image->previous == (Image *) NULL)1                   if (QuantumTick(y,image->rows)) A                     ProgressMonitor(SaveImageText,y,image->rows);                }                break;
             }              case NoCompression: 
             {                /*6                 Dump uncompressed PseudoColor packets.               */               i=0;3               for (y=0; y < (int) image->rows; y++)                { <                 p=GetPixelCache(image,0,y,image->columns,1);.                 if (p == (PixelPacket *) NULL)                   break;8                 for (x=0; x < (int) image->columns; x++)                 { B                   (void) sprintf(buffer,"%02x",image->indexes[x]);@                   (void) WriteBlob(image,strlen(buffer),buffer);                   i++;                   if (i == 36)                     { 3                       (void) WriteByte(image,'\n');                        i=0;                     }                    p++;                 } 6                 if (image->previous == (Image *) NULL)1                   if (QuantumTick(y,image->rows)) A                     ProgressMonitor(SaveImageText,y,image->rows);                }                break;
             }            } '           (void) WriteByte(image,'\n'); 	         } (     (void) strcpy(buffer,"%%EndData\n");2     (void) WriteBlob(image,strlen(buffer),buffer);4     if (Latin1Compare(image_info->magick,"PS") != 0)       { &         (void) strcpy(buffer,"end\n");6         (void) WriteBlob(image,strlen(buffer),buffer);       } ,     (void) strcpy(buffer,"%%PageTrailer\n");2     (void) WriteBlob(image,strlen(buffer),buffer);&     if (image->next == (Image *) NULL)       break;     image=GetNextImage(image);C     ProgressMonitor(SaveImagesText,scene++,GetNumberScenes(image));    } while (image_info->adjoin);    if (image_info->adjoin) -     while (image->previous != (Image *) NULL)        image=image->previous;&   (void) strcpy(buffer,"%%Trailer\n");0   (void) WriteBlob(image,strlen(buffer),buffer);   if (page > 1)      { =       (void) sprintf(buffer,"%%%%BoundingBox: %g %g %g %g\n", I         bounding_box.x1,bounding_box.y1,bounding_box.x2,bounding_box.y2); 4       (void) WriteBlob(image,strlen(buffer),buffer);     } "   (void) strcpy(buffer,"%%EOF\n");0   (void) WriteBlob(image,strlen(buffer),buffer);   CloseBlob(image);    return(True);  } 