 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %           QQQ   U   U   AAA   N   N  TTTTT  IIIII   ZZZZZ  EEEEE            % O %          Q   Q  U   U  A   A  NN  N    T      I        ZZ  E                % O %          Q   Q  U   U  AAAAA  N N N    T      I      ZZZ   EEEEE            % O %          Q  QQ  U   U  A   A  N  NN    T      I     ZZ     E                % O %           QQQQ   UUU   A   A  N   N    T    IIIII   ZZZZZ  EEEEE            % O %                                                                             % O %                                                                             % O %         Methods to Reduce the Number of Unique Colors in an Image           % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                              July 1992                                      % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Realism in computer graphics typically requires using 24 bits/pixel to F %  generate an image.  Yet many graphic display devices do not contain@ %  the amount of memory necessary to match the spatial and colorD %  resolution of the human eye.  The QUANTIZE program takes a 24 bitC %  image and reduces the number of colors so it can be displayed on B %  raster device with less bits per pixel.  In most instances, theB %  quantized image closely resembles the original reference image. % @ %  A reduction of colors in an image is also desirable for image( %  transmission and real-time animation. % J %  Method Quantize takes a standard RGB or monochrome images and quantizes, %  them down to some fixed number of colors. % I %  For purposes of color allocation, an image is a set of n pixels, where D %  each pixel is a point in RGB space.  RGB space is a 3-dimensionalH %  vector space, and each pixel, pi,  is defined by an ordered triple of2 %  red, green, and blue coordinates, (ri, gi, bi). % C %  Each primary color component (red, green, or blue) represents an I %  intensity which varies linearly from 0 to a maximum value, cmax, which E %  corresponds to full saturation of that color.  Color allocation is A %  defined over a domain consisting of the cube in RGB space with H %  opposite vertices at (0,0,0) and (cmax,cmax,cmax).  QUANTIZE requires %  cmax = 255. % @ %  The algorithm maps this domain onto a tree in which each nodeE %  represents a cube within that domain.  In the following discussion F %  these cubes are defined by the coordinate of two opposite vertices:E %  The vertex nearest the origin in RGB space and the vertex farthest  %  from the origin.  % I %  The tree's root node represents the the entire domain, (0,0,0) through B %  (cmax,cmax,cmax).  Each lower level in the tree is generated byF %  subdividing one node's cube into eight smaller cubes of equal size.D %  This corresponds to bisecting the parent cube with planes passing& %  through the midpoints of each edge. % @ %  The basic algorithm operates in three phases: Classification,< %  Reduction, and Assignment.  Classification builds a colorF %  description tree for the image.  Reduction collapses the tree untilI %  the number it represents, at most, the number of colors desired in the E %  output image.  Assignment defines the output image's color map and C %  sets each pixel's color by reclassification in the reduced tree. K %  Our goal is to minimize the numerical discrepancies between the original 4 %  colors and quantized colors (quantization error). % D %  Classification begins by initializing a color description tree ofE %  sufficient depth to represent each possible input color in a leaf. > %  However, it is impractical to generate a fully-formed colorG %  description tree in the classification phase for realistic values of H %  cmax.  If colors components in the input image are quantized to k-bitH %  precision, so that cmax= 2k-1, the tree would need k levels below theG %  root node to allow representing each possible input color in a leaf. G %  This becomes prohibitive because the tree's total number of nodes is  %  1 + sum(i=1,k,8k).  % H %  A complete tree would require 19,173,961 nodes for k = 8, cmax = 255.E %  Therefore, to avoid building a fully populated tree, QUANTIZE: (1) F %  Initializes data structures for nodes only as they are needed;  (2)D %  Chooses a maximum depth for the tree as a function of the desiredH %  number of colors in the output image (currently log2(colormap size)). % H %  For each pixel in the input image, classification scans downward fromH %  the root of the color description tree.  At each level of the tree itB %  identifies the single node which represents a cube in RGB spaceH %  containing the pixel's color.  It updates the following data for each
 %  such node:  % B %    n1: Number of pixels whose color is contained in the RGB cube  %    which this node represents; % E %    n2: Number of pixels whose color is not represented in a node at F %    lower depth in the tree;  initially,  n2 = 0 for all nodes except %    leaves of the tree. % F %    Sr, Sg, Sb: Sums of the red, green, and blue component values forC %    all pixels not classified at a lower depth. The combination of H %    these sums and n2  will ultimately characterize the mean color of a, %    set of pixels represented by this node. % F %    E: The distance squared in RGB space between each pixel containedK %    within a node and the nodes' center.  This represents the quantization  %    error for a node. % F %  Reduction repeatedly prunes the tree until the number of nodes withG %  n2 > 0 is less than or equal to the maximum number of colors allowed I %  in the output image.  On any given iteration over the tree, it selects D %  those nodes whose E count is minimal for pruning and merges theirF %  color statistics upward. It uses a pruning threshold, Ep, to govern %  node selection as follows:  %  %    Ep = 0 L %    while number of nodes with (n2 > 0) > required maximum number of colors( %      prune all nodes such that E <= Ep- %      Set Ep to minimum E in remaining nodes  % H %  This has the effect of minimizing any quantization error when merging %  two nodes together. % H %  When a node to be pruned has offspring, the pruning procedure invokesH %  itself recursively in order to prune the tree from the leaves upward.G %  n2,  Sr, Sg,  and  Sb in a node being pruned are always added to the E %  corresponding data in that node's parent.  This retains the pruned 4 %  node's color characteristics for later averaging. % D %  For each node, n2 pixels exist for which that node represents theI %  smallest volume in RGB space containing those pixel's colors.  When n2 H %  > 0 the node will uniquely define a color in the output image. At theH %  beginning of reduction,  n2 = 0  for all nodes except a the leaves of> %  the tree which represent colors present in the input image. % B %  The other pixel count, n1, indicates the total number of colorsI %  within the cubic volume which the node represents.  This includes n1 - I %  n2  pixels whose colors should be defined by nodes at a lower level in  %  the tree. % C %  Assignment generates the output image from the pruned tree.  The D %  output image consists of two parts: (1)  A color map, which is anF %  array of color descriptions (RGB triples) for each color present inH %  the output image;  (2)  A pixel array, which represents each pixel as% %  an index into the color map array.  % C %  First, the assignment phase makes one pass over the pruned color F %  description tree to establish the image's color map.  For each nodeE %  with n2  > 0, it divides Sr, Sg, and Sb by n2 .  This produces the H %  mean color of all pixels that classify no lower than this node.  Each5 %  of these colors becomes an entry in the color map.  % G %  Finally,  the assignment phase reclassifies each pixel in the pruned G %  tree to identify the deepest node containing the pixel's color.  The I %  pixel's value in the pixel array becomes the index of this node's mean  %  color in the color map. % E %  For efficiency, QUANTIZE requires that the reference image be in a  %  run-length encoded format.  % H %  This method is based on a similar algorithm written by Paul Raveling. %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*   Define declarations. */$ #define CacheShift  (QuantumDepth-6) #define ErrorQueueLength  16 #define MaxNodes  266817   /*   Typdef declarations. */ typedef struct _ErrorPacket  {    double     red,
     green,	     blue;  } ErrorPacket;   typedef struct _NodeInfo {    double     number_unique,     total_red,     total_green,     total_blue,      quantization_error;      unsigned int     color_number;      unsigned char      id, 
     level,     census;      struct _NodeInfo     *parent,     *child[8]; } NodeInfo;    typedef struct _Nodes  { 
   NodeInfo     nodes[NodesInAList];     struct _Nodes 
     *next; } Nodes;   typedef struct _CubeInfo { 
   NodeInfo
     *root;     unsigned int
     depth;     unsigned long      colors;   
   PixelPacket 
     color,     *colormap;     double
     distance,      pruning_threshold,     next_pruning_threshold, 
     *squares;      unsigned int
     nodes,     free_nodes,      color_number;   
   NodeInfo     *next_node;      Nodes      *node_queue;     int      x,     y,     *cache;   	   Quantum      *range_limit;   
   ErrorPacket      error[ErrorQueueLength];     double     weights[ErrorQueueLength];     const QuantizeInfo     *quantize_info;  } CubeInfo;    /*   Const declarations.  */
 const long   MaxColormapSize = 65535L;    /*   Method prototypes. */ static NodeInfo L   *GetNodeInfo(CubeInfo *,const unsigned int,const unsigned int,NodeInfo *);   static unsigned int "   DitherImage(CubeInfo *,Image *);   static void ,   ClosestColor(CubeInfo *,const NodeInfo *),(   DefineColormap(CubeInfo *,NodeInfo *),@   HilbertCurve(CubeInfo *,Image *,const int,const unsigned int),*   PruneLevel(CubeInfo *,const NodeInfo *),+   Reduction(CubeInfo *,const unsigned int);    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   A s s i g n m e n t                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method Assignment generates the output image from the pruned tree.  TheD %  output image consists of two parts: (1)  A color map, which is anF %  array of color descriptions (RGB triples) for each color present inH %  the output image;  (2)  A pixel array, which represents each pixel as% %  an index into the color map array.  % C %  First, the assignment phase makes one pass over the pruned color F %  description tree to establish the image's color map.  For each nodeE %  with n2  > 0, it divides Sr, Sg, and Sb by n2 .  This produces the H %  mean color of all pixels that classify no lower than this node.  Each5 %  of these colors becomes an entry in the color map.  % G %  Finally,  the assignment phase reclassifies each pixel in the pruned G %  tree to identify the deepest node containing the pixel's color.  The I %  pixel's value in the pixel array becomes the index of this node's mean  %  color in the color map. % * %  The format of the Assignment method is: % @ %      unsigned int Assignment(CubeInfo *cube_info,Image *image) % + %  A description of each parameter follows.  % 2 %    o cube_info: A pointer to the Cube structure. % G %    o image: Specifies a pointer to an Image structure;  returned from  %      ReadImage.  %  %  */@ static unsigned int Assignment(CubeInfo *cube_info,Image *image) { 8 #define AssignImageText  "  Assigning image colors...  "     int      y;     register int     x;     register const NodeInfo      *node_info;      register PixelPacket     *q;      register unsigned short 
     index;     unsigned int     dither,      id;      /*     Allocate image colormap.   */.   if (image->colormap == (PixelPacket *) NULL)#     image->colormap=(PixelPacket *) <       AllocateMemory(cube_info->colors*sizeof(PixelPacket));   elseN     image->colormap=(PixelPacket *) ReallocateMemory((char *) image->colormap,-       cube_info->colors*sizeof(PixelPacket)); .   if (image->colormap == (PixelPacket *) NULL)     { D       MagickWarning(ResourceLimitWarning,"Unable to quantize image",$         "Memory allocation failed");       return(False);     } &   cube_info->colormap=image->colormap;   cube_info->colors=0;,   DefineColormap(cube_info,cube_info->root);H   if ((cube_info->quantize_info->colorspace != TransparentColorspace) &&,       (image->colorspace != CMYKColorspace))     image->class=PseudoClass; 1   image->colors=(unsigned int) cube_info->colors;    /*!     Create a reduced color image.    */*   dither=cube_info->quantize_info->dither;
   if (dither) (     dither=DitherImage(cube_info,image);   if (!dither))     for (y=0; y < (int) image->rows; y++)      { 2       q=GetPixelCache(image,0,y,image->columns,1);$       if (q == (PixelPacket *) NULL)         break;.       for (x=0; x < (int) image->columns; x++)       { 
         /*A           Identify the deepest node containing the pixel's color. 
         */"         node_info=cube_info->root;<         for (index=MaxTreeDepth-1; (int) index > 0; index--)	         { 9           id=((DownScale(q->red) >> index) & 0x01) << 2 | ;              ((DownScale(q->green) >> index) & 0x01) << 1 | 4              ((DownScale(q->blue) >> index) & 0x01);3           if ((node_info->census & (1 << id)) == 0)              break;)           node_info=node_info->child[id]; 	         } 
         /*?           Find closest color among siblings and their children. 
         */$         cube_info->color.red=q->red;(         cube_info->color.green=q->green;&         cube_info->color.blue=q->blue;6         cube_info->distance=3.0*(MaxRGB+1)*(MaxRGB+1);2         ClosestColor(cube_info,node_info->parent);&         index=cube_info->color_number;(         if (image->class == PseudoClass)"           image->indexes[x]=index;5         if (!cube_info->quantize_info->measure_error) $           *q=image->colormap[index];         q++;       } !       if (!SyncPixelCache(image))          break;%       if (QuantumTick(y,image->rows)) 7         ProgressMonitor(AssignImageText,y,image->rows);      } 7   if ((cube_info->quantize_info->number_colors == 2) && ?       (cube_info->quantize_info->colorspace == GRAYColorspace))      {        unsigned int         polarity;          /*         Monochrome image.        */M       polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]); &       image->colormap[polarity].red=0;(       image->colormap[polarity].green=0;'       image->colormap[polarity].blue=0; ,       image->colormap[!polarity].red=MaxRGB;.       image->colormap[!polarity].green=MaxRGB;-       image->colormap[!polarity].blue=MaxRGB;      } .   if (cube_info->quantize_info->measure_error)     {        QuantizationError(image);        SyncImage(image);      }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   C l a s s i f i c a t i o n                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method Classification begins by initializing a color description treeH %  of sufficient depth to represent each possible input color in a leaf.> %  However, it is impractical to generate a fully-formed colorG %  description tree in the classification phase for realistic values of H %  cmax.  If colors components in the input image are quantized to k-bitH %  precision, so that cmax= 2k-1, the tree would need k levels below theG %  root node to allow representing each possible input color in a leaf. G %  This becomes prohibitive because the tree's total number of nodes is  %  1 + sum(i=1,k,8k).  % H %  A complete tree would require 19,173,961 nodes for k = 8, cmax = 255.E %  Therefore, to avoid building a fully populated tree, QUANTIZE: (1) F %  Initializes data structures for nodes only as they are needed;  (2)D %  Chooses a maximum depth for the tree as a function of the desiredH %  number of colors in the output image (currently log2(colormap size)). % H %  For each pixel in the input image, classification scans downward fromH %  the root of the color description tree.  At each level of the tree itB %  identifies the single node which represents a cube in RGB space? %  containing It updates the following data for each such node:  % C %    n1 : Number of pixels whose color is contained in the RGB cube   %    which this node represents; % F %    n2 : Number of pixels whose color is not represented in a node atF %    lower depth in the tree;  initially,  n2 = 0 for all nodes except %    leaves of the tree. % G %    Sr, Sg, Sb : Sums of the red, green, and blue component values for C %    all pixels not classified at a lower depth. The combination of H %    these sums and n2  will ultimately characterize the mean color of a, %    set of pixels represented by this node. % F %    E: The distance squared in RGB space between each pixel containedK %    within a node and the nodes' center.  This represents the quantization  %    error for a node. % . %  The format of the Classification method is: % D %      unsigned int Classification(CubeInfo *cube_info,Image *image) % + %  A description of each parameter follows.  % 2 %    o cube_info: A pointer to the Cube structure. % G %    o image: Specifies a pointer to an Image structure;  returned from  %      ReadImage.  %  %  */D static unsigned int Classification(CubeInfo *cube_info,Image *image) { < #define ClassifyImageText  "  Classifying image colors...  "     double     bisect[MaxTreeDepth+1],      mid_red,     mid_green,
     mid_blue;      int      y;     register double      distance_squared, 
     *squares;      register int     i,     x;     register NodeInfo      *node_info;      register PixelPacket     *p;      register unsigned int 
     index;     unsigned int     id, 
     level;     bisect[0]=(MaxRGB+1.0)/2.0; #   for (i=1; i <= MaxTreeDepth; i++)      bisect[i]=0.5*bisect[i-1];   squares=cube_info->squares; '   cube_info->root->quantization_error+= =     3.0*(MaxRGB/2.0)*(MaxRGB/2.0)*image->columns*image->rows; '   for (y=0; y < (int) image->rows; y++)    { 0     p=GetPixelCache(image,0,y,image->columns,1);"     if (p == (PixelPacket *) NULL)       break;*     if ((int) cube_info->nodes > MaxNodes)       { 
         /*9           Prune one level if the color tree is too large. 
         */.         PruneLevel(cube_info,cube_info->root);         cube_info->depth--;        } ,     for (x=0; x < (int) image->columns; x++)     {        /*:         Start at the root and descend the color cube tree.       */        node_info=cube_info->root;       index=MaxTreeDepth-1;        mid_red=MaxRGB/2.0;        mid_green=MaxRGB/2.0;        mid_blue=MaxRGB/2.0;7       for (level=1; level <= cube_info->depth; level++)        { 7         id=((DownScale(p->red) >> index) & 0x01) << 2 | 9            ((DownScale(p->green) >> index) & 0x01) << 1 | 2            ((DownScale(p->blue) >> index) & 0x01);9         mid_red+=id & 4 ? bisect[level] : -bisect[level]; ;         mid_green+=id & 2 ? bisect[level] : -bisect[level]; :         mid_blue+=id & 1 ? bisect[level] : -bisect[level];6         if (node_info->child[id] == (NodeInfo *) NULL)           {              /*6               Set colors of new node to contain pixel.             */'             node_info->census|=1 << id; K             node_info->child[id]=GetNodeInfo(cube_info,id,level,node_info); :             if (node_info->child[id] == (NodeInfo *) NULL)               { N                 MagickWarning(ResourceLimitWarning,"Unable to quantize image",.                   "Memory allocation failed");                 return(False);               } *             if (level == cube_info->depth)"               cube_info->colors++;           } '         node_info=node_info->child[id]; "         if (level != MaxTreeDepth)           {              /*J               Approximate the quantization error represented by this node.             */=             distance_squared=squares[(int) (p->red-mid_red)]+ 2               squares[(int) (p->green-mid_green)]+0               squares[(int) (p->blue-mid_blue)];<             node_info->quantization_error+=distance_squared;           }          index--;       }        /*J         Sum RGB for this leaf for later derivation of the mean cube color.       */!       node_info->number_unique++; #       node_info->total_red+=p->red; '       node_info->total_green+=p->green; %       node_info->total_blue+=p->blue; 
       p++;     } #     if (QuantumTick(y,image->rows)) 7       ProgressMonitor(ClassifyImageText,y,image->rows);    }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C l o n e Q u a n t i z e I n f o                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Method CloneQuantizeInfo makes a duplicate of the given quantize info, or if $ %  quantize info is NULL, a new one. % 1 %  The format of the CloneQuantizeInfo method is:  % I %      QuantizeInfo *CloneQuantizeInfo(const QuantizeInfo *quantize_info)  % + %  A description of each parameter follows:  % M %    o cloned_info: Method CloneQuantizeInfo returns a duplicate of the given 9 %      quantize info, or if image info is NULL a new one.  % / %    o quantize_info: a structure of type info.  %  %  */I Export QuantizeInfo *CloneQuantizeInfo(const QuantizeInfo *quantize_info)  {    QuantizeInfo     *cloned_info;   D   cloned_info=(QuantizeInfo *) AllocateMemory(sizeof(QuantizeInfo));+   if (cloned_info == (QuantizeInfo *) NULL) B     MagickError(ResourceLimitWarning,"Unable to clone image info","       "Memory allocation failed");-   if (quantize_info == (QuantizeInfo *) NULL)      { #       GetQuantizeInfo(cloned_info);        return(cloned_info);     }     *cloned_info=(*quantize_info);   return(cloned_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   C l o s e s t C o l o r                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method ClosestColor traverses the color cube tree at a particular node G %  and determines which colormap entry best represents the input color.  % , %  The format of the ClosestColor method is: % G %      void ClosestColor(CubeInfo *cube_info,const NodeInfo *node_info)  % + %  A description of each parameter follows.  % 2 %    o cube_info: A pointer to the Cube structure. % O %    o node_info: The address of a structure of type NodeInfo which points to a 8 %      node in the color cube tree that is to be pruned. %  %  */G static void ClosestColor(CubeInfo *cube_info,const NodeInfo *node_info)  {    register unsigned int      id;   !   if (cube_info->distance != 0.0)      {        /*         Traverse any children.       */!       if (node_info->census != 0) +         for (id=0; id < MaxTreeDepth; id++) ,           if (node_info->census & (1 << id))9             ClosestColor(cube_info,node_info->child[id]); (       if (node_info->number_unique != 0)	         {            register PixelPacket             *color;              register double              distance_squared,              *squares;              /*1             Determine if this color is "closest".            */%           squares=cube_info->squares; <           color=cube_info->colormap+node_info->color_number;L           distance_squared=squares[(int) (color->red-cube_info->color.red)]+A             squares[(int) (color->green-cube_info->color.green)]+ ?             squares[(int) (color->blue-cube_info->color.blue)]; 5           if (distance_squared < cube_info->distance) 
             { 3               cube_info->distance=distance_squared; O               cube_info->color_number=(unsigned short) node_info->color_number; 
             } 	         }      }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   D e f i n e C o l o r m a p                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method DefineColormap traverses the color cube tree and notes each M %  colormap entry.  A colormap entry is any node in the color cube tree where + %  the number of unique colors is not zero.  % . %  The format of the DefineColormap method is: % > %      DefineColormap(CubeInfo *cube_info,NodeInfo *node_info) % + %  A description of each parameter follows.  % 2 %    o cube_info: A pointer to the Cube structure. % O %    o node_info: The address of a structure of type NodeInfo which points to a 8 %      node in the color cube tree that is to be pruned. %  %  */C static void DefineColormap(CubeInfo *cube_info,NodeInfo *node_info)  {    register double      number_unique;     register unsigned int      id;      /*     Traverse any children.   */   if (node_info->census != 0) '     for (id=0; id < MaxTreeDepth; id++) (       if (node_info->census & (1 << id))7         DefineColormap(cube_info,node_info->child[id]); $   if (node_info->number_unique != 0)     {        /*A         Colormap entry is defined by the mean color in this cube.        */-       number_unique=node_info->number_unique; :       cube_info->colormap[cube_info->colors].red=(Quantum)?         ((node_info->total_red+number_unique/2)/number_unique); <       cube_info->colormap[cube_info->colors].green=(Quantum)A         ((node_info->total_green+number_unique/2)/number_unique); ;       cube_info->colormap[cube_info->colors].blue=(Quantum) @         ((node_info->total_blue+number_unique/2)/number_unique);A       node_info->color_number=(unsigned int) cube_info->colors++;      }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   D e s t r o y C u b e I n f o                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method DestroyCubeInfo deallocates memory associated with an image. % / %  The format of the DestroyCubeInfo method is:  % + %      DestroyCubeInfo(CubeInfo *cube_info)  % + %  A description of each parameter follows:  % > %    o cube_info: The address of a structure of type CubeInfo. %  %  */0 static void DestroyCubeInfo(CubeInfo *cube_info) {    register Nodes     *nodes;      /*$     Release color cube tree storage.   */   do   { &     nodes=cube_info->node_queue->next;&     FreeMemory(cube_info->node_queue);      cube_info->node_queue=nodes;4   } while (cube_info->node_queue != (Nodes *) NULL);   cube_info->squares-=MaxRGB; !   FreeMemory(cube_info->squares); (   if (!cube_info->quantize_info->dither)     return;    /*     Free memory resources.   */%   cube_info->range_limit-=(MaxRGB+1); %   FreeMemory(cube_info->range_limit);    FreeMemory(cube_info->cache);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   D e s t r o y Q u a n t i z e I n f o                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Method DestroyQuantizeInfo deallocates memory associated with an  %  QuantizeInfo structure. % 3 %  The format of the DestroyQuantizeInfo method is:  % 7 %      DestroyQuantizeInfo(QuantizeInfo *quantize_info)  % + %  A description of each parameter follows:  % G %    o quantize_info: Specifies a pointer to an QuantizeInfo structure.  %  %  */< Export void DestroyQuantizeInfo(QuantizeInfo *quantize_info) { 1   assert(quantize_info != (QuantizeInfo *) NULL); -   FreeMemory((QuantizeInfo *) quantize_info); &   quantize_info=(QuantizeInfo *) NULL; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   D i t h e r                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method Dither distributes the difference between an original image and the N %  corresponding color reduced algorithm to neighboring pixels along a Hilbert	 %  curve.  % & %  The format of the Dither method is: % L %      Dither(CubeInfo *cube_info,Image *image,const unsigned int direction) % + %  A description of each parameter follows.  % 2 %    o cube_info: A pointer to the Cube structure. % G %    o image: Specifies a pointer to an Image structure;  returned from  %      ReadImage.  % D %    o direction:  This unsigned direction describes which direction3 %      to move to next to follow the Hilbert curve.  %  */4 static void Dither(CubeInfo *cube_info,Image *image,   const unsigned int direction)  {    double     blue_error,      green_error,     red_error;  	   Quantum 	     blue, 
     green,     red;     register CubeInfo      *p;      register int     i;     register PixelPacket     *q;      unsigned short
     index;     p=cube_info;5   if ((p->x >= 0) && (p->x < (int) image->columns) && 0       (p->y >= 0) && (p->y < (int) image->rows))     {        /*         Distribute error.        */       red_error=0.0;       green_error=0.0;       blue_error=0.0; *       for (i=0; i < ErrorQueueLength; i++)       { 1         red_error+=p->error[i].red*p->weights[i]; 5         green_error+=p->error[i].green*p->weights[i]; 3         blue_error+=p->error[i].blue*p->weights[i];        } +       q=GetPixelCache(image,p->x,p->y,1,1); $       if (q == (PixelPacket *) NULL)         return; 3       red=p->range_limit[(int) (q->red+red_error)]; 9       green=p->range_limit[(int) (q->green+green_error)]; 6       blue=p->range_limit[(int) (q->blue+blue_error)];A       i=(blue >> CacheShift) << 12 | (green >> CacheShift) << 6 |          (red >> CacheShift);       if (p->cache[i] < 0)	         {            register NodeInfo              *node_info;              register unsigned int              id;              /*C             Identify the deepest node containing the pixel's color.            */           node_info=p->root;>           for (index=MaxTreeDepth-1; (int) index > 0; index--)           { 8             id=((DownScale(red) >> index) & 0x01) << 2 |:                ((DownScale(green) >> index) & 0x01) << 1 |3                ((DownScale(blue) >> index) & 0x01); 5             if ((node_info->census & (1 << id)) == 0)                break;+             node_info=node_info->child[id];            }            /*A             Find closest color among siblings and their children.            */           p->color.red=red;            p->color.green=green;            p->color.blue=blue; 0           p->distance=3.0*(MaxRGB+1)*(MaxRGB+1);,           ClosestColor(p,node_info->parent);&           p->cache[i]=p->color_number;	         }        /*/         Assign pixel to closest colormap entry.        */)       index=(unsigned short) p->cache[i]; &       if (image->class == PseudoClass)         *image->indexes=index;3       if (!cube_info->quantize_info->measure_error) "         *q=image->colormap[index];!       if (!SyncPixelCache(image))          return;        /*A         Propagate the error as the last entry of the error queue.        */.       for (i=0; i < (ErrorQueueLength-1); i++)"         p->error[i]=p->error[i+1];5       p->error[i].red=red-image->colormap[index].red; ;       p->error[i].green=green-image->colormap[index].green; 8       p->error[i].blue=blue-image->colormap[index].blue;     }    switch (direction)   { $     case WestGravity: p->x--; break;$     case EastGravity: p->x++; break;%     case NorthGravity: p->y--; break; %     case SouthGravity: p->y++; break;    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   D i t h e r I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Method DitherImage distributes the difference between an original image andJ %  the corresponding color reduced algorithm to neighboring pixels along aD %  Hilbert curve.  DitherImage returns True if the image is dithered %  otherwise False.  % F %  This algorithm is strongly based on a similar algorithm by Thiadmer
 %  Riemersma.  % + %  The format of the DitherImage method is:  % A %      unsigned int DitherImage(CubeInfo *cube_info,Image *image)  % + %  A description of each parameter follows.  % 2 %    o cube_info: A pointer to the Cube structure. % G %    o image: Specifies a pointer to an Image structure;  returned from  %      ReadImage.  %  %  */A static unsigned int DitherImage(CubeInfo *cube_info,Image *image)  {    register int     i;     unsigned int
     depth;     /*     Initialize error queue.    */&   for (i=0; i < ErrorQueueLength; i++)   {       cube_info->error[i].red=0.0;"     cube_info->error[i].green=0.0;!     cube_info->error[i].blue=0.0;    }    /*8     Distribute quantization error along a Hilbert curve.   */   cube_info->x=0;    cube_info->y=0; @   i=image->columns > image->rows ? image->columns : image->rows;    for (depth=1; i != 0; depth++)
     i>>=1;5   HilbertCurve(cube_info,image,depth-1,NorthGravity); (   Dither(cube_info,image,ForgetGravity);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   G e t C u b e I n f o                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 9 %  Method GetCubeInfo initialize the Cube data structure.  % + %  The format of the GetCubeInfo method is:  % 4 %      unsigned int GetCubeInfo(CubeInfo *cube_info,5 %        const QuantizeInfo *quantize_info,int depth)  % + %  A description of each parameter follows.  % 2 %    o cube_info: A pointer to the Cube structure. % G %    o quantize_info: Specifies a pointer to an QuantizeInfo structure.  % E %    o depth: Normally, this integer value is zero or one.  A zero or P %      one tells Quantize to choose a optimal tree depth of Log4(number_colors).K %      A tree of this depth generally allows the best representation of the F %      reference image with the least amount of memory and the fastestK %      computational speed.  In some cases, such as an image with low color > %      dispersion (a few number of colors), a value other thanM %      Log4(number_colors) is required.  To expand the color tree completely,  %      use a value of 8. %  %  */4 static unsigned int GetCubeInfo(CubeInfo *cube_info,.   const QuantizeInfo *quantize_info,int depth) {    double     weight;      register int     i;     /*0     Initialize tree to describe color cube_info.   */'   cube_info->node_queue=(Nodes *) NULL;    cube_info->nodes=0;    cube_info->free_nodes=0;   if (depth > MaxTreeDepth)      depth=MaxTreeDepth;    if (depth < 2)     depth=2;   cube_info->depth=depth;    /*     Initialize root node.    */?   cube_info->root=GetNodeInfo(cube_info,0,0,(NodeInfo *) NULL);    cube_info->squares=(double *) 5     AllocateMemory((MaxRGB+MaxRGB+1)*sizeof(double)); /   if ((cube_info->root == (NodeInfo *) NULL) || .       (cube_info->squares == (double *) NULL))     { D       MagickWarning(ResourceLimitWarning,"Unable to quantize image",$         "Memory allocation failed");       return(False);     } *   cube_info->root->parent=cube_info->root;*   cube_info->root->quantization_error=0.0;   cube_info->colors=0;   cube_info->squares+=MaxRGB; %   for (i=(-MaxRGB); i <= MaxRGB; i++)      cube_info->squares[i]=i*i;)   cube_info->quantize_info=quantize_info; (   if (!cube_info->quantize_info->dither)     return(True);    /*      Initialize dither resources.   */A   cube_info->cache=(int *) AllocateMemory((1 << 18)*sizeof(int)); $   cube_info->range_limit=(Quantum *)1     AllocateMemory(3*(MaxRGB+1)*sizeof(Quantum)); +   if ((cube_info->cache == (int *) NULL) || 3       (cube_info->range_limit == (Quantum *) NULL))      { B       MagickWarning(ResourceLimitWarning,"Unable to dither image",$         "Memory allocation failed");       return(True);      }    /*     Initialize range tables.   */   for (i=0; i <= MaxRGB; i++)    {       cube_info->range_limit[i]=0;5     cube_info->range_limit[i+(MaxRGB+1)]=(Quantum) i; 2     cube_info->range_limit[i+(MaxRGB+1)*2]=MaxRGB;   } %   cube_info->range_limit+=(MaxRGB+1);    /*     Initialize color cache.    */   for (i=0; i < (1 << 18); i++)      cube_info->cache[i]=(-1);    /*:     Distribute weights along a curve of exponential decay.   */
   weight=1.0; &   for (i=0; i < ErrorQueueLength; i++)   { 8     cube_info->weights[ErrorQueueLength-i-1]=1.0/weight;?     weight*=exp(log((double) MaxRGB+1)/(ErrorQueueLength-1.0));    }    /*$     Normalize the weighting factors.   */
   weight=0.0; &   for (i=0; i < ErrorQueueLength; i++)"     weight+=cube_info->weights[i];&   for (i=0; i < ErrorQueueLength; i++)"     cube_info->weights[i]/=weight;   if (QuantumDepth == 16) (     for (i=0; i < ErrorQueueLength; i++)#       cube_info->weights[i]/=256.0;    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   G e t N o d e I n f o                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method GetNodeInfo allocates memory for a new node in the color cube ' %  tree and presets all fields to zero.  % + %  The format of the GetNodeInfo method is:  % G %      NodeInfo *GetNodeInfo(CubeInfo *cube_info,const unsigned int id, 3 %        const unsigned int level,NodeInfo *parent)  % + %  A description of each parameter follows.  % A %    o node: The GetNodeInfo method returns this integer address.  % 2 %    o id: Specifies the child number of the node. % I %    o level: Specifies the level in the classification the node resides.  %  %  */G static NodeInfo *GetNodeInfo(CubeInfo *cube_info,const unsigned int id, ,   const unsigned int level,NodeInfo *parent) {    register int     i;  
   NodeInfo     *node_info;   !   if (cube_info->free_nodes == 0)      {        Nodes          *nodes;          /*&         Allocate a new nodes of nodes.       */4       nodes=(Nodes *) AllocateMemory(sizeof(Nodes));"       if (nodes == (Nodes *) NULL)"         return((NodeInfo *) NULL);(       nodes->next=cube_info->node_queue;"       cube_info->node_queue=nodes;(       cube_info->next_node=nodes->nodes;)       cube_info->free_nodes=NodesInAList;      }    cube_info->nodes++;    cube_info->free_nodes--;#   node_info=cube_info->next_node++;    node_info->parent=parent; "   for (i=0; i < MaxTreeDepth; i++)*     node_info->child[i]=(NodeInfo *) NULL;   node_info->id=id;    node_info->level=level;    node_info->census=0;   node_info->number_unique=0; $   node_info->quantization_error=0.0;   node_info->total_red=0.0;    node_info->total_green=0.0;    node_info->total_blue=0.0;   return(node_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t Q u a n t i z e I n f o                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Method GetQuantizeInfo initializes the QuantizeInfo structure.  % / %  The format of the GetQuantizeInfo method is:  % 3 %      GetQuantizeInfo(QuantizeInfo *quantize_info)  % + %  A description of each parameter follows:  % F %    o quantize_info: Specifies a pointer to a QuantizeInfo structure. %  %  */8 Export void GetQuantizeInfo(QuantizeInfo *quantize_info) { 1   assert(quantize_info != (QuantizeInfo *) NULL); !   quantize_info->number_colors=0;    quantize_info->tree_depth=0;   quantize_info->dither=False;*   quantize_info->colorspace=RGBColorspace;%   quantize_info->measure_error=False;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   H i l b e r t C u r v e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method HilbertCurve s a space filling curve that visits every point in a J %  square grid with any power of 2.  Hilbert is useful in dithering due toM %  the coherence between neighboring pixels.  Here, the quantization error is ' %  distributed along the Hilbert curve.  % , %  The format of the HilbertCurve method is: % J %      void HilbertCurve(CubeInfo *cube_info,Image *image,const int level,& %        const unsigned int direction) % + %  A description of each parameter follows.  % 2 %    o cube_info: A pointer to the Cube structure. % G %    o image: Specifies a pointer to an Image structure;  returned from  %      ReadImage.  % D %    o direction:  This unsigned direction describes which direction3 %      to move to next to follow the Hilbert curve.  %  %  */J static void HilbertCurve(CubeInfo *cube_info,Image *image,const int level,   const unsigned int direction)  {    if (level == 1)      {        switch (direction)       {          case WestGravity: 	         { .           Dither(cube_info,image,EastGravity);/           Dither(cube_info,image,SouthGravity); .           Dither(cube_info,image,WestGravity);           break;	         }          case EastGravity: 	         { .           Dither(cube_info,image,WestGravity);/           Dither(cube_info,image,NorthGravity); .           Dither(cube_info,image,EastGravity);           break;	         }          case NorthGravity:	         { /           Dither(cube_info,image,SouthGravity); .           Dither(cube_info,image,EastGravity);/           Dither(cube_info,image,NorthGravity);            break;	         }          case SouthGravity:	         { /           Dither(cube_info,image,NorthGravity); .           Dither(cube_info,image,WestGravity);/           Dither(cube_info,image,SouthGravity);            break;	         }          default:           break;       } 
       return;      }    switch (direction)   {      case WestGravity:      { 9       HilbertCurve(cube_info,image,level-1,NorthGravity); *       Dither(cube_info,image,EastGravity);8       HilbertCurve(cube_info,image,level-1,WestGravity);+       Dither(cube_info,image,SouthGravity); 8       HilbertCurve(cube_info,image,level-1,WestGravity);*       Dither(cube_info,image,WestGravity);9       HilbertCurve(cube_info,image,level-1,SouthGravity);        break;     }      case EastGravity:      { 9       HilbertCurve(cube_info,image,level-1,SouthGravity); *       Dither(cube_info,image,WestGravity);8       HilbertCurve(cube_info,image,level-1,EastGravity);+       Dither(cube_info,image,NorthGravity); 8       HilbertCurve(cube_info,image,level-1,EastGravity);*       Dither(cube_info,image,EastGravity);9       HilbertCurve(cube_info,image,level-1,NorthGravity);        break;     }      case NorthGravity:     { 8       HilbertCurve(cube_info,image,level-1,WestGravity);+       Dither(cube_info,image,SouthGravity); 9       HilbertCurve(cube_info,image,level-1,NorthGravity); *       Dither(cube_info,image,EastGravity);9       HilbertCurve(cube_info,image,level-1,NorthGravity); +       Dither(cube_info,image,NorthGravity); 8       HilbertCurve(cube_info,image,level-1,EastGravity);       break;     }      case SouthGravity:     { 8       HilbertCurve(cube_info,image,level-1,EastGravity);+       Dither(cube_info,image,NorthGravity); 9       HilbertCurve(cube_info,image,level-1,SouthGravity); *       Dither(cube_info,image,WestGravity);9       HilbertCurve(cube_info,image,level-1,SouthGravity); +       Dither(cube_info,image,SouthGravity); 8       HilbertCurve(cube_info,image,level-1,WestGravity);       break;     }      default:       break;   }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   M a p I m a g e                                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  MapImage replaces the colors of an image with the closest color from  %  a reference image.  % ( %  The format of the MapImage method is: % ; %      unsigned int MapImage(Image *image,Image *map_image, # %        const unsigned int dither)  % + %  A description of each parameter follows:  % 8 %    o image: Specifies a pointer to an Image structure. % C %    o map_image: Specifies a pointer to a Image structure.  Reduce : %      image to a set of colors represented by this image. % E %    o dither: Set this integer value to something other than zero to " %      dither the quantized image. %  %  */; Export unsigned int MapImage(Image *image,Image *map_image,    const unsigned int dither) { 
   CubeInfo     cube_info;     QuantizeInfo     quantize_info;     unsigned int     status;   "   assert(image != (Image *) NULL);"   if (map_image == (Image *) NULL)     return(False);   /*     Initialize color cube.   */"   GetQuantizeInfo(&quantize_info);   quantize_info.dither=dither;P   quantize_info.colorspace=image->matte ? TransparentColorspace : RGBColorspace;2   status=GetCubeInfo(&cube_info,&quantize_info,8);   if (status == False)     return(False);.   status=Classification(&cube_info,map_image);   if (status != False)     {        /*7         Classify image colors from the reference image.        */3       quantize_info.number_colors=cube_info.colors; *       status=Assignment(&cube_info,image);     }    DestroyCubeInfo(&cube_info);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   M a p I m a g e s                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  MapImages replaces the colors of a sequence of images with the closest   %  color from a reference image. % ( %  The format of the MapImage method is: % = %      unsigned int MapImages(Image *images,Image *map_image, # %        const unsigned int dither)  % + %  A description of each parameter follows:  % ? %    o image: Specifies a pointer to a set of Image structures.  % C %    o map_image: Specifies a pointer to a Image structure.  Reduce : %      image to a set of colors represented by this image. % E %    o dither: Set this integer value to something other than zero to " %      dither the quantized image. %  %  */= Export unsigned int MapImages(Image *images,Image *map_image,    const unsigned int dither) { 
   CubeInfo     cube_info;     Image      *image;      QuantizeInfo     quantize_info;     unsigned int     status;   #   assert(images != (Image *) NULL); %   if (images->next == (Image *) NULL)      {        /*,         Handle a single image with MapImage.       *//       status=MapImage(images,map_image,dither);        return(status);      } "   GetQuantizeInfo(&quantize_info);   quantize_info.dither=dither;"   if (map_image == (Image *) NULL)     {        /*7         Create a global colormap for an image sequence.        */D       for (image=images; image != (Image *) NULL; image=image->next)         if (image->matte) 9           quantize_info.colorspace=TransparentColorspace; 3       status=QuantizeImages(&quantize_info,images);        return(status);      }    /*3     Classify image colors from the reference image.    */2   status=GetCubeInfo(&cube_info,&quantize_info,8);   if (status == False)     return(False);.   status=Classification(&cube_info,map_image);   if (status != False)     {        /*7         Classify image colors from the reference image.        */3       quantize_info.number_colors=cube_info.colors; D       for (image=images; image != (Image *) NULL; image=image->next)       { !         quantize_info.colorspace= ?           image->matte ? TransparentColorspace : RGBColorspace; ,         status=Assignment(&cube_info,image);         if (status == False)           break;       }      }    DestroyCubeInfo(&cube_info);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   O r d e r e d D i t h e r I m a g e                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Method OrderedDitherImage uses the ordered dithering technique ofM %  reducing color images to monochrome using positional information to retain # %  as much information as possible.  % 2 %  The format of the OrderedDitherImage method is: % 4 %      unsigned int OrderedDitherImage(Image *image) % + %  A description of each parameter follows.  % G %    o image: Specifies a pointer to an Image structure;  returned from  %      ReadImage.  %  %  */4 static unsigned int OrderedDitherImage(Image *image) { 1 #define DitherImageText  "  Dithering image...  "      static Quantum     DitherMatrix[8][8] =     { ?       { UpScale(  0), UpScale(192), UpScale( 48), UpScale(240), A         UpScale( 12), UpScale(204), UpScale( 60), UpScale(252) }, ?       { UpScale(128), UpScale( 64), UpScale(176), UpScale(112), A         UpScale(140), UpScale( 76), UpScale(188), UpScale(124) }, ?       { UpScale( 32), UpScale(224), UpScale( 16), UpScale(208), A         UpScale( 44), UpScale(236), UpScale( 28), UpScale(220) }, ?       { UpScale(160), UpScale( 96), UpScale(144), UpScale( 80), A         UpScale(172), UpScale(108), UpScale(156), UpScale( 92) }, ?       { UpScale(  8), UpScale(200), UpScale( 56), UpScale(248), A         UpScale(  4), UpScale(196), UpScale( 52), UpScale(244) }, ?       { UpScale(136), UpScale( 72), UpScale(184), UpScale(120), A         UpScale(132), UpScale( 68), UpScale(180), UpScale(116) }, ?       { UpScale( 40), UpScale(232), UpScale( 24), UpScale(216), A         UpScale( 36), UpScale(228), UpScale( 20), UpScale(212) }, ?       { UpScale(168), UpScale(104), UpScale(152), UpScale( 88), @         UpScale(164), UpScale(100), UpScale(148), UpScale( 84) }     };  
   IndexPacket 
     index;     int      y;  
   PixelPacket      *colormap;     register int     x;     register PixelPacket     *q;      /*     Initialize colormap.   */   NormalizeImage(image);   image->class=PseudoClass;    image->colors=2;M   colormap=(PixelPacket *) AllocateMemory(image->colors*sizeof(PixelPacket)); '   if (colormap == (PixelPacket *) NULL)      { B       MagickWarning(ResourceLimitWarning,"Unable to dither image",$         "Memory allocation failed");       return(False);     } .   if (image->colormap != (PixelPacket *) NULL)      FreeMemory(image->colormap);   image->colormap=colormap;    image->colormap[0].red=0;    image->colormap[0].green=0;    image->colormap[0].blue=0;    image->colormap[1].red=MaxRGB;"   image->colormap[1].green=MaxRGB;!   image->colormap[1].blue=MaxRGB;    /*6     Dither image with the ordered dithering technique.   */'   for (y=0; y < (int) image->rows; y++)    { 0     q=GetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     { E       index=Intensity(*q) > DitherMatrix[y & 0x07][x & 0x07] ? 1 : 0;        image->indexes[x]=index;"       *q++=image->colormap[index];     }      if (!SyncPixelCache(image))        break;#     if (QuantumTick(y,image->rows)) 5       ProgressMonitor(DitherImageText,y,image->rows);    }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   P r u n e C h i l d                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method PruneChild deletes the given node and merges its statistics into %  its parent. % , %  The format of the PruneSubtree method is: % @ %      PruneChild(CubeInfo *cube_info,const NodeInfo *node_info) % + %  A description of each parameter follows.  % 2 %    o cube_info: A pointer to the Cube structure. % J %    o node_info: pointer to node in color cube tree that is to be pruned. %  %  */E static void PruneChild(CubeInfo *cube_info,const NodeInfo *node_info)  { 
   NodeInfo     *parent;     register int     id;      /*     Traverse any children.   */   if (node_info->census != 0) '     for (id=0; id < MaxTreeDepth; id++) (       if (node_info->census & (1 << id))3         PruneChild(cube_info,node_info->child[id]);    /*'     Merge color statistics into parent.    */   parent=node_info->parent; (   parent->census&=~(1 << node_info->id);2   parent->number_unique+=node_info->number_unique;*   parent->total_red+=node_info->total_red;.   parent->total_green+=node_info->total_green;,   parent->total_blue+=node_info->total_blue;   cube_info->nodes--;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  P r u n e L e v e l                                                        % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method PruneLevel deletes all nodes at the bottom level of the color > %  tree merging their color statistics into their parent node. % * %  The format of the PruneLevel method is: % @ %      PruneLevel(CubeInfo *cube_info,const NodeInfo *node_info) % + %  A description of each parameter follows.  % 2 %    o cube_info: A pointer to the Cube structure. % J %    o node_info: pointer to node in color cube tree that is to be pruned. %  %  */E static void PruneLevel(CubeInfo *cube_info,const NodeInfo *node_info)  {    register int     id;      /*     Traverse any children.   */   if (node_info->census != 0) '     for (id=0; id < MaxTreeDepth; id++) (       if (node_info->census & (1 << id))3         PruneLevel(cube_info,node_info->child[id]); +   if (node_info->level == cube_info->depth) $     PruneChild(cube_info,node_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  Q u a n t i z a t i o n E r r o r                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method QuantizationError measures the difference between the originalJ %  and quantized images.  This difference is the total quantization error.L %  The error is computed by summing over all pixels in an image the distanceL %  squared in RGB space between each reference pixel value and its quantized% %  value.  These values are computed:  % I %    o mean_error_per_pixel:  This value is the mean error for any single  %      pixel in the image. % G %    o normalized_mean_square_error:  This value is the normalized mean K %      quantization error for any single pixel in the image.  This distance K %      measure is normalized to a range between 0 and 1.  It is independent @ %      of the range of red, green, and blue values in the image. % E %    o normalized_maximum_square_error:  Thsi value is the normalized J %      maximum quantization error for any single pixel in the image.  ThisH %      distance measure is normalized to a range between 0 and 1.  It isM %      independent of the range of red, green, and blue values in your image.  %  % 1 %  The format of the QuantizationError method is:  % 3 %      unsigned int QuantizationError(Image *image)  % + %  A description of each parameter follows.  % @ %    o image: The address of a byte (8 bits) array of run-lengthB %      encoded pixel data of your reference image.  The sum of theJ %      run-length counts in the reference image must be equal to or exceed %      the number of pixels. %  %  */3 Export unsigned int QuantizationError(Image *image)  { 
   CubeInfo     cube_info;     double     maximum_error_per_pixel,     total_error;  
   IndexPacket 
     index;     int      y;     register double      distance_squared, 
     *squares;      register int     i,     x;     register PixelPacket     *p;      /*     Initialize measurement.    */"   assert(image != (Image *) NULL);;   image->total_colors=GetNumberColors(image,(FILE *) NULL);     image->mean_error_per_pixel=0;#   image->normalized_mean_error=0.0; &   image->normalized_maximum_error=0.0;"   if (image->class == DirectClass)     return(True); P   cube_info.squares=(double *) AllocateMemory((MaxRGB+MaxRGB+1)*sizeof(double));+   if (cube_info.squares == (double *) NULL)      { C       MagickWarning(ResourceLimitWarning,"Unable to measure error", $         "Memory allocation failed");       return(False);     }    cube_info.squares+=MaxRGB;%   for (i=(-MaxRGB); i <= MaxRGB; i++)      cube_info.squares[i]=i*i;    /*-     For each pixel, collect error statistics.    */   squares=cube_info.squares;   maximum_error_per_pixel=0;   total_error=0;'   for (y=0; y < (int) image->rows; y++)    { 0     p=GetPixelCache(image,0,y,image->columns,1);"     if (p == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     {        index=image->indexes[x];J       distance_squared=squares[(int) (p->red-image->colormap[index].red)]+?         squares[(int) (p->green-image->colormap[index].green)]+ =         squares[(int) (p->blue-image->colormap[index].blue)]; $       total_error+=distance_squared;5       if (distance_squared > maximum_error_per_pixel) 1         maximum_error_per_pixel=distance_squared; 
       p++;     }    }    /*#     Compute final error statistics.    */,   image->mean_error_per_pixel=(unsigned int)/     (total_error/(image->columns*image->rows));    image->normalized_mean_error= >     (image->mean_error_per_pixel)/(3.0*(MaxRGB+1)*(MaxRGB+1));"   image->normalized_maximum_error=8     maximum_error_per_pixel/(3.0*(MaxRGB+1)*(MaxRGB+1));   cube_info.squares-=MaxRGB;    FreeMemory(cube_info.squares);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  Q u a n t i z e I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method QuantizeImage analyzes the colors within a reference image andL %  chooses a fixed number of colors to represent the image.  The goal of theM %  algorithm is to minimize the difference between the input and output image ( %  while minimizing the processing time. % - %  The format of the QuantizeImage method is:  % D %      unsigned int QuantizeImage(const QuantizeInfo *quantize_info, %        Image *image) % + %  A description of each parameter follows:  % G %    o quantize_info: Specifies a pointer to an QuantizeInfo structure.  % 7 %    o image: Specifies a pointer to a Image structure.  %  */D Export unsigned int QuantizeImage(const QuantizeInfo *quantize_info,   Image *image)  { 
   CubeInfo     cube_info;     int 
     depth;     unsigned int     number_colors,     status;   "   assert(image != (Image *) NULL);E   if ((quantize_info->number_colors == 2) && quantize_info->dither && 4       (quantize_info->colorspace == GRAYColorspace))     { '       status=OrderedDitherImage(image);        return(status);      } -   number_colors=quantize_info->number_colors;    if (number_colors == 0)      number_colors=MaxRGB+1; ,   if ((int) number_colors > MaxColormapSize)"     number_colors=MaxColormapSize;"   depth=quantize_info->tree_depth;   if (depth == 0)      {        unsigned int         colors;          /*E         Depth of color classification tree is: Log4(colormap size)+2.        */       colors=number_colors; )       for (depth=1; colors != 0; depth++)          colors>>=2;         if (quantize_info->dither)         depth--;&       if (image->class == PseudoClass)         depth+=2;      }    /*     Initialize color cube.   */5   status=GetCubeInfo(&cube_info,quantize_info,depth);    if (status == False)     return(False);1   if (quantize_info->colorspace != RGBColorspace) 7     RGBTransformImage(image,quantize_info->colorspace); *   status=Classification(&cube_info,image);   if (status != False)     {        /*A         Reduce the number of colors in the continuous tone image.        */+       if (number_colors < cube_info.colors) ,         Reduction(&cube_info,number_colors);*       status=Assignment(&cube_info,image);5       if (quantize_info->colorspace != RGBColorspace) ;         TransformRGBImage(image,quantize_info->colorspace);      }    DestroyCubeInfo(&cube_info);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   Q u a n t i z e I m a g e s                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  QuantizeImages analyzes the colors within a set of reference images andJ %  chooses a fixed number of colors to represent the set.  The goal of theN %  algorithm is to minimize the difference between the input and output images( %  while minimizing the processing time. % . %  The format of the QuantizeImages method is: % E %      unsigned int QuantizeImages(const QuantizeInfo *quantize_info,  %        Image *images)  % + %  A description of each parameter follows:  % G %    o quantize_info: Specifies a pointer to an QuantizeInfo structure.  % A %    o images: Specifies a pointer to a list of Image structures.  %  %  */E Export unsigned int QuantizeImages(const QuantizeInfo *quantize_info,    Image *images) { 
   CubeInfo     cube_info;     int 
     depth;     MonitorHandler     handler;     Image      *image;      register int     i;     unsigned int     number_colors,     number_images,     status;   #   assert(images != (Image *) NULL); %   if (images->next == (Image *) NULL)      {        /*1         Handle a single image with QuantizeImage.        */1       status=QuantizeImage(quantize_info,images);        return(status);      } -   number_colors=quantize_info->number_colors;    if (number_colors == 0)      number_colors=MaxRGB+1; ,   if ((int) number_colors > MaxColormapSize)"     number_colors=MaxColormapSize;"   depth=quantize_info->tree_depth;   if (depth == 0)      { 	       int          pseudo_class;          unsigned int         colors;          /*E         Depth of color classification tree is: Log4(colormap size)+2.        */       colors=number_colors; )       for (depth=1; colors != 0; depth++)          colors>>=2;         if (quantize_info->dither)         depth--;       pseudo_class=True;D       for (image=images; image != (Image *) NULL; image=image->next)4         pseudo_class|=(image->class == PseudoClass);       if (pseudo_class)          depth+=2;      }    /*     Initialize color cube.   */5   status=GetCubeInfo(&cube_info,quantize_info,depth);    if (status == False)     return(False);   image=images; )   for (i=0; image != (Image *) NULL; i++)    { 3     if (quantize_info->colorspace != RGBColorspace) 9       RGBTransformImage(image,quantize_info->colorspace);      image=image->next;   }    number_images=i;   image=images; )   for (i=0; image != (Image *) NULL; i++)    { 5     handler=SetMonitorHandler((MonitorHandler) NULL); ,     status=Classification(&cube_info,image);     if (status == False)       break;     image=image->next;&     (void) SetMonitorHandler(handler);7     ProgressMonitor(ClassifyImageText,i,number_images);    }    if (status != False)     {        /*J         Reduce the number of colors in the continuous tone image sequence.       */*       Reduction(&cube_info,number_colors);       image=images; -       for (i=0; image != (Image *) NULL; i++)        { 9         handler=SetMonitorHandler((MonitorHandler) NULL); ,         status=Assignment(&cube_info,image);         if (status == False)           break;7         if (quantize_info->colorspace != RGBColorspace) =           TransformRGBImage(image,quantize_info->colorspace);          image=image->next;*         (void) SetMonitorHandler(handler);9         ProgressMonitor(AssignImageText,i,number_images);        }      }    DestroyCubeInfo(&cube_info);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   R e d u c e                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method Reduce traverses the color cube tree and prunes any node whose9 %  quantization error falls below a particular threshold.  % & %  The format of the Reduce method is: % < %      Reduce(CubeInfo *cube_info,const NodeInfo *node_info) % + %  A description of each parameter follows.  % 2 %    o cube_info: A pointer to the Cube structure. % J %    o node_info: pointer to node in color cube tree that is to be pruned. %  %  */A static void Reduce(CubeInfo *cube_info,const NodeInfo *node_info)  {    register unsigned int      id;      /*     Traverse any children.   */   if (node_info->census != 0) '     for (id=0; id < MaxTreeDepth; id++) (       if (node_info->census & (1 << id))/         Reduce(cube_info,node_info->child[id]); D   if (node_info->quantization_error <= cube_info->pruning_threshold)$     PruneChild(cube_info,node_info);   else     {        /*'         Find minimum pruning threshold.        */'       if (node_info->number_unique > 0)          cube_info->colors++;L       if (node_info->quantization_error < cube_info->next_pruning_threshold)H         cube_info->next_pruning_threshold=node_info->quantization_error;     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   R e d u c t i o n                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method Reduction repeatedly prunes the tree until the number of nodesL %  with n2 > 0 is less than or equal to the maximum number of colors allowedI %  in the output image.  On any given iteration over the tree, it selects D %  those nodes whose E value is minimal for pruning and merges theirF %  color statistics upward. It uses a pruning threshold, Ep, to govern %  node selection as follows:  %  %    Ep = 0 L %    while number of nodes with (n2 > 0) > required maximum number of colors( %      prune all nodes such that E <= Ep- %      Set Ep to minimum E in remaining nodes  % H %  This has the effect of minimizing any quantization error when merging %  two nodes together. % H %  When a node to be pruned has offspring, the pruning procedure invokesH %  itself recursively in order to prune the tree from the leaves upward.G %  n2,  Sr, Sg,  and  Sb in a node being pruned are always added to the E %  corresponding data in that node's parent.  This retains the pruned 4 %  node's color characteristics for later averaging. % D %  For each node, n2 pixels exist for which that node represents theI %  smallest volume in RGB space containing those pixel's colors.  When n2 H %  > 0 the node will uniquely define a color in the output image. At theH %  beginning of reduction,  n2 = 0  for all nodes except a the leaves of> %  the tree which represent colors present in the input image. % B %  The other pixel count, n1, indicates the total number of colorsI %  within the cubic volume which the node represents.  This includes n1 - I %  n2  pixels whose colors should be defined by nodes at a lower level in  %  the tree. % ) %  The format of the Reduction method is:  % F %      Reduction(CubeInfo *cube_info,const unsigned int number_colors) % + %  A description of each parameter follows.  % 2 %    o cube_info: A pointer to the Cube structure. % H %    o number_colors: This integer value indicates the maximum number ofG %      colors in the quantized image or colormap.  The actual number of H %      colors allocated to the colormap may be less than this value, but %      never more. %  %  */K static void Reduction(CubeInfo *cube_info,const unsigned int number_colors)  { 7 #define ReduceImageText  "  Reducing image colors...  "      unsigned int	     span;   (   span=(unsigned int) cube_info->colors;(   cube_info->next_pruning_threshold=0.0;+   while (cube_info->colors > number_colors)    { C     cube_info->pruning_threshold=cube_info->next_pruning_threshold; J     cube_info->next_pruning_threshold=cube_info->root->quantization_error;     cube_info->colors=0;&     Reduce(cube_info,cube_info->root);L     ProgressMonitor(ReduceImageText,(unsigned int) (span-cube_info->colors),       span-number_colors+1);   }  } 