 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            RRRR   L       AAA                               % O %                            R   R  L      A   A                              % O %                            RRRR   L      AAAAA                              % O %                            R R    L      A   A                              % O %                            R  R   LLLLL  A   A                              % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d R L A I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method ReadRLAImage reads a run-length encoded Wavefront RLA image fileG %  and returns it.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % O %  Note:  This module was contributed by Lester Vecsey (master@internexus.net).  % , %  The format of the ReadRLAImage method is: % 7 %      Image *ReadRLAImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadRLAImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadRLAImage(const ImageInfo *image_info)  {    typedef struct _WindowFrame    { 	     short        left,        right,
       bottom, 
       top;   } WindowFrame;     typedef struct _RLAHeader    {      WindowFrame 
       window,        active_window;  	     short        frame,       storage_type,        number_channels,       number_matte_channels,        number_auxiliary_channels,       revision;        char       gamma[16],       red_primary[24],       green_primary[24],       blue_primary[24],        white_point[24];       long       job_number;        char       name[128],       description[128],        program[64],       machine[32],       user[32],        date[20],        aspect[24],        aspect_ratio[8],       chan[32];   	     short        field;       char       time[12],        filter[32];   	     short        bits_per_channel,        matte_type,        matte_bits,        auxiliary_type,        auxiliary_bits;        char       auxiliary[32],       space[36];       long       next;    } RLAHeader;     Image      *image;      int      channel,     length,      runlength,     y;     long     *scanlines;      register int     i,     x;     register PixelPacket     *q;      RLAHeader      rla_header;      unsigned char 	     byte;      unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);2   rla_header.window.left=MSBFirstReadShort(image);3   rla_header.window.right=MSBFirstReadShort(image); 4   rla_header.window.bottom=MSBFirstReadShort(image);1   rla_header.window.top=MSBFirstReadShort(image); 9   rla_header.active_window.left=MSBFirstReadShort(image); :   rla_header.active_window.right=MSBFirstReadShort(image);;   rla_header.active_window.bottom=MSBFirstReadShort(image); 8   rla_header.active_window.top=MSBFirstReadShort(image);,   rla_header.frame=MSBFirstReadShort(image);3   rla_header.storage_type=MSBFirstReadShort(image); 6   rla_header.number_channels=MSBFirstReadShort(image);<   rla_header.number_matte_channels=MSBFirstReadShort(image);&   if (rla_header.number_channels == 0)!     rla_header.number_channels=3; ?   rla_header.number_channels+=rla_header.number_matte_channels; @   rla_header.number_auxiliary_channels=MSBFirstReadShort(image);/   rla_header.revision=MSBFirstReadShort(image); 6   (void) ReadBlob(image,16,(char *) rla_header.gamma);<   (void) ReadBlob(image,24,(char *) rla_header.red_primary);>   (void) ReadBlob(image,24,(char *) rla_header.green_primary);=   (void) ReadBlob(image,24,(char *) rla_header.blue_primary); <   (void) ReadBlob(image,24,(char *) rla_header.white_point);7   rla_header.job_number=(long) MSBFirstReadLong(image); 6   (void) ReadBlob(image,128,(char *) rla_header.name);=   (void) ReadBlob(image,128,(char *) rla_header.description); 8   (void) ReadBlob(image,64,(char *) rla_header.program);8   (void) ReadBlob(image,32,(char *) rla_header.machine);5   (void) ReadBlob(image,32,(char *) rla_header.user); 5   (void) ReadBlob(image,20,(char *) rla_header.date); 7   (void) ReadBlob(image,24,(char *) rla_header.aspect); <   (void) ReadBlob(image,8,(char *) rla_header.aspect_ratio);5   (void) ReadBlob(image,32,(char *) rla_header.chan); ,   rla_header.field=MSBFirstReadShort(image);5   (void) ReadBlob(image,12,(char *) rla_header.time); 7   (void) ReadBlob(image,32,(char *) rla_header.filter); 7   rla_header.bits_per_channel=MSBFirstReadShort(image); 1   rla_header.matte_type=MSBFirstReadShort(image); 1   rla_header.matte_bits=MSBFirstReadShort(image); 5   rla_header.auxiliary_type=MSBFirstReadShort(image); 5   rla_header.auxiliary_bits=MSBFirstReadShort(image); :   (void) ReadBlob(image,32,(char *) rla_header.auxiliary);6   (void) ReadBlob(image,36,(char *) rla_header.space);1   rla_header.next=(long) MSBFirstReadLong(image);    /*     Initialize image structure.    */5   image->matte=rla_header.number_matte_channels != 0;    image->depth=QuantumDepth;N   image->columns=rla_header.active_window.right-rla_header.active_window.left;K   image->rows=rla_header.active_window.top-rla_header.active_window.bottom;    if (image_info->ping)      {        CloseBlob(image);        return(image);     } >   scanlines=(long *) AllocateMemory(image->rows*sizeof(long));!   if (scanlines == (long *) NULL) F     ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);&   if (*rla_header.description != '\0')     {        /*         RLA image comment.       */       image->comments=(char *)H         AllocateMemory((Extent(rla_header.description)+1)*sizeof(char));+       if (image->comments == (char *) NULL) I         ReaderExit(ResourceLimitWarning,"Memory allocation failed",image) <       (void) strcpy(image->comments,rla_header.description);     }    /*'     Read offsets to each scanline data.    */'   for (i=0; i < (int) image->rows; i++) 0     scanlines[i]=(long) MSBFirstReadLong(image);   /*     Read image data.   */   x=0;'   for (y=0; y < (int) image->rows; y++)    { ?     (void) SeekBlob(image,scanlines[image->rows-y-1],SEEK_SET); J     for (channel=0; channel < (int) rla_header.number_channels; channel++)     { &       length=MSBFirstReadShort(image);)       q=image->pixels+(y*image->columns);        while (length > 0)       {          byte=ReadByte(image);          runlength=byte;          if (byte > 127)            runlength=byte-256;          length--;          if (length == 0)           break;         if (runlength < 0)           { K             q=GetPixelCache(image,x % image->columns,y/image->columns,1,1); *             if (q == (PixelPacket *) NULL)               break;!             while (runlength < 0) 
             { #               byte=ReadByte(image);                length--;                switch (channel)               {                  case 0:                  { '                   q->red=UpScale(byte); $                   *image->indexes=0;                   break;                 }                  case 1:                  { )                   q->green=UpScale(byte);                    break;                 }                  case 2:                  { (                   q->blue=UpScale(byte);                   break;                 }                  case 3:                  default:                 { +                   q->opacity=UpScale(byte);                    break;                 }                } )               if (!SyncPixelCache(image))                  break;               x++;               runlength++;
             }              continue;            }          byte=ReadByte(image);          length--;          runlength++;
         do	         { I           q=GetPixelCache(image,x % image->columns,y/image->columns,1,1); (           if (q == (PixelPacket *) NULL)             break;           switch (channel)           {              case 0: 
             { #               q->red=UpScale(byte);                 *image->indexes=0;               break;
             }              case 1: 
             { %               q->green=UpScale(byte);                break;
             }              case 2: 
             { $               q->blue=UpScale(byte);               break;
             }              case 3:              default:
             { '               q->opacity=UpScale(byte);                break;
             }            } %           if (!SyncPixelCache(image))              break;           x++;           runlength--;	         }          while (runlength > 0);       }      } #     if (QuantumTick(y,image->rows)) 3       ProgressMonitor(LoadImageText,y,image->rows);    }    CloseBlob(image);    return(image); } 