 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            RRRR   L      EEEEE                              % O %                            R   R  L      E                                  % O %                            RRRR   L      EEE                                % O %                            R R    L      E                                  % O %                            R  R   LLLLL  EEEEE                              % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s R L E                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method IsRLE returns True if the image format type, identified by the %  magick string, is RLE.  % , %  The format of the ReadRLEImage method is: % 6 %      unsigned int IsRLE(const unsigned char *magick,# %        const unsigned int length)  % + %  A description of each parameter follows:  % J %    o status:  Method IsRLE returns True if the image format type is RLE. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */P Export unsigned int IsRLE(const unsigned char *magick,const unsigned int length) {    if (length < 2)      return(False);1   if (strncmp((char *) magick,"\122\314",2) == 0)      return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d R L E I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method ReadRLEImage reads a run-length encoded Utah Raster Toolkit L %  image file and returns it.  It allocates the memory necessary for the new: %  Image structure and returns a pointer to the new image. % , %  The format of the ReadRLEImage method is: % 7 %      Image *ReadRLEImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadRLEImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadRLEImage(const ImageInfo *image_info)  {  #define SkipLinesOp  0x01  #define SetColorOp  0x02 #define SkipPixelsOp  0x03 #define ByteDataOp  0x05 #define RunDataOp  0x06  #define EOFOp  0x07      char     magick[12];      Image      *image;      int      opcode,      operand,     status,      y;     register int     i,     x;     register PixelPacket     *q;      register unsigned char     *p;      unsigned char      background_color[256],     *colormap,
     pixel,
     plane,     *rle_pixels;     unsigned int     bits_per_pixel, 
     flags,     map_length,      number_colormaps,      number_planes;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*$     Determine if this is a RLE file.   */+   status=ReadBlob(image,2,(char *) magick); ?   if ((status == False) || (strncmp(magick,"\122\314",2) != 0)) A     ReaderExit(CorruptImageWarning,"Not a RLE image file",image);    do   {      /*       Read image header.     */$     (void) LSBFirstReadShort(image);$     (void) LSBFirstReadShort(image);,     image->columns=LSBFirstReadShort(image);)     image->rows=LSBFirstReadShort(image);      if (image_info->ping)        {          CloseBlob(image);          return(image);       }      flags=ReadByte(image);     image->matte=flags & 0x04;"     number_planes=ReadByte(image);#     bits_per_pixel=ReadByte(image); %     number_colormaps=ReadByte(image); $     map_length=1 << ReadByte(image);P     if ((number_planes == 0) || (number_planes == 2) || (bits_per_pixel != 8) ||         (image->columns == 0))I       ReaderExit(CorruptImageWarning,"Unsupported RLE image file",image);      if (flags & 0x02)        { 
         /*4           No background color-- initialize to black.
         *//         for (i=0; i < (int) number_planes; i++) 0           background_color[i]=(unsigned char) 0;         (void) ReadByte(image);        }      else       { 
         /*&           Initialize background color.
         */         p=background_color; /         for (i=0; i < (int) number_planes; i++) /           *p++=(unsigned char) ReadByte(image);        } $     if ((number_planes & 0x01) == 0)       (void) ReadByte(image); $     colormap=(unsigned char *) NULL;     if (number_colormaps != 0)       { 
         /*           Read image colormaps. 
         */"         colormap=(unsigned char *)L           AllocateMemory(number_colormaps*map_length*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL) L           ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);         p=colormap; 2         for (i=0; i < (int) number_colormaps; i++).           for (x=0; x < (int) map_length; x++)6             *p++=XDownScale(LSBFirstReadShort(image));       }      if (flags & 0x08)        {          unsigned int           length;   
         /*           Read image comment. 
         */(         length=LSBFirstReadShort(image);E         image->comments=(char *) AllocateMemory(length*sizeof(char)); -         if (image->comments == (char *) NULL) L           ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);A         (void) ReadBlob(image,length-1,(char *) image->comments); '         image->comments[length-1]='\0'; !         if ((length & 0x01) == 0) !           (void) ReadByte(image);        }      /*       Allocate RLE pixels.     */     if (image->matte)        number_planes++;0     rle_pixels=(unsigned char *) AllocateMemory(F       image->columns*image->rows*number_planes*sizeof(unsigned char));-     if (rle_pixels == (unsigned char *) NULL) H       ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);*     if ((flags & 0x01) && !(flags & 0x02))       { 
         /*           Set background color. 
         */         p=rle_pixels; >         for (i=0; i < (int) (image->columns*image->rows); i++)	         {            if (!image->matte)3             for (x=0; x < (int) number_planes; x++) '               *p++=background_color[x];            else
             { 9               for (x=0; x < (int) (number_planes-1); x++) )                 *p++=background_color[x]; 5               *p++=0;  /* initialize matte channel */ 
             } 	         }        }      /*#       Read runlength-encoded image.      */     plane=0;     x=0;     y=0;     opcode=ReadByte(image);      do     {        switch (opcode & 0x3f)       {          case SkipLinesOp: 	         { "           operand=ReadByte(image);           if (opcode & 0x40)-             operand=LSBFirstReadShort(image);            x=0;           y+=operand;            break;	         }          case SetColorOp:	         { "           operand=ReadByte(image);(           plane=(unsigned char) operand;           if (plane == 255) "             plane=number_planes-1;           x=0;           break;	         }          case SkipPixelsOp:	         { "           operand=ReadByte(image);           if (opcode & 0x40)-             operand=LSBFirstReadShort(image);            x+=operand;            break;	         }          case ByteDataOp:	         { "           operand=ReadByte(image);           if (opcode & 0x40)-             operand=LSBFirstReadShort(image); H           p=rle_pixels+((image->rows-y-1)*image->columns*number_planes)+"             x*number_planes+plane;           operand++;%           for (i=0; i < operand; i++)            { "             pixel=ReadByte(image);J             if ((y < (int) image->rows) && ((x+i) < (int) image->columns))               *p=pixel;              p+=number_planes;            }            if (operand & 0x01) #             (void) ReadByte(image);            x+=operand;            break;	         }          case RunDataOp: 	         { "           operand=ReadByte(image);           if (opcode & 0x40)-             operand=LSBFirstReadShort(image);             pixel=ReadByte(image);!           (void) ReadByte(image);            operand++;H           p=rle_pixels+((image->rows-y-1)*image->columns*number_planes)+"             x*number_planes+plane;%           for (i=0; i < operand; i++)            { J             if ((y < (int) image->rows) && ((x+i) < (int) image->columns))               *p=pixel;              p+=number_planes;            }            x+=operand;            break;	         }          default:           break;       }        opcode=ReadByte(image); <     } while (((opcode & 0x3f) != EOFOp) && (opcode != EOF));     if (number_colormaps != 0)       {          unsigned int           mask;   
         /*1           Apply colormap transformation to image. 
         */         mask=(map_length-1);         p=rle_pixels; "         if (number_colormaps == 1)@           for (i=0; i < (int) (image->columns*image->rows); i++)           { 3             *p=(unsigned char) colormap[*p & mask];              p++;           }          else>           if ((number_planes >= 3) && (number_colormaps >= 3))B             for (i=0; i < (int) (image->columns*image->rows); i++)5               for (x=0; x < (int) number_planes; x++)                { F                 *p=(unsigned char) colormap[x*map_length+(*p & mask)];                 p++;               }        }      /*!       Initialize image structure.      */     if (number_planes >= 3)        { 
         /*<           Convert raster image to DirectClass pixel packets.
         */         p=rle_pixels; -         for (y=0; y < (int) image->rows; y++) 	         { 6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           { !             q->red=UpScale(*p++); #             q->green=UpScale(*p++); "             q->blue=UpScale(*p++);             if (image->matte) '               q->opacity=UpScale(*p++);              q++;           } %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(LoadImageText,y,image->rows); 	         }        }      else       { 
         /*           Create colormap.
         */!         image->class=PseudoClass; "         if (number_colormaps == 0)           map_length=256; !         image->colors=map_length; '         image->colormap=(PixelPacket *) <           AllocateMemory(image->colors*sizeof(PixelPacket));4         if (image->colormap == (PixelPacket *) NULL)L           ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);         p=colormap; "         if (number_colormaps == 0)1           for (i=0; i < (int) image->colors; i++)            {              /*               Grayscale.             */@             image->colormap[i].red=(MaxRGB*i)/(image->colors-1);B             image->colormap[i].green=(MaxRGB*i)/(image->colors-1);A             image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);            }          else$           if (number_colormaps == 1)3             for (i=0; i < (int) image->colors; i++) 
             {                /*                 Pseudocolor.               */:               image->colormap[i].red=(Quantum) UpScale(i);<               image->colormap[i].green=(Quantum) UpScale(i);;               image->colormap[i].blue=(Quantum) UpScale(i); 
             }            else3             for (i=0; i < (int) image->colors; i++) 
             { 1               image->colormap[i].red=UpScale(*p); @               image->colormap[i].green=UpScale(*(p+map_length));A               image->colormap[i].blue=UpScale(*(p+map_length*2));                p++;
             }          p=rle_pixels;          if (!image->matte)           {              /*@               Convert raster image to PseudoClass pixel packets.             */1             for (y=0; y < (int) image->rows; y++) 
             { =               if (!SetPixelCache(image,0,y,image->columns,1))                  break;6               for (x=0; x < (int) image->columns; x++):                 image->indexes[x]=(unsigned short) (*p++);)               if (!SyncPixelCache(image))                  break;4               if (image->previous == (Image *) NULL)/                 if (QuantumTick(y,image->rows)) ?                   ProgressMonitor(LoadImageText,y,image->rows); 
             }              SyncImage(image);            }          else           {              /*A               Image has a matte channel-- promote to DirectClass.              */1             for (y=0; y < (int) image->rows; y++) 
             { :               q=SetPixelCache(image,0,y,image->columns,1);,               if (q == (PixelPacket *) NULL)                 break;6               for (x=0; x < (int) image->columns; x++)               { 1                 q->red=image->colormap[*p++].red; 5                 q->green=image->colormap[*p++].green; 3                 q->blue=image->colormap[*p++].blue; )                 q->opacity=UpScale(*p++);                  q++;               } )               if (!SyncPixelCache(image))                  break;4               if (image->previous == (Image *) NULL)/                 if (QuantumTick(y,image->rows)) ?                   ProgressMonitor(LoadImageText,y,image->rows); 
             } (             FreeMemory(image->colormap);1             image->colormap=(PixelPacket *) NULL; %             image->class=DirectClass;              image->colors=0;           }        }      if (number_colormaps != 0)       FreeMemory(colormap);      FreeMemory(rle_pixels);      /*       Proceed to next image.     */"     if (image_info->subrange != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;     (void) ReadByte(image); -     status=ReadBlob(image,2,(char *) magick); @     if ((status == True) && (strncmp(magick,"\122\314",2) == 0))       { 
         /*(           Allocate next image structure.
         */,         AllocateNextImage(image_info,image);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            }          image=image->next;F         ProgressMonitor(LoadImagesText,(unsigned int) TellBlob(image),*           (unsigned int) image->filesize);       } D   } while ((status == True) && (strncmp(magick,"\122\314",2) == 0));+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseBlob(image);    return(image); } 