 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            SSSSS   CCCC  TTTTT                              % O %                            SS     C        T                                % O %                             SSS   C        T                                % O %                               SS  C        T                                % O %                            SSSSS   CCCC    T                                % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s S C T                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method IsSCT returns True if the image format type, identified by the %  magick string, is SCT.  % , %  The format of the ReadSCTImage method is: % 6 %      unsigned int IsSCT(const unsigned char *magick,# %        const unsigned int length)  % + %  A description of each parameter follows:  % J %    o status:  Method IsSCT returns True if the image format type is SCT. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */P Export unsigned int IsSCT(const unsigned char *magick,const unsigned int length) {    if (length < 2)      return(False);+   if (strncmp((char *) magick,"CT",2) == 0)      return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d S C T I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Method ReadSCTImage reads a Scitex image file and returns it.  It allocatesL %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  % , %  The format of the ReadSCTImage method is: % 7 %      Image *ReadSCTImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadSCTImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadSCTImage(const ImageInfo *image_info)  {    char     buffer[768],     magick[2];     Image      *image;      int      y;     register int     x;     register PixelPacket     *q;      unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*     Read control block.    */,   (void) ReadBlob(image,80,(char *) buffer);+   (void) ReadBlob(image,2,(char *) magick); /   if ((strncmp((char *) magick,"CT",2) != 0) && /       (strncmp((char *) magick,"LW",2) != 0) && /       (strncmp((char *) magick,"BM",2) != 0) && /       (strncmp((char *) magick,"PG",2) != 0) && -       (strncmp((char *) magick,"TX",2) != 0)) A     ReaderExit(CorruptImageWarning,"Not a SCT image file",image); /   if ((strncmp((char *) magick,"LW",2) == 0) || /       (strncmp((char *) magick,"BM",2) == 0) || /       (strncmp((char *) magick,"PG",2) == 0) || -       (strncmp((char *) magick,"TX",2) == 0)) L     ReaderExit(CorruptImageWarning,"only Continuous Tone Picture supported",
       image); -   (void) ReadBlob(image,174,(char *) buffer); -   (void) ReadBlob(image,768,(char *) buffer);    /*     Read paramter block.   */,   (void) ReadBlob(image,32,(char *) buffer);,   (void) ReadBlob(image,14,(char *) buffer);   image->rows=atoi(buffer); ,   (void) ReadBlob(image,14,(char *) buffer);   image->columns=atoi(buffer);-   (void) ReadBlob(image,196,(char *) buffer); -   (void) ReadBlob(image,768,(char *) buffer);    if (image_info->ping)      {        CloseBlob(image);        return(image);     }    /*.     Convert SCT raster image to pixel packets.   */#   image->colorspace=CMYKColorspace; '   for (y=0; y < (int) image->rows; y++)    { 0     q=SetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     { -       q->red=MaxRGB-UpScale(ReadByte(image)); 
       q++;     } "     if ((image->columns % 2) != 0)(       (void) ReadByte(image);  /* pad */     q=image->pixels;,     for (x=0; x < (int) image->columns; x++)     { /       q->green=MaxRGB-UpScale(ReadByte(image)); 
       q++;     } "     if ((image->columns % 2) != 0)(       (void) ReadByte(image);  /* pad */     q=image->pixels;,     for (x=0; x < (int) image->columns; x++)     { .       q->blue=MaxRGB-UpScale(ReadByte(image));
       q++;     } "     if ((image->columns % 2) != 0)(       (void) ReadByte(image);  /* pad */     q=image->pixels;,     for (x=0; x < (int) image->columns; x++)     { 1       q->opacity=MaxRGB-UpScale(ReadByte(image)); 
       q++;     }      if (!SyncPixelCache(image))        break;"     if ((image->columns % 2) != 0)(       (void) ReadByte(image);  /* pad */#     if (QuantumTick(y,image->rows)) 3       ProgressMonitor(LoadImageText,y,image->rows);    }    return(image); } 