 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %               SSSSS  EEEEE   GGGG  M   M  EEEEE  N   N  TTTTT               % O %               SS     E      G      MM MM  E      NN  N    T                 % O %                SSS   EEE    G GGG  M M M  EEE    N N N    T                 % O %                  SS  E      G   G  M   M  E      N  NN    T                 % O %               SSSSS  EEEEE   GGGG  M   M  EEEEE  N   N    T                 % O %                                                                             % O %                                                                             % O %        Methods to Segment an Image with Thresholding Fuzzy c-Means          % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                April 1993                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Segment segments an image by analyzing the histograms of the color G %  components and identifying units that are homogeneous with the fuzzy H %  c-means technique.  The scale-space filter analyzes the histograms ofK %  the three color components of the image and identifies a set of classes. G %  The extents of each class is used to coarsely segment the image with G %  thresholding.  The color associated with each class is determined by I %  the mean color of all pixels within the extents of a particular class. J %  Finally, any unclassified pixels are assigned to the closest class with %  the fuzzy c-means technique.  % < %  The fuzzy c-Means algorithm can be summarized as follows: % D %    o Build a histogram, one for each color component of the image. % = %    o For each histogram, successively apply the scale-space = %      filter and build an interval tree of zero crossings in 9 %      the second derivative at each scale.  Analyze this ? %      scale-space ``fingerprint'' to determine which peaks and 5 %      valleys in the histogram are most predominant.  % ; %    o The fingerprint defines intervals on the axis of the > %      histogram.  Each interval contains either a minima or a> %      maxima in the original signal.  If each color component@ %      lies within the maxima interval, that pixel is considered= %      ``classified'' and is assigned an unique class number.  % 9 %    o Any pixel that fails to be classified in the above 6 %      thresholding pass is classified using the fuzzy? %      c-Means technique.  It is assigned to one of the classes 2 %      discovered in the histogram analysis phase. % E %  The fuzzy c-Means technique attempts to cluster a pixel by finding H %  the local minima of the generalized within group sum of squared errorI %  objective function.  A pixel is assigned to the closest class of which , %  the fuzzy membership has a maximum value. % J %  Segment is strongly based on software written by Andy Gallo, University %  of Delaware.  % = %  The following reference was used in creating this program:  % K %    Young Won Lim, Sang Uk Lee, "On The Color Image Segmentation Algorithm I %    Based on the Thresholding and the Fuzzy c-Means Techniques", Pattern ; %    Recognition, Volume 23, Number 9, pages 935-952, 1990.  %  %  */   #include "magick.h"  #include "defines.h"   /*   Define declarations. */ #define  Dimension  3    /*   Typedef declarations.  */ typedef struct _ExtentPacket {    int 
     index,	     left, 
     right;     long     center;  } ExtentPacket;    typedef struct _IntervalTree {    double     tau;     int 	     left, 
     right;     double     mean_stability,      stability;     struct _IntervalTree
     *sibling,      *child;  } IntervalTree;    typedef struct _ZeroCrossing {    double     tau,#     histogram[DownScale(MaxRGB)+1];      short #     crossings[DownScale(MaxRGB)+1];  } ZeroCrossing;    /*   Constant declarations. */	 const int    Blue = 2,    Green = 1,
   Red = 0,   SafeMargin = 3,    TreeLength = 600;    /*   Method prototypes. */
 static int-   DefineRegion(const short *,ExtentPacket *);    static void 1   ScaleSpace(const long *,const double,double *), 4   ZeroCrossHistogram(double *,const double,short *);   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   C l a s s i f y                                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  % J %  Method Classify defines on ore more classes.  Each pixel is thresholdedI %  to determine which class it belongs to.  If not class is identified it I %  is assigned to the closest class based on the fuzzy c-Means technique.  % ( %  The format of the Classify method is: % N %      unsigned int SegmentImage(Image *image,const ColorspaceType colorspace,C %        const unsigned int verbose,const double cluster_threshold, * %        const double smoothing_threshold) % + %  A description of each parameter follows.  % G %    o image: Specifies a pointer to an Image structure;  returned from  %      ReadImage.  % C %    o extrema:  Specifies a pointer to an array of integers.  They F %      represent the peaks and valleys of the histogram for each color %      component.  % N %    o cluster_threshold:  This double represents the minimum number of pixelsL %      contained in a hexahedra before it can be considered valid (expressed %      as a percentage). % G %    o weighting_exponent: Specifies the membership weighting exponent.  % L %    o verbose:  A value greater than zero prints detailed information about %      the identified classes. %  %  */: static unsigned int Classify(Image *image,short **extrema,A   const double cluster_threshold,const double weighting_exponent,    const unsigned int verbose)  { 3 #define SegmentImageText  "  Segmenting image...  "      typedef struct _Cluster    { 	     short 	       id;        ExtentPacket
       red,       green,       blue;        long       count;       struct _Cluster        *next;   } Cluster;  	   Cluster 
     *cluster, 
     *head,     *last_cluster,     *next_cluster;  
   PixelPacket      *colormap;     double     local_minima,      numerator,
     ratio,     sum;     ExtentPacket	     blue, 
     green,     red;     int 
     count,     y;     register double      distance_squared, 
     *squares;      register int     i,     j,     k,     x;     register PixelPacket     *p,      *q;      unsigned int     number_clusters;     /*     Form clusters.   */   cluster=(Cluster *) NULL;    head=(Cluster *) NULL;   red.index=0;)   while (DefineRegion(extrema[Red],&red))    {      green.index=0;/     while (DefineRegion(extrema[Green],&green))      {        blue.index=0; /       while (DefineRegion(extrema[Blue],&blue))        { 
         /*           Allocate a new class. 
         */%         if (head != (Cluster *) NULL)            { F             cluster->next=(Cluster *) AllocateMemory(sizeof(Cluster));"             cluster=cluster->next;           }          else           { @             cluster=(Cluster *) AllocateMemory(sizeof(Cluster));             head=cluster;            } (         if (cluster == (Cluster *) NULL)           { J             MagickWarning(ResourceLimitWarning,"Memory allocation failed",               (char *) NULL);              return(False);           } 
         /*!           Initialize a new class. 
         */         cluster->count=0;          cluster->red=red;          cluster->green=green;          cluster->blue=blue; '         cluster->next=(Cluster *) NULL;        }      }    }    if (head == (Cluster *) NULL)      {        /*0         No classes were identified-- create one.       */:       cluster=(Cluster *) AllocateMemory(sizeof(Cluster));&       if (cluster == (Cluster *) NULL)	         { H           MagickWarning(ResourceLimitWarning,"Memory allocation failed",             (char *) NULL);            return(False);	         }        /*         Initialize a new class.        */       cluster->count=0;        cluster->red=red;        cluster->green=green;        cluster->blue=blue; %       cluster->next=(Cluster *) NULL;        head=cluster;      }    /*&     Count the pixels for each cluster.   */
   count=0;'   for (y=0; y < (int) image->rows; y++)    { 0     p=GetPixelCache(image,0,y,image->columns,1);"     if (p == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     { L       for (cluster=head; cluster != (Cluster *) NULL; cluster=cluster->next)J         if (((int) DownScale(p->red) >= (cluster->red.left-SafeMargin)) &&K             ((int) DownScale(p->red) <= (cluster->red.right+SafeMargin)) && N             ((int) DownScale(p->green) >= (cluster->green.left-SafeMargin)) &&O             ((int) DownScale(p->green) <= (cluster->green.right+SafeMargin)) && L             ((int) DownScale(p->blue) >= (cluster->blue.left-SafeMargin)) &&K             ((int) DownScale(p->blue) <= (cluster->blue.right+SafeMargin)))            {              /*               Count this pixel.              */             count++;             cluster->count++; 3             cluster->red.center+=DownScale(p->red); 7             cluster->green.center+=DownScale(p->green); 5             cluster->blue.center+=DownScale(p->blue);              break;           } 
       p++;     } #     if (QuantumTick(y,image->rows)) ;       ProgressMonitor(SegmentImageText,y,image->rows << 1);    }    /*?     Remove clusters that do not meet minimum cluster threshold.    */
   count=0;   last_cluster=head;   next_cluster=head;G   for (cluster=head; cluster != (Cluster *) NULL; cluster=next_cluster)    {      next_cluster=cluster->next; B     if ((double) cluster->count >= (cluster_threshold*count*0.01))       { 
         /*           Initialize cluster. 
         */         cluster->id=count;         cluster->red.center=E           (cluster->red.center+(cluster->count >> 1))/cluster->count;          cluster->green.center=G           (cluster->green.center+(cluster->count >> 1))/cluster->count;          cluster->blue.center= F           (cluster->blue.center+(cluster->count >> 1))/cluster->count;         count++;         last_cluster=cluster;        }      else       { 
         /*           Delete cluster. 
         */         if (cluster == head)           head=next_cluster;         else*           last_cluster->next=next_cluster;         FreeMemory(cluster);       }    }    number_clusters=count;   if (verbose)     {        /*!         Print cluster statistics.        */:       (void) fprintf(stderr,"Fuzzy c-Means Statistics\n");7       (void) fprintf(stderr,"===================\n\n"); B       (void) fprintf(stderr,"\tTotal Number of Clusters = %u\n\n",         number_clusters);        /*5         Print the total number of points per cluster.        */C       (void) fprintf(stderr,"\n\nNumber of Vectors Per Cluster\n"); A       (void) fprintf(stderr,"=============================\n\n"); L       for (cluster=head; cluster != (Cluster *) NULL; cluster=cluster->next)P         (void) fprintf(stderr,"Cluster #%d = %ld\n",cluster->id,cluster->count);       /*"         Print the cluster extents.       */       (void) fprintf(stderr,G         "\n\n\nCluster Extents:        (Vector Size: %d)\n",Dimension); 1       (void) fprintf(stderr, "================"); L       for (cluster=head; cluster != (Cluster *) NULL; cluster=cluster->next)       { A         (void) fprintf(stderr,"\n\nCluster #%d\n\n",cluster->id); 6         (void) fprintf(stderr,"%d-%d  %d-%d  %d-%d\n",/           cluster->red.left,cluster->red.right, 3           cluster->green.left,cluster->green.right, 2           cluster->blue.left,cluster->blue.right);       }        /*(         Print the cluster center values.       */       (void) fprintf(stderr,M         "\n\n\nCluster Center Values:        (Vector Size: %d)\n",Dimension); 6       (void) fprintf(stderr, "=====================");L       for (cluster=head; cluster != (Cluster *) NULL; cluster=cluster->next)       { A         (void) fprintf(stderr,"\n\nCluster #%d\n\n",cluster->id); D         (void) fprintf(stderr,"%ld  %ld  %ld\n",cluster->red.center,6           cluster->green.center,cluster->blue.center);       } "       (void) fprintf(stderr,"\n");     }    /*#     Speed up distance calculations.    */   squares=(double *)K     AllocateMemory((DownScale(MaxRGB)+DownScale(MaxRGB)+1)*sizeof(double)); !   if (squares == (double *) NULL)      { D       MagickWarning(ResourceLimitWarning,"Memory allocation failed",         (char *) NULL);        return(False);     }    squares+=DownScale(MaxRGB); G   for (i=(-(int) DownScale(MaxRGB)); i <= (int) DownScale(MaxRGB); i++)      squares[i]=i*i;    /*     Allocate image colormap.   */   colormap=(PixelPacket *)G     AllocateMemory((unsigned int) number_clusters*sizeof(PixelPacket)); '   if (colormap == (PixelPacket *) NULL)      { D       MagickWarning(ResourceLimitWarning,"Memory allocation failed",         (char *) NULL);        return(False);     }    image->matte=False;    image->class=PseudoClass; .   if (image->colormap != (PixelPacket *) NULL)      FreeMemory(image->colormap);   image->colormap=colormap;     image->colors=number_clusters;   i=0;H   for (cluster=head; cluster != (Cluster *) NULL; cluster=cluster->next)   { B     image->colormap[i].red=(Quantum) UpScale(cluster->red.center);F     image->colormap[i].green=(Quantum) UpScale(cluster->green.center);D     image->colormap[i].blue=(Quantum) UpScale(cluster->blue.center);     i++;   }    /*#     Do course grain classification.    */'   for (y=0; y < (int) image->rows; y++)    { 0     q=GetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     { L       for (cluster=head; cluster != (Cluster *) NULL; cluster=cluster->next)J         if (((int) DownScale(q->red) >= (cluster->red.left-SafeMargin)) &&K             ((int) DownScale(q->red) <= (cluster->red.right+SafeMargin)) && N             ((int) DownScale(q->green) >= (cluster->green.left-SafeMargin)) &&O             ((int) DownScale(q->green) <= (cluster->green.right+SafeMargin)) && L             ((int) DownScale(q->blue) >= (cluster->blue.left-SafeMargin)) &&K             ((int) DownScale(q->blue) <= (cluster->blue.right+SafeMargin)))            {              /*"               Classify this pixel.             */*             image->indexes[x]=cluster->id;             break;           } &       if (cluster == (Cluster *) NULL)	         {            /*%             Compute fuzzy membership.            */           local_minima=0.0; 1           for (j=0; j < (int) image->colors; j++)            {              sum=0.0;              p=image->colormap+j;             distance_squared= G               squares[(int) DownScale(q->red)-(int) DownScale(p->red)]+ K               squares[(int) DownScale(q->green)-(int) DownScale(p->green)]+ I               squares[(int) DownScale(q->blue)-(int) DownScale(p->blue)]; -             numerator=sqrt(distance_squared); 5             for (k=j+1; k < (int) image->colors; k++) 
             { "               p=image->colormap+k;               distance_squared= I                 squares[(int) DownScale(q->red)-(int) DownScale(p->red)]+ M                 squares[(int) DownScale(q->green)-(int) DownScale(p->green)]+ K                 squares[(int) DownScale(q->blue)-(int) DownScale(p->blue)]; 5               ratio=numerator/sqrt(distance_squared); F               sum+=pow(ratio,(double) (2.0/(weighting_exponent-1.0)));
             } )             if ((1.0/sum) > local_minima)                {                  /*&                   Classify this pixel.                 */%                 local_minima=1.0/sum; 2                 image->indexes[x]=(IndexPacket) j;               }            } 	         } 
       q++;     }      if (!SyncPixelCache(image))        break;#     if (QuantumTick(y,image->rows)) G       ProgressMonitor(SegmentImageText,y+image->rows,image->rows << 1);    }    SyncImage(image);    /*     Free memory.   */G   for (cluster=head; cluster != (Cluster *) NULL; cluster=next_cluster)    {      next_cluster=cluster->next;      FreeMemory(cluster);   } #   squares-=(int) DownScale(MaxRGB);    FreeMemory(squares);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   C o n s o l i d a t e C r o s s i n g s                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  % E %  Method ConsolidateCrossings guarantees that an even number of zero . %  crossings always lie between two crossings. % 4 %  The format of the ConsolidateCrossings method is: % ; %      ConsolidateCrossings(zero_crossing,number_crossings)  % + %  A description of each parameter follows.  % L %    o zero_crossing: Specifies an array of structures of type ZeroCrossing. % K %    o number_crossings: This unsigned int specifies the number of elements " %      in the zero_crossing array. %  %  */= static void ConsolidateCrossings(ZeroCrossing *zero_crossing, &   const unsigned int number_crossings) {    int      center,      correct,
     count,	     left, 
     right;     register int     i,     j,     k,     l;     /*     Consolidate zero crossings.    */)   for (i=number_crossings-1; i >= 0; i--) 0     for (j=0; j <= (int) DownScale(MaxRGB); j++)     { -       if (zero_crossing[i].crossings[j] == 0)          continue;        /*C         Find the entry that is closest to j and still preserves the C         property that there are an even number of crossings between          intervals.       */       for (k=j-1; k > 0; k--) 1         if (zero_crossing[i+1].crossings[k] != 0)            break;       left=Max(k,0);       center=j; 3       for (k=j+1; k < (int) DownScale(MaxRGB); k++) 1         if (zero_crossing[i+1].crossings[k] != 0)            break;+       right=Min(k,(int) DownScale(MaxRGB));        /*.         K is the zero crossing just left of j.       */       for (k=j-1; k > 0; k--) /         if (zero_crossing[i].crossings[k] != 0)            break;       if (k < 0)         k=0;       /*E         Check center for an even number of crossings between k and j.        */       correct=(-1); /       if (zero_crossing[i+1].crossings[j] != 0) 	         {            count=0;&           for (l=k+1; l < center; l++)5             if (zero_crossing[i+1].crossings[l] != 0)                count++;           if ((count % 2) == 0)              if (center != k)               correct=center; 	         }        /*C         Check left for an even number of crossings between k and j.        */       if (correct == -1)	         {            count=0;$           for (l=k+1; l < left; l++)5             if (zero_crossing[i+1].crossings[l] != 0)                count++;           if ((count % 2) == 0)              if (left != k)               correct=left; 	         }        /*D         Check right for an even number of crossings between k and j.       */       if (correct == -1)	         {            count=0;%           for (l=k+1; l < right; l++) 5             if (zero_crossing[i+1].crossings[l] != 0)                count++;           if ((count % 2) == 0)              if (right != k)                correct=right;	         } &       l=zero_crossing[i].crossings[j];&       zero_crossing[i].crossings[j]=0;       if (correct != -1)<         zero_crossing[i].crossings[correct]=(IndexPacket) l;     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   D e f i n e R e g i o n                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  % F %  Method DefineRegion defines the left and right boundaries of a peak
 %  region. % , %  The format of the DefineRegion method is: % + %      status=DefineRegion(extrema,extents)  % + %  A description of each parameter follows.  % C %    o extrema:  Specifies a pointer to an array of integers.  They F %      represent the peaks and valleys of the histogram for each color %      component.  % F %    o extents:  This pointer to an ExtentPacket represent the extends; %      of a particular peak or valley of a color component.  %  %  */C static int DefineRegion(const short *extrema,ExtentPacket *extents)  {    /*!     Initialize to default values.    */   extents->left=0;   extents->center=0;#   extents->right=DownScale(MaxRGB);    /*      Find the left side (maxima).   */F   for ( ; extents->index <= (int) DownScale(MaxRGB); extents->index++)$     if (extrema[extents->index] > 0)       break;/   if (extents->index > (int) DownScale(MaxRGB)) 9     return(False);  /* no left side - no region exists */    extents->left=extents->index;    /*!     Find the right side (minima).    */F   for ( ; extents->index <= (int) DownScale(MaxRGB); extents->index++)$     if (extrema[extents->index] < 0)       break;"   extents->right=extents->index-1;   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   D e r i v a t i v e H i s t o g r a m                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  % H %  Method DerivativeHistogram determines the derivative of the histogram %  using central differencing. % 3 %  The format of the DerivativeHistogram method is:  % 0 %      DerivativeHistogram(histogram,derivative) % + %  A description of each parameter follows.  % J %    o histogram: Specifies an array of doubles representing the number ofA %      pixels for each intensity of a particular color component.  % N %    o derivative: This array of doubles is initialized by DerivativeHistogramE %      to the derivative of the histogram using central differencing.  %  %  */K static void DerivativeHistogram(const double *histogram,double *derivative)  {    register int     i,     n;     /*B     Compute endpoints using second order polynomial interpolation.   */   n=DownScale(MaxRGB);F   derivative[0]=(-1.5*histogram[0]+2.0*histogram[1]-0.5*histogram[2]);I   derivative[n]=(0.5*histogram[n-2]-2.0*histogram[n-1]+1.5*histogram[n]);    /*2     Compute derivative using central differencing.   */   for (i=1; i < n; i++) 4     derivative[i]=(histogram[i+1]-histogram[i-1])/2;	   return;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  I n i t i a l i z e H i s t o g r a m                                      % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % B %  Method InitializeHistogram computes the histogram for an image. % 3 %  The format of the InitializeHistogram method is:  % + %      InitializeHistogram(image,histogram)  % + %  A description of each parameter follows.  % G %    o image: Specifies a pointer to an Image structure;  returned from  %      ReadImage.  % H %    o histogram: Specifies an array of integers representing the numberD %      of pixels for each intensity of a particular color component. %  %  */> static void InitializeHistogram(Image *image,long **histogram) {    int      y;     register int     i,     x;     register PixelPacket     *p;      /*     Initialize histogram.    */.   for (i=0; i <= (int) DownScale(MaxRGB); i++)   {      histogram[Red][i]=0;     histogram[Green][i]=0;     histogram[Blue][i]=0;    } '   for (y=0; y < (int) image->rows; y++)    { 0     p=GetPixelCache(image,0,y,image->columns,1);"     if (p == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     { *       histogram[Red][DownScale(p->red)]++;.       histogram[Green][DownScale(p->green)]++;,       histogram[Blue][DownScale(p->blue)]++;
       p++;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   I n i t i a l i z e I n t e r v a l T r e e                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  % F %  Method InitializeIntervalTree initializes an interval tree from the %  lists of zero crossings.  % 6 %  The format of the InitializeIntervalTree method is: % = %      InitializeIntervalTree(zero_crossing,number_crossings)  % + %  A description of each parameter follows.  % L %    o zero_crossing: Specifies an array of structures of type ZeroCrossing. % K %    o number_crossings: This unsigned int specifies the number of elements " %      in the zero_crossing array. %  %  */  A static void InitializeList(IntervalTree **list,int *number_nodes,    IntervalTree *node)  { $   if (node == (IntervalTree *) NULL)     return; +   if (node->child == (IntervalTree *) NULL) !     list[(*number_nodes)++]=node; 2   InitializeList(list,number_nodes,node->sibling);0   InitializeList(list,number_nodes,node->child); }   6 static void MeanStability(register IntervalTree *node) {    register IntervalTree      *child;   $   if (node == (IntervalTree *) NULL)     return;    node->mean_stability=0.0;    child=node->child;%   if (child != (IntervalTree *) NULL)      {        register double          sum;         register int         count;         sum=0.0;       count=0;C       for ( ; child != (IntervalTree *) NULL; child=child->sibling)        {          sum+=child->stability;         count++;       } .       node->mean_stability=sum/(double) count;     }    MeanStability(node->sibling);    MeanStability(node->child);  }   2 static void Stability(register IntervalTree *node) { $   if (node == (IntervalTree *) NULL)     return; +   if (node->child == (IntervalTree *) NULL)      node->stability=0.0;   else1     node->stability=node->tau-(node->child)->tau;    Stability(node->sibling);    Stability(node->child);  }   N static IntervalTree *InitializeIntervalTree(const ZeroCrossing *zero_crossing,&   const unsigned int number_crossings) {    int 	     left,      number_nodes;      IntervalTree
     *head,     **list, 
     *node,
     *root;     register int     i,     j,     k;     /*     Allocate interval tree.    */K   list=(IntervalTree **) AllocateMemory(TreeLength*sizeof(IntervalTree *)); %   if (list == (IntervalTree **) NULL)      { D       MagickWarning(ResourceLimitWarning,"Memory allocation failed",         (char *) NULL); $       return((IntervalTree *) NULL);     }    /*%     The root is the entire histogram.    */=   root=(IntervalTree *) AllocateMemory(sizeof(IntervalTree)); $   root->child=(IntervalTree *) NULL;&   root->sibling=(IntervalTree *) NULL;   root->tau=0.0;   root->left=0;     root->right=DownScale(MaxRGB);/   for (i=(-1); i < (int) number_crossings; i++)    {      /*6       Initialize list with all nodes with no children.     */     number_nodes=0; ,     InitializeList(list,&number_nodes,root);     /*       Split list.      */$     for (j=0; j < number_nodes; j++)     {        head=list[j];        left=head->left;       node=head;0       for (k=head->left+1; k < head->right; k++)       { 1         if (zero_crossing[i+1].crossings[k] != 0)            {              if (node == head)                { ,                 node->child=(IntervalTree *)7                   AllocateMemory(sizeof(IntervalTree)); !                 node=node->child;                }              else               { .                 node->sibling=(IntervalTree *)7                   AllocateMemory(sizeof(IntervalTree)); #                 node=node->sibling;                } -             node->tau=zero_crossing[i+1].tau; .             node->child=(IntervalTree *) NULL;0             node->sibling=(IntervalTree *) NULL;             node->left=left;             node->right=k;             left=k;            } 	         }          if (left != head->left)            { P             node->sibling=(IntervalTree *) AllocateMemory(sizeof(IntervalTree));             node=node->sibling; -             node->tau=zero_crossing[i+1].tau; .             node->child=(IntervalTree *) NULL;0             node->sibling=(IntervalTree *) NULL;             node->left=left;$             node->right=head->right;           }        }      }    /*J     Determine the stability: difference between a nodes tau and its child.   */   Stability(root->child);    MeanStability(root->child);    FreeMemory(list);    return(root);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   O p t i m a l T a u                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  % J %  Method OptimalTau finds the optimal tau for each band of the histogram. % * %  The format of the OptimalTau method is: % J %      OptimalTau(histogram,max_tau,min_tau,delta_tau,smoothing_threshold, %        extrema)  % + %  A description of each parameter follows.  % H %    o histogram: Specifies an array of integers representing the numberD %      of pixels for each intensity of a particular color component. % C %    o extrema:  Specifies a pointer to an array of integers.  They F %      represent the peaks and valleys of the histogram for each color %      component.  %  %  */  > static void ActiveNodes(IntervalTree **list,int *number_nodes,   IntervalTree *node)  { $   if (node == (IntervalTree *) NULL)     return; .   if (node->stability >= node->mean_stability)     { #       list[(*number_nodes)++]=node; 3       ActiveNodes(list,number_nodes,node->sibling);      }    else     { 3       ActiveNodes(list,number_nodes,node->sibling); 1       ActiveNodes(list,number_nodes,node->child);      }  }   / static void FreeNodes(const IntervalTree *node)  { $   if (node == (IntervalTree *) NULL)     return;    FreeNodes(node->sibling);    FreeNodes(node->child);    FreeMemory((void *) node); }   D static double OptimalTau(const long *histogram,const double max_tau,O   const double min_tau,const double delta_tau,const double smoothing_threshold,    short *extrema)  {    double     average_tau,$     derivative[DownScale(MaxRGB)+1],+     second_derivative[DownScale(MaxRGB)+1],      tau,
     value;     int 
     index,     number_nodes, 	     peak,      x;     IntervalTree     **list, 
     *node,
     *root;     register int     i,     j,     k;     unsigned int
     count,     number_crossings;      ZeroCrossing     *zero_crossing;      /*     Allocate interval tree.    */K   list=(IntervalTree **) AllocateMemory(TreeLength*sizeof(IntervalTree *)); %   if (list == (IntervalTree **) NULL)      { D       MagickWarning(ResourceLimitWarning,"Memory allocation failed",         (char *) NULL);        return(0.0);     }    /*      Allocate zero crossing list.   */7   count=(unsigned int) ((max_tau-min_tau)/delta_tau)+2; L   zero_crossing=(ZeroCrossing *) AllocateMemory(count*sizeof(ZeroCrossing));-   if (zero_crossing == (ZeroCrossing *) NULL)      { D       MagickWarning(ResourceLimitWarning,"Memory allocation failed",         (char *) NULL);        return(0.0);     } !   for (i=0; i < (int) count; i++)      zero_crossing[i].tau=(-1);   /*"     Initialize zero crossing list.   */   i=0;3   for (tau=max_tau; tau >= min_tau; tau-=delta_tau)    {      zero_crossing[i].tau=tau; 9     ScaleSpace(histogram,tau,zero_crossing[i].histogram); ?     DerivativeHistogram(zero_crossing[i].histogram,derivative); 6     DerivativeHistogram(derivative,second_derivative);=     ZeroCrossHistogram(second_derivative,smoothing_threshold, "       zero_crossing[i].crossings);     i++;   }    /*,     Add an entry for the original histogram.   */   zero_crossing[i].tau=0.0; .   for (j=0; j <= (int) DownScale(MaxRGB); j++)8     zero_crossing[i].histogram[j]=(double) histogram[j];=   DerivativeHistogram(zero_crossing[i].histogram,derivative); 4   DerivativeHistogram(derivative,second_derivative);;   ZeroCrossHistogram(second_derivative,smoothing_threshold,       zero_crossing[i].crossings);   number_crossings=i;    /*M     Ensure the scale-space fingerprints form lines in scale-space, not loops.    */7   ConsolidateCrossings(zero_crossing,number_crossings);    /*3     Force endpoints to be included in the interval.    */-   for (i=0; i <= (int) number_crossings; i++)    { /     for (j=0; j < (int) DownScale(MaxRGB); j++) -       if (zero_crossing[i].crossings[j] != 0)          break;C     zero_crossing[i].crossings[0]=(-zero_crossing[i].crossings[j]); /     for (j=(int) DownScale(MaxRGB); j > 0; j--) -       if (zero_crossing[i].crossings[j] != 0)          break;2     zero_crossing[i].crossings[DownScale(MaxRGB)]='       (-zero_crossing[i].crossings[j]);    }    /*     Initialize interval tree.    */>   root=InitializeIntervalTree(zero_crossing,number_crossings);$   if (root == (IntervalTree *) NULL)     return(0.0);   /*P     Find active nodes:  stability is greater (or equal) to the mean stability of     its children.    */   number_nodes=0; .   ActiveNodes(list,&number_nodes,root->child);   /*     Initialize extrema.    */.   for (i=0; i <= (int) DownScale(MaxRGB); i++)     extrema[i]=0; "   for (i=0; i < number_nodes; i++)   {      /*+       Find this tau in zero crossings list.      */     k=0;     node=list[i]; /     for (j=0; j <= (int) number_crossings; j++) ,       if (zero_crossing[j].tau == node->tau)         k=j;     /*!       Find the value of the peak.      */7     peak=zero_crossing[k].crossings[node->right] == -1;      index=node->left; ,     value=zero_crossing[k].histogram[index];-     for (x=node->left; x <= node->right; x++)      {        if (peak) 	         { 4           if (zero_crossing[k].histogram[x] > value)
             { 2               value=zero_crossing[k].histogram[x];               index=x;
             } 	         } 
       else2         if (zero_crossing[k].histogram[x] < value)           { 0             value=zero_crossing[k].histogram[x];             index=x;           }      } -     for (x=node->left; x <= node->right; x++)      {        if (index == 0) "         index=DownScale(MaxRGB)+1;       if (peak)          extrema[x]=index; 
       else         extrema[x]=(-index);     }    }    /*     Determine the average tau.   */   average_tau=0.0;"   for (i=0; i < number_nodes; i++)     average_tau+=list[i]->tau;%   average_tau/=(double) number_nodes;    /*     Free memory.   */   FreeNodes(root);   FreeMemory(zero_crossing);   FreeMemory(list);    return(average_tau); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   S c a l e S p a c e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  % G %  Method ScaleSpace performs a scale-space filter on the 1D histogram.  % * %  The format of the ScaleSpace method is: % 1 %      ScaleSpace(histogram,tau,scaled_histogram)  % + %  A description of each parameter follows.  % J %    o histogram: Specifies an array of doubles representing the number ofA %      pixels for each intensity of a particular color component.  %  %  */> static void ScaleSpace(const long *histogram,const double tau,   double *scaled_histogram)  {    double
     alpha,	     beta,      gamma[DownScale(MaxRGB)+1],      sum;     register int     u,     x;  ,   alpha=1.0/(tau*sqrt((double) (2.0*M_PI)));   beta=(-1.0/(2.0*tau*tau));.   for (x=0; x <= (int) DownScale(MaxRGB); x++)&     gamma[x]=exp((double) (beta*x*x));.   for (x=0; x <= (int) DownScale(MaxRGB); x++)   {      sum=0.0;0     for (u=0; u <= (int) DownScale(MaxRGB); u++);       sum+=(double) histogram[u]*gamma[AbsoluteValue(x-u)]; "     scaled_histogram[x]=alpha*sum;   }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   Z e r o C r o s s H i s t o g r a m                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  % G %  Method ZeroCrossHistogram find the zero crossings in a histogram and K %  marks directions as:  1 is negative to positive; 0 is zero crossing; and  %  -1 is positive to negative. % 2 %  The format of the ZeroCrossHistogram method is: % J %      ZeroCrossHistogram(second_derivative,smoothing_threshold,crossings) % + %  A description of each parameter follows.  % H %    o second_derivative: Specifies an array of doubles representing theJ %      second derivative of the histogram of a particular color component. % = %    o crossings:  This array of integers is initialized with H %      -1, 0, or 1 representing the slope of the first derivative of the' %      of a particular color component.  %  %  */9 static void ZeroCrossHistogram(double *second_derivative, 4   const double smoothing_threshold,short *crossings) {    int      parity;      register int     i;     /*4     Merge low numbers to zero to help prevent noise.   */.   for (i=0; i <= (int) DownScale(MaxRGB); i++)7     if ((second_derivative[i] < smoothing_threshold) && 7         (second_derivative[i] >= -smoothing_threshold))        second_derivative[i]=0.0;    /*     Mark zero crossings.   */   parity=0; .   for (i=0; i <= (int) DownScale(MaxRGB); i++)   {      crossings[i]=0; #     if (second_derivative[i] < 0.0)        {          if (parity > 0)            crossings[i]=(-1);         parity=1;        }      else%       if (second_derivative[i] > 0.0) 	         {            if (parity < 0)              crossings[i]=1;            parity=(-1);	         }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  S e g m e n t I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method SegmentImage segment an image by analyzing the histograms of theM %  color components and identifying units that are homogeneous with the fuzzy  %  c-means technique.  % J %  Specify Icluster threshold as the number of pixels in each cluster mustF %  exceed the the cluster threshold to be considered valid.  SmoothingH %  threshold eliminates noise in the second derivative of the histogram.J %  As the value is increased, you can expect a smoother second derivative. %  The default is 1.5. % , %  The format of the SegmentImage method is: % 4 %      status=SegmentImage(image,colorspace,verbose) % + %  A description of each parameter follows.  % = %    o colors: The SegmentImage function returns this integer A %      value.  It is the actual number of colors allocated in the  %      colormap. % G %    o image: Specifies a pointer to an Image structure;  returned from  %      ReadImage.  % K %    o colorspace: An unsigned integer value that indicates the colorspace. M %      Empirical evidence suggests that distances in YUV or YIQ correspond to I %      perceptual color differences more closely than do distances in RGB G %      space.  The image is then returned to RGB colorspace after color  %      reduction.  % L %    o verbose:  A value greater than zero prints detailed information about %      the identified classes. %  %  */N Export unsigned int SegmentImage(Image *image,const ColorspaceType colorspace,<   const unsigned int verbose,const double cluster_threshold,#   const double smoothing_threshold)  {  #define DeltaTau  0.5  #define Tau  5.2 #define WeightingExponent  2.0     long     *histogram[Dimension];     register int     i;     short      *extrema[Dimension];     unsigned int     status;      /*#     Allocate histogram and extrema.    */"   assert(image != (Image *) NULL);   for (i=0; i < Dimension; i++)    { M     histogram[i]=(long *) AllocateMemory((DownScale(MaxRGB)+1)*sizeof(long)); M     extrema[i]=(short *) AllocateMemory((DownScale(MaxRGB)+1)*sizeof(short)); J     if ((histogram[i] == (long *) NULL) || (extrema[i] == (short *) NULL))       { F         MagickWarning(ResourceLimitWarning,"Memory allocation failed",           (char *) NULL);          for (i-- ; i >= 0; i--) 	         { !           FreeMemory(extrema[i]); #           FreeMemory(histogram[i]); 	         }          return(False);       }    } "   if (colorspace != RGBColorspace)(     RGBTransformImage(image,colorspace);   /*     Initialize histogram.    */'   InitializeHistogram(image,histogram); H   (void) OptimalTau(histogram[Red],Tau,0.2,DeltaTau,smoothing_threshold,     extrema[Red]);J   (void) OptimalTau(histogram[Green],Tau,0.2,DeltaTau,smoothing_threshold,     extrema[Green]);I   (void) OptimalTau(histogram[Blue],Tau,0.2,DeltaTau,smoothing_threshold,      extrema[Blue]);    /*/     Classify using the fuzzy c-Means technique.    */M   status=Classify(image,extrema,cluster_threshold,WeightingExponent,verbose); "   if (colorspace != RGBColorspace)(     TransformRGBImage(image,colorspace);   /*     Free memory.   */   for (i=0; i < Dimension; i++)    {      FreeMemory(extrema[i]);      FreeMemory(histogram[i]);    }    return(status);  } 