 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                      SSSSS  H   H  EEEEE   AAA    RRRR                      % O %                      SS     H   H  E      A   A   R   R                     % O %                       SSS   HHHHH  EEE    AAAAA   RRRR                      % O %                         SS  H   H  E      A   A   R R                       % O %                      SSSSS  H   H  EEEEE  A   A   R  R                      % O %                                                                             % O %                                                                             % O %            Methods to Shear or Rotate an Image by an Arbitrary Angle        % O %                                                                             % O %                                                                             % O %                               Software Design                               % O %                                 John Cristy                                 % O %                                  July 1992                                  % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method RotateImage, XShearImage, and YShearImage is based on the paper E %  "A Fast Algorithm for General Raster Rotatation" by Alan W. Paeth, M %  Graphics Interface '86 (Vancouver).  RotateImage is adapted from a similar J %  method based on the Paeth paper written by Michael Halle of the Spatial  %  Imaging Group, MIT Media Lab. %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   I n t e g r a l R o t a t e I m a g e                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method IntegralRotateImage rotates the image an integral of 90 degrees.L %  It allocates the memory necessary for the new Image structure and returns" %  a pointer to the rotated image. % 3 %  The format of the IntegralRotateImage method is:  % F %      Image *IntegralRotateImage(Image *image,unsigned int rotations) % + %  A description of each parameter follows.  % H %    o rotate_image: Method IntegralRotateImage returns a pointer to theP %      rotated image.  A null image is returned if there is a a memory shortage. % 7 %    o image: The address of a structure of type Image.  % > %    o rotations: Specifies the number of 90 degree rotations. %  %  */F static Image *IntegralRotateImage(Image *image,unsigned int rotations) { 0 #define RotateImageText  "  Rotating image...  "     Image      *rotate_image;     int      y;     register int     x;     register PixelPacket     *p,      *q;      /*(     Initialize rotated image attributes.   */"   assert(image != (Image *) NULL);   rotations%=4; +   if ((rotations == 1) || (rotations == 3)) C     rotate_image=CloneImage(image,image->rows,image->columns,True);    elseC     rotate_image=CloneImage(image,image->columns,image->rows,True); %   if (rotate_image == (Image *) NULL)      { B       MagickWarning(ResourceLimitWarning,"Unable to rotate image",$         "Memory allocation failed");       return((Image *) NULL);      }    /*     Integral rotate the image.   */   switch (rotations)   {      case 0:      {        /*         Rotate 0 degrees.        */+       for (y=0; y < (int) image->rows; y++)        { 4         p=GetPixelCache(image,0,y,image->columns,1);B         q=SetPixelCache(rotate_image,0,y,rotate_image->columns,1);G         if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))            break;(         if (image->class == PseudoClass)=           (void) memcpy(rotate_image->indexes,image->indexes, 0             image->columns*sizeof(IndexPacket));>         (void) memcpy(q,p,image->columns*sizeof(PixelPacket));*         if (!SyncPixelCache(rotate_image))           break;'         if (QuantumTick(y,image->rows)) 9           ProgressMonitor(RotateImageText,y,image->rows);        }        break;     }      case 1:      {        /*         Rotate 90 degrees.       */+       for (y=0; y < (int) image->rows; y++)        { 4         p=GetPixelCache(image,0,y,image->columns,1);M         q=SetPixelCache(rotate_image,image->rows-y-1,0,1,rotate_image->rows); G         if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))            break;(         if (image->class == PseudoClass)=           (void) memcpy(rotate_image->indexes,image->indexes, 0             image->columns*sizeof(IndexPacket));>         (void) memcpy(q,p,image->columns*sizeof(PixelPacket));*         if (!SyncPixelCache(rotate_image))           break;'         if (QuantumTick(y,image->rows)) 9           ProgressMonitor(RotateImageText,y,image->rows);        }        break;     }      case 2:      {        /*         Rotate 180 degrees.        */+       for (y=0; y < (int) image->rows; y++)        { 4         p=GetPixelCache(image,0,y,image->columns,1);I         q=SetPixelCache(rotate_image,0,image->rows-y-1,image->columns,1); G         if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))            break;         q+=image->columns;0         for (x=0; x < (int) image->columns; x++)           *--q=(*p++);(         if (image->class == PseudoClass)2           for (x=0; x < (int) image->columns; x++)H             rotate_image->indexes[image->columns-x-1]=image->indexes[x];*         if (!SyncPixelCache(rotate_image))           break;'         if (QuantumTick(y,image->rows)) 9           ProgressMonitor(RotateImageText,y,image->rows);        }        break;     }      case 3:      {        /*         Rotate 270 degrees.        */+       for (y=0; y < (int) image->rows; y++)        { 4         p=GetPixelCache(image,0,y,image->columns,1);?         q=SetPixelCache(rotate_image,y,0,1,rotate_image->rows); G         if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))            break;         q+=image->columns;0         for (x=0; x < (int) image->columns; x++)           *--q=(*p++);(         if (image->class == PseudoClass)2           for (x=0; x < (int) image->columns; x++)H             rotate_image->indexes[image->columns-x-1]=image->indexes[x];*         if (!SyncPixelCache(rotate_image))           break;'         if (QuantumTick(y,image->rows)) 9           ProgressMonitor(RotateImageText,y,image->rows);        }        break;     }    }    return(rotate_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X S h e a r I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Procedure XShearImage shears the image in the X direction with a shear angle L %  of 'degrees'.  Positive angles shear counter-clockwise (right-hand rule),J %  and negative angles shear clockwise.  Angles are measured relative to aL %  vertical Y-axis.  X shears will widen an image creating 'empty' triangles3 %  on the left and right sides of the source image.  % + %  The format of the XShearImage method is:  % : %      void XShearImage(Image *image,const double degrees,O %        const unsigned int width,const unsigned int height,const int x_offset, 4 %        int y_offset,register Quantum *range_limit) % + %  A description of each parameter follows.  % 7 %    o image: The address of a structure of type Image.  % J %    o degrees: A double representing the shearing angle along the X axis. % G %    o width, height, x_offset, y_offset: Defines a region of the image  %      to shear. %  */: static void XShearImage(Image *image,const double degrees,H   const unsigned int width,const unsigned int height,const int x_offset,-   int y_offset,register Quantum *range_limit)  { / #define XShearImageText  "  X Shear image...  "      double     displacement;      enum {LEFT,RIGHT}      direction;     int 	     step,      y;     long     opacity;     register PixelPacket     *p,      *q;      register int     i;  
   PixelPacket 
     pixel;  "   assert(image != (Image *) NULL);
   y_offset--; "   for (y=0; y < (int) height; y++)   {      y_offset++; (     displacement=degrees*(y-height/2.0);     if (displacement == 0.0)       continue;      if (displacement > 0.0)        direction=RIGHT;     else       {          displacement*=(-1.0);          direction=LEFT;        } #     step=(int) floor(displacement); '     opacity=MaxRGB*(displacement-step);      if (opacity == 0)        { 
         /*1           No fractional displacement-- just copy. 
         */         switch (direction)	         {            case LEFT:           {              /*,               Transfer pixels left-to-right.             */?             p=GetPixelCache(image,0,y_offset,image->columns,1); *             if (p == (PixelPacket *) NULL)               break;             p+=x_offset;             q=p-step; 9             (void) memcpy(q,p,width*sizeof(PixelPacket));              /**               Set old row to border color.             */             q+=width; *             for (i=0; i < (int) step; i++)'               *q++=image->border_color;              break;           }            case RIGHT:            {              /*,               Transfer pixels right-to-left.             */?             p=GetPixelCache(image,0,y_offset,image->columns,1); *             if (p == (PixelPacket *) NULL)               break;             p+=x_offset+width;             q=p+step; +             for (i=0; i < (int) width; i++)                *--q=(*--p);             /**               Set old row to border color.             */*             for (i=0; i < (int) step; i++)'               *--q=image->border_color;              break;           } 	         } #         if (!SyncPixelCache(image))            break;         continue;        }      /*       Fractional displacement.     */     step++;      pixel=image->border_color;     switch (direction)     {        case LEFT:       { 
         /*(           Transfer pixels left-to-right.
         */;         p=GetPixelCache(image,0,y_offset,image->columns,1); &         if (p == (PixelPacket *) NULL)           break;         p+=x_offset;         q=p-step; '         for (i=0; i < (int) width; i++) 	         { "           if ((x_offset+i) < step)
             {                p++;               q++;               continue; 
             } @           q->red=range_limit[(unsigned long) (pixel.red*(MaxRGB-.              opacity)+p->red*opacity)/MaxRGB];D           q->green=range_limit[(unsigned long) (pixel.green*(MaxRGB-0              opacity)+p->green*opacity)/MaxRGB];B           q->blue=range_limit[(unsigned long) (pixel.blue*(MaxRGB-/              opacity)+p->blue*opacity)/MaxRGB]; H           q->opacity=range_limit[(unsigned long) (pixel.opacity*(MaxRGB-1             opacity)+p->opacity*opacity)/MaxRGB];            pixel=(*p);            p++;           q++;	         } 
         /*&           Set old row to border color.
         */>         q->red=range_limit[(unsigned long) (pixel.red*(MaxRGB-<           opacity)+image->border_color.red*opacity)/MaxRGB];B         q->green=range_limit[(unsigned long) (pixel.green*(MaxRGB->           opacity)+image->border_color.green*opacity)/MaxRGB];@         q->blue=range_limit[(unsigned long) (pixel.blue*(MaxRGB-=           opacity)+image->border_color.blue*opacity)/MaxRGB]; F         q->opacity=range_limit[(unsigned long) (pixel.opacity*(MaxRGB-@           opacity)+image->border_color.opacity*opacity)/MaxRGB];$         for (i=0; i < (step-1); i++)#           *++q=image->border_color;          break;       }        case RIGHT:        { 
         /*(           Transfer pixels right-to-left.
         */;         p=GetPixelCache(image,0,y_offset,image->columns,1); &         if (p == (PixelPacket *) NULL)           break;         p+=x_offset+width;         q=p+step; '         for (i=0; i < (int) width; i++) 	         {            p--;           q--;8           if ((x_offset+width+step-i) >= image->columns)             continue; @           q->red=range_limit[(unsigned long) (pixel.red*(MaxRGB--             opacity)+p->red*opacity)/MaxRGB]; D           q->green=range_limit[(unsigned long) (pixel.green*(MaxRGB-/             opacity)+p->green*opacity)/MaxRGB]; B           q->blue=range_limit[(unsigned long) (pixel.blue*(MaxRGB-.             opacity)+p->blue*opacity)/MaxRGB];H           q->opacity=range_limit[(unsigned long) (pixel.opacity*(MaxRGB-1             opacity)+p->opacity*opacity)/MaxRGB];            pixel=(*p); 	         } 
         /*&           Set old row to border color.
         */         q--;>         q->red=range_limit[(unsigned long) (pixel.red*(MaxRGB-<           opacity)+image->border_color.red*opacity)/MaxRGB];B         q->green=range_limit[(unsigned long) (pixel.green*(MaxRGB->           opacity)+image->border_color.green*opacity)/MaxRGB];@         q->blue=range_limit[(unsigned long) (pixel.blue*(MaxRGB-=           opacity)+image->border_color.blue*opacity)/MaxRGB]; F         q->opacity=range_limit[(unsigned long) (pixel.opacity*(MaxRGB-@           opacity)+image->border_color.opacity*opacity)/MaxRGB];$         for (i=0; i < (step-1); i++)#           *--q=image->border_color;          break;       }      }      if (!SyncPixelCache(image))        break;     if (QuantumTick(y,height))0       ProgressMonitor(XShearImageText,y,height);   }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   Y S h e a r I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Procedure YShearImage shears the image in the Y direction with a shear K %  angle of 'degrees'.  Positive angles shear counter-clockwise (right-hand L %  rule), and negative angles shear clockwise.  Angles are measured relativeI %  to a horizontal X-axis.  Y shears will increase the height of an image H %  creating 'empty' triangles on the top and bottom of the source image. % + %  The format of the YShearImage method is:  % : %      void YShearImage(Image *image,const double degrees,I %        const unsigned int width,const unsigned int height,int x_offset, : %        const int y_offset,register Quantum *range_limit) % + %  A description of each parameter follows.  % 7 %    o image: The address of a structure of type Image.  % J %    o degrees: A double representing the shearing angle along the Y axis. % G %    o width, height, x_offset, y_offset: Defines a region of the image  %      to shear. %  %  */: static void YShearImage(Image *image,const double degrees,B   const unsigned int width,const unsigned int height,int x_offset,3   const int y_offset,register Quantum *range_limit)  { / #define YShearImageText  "  Y Shear image...  "      double     displacement;      enum {UP,DOWN}     direction;     int 	     step,      y;     long     opacity;     register PixelPacket     *p,      *q;      register int     i;  
   PixelPacket 
     pixel;  "   assert(image != (Image *) NULL);
   x_offset--; !   for (y=0; y < (int) width; y++)    {      x_offset++; '     displacement=degrees*(y-width/2.0);      if (displacement == 0.0)       continue;      if (displacement > 0.0)        direction=DOWN;      else       {          displacement*=(-1.0);          direction=UP;        } #     step=(int) floor(displacement); '     opacity=MaxRGB*(displacement-step);      if (opacity == 0)        { 
         /*<           No fractional displacement-- just copy the pixels.
         */         switch (direction)	         {            case UP:           {              /*,               Transfer pixels top-to-bottom.             */<             p=GetPixelCache(image,x_offset,0,1,image->rows);*             if (p == (PixelPacket *) NULL)               break;             p+=y_offset;             q=p-step; :             (void) memcpy(q,p,height*sizeof(PixelPacket));             /*-               Set old column to border color.              */             q+=height;*             for (i=0; i < (int) step; i++)'               *q++=image->border_color;              break;           }            case DOWN:           {              /*,               Transfer pixels bottom-to-top.             */<             p=GetPixelCache(image,x_offset,0,1,image->rows);*             if (p == (PixelPacket *) NULL)               break;             p+=y_offset+height;              q=p+step; ,             for (i=0; i < (int) height; i++)               *--q=(*--p);             /*-               Set old column to border color.              */*             for (i=0; i < (int) step; i++)'               *--q=image->border_color;              break;           } 	         } #         if (!SyncPixelCache(image))            break;         continue;        }      /*       Fractional displacment.      */     step++;      pixel=image->border_color;     switch (direction)     {        case UP:       { 
         /*(           Transfer pixels top-to-bottom.
         */8         p=GetPixelCache(image,x_offset,0,1,image->rows);&         if (p == (PixelPacket *) NULL)           break;         p+=y_offset;         q=p-step; (         for (i=0; i < (int) height; i++)	         { @           q->red=range_limit[(unsigned long) (pixel.red*(MaxRGB--             opacity)+p->red*opacity)/MaxRGB]; D           q->green=range_limit[(unsigned long) (pixel.green*(MaxRGB-/             opacity)+p->green*opacity)/MaxRGB]; B           q->blue=range_limit[(unsigned long) (pixel.blue*(MaxRGB-.             opacity)+p->blue*opacity)/MaxRGB];H           q->opacity=range_limit[(unsigned long) (pixel.opacity*(MaxRGB-1             opacity)+p->opacity*opacity)/MaxRGB];            pixel=(*p);            p++;           q++;	         } 
         /*)           Set old column to border color. 
         */>         q->red=range_limit[(unsigned long) (pixel.red*(MaxRGB-<           opacity)+image->border_color.red*opacity)/MaxRGB];B         q->green=range_limit[(unsigned long) (pixel.green*(MaxRGB->           opacity)+image->border_color.green*opacity)/MaxRGB];@         q->blue=range_limit[(unsigned long) (pixel.blue*(MaxRGB-=           opacity)+image->border_color.blue*opacity)/MaxRGB]; F         q->opacity=range_limit[(unsigned long) (pixel.opacity*(MaxRGB-@           opacity)+image->border_color.opacity*opacity)/MaxRGB];$         for (i=0; i < (step-1); i++)#           *++q=image->border_color;          break;       }        case DOWN:       { 
         /*(           Transfer pixels bottom-to-top.
         */8         p=GetPixelCache(image,x_offset,0,1,image->rows);&         if (p == (PixelPacket *) NULL)           break;         p+=y_offset+height;          q=p+step; (         for (i=0; i < (int) height; i++)	         {            p--;           q--;6           if ((y_offset+height+step-i) >= image->rows)             continue; @           q->red=range_limit[(unsigned long) (pixel.red*(MaxRGB--             opacity)+p->red*opacity)/MaxRGB]; D           q->green=range_limit[(unsigned long) (pixel.green*(MaxRGB-/             opacity)+p->green*opacity)/MaxRGB]; B           q->blue=range_limit[(unsigned long) (pixel.blue*(MaxRGB-.             opacity)+p->blue*opacity)/MaxRGB];H           q->opacity=range_limit[(unsigned long) (pixel.opacity*(MaxRGB-1             opacity)+p->opacity*opacity)/MaxRGB];            pixel=(*p); 	         } 
         /*)           Set old column to border color. 
         */         q--;>         q->red=range_limit[(unsigned long) (pixel.red*(MaxRGB-<           opacity)+image->border_color.red*opacity)/MaxRGB];B         q->green=range_limit[(unsigned long) (pixel.green*(MaxRGB->           opacity)+image->border_color.green*opacity)/MaxRGB];@         q->blue=range_limit[(unsigned long) (pixel.blue*(MaxRGB-=           opacity)+image->border_color.blue*opacity)/MaxRGB]; F         q->opacity=range_limit[(unsigned long) (pixel.opacity*(MaxRGB-@           opacity)+image->border_color.opacity*opacity)/MaxRGB];$         for (i=0; i < (step-1); i++)#           *--q=image->border_color;          break;       }      }      if (!SyncPixelCache(image))        break;     if (QuantumTick(y,width)) /       ProgressMonitor(YShearImageText,y,width);    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R o t a t e I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method RotateImage creates a new image that is a rotated copy of anM %  existing one.  Positive angles rotate counter-clockwise (right-hand rule), M %  while negative angles rotate clockwise.  Rotated images are usually larger J %  than the originals and have 'empty' triangular corners.  X axis.  EmptyH %  triangles left over from shearing the image are filled with the colorL %  defined by the pixel at location (0,0).  RotateImage allocates the memoryI %  necessary for the new Image structure and returns a pointer to the new 	 %  image.  % I %  Method RotateImage is based on the paper "A Fast Algorithm for General N %  Raster Rotatation" by Alan W. Paeth.  RotateImage is adapted from a similarJ %  method based on the Paeth paper written by Michael Halle of the Spatial  %  Imaging Group, MIT Media Lab. % + %  The format of the RotateImage method is:  % < %      Image *RotateImage(Image *image,const double degrees) % + %  A description of each parameter follows.  % F %    o status: Method RotateImage returns a pointer to the image afterI %      rotating.  A null image is returned if there is a memory shortage.  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % D %    o degrees: Specifies the number of degrees to rotate the image. %  %  */< Export Image *RotateImage(Image *image,const double degrees) {    double
     angle;     Image      *integral_image,     *rotate_image;     int 
     x_offset, 
     y_offset;      PointInfo 
     shear;  	   Quantum      *range_limit,      *range_table;      RectangleInfo      border_info;     register int     i;     unsigned int     height,      rotations,
     width,     y_width;     /*     Adjust rotation angle.   */"   assert(image != (Image *) NULL);   angle=degrees;   while (angle < -45.0)      angle+=360.0; .   for (rotations=0; angle > 45.0; rotations++)     angle-=90.0;   rotations%=4;    /*     Calculate shear equations.   */6   integral_image=IntegralRotateImage(image,rotations);'   if (integral_image == (Image *) NULL)      { B       MagickWarning(ResourceLimitWarning,"Unable to rotate image",$         "Memory allocation failed");       return((Image *) NULL);      } .   shear.x=(-tan(DegreesToRadians(angle)/2.0));'   shear.y=sin(DegreesToRadians(angle)); +   if ((shear.x == 0.0) || (shear.y == 0.0))      return(integral_image);    /*     Initialize range table.    */G   range_table=(Quantum *) AllocateMemory(3*(MaxRGB+1)*sizeof(Quantum)); &   if (range_table == (Quantum *) NULL)     { #       DestroyImage(integral_image); B       MagickWarning(ResourceLimitWarning,"Unable to rotate image",$         "Memory allocation failed");       return((Image *) NULL);      }    for (i=0; i <= MaxRGB; i++)    {      range_table[i]=0; *     range_table[i+(MaxRGB+1)]=(Quantum) i;'     range_table[i+(MaxRGB+1)*2]=MaxRGB;    } %   range_limit=range_table+(MaxRGB+1);    /*     Compute image size.    */   width=image->columns;    height=image->rows; +   if ((rotations == 1) || (rotations == 3))      {        width=image->rows;       height=image->columns;     } +   y_width=width+ceil(height*fabs(shear.x)); 6   x_offset=width+2.0*ceil(height*fabs(shear.y))-width;5   y_offset=height+ceil(y_width*fabs(shear.y))-height;    /*!     Surround image with a border.    */   if (!integral_image->matte) &     MatteImage(integral_image,Opaque);   border_info.width=x_offset;    border_info.height=y_offset;8   rotate_image=BorderImage(integral_image,&border_info);   DestroyImage(integral_image); %   if (rotate_image == (Image *) NULL)      { B       MagickWarning(ResourceLimitWarning,"Unable to rotate image",$         "Memory allocation failed");       return((Image *) NULL);      } "   rotate_image->class=DirectClass;   /*     Rotate the image.    */9   XShearImage(rotate_image,shear.x,width,height,x_offset, 1     (rotate_image->rows-height+1)/2,range_limit); 2   YShearImage(rotate_image,shear.y,y_width,height,>     (rotate_image->columns-y_width+1)/2,y_offset,range_limit);>   XShearImage(rotate_image,shear.x,y_width,rotate_image->rows,7     (rotate_image->columns-y_width+1)/2,0,range_limit); 4   TransformImage(&rotate_image,"0x0",(char *) NULL);   FreeMemory(range_table);   return(rotate_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S h e a r I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method ShearImage creates a new image that is a shear_image copy of an G %  existing one.  Shearing slides one edge of an image along the X or Y G %  axis, creating a parallelogram.  An X direction shear slides an edge I %  along the X axis, while a Y direction shear slides an edge along the Y H %  axis.  The amount of the shear is controlled by a shear angle.  For XD %  direction shears, x_shear is measured relative to the Y axis, andH %  similarly, for Y direction shears y_shear is measured relative to theH %  X axis.  Empty triangles left over from shearing the image are filledE %  with the color defined by the pixel at location (0,0).  ShearImage I %  allocates the memory necessary for the new Image structure and returns  %  a pointer to the new image. % H %  Method ShearImage is based on the paper "A Fast Algorithm for General' %  Raster Rotatation" by Alan W. Paeth.  % * %  The format of the ShearImage method is: % P %      Image *ShearImage(Image *image,const double x_shear,const double y_shear) % + %  A description of each parameter follows.  % E %    o status: Method ShearImage returns a pointer to the image after I %      rotating.  A null image is returned if there is a memory shortage.  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o x_shear, y_shear: Specifies the number of degrees to shear the image. %  %  */P Export Image *ShearImage(Image *image,const double x_shear,const double y_shear) {    Image      *integral_image,     *shear_image;      int 
     x_offset, 
     y_offset;      PointInfo 
     shear;  	   Quantum      *range_limit,      *range_table;      RectangleInfo      border_info;     register int     i;     unsigned int     y_width;  "   assert(image != (Image *) NULL);/   if ((x_shear == 180.0) || (y_shear == 180.0))      { :       MagickWarning(OptionWarning,"Unable to shear image","         "angle is discontinuous");       return((Image *) NULL);      }    /*     Initialize shear angle.    */.   integral_image=IntegralRotateImage(image,0);'   if (integral_image == (Image *) NULL)      { A       MagickWarning(ResourceLimitWarning,"Unable to shear image", $         "Memory allocation failed");       return((Image *) NULL);      } 0   shear.x=(-tan(DegreesToRadians(x_shear)/2.0));)   shear.y=sin(DegreesToRadians(y_shear)); +   if ((shear.x == 0.0) || (shear.y == 0.0))      return(integral_image);    /*     Initialize range table.    */G   range_table=(Quantum *) AllocateMemory(3*(MaxRGB+1)*sizeof(Quantum)); &   if (range_table == (Quantum *) NULL)     { A       MagickWarning(ResourceLimitWarning,"Unable to shear image", $         "Memory allocation failed");       return((Image *) NULL);      }    for (i=0; i <= MaxRGB; i++)    {      range_table[i]=0; *     range_table[i+(MaxRGB+1)]=(Quantum) i;'     range_table[i+(MaxRGB+1)*2]=MaxRGB;    } %   range_limit=range_table+(MaxRGB+1);    /*     Compute image size.    */9   y_width=image->columns+ceil(image->rows*fabs(shear.x)); K   x_offset=image->columns+ceil(2*image->rows*fabs(shear.y))-image->columns; ?   y_offset=image->rows+ceil(y_width*fabs(shear.y))-image->rows;    /*     Surround image with border.    */   if (!integral_image->matte) &     MatteImage(integral_image,Opaque);   border_info.width=x_offset;    border_info.height=y_offset;7   shear_image=BorderImage(integral_image,&border_info); $   if (shear_image == (Image *) NULL)     { A       MagickWarning(ResourceLimitWarning,"Unable to shear image", $         "Memory allocation failed");       return((Image *) NULL);      }    DestroyImage(integral_image); !   shear_image->class=DirectClass;    /*     Shear the image.   */F   XShearImage(shear_image,shear.x,image->columns,image->rows,x_offset,5     (shear_image->rows-image->rows+1)/2,range_limit); 6   YShearImage(shear_image,shear.y,y_width,image->rows,=     (shear_image->columns-y_width+1)/2,y_offset,range_limit); 3   TransformImage(&shear_image,"0x0",(char *) NULL);    FreeMemory(range_table);   return(shear_image); } 