 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %              SSSSS  TTTTT  EEEEE   GGGG   AAA   N   N   OOO                 % O %              SS       T    E      G      A   A  NN  N  O   O                % O %               SSS     T    EEE    G  GG  AAAAA  N N N  O   O                % O %                 SS    T    E      G   G  A   A  N  NN  O   O                % O %              SSSSS    T    EEEEE   GGG   A   A  N   N   OOO                 % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d S T E G A N O I m a g e                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method ReadSTEGANOImage reads a steganographic image hidden within another M %  image type.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % 0 %  The format of the ReadSTEGANOImage method is: % ; %      Image *ReadSTEGANOImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % E %    o image:  Method ReadSTEGANOImage returns a pointer to the image M %      after reading.  A null image is returned if there is a memory shortage & %      of if the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */; Export Image *ReadSTEGANOImage(const ImageInfo *image_info)  {  #define UnembedBit(byte) \ { \ F   if (!GetPixelCache(image,j % image->columns,j/image->columns,1,1)) \     break; \0   (*image->indexes)|=((byte) & 0x01) << shift; \!   (void) SyncPixelCache(image); \    j++; \*   if (j == (image->columns*image->rows)) \     { \        j=0; \       shift--; \       if (shift < 0) \         break; \     } \  }      ImageInfo      *local_info;     int      j,
     shift,     y;     register int     i,     x;     register PixelPacket     *p;      Image      *cloned_image,     *image,      *stegano_image;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL); 2   if ((image->columns == 0) || (image->rows == 0))>     ReaderExit(OptionWarning,"Must specify image size",image);   /*     Initialize Image structure.    */(   local_info=CloneImageInfo(image_info);'   if (local_info == (ImageInfo *) NULL) F     ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);   *local_info->magick='\0'; &   stegano_image=ReadImage(local_info);   DestroyImageInfo(local_info); &   if (stegano_image == (Image *) NULL)     return((Image *) NULL); I   cloned_image=CloneImage(stegano_image,image->columns,image->rows,True);    DestroyImage(image);%   if (cloned_image == (Image *) NULL) N     ReaderExit(ResourceLimitWarning,"Memory allocation failed",stegano_image);   image=cloned_image;    image->class=PseudoClass; "   image->colors=1 << QuantumDepth;!   image->colormap=(PixelPacket *) 6     AllocateMemory(image->colors*sizeof(PixelPacket));.   if (image->colormap == (PixelPacket *) NULL)F     ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);)   for (i=0; i < (int) image->colors; i++)    { $     image->colormap[i].red=(Quantum)5       ((unsigned long) (MaxRGB*i)/(image->colors-1)); &     image->colormap[i].green=(Quantum)5       ((unsigned long) (MaxRGB*i)/(image->colors-1)); %     image->colormap[i].blue=(Quantum) 5       ((unsigned long) (MaxRGB*i)/(image->colors-1));    }    /*     Grab embedded watermark.   */   i=image->offset;   j=0;   shift=image->depth-1; /   for (y=0; y < (int) stegano_image->rows; y++)    { 4     for (x=0; x < (int) stegano_image->columns; x++)     { <       if (i == (stegano_image->columns*stegano_image->rows))         i=0;?       p=GetPixelCache(stegano_image,i % stegano_image->columns, &         i/stegano_image->columns,1,1);$       if (p == (PixelPacket *) NULL)         break;.       if (stegano_image->class == PseudoClass)+         UnembedBit(*stegano_image->indexes) 
       else	         { 1           UnembedBit(stegano_image->pixels->red); 3           UnembedBit(stegano_image->pixels->green); 2           UnembedBit(stegano_image->pixels->blue);	         } 
       i++;     }      if (shift < 0)       break;+     if (QuantumTick(y,stegano_image->rows)) ;       ProgressMonitor(LoadImageText,y,stegano_image->rows);    }    SyncImage(image);    DestroyImage(stegano_image);   return(image); } 