 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                    TTTTT  IIIII  M   M  EEEEE  RRRR                         % O %                      T      I    MM MM  E      R   R                        % O %                      T      I    M M M  EEE    RRRR                         % O %                      T      I    M   M  E      R R                          % O %                      T    IIIII  M   M  EEEEE  R  R                         % O %                                                                             % O %                                                                             % O %                        ImageMagick Timing Methods                           % O %                                                                             % O %                                                                             % O %                             Software Design                                 % O %                               John Cristy                                   % O %                              January 1993                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 5 %  Contributed by Bill Radcliffe and Bob Friesenhahn.  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"  ; #if !defined(vms) && !defined(macintosh) && !defined(WIN32)  #include <sys/times.h> #include <limits.h>  #endif #if defined(macintosh) #define CLK_TCK  CLOCKS_PER_SEC  #endif #if defined(WIN32) #include "nt.h"  #endif #if !defined(CLK_TCK) % #define CLK_TCK  sysconf(_SC_CLK_TCK)  #endif   /*   Forward declarations.  */
 static double    UserTime(void);    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o n t i n u e T i m e r                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method ContinueTimer resumes a stopped stopwatch. The stopwatch continues/ %  counting from the last StartTimer() onwards.  % - %  The format of the ContinueTimer method is:  % 7 %      unsigned int ContinueTimer(TimerInfo *time_info)  % + %  A description of each parameter follows.  % - %    o  time_info: Time statistics structure.  %  */7 Export unsigned int ContinueTimer(TimerInfo *time_info)  { .   if (time_info->state == UndefinedTimerState)     return(False);,   if (time_info->state == StoppedTimerState)     { H       time_info->user.total-=time_info->user.stop-time_info->user.start;        time_info->elapsed.total-=9         time_info->elapsed.stop-time_info->elapsed.start;      } %   time_info->state=RunningTimerState;    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   E l a p s e d T i m e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method ElapsedTime returns the elapsed time (in seconds) since the last %  call to StartTimer(). % + %  The format of the ElapsedTime method is:  %  %      double ElapsedTime()  %  */ static double ElapsedTime(void)  { ; #if !defined(vms) && !defined(macintosh) && !defined(WIN32)    struct tms
     timer;  )   return((double) times(&timer)/CLK_TCK);  #endif #if defined(vms)#   return((double) clock()/CLK_TCK);  #endif #if defined(macintosh)#   return((double) clock()/CLK_TCK);  #endif #if defined(WIN32)   union    {      FILETIME       filetime;        __int64        filetime64;    } elapsed_time;      SYSTEMTIME     system_time;     GetSystemTime(&system_time);<   SystemTimeToFileTime(&system_time,&elapsed_time.filetime);2   return((double) 1.0e-7*elapsed_time.filetime64); #endif }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t E l a p s e d T i m e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method GetElapsedTime returns the elapsed time (in seconds) passed between N %  the start and stop events. If the stopwatch is still running, it is stopped	 %  first.  % . %  The format of the GetElapsedTime method is: % 2 %      double GetElapsedTime(TimerInfo *time_info) % + %  A description of each parameter follows.  % . %    o  time_info: Timer statistics structure. %  */2 Export double GetElapsedTime(TimerInfo *time_info) { .   if (time_info->state == UndefinedTimerState)     return(0.0);,   if (time_info->state == RunningTimerState)     StopTimer(time_info); #   return(time_info->elapsed.total);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t T i m e r I n f o                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ; %  Method GetTimerInfo initializes the TimerInfo structure.  % , %  The format of the GetTimerInfo method is: % . %      void GetTimerInfo(TimerInfo *time_info) % + %  A description of each parameter follows.  % . %    o  time_info: Timer statistics structure. %  */. Export void GetTimerInfo(TimerInfo *time_info) {    /*$     Create a stopwatch and start it.   */'   time_info->state=UndefinedTimerState;    time_info->user.total=0;   time_info->elapsed.total=0;    StartTimer(time_info,True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t U s e r T i m e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Method GetUserTime returns the User time (user and system) by the operatingM %  system (in seconds) between the start and stop events. If the stopwatch is & %  still running, it is stopped first. % + %  The format of the GetUserTime method is:  % / %      double GetUserTime(TimerInfo *time_info)  % + %  A description of each parameter follows.  % . %    o  time_info: Timer statistics structure. %  *// Export double GetUserTime(TimerInfo *time_info)  { .   if (time_info->state == UndefinedTimerState)     return(0.0);,   if (time_info->state == RunningTimerState)     StopTimer(time_info);     return(time_info->user.total); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e s e t T i m e r                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % * %  Method ResetTimer resets the stopwatch. % * %  The format of the ResetTimer method is: % , %      void ResetTimer(TimerInfo *time_info) % + %  A description of each parameter follows.  % . %    o  time_info: Timer statistics structure. %  */, Export void ResetTimer(TimerInfo *time_info) {    StopTimer(time_info);    time_info->elapsed.stop=0.0;   time_info->user.stop=0.0;    }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S t a r t T i m e r                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % * %  Method StartTimer starts the stopwatch. % * %  The format of the StartTimer method is: % E %      void StartTimer(TimerInfo *time_info,const unsigned int reset)  % + %  A description of each parameter follows.  % . %    o  time_info: Timer statistics structure. % O %    o  reset: If reset is True, then the stopwatch is reset prior to starting. I %       If reset is False, then timing is continued without resetting the  %       stopwatch. %  */F Export void StartTimer(TimerInfo *time_info, const unsigned int reset) {    if (reset)     {        /*/         Reset the stopwatch before starting it.        */       time_info->user.total=0;!       time_info->elapsed.total=0;      } ,   if (time_info->state != RunningTimerState)     { -       time_info->elapsed.start=ElapsedTime(); '       time_info->user.start=UserTime();      } %   time_info->state=RunningTimerState;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S t o p T i m e r                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ( %  Method StopTimer stops the stopwatch. % ) %  The format of the StopTimer method is:  % + %      void StopTimer(TimerInfo *time_info)  % + %  A description of each parameter follows.  % . %    o  time_info: Timer statistics structure. %  */+ Export void StopTimer(TimerInfo *time_info)  { (   time_info->elapsed.stop=ElapsedTime();"   time_info->user.stop=UserTime();,   if (time_info->state == RunningTimerState)     { H       time_info->user.total+=time_info->user.stop-time_info->user.start;        time_info->elapsed.total+=9         time_info->elapsed.stop-time_info->elapsed.start;      } %   time_info->state=StoppedTimerState;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   U s e r T i m e                                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method UserTime returns the total time the process has been scheduled (in0 %  seconds) since the last call to StartTimer(). % ( %  The format of the UserTime method is: %  %      double UserTime() %  */ static double UserTime(void) { ; #if !defined(vms) && !defined(macintosh) && !defined(WIN32)    struct tms
     timer;     times(&timer);=   return((double) (timer.tms_utime+timer.tms_stime)/CLK_TCK);  #endif #if defined(vms)#   return((double) clock()/CLK_TCK);  #endif #if defined(macintosh)#   return((double) clock()/CLK_TCK);  #endif #if defined(WIN32)   DWORD      status;   
   FILETIME     create_time,     exit_time;     OSVERSIONINFO      OsVersionInfo;     union    {      FILETIME       filetime;        __int64        filetime64;    } kernel_time;     union    {      FILETIME       filetime;        __int64        filetime64;    } user_time;  :   OsVersionInfo.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);   GetVersionEx(&OsVersionInfo); :   if (OsVersionInfo.dwPlatformId != VER_PLATFORM_WIN32_NT)     return(ElapsedTime());E   status=GetProcessTimes(GetCurrentProcess(),&create_time,&exit_time, /     &kernel_time.filetime,&user_time.filetime);    if (status != TRUE)      return(0.0);H   return((double) 1.0e-7*(kernel_time.filetime64+user_time.filetime64)); #endif } 