 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            TTTTT  X   X  TTTTT                              % O %                              T     X X     T                                % O %                              T      X      T                                % O %                              T     X X     T                                % O %                              T    X   X    T                                % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d T X T I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method ReadTXTImage reads a text file and returns it as an image.  ItK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % , %  The format of the ReadTXTImage method is: % 7 %      Image *ReadTXTImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadTXTImage returns a pointer to the image after L %      reading. A null image is returned if there is a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadTXTImage(const ImageInfo *image_info)  {    AnnotateInfo     *annotate_info;      char     filename[MaxTextExtent],     geometry[MaxTextExtent],     text[MaxTextExtent];     double     dx_resolution,     dy_resolution;     Image      *image, 
     *texture;      int 
     count,     offset;      RectangleInfo      page_info;     register char      *p;      unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*     Set the page geometry.   */   dx_resolution=72.0;    dy_resolution=72.0; C   if ((image->x_resolution == 0.0) || (image->y_resolution == 0.0))      { 
       char         density[MaxTextExtent];   /       (void) strcpy(density,PSDensityGeometry); P       count=sscanf(density,"%lfx%lf",&image->x_resolution,&image->y_resolution);       if (count != 2) 0         image->y_resolution=image->x_resolution;     }    page_info.width=612;   page_info.height=792;    page_info.x=0;   page_info.y=0;F   (void) ParseImageGeometry("612x792+43+43",&page_info.x,&page_info.y,(     &page_info.width,&page_info.height);(   if (image_info->page != (char *) NULL)I     (void) ParseImageGeometry(image_info->page,&page_info.x,&page_info.y, *       &page_info.width,&page_info.height);   /*     Initialize Image structure.    */   image->columns=(unsigned int) @     (((page_info.width*image->x_resolution)/dx_resolution)+0.5);   image->rows=(unsigned int)A     (((page_info.height*image->y_resolution)/dy_resolution)+0.5); @   (void) QueryColorDatabase("#c0c0c0",&image->background_color);   texture=(Image *) NULL; +   if (image_info->texture != (char *) NULL)      {        ImageInfo          *local_info;  ,       local_info=CloneImageInfo(image_info);+       if (local_info == (ImageInfo *) NULL)          return((Image *) NULL); >       (void) strcpy(local_info->filename,image_info->texture);$       texture=ReadImage(local_info);$       if (texture != (Image *) NULL)$         TextureImage(image,texture);#       DestroyImageInfo(local_info);      }    /*     Annotate the text image.   */   SetImage(image);   annotate_info=F     CloneAnnotateInfo((ImageInfo *) image_info,(AnnotateInfo *) NULL);/   (void) strcpy(filename,image_info->filename);    offset=0; 
   for ( ; ; )    {      /*       Annotate image with text.      */      p=GetStringBlob(image,text);     if (p == (char *) NULL)        break;2     (void) CloneString(&annotate_info->text,text);C     FormatString(geometry,"%+d%+d",page_info.x,page_info.y+offset); :     (void) CloneString(&annotate_info->geometry,geometry);'     AnnotateImage(image,annotate_info); )     offset+=annotate_info->bounds.height; *     if (image->previous == (Image *) NULL)6       if (QuantumTick(page_info.y+offset,image->rows))F         ProgressMonitor(LoadImageText,page_info.y+offset,image->rows);L     if (((2*page_info.y)+offset+annotate_info->bounds.height) < image->rows)       continue;      /*3       Page is full-- allocate next image structure.      */B     image->next=CloneImage(image,image->columns,image->rows,True);&     if (image->next == (Image *) NULL)       { +         DestroyAnnotateInfo(annotate_info); F         MagickWarning(ResourceLimitWarning,"Unable to annotate image",&           "Memory allocation failed");         break;       } 2     (void) strcpy(image->next->filename,filename);,     image->next->blob_info=image->blob_info;"     image->next->file=image->file;*     image->next->filesize=image->filesize;&     image->next->scene=image->scene+1;      image->next->previous=image;      (void) IsPseudoClass(image);     image=image->next;B     ProgressMonitor(LoadImagesText,(unsigned int) TellBlob(image),&       (unsigned int) image->filesize);     /*0       Initialize text image to background color.     */"     if (texture != (Image *) NULL)       {          MonitorHandler           handler;  9         handler=SetMonitorHandler((MonitorHandler) NULL); $         TextureImage(image,texture);*         (void) SetMonitorHandler(handler);       } 
     offset=0;    }     if (texture != (Image *) NULL)     DestroyImage(texture);%   DestroyAnnotateInfo(annotate_info);    (void) IsPseudoClass(image);+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseBlob(image);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e T X T I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % @ %  Method WriteTXTImage writes the pixel values as text numbers. % - %  The format of the WriteTXTImage method is:  % K %      unsigned int WriteTXTImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % H %    o status: Method WriteTXTImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K Export unsigned int WriteTXTImage(const ImageInfo *image_info,Image *image)  {    char     buffer[MaxTextExtent];     int      y;     register int     x;     register PixelPacket     *p;      unsigned int
     scene,     status;      /*     Open output image file.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);
   scene=0;   do   {      /*(       Convert MIFF to TXT raster pixels.     */+     TransformRGBImage(image,RGBColorspace); )     for (y=0; y < (int) image->rows; y++)      { 2       p=GetPixelCache(image,0,y,image->columns,1);$       if (p == (PixelPacket *) NULL)         break;.       for (x=0; x < (int) image->columns; x++)       {          if (image->matte)            { =             (void) sprintf(buffer,"%d,%d: %d,%d,%d,%d\n",x,y, 2               p->red,p->green,p->blue,p->opacity);:             (void) WriteBlob(image,strlen(buffer),buffer);           }          else           { :             (void) sprintf(buffer,"%d,%d: %d,%d,%d  ",x,y,'               p->red,p->green,p->blue); :             (void) WriteBlob(image,strlen(buffer),buffer);J             (void) sprintf(buffer,HexColorFormat,p->red,p->green,p->blue);:             (void) WriteBlob(image,strlen(buffer),buffer);           } %         (void) WriteByte(image,'\n');          x++;&         if (x == (int) image->columns)           { 2             if (image->previous == (Image *) NULL)-               if (QuantumTick(y,image->rows)) =                 ProgressMonitor(SaveImageText,y,image->rows);              x=0;             y++;           }        } 
       p++;     } &     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;C     ProgressMonitor(SaveImagesText,scene++,GetNumberScenes(image));    } while (image_info->adjoin);    if (image_info->adjoin) -     while (image->previous != (Image *) NULL)        image=image->previous;   CloseBlob(image);    return(True);  } 