 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                     V   V  IIIII   CCCC   AAA   RRRR                        % O %                     V   V    I    C      A   A  R   R                       % O %                     V   V    I    C      AAAAA  RRRR                        % O %                      V V     I    C      A   A  R R                         % O %                       V    IIIII   CCCC  A   A  R  R                        % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s V I C A R                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method IsVICAR returns True if the image format type, identified by the %  magick string, is VICAR.  % . %  The format of the ReadVICARImage method is: % 8 %      unsigned int IsVICAR(const unsigned char *magick,# %        const unsigned int length)  % + %  A description of each parameter follows:  % N %    o status:  Method IsVICAR returns True if the image format type is VICAR. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */8 Export unsigned int IsVICAR(const unsigned char *magick,   const unsigned int length) {    if (length < 7)      return(False);0   if (strncmp((char *) magick,"LBLSIZE",7) == 0)     return(True); /   if (strncmp((char *) magick,"NJPL1I",6) == 0)      return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d V I C A R I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method ReadVICARImage reads a VICAR image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadVICARImage method is: % 9 %      Image *ReadVICARImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % H %    o image: Method ReadVICARImage returns a pointer to the image afterM %      reading.  A null image is returned if there is a memory shortage or if   %      the image cannot be read. % 9 %    o filename: Specifies the name of the image to read.  %  %  */9 Export Image *ReadVICARImage(const ImageInfo *image_info)  {    char     keyword[MaxTextExtent],      value[MaxTextExtent];      Image      *image;   
   IndexPacket 
     index;     int      c,     y;     long
     count;     register int     i,     x;     register PixelPacket     *q;      register unsigned char     *p;      unsigned char      *vicar_pixels;     unsigned int     header_length,     status,      value_expected;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*     Decode image header.   */   c=ReadByte(image);
   count=1;   if (c == EOF)      {        DestroyImage(image);       return((Image *) NULL);      }    header_length=0;;   while (isgraph(c) && ((image->columns*image->rows) == 0))    {      if (!isalnum(c))       {          c=ReadByte(image);         count++;       }      else       {          register char 
           *p;   
         /*,           Determine a keyword and its value.
         */         p=keyword;
         do	         { .           if ((p-keyword) < (MaxTextExtent-1))             *p++=(char) c;           c=ReadByte(image);           count++;+         } while (isalnum(c) || (c == '_'));          *p='\0';         value_expected=False; (         while (isspace(c) || (c == '='))	         {            if (c == '=')               value_expected=True;           c=ReadByte(image);           count++;	         } $         if (value_expected == False)           continue;          p=value;         while (isalnum(c))	         { ,           if ((p-value) < (MaxTextExtent-1))             *p++=(char) c;           c=ReadByte(image);           count++;	         }          *p='\0';
         /*2           Assign a value to the specified keyword.
         */8         if (Latin1Compare(keyword,"LABEL_RECORDS") == 0)3           header_length=(unsigned int) atoi(value); 2         if (Latin1Compare(keyword,"LBLSIZE") == 0)3           header_length=(unsigned int) atoi(value); 7         if (Latin1Compare(keyword,"RECORD_BYTES") == 0) 4           image->columns=(unsigned int) atoi(value);-         if (Latin1Compare(keyword,"NS") == 0) 4           image->columns=(unsigned int) atoi(value);0         if (Latin1Compare(keyword,"LINES") == 0)1           image->rows=(unsigned int) atoi(value); -         if (Latin1Compare(keyword,"NL") == 0) 1           image->rows=(unsigned int) atoi(value);        }      while (isspace(c))     {        c=ReadByte(image);       count++;     }    }    image->class=PseudoClass;    image->colors=256;   if (image_info->ping)      {        CloseBlob(image);        return(image);     }    /*      Read the rest of the header.   */%   while (count < (int) header_length)    {      c=ReadByte(image);     count++;   }    /*6     Verify that required image information is defined.   */(   if ((image->columns*image->rows) == 0)?     ReaderExit(CorruptImageWarning,"image size is zero",image);    /*     Create linear colormap.    */!   image->colormap=(PixelPacket *) 6     AllocateMemory(image->colors*sizeof(PixelPacket));.   if (image->colormap == (PixelPacket *) NULL)F     ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);)   for (i=0; i < (int) image->colors; i++)    { 0     image->colormap[i].red=(Quantum) UpScale(i);2     image->colormap[i].green=(Quantum) UpScale(i);1     image->colormap[i].blue=(Quantum) UpScale(i);    }    /*     Initialize image structure.    */    vicar_pixels=(unsigned char *)E     AllocateMemory(image->columns*image->rows*sizeof(unsigned char)); -   if (vicar_pixels == (unsigned char *) NULL) F     ReaderExit(CorruptImageWarning,"Unable to read image data",image);   /**     Convert VICAR pixels to pixel packets.   */J   status=ReadBlob(image,image->columns*image->rows,(char *) vicar_pixels);   if (status == False)L     ReaderExit(CorruptImageWarning,"Insufficient image data in file",image);   /**     Convert VICAR pixels to pixel packets.   */   p=vicar_pixels; '   for (y=0; y < (int) image->rows; y++)    { 0     q=SetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     {        index=(*p++);        image->indexes[x]=index;"       *q++=image->colormap[index];     }      if (!SyncPixelCache(image))        break;#     if (QuantumTick(y,image->rows)) 3       ProgressMonitor(LoadImageText,y,image->rows);    }    FreeMemory(vicar_pixels);    CloseBlob(image);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e V I C A R I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method WriteVICARImage writes an image in the VICAR rasterfile format. N %  Vicar files contain a text header, followed by one or more planes of binaryM %  grayscale image data.  Vicar files are designed to allow many planes to be J %  stacked together to form image cubes.  This method only writes a single %  grayscale plane.  % 4 %  Method WriteVICARImage was written contributed by %  gorelick@esther.la.asu.edu. % / %  The format of the WriteVICARImage method is:  % M %      unsigned int WriteVICARImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % J %    o status: Method WriteVICARImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */M Export unsigned int WriteVICARImage(const ImageInfo *image_info,Image *image)  {    char     buffer[MaxTextExtent],     header[MaxTextExtent],     label[16];     int      label_size,      y;     register int     i,     x;     register PixelPacket     *p;      register unsigned char     *q;      unsigned char      *pixels;     unsigned int     status;      /*     Open output image file.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);)   TransformRGBImage(image,RGBColorspace);    /*     Write header.    */I   FormatString(header,"LBLSIZE=            FORMAT='BYTE'  TYPE='IMAGE'"); F   FormatString(header+Extent(header),"  BUFSIZE=20000  DIM=2  EOL=0");%   FormatString(header+Extent(header), M     "  RECSIZE=%u  ORG='BSQ'  NL=%u  NS=%u  NB=1",image->columns,image->rows,      image->columns);%   FormatString(header+Extent(header), .     "  N1=0  N2=0  N3=0  N4=0  NBB=0  NLB=0");=   FormatString(header+Extent(header),"  TASK='ImageMagick'");    /*"     Compute the size of the label.   */M   label_size=(Extent(header)+image->columns-1)/image->columns*image->columns; &   FormatString(label,"%d",label_size);$   for (i=0 ; i < Extent(label); i++)     header[i+8]=label[i];    /*<     Print the header and enough spaces to pad to label size.   */3   (void) sprintf(buffer, "%-*s",label_size,header); 0   (void) WriteBlob(image,strlen(buffer),buffer);   /*     Allocate memory for pixels.    */   pixels=(unsigned char *)7     AllocateMemory(image->columns*sizeof(PixelPacket)); '   if (pixels == (unsigned char *) NULL) F     WriterExit(ResourceLimitWarning,"Memory allocation failed",image);   /*     Write VICAR pixels.    */'   for (y=0; y < (int) image->rows; y++)    { 0     p=GetPixelCache(image,0,y,image->columns,1);"     if (p == (PixelPacket *) NULL)       break;
     q=pixels; ,     for (x=0; x < (int) image->columns; x++)     { $       *q++=DownScale(Intensity(*p));
       p++;     } 5     (void) WriteBlob(image,q-pixels,(char *) pixels); *     if (image->previous == (Image *) NULL)%       if (QuantumTick(y,image->rows)) 5         ProgressMonitor(SaveImageText,y,image->rows);    }    FreeMemory(pixels);    CloseBlob(image);    return(True);  } 