 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            V   V  IIIII  DDDD                               % O %                            V   V    I    D   D                              % O %                            V   V    I    D   D                              % O %                             V V     I    D   D                              % O %                              V    IIIII  DDDD                               % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d V I D I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method ReadVIDImage reads one of more images and creates a Visual ImageG %  Directory file.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % , %  The format of the ReadVIDImage method is: % 7 %      Image *ReadVIDImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadVIDImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadVIDImage(const ImageInfo *image_info)  {  #define ClientName  "montage"      char     *commands[5],      **filelist,      **list;      Image      *image,      *montage_image,      *next_image;     ImageInfo      *local_info;     int      number_files;      MonitorHandler     handler;  
   MontageInfo      montage_info;      register int     i;     unsigned int     status;      /*     Expand the filename.   */0   list=(char **) AllocateMemory(sizeof(char *));   if (list == (char **) NULL)      { D       MagickWarning(ResourceLimitWarning,"Memory allocation failed",         (char *) NULL);        return((Image *) NULL);      } B   list[0]=(char *) AllocateMemory(Extent(image_info->filename)+1);   if (list[0] == (char *) NULL)      { D       MagickWarning(ResourceLimitWarning,"Memory allocation failed",         (char *) NULL);        return((Image *) NULL);      } .   (void) strcpy(list[0],image_info->filename);   number_files=1;    filelist=list;2   status=ExpandFilenames(&number_files,&filelist);/   if ((status == False) || (number_files == 0))      { C       MagickWarning(CorruptImageWarning,"unable to read VID image",          image_info->filename);       return((Image *) NULL);      }    /*/     Read each image and convert them to a tile.    */   image=(Image *) NULL; (   local_info=CloneImageInfo(image_info);'   if (local_info == (ImageInfo *) NULL)      return((Image *) NULL); <   (void) CloneString(&local_info->size,DefaultTileGeometry);+   commands[0]=SetClientName((char *) NULL);    commands[1]="-label"; (   commands[2]=(char *) DefaultTileLabel;   commands[3]="-geometry";+   commands[4]=(char *) DefaultTileGeometry; "   for (i=0; i < number_files; i++)   { 5     handler=SetMonitorHandler((MonitorHandler) NULL); 4     (void) strcpy(local_info->filename,filelist[i]);     *local_info->magick='\0'; %     next_image=ReadImage(local_info);      FreeMemory(filelist[i]);%     if (next_image != (Image *) NULL)        { 9         MogrifyImages(local_info,5,commands,&next_image); $         if (image == (Image *) NULL)           image=next_image;          else           { #             image->next=next_image; (             image->next->previous=image;             image=image->next;           }        } &     (void) SetMonitorHandler(handler);2     ProgressMonitor(LoadImageText,i,number_files);   }    DestroyImageInfo(local_info);    FreeMemory(filelist);    if (image == (Image *) NULL)     { C       MagickWarning(CorruptImageWarning,"unable to read VID image",          image_info->filename);       return((Image *) NULL);      } +   while (image->previous != (Image *) NULL)      image=image->previous;   /*&     Create the visual image directory.   */    GetMontageInfo(&montage_info);<   (void) strcpy(montage_info.filename,image_info->filename);:   (void) CloneString(&montage_info.font,image_info->font);/   montage_info.pointsize=image_info->pointsize; 3   montage_image=MontageImages(image,&montage_info); $   DestroyMontageInfo(&montage_info);&   if (montage_image == (Image *) NULL)     { C       MagickWarning(CorruptImageWarning,"unable to read VID image",          image_info->filename);       return((Image *) NULL);      }    DestroyImages(image);    FreeMemory(list[0]);   FreeMemory(list);    return(montage_image); } 