 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %                  W   W  IIIII  DDDD    GGGG  EEEEE  TTTTT                   % O %                  W   W    I    D   D  G      E        T                     % O %                  W W W    I    D   D  G  GG  EEE      T                     % O %                  WW WW    I    D   D  G   G  E        T                     % O %                  W   W  IIIII  DDDD    GGGG  EEEEE    T                     % O %                                                                             % O %                                                                             % O %                 X11 User Interface Methods for ImageMagick                  % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                              September 1993                                 % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   #if defined(HasX11)  #include "xwindows.h"  /*   Define declarations. */, #define AreaIsActive(matte_info,position)  \D   ((position.y >= (int) (matte_info.y-matte_info.bevel_width)) &&  \P    (position.y < (int) (matte_info.y+matte_info.height+matte_info.bevel_width)))- #define MatteIsActive(matte_info,position)  \ C   ((position.x >= (int) (matte_info.x-matte_info.bevel_width)) && \ D    (position.y >= (int) (matte_info.y-matte_info.bevel_width)) &&  \T    (position.x < (int) (matte_info.x+matte_info.width+matte_info.bevel_width)) &&  \P    (position.y < (int) (matte_info.y+matte_info.height+matte_info.bevel_width)))6 #define MaxTextWidth  (80*XTextWidth(font_info,"_",1))6 #define MinTextWidth  (26*XTextWidth(font_info,"_",1)); #define QuantumMargin   Max(font_info->max_bounds.width,12) / #define WindowIsActive(window_info,position)  \ /   ((position.x >= 0) && (position.y >= 0) &&  \ /    (position.x < (int) window_info.width) &&  \ +    (position.y < (int) window_info.height))    /*   Variable declarations. */ static XWidgetInfo   monitor_info =   { *     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,/     (char *) NULL, (char *) NULL, (char *) NULL    },   submenu_info =   { *     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,/     (char *) NULL, (char *) NULL, (char *) NULL    },   toggle_info =    { *     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,/     (char *) NULL, (char *) NULL, (char *) NULL    };   /*   Constant declarations. */ const unsigned int   BorderOffset = 4,    DoubleClick = 250;   /*   Method prototypes. */ static void @   XDrawMatte(Display *,const XWindowInfo *,const XWidgetInfo *),C   XSetBevelColor(Display *,const XWindowInfo *,const unsigned int), C   XSetMatteColor(Display *,const XWindowInfo *,const unsigned int), B   XSetTextColor(Display *,const XWindowInfo *,const unsigned int);   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X D r a w B e v e l                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Method XDrawBevel "sets off" an area with a highlighted upper andH %  left bevel and a shadowed lower and right bevel.  The highlighted and' %  shadowed bevels create a 3-D effect.  % , %  The format of the XDrawBevel function is: % 1 %      XDrawBevel(display,window_info,bevel_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % F %    o bevel_info: Specifies a pointer to a XWidgetInfo structure.  It) %      contains the extents of the bevel.  %  %  */G static void XDrawBevel(Display *display,const XWindowInfo *window_info,     const XWidgetInfo *bevel_info) {    int      x1,      x2,      y1,      y2;      unsigned int     bevel_width;     XPoint     points[6];     /*'     Draw upper and left beveled border.    */   x1=bevel_info->x; &   y1=bevel_info->y+bevel_info->height;%   x2=bevel_info->x+bevel_info->width;    y2=bevel_info->y; &   bevel_width=bevel_info->bevel_width;   points[0].x=x1;    points[0].y=y1;    points[1].x=x1;    points[1].y=y2;    points[2].x=x2;    points[2].y=y2;    points[3].x=x2+bevel_width;    points[3].y=y2-bevel_width;    points[4].x=x1-bevel_width;    points[4].y=y2-bevel_width;    points[5].x=x1-bevel_width;    points[5].y=y1+bevel_width; 9   XSetBevelColor(display,window_info,bevel_info->raised); L   XFillPolygon(display,window_info->id,window_info->widget_context,points,6,     Complex,CoordModeOrigin);    /*(     Draw lower and right beveled border.   */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y1;    points[2].x=x2;    points[2].y=y2;    points[3].x=x2+bevel_width;    points[3].y=y2-bevel_width;    points[4].x=x2+bevel_width;    points[4].y=y1+bevel_width;    points[5].x=x1-bevel_width;    points[5].y=y1+bevel_width; I   XSetBevelColor(display,window_info,(unsigned int) !bevel_info->raised); L   XFillPolygon(display,window_info->id,window_info->widget_context,points,6,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X D r a w B e v e l e d B u t t o n                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method XDrawBeveledButton draws a button with a highlighted upper andH %  left bevel and a shadowed lower and right bevel.  The highlighted and' %  shadowed bevels create a 3-D effect.  % 4 %  The format of the XDrawBeveledButton function is: % : %      XDrawBeveledButton(display,window_info,button_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % G %    o button_info: Specifies a pointer to a XWidgetInfo structure.  It * %      contains the extents of the button. %  %  */O static void XDrawBeveledButton(Display *display,const XWindowInfo *window_info, !   const XWidgetInfo *button_info)  {    int      x,     y;     unsigned int
     width;  
   XFontStruct      *font_info;      XRectangle     crop_info;     /*     Draw matte.    */.   XDrawBevel(display,window_info,button_info);:   XSetMatteColor(display,window_info,button_info->raised);E   XFillRectangle(display,window_info->id,window_info->widget_context, J     button_info->x,button_info->y,button_info->width,button_info->height);.   x=button_info->x-button_info->bevel_width-1;.   y=button_info->y-button_info->bevel_width-1;5   XSetForeground(display,window_info->widget_context, 1     window_info->pixel_info->trough_color.pixel); 7   if (button_info->raised || (window_info->depth == 1)) K     XDrawRectangle(display,window_info->id,window_info->widget_context,x,y, O       button_info->width+(button_info->bevel_width << 1)+1,button_info->height+ )       (button_info->bevel_width << 1)+1); )   if (button_info->text == (char *) NULL)      return;    /*     Set cropping region.   */%   crop_info.width=button_info->width; '   crop_info.height=button_info->height;    crop_info.x=button_info->x;    crop_info.y=button_info->y;    /*     Draw text.   */#   font_info=window_info->font_info; J   width=XTextWidth(font_info,button_info->text,Extent(button_info->text));(   x=button_info->x+(QuantumMargin >> 1);   if (button_info->center)<     x=button_info->x+(button_info->width >> 1)-(width >> 1);)   y=button_info->y+((button_info->height- D     (font_info->ascent+font_info->descent)) >> 1)+font_info->ascent;7   if ((int) button_info->width == (QuantumMargin >> 1))      {        /*7         Option button-- write label to right of button.        */.       XSetTextColor(display,window_info,True);C       x=button_info->x+button_info->width+button_info->bevel_width+          (QuantumMargin >> 1); J       XDrawString(display,window_info->id,window_info->widget_context,x,y,5         button_info->text,Extent(button_info->text)); 
       return;      } J   XSetClipRectangles(display,window_info->widget_context,0,0,&crop_info,1,     Unsorted);9   XSetTextColor(display,window_info,button_info->raised); F   XDrawString(display,window_info->id,window_info->widget_context,x,y,1     button_info->text,Extent(button_info->text)); 9   XSetClipMask(display,window_info->widget_context,None);    if (!button_info->raised) %     XDelay(display,SuspendTime << 2);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X D r a w B e v e l e d M a t t e                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Method XDrawBeveledMatte draws a matte with a shadowed upper and K %  left bevel and a highlighted lower and right bevel.  The highlighted and ' %  shadowed bevels create a 3-D effect.  % 3 %  The format of the XDrawBeveledMatte function is:  % 8 %      XDrawBeveledMatte(display,window_info,matte_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % F %    o matte_info: Specifies a pointer to a XWidgetInfo structure.  It) %      contains the extents of the matte.  %  %  */N static void XDrawBeveledMatte(Display *display,const XWindowInfo *window_info,    const XWidgetInfo *matte_info) {    /*     Draw matte.    */-   XDrawBevel(display,window_info,matte_info); -   XDrawMatte(display,window_info,matte_info);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X D r a w M a t t e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Method XDrawMatte fills a rectangular area with the matte color.  % , %  The format of the XDrawMatte function is: % 1 %      XDrawMatte(display,window_info,matte_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % F %    o matte_info: Specifies a pointer to a XWidgetInfo structure.  It) %      contains the extents of the matte.  %  %  */G static void XDrawMatte(Display *display,const XWindowInfo *window_info,     const XWidgetInfo *matte_info) {    /*     Draw matte.    */7   if (!matte_info->trough || (window_info->depth == 1)) J     XFillRectangle(display,window_info->id,window_info->highlight_context,H       matte_info->x,matte_info->y,matte_info->width,matte_info->height);   else     { 9       XSetForeground(display,window_info->widget_context, 5         window_info->pixel_info->trough_color.pixel); I       XFillRectangle(display,window_info->id,window_info->widget_context, J         matte_info->x,matte_info->y,matte_info->width,matte_info->height);     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X D r a w M a t t e T e x t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method XDrawMatteText draws a matte with text.  If the text exceeds theG %  extents of the text, a portion of the text relative to the cursor is 
 %  displayed.  % 0 %  The format of the XDrawMatteText function is: % 4 %      XDrawMatteText(display,window_info,text_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % E %    o text_info: Specifies a pointer to a XWidgetInfo structure.  It ( %      contains the extents of the text. %  %  */K static void XDrawMatteText(Display *display,const XWindowInfo *window_info,    XWidgetInfo *text_info)  {    const char
     *text;     int      n,     x,     y;     register int     i;     unsigned int     height, 
     width;  
   XFontStruct      *font_info;      XRectangle     crop_info;     /*     Clear the text area.   */,   XSetMatteColor(display,window_info,False);E   XFillRectangle(display,window_info->id,window_info->widget_context, B     text_info->x,text_info->y,text_info->width,text_info->height);'   if (text_info->text == (char *) NULL)      return; :   XSetTextColor(display,window_info,text_info->highlight);#   font_info=window_info->font_info; &   x=text_info->x+(QuantumMargin >> 2);<   y=text_info->y+font_info->ascent+(text_info->height >> 2);.   width=text_info->width-(QuantumMargin >> 1);.   height=font_info->ascent+font_info->descent;   if (*text_info->text == '\0')      {        /*#         No text-- just draw cursor.        */L       XDrawLine(display,window_info->id,window_info->annotate_context,x,y+3,         x,y-height+3);
       return;      }    /*     Set cropping region.   */#   crop_info.width=text_info->width; %   crop_info.height=text_info->height;    crop_info.x=text_info->x;    crop_info.y=text_info->y;    /*,     Determine beginning of the visible text.   */,   if (text_info->cursor < text_info->marker)(     text_info->marker=text_info->cursor;   else     {        text=text_info->marker; L       if (XTextWidth(font_info,text,(text_info->cursor-text)) > (int) width)	         {            text=text_info->text; *           for (i=0; i < Extent(text); i++)           { L             n=XTextWidth(font_info,text+i,(int) (text_info->cursor-text-i));!             if (n <= (int) width)                break;           } ,           text_info->marker=(char *) text+i;	         }      }    /*     Draw text and cursor.    */   if (!text_info->highlight)     { N       XSetClipRectangles(display,window_info->widget_context,0,0,&crop_info,1,         Unsorted);J       XDrawString(display,window_info->id,window_info->widget_context,x,y,5         text_info->marker,Extent(text_info->marker)); =       XSetClipMask(display,window_info->widget_context,None);      }    else     { N       XSetClipRectangles(display,window_info->annotate_context,0,0,&crop_info,         1,Unsorted);N       width=XTextWidth(font_info,text_info->marker,Extent(text_info->marker));M       XFillRectangle(display,window_info->id,window_info->annotate_context,x, *         y-font_info->ascent,width,height);?       XSetClipMask(display,window_info->annotate_context,None); O       XSetClipRectangles(display,window_info->highlight_context,0,0,&crop_info,          1,Unsorted);M       XDrawString(display,window_info->id,window_info->highlight_context,x,y, 5         text_info->marker,Extent(text_info->marker)); @       XSetClipMask(display,window_info->highlight_context,None);     } 1   x+=XTextWidth(font_info,text_info->marker,(int) +     (text_info->cursor-text_info->marker)); H   XDrawLine(display,window_info->id,window_info->annotate_context,x,y+3,     x,y-height+3); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X D r a w T r i a n g l e E a s t                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Method XDrawTriangleEast draws a triangle with a highlighted leftC %  bevel and a shadowed right and lower bevel.  The highlighted and ' %  shadowed bevels create a 3-D effect.  % 3 %  The format of the XDrawTriangleEast function is:  % ; %      XDrawTriangleEast(display,window_info,triangle_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % I %    o triangle_info: Specifies a pointer to a XWidgetInfo structure.  It , %      contains the extents of the triangle. %  %  */N static void XDrawTriangleEast(Display *display,const XWindowInfo *window_info,#   const XWidgetInfo *triangle_info)  {    int      x1,      x2,      x3,      y1,      y2,      y3;      unsigned int     bevel_width;  
   XFontStruct      *font_info;      XPoint     points[4];     /*     Draw triangle matte.   */   x1=triangle_info->x;   y1=triangle_info->y;+   x2=triangle_info->x+triangle_info->width; 3   y2=triangle_info->y+(triangle_info->height >> 1);    x3=triangle_info->x;,   y3=triangle_info->y+triangle_info->height;)   bevel_width=triangle_info->bevel_width;    points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x3;    points[2].y=y3; <   XSetMatteColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,3,     Complex,CoordModeOrigin);    /*     Draw bottom bevel.   */   points[0].x=x2;    points[0].y=y2;    points[1].x=x3;    points[1].y=y3;    points[2].x=x3-bevel_width;    points[2].y=y3+bevel_width;    points[3].x=x2+bevel_width;    points[3].y=y2; L   XSetBevelColor(display,window_info,(unsigned int) !triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw Left bevel.   */   points[0].x=x3;    points[0].y=y3;    points[1].x=x1;    points[1].y=y1;    points[2].x=x1-bevel_width+1;    points[2].y=y1-bevel_width;    points[3].x=x3-bevel_width+1;    points[3].y=y3+bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw top bevel.    */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x2+bevel_width;    points[2].y=y2;    points[3].x=x1-bevel_width;    points[3].y=y1-bevel_width; L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid); +   if (triangle_info->text == (char *) NULL)      return;    /*%     Write label to right of triangle.    */#   font_info=window_info->font_info; *   XSetTextColor(display,window_info,True);F   x1=triangle_info->x+triangle_info->width+triangle_info->bevel_width+     (QuantumMargin >> 1); .   y1=triangle_info->y+((triangle_info->height-D     (font_info->ascent+font_info->descent)) >> 1)+font_info->ascent;H   XDrawString(display,window_info->id,window_info->widget_context,x1,y1,5     triangle_info->text,Extent(triangle_info->text));  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X D r a w T r i a n g l e N o r t h                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method XDrawTriangleNorth draws a triangle with a highlighted left C %  bevel and a shadowed right and lower bevel.  The highlighted and ' %  shadowed bevels create a 3-D effect.  % 4 %  The format of the XDrawTriangleNorth function is: % < %      XDrawTriangleNorth(display,window_info,triangle_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % I %    o triangle_info: Specifies a pointer to a XWidgetInfo structure.  It , %      contains the extents of the triangle. %  %  */O static void XDrawTriangleNorth(Display *display,const XWindowInfo *window_info, #   const XWidgetInfo *triangle_info)  {    int      x1,      x2,      x3,      y1,      y2,      y3;      unsigned int     bevel_width;     XPoint     points[4];     /*     Draw triangle matte.   */   x1=triangle_info->x;,   y1=triangle_info->y+triangle_info->height;2   x2=triangle_info->x+(triangle_info->width >> 1);   y2=triangle_info->y;+   x3=triangle_info->x+triangle_info->width; ,   y3=triangle_info->y+triangle_info->height;)   bevel_width=triangle_info->bevel_width;    points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x3;    points[2].y=y3; <   XSetMatteColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,3,     Complex,CoordModeOrigin);    /*     Draw left bevel.   */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x2;    points[2].y=y2-bevel_width-2;    points[3].x=x1-bevel_width-1;    points[3].y=y1+bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw right bevel.    */   points[0].x=x2;    points[0].y=y2;    points[1].x=x3;    points[1].y=y3;    points[2].x=x3+bevel_width;    points[2].y=y3+bevel_width;    points[3].x=x2;    points[3].y=y2-bevel_width; L   XSetBevelColor(display,window_info,(unsigned int) !triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw lower bevel.    */   points[0].x=x3;    points[0].y=y3;    points[1].x=x1;    points[1].y=y1;    points[2].x=x1-bevel_width;    points[2].y=y1+bevel_width;    points[3].x=x3+bevel_width;    points[3].y=y3+bevel_width; L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X D r a w T r i a n g l e S o u t h                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method XDrawTriangleSouth draws a border with a highlighted left and H %  right bevel and a shadowed lower bevel.  The highlighted and shadowed %  bevels create a 3-D effect. % 4 %  The format of the XDrawTriangleSouth function is: % < %      XDrawTriangleSouth(display,window_info,triangle_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % I %    o triangle_info: Specifies a pointer to a XWidgetInfo structure.  It , %      contains the extents of the triangle. %  %  */O static void XDrawTriangleSouth(Display *display,const XWindowInfo *window_info, #   const XWidgetInfo *triangle_info)  {    int      x1,      x2,      x3,      y1,      y2,      y3;      unsigned int     bevel_width;     XPoint     points[4];     /*     Draw triangle matte.   */   x1=triangle_info->x;   y1=triangle_info->y;2   x2=triangle_info->x+(triangle_info->width >> 1);,   y2=triangle_info->y+triangle_info->height;+   x3=triangle_info->x+triangle_info->width;    y3=triangle_info->y;)   bevel_width=triangle_info->bevel_width;    points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x3;    points[2].y=y3; <   XSetMatteColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,3,     Complex,CoordModeOrigin);    /*     Draw top bevel.    */   points[0].x=x3;    points[0].y=y3;    points[1].x=x1;    points[1].y=y1;    points[2].x=x1-bevel_width;    points[2].y=y1-bevel_width;    points[3].x=x3+bevel_width;    points[3].y=y3-bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw right bevel.    */   points[0].x=x2;    points[0].y=y2;    points[1].x=x3+1;    points[1].y=y3-bevel_width;    points[2].x=x3+bevel_width;    points[2].y=y3-bevel_width;    points[3].x=x2;    points[3].y=y2+bevel_width; L   XSetBevelColor(display,window_info,(unsigned int) !triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw left bevel.   */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x2;    points[2].y=y2+bevel_width;    points[3].x=x1-bevel_width;    points[3].y=y1-bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X D r a w W i d g e t T e x t                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method XDrawWidgetText first clears the widget and draws a text string G %  justifed left (or center) in the x-direction and centered within the  %  y-direction.  % 1 %  The format of the XDrawWidgetText function is:  % 5 %      XDrawWidgetText(display,window_info,text_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % C %    o window_info: Specifies a pointer to a XWindowText structure.  % ? %    o text_info: Specifies a pointer to XWidgetInfo structure.  %  %  */L static void XDrawWidgetText(Display *display,const XWindowInfo *window_info,   XWidgetInfo *text_info)  {    GC     widget_context;      int      x,     y;     unsigned int     height, 
     width;  
   XFontStruct      *font_info;      XRectangle     crop_info;     /*     Clear the text area.   *//   widget_context=window_info->annotate_context;    if (text_info->raised)A     XClearArea(display,window_info->id,text_info->x,text_info->y, 0       text_info->width,text_info->height,False);   else     { I       XFillRectangle(display,window_info->id,widget_context,text_info->x, 9         text_info->y,text_info->width,text_info->height); 4       widget_context=window_info->highlight_context;     } '   if (text_info->text == (char *) NULL)      return;    if (*text_info->text == '\0')      return;    /*     Set cropping region.   */#   font_info=window_info->font_info; #   crop_info.width=text_info->width; %   crop_info.height=text_info->height;    crop_info.x=text_info->x;    crop_info.y=text_info->y;    /*     Draw text.   */F   width=XTextWidth(font_info,text_info->text,Extent(text_info->text));&   x=text_info->x+(QuantumMargin >> 1);   if (text_info->center)8     x=text_info->x+(text_info->width >> 1)-(width >> 1);   if (text_info->raised)1     if (width > (text_info->width-QuantumMargin)) 0       x+=(text_info->width-QuantumMargin-width);.   height=font_info->ascent+font_info->descent;E   y=text_info->y+((text_info->height-height) >> 1)+font_info->ascent; G   XSetClipRectangles(display,widget_context,0,0,&crop_info,1,Unsorted); I   XDrawString(display,window_info->id,widget_context,x,y,text_info->text,      Extent(text_info->text)); ,   XSetClipMask(display,widget_context,None);   if (x < text_info->x) D     XDrawLine(display,window_info->id,window_info->annotate_context,O       text_info->x,text_info->y,text_info->x,text_info->y+text_info->height-1);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X E d i t T e x t                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method XEditText edits a text string as indicated by the key symbol.  % + %  The format of the XEditText function is:  % 9 %      XEditText(display,text_info,key_symbol,text,state)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % E %    o text_info: Specifies a pointer to a XWidgetInfo structure.  It ( %      contains the extents of the text. % H %    o key_symbol:  A X11 KeySym that indicates what editing function to %      perform to the text.  % 8 %    o text: A character string to insert into the text. % J %    o state:  An unsigned long that indicates whether the key symbol is a  %      control character or not. %  %  */> static void XEditText(Display *display,XWidgetInfo *text_info,?   const KeySym key_symbol,char *text,const unsigned long state)  {    switch (key_symbol)    {      case XK_BackSpace:     case XK_Delete:      {        if (text_info->highlight) 	         {            /**             Erase the entire line of text.           */            *text_info->text='\0';,           text_info->cursor=text_info->text;,           text_info->marker=text_info->text;%           text_info->highlight=False; 	         }        /*         Erase one character.       *//       if (text_info->cursor != text_info->text) 	         {            text_info->cursor--;?           (void) strcpy(text_info->cursor,text_info->cursor+1); %           text_info->highlight=False;            break;	         }      }      case XK_Left:      case XK_KP_Left:     {        /*&         Move cursor one position left.       *//       if (text_info->cursor == text_info->text)          break;       text_info->cursor--;       break;     }      case XK_Right:     case XK_KP_Right:      {        /*'         Move cursor one position right.        */I       if (text_info->cursor == (text_info->text+Extent(text_info->text)))          break;       text_info->cursor++;       break;     }      default:     {        register char          *p,          *q;          register int
         i;         if (state & ControlState)          break;       if (*text == '\0')         break;7       if ((Extent(text_info->text)+1) >= MaxTextExtent)          XBell(display,0); 
       else	         { #           if (text_info->highlight) 
             {                /*.                 Erase the entire line of text.               */$               *text_info->text='\0';0               text_info->cursor=text_info->text;0               text_info->marker=text_info->text;)               text_info->highlight=False; 
             }            /**             Insert a string into the text.           */A           q=text_info->text+Extent(text_info->text)+Extent(text); 8           for (i=0; i <= Extent(text_info->cursor); i++)           { #             *q=(*(q-Extent(text)));              q--;           }            p=text; *           for (i=0; i < Extent(text); i++)(             *text_info->cursor++=(*p++);	         }        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X G e t W i d g e t I n f o                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ? %  Method XGetWidgetInfo initializes the XWidgetInfo structure.  % 0 %  The format of the XGetWidgetInfo function is: % ' %      XGetWidgetInfo(text,widget_info)  % + %  A description of each parameter follows:  % ? %    o text: A string of characters associated with the widget.  % G %    o widget_info: Specifies a pointer to a X11 XWidgetInfo structure.  %  %  */E static void XGetWidgetInfo(const char *text,XWidgetInfo *widget_info)  {    /*     Initialize widget info.    */   widget_info->id=(~0);    widget_info->bevel_width=3;    widget_info->width=1;    widget_info->height=1;   widget_info->x=0;    widget_info->y=0;    widget_info->min_y=0;    widget_info->max_y=0;    widget_info->raised=True;    widget_info->active=False;   widget_info->center=True;    widget_info->trough=False;   widget_info->highlight=False; "   widget_info->text=(char *) text;$   widget_info->cursor=(char *) text;   if (text != (char *) NULL)&     widget_info->cursor+=Extent(text);$   widget_info->marker=(char *) text; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X H i g h l i g h t W i d g e t                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method XHighlightWidget draws a highlighted border around a window. % 2 %  The format of the XHighlightWidget function is: % 0 %      XHighlightWidget(display,window_info,x,y) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % G %    o x: Specifies an integer representing the rectangle offset in the  %      x-direction.  % G %    o y: Specifies an integer representing the rectangle offset in the  %      y-direction.  %  %  */M static void XHighlightWidget(Display *display,const XWindowInfo *window_info,    const int x,const int y) {    /*+     Draw the widget highlighting rectangle.    */+   XSetBevelColor(display,window_info,True); I   XDrawRectangle(display,window_info->id,window_info->widget_context,x,y, >     window_info->width-(x << 1),window_info->height-(y << 1));M   XDrawRectangle(display,window_info->id,window_info->widget_context,x-1,y-1, B     window_info->width-(x << 1)+1,window_info->height-(y << 1)+1);,   XSetBevelColor(display,window_info,False);M   XDrawRectangle(display,window_info->id,window_info->widget_context,x-1,y-1, >     window_info->width-(x << 1),window_info->height-(y << 1));?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X S c r e e n E v e n t                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method XScreenEvent returns True if the any event on the X server queue( %  is associated with the widget window. % . %  The format of the XScreenEvent function is: % ' %      XScreenEvent(display,event,data)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % < %    o event: Specifies a pointer to a X11 XEvent structure. % 9 %    o data: Specifies a pointer to a XWindows structure.  %  %  *// #if defined(__cplusplus) || defined(c_plusplus)  extern "C" { #endif  B static int XScreenEvent(Display *display,XEvent *event,char *data) { 
   XWindows
     *windows;      windows=(XWindows *) data;.   if (event->xany.window == windows->popup.id)     { #       if (event->type == MapNotify) #         windows->popup.mapped=True; %       if (event->type == UnmapNotify) $         windows->popup.mapped=False;       return(True);      } /   if (event->xany.window == windows->widget.id)      { #       if (event->type == MapNotify) $         windows->widget.mapped=True;%       if (event->type == UnmapNotify) %         windows->widget.mapped=False;        return(True);      }    switch (event->type)   {      case ButtonPress:      { /       if ((event->xbutton.button == Button3) && ,           (event->xbutton.state & Mod1Mask))	         {            /*+             Convert Alt-Button3 to Button2.            */(           event->xbutton.button=Button2;,           event->xbutton.state&=(~Mod1Mask);	         }        return(True);      }      case Expose:     { 5       if (event->xexpose.window == windows->image.id) 	         { 8           XRefreshWindow(display,&windows->image,event);           break;	         } 7       if (event->xexpose.window == windows->magnify.id) &         if (event->xexpose.count == 0)&           if (windows->magnify.mapped)
             { 1               XMakeMagnifyImage(display,windows);                break;
             } 7       if (event->xexpose.window == windows->command.id) &         if (event->xexpose.count == 0)           { N             (void) XCommandWidget(display,windows,(char const **) NULL,event);             break;           }        break;     }      case FocusOut:     {        /*,         Set input focus for backdrop window.       */4       if (event->xfocus.window == windows->image.id)K         XSetInputFocus(display,windows->image.id,RevertToNone,CurrentTime);        return(True);      }      case ButtonRelease:      case KeyPress:     case KeyRelease:     case MotionNotify:     case SelectionNotify:        return(True);      default:       break;   }    return(False); }   / #if defined(__cplusplus) || defined(c_plusplus)  }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X S e t B e v e l C o l o r                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method XSetBevelColor sets the graphic context for drawing a beveled 
 %  border. % 0 %  The format of the XSetBevelColor function is: % 1 %      XSetBevelColor(display,window_info,raised)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % D %    o raised: A value other than zero indicates the color show be a> %      "highlight" color, otherwise the "shadow" color is set. %  %  */K static void XSetBevelColor(Display *display,const XWindowInfo *window_info,    const unsigned int raised) {    if (window_info->depth == 1)     {        Pixmap         stipple;         /*         Monochrome window.       */9       XSetBackground(display,window_info->widget_context, 2         XBlackPixel(display,window_info->screen));9       XSetForeground(display,window_info->widget_context, 2         XWhitePixel(display,window_info->screen));L       XSetFillStyle(display,window_info->widget_context,FillOpaqueStippled);-       stipple=window_info->highlight_stipple;        if (!raised),         stipple=window_info->shadow_stipple;?       XSetStipple(display,window_info->widget_context,stipple);      }    else     if (raised) 9       XSetForeground(display,window_info->widget_context, 8         window_info->pixel_info->highlight_color.pixel);     else9       XSetForeground(display,window_info->widget_context, 5         window_info->pixel_info->shadow_color.pixel);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X S e t M a t t e C o l o r                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method XSetMatteColor sets the graphic context for drawing the matte. % 0 %  The format of the XSetMatteColor function is: % 1 %      XSetMatteColor(display,window_info,raised)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % E %    o raised: A value other than zero indicates the matte is active.  %  %  */K static void XSetMatteColor(Display *display,const XWindowInfo *window_info,    const unsigned int raised) {    if (window_info->depth == 1)     {        /*         Monochrome window.       */       if (raised) ;         XSetForeground(display,window_info->widget_context, 4           XWhitePixel(display,window_info->screen));
       else;         XSetForeground(display,window_info->widget_context, 4           XBlackPixel(display,window_info->screen));     }    else     if (raised) 9       XSetForeground(display,window_info->widget_context, 4         window_info->pixel_info->matte_color.pixel);     else9       XSetForeground(display,window_info->widget_context, 4         window_info->pixel_info->depth_color.pixel); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X S e t T e x t C o l o r                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method XSetTextColor sets the graphic context for drawing text on a	 %  matte.  % / %  The format of the XSetTextColor function is:  % 0 %      XSetTextColor(display,window_info,raised) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % D %    o raised: A value other than zero indicates the color show be a> %      "highlight" color, otherwise the "shadow" color is set. %  %  */J static void XSetTextColor(Display *display,const XWindowInfo *window_info,   const unsigned int raised) {    int      foreground, 
     matte;     if (window_info->depth == 1)     {        /*         Monochrome window.       */       if (raised) ;         XSetForeground(display,window_info->widget_context, 4           XBlackPixel(display,window_info->screen));
       else;         XSetForeground(display,window_info->widget_context, 4           XWhitePixel(display,window_info->screen));
       return;      } N   foreground=XDownScale(Intensity(window_info->pixel_info->foreground_color));D   matte=XDownScale(Intensity(window_info->pixel_info->matte_color));6   if (AbsoluteValue(foreground-matte) > (MaxRGB >> 3))7     XSetForeground(display,window_info->widget_context, 7       window_info->pixel_info->foreground_color.pixel);    else7     XSetForeground(display,window_info->widget_context, 7       window_info->pixel_info->background_color.pixel);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o l o r B r o w s e r W i d g e t                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method XColorBrowserWidget displays a Color Browser widget with a colorM %  query to the user.  The user keys a reply and presses the Action or Cancel O %  button to exit.  The typed text is returned as the reply function parameter.  % 3 %  The format of the XColorBrowserWidget method is:  % C %      void XColorBrowserWidget(Display *display,XWindows *windows, ( %        const char *action,char *reply) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % @ %    o action: Specifies a pointer to the action of this widget. % G %    o reply: The response from the user is returned in this parameter.  %  %  */C Export void XColorBrowserWidget(Display *display,XWindows *windows, !   const char *action,char *reply)  { " #define CancelButtonText  "Cancel" #define ColornameText  "Name:"$ #define ColorPatternText  "Pattern:" #define GrabButtonText  "Grab"  #define ResetButtonText  "Reset"     char     **colorlist,%     primary_selection[MaxTextExtent], !     reset_pattern[MaxTextExtent],      text[MaxTextExtent];     int      colors,      height,      status,      text_width, 
     width,     x,     y;     register int     i;  
   static char &     glob_pattern[MaxTextExtent] = "*";  
   static char *     mask = CWWidth | CWHeight | CWX | CWY;     unsigned int     visible_colors;      unsigned long 
     delay,
     state;     XColor
     color;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      action_info,     cancel_info,     expose_info,     grab_info,     list_info,     mode_info,     north_info,      reply_info,      reset_info,      scroll_info,     selection_info,      slider_info,     south_info,      text_info;     XWindowChanges     window_changes;      /*/     Get color list and sort in ascending order.    */&   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL); "   assert(action != (char *) NULL);!   assert(reply != (char *) NULL); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);#   (void) strcpy(reset_pattern,"*"); -   colorlist=ListColors(glob_pattern,&colors); "   if (colorlist == (char **) NULL)     {        /*.         Pattern failed, obtain all the colors.       */&       (void) strcpy(glob_pattern,"*");1       colorlist=ListColors(glob_pattern,&colors); &       if (colorlist == (char **) NULL)	         { I           XNoticeWidget(display,windows,"Unable to obtain colors names:",              glob_pattern);J           (void) XDialogWidget(display,windows,action,"Enter color name:",             reply);            return; 	         }      }    /*.     Determine Color Browser widget attributes.   */&   font_info=windows->widget.font_info;   text_width=0;    for (i=0; i < colors; i++)M     if (XTextWidth(font_info,colorlist[i],Extent(colorlist[i])) > text_width) I       text_width=XTextWidth(font_info,colorlist[i],Extent(colorlist[i])); 4   width=XTextWidth(font_info,action,Extent(action));N   if (XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText));L   if (XTextWidth(font_info,ResetButtonText,Extent(ResetButtonText)) > width)H     width=XTextWidth(font_info,ResetButtonText,Extent(ResetButtonText));J   if (XTextWidth(font_info,GrabButtonText,Extent(GrabButtonText)) > width)F     width=XTextWidth(font_info,GrabButtonText,Extent(GrabButtonText));   width+=QuantumMargin; N   if (XTextWidth(font_info,ColorPatternText,Extent(ColorPatternText)) > width)J     width=XTextWidth(font_info,ColorPatternText,Extent(ColorPatternText));H   if (XTextWidth(font_info,ColornameText,Extent(ColornameText)) > width)D     width=XTextWidth(font_info,ColornameText,Extent(ColornameText));.   height=font_info->ascent+font_info->descent;   /*"     Position Color Browser widget.   */K   windows->widget.width=width+Min(text_width,MaxTextWidth)+6*QuantumMargin; ?   windows->widget.min_width=width+MinTextWidth+4*QuantumMargin; 8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;H   windows->widget.height=((81*height) >> 2)+((13*QuantumMargin) >> 1)+4;L   windows->widget.min_height=((23*height) >> 1)+((13*QuantumMargin) >> 1)+4;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Color Browser widget.    */B   (void) strcpy(windows->widget.name,"Browse and Select a Color");I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);    if (status != 0)     { :       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     } -   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y; N   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,mask,     &window_changes); )   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;    /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info); ,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_colors=0;    delay=SuspendTime << 2; !   state=UpdateConfigurationState;    do   { )     if (state & UpdateConfigurationState)        {          int 
           id;   
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1; N         cancel_info.x=windows->widget.width-cancel_info.width-QuantumMargin-2;N         cancel_info.y=windows->widget.height-cancel_info.height-QuantumMargin;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; L         action_info.x=cancel_info.x-(cancel_info.width+(QuantumMargin >> 1)+*           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;2         XGetWidgetInfo(GrabButtonText,&grab_info);         grab_info.width=width;)         grab_info.height=(3*height) >> 1; "         grab_info.x=QuantumMargin;4         grab_info.y=((5*QuantumMargin) >> 1)+height;4         XGetWidgetInfo(ResetButtonText,&reset_info);         reset_info.width=width; *         reset_info.height=(3*height) >> 1;#         reset_info.x=QuantumMargin; @         reset_info.y=grab_info.y+grab_info.height+QuantumMargin;
         /*'           Initialize reply information. 
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--; N         reply_info.width=windows->widget.width-width-((6*QuantumMargin) >> 1);&         reply_info.height=height << 1;0         reply_info.x=width+(QuantumMargin << 1);C         reply_info.y=action_info.y-reply_info.height-QuantumMargin; 
         /*&           Initialize mode information.
         */1         XGetWidgetInfo((char *) NULL,&mode_info);          mode_info.active=True;          mode_info.bevel_width=0;A         mode_info.width=action_info.x-reply_info.x-QuantumMargin; ,         mode_info.height=action_info.height;!         mode_info.x=reply_info.x; "         mode_info.y=action_info.y;
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info); "         scroll_info.bevel_width--;!         scroll_info.width=height; I         scroll_info.height=reply_info.y-grab_info.y-(QuantumMargin >> 1); H         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);9         scroll_info.y=grab_info.y-reply_info.bevel_width; !         scroll_info.raised=False;           scroll_info.trough=True;         north_info=scroll_info;          north_info.raised=True; 8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1; -         north_info.x+=north_info.bevel_width; -         north_info.y+=north_info.bevel_width;          south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;          slider_info.id=id;         slider_info.width-=2; P         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;         visible_colors= A           (scroll_info.height-(height >> 3)-3)/((9*height) >> 3); *         if (colors > (int) visible_colors)H           slider_info.height=(visible_colors*slider_info.height)/colors;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);          list_info.raised=False;           list_info.bevel_width--;H         list_info.width=scroll_info.x-reply_info.x-(QuantumMargin >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x; "         list_info.y=scroll_info.y;$         if (!windows->widget.mapped)           state|=JumpListState; 
         /*&           Initialize text information.
         */         *text='\0'; (         XGetWidgetInfo(text,&text_info);         text_info.center=False; )         text_info.width=reply_info.width;           text_info.height=height;5         text_info.x=list_info.x-(QuantumMargin >> 1); "         text_info.y=QuantumMargin;
         /*+           Initialize selection information. 
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width; .         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*&           Redraw Color Browser window.
         */         x=QuantumMargin;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent; P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,9           x,y,ColorPatternText,Extent(ColorPatternText)); <         FormatString(text_info.text,"%.1024s",glob_pattern);=         XDrawWidgetText(display,&windows->widget,&text_info); @         XDrawBeveledButton(display,&windows->widget,&grab_info);A         XDrawBeveledButton(display,&windows->widget,&reset_info); ?         XDrawBeveledMatte(display,&windows->widget,&list_info); A         XDrawBeveledMatte(display,&windows->widget,&scroll_info); A         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);          x=QuantumMargin;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent; P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,3           x,y,ColornameText,Extent(ColornameText)); @         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info); B         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);          selection_info.id=(~0); !         state|=RedrawActionState;          state|=RedrawListState; $         state&=(~RedrawWidgetState);       }       if (state & UpdateListState)       {          char           **checklist;           int            number_colors;  F         status=XParseColor(display,windows->widget.map_info->colormap,           glob_pattern,&color); I         if ((status != 0) || (strchr(glob_pattern,'-') != (char *) NULL))            {              /*2               Reply is a single color name-- exit.             */.             (void) strcpy(reply,glob_pattern);6             (void) strcpy(glob_pattern,reset_pattern);%             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } 
         /*           Update color list.
         */:         checklist=ListColors(glob_pattern,&number_colors);         if (number_colors == 0)            { 6             (void) strcpy(glob_pattern,reset_pattern);             XBell(display,0);            }          else           { &             for (i=0; i < colors; i++)'               FreeMemory(colorlist[i]); ,             if (colorlist != (char **) NULL)$               FreeMemory(colorlist);              colorlist=checklist;!             colors=number_colors;            } 
         /*-           Sort color list in ascending order. 
         */         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+1;*         if (colors > (int) visible_colors)H           slider_info.height=(visible_colors*slider_info.height)/colors;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;         slider_info.id=0; (         slider_info.y=slider_info.min_y;$         expose_info.y=slider_info.y;         selection_info.id=(~0);          list_info.id=(~0);         state|=RedrawListState; 
         /*$           Redraw color name & reply.
         */         *reply_info.text='\0';*         reply_info.cursor=reply_info.text;<         FormatString(text_info.text,"%.1024s",glob_pattern);=         XDrawWidgetText(display,&windows->widget,&text_info); =         XDrawMatteText(display,&windows->widget,&reply_info); A         XDrawBeveledMatte(display,&windows->widget,&scroll_info); A         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info); M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset); "         state&=(~UpdateListState);       }      if (state & JumpListState)       { 
         /**           Jump scroll to match user color.
         */         list_info.id=(~0);"         for (i=0; i < colors; i++)5           if (Latin1Compare(colorlist[i],reply) >= 0) 
             { K               list_info.id=Latin1Compare(colorlist[i],reply) == 0 ? i : ~0;                break;
             } #         if ((i < slider_info.id) || 9             (i >= (int) (slider_info.id+visible_colors))) 1           slider_info.id=i-(visible_colors >> 1);          selection_info.id=(~0);          state|=RedrawListState;           state&=(~JumpListState);       }       if (state & RedrawListState)       { 
         /*+           Determine slider id and position. 
         */<         if (slider_info.id >= (int) (colors-visible_colors))/           slider_info.id=colors-visible_colors; E         if ((slider_info.id < 0) || (colors <= (int) visible_colors))            slider_info.id=0; (         slider_info.y=slider_info.min_y;         if (colors > 0)            slider_info.y+= J             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/colors;0         if (slider_info.id != selection_info.id)           {              /*/               Redraw scroll bar and file names.              */-             selection_info.id=slider_info.id; 9             selection_info.y=list_info.y+(height >> 3)+2; 4             for (i=0; i < (int) visible_colors; i++)
             { G               selection_info.raised=(slider_info.id+i) != list_info.id; 0               selection_info.text=(char *) NULL;.               if ((slider_info.id+i) < colors)@                 selection_info.text=colorlist[slider_info.id+i];H               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             }              /*               Update slider.             */.             if (slider_info.y > expose_info.y)               { ?                 expose_info.height=slider_info.y-expose_info.y; ?                 expose_info.y=slider_info.y-expose_info.height- ,                   slider_info.bevel_width-1;               }              else               { ?                 expose_info.height=expose_info.y-slider_info.y; ?                 expose_info.y=slider_info.y+slider_info.height+ ,                   slider_info.bevel_width+1;               } E             XDrawTriangleNorth(display,&windows->widget,&north_info); >             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info); (             expose_info.y=slider_info.y;           } "         state&=(~RedrawListState);       } "     if (state & RedrawActionState)       {          static char #           colorname[MaxTextExtent];   
         /*7           Display the selected color in a drawing area. 
         */6         color=windows->widget.pixel_info->matte_color;F         (void) XParseColor(display,windows->widget.map_info->colormap,D           reply_info.text,&windows->widget.pixel_info->matte_color);N         XBestPixel(display,windows->widget.map_info->colormap,(XColor *) NULL,D           (unsigned int) windows->widget.visual_info->colormap_size,4           &windows->widget.pixel_info->matte_color);!         mode_info.text=colorname; 4         FormatString(mode_info.text,"#%02x%02x%02x",B           XDownScale(windows->widget.pixel_info->matte_color.red),D           XDownScale(windows->widget.pixel_info->matte_color.green),D           XDownScale(windows->widget.pixel_info->matte_color.blue));@         XDrawBeveledButton(display,&windows->widget,&mode_info);6         windows->widget.pixel_info->matte_color=color;$         state&=(~RedrawActionState);       }      /*       Wait for next event.     *//     if (north_info.raised && south_info.raised) =       XIfEvent(display,&event,XScreenEvent,(char *) windows);      else       { 
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised) !           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */               slider_info.id--; %               state|=RedrawListState; 
             }          if (!south_info.raised) &           if (slider_info.id < colors)
             {                /*!                 Move slider down.                */               slider_info.id++; %               state|=RedrawListState; 
             } (         if (event.type != ButtonRelease)           continue;        }      switch (event.type)      {        case ButtonPress:        { 5         if (MatteIsActive(slider_info,event.xbutton))            {              /*               Track slider.              */$             slider_info.active=True;             break;           } 4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */&               north_info.raised=False;               slider_info.id--; %               state|=RedrawListState;                break;
             } 4         if (MatteIsActive(south_info,event.xbutton))&           if (slider_info.id < colors)
             {                /*!                 Move slider down.                */&               south_info.raised=False;               slider_info.id++; %               state|=RedrawListState;                break;
             } 5         if (MatteIsActive(scroll_info,event.xbutton))            {              /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)1               slider_info.id-=(visible_colors-1);              else1               slider_info.id+=(visible_colors-1); #             state|=RedrawListState;              break;           } 3         if (MatteIsActive(list_info,event.xbutton))            {              unsigned int               id;                /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;#             if ((int) id >= colors)                break;9             (void) strcpy(reply_info.text,colorlist[id]); '             reply_info.highlight=False; .             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+Extent(reply_info.text);A             XDrawMatteText(display,&windows->widget,&reply_info); %             state|=RedrawActionState; )             if ((int) id == list_info.id)                { <                 (void) strcpy(glob_pattern,reply_info.text);'                 state|=UpdateListState;                } #             selection_info.id=(~0);              list_info.id=id;#             state|=RedrawListState;              break;           } 3         if (MatteIsActive(grab_info,event.xbutton))            {              /*'               User pressed Grab button.              */#             grab_info.raised=False; D             XDrawBeveledButton(display,&windows->widget,&grab_info);             break;           } 4         if (MatteIsActive(reset_info,event.xbutton))           {              /*(               User pressed Reset button.             */$             reset_info.raised=False;E             XDrawBeveledButton(display,&windows->widget,&reset_info);              break;           } 3         if (MatteIsActive(mode_info,event.xbutton))            {              /*'               User pressed mode button.              */:             (void) strcpy(reply_info.text,mode_info.text);=             (void) strcpy(primary_selection,reply_info.text); E             XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id, "               event.xbutton.time);J             reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==!               windows->widget.id; .             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+Extent(reply_info.text);A             XDrawMatteText(display,&windows->widget,&reply_info);              break;           } 5         if (MatteIsActive(action_info,event.xbutton))            {              /*)               User pressed action button.              */%             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } 5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*)               User pressed Cancel button.              */%             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;,         if (event.xbutton.button != Button2)           {              static Time                click_time;                /*;               Move text cursor to position of button press.              */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);:             for (i=1; i <= Extent(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;              else               {                  /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); I                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id, &                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;                } A             XDrawMatteText(display,&windows->widget,&reply_info); *             click_time=event.xbutton.time;             break;           } 
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, 1           windows->widget.id,event.xbutton.time);          break;       }        case ButtonRelease:        { $         if (!windows->widget.mapped)           break;         if (!north_info.raised)            {              /*&               User released up button.             */#             delay=SuspendTime << 2; #             north_info.raised=True; E             XDrawTriangleNorth(display,&windows->widget,&north_info);            }          if (!south_info.raised)            {              /*(               User released down button.             */#             delay=SuspendTime << 2; #             south_info.raised=True; E             XDrawTriangleSouth(display,&windows->widget,&south_info);            }          if (slider_info.active)            {              /*#               Stop tracking slider.              */%             slider_info.active=False;              break;           }          if (!grab_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) 9               if (MatteIsActive(grab_info,event.xbutton))                  {                    /*9                     Select a pen color from the X server.                    */B                   (void) XGetWindowColor(display,reply_info.text);4                   reply_info.marker=reply_info.text;L                   reply_info.cursor=reply_info.text+Extent(reply_info.text);G                   XDrawMatteText(display,&windows->widget,&reply_info); +                   state|=RedrawActionState;                  } "             grab_info.raised=True;D             XDrawBeveledButton(display,&windows->widget,&grab_info);           }          if (!reset_info.raised)            { ;             if (event.xbutton.window == windows->widget.id) :               if (MatteIsActive(reset_info,event.xbutton))                 { <                   (void) strcpy(glob_pattern,reset_pattern);)                   state|=UpdateListState;                  } #             reset_info.raised=True; E             XDrawBeveledButton(display,&windows->widget,&reset_info);            }           if (!action_info.raised)           { ;             if (event.xbutton.window == windows->widget.id)                { =                 if (MatteIsActive(action_info,event.xbutton))                    { 1                     if (*reply_info.text == '\0') '                       XBell(display,0);                      else'                       state|=ExitState;                    }                } $             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }           if (!cancel_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(cancel_info,event.xbutton))                  { (                   *reply_info.text='\0';#                   state|=ExitState;                  } $             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;         break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;B         if (*event.xclient.data.l == (int) windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } E         if (*event.xclient.data.l != (int) windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)            { "             *reply_info.text='\0';             state|=ExitState;              break;           }          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;F         if ((event.xconfigure.width == (int) windows->widget.width) &&F             (event.xconfigure.height == (int) windows->widget.height))           break;         windows->widget.width=F           Max(event.xconfigure.width,(int) windows->widget.min_width);         windows->widget.height= H           Max(event.xconfigure.height,(int) windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       { 7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {          static char !           command[MaxTextExtent];            static int           length;            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; 1         if (AreaIsActive(scroll_info,event.xkey))            {              /*               Move slider.             */             switch (key_symbol) 
             {                case XK_Home:                case XK_KP_Home:               { !                 slider_info.id=0;                  break;               }                case XK_Up:                case XK_KP_Up:               { !                 slider_info.id--;                  break;               }                case XK_Down:                case XK_KP_Down:               { !                 slider_info.id++;                  break;               }                case XK_Prior:               case XK_KP_Prior:                { /                 slider_info.id-=visible_colors;                  break;               }                case XK_Next:                case XK_KP_Next:               { /                 slider_info.id+=visible_colors;                  break;               }                case XK_End:               case XK_KP_End:                { &                 slider_info.id=colors;                 break;               } 
             } #             state|=RedrawListState;              break;           } E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            {              /*-               Read new color or glob patterm.              */)             if (*reply_info.text == '\0')                break;8             (void) strcpy(glob_pattern,reply_info.text);#             state|=UpdateListState;              break;           } '         if (key_symbol == XK_Control_L)            {               state|=ControlState;             break;           } !         if (state & ControlState)            switch (key_symbol)            {              case XK_u:             case XK_U:
             {                /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;                break;
             }              default:               break;           } @         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info);          state|=JumpListState; F         status=XParseColor(display,windows->widget.map_info->colormap,"           reply_info.text,&color);         if (status != 0)#           state|=RedrawActionState;          break;       }        case KeyRelease:       {          static char !           command[MaxTextExtent];            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); '         if (key_symbol == XK_Control_L) !           state&=(~ControlState);          break;       }        case LeaveNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;#         state|=InactiveWidgetState;          break;       }        case MapNotify:        {          mask&=(~CWX);          mask&=(~CWY);          break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));          if (slider_info.active)            {              /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0; 3             if (slider_info.y != slider_info.min_y) J               slider_info.id=(colors*(slider_info.y-slider_info.min_y+1))/8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;              break;           } (         if (state & InactiveWidgetState)           break;G         if (grab_info.raised == MatteIsActive(grab_info,event.xmotion))            {              /*)               Grab button status changed.              *//             grab_info.raised=!grab_info.raised; D             XDrawBeveledButton(display,&windows->widget,&grab_info);             break;           } I         if (reset_info.raised == MatteIsActive(reset_info,event.xmotion))            {              /**               Reset button status changed.             */1             reset_info.raised=!reset_info.raised; E             XDrawBeveledButton(display,&windows->widget,&reset_info);              break;           } K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {              /*+               Action button status changed.              */3             action_info.raised=!action_info.raised; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {              /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }          break;       }        case SelectionClear:       { #         reply_info.highlight=False; =         XDrawMatteText(display,&windows->widget,&reply_info);          break;       }        case SelectionNotify:        {          Atom           type;            int            format;            unsigned char            *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;>         if ((Extent(reply_info.text)+length) >= MaxTextExtent)           XBell(display,0);          else           {              /*5               Insert primary selection in reply text.              */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,                state); A             XDrawMatteText(display,&windows->widget,&reply_info); !             state|=JumpListState; %             state|=RedrawActionState;            }          XFree((void *) data);          break;       }        case SelectionRequest:       {          XSelectionEvent            notify;            XSelectionRequestEvent           *request;   "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest)); N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           Extent(primary_selection)); $         notify.type=SelectionNotify;         notify.send_event=True; (         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;P         (void) XSendEvent(request->display,request->requestor,False,NoEventMask,           (XEvent *) &notify);       }        default:         break;     } !   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   /*     Free color list.   */   for (i=0; i < colors; i++)     FreeMemory(colorlist[i]); "   if (colorlist != (char **) NULL)     FreeMemory(colorlist);?   if ((*reply == '\0') || (strchr(reply,'-') != (char *) NULL))      return; N   status=XParseColor(display,windows->widget.map_info->colormap,reply,&color);   if (status != 0)     return; G   XNoticeWidget(display,windows,"Color is unknown to X server:",reply);    (void) strcpy(reply,"gray"); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o m m a n d W i d g e t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method XCommandWidget maps a menu and returns the command pointed to by( %  the user when the button is released. % . %  The format of the XCommandWidget method is: % = %      int XCommandWidget(Display *display,XWindows *windows, / %        const char **selections,XEvent *event)  % + %  A description of each parameter follows:  % G %    o selection_number: Specifies the number of the selection that the  %      user choose.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % K %    o selections: Specifies a pointer to one or more strings that comprise  %      the choices in the menu.  % < %    o event: Specifies a pointer to a X11 XEvent structure. %  %  */= Export int XCommandWidget(Display *display,XWindows *windows, (   const char **selections,XEvent *event) {  #define tile_width 112 #define tile_height 70     static const unsigned char     tile_bits[]=     { M       0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x00, 0x00, 0x1e, 0x38, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x1e, 0xbc, 0x9f, 0x03, 0x00, 0x3e, 0x00, 0xc0, M       0x1f, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x1e, 0xfc, 0xff, 0x0f, 0x80, 0x3f, M       0x00, 0xf0, 0x1f, 0xc0, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0xfc, 0xff, 0x1f, M       0xe0, 0x3f, 0x00, 0xfc, 0x1f, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0xfc, M       0xff, 0x1f, 0xf0, 0x3f, 0x00, 0xfe, 0x1f, 0xf8, 0x0f, 0x00, 0x00, 0x00, M       0x1e, 0xfc, 0xfc, 0x3f, 0xf8, 0x3f, 0x00, 0xff, 0x1e, 0xfc, 0x0f, 0x00, M       0x00, 0x00, 0x1e, 0x7c, 0xfc, 0x3e, 0xf8, 0x3c, 0x80, 0x1f, 0x1e, 0x7c, M       0x0f, 0x00, 0x00, 0x00, 0x1e, 0x78, 0x78, 0x3c, 0x7c, 0x3c, 0xc0, 0x0f, M       0x1e, 0x3e, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0x78, 0x78, 0x3c, 0x7c, 0x3c, M       0xc0, 0x07, 0x1e, 0x3e, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0x78, 0x78, 0x3c, M       0x7c, 0x7c, 0xc0, 0x0f, 0x1e, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x78, M       0x78, 0x3c, 0xfc, 0x7c, 0x80, 0x7f, 0x1e, 0x7c, 0x00, 0x00, 0x00, 0x00, M       0x1e, 0xf8, 0x78, 0x7c, 0xf8, 0xff, 0x00, 0xff, 0x1f, 0xf8, 0xff, 0x00, M       0x00, 0x00, 0x1e, 0xf8, 0x78, 0x7c, 0xf0, 0xff, 0x07, 0xfe, 0x1f, 0xf8, M       0xff, 0x00, 0x00, 0x00, 0x1e, 0xf8, 0x78, 0x7c, 0xf0, 0xff, 0x07, 0xf8, M       0x1f, 0xf0, 0xff, 0x01, 0x00, 0x00, 0x1e, 0xf8, 0x78, 0x7c, 0xc0, 0xef, M       0x07, 0xe0, 0x1f, 0xc0, 0xff, 0x01, 0x00, 0x00, 0x1e, 0x70, 0x40, 0x78, M       0x00, 0xc7, 0x07, 0x00, 0x1e, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x1e, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, M       0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x00, 0xc0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x00, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x01, 0x00, 0x00, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x02, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x07, M       0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, M       0xc0, 0x0f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x60, 0x00, 0xc0, 0x0f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x00, 0x00, 0x78, 0x00, 0xc0, 0x8f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0xc0, 0x8f, 0x3f, 0x00, 0x00, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0xe0, 0x9f, 0x7f, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0xe0, 0xdf, M       0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x78, 0x00, M       0xe0, 0xdf, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x0c, M       0x78, 0x30, 0xf0, 0xff, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, M       0x00, 0x0f, 0xf8, 0x70, 0xf0, 0xff, 0x7b, 0x00, 0x00, 0x1f, 0x00, 0xe0, M       0x0f, 0x1e, 0x80, 0x0f, 0xf8, 0x78, 0xf0, 0xfd, 0xf9, 0x00, 0xc0, 0x1f, M       0x00, 0xf8, 0x0f, 0x00, 0xe0, 0x1f, 0xf8, 0x7c, 0xf0, 0xfc, 0xf9, 0x00, M       0xf0, 0x1f, 0x00, 0xfe, 0x0f, 0x00, 0xf0, 0x07, 0xf8, 0x3e, 0xf8, 0xfc, M       0xf0, 0x01, 0xf8, 0x1f, 0x00, 0xff, 0x0f, 0x1e, 0xf0, 0x03, 0xf8, 0x3f, M       0xf8, 0xf8, 0xf0, 0x01, 0xfc, 0x1f, 0x80, 0x7f, 0x0f, 0x1e, 0xf8, 0x00, M       0xf8, 0x1f, 0x78, 0x18, 0xf0, 0x01, 0x7c, 0x1e, 0xc0, 0x0f, 0x0f, 0x1e, M       0x7c, 0x00, 0xf0, 0x0f, 0x78, 0x00, 0xf0, 0x01, 0x3e, 0x1e, 0xe0, 0x07, M       0x0f, 0x1e, 0x7c, 0x00, 0xf0, 0x07, 0x7c, 0x00, 0xe0, 0x01, 0x3e, 0x1e, M       0xe0, 0x03, 0x0f, 0x1e, 0x3e, 0x00, 0xf0, 0x0f, 0x7c, 0x00, 0xe0, 0x03, M       0x3e, 0x3e, 0xe0, 0x07, 0x0f, 0x1e, 0x1e, 0x00, 0xf0, 0x1f, 0x3c, 0x00, M       0xe0, 0x03, 0x7e, 0x3e, 0xc0, 0x3f, 0x0f, 0x1e, 0x3e, 0x00, 0xf0, 0x1f, M       0x3e, 0x00, 0xe0, 0x03, 0xfc, 0x7f, 0x80, 0xff, 0x0f, 0x1e, 0xfc, 0x00, M       0xf0, 0x3e, 0x3e, 0x00, 0xc0, 0x03, 0xf8, 0xff, 0x03, 0xff, 0x0f, 0x1e, M       0xfc, 0x07, 0xf0, 0x7c, 0x1e, 0x00, 0xc0, 0x03, 0xf8, 0xff, 0x03, 0xfc, M       0x0f, 0x1e, 0xf8, 0x1f, 0xf0, 0xf8, 0x1e, 0x00, 0xc0, 0x03, 0xe0, 0xf7, M       0x03, 0xf0, 0x0f, 0x1e, 0xe0, 0x3f, 0xf0, 0x78, 0x1c, 0x00, 0x80, 0x03, M       0x80, 0xe3, 0x03, 0x00, 0x0f, 0x1e, 0xc0, 0x3f, 0xf0, 0x30, 0x00, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0e, 0x00, 0x3e, 0x00, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x10, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0f, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, M       0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x00, 0x00, 0x00, 0xf0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, M       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 4       0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     };     int      id,      y;     register int     i;     static unsigned int      number_selections;     static XWidgetInfo+     *selection_info = (XWidgetInfo *) NULL;      unsigned int     height;      unsigned long 
     state;  
   XFontStruct      *font_info;   &   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL); '   font_info=windows->command.font_info; .   height=font_info->ascent+font_info->descent;
   id=(~0);   state=DefaultState;    if (event == (XEvent *) NULL)      {        unsigned int         width;         XTextProperty          window_name;         XWindowChanges         window_changes;          /*,         Determine command window attributes.       */1       assert(selections != (char const **) NULL);        windows->command.width=0; 4       for (i=0; selections[i] != (char *) NULL; i++)       { H         width=XTextWidth(font_info,selections[i],Extent(selections[i]));+         if (width > windows->command.width) '           windows->command.width=width;        }        number_selections=i;1       windows->command.width+=3*QuantumMargin+10; G       if ((int) windows->command.width < (tile_width+QuantumMargin+10)) ;         windows->command.width=tile_width+QuantumMargin+10;        windows->command.height=@         number_selections*(((3*height) >> 1)+10)+tile_height+20;8       windows->command.min_width=windows->command.width;:       windows->command.min_height=windows->command.height;:       XConstrainWindowPosition(display,&windows->command);/       if (windows->command.id != (Window) NULL) 	         { 
           int              status;              /*'             Reconfigure command window.            */D           status=XStringListToTextProperty(&windows->command.name,1,             &window_name);           if (status != 0)
             { C               XSetWMName(display,windows->command.id,&window_name); G               XSetWMIconName(display,windows->command.id,&window_name); 0               XFree((void *) window_name.value);
             } 6           window_changes.width=windows->command.width;8           window_changes.height=windows->command.height;;           XReconfigureWMWindow(display,windows->command.id, H             windows->command.screen,CWWidth | CWHeight,&window_changes);	         }        /*'         Allocate selection info memory.        */1       if (selection_info != (XWidgetInfo *) NULL) #         FreeMemory(selection_info); $       selection_info=(XWidgetInfo *)>         AllocateMemory(number_selections*sizeof(XWidgetInfo));1       if (selection_info == (XWidgetInfo *) NULL) 	         { O           MagickWarning(ResourceLimitWarning,"Unable to create Command Widget", (             "Memory allocation failed");           return(id); 	         } :       state|=UpdateConfigurationState | RedrawWidgetState;     }    /*     Wait for next event.   */   if (event != (XEvent *) NULL)      switch (event->type)     {        case ButtonPress:        { 3         for (i=0; i < (int) number_selections; i++) 	         { ?           if (!MatteIsActive(selection_info[i],event->xbutton))              continue; /           if (i >= (int) windows->command.data) 
             { -               selection_info[i].raised=False; O               XDrawBeveledButton(display,&windows->command,&selection_info[i]);                break;
             } )           submenu_info=selection_info[i]; #           submenu_info.active=True;            toggle_info.y=P             submenu_info.y+(submenu_info.height >> 1)-(toggle_info.height >> 1);           id=i; N           XCheckWindowEvent(display,windows->widget.id,LeaveWindowMask,event);           break;	         }          break;       }        case ButtonRelease:        { 3         for (i=0; i < (int) number_selections; i++) 	         { ?           if (!MatteIsActive(selection_info[i],event->xbutton))              continue;            id=i; 0           if (id >= (int) windows->command.data)
             { -               selection_info[id].raised=True; P               XDrawBeveledButton(display,&windows->command,&selection_info[id]);               break;
             }            break;	         }          break;       }        case ClientMessage:        { 
         /*C           If client window delete message, withdraw command widget. 
         */A         if (event->xclient.message_type != windows->wm_protocols)            break;F         if (*event->xclient.data.l != (int) windows->wm_delete_window)           break;M         XWithdrawWindow(display,windows->command.id,windows->command.screen);          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */<         if (event->xconfigure.window != windows->command.id)           break;.         if (event->xconfigure.send_event != 0)           { 3             windows->command.x=event->xconfigure.x; 3             windows->command.y=event->xconfigure.y;            } H         if ((event->xconfigure.width == (int) windows->command.width) &&H             (event->xconfigure.height == (int) windows->command.height))           break;         windows->command.width= H           Max(event->xconfigure.width,(int) windows->command.min_width);          windows->command.height=J           Max(event->xconfigure.height,(int) windows->command.min_height);(         state|=UpdateConfigurationState;         break;       }        case Expose:       { 9         if (event->xexpose.window != windows->command.id)            break;&         if (event->xexpose.count != 0)           break;!         state|=RedrawWidgetState;          break;       }        case MotionNotify:       { 
         /*6           Return the ID of the highlighted menu entry.
         */         for ( ; ; ) 	         { 5           for (i=0; i < (int) number_selections; i++)            { 1             if (i >= (int) windows->command.data)                { /                 if (selection_info[i].raised == D                     MatteIsActive(selection_info[i],event->xmotion))                   {                      /*,                       Button status changed.                     */G                     selection_info[i].raised=!selection_info[i].raised; A                     XDrawBeveledButton(display,&windows->command, *                       &selection_info[i]);                   }                  continue;                } A             if (!MatteIsActive(selection_info[i],event->xmotion))                continue; +             submenu_info=selection_info[i]; %             submenu_info.active=True; $             toggle_info.raised=True;D             toggle_info.y=submenu_info.y+(submenu_info.height >> 1)-(               (toggle_info.height >> 1);F             XDrawTriangleEast(display,&windows->command,&toggle_info);             id=i;            } &           XDelay(display,SuspendTime);?           if (!XCheckMaskEvent(display,ButtonMotionMask,event))              break;B           while (XCheckMaskEvent(display,ButtonMotionMask,event));#           toggle_info.raised=False; (           if (windows->command.data > 0)F             XDrawTriangleEast(display,&windows->command,&toggle_info);	         }          break;       }        case MapNotify:        { %         windows->command.mapped=True;          break;       }        case UnmapNotify:        { &         windows->command.mapped=False;         break;       }        default:         break;     } '   if (state & UpdateConfigurationState)      {        /*&         Initialize button information.       */1       assert(selections != (char const **) NULL);        y=tile_height+20; 1       for (i=0; i < (int) number_selections; i++)        { 9         XGetWidgetInfo(selections[i],&selection_info[i]); '         selection_info[i].center=False; (         selection_info[i].bevel_width--;1         selection_info[i].height=(3*height) >> 1; 3         selection_info[i].x=(QuantumMargin >> 1)+4;           selection_info[i].width=<           windows->command.width-(selection_info[i].x << 1);         selection_info[i].y=y;K         y+=selection_info[i].height+(selection_info[i].bevel_width << 1)+6;        } 1       XGetWidgetInfo((char *) NULL,&toggle_info);         toggle_info.bevel_width--;I       toggle_info.width=((5*height) >> 3)-(toggle_info.bevel_width << 1); +       toggle_info.height=toggle_info.width; @       toggle_info.x=selection_info[0].x+selection_info[0].width-/         toggle_info.width-(QuantumMargin >> 1); "       if (windows->command.mapped)2         XClearWindow(display,windows->command.id);     }     if (state & RedrawWidgetState)     {        Pixmap         tile_pixmap;         /*         Draw command buttons.        */J       tile_pixmap=XCreatePixmapFromBitmapData(display,windows->command.id,;         (char *) tile_bits,tile_width,tile_height,1L,0L,1); '       if (tile_pixmap != (Pixmap) NULL) 	         { =           XCopyPlane(display,tile_pixmap,windows->command.id, I             windows->command.annotate_context,0,0,tile_width,tile_height, <             (windows->command.width-tile_width) >> 1,10,1L);+           XFreePixmap(display,tile_pixmap); 	         } 1       for (i=0; i < (int) number_selections; i++)        { I         XDrawBeveledButton(display,&windows->command,&selection_info[i]); -         if (i >= (int) windows->command.data)            continue; #         toggle_info.raised=i == id; *         toggle_info.y=selection_info[i].y+D           (selection_info[i].height >> 1)-(toggle_info.height >> 1);B         XDrawTriangleEast(display,&windows->command,&toggle_info);       } L       XHighlightWidget(display,&windows->command,BorderOffset,BorderOffset);     } 
   return(id);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i r m W i d g e t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method XConfirmWidget displays a Confirm widget with a notice to the user. I %  The function returns -1 if Dismiss is pressed, 0 for Cancel, and 1 for  %  Yes.  % . %  The format of the XConfirmWidget method is: % = %      int XConfirmWidget(Display *display,XWindows *windows, 3 %        const char *message,const char *qualifier)  % + %  A description of each parameter follows:  % J %    o status:  Method XConfirmWidget returns True if the user presses Yes# %      otherwise False is returned.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */= Export int XConfirmWidget(Display *display,XWindows *windows, ,   const char *message,const char *qualifier) { " #define CancelButtonText  "Cancel"$ #define DismissButtonText  "Dismiss" #define YesButtonText  "Yes"     int      confirm,     height,      status, 
     width,     x,     y;     unsigned long 
     state;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      cancel_info,     dismiss_info, 
     yes_info;      XWindowChanges     window_changes;      /*(     Determine Confirm widget attributes.   */&   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL); #   assert(message != (char *) NULL); %   assert(qualifier != (char *) NULL); (   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;H   width=XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText));P   if (XTextWidth(font_info,DismissButtonText,Extent(DismissButtonText)) > width)L     width=XTextWidth(font_info,DismissButtonText,Extent(DismissButtonText));H   if (XTextWidth(font_info,YesButtonText,Extent(YesButtonText)) > width)D     width=XTextWidth(font_info,YesButtonText,Extent(YesButtonText));   width<<=1;!   if (qualifier != (char *) NULL) B     if (XTextWidth(font_info,qualifier,Extent(qualifier)) > width)>       width=XTextWidth(font_info,qualifier,Extent(qualifier));!   if (qualifier != (char *) NULL) B     if (XTextWidth(font_info,qualifier,Extent(qualifier)) > width)>       width=XTextWidth(font_info,qualifier,Extent(qualifier));0   height=(font_info->ascent+font_info->descent);   /*     Position Confirm widget.   */.   windows->widget.width=width+9*QuantumMargin;,   windows->widget.min_width=9*QuantumMargin+D     XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText))+F     XTextWidth(font_info,DismissButtonText,Extent(DismissButtonText))+>     XTextWidth(font_info,YesButtonText,Extent(YesButtonText));8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;#   windows->widget.height=12*height; &   windows->widget.min_height=7*height;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Confirm widget.    */0   (void) strcpy(windows->widget.name,"Confirm");I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);    if (status != 0)     { :       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     } -   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y; I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen, 4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;    /*     Respond to X events.   */   confirm=0;!   state=UpdateConfigurationState; (   XSetCursorState(display,windows,True);   do   { )     if (state & UpdateConfigurationState)        { 
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);(         cancel_info.width=QuantumMargin+J           XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText));+         cancel_info.height=(3*height) >> 1; L         cancel_info.x=windows->widget.width-cancel_info.width-QuantumMargin;G         cancel_info.y=windows->widget.height-(cancel_info.height << 1); !         dismiss_info=cancel_info; ,         dismiss_info.text=DismissButtonText;C         if (Latin1Compare(qualifier,"Do you want to save it") == 0) )           dismiss_info.text="Don't Save"; )         dismiss_info.width=QuantumMargin+ L           XTextWidth(font_info,dismiss_info.text,Extent(dismiss_info.text));N         dismiss_info.x=(windows->widget.width >> 1)-(dismiss_info.width >> 1);         yes_info=cancel_info; $         yes_info.text=YesButtonText;C         if (Latin1Compare(qualifier,"Do you want to save it") == 0)            yes_info.text="Save"; %         yes_info.width=QuantumMargin+ D           XTextWidth(font_info,yes_info.text,Extent(yes_info.text));/         if (yes_info.width < cancel_info.width) +           yes_info.width=cancel_info.width; !         yes_info.x=QuantumMargin; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*            Redraw Confirm widget.
         */<         width=XTextWidth(font_info,message,Extent(message));4         x=(windows->widget.width >> 1)-(width >> 1);6         y=(windows->widget.height >> 1)-(height << 1);P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,0           x,y,(char *) message,Extent(message));'         if (qualifier != (char *) NULL)            {              char&               question[MaxTextExtent];  .             (void) strcpy(question,qualifier);(             (void) strcat(question,"?");B             width=XTextWidth(font_info,question,Extent(question));8             x=(windows->widget.width >> 1)-(width >> 1);             y+=height;3             XDrawString(display,windows->widget.id, N               windows->widget.annotate_context,x,y,question,Extent(question));           } B         XDrawBeveledButton(display,&windows->widget,&cancel_info);C         XDrawBeveledButton(display,&windows->widget,&dismiss_info); ?         XDrawBeveledButton(display,&windows->widget,&yes_info); M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset); $         state&=(~RedrawWidgetState);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)      {        case ButtonPress:        { 5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*%               User pressed No button.              */%             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } 6         if (MatteIsActive(dismiss_info,event.xbutton))           {              /**               User pressed Dismiss button.             */&             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);              break;           } 2         if (MatteIsActive(yes_info,event.xbutton))           {              /*&               User pressed Yes button.             */"             yes_info.raised=False;C             XDrawBeveledButton(display,&windows->widget,&yes_info);              break;           }          break;       }        case ButtonRelease:        { $         if (!windows->widget.mapped)           break;          if (!cancel_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(cancel_info,event.xbutton))                  {                    confirm=0;#                   state|=ExitState;                  } $             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           } !         if (!dismiss_info.raised)            { ;             if (event.xbutton.window == windows->widget.id) <               if (MatteIsActive(dismiss_info,event.xbutton))                 {                    confirm=(-1); #                   state|=ExitState;                  } %             dismiss_info.raised=True; G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);            }          if (!yes_info.raised)            { ;             if (event.xbutton.window == windows->widget.id) 8               if (MatteIsActive(yes_info,event.xbutton))                 {                    confirm=1;#                   state|=ExitState;                  } !             yes_info.raised=True; C             XDrawBeveledButton(display,&windows->widget,&yes_info);            }          break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;B         if (*event.xclient.data.l == (int) windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } E         if (*event.xclient.data.l != (int) windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)            {              state|=ExitState;              break;           }          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;F         if ((event.xconfigure.width == (int) windows->widget.width) &&F             (event.xconfigure.height == (int) windows->widget.height))           break;         windows->widget.width=F           Max(event.xconfigure.width,(int) windows->widget.min_width);         windows->widget.height= H           Max(event.xconfigure.height,(int) windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       { 7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {          static char !           command[MaxTextExtent];            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            { "             yes_info.raised=False;C             XDrawBeveledButton(display,&windows->widget,&yes_info);              confirm=1;             state|=ExitState;              break;           }          break;       }        case LeaveNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;#         state|=InactiveWidgetState;          break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); (         if (state & InactiveWidgetState)           break;K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {              /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } M         if (dismiss_info.raised == MatteIsActive(dismiss_info,event.xmotion))            {              /*,               Dismiss button status changed.             */4             dismiss_info.raised=!cancel_info.raised;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);              break;           } E         if (yes_info.raised == MatteIsActive(yes_info,event.xmotion))            {              /*(               Yes button status changed.             */-             yes_info.raised=!yes_info.raised; C             XDrawBeveledButton(display,&windows->widget,&yes_info);              break;           }          break;       }        default:         break;     } !   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   return(confirm); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D i a l o g W i d g e t                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method XDialogWidget displays a Dialog widget with a query to the user.J %  The user keys a reply and presses the Ok or Cancel button to exit.  The: %  typed text is returned as the reply function parameter. % - %  The format of the XDialogWidget method is:  % O %      int XDialogWidget(Display *display,XWindows *windows,const char *action, ' %        const char *query,char *reply)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % @ %    o action: Specifies a pointer to the action of this widget. % F %    o query: Specifies a pointer to the query to present to the user. % G %    o reply: The response from the user is returned in this parameter.  %  %  */O Export int XDialogWidget(Display *display,XWindows *windows,const char *action,     const char *query,char *reply) { " #define CancelButtonText  "Cancel"     char%     primary_selection[MaxTextExtent];      int      height,      status, 
     width,     x;     register int     i;     static unsigned int      raised = False;      unsigned int     anomaly;     unsigned long 
     state;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      action_info,     cancel_info,     reply_info,      special_info,      text_info;     XWindowChanges     window_changes;      /*'     Determine Dialog widget attributes.    */&   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL); "   assert(action != (char *) NULL);!   assert(query != (char *) NULL); !   assert(reply != (char *) NULL); (   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;4   width=XTextWidth(font_info,action,Extent(action));N   if (XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText));    width+=(3*QuantumMargin) >> 1;.   height=font_info->ascent+font_info->descent;   /*     Position Dialog widget.    */O   windows->widget.width=Max(2*width,XTextWidth(font_info,query,Extent(query))); N   if ((int) windows->widget.width < XTextWidth(font_info,reply,Extent(reply)))D     windows->widget.width=XTextWidth(font_info,reply,Extent(reply));)   windows->widget.width+=6*QuantumMargin;    windows->widget.min_width=9     width+28*XTextWidth(font_info,"#",1)+4*QuantumMargin; 8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;7   windows->widget.height=7*height+(QuantumMargin << 1); 4   windows->widget.min_height=windows->widget.height;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Dialog widget.   *//   (void) strcpy(windows->widget.name,"Dialog"); I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);    if (status != 0)     { :       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     } -   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y; I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen, 4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;    /*     Respond to X events.   */6   anomaly=(Latin1Compare(action,"Background") == 0) ||)     (Latin1Compare(action,"New") == 0) || .     (Latin1Compare(action,"Quantize") == 0) ||,     (Latin1Compare(action,"Resize") == 0) ||*     (Latin1Compare(action,"Save") == 0) ||)     (Latin1Compare(action,"Shade") == 0); !   state=UpdateConfigurationState; (   XSetCursorState(display,windows,True);   do   { )     if (state & UpdateConfigurationState)        { 
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1;          cancel_info.x=K           windows->widget.width-cancel_info.width-((3*QuantumMargin) >> 1);          cancel_info.y=M           windows->widget.height-cancel_info.height-((3*QuantumMargin) >> 1); ,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; E         action_info.x=cancel_info.x-(cancel_info.width+QuantumMargin+ *           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;
         /*'           Initialize reply information. 
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--; A         reply_info.width=windows->widget.width-(3*QuantumMargin); &         reply_info.height=height << 1;,         reply_info.x=(3*QuantumMargin) >> 1;C         reply_info.y=action_info.y-reply_info.height-QuantumMargin; 
         /*(           Initialize option information.
         *//         XGetWidgetInfo("Dither",&special_info); #         special_info.raised=raised; #         special_info.bevel_width--; .         special_info.width=QuantumMargin >> 1;/         special_info.height=QuantumMargin >> 1; $         special_info.x=reply_info.x;L         special_info.y=action_info.y+action_info.height-special_info.height;4         if (Latin1Compare(action,"Background") == 0)'           special_info.text="Backdrop"; -         if (Latin1Compare(action,"New") == 0) (           special_info.text="Gradation";0         if (Latin1Compare(action,"Resize") == 0).           special_info.text="Constrain ratio";.         if (Latin1Compare(action,"Save") == 0).           special_info.text="Non-progressive";/         if (Latin1Compare(action,"Shade") == 0) ,           special_info.text="Color shading";
         /*&           Initialize text information.
         */)         XGetWidgetInfo(query,&text_info); )         text_info.width=reply_info.width;           text_info.height=height;6         text_info.x=reply_info.x-(QuantumMargin >> 1);"         text_info.y=QuantumMargin;         text_info.center=False; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*           Redraw Dialog widget.M
         */=         XDrawWidgetText(display,&windows->widget,&text_info); @         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info);          if (anomaly)E           XDrawBeveledButton(display,&windows->widget,&special_info); B         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset); $         state&=(~RedrawWidgetState);       }p     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);j     switch (event.type)i     {        case ButtonPress:        {          if (anomaly)8           if (MatteIsActive(special_info,event.xbutton))
             {i               /*-                 Option button status changed.l               */7               special_info.raised=!special_info.raised; I               XDrawBeveledButton(display,&windows->widget,&special_info);                break;
             } 5         if (MatteIsActive(action_info,event.xbutton))o           {t             /*)               User pressed Action button.r             */%             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }a5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*)               User pressed Cancel button.              */%             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } 5         if (!MatteIsActive(reply_info,event.xbutton)),           break;,         if (event.xbutton.button != Button2)           {n             static Time                click_time;h               /*;               Move text cursor to position of button press.I             */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);:             for (i=1; i <= Extent(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;e             else               {a                 /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text);iI                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id,i&                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;t               }fA             XDrawMatteText(display,&windows->widget,&reply_info);t*             click_time=event.xbutton.time;             break;           }8
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING,x1           windows->widget.id,event.xbutton.time);n         break;       }i       case ButtonRelease:        { $         if (!windows->widget.mapped)           break;          if (!action_info.raised)           { ;             if (event.xbutton.window == windows->widget.id)o;               if (MatteIsActive(action_info,event.xbutton)) !                 state|=ExitState;a$             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }a          if (!cancel_info.raised)           {,;             if (event.xbutton.window == windows->widget.id)r;               if (MatteIsActive(cancel_info,event.xbutton))n                 {n(                   *reply_info.text='\0';#                   state|=ExitState;.                 } $             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }g         break;       }l       case ClientMessage:n       {t
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;B         if (*event.xclient.data.l == (int) windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } E         if (*event.xclient.data.l != (int) windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)            { "             *reply_info.text='\0';             state|=ExitState;              break;           }          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;F         if ((event.xconfigure.width == (int) windows->widget.width) &&F             (event.xconfigure.height == (int) windows->widget.height))           break;         windows->widget.width=F           Max(event.xconfigure.width,(int) windows->widget.min_width);         windows->widget.height=mH           Max(event.xconfigure.height,(int) windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }o       case EnterNotify:a       {d9         if (event.xcrossing.window != windows->widget.id)t           break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       {l7         if (event.xexpose.window != windows->widget.id)s           break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;t         break;       }s       case KeyPress:       {d         static char !           command[MaxTextExtent];b           static int           length;v           static KeySymd           key_symbol;y  4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),w/           &key_symbol,(XComposeStatus *) NULL);4         *(command+length)='\0';.E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))s           {n%             action_info.raised=False;nF             XDrawBeveledButton(display,&windows->widget,&action_info);             state|=ExitState;              break;           }r'         if (key_symbol == XK_Control_L)0           {o              state|=ControlState;             break;           }.!         if (state & ControlState)h           switch (key_symbol)h           {4             case XK_u:             case XK_U:
             {5               /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;i               break;
             }              default:               break;           }%@         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info);          break;       }        case KeyRelease:       {          static char !           command[MaxTextExtent];            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); '         if (key_symbol == XK_Control_L) !           state&=(~ControlState);%         break;       }%       case LeaveNotify:        {D9         if (event.xcrossing.window != windows->widget.id)d           break;#         state|=InactiveWidgetState;T         break;       }a       case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));n(         if (state & InactiveWidgetState)           break;K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {_             /*+               Action button status changed.              */3             action_info.raised=!action_info.raised; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }pK         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {,             /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }>         break;       }e       case SelectionClear:       {>#         reply_info.highlight=False;b=         XDrawMatteText(display,&windows->widget,&reply_info);t         break;       }e       case SelectionNotify:-       {_         Atom           type;e           intw           format;c           unsigned char-           *data;           unsigned longu           after,           length;p  
         /*1           Obtain response from primary selection.o
         */5         if (event.xselection.property == (Atom) None)l           break;E         status=XGetWindowProperty(display,event.xselection.requestor,uJ           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||t             (length == 0))           break;>         if ((Extent(reply_info.text)+length) >= MaxTextExtent)           XBell(display,0);o         else           {u             /*5               Insert primary selection in reply text.t             */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,                state);_A             XDrawMatteText(display,&windows->widget,&reply_info);w           }t         XFree((void *) data);          break;       }-       case SelectionRequest:       {          XSelectionEvent(           notify;,           XSelectionRequestEvent           *request;n  "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest));tN         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           Extent(primary_selection)); $         notify.type=SelectionNotify;(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;F         (void) XSendEvent(request->display,request->requestor,False,0,           (XEvent *) &notify);       }        default:         break;     } !   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   if (anomaly)     if (special_info.raised)       if (*reply != '\0')          raised=True;   return(!raised); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             %tO %                                                                             % O %                                                                             % O %   X F i l e B r o w s e r W i d g e t                                       %MO %                                                                             %oO %                                                                             % O %                                                                             %XO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%f %tM %  Method XFileBrowserWidget displays a File Browser widget with a file queryiN %  to the user.  The user keys a reply and presses the Action or Cancel buttonH %  to exit.  The typed text is returned as the reply function parameter. %y2 %  The format of the XFileBrowserWidget method is: %_B %      void XFileBrowserWidget(Display *display,XWindows *windows,( %        const char *action,char *reply) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % @ %    o action: Specifies a pointer to the action of this widget. % G %    o reply: The response from the user is returned in this parameter.  %  %  */B Export void XFileBrowserWidget(Display *display,XWindows *windows,!   const char *action,char *reply)  { " #define CancelButtonText  "Cancel"# #define DirectoryText  "Directory:" " #define FilenameText  "File name:" #define GrabButtonText  "Grab"" #define FormatButtonText  "Format" #define HomeButtonText  "Home" #define UpButtonText  "Up"     static const chare     *ImageOutputFormats[]=     {i       "avs",       "bie",       "bmp",       "bmp24",
       "cmyk",r       "dcx",       "eps",
       "epsf", 
       "epsi",c       "fax",
       "fits",y       "fpx",       "gif",       "gif87",
       "gray",o       "g3",        "hdf",       "histogram",
       "html",e
       "jbig",m
       "jpeg",i       "jpg",       "map",       "matte",
       "miff",a
       "mono",        "mpg",       "mtv",       "pbm",       "pcl",       "pcx",       "pdf",       "pgm",
       "pict",d       "png",       "ppm",       "pnm",       "ps",        "psd",       "ps2",       "ras",       "rgb",       "rle",       "sgi",       "shtml",       "sun",       "tga",
       "tiff",t       "uil",
       "uyvy",_       "vid",
       "viff",t
       "x",       "xbm",       "xpm",       "xv",o       "xwd",       "yuv",
       "yuv3",f       (char *) NULL_     };     char     **filelist,e"     home_directory[MaxTextExtent],%     primary_selection[MaxTextExtent],>     text[MaxTextExtent],%     working_directory[MaxTextExtent];      int 
     files,     height,%     status,%     text_width,%
     width,     x,     y;     register int     i;  
   static char &     glob_pattern[MaxTextExtent] = "*",#     format[MaxTextExtent] = "miff";   
   static char *     mask = CWWidth | CWHeight | CWX | CWY;     unsigned int     anomaly,     visible_files;     unsigned long 
     delay,
     state;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      action_info,     cancel_info,     expose_info,     special_info,      list_info,     home_info,     north_info,      reply_info,      scroll_info,     selection_info,%     slider_info,     south_info,%     text_info,     up_info;     XWindowChanges     window_changes;s     /*)     Read filelist from current directory.t   */&   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL); "   assert(action != (char *) NULL);!   assert(reply != (char *) NULL);T(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);0   (void) getcwd(home_directory,MaxTextExtent-1);2   (void) strcpy(working_directory,home_directory);<   filelist=ListFiles(working_directory,glob_pattern,&files);!   if (filelist == (char **) NULL)_     {p       /*         Directory read failed.       */@       XNoticeWidget(display,windows,"Unable to read directory:",         working_directory);aK       (void) XDialogWidget(display,windows,action,"Enter filename:",reply);h
       return;      }    /*-     Determine File Browser widget attributes.    */&   font_info=windows->widget.font_info;   text_width=0;    for (i=0; i < files; i++) K     if (XTextWidth(font_info,filelist[i],Extent(filelist[i])) > text_width)lG       text_width=XTextWidth(font_info,filelist[i],Extent(filelist[i]));n4   width=XTextWidth(font_info,action,Extent(action));J   if (XTextWidth(font_info,GrabButtonText,Extent(GrabButtonText)) > width)F     width=XTextWidth(font_info,GrabButtonText,Extent(GrabButtonText));N   if (XTextWidth(font_info,FormatButtonText,Extent(FormatButtonText)) > width)J     width=XTextWidth(font_info,FormatButtonText,Extent(FormatButtonText));N   if (XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText));J   if (XTextWidth(font_info,HomeButtonText,Extent(HomeButtonText)) > width)F     width=XTextWidth(font_info,HomeButtonText,Extent(HomeButtonText));F   if (XTextWidth(font_info,UpButtonText,Extent(UpButtonText)) > width)B     width=XTextWidth(font_info,UpButtonText,Extent(UpButtonText));   width+=QuantumMargin;=H   if (XTextWidth(font_info,DirectoryText,Extent(DirectoryText)) > width)D     width=XTextWidth(font_info,DirectoryText,Extent(DirectoryText));F   if (XTextWidth(font_info,FilenameText,Extent(FilenameText)) > width)B     width=XTextWidth(font_info,FilenameText,Extent(FilenameText));.   height=font_info->ascent+font_info->descent;   /*!     Position File Browser widget.+   */K   windows->widget.width=width+Min(text_width,MaxTextWidth)+6*QuantumMargin;r?   windows->widget.min_width=width+MinTextWidth+4*QuantumMargin;a8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;H   windows->widget.height=((81*height) >> 2)+((13*QuantumMargin) >> 1)+4;L   windows->widget.min_height=((23*height) >> 1)+((13*QuantumMargin) >> 1)+4;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XConstrainWindowPosition(display,&windows->widget);i   /*     Map File Browser widget.   */A   (void) strcpy(windows->widget.name,"Browse and Select a File");0I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);_   if (status != 0)     {f:       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     }n-   window_changes.width=windows->widget.width;t/   window_changes.height=windows->widget.height;,%   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y;iN   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,mask,     &window_changes);l)   XMapRaised(display,windows->widget.id);x   windows->widget.mapped=False;(   /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info);D,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_files=0;5   anomaly=(Latin1Compare(action,"Composite") == 0) ||%N     (Latin1Compare(action,"Open") == 0) || (Latin1Compare(action,"Map") == 0);   delay=SuspendTime << 2; !   state=UpdateConfigurationState;    do   { )     if (state & UpdateConfigurationState)        {          int 
           id;   
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1; N         cancel_info.x=windows->widget.width-cancel_info.width-QuantumMargin-2;N         cancel_info.y=windows->widget.height-cancel_info.height-QuantumMargin;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1;iL         action_info.x=cancel_info.x-(cancel_info.width+(QuantumMargin >> 1)+*           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;5         XGetWidgetInfo(GrabButtonText,&special_info);d!         special_info.width=width; ,         special_info.height=(3*height) >> 1;M         special_info.x=action_info.x-(action_info.width+(QuantumMargin >> 1)+ +           (special_info.bevel_width << 1));_%         special_info.y=action_info.y;d         if (!anomaly)            {l             register char                *p;r  /             special_info.text=FormatButtonText;i$             p=reply+Extent(reply)-1;6             while ((p > (reply+1)) && (*(p-1) != '.'))               p--;3             if ((p > (reply+1)) && (*(p-1) == '.')) &               (void) strcpy(format,p);           }d.         XGetWidgetInfo(UpButtonText,&up_info);         up_info.width=width;'         up_info.height=(3*height) >> 1;.          up_info.x=QuantumMargin;2         up_info.y=((5*QuantumMargin) >> 1)+height;2         XGetWidgetInfo(HomeButtonText,&home_info);         home_info.width=width;)         home_info.height=(3*height) >> 1;f"         home_info.x=QuantumMargin;;         home_info.y=up_info.y+up_info.height+QuantumMargin; 
         /*'           Initialize reply information.3
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--;wN         reply_info.width=windows->widget.width-width-((6*QuantumMargin) >> 1);&         reply_info.height=height << 1;0         reply_info.x=width+(QuantumMargin << 1);C         reply_info.y=action_info.y-reply_info.height-QuantumMargin;l
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info);n"         scroll_info.bevel_width--;!         scroll_info.width=height;>G         scroll_info.height=reply_info.y-up_info.y-(QuantumMargin >> 1);LH         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);7         scroll_info.y=up_info.y-reply_info.bevel_width; !         scroll_info.raised=False;o          scroll_info.trough=True;         north_info=scroll_info;t         north_info.raised=True;i8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1;o-         north_info.x+=north_info.bevel_width;v-         north_info.y+=north_info.bevel_width;1         south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;o         slider_info.id=id;         slider_info.width-=2;iP         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height=aJ           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;M         visible_files=(scroll_info.height-(height >> 3)-3)/((9*height) >> 3);d(         if (files > (int) visible_files)F           slider_info.height=(visible_files*slider_info.height)/files;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);          list_info.raised=False;           list_info.bevel_width--;H         list_info.width=scroll_info.x-reply_info.x-(QuantumMargin >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x; "         list_info.y=scroll_info.y;$         if (!windows->widget.mapped)           state|=JumpListState; 
         /*&           Initialize text information.
         */         *text='\0'; (         XGetWidgetInfo(text,&text_info);         text_info.center=False;%)         text_info.width=reply_info.width;%          text_info.height=height;5         text_info.x=list_info.x-(QuantumMargin >> 1);b"         text_info.y=QuantumMargin;
         /*+           Initialize selection information. 
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width;p.         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x;y+         state&=(~UpdateConfigurationState);a       } "     if (state & RedrawWidgetState)       {1
         /*%           Redraw File Browser window. 
         */         x=QuantumMargin;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent;tP         XDrawString(display,windows->widget.id,windows->widget.annotate_context,3           x,y,DirectoryText,Extent(DirectoryText));1N         FormatString(text_info.text,"%.1024s%.1024s%.1024s",working_directory,+           DirectorySeparator,glob_pattern); =         XDrawWidgetText(display,&windows->widget,&text_info);i>         XDrawBeveledButton(display,&windows->widget,&up_info);@         XDrawBeveledButton(display,&windows->widget,&home_info);?         XDrawBeveledMatte(display,&windows->widget,&list_info);-A         XDrawBeveledMatte(display,&windows->widget,&scroll_info);=A         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);>         x=QuantumMargin;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent; P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,1           x,y,FilenameText,Extent(FilenameText));2@         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info);;C         XDrawBeveledButton(display,&windows->widget,&special_info);pB         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);d         selection_info.id=(~0);s         state|=RedrawListState;e$         state&=(~RedrawWidgetState);       }n      if (state & UpdateListState)       {w         char           **checklist;           int            number_files;i  
         /*           Update file list. 
         */J         checklist=ListFiles(working_directory,glob_pattern,&number_files);(         if (checklist == (char **) NULL)           {              /*(               Reply is a filename, exit.             */%             action_info.raised=False;>F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }t!         for (i=0; i < files; i++)%"           FreeMemory(filelist[i]);'         if (filelist != (char **) NULL)            FreeMemory(filelist);          filelist=checklist;          files=number_files; 
         /*           Update file list. 
         */         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+1;(         if (files > (int) visible_files)F           slider_info.height=(visible_files*slider_info.height)/files;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;         slider_info.id=0; (         slider_info.y=slider_info.min_y;$         expose_info.y=slider_info.y;         selection_info.id=(~0);%         list_info.id=(~0);         state|=RedrawListState;T
         /*(           Redraw directory name & reply.
         */%         if (!IsGlob(reply_info.text))            {n"             *reply_info.text='\0';.             reply_info.cursor=reply_info.text;           }iN         FormatString(text_info.text,"%.1024s%.1024s%.1024s",working_directory,+           DirectorySeparator,glob_pattern); =         XDrawWidgetText(display,&windows->widget,&text_info);t=         XDrawMatteText(display,&windows->widget,&reply_info);fA         XDrawBeveledMatte(display,&windows->widget,&scroll_info);_A         XDrawTriangleNorth(display,&windows->widget,&north_info);cB         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);oM         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset); "         state&=(~UpdateListState);       }      if (state & JumpListState)       {;
         /*-           Jump scroll to match user filename.o
         */         list_info.id=(~0);!         for (i=0; i < files; i++)>4           if (Latin1Compare(filelist[i],reply) >= 0)
             {oJ               list_info.id=Latin1Compare(filelist[i],reply) == 0 ? i : ~0;               break;
             } P         if ((i < slider_info.id) || (i >= (int) (slider_info.id+visible_files)))0           slider_info.id=i-(visible_files >> 1);         selection_info.id=(~0);          state|=RedrawListState;>          state&=(~JumpListState);       }       if (state & RedrawListState)       {w
         /*+           Determine slider id and position. 
         */:         if (slider_info.id >= (int) (files-visible_files))-           slider_info.id=files-visible_files;=C         if ((slider_info.id < 0) || (files <= (int) visible_files))s           slider_info.id=0;o(         slider_info.y=slider_info.min_y;         if (files > 0)           slider_info.y+= I             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/files;.0         if (slider_info.id != selection_info.id)           {=             /*/               Redraw scroll bar and file names.3             */-             selection_info.id=slider_info.id;h9             selection_info.y=list_info.y+(height >> 3)+2;i3             for (i=0; i < (int) visible_files; i++)n
             {nG               selection_info.raised=(slider_info.id+i) != list_info.id;r0               selection_info.text=(char *) NULL;-               if ((slider_info.id+i) < files)2?                 selection_info.text=filelist[slider_info.id+i];3H               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             }>             /*               Update slider.             */.             if (slider_info.y > expose_info.y)               {i?                 expose_info.height=slider_info.y-expose_info.y;%?                 expose_info.y=slider_info.y-expose_info.height- ,                   slider_info.bevel_width-1;               }              else               { ?                 expose_info.height=expose_info.y-slider_info.y; ?                 expose_info.y=slider_info.y+slider_info.height+ ,                   slider_info.bevel_width+1;               } E             XDrawTriangleNorth(display,&windows->widget,&north_info); >             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info);%(             expose_info.y=slider_info.y;           } "         state&=(~RedrawListState);       }w     /*       Wait for next event.     *//     if (north_info.raised && south_info.raised)w=       XIfEvent(display,&event,XScreenEvent,(char *) windows);g     else       { 
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised) !           if (slider_info.id > 0)t
             {                /*                 Move slider up.n               */               slider_info.id--;T%               state|=RedrawListState;*
             }          if (!south_info.raised)C%           if (slider_info.id < files),
             {n               /*!                 Move slider down.                */               slider_info.id++; %               state|=RedrawListState; 
             }t(         if (event.type != ButtonRelease)           continue;        }a     switch (event.type)t     {o       case ButtonPress:        {-5         if (MatteIsActive(slider_info,event.xbutton))            {e             /*               Track slider.i             */$             slider_info.active=True;             break;           }e4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0) 
             {(               /*                 Move slider up.                */&               north_info.raised=False;               slider_info.id--;f%               state|=RedrawListState;o               break;
             }x4         if (MatteIsActive(south_info,event.xbutton))%           if (slider_info.id < files)x
             {t               /*!                 Move slider down.i               */&               south_info.raised=False;               slider_info.id++;;%               state|=RedrawListState;t               break;
             } 5         if (MatteIsActive(scroll_info,event.xbutton))e           {o             /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)0               slider_info.id-=(visible_files-1);             else0               slider_info.id+=(visible_files-1);#             state|=RedrawListState;x             break;           }d3         if (MatteIsActive(list_info,event.xbutton))            {n             unsigned int               id;t               /*&               User pressed file matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;"             if ((int) id >= files)               break;8             (void) strcpy(reply_info.text,filelist[id]);'             reply_info.highlight=False; .             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+Extent(reply_info.text);A             XDrawMatteText(display,&windows->widget,&reply_info); )             if ((int) id == list_info.id)                { A                 (void) strcpy(working_directory,reply_info.text); '                 state|=UpdateListState;                } #             selection_info.id=(~0);%             list_info.id=id;#             state|=RedrawListState;%             break;           } 1         if (MatteIsActive(up_info,event.xbutton))            {f             /*%               User pressed Up button.e             */!             up_info.raised=False; B             XDrawBeveledButton(display,&windows->widget,&up_info);             break;           };3         if (MatteIsActive(home_info,event.xbutton))x           {f             /*'               User pressed Home button.n             */#             home_info.raised=False;:D             XDrawBeveledButton(display,&windows->widget,&home_info);             break;           }A6         if (MatteIsActive(special_info,event.xbutton))           {i             /**               User pressed Special button.             */&             special_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&special_info);,             break;           }a5         if (MatteIsActive(action_info,event.xbutton))k           {a             /*)               User pressed action button.              */%             action_info.raised=False;nF             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } 5         if (MatteIsActive(cancel_info,event.xbutton))            {g             /*)               User pressed Cancel button.r             */%             cancel_info.raised=False;nF             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }f5         if (!MatteIsActive(reply_info,event.xbutton))            break;,         if (event.xbutton.button != Button2)           {:             static Time                click_time;l               /*;               Move text cursor to position of button press.;             */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);:             for (i=1; i <= Extent(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;t             else               {t                 /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); I                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id, &                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;i               } A             XDrawMatteText(display,&windows->widget,&reply_info);-*             click_time=event.xbutton.time;             break;           } 
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING,(1           windows->widget.id,event.xbutton.time);          break;       }        case ButtonRelease:        { $         if (!windows->widget.mapped)           break;         if (!north_info.raised)+           {              /*&               User released up button.             */#             delay=SuspendTime << 2;%#             north_info.raised=True; E             XDrawTriangleNorth(display,&windows->widget,&north_info);            }          if (!south_info.raised)            {              /*(               User released down button.             */#             delay=SuspendTime << 2; #             south_info.raised=True; E             XDrawTriangleSouth(display,&windows->widget,&south_info);            }          if (slider_info.active)            {              /*#               Stop tracking slider.              */%             slider_info.active=False;              break;           }%         if (!up_info.raised)           {%;             if (event.xbutton.window == windows->widget.id)i7               if (MatteIsActive(up_info,event.xbutton))                  {f8                   (void) strcpy(working_directory,"..");)                   state|=UpdateListState;f                 }o              up_info.raised=True;B             XDrawBeveledButton(display,&windows->widget,&up_info);           }i         if (!home_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) 9               if (MatteIsActive(home_info,event.xbutton))i                 {iB                   (void) strcpy(working_directory,home_directory);)                   state|=UpdateListState;y                 }-"             home_info.raised=True;D             XDrawBeveledButton(display,&windows->widget,&home_info);           }=!         if (!special_info.raised);           {f             if (!anomaly)g               {a                 /*/                   Let user select image format.                  */9                 XDefineCursor(display,windows->widget.id,)/                   windows->widget.busy_cursor);%6                 windows->popup.x=windows->widget.x+60;6                 windows->popup.y=windows->widget.y+60;C                 XListBrowserWidget(display,windows,&windows->popup, J                   ImageOutputFormats,"Select","Select image format type:",                   format);6                 XSetCursorState(display,windows,True);9                 XDefineCursor(display,windows->widget.id, *                   windows->widget.cursor);:                 AppendImageFormat(format,reply_info.text);J                 reply_info.cursor=reply_info.text+Extent(reply_info.text);E                 XDrawMatteText(display,&windows->widget,&reply_info);%)                 special_info.raised=True;%K                 XDrawBeveledButton(display,&windows->widget,&special_info);w                 break;               }h;             if (event.xbutton.window == windows->widget.id)d<               if (MatteIsActive(special_info,event.xbutton))                 {y6                   (void) strcpy(reply_info.text,"x:");#                   state|=ExitState;                  }c%             special_info.raised=True;rG             XDrawBeveledButton(display,&windows->widget,&special_info);f           }           if (!action_info.raised)           {n;             if (event.xbutton.window == windows->widget.id)d               { =                 if (MatteIsActive(action_info,event.xbutton))o                   { 1                     if (*reply_info.text == '\0')w'                       XBell(display,0);S                     else'                       state|=ExitState;w                   }_               }e$             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }n          if (!cancel_info.raised)           {w;             if (event.xbutton.window == windows->widget.id)C;               if (MatteIsActive(cancel_info,event.xbutton))n                 {_(                   *reply_info.text='\0';#                   state|=ExitState;i                 }S$             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }%         break;       }%       case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;B         if (*event.xclient.data.l == (int) windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } E         if (*event.xclient.data.l != (int) windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)            {%"             *reply_info.text='\0';             state|=ExitState;%             break;           }t         break;       }t       case ConfigureNotify:        {d
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;F         if ((event.xconfigure.width == (int) windows->widget.width) &&F             (event.xconfigure.height == (int) windows->widget.height))           break;         windows->widget.width=F           Max(event.xconfigure.width,(int) windows->widget.min_width);         windows->widget.height=uH           Max(event.xconfigure.height,(int) windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }w       case EnterNotify:i       {d9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       {y7         if (event.xexpose.window != windows->widget.id)u           break;%         if (event.xexpose.count != 0).           break;!         state|=RedrawWidgetState;          break;       }p       case KeyPress:       {          static char !           command[MaxTextExtent];            static int           length;v           static KeySyme           key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),n/           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; 1         if (AreaIsActive(scroll_info,event.xkey))x           {              /*               Move slider.             */             switch (key_symbol) 
             {;               case XK_Home:-               case XK_KP_Home:               { !                 slider_info.id=0;                  break;               }                case XK_Up:k               case XK_KP_Up:               { !                 slider_info.id--;v                 break;               }d               case XK_Down:e               case XK_KP_Down:               {o!                 slider_info.id++;o                 break;               }                case XK_Prior:               case XK_KP_Prior:                { .                 slider_info.id-=visible_files;                 break;               }-               case XK_Next:F               case XK_KP_Next:               {n.                 slider_info.id+=visible_files;                 break;               }                case XK_End:               case XK_KP_End:n               {e%                 slider_info.id=files;;                 break;               }e
             }|#             state|=RedrawListState;              break;           }%E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            {              /*1               Read new directory or glob patterm.              */)             if (*reply_info.text == '\0')                break;(             if (IsGlob(reply_info.text)):               (void) strcpy(glob_pattern,reply_info.text);             else               { A                 (void) strcpy(working_directory,reply_info.text); .                 if (*working_directory == '~')4                   ExpandFilename(working_directory);               } #             state|=UpdateListState;              break;           }%'         if (key_symbol == XK_Control_L)%           {%              state|=ControlState;             break;           }o!         if (state & ControlState)r           switch (key_symbol)X           {              case XK_u:             case XK_U:
             {s               /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;o               break;
             }o             default:               break;           }c@         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info);e         state|=JumpListState;h         break;       }m       case KeyRelease:       {          static charn!           command[MaxTextExtent];d           static KeySymg           key_symbol;B  4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),t/           &key_symbol,(XComposeStatus *) NULL);i'         if (key_symbol == XK_Control_L)l!           state&=(~ControlState);          break;       }d       case LeaveNotify:t       { 9         if (event.xcrossing.window != windows->widget.id)l           break;#         state|=InactiveWidgetState;p         break;       }r       case MapNotify:        {e         mask&=(~CWX);n         mask&=(~CWY);          break;       }i       case MotionNotify:       { 
         /*/           Discard pending button motion events.%
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));          if (slider_info.active)            {              /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0; 3             if (slider_info.y != slider_info.min_y) I               slider_info.id=(files*(slider_info.y-slider_info.min_y+1))/%8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;T             break;           }u(         if (state & InactiveWidgetState)           break;C         if (up_info.raised == MatteIsActive(up_info,event.xmotion))d           {f             /*'               Up button status changed.              */+             up_info.raised=!up_info.raised;eB             XDrawBeveledButton(display,&windows->widget,&up_info);             break;           } G         if (home_info.raised == MatteIsActive(home_info,event.xmotion))W           {n             /*)               Home button status changed.i             *//             home_info.raised=!home_info.raised; D             XDrawBeveledButton(display,&windows->widget,&home_info);             break;           }iM         if (special_info.raised == MatteIsActive(special_info,event.xmotion))l           {o             /*)               Grab button status changed.f             */5             special_info.raised=!special_info.raised;sG             XDrawBeveledButton(display,&windows->widget,&special_info);e             break;           }SK         if (action_info.raised == MatteIsActive(action_info,event.xmotion))l           {c             /*+               Action button status changed.%             */3             action_info.raised=!action_info.raised; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {              /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }          break;       }        case SelectionClear:       { #         reply_info.highlight=False; =         XDrawMatteText(display,&windows->widget,&reply_info);%         break;       }%       case SelectionNotify:o       {e         Atom           type;x           inte           format;a           unsigned charn           *data;           unsigned longy           after,           length;p  
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)a           break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||n             (length == 0))           break;>         if ((Extent(reply_info.text)+length) >= MaxTextExtent)           XBell(display,0);          else           {h             /*5               Insert primary selection in reply text.l             */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,l               state);cA             XDrawMatteText(display,&windows->widget,&reply_info); !             state|=JumpListState;o%             state|=RedrawActionState;f           }_         XFree((void *) data);t         break;       }_       case SelectionRequest:       {u         XSelectionEventx           notify;t           XSelectionRequestEvent           *request;   "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest));oN         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           Extent(primary_selection)); $         notify.type=SelectionNotify;(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;F         (void) XSendEvent(request->display,request->requestor,False,0,           (XEvent *) &notify);       }%       default:         break;     }%!   } while (!(state & ExitState));r)   XSetCursorState(display,windows,False);eE   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);s(   XCheckRefreshWindows(display,windows);   /*     Free file list.d   */   for (i=0; i < files; i++)      FreeMemory(filelist[i]);!   if (filelist != (char **) NULL)      FreeMemory(filelist);(   if (*reply == '~')     ExpandFilename(reply); }c   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             %.O %                                                                             %tO %                                                                             %pO %   X F o n t B r o w s e r W i d g e t                                       %rO %                                                                             %pO %                                                                             %fO %                                                                             %tO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%] % M %  Method XFontBrowserWidget displays a Font Browser widget with a font queryoN %  to the user.  The user keys a reply and presses the Action or Cancel buttonH %  to exit.  The typed text is returned as the reply function parameter. % 2 %  The format of the XFontBrowserWidget method is: % B %      void XFontBrowserWidget(Display *display,XWindows *windows,( %        const char *action,char *reply) %o+ %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %c; %    o window: Specifies a pointer to a XWindows structure.  %o@ %    o action: Specifies a pointer to the action of this widget. %cG %    o reply: The response from the user is returned in this parameter.  %t %f */  3 static int FontCompare(const void *x,const void *y)e {o   register char      *p,i     *q;      p=(char *) *((char **) x);   q=(char *) *((char **) y);4   while ((*p != '\0') && (*q != '\0') && (*p == *q))   {L     p++;     q++;   }a   return(*p-(*q)); }s  B Export void XFontBrowserWidget(Display *display,XWindows *windows,!   const char *action,char *reply)* {  #define BackButtonText  "Back"" #define CancelButtonText  "Cancel" #define FontnameText  "Name:" # #define FontPatternText  "Pattern:"l  #define ResetButtonText  "Reset"     char      back_pattern[MaxTextExtent],     **fontlist,_     **listhead, %     primary_selection[MaxTextExtent],)!     reset_pattern[MaxTextExtent],e     text[MaxTextExtent];     int 
     fonts,     height,      status,e     text_width,v
     width,     x,     y;     register int     i;  
   static char &     glob_pattern[MaxTextExtent] = "*";  
   static char**     mask = CWWidth | CWHeight | CWX | CWY;     unsigned int     visible_fonts;     unsigned longt
     delay,
     state;     XEvent
     event;  
   XFontStruct_     *font_info;,     XTextProperty)     window_name;  
   XWidgetInfoX     action_info,     back_info,     cancel_info,     expose_info,     list_info,     mode_info,     north_info,T     reply_info,o     reset_info,,     scroll_info,     selection_info,      slider_info,     south_info,t     text_info;     XWindowChanges     window_changes;_     /*.     Get font list and sort in ascending order.   */&   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL);d"   assert(action != (char *) NULL);!   assert(reply != (char *) NULL);=(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);+   (void) strcpy(back_pattern,glob_pattern);x#   (void) strcpy(reset_pattern,"*"); 9   fontlist=XListFonts(display,glob_pattern,32767,&fonts);r   if (fonts == 0)f     {W       /*-         Pattern failed, obtain all the fonts.t       */D       XNoticeWidget(display,windows,"Unable to obtain fonts names:",         glob_pattern);&       (void) strcpy(glob_pattern,"*");=       fontlist=XListFonts(display,glob_pattern,32767,&fonts);t%       if (fontlist == (char **) NULL) 	         {wH           XNoticeWidget(display,windows,"Unable to obtain fonts names:",             glob_pattern);           return;w	         }i     }d   /*&     Sort font list in ascending order.   */   listhead=fontlist;;   fontlist=(char **) AllocateMemory(fonts*sizeof(char **));g!   if (fontlist == (char **) NULL)+     {f<       XNoticeWidget(display,windows,"Unable to view fonts:",$         "Memory allocation failed");
       return;C     }n   for (i=0; i < fonts; i++)w     fontlist[i]=listhead[i];0   qsort((void *) fontlist,fonts,sizeof(char **),7     (int (*)(const void *, const void *)) FontCompare);t   /*-     Determine Font Browser widget attributes.w   */&   font_info=windows->widget.font_info;   text_width=0;w   for (i=0; i < fonts; i++)eK     if (XTextWidth(font_info,fontlist[i],Extent(fontlist[i])) > text_width)eG       text_width=XTextWidth(font_info,fontlist[i],Extent(fontlist[i]));i4   width=XTextWidth(font_info,action,Extent(action));N   if (XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText));L   if (XTextWidth(font_info,ResetButtonText,Extent(ResetButtonText)) > width)H     width=XTextWidth(font_info,ResetButtonText,Extent(ResetButtonText));J   if (XTextWidth(font_info,BackButtonText,Extent(BackButtonText)) > width)F     width=XTextWidth(font_info,BackButtonText,Extent(BackButtonText));   width+=QuantumMargin;uL   if (XTextWidth(font_info,FontPatternText,Extent(FontPatternText)) > width)H     width=XTextWidth(font_info,FontPatternText,Extent(FontPatternText));F   if (XTextWidth(font_info,FontnameText,Extent(FontnameText)) > width)B     width=XTextWidth(font_info,FontnameText,Extent(FontnameText));.   height=font_info->ascent+font_info->descent;   /*!     Position Font Browser widget.w   */K   windows->widget.width=width+Min(text_width,MaxTextWidth)+6*QuantumMargin;w?   windows->widget.min_width=width+MinTextWidth+4*QuantumMargin;t8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;H   windows->widget.height=((85*height) >> 2)+((13*QuantumMargin) >> 1)+4;L   windows->widget.min_height=((27*height) >> 1)+((13*QuantumMargin) >> 1)+4;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Font Browser widget.   */A   (void) strcpy(windows->widget.name,"Browse and Select a Font"); I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);    if (status != 0)     {g:       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     }_-   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height;w%   window_changes.x=windows->widget.x;a%   window_changes.y=windows->widget.y;hN   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,mask,     &window_changes);y)   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;o   /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info);e,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_fonts=0;   delay=SuspendTime << 2;.!   state=UpdateConfigurationState;    do   {=)     if (state & UpdateConfigurationState)i       {          int 
           id;e  
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1;bN         cancel_info.x=windows->widget.width-cancel_info.width-QuantumMargin-2;N         cancel_info.y=windows->widget.height-cancel_info.height-QuantumMargin;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1;nL         action_info.x=cancel_info.x-(cancel_info.width+(QuantumMargin >> 1)+*           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;2         XGetWidgetInfo(BackButtonText,&back_info);         back_info.width=width;)         back_info.height=(3*height) >> 1;s"         back_info.x=QuantumMargin;4         back_info.y=((5*QuantumMargin) >> 1)+height;4         XGetWidgetInfo(ResetButtonText,&reset_info);         reset_info.width=width;r*         reset_info.height=(3*height) >> 1;#         reset_info.x=QuantumMargin;i@         reset_info.y=back_info.y+back_info.height+QuantumMargin;
         /*'           Initialize reply information.i
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--;)N         reply_info.width=windows->widget.width-width-((6*QuantumMargin) >> 1);&         reply_info.height=height << 1;0         reply_info.x=width+(QuantumMargin << 1);K         reply_info.y=action_info.y-(action_info.height << 1)-QuantumMargin;f
         /*&           Initialize mode information.
         */)         XGetWidgetInfo(reply,&mode_info);=          mode_info.bevel_width=0;A         mode_info.width=action_info.x-reply_info.x-QuantumMargin;.1         mode_info.height=action_info.height << 1;&!         mode_info.x=reply_info.x;sM         mode_info.y=action_info.y-action_info.height+action_info.bevel_width;f
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info); "         scroll_info.bevel_width--;!         scroll_info.width=height;eI         scroll_info.height=reply_info.y-back_info.y-(QuantumMargin >> 1); H         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);9         scroll_info.y=back_info.y-reply_info.bevel_width;e!         scroll_info.raised=False;           scroll_info.trough=True;         north_info=scroll_info;a         north_info.raised=True;i8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1;i-         north_info.x+=north_info.bevel_width; -         north_info.y+=north_info.bevel_width;o         south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;t         slider_info.id=id;         slider_info.width-=2;rP         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height=aJ           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;         visible_fonts=A           (scroll_info.height-(height >> 3)-3)/((9*height) >> 3);p(         if (fonts > (int) visible_fonts)F           slider_info.height=(visible_fonts*slider_info.height)/fonts;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);l         list_info.raised=False;           list_info.bevel_width--;H         list_info.width=scroll_info.x-reply_info.x-(QuantumMargin >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x; "         list_info.y=scroll_info.y;$         if (!windows->widget.mapped)           state|=JumpListState;l
         /*&           Initialize text information.
         */         *text='\0';a(         XGetWidgetInfo(text,&text_info);         text_info.center=False;d)         text_info.width=reply_info.width;o          text_info.height=height;5         text_info.x=list_info.x-(QuantumMargin >> 1); "         text_info.y=QuantumMargin;
         /*+           Initialize selection information.e
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width; .         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x;l+         state&=(~UpdateConfigurationState);        }s"     if (state & RedrawWidgetState)       {c
         /*%           Redraw Font Browser window. 
         */         x=QuantumMargin;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent; P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,7           x,y,FontPatternText,Extent(FontPatternText));-<         FormatString(text_info.text,"%.1024s",glob_pattern);=         XDrawWidgetText(display,&windows->widget,&text_info);l@         XDrawBeveledButton(display,&windows->widget,&back_info);A         XDrawBeveledButton(display,&windows->widget,&reset_info);r?         XDrawBeveledMatte(display,&windows->widget,&list_info); A         XDrawBeveledMatte(display,&windows->widget,&scroll_info); A         XDrawTriangleNorth(display,&windows->widget,&north_info);(B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);          x=QuantumMargin;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent; P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,1           x,y,FontnameText,Extent(FontnameText));d@         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info); B         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);|         selection_info.id=(~0); !         state|=RedrawActionState;          state|=RedrawListState;e$         state&=(~RedrawWidgetState);       }t      if (state & UpdateListState)       {%         char           **checklist;           inta           number_fonts;i  
         /*           Update font list.d
         */G         checklist=XListFonts(display,glob_pattern,32767,&number_fonts);l(         if (checklist == (char **) NULL)           {w>             if ((strchr(glob_pattern,'*') == (char *) NULL) &&<                 (strchr(glob_pattern,'?') == (char *) NULL))               {s                 /*3                   Might be a scaleable font-- exit.s                 */2                 (void) strcpy(reply,glob_pattern);9                 (void) strcpy(glob_pattern,back_pattern);u)                 action_info.raised=False; J                 XDrawBeveledButton(display,&windows->widget,&action_info);                 break;               } 5             (void) strcpy(glob_pattern,back_pattern);a             XBell(display,0);            }          else            if (number_fonts == 1)
             {)               /*3                 Reply is a single font name-- exit.                */0               (void) strcpy(reply,checklist[0]);7               (void) strcpy(glob_pattern,back_pattern);t(               XFreeFontNames(checklist);'               action_info.raised=False; H               XDrawBeveledButton(display,&windows->widget,&action_info);               break;
             }l           else
             {f'               XFreeFontNames(listhead);(#               FreeMemory(fontlist);n!               fontlist=checklist;d!               fonts=number_fonts;.
             }i
         /*,           Sort font list in ascending order.
         */         listhead=fontlist;A         fontlist=(char **) AllocateMemory(fonts*sizeof(char **)); '         if (fontlist == (char **) NULL)            { B             XNoticeWidget(display,windows,"Unable to view fonts:",*               "Memory allocation failed");             return;o           }y!         for (i=0; i < fonts; i++) "           fontlist[i]=listhead[i];6         qsort((void *) fontlist,fonts,sizeof(char **),=           (int (*)(const void *, const void *)) FontCompare);o         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+1;(         if (fonts > (int) visible_fonts)F           slider_info.height=(visible_fonts*slider_info.height)/fonts;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;         slider_info.id=0; (         slider_info.y=slider_info.min_y;$         expose_info.y=slider_info.y;         selection_info.id=(~0);y         list_info.id=(~0);         state|=RedrawListState;-
         /*#           Redraw font name & reply.f
         */         *reply_info.text='\0';*         reply_info.cursor=reply_info.text;<         FormatString(text_info.text,"%.1024s",glob_pattern);=         XDrawWidgetText(display,&windows->widget,&text_info); =         XDrawMatteText(display,&windows->widget,&reply_info); A         XDrawBeveledMatte(display,&windows->widget,&scroll_info); A         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info); M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);s"         state&=(~UpdateListState);       }i     if (state & JumpListState)       { 
         /*)           Jump scroll to match user font. 
         */         list_info.id=(~0);!         for (i=0; i < fonts; i++)o4           if (Latin1Compare(fontlist[i],reply) >= 0)
             {lJ               list_info.id=Latin1Compare(fontlist[i],reply) == 0 ? i : ~0;               break;
             }rP         if ((i < slider_info.id) || (i >= (int) (slider_info.id+visible_fonts)))0           slider_info.id=i-(visible_fonts >> 1);         selection_info.id=(~0);w         state|=RedrawListState;c          state&=(~JumpListState);       }       if (state & RedrawListState)       {0
         /*+           Determine slider id and position.-
         */:         if (slider_info.id >= (int) (fonts-visible_fonts))-           slider_info.id=fonts-visible_fonts;>C         if ((slider_info.id < 0) || (fonts <= (int) visible_fonts))s           slider_info.id=0;n(         slider_info.y=slider_info.min_y;         if (fonts > 0)           slider_info.y+=aI             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/fonts;n0         if (slider_info.id != selection_info.id)           {,             /*/               Redraw scroll bar and file names.              */-             selection_info.id=slider_info.id; 9             selection_info.y=list_info.y+(height >> 3)+2; 3             for (i=0; i < (int) visible_fonts; i++)a
             { G               selection_info.raised=(slider_info.id+i) != list_info.id; 0               selection_info.text=(char *) NULL;-               if ((slider_info.id+i) < fonts)l?                 selection_info.text=fontlist[slider_info.id+i]; H               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             }              /*               Update slider.             */.             if (slider_info.y > expose_info.y)               {y?                 expose_info.height=slider_info.y-expose_info.y;(?                 expose_info.y=slider_info.y-expose_info.height- ,                   slider_info.bevel_width-1;               }              else               {l?                 expose_info.height=expose_info.y-slider_info.y; ?                 expose_info.y=slider_info.y+slider_info.height+o,                   slider_info.bevel_width+1;               } E             XDrawTriangleNorth(display,&windows->widget,&north_info); >             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info);)(             expose_info.y=slider_info.y;           } "         state&=(~RedrawListState);       }e"     if (state & RedrawActionState)       {t         XFontStruct            *save_info;f  
         /*6           Display the selected font in a drawing area.
         */,         save_info=windows->widget.font_info;:         font_info=XLoadQueryFont(display,reply_info.text);.         if (font_info != (XFontStruct *) NULL)           { 1             windows->widget.font_info=font_info;;sL             XSetFont(display,windows->widget.widget_context,font_info->fid);           } @         XDrawBeveledButton(display,&windows->widget,&mode_info);,         windows->widget.font_info=save_info;.         if (font_info != (XFontStruct *) NULL)           { <             XSetFont(display,windows->widget.widget_context,.               windows->widget.font_info->fid);)             XFreeFont(display,font_info);1           } M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset); =         XDrawMatteText(display,&windows->widget,&reply_info);[$         state&=(~RedrawActionState);       }      /*       Wait for next event.     *//     if (north_info.raised && south_info.raised)x=       XIfEvent(display,&event,XScreenEvent,(char *) windows);&     else       {p
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised) !           if (slider_info.id > 0) 
             {i               /*                 Move slider up.                */               slider_info.id--;A%               state|=RedrawListState; 
             }          if (!south_info.raised)d%           if (slider_info.id < fonts) 
             {a               /*!                 Move slider down.&               */               slider_info.id++; %               state|=RedrawListState;e
             }x(         if (event.type != ButtonRelease)           continue;s       }b     switch (event.type)      {        case ButtonPress:;       { 5         if (MatteIsActive(slider_info,event.xbutton))i           {              /*               Track slider.I             */$             slider_info.active=True;             break;           }e4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0)e
             {                /*                 Move slider up.                */&               north_info.raised=False;               slider_info.id--;n%               state|=RedrawListState;o               break;
             },4         if (MatteIsActive(south_info,event.xbutton))%           if (slider_info.id < fonts)t
             {                /*!                 Move slider down..               */&               south_info.raised=False;               slider_info.id++;a%               state|=RedrawListState;t               break;
             } 5         if (MatteIsActive(scroll_info,event.xbutton))t           {              /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)0               slider_info.id-=(visible_fonts-1);             else0               slider_info.id+=(visible_fonts-1);#             state|=RedrawListState;r             break;           } 3         if (MatteIsActive(list_info,event.xbutton))            {v             unsigned int               id;n               /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;"             if ((int) id >= fonts)               break;8             (void) strcpy(reply_info.text,fontlist[id]);'             reply_info.highlight=False;o.             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+Extent(reply_info.text);A             XDrawMatteText(display,&windows->widget,&reply_info);;%             state|=RedrawActionState;n)             if ((int) id == list_info.id)o               {i<                 (void) strcpy(glob_pattern,reply_info.text);'                 state|=UpdateListState;                } #             selection_info.id=(~0);e             list_info.id=id;#             state|=RedrawListState;r             break;           } 3         if (MatteIsActive(back_info,event.xbutton))R           {d             /*'               User pressed Back button.              */#             back_info.raised=False;aD             XDrawBeveledButton(display,&windows->widget,&back_info);             break;           }d4         if (MatteIsActive(reset_info,event.xbutton))           {t             /*(               User pressed Reset button.             */$             reset_info.raised=False;E             XDrawBeveledButton(display,&windows->widget,&reset_info);              break;           }u5         if (MatteIsActive(action_info,event.xbutton))o           {              /*)               User pressed action button.a             */%             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } 5         if (MatteIsActive(cancel_info,event.xbutton))T           {d             /*)               User pressed Cancel button.              */%             cancel_info.raised=False;*F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } 5         if (!MatteIsActive(reply_info,event.xbutton))S           break;,         if (event.xbutton.button != Button2)           {r             static Time                click_time;                /*;               Move text cursor to position of button press.l             */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);:             for (i=1; i <= Extent(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;e             else               {m                 /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text);yI                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id, &                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;                } A             XDrawMatteText(display,&windows->widget,&reply_info);f*             click_time=event.xbutton.time;             break;           } 
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING,_1           windows->widget.id,event.xbutton.time);d         break;       }r       case ButtonRelease:        {f$         if (!windows->widget.mapped)           break;         if (!north_info.raised)d           {              /*&               User released up button.             */#             delay=SuspendTime << 2; #             north_info.raised=True;'E             XDrawTriangleNorth(display,&windows->widget,&north_info);            }          if (!south_info.raised)            {              /*(               User released down button.             */#             delay=SuspendTime << 2;e#             south_info.raised=True; E             XDrawTriangleSouth(display,&windows->widget,&south_info);.           }d         if (slider_info.active)f           {v             /*#               Stop tracking slider.              */%             slider_info.active=False;              break;           }          if (!back_info.raised)           { ;             if (event.xbutton.window == windows->widget.id)e9               if (MatteIsActive(back_info,event.xbutton))f                 { ;                   (void) strcpy(glob_pattern,back_pattern);M)                   state|=UpdateListState;f                 }t"             back_info.raised=True;D             XDrawBeveledButton(display,&windows->widget,&back_info);           }          if (!reset_info.raised)n           {m;             if (event.xbutton.window == windows->widget.id)y:               if (MatteIsActive(reset_info,event.xbutton))                 { ;                   (void) strcpy(back_pattern,glob_pattern);t<                   (void) strcpy(glob_pattern,reset_pattern);)                   state|=UpdateListState;w                 } #             reset_info.raised=True;tE             XDrawBeveledButton(display,&windows->widget,&reset_info);            }a          if (!action_info.raised)           { ;             if (event.xbutton.window == windows->widget.id)                {f=                 if (MatteIsActive(action_info,event.xbutton))a                   {t1                     if (*reply_info.text == '\0')&'                       XBell(display,0);                      else'                       state|=ExitState;w                   }                }i$             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }           if (!cancel_info.raised)           {d;             if (event.xbutton.window == windows->widget.id)E;               if (MatteIsActive(cancel_info,event.xbutton))                  { (                   *reply_info.text='\0';#                   state|=ExitState;                  }p$             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }          break;       }        case ClientMessage:S       { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;B         if (*event.xclient.data.l == (int) windows->wm_take_focus)           {=G             XSetInputFocus(display,event.xclient.window,RevertToParent,a'               event.xclient.data.l[1]);g             break;           }vE         if (*event.xclient.data.l != (int) windows->wm_delete_window)u           break;7         if (event.xclient.window == windows->widget.id)r           {t"             *reply_info.text='\0';             state|=ExitState;              break;           }h         break;       }        case ConfigureNotify:o       { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;F         if ((event.xconfigure.width == (int) windows->widget.width) &&F             (event.xconfigure.height == (int) windows->widget.height))           break;         windows->widget.width=F           Max(event.xconfigure.width,(int) windows->widget.min_width);         windows->widget.height= H           Max(event.xconfigure.height,(int) windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       { 7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }a       case KeyPress:       {          static chark!           command[MaxTextExtent];b           static int           length;            static KeySyme           key_symbol;t  4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0';t1         if (AreaIsActive(scroll_info,event.xkey))(           {o             /*               Move slider.             */             switch (key_symbol)a
             {                case XK_Home:                case XK_KP_Home:               { !                 slider_info.id=0;i                 break;               }c               case XK_Up:                case XK_KP_Up:               { !                 slider_info.id--;l                 break;               }                case XK_Down:                case XK_KP_Down:               {i!                 slider_info.id++;d                 break;               }&               case XK_Prior:               case XK_KP_Prior:                {a.                 slider_info.id-=visible_fonts;                 break;               }                case XK_Next:                case XK_KP_Next:               { .                 slider_info.id+=visible_fonts;                 break;               }x               case XK_End:               case XK_KP_End:                {v%                 slider_info.id=fonts;                  break;               }e
             } #             state|=RedrawListState;i             break;           }vE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))u           {              /*,               Read new font or glob patterm.             */)             if (*reply_info.text == '\0')o               break;5             (void) strcpy(back_pattern,glob_pattern); 8             (void) strcpy(glob_pattern,reply_info.text);#             state|=UpdateListState;p             break;           }='         if (key_symbol == XK_Control_L)            {               state|=ControlState;             break;           }r!         if (state & ControlState)            switch (key_symbol)M           {l             case XK_u:             case XK_U:
             {                /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;d               break;
             }              default:               break;           } @         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info);          state|=JumpListState;d         break;       }_       case KeyRelease:       {n         static charm!           command[MaxTextExtent];L           static KeySymr           key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); '         if (key_symbol == XK_Control_L)d!           state&=(~ControlState);          break;       }        case LeaveNotify:e       {e9         if (event.xcrossing.window != windows->widget.id)            break;#         state|=InactiveWidgetState;          break;       }e       case MapNotify:i       {d         mask&=(~CWX);v         mask&=(~CWY);d         break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events.v
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));s         if (slider_info.active)            {i             /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0;-3             if (slider_info.y != slider_info.min_y) I               slider_info.id=(fonts*(slider_info.y-slider_info.min_y+1))/ 8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;              break;           }e(         if (state & InactiveWidgetState)           break;G         if (back_info.raised == MatteIsActive(back_info,event.xmotion))            {              /*)               Back button status changed.              *//             back_info.raised=!back_info.raised; D             XDrawBeveledButton(display,&windows->widget,&back_info);             break;           }WI         if (reset_info.raised == MatteIsActive(reset_info,event.xmotion))i           {L             /**               Reset button status changed.             */1             reset_info.raised=!reset_info.raised;|E             XDrawBeveledButton(display,&windows->widget,&reset_info);              break;           }lK         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {              /*+               Action button status changed.              */3             action_info.raised=!action_info.raised;TF             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }eK         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))e           {              /*+               Cancel button status changed.i             */3             cancel_info.raised=!cancel_info.raised; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }e         break;       }y       case SelectionClear:       { #         reply_info.highlight=False;t=         XDrawMatteText(display,&windows->widget,&reply_info);          break;       }(       case SelectionNotify:u       {u         Atom           type;s           intp           format;e           unsigned charo           *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection.>
         */5         if (event.xselection.property == (Atom) None)i           break;E         status=XGetWindowProperty(display,event.xselection.requestor,tJ           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||n             (length == 0))           break;>         if ((Extent(reply_info.text)+length) >= MaxTextExtent)           XBell(display,0);          else           {a             /*5               Insert primary selection in reply text.i             */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,                state); A             XDrawMatteText(display,&windows->widget,&reply_info);N!             state|=JumpListState; %             state|=RedrawActionState;-           })         XFree((void *) data);s         break;       }o       case SelectionRequest:       {l         XSelectionEvent            notify;t           XSelectionRequestEvent           *request;:  
         /*#           Set XA_PRIMARY selection. 
         */-         request=(&(event.xselectionrequest));%N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           Extent(primary_selection)); $         notify.type=SelectionNotify;(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;F         (void) XSendEvent(request->display,request->requestor,False,0,           (XEvent *) &notify);       }g       default:         break;     }p!   } while (!(state & ExitState));b)   XSetCursorState(display,windows,False);eE   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);l(   XCheckRefreshWindows(display,windows);   /*     Free font list.t   */   XFreeFontNames(listhead);r   FreeMemory(fontlist);  }s c /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %XO %                                                                             % O %                                                                             % O %   X I n f o W i d g e t                                                     %vO %                                                                             %wO %                                                                             %dO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %xJ %  Method XInfoWidget displays text in the Info widget.  The purpose is toH %  inform the user that what activity is currently being performed (e.g.. %  reading an image, rotating an image, etc.). %x+ %  The format of the XInfoWidget method is:0 %xP %      void XInfoWidget(Display *display,XWindows *windows,const char *activity) %x+ %  A description of each parameter follows:  %0E %    o display: Specifies a connection to an X server;  returned fromx %      XOpenDisplay. %x; %    o window: Specifies a pointer to a XWindows structure.0 % K %    o activity: This character string reflects the current activity and is $ %      displayed in the Info widget. %c %x */P Export void XInfoWidget(Display *display,XWindows *windows,const char *activity) {    intx     height,f
     width;     unsigned int     margin;0  
   XFontStructe     *font_info;f     XWindowChanges     window_changes;x     /*     Map Info widget.   */&   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL);0$   assert(activity != (char *) NULL);$   font_info=windows->info.font_info;   width=O     XTextWidth(font_info,activity,Extent(activity))+((3*QuantumMargin) >> 1)+4; =   height=((6*(font_info->ascent+font_info->descent)) >> 2)+4;x-   if (((int) windows->info.width != width) || -       ((int) windows->info.height != height))      {        /*:         Size Info widget to accommodate the activity text.       */        windows->info.width=width;"       windows->info.height=height;!       window_changes.width=width;x#       window_changes.height=height;0I       XReconfigureWMWindow(display,windows->info.id,windows->info.screen, ,         CWWidth | CWHeight,&window_changes);     }0   if (!windows->info.mapped)     { +       XMapRaised(display,windows->info.id);x        windows->info.mapped=True;     }    /*&     Initialize Info matte information.   */.   height=font_info->ascent+font_info->descent;)   XGetWidgetInfo(activity,&monitor_info);8   monitor_info.bevel_width--;0I   margin=monitor_info.bevel_width+((windows->info.height-height) >> 1)-2;    monitor_info.center=False;   monitor_info.x=margin;   monitor_info.y=margin;7   monitor_info.width=windows->info.width-(margin << 1); ;   monitor_info.height=windows->info.height-(margin << 1)+1;    /*     Draw Info widget.0   */   monitor_info.raised=False;:   XDrawBeveledMatte(display,&windows->info,&monitor_info);   monitor_info.raised=True;x8   XDrawWidgetText(display,&windows->info,&monitor_info); }x   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %xO %                                                                             %1O %                                                                             % O %   X L i s t B r o w s e r W i d g e t                                       %xO %                                                                             %0O %                                                                             % O %                                                                             %xO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%0 %xK %  Method XListBrowserWidget displays a List Browser widget with a query to N %  the user.  The user keys a reply or select a reply from the list.  Finally,K %  the user presses the Action or Cancel button to exit.  The typed text is0, %  returned as the reply function parameter. %02 %  The format of the XListBrowserWidget method is: %0B %      void XListBrowserWidget(Display *display,XWindows *windows,G %        XWindowInfo *window_info,char const **list,const char *action, ' %        const char *query,char *reply)0 %x+ %  A description of each parameter follows:0 %xE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %x; %    o window: Specifies a pointer to a XWindows structure.x % F %    o list: Specifies a pointer to an array of strings.  The user can; %      select from these strings as a possible reply value.  %f@ %    o action: Specifies a pointer to the action of this widget. % F %    o query: Specifies a pointer to the query to present to the user. %xG %    o reply: The response from the user is returned in this parameter.x %  %3 */B Export void XListBrowserWidget(Display *display,XWindows *windows,@   XWindowInfo *window_info,char const **list,const char *action,    const char *query,char *reply) { " #define CancelButtonText  "Cancel"     char%     primary_selection[MaxTextExtent];      inte     entries,     height,x     status,0     text_width,e
     width,     x;  
   static chare*     mask = CWWidth | CWHeight | CWX | CWY;     register int     i;     unsigned int     visible_entries;     unsigned long 
     delay,
     state;     XEvent
     event;  
   XFontStruct0     *font_info;x     XTextProperty3     window_name;  
   XWidgetInfoe     action_info,     cancel_info,     expose_info,     list_info,     north_info,      reply_info,c     scroll_info,     selection_info,x     slider_info,     south_info,      text_info;     XWindowChanges     window_changes;3     /*,     Count the number of entries in the list.   */&   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL);0.   assert(window_info != (XWindowInfo *) NULL);'   assert(list != (char const **) NULL);x"   assert(action != (char *) NULL);!   assert(query != (char *) NULL); !   assert(reply != (char *) NULL); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);#   if (list == (char const **) NULL)0     { H       XNoticeWidget(display,windows,"No text to browse:",(char *) NULL);
       return;0     }    for (entries=0; ; entries++)'     if (list[entries] == (char *) NULL)        break;   /*-     Determine Font Browser widget attributes.    */#   font_info=window_info->font_info; 7   text_width=XTextWidth(font_info,query,Extent(query));0   for (i=0; i < entries; i++)0C     if (XTextWidth(font_info,list[i],Extent(list[i])) > text_width) ?       text_width=XTextWidth(font_info,list[i],Extent(list[i])); 4   width=XTextWidth(font_info,action,Extent(action));N   if (XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText));   width+=QuantumMargin; .   height=font_info->ascent+font_info->descent;   /*!     Position List Browser widget.    */K   window_info->width=Min(text_width,MaxTextWidth)+((9*QuantumMargin) >> 1); 6   window_info->min_width=MinTextWidth+4*QuantumMargin;2   if (window_info->width < window_info->min_width).     window_info->width=window_info->min_width;E   window_info->height=((81*height) >> 2)+((13*QuantumMargin) >> 1)+4;>I   window_info->min_height=((23*height) >> 1)+((13*QuantumMargin) >> 1)+4; 4   if (window_info->height < window_info->min_height)0     window_info->height=window_info->min_height;0   XConstrainWindowPosition(display,window_info);   /*     Map List Browser widget.   */,   (void) strcpy(window_info->name,"Browse");F   status=XStringListToTextProperty(&window_info->name,1,&window_name);   if (status != 0)     {s7       XSetWMName(display,window_info->id,&window_name);W>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     }d*   window_changes.width=window_info->width;,   window_changes.height=window_info->height;"   window_changes.x=window_info->x;"   window_changes.y=window_info->y;H   XReconfigureWMWindow(display,window_info->id,window_info->screen,mask,     &window_changes); &   XMapRaised(display,window_info->id);   window_info->mapped=False;   /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info); ,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_entries=0;   delay=SuspendTime << 2;i!   state=UpdateConfigurationState;    do   { )     if (state & UpdateConfigurationState)        {e         intm
           id;   
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1;.K         cancel_info.x=window_info->width-cancel_info.width-QuantumMargin-2;&K         cancel_info.y=window_info->height-cancel_info.height-QuantumMargin; ,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; L         action_info.x=cancel_info.x-(cancel_info.width+(QuantumMargin >> 1)+*           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;
         /*'           Initialize reply information.e
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--;lE         reply_info.width=window_info->width-((4*QuantumMargin) >> 1);o&         reply_info.height=height << 1;#         reply_info.x=QuantumMargin;eC         reply_info.y=action_info.y-reply_info.height-QuantumMargin; 
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info); "         scroll_info.bevel_width--;!         scroll_info.width=height;UH         scroll_info.height=reply_info.y-((6*QuantumMargin) >> 1)-height;H         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);M         scroll_info.y=((5*QuantumMargin) >> 1)+height-reply_info.bevel_width;e!         scroll_info.raised=False;s          scroll_info.trough=True;         north_info=scroll_info;a         north_info.raised=True;B8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1; -         north_info.x+=north_info.bevel_width; -         north_info.y+=north_info.bevel_width;f         south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;          slider_info.id=id;         slider_info.width-=2;aP         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;         visible_entries=A           (scroll_info.height-(height >> 3)-3)/((9*height) >> 3);D,         if (entries > (int) visible_entries)J           slider_info.height=(visible_entries*slider_info.height)/entries;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);i         list_info.raised=False;           list_info.bevel_width--;H         list_info.width=scroll_info.x-reply_info.x-(QuantumMargin >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x; "         list_info.y=scroll_info.y;!         if (!window_info->mapped) %           for (i=0; i < entries; i++)e2             if (Latin1Compare(list[i],reply) == 0)               {y                 list_info.id=i;e8                 slider_info.id=i-(visible_entries >> 1);'                 if (slider_info.id < 0)(#                   slider_info.id=0;                } 
         /*&           Initialize text information.
         */)         XGetWidgetInfo(query,&text_info); )         text_info.width=reply_info.width;v          text_info.height=height;5         text_info.x=list_info.x-(QuantumMargin >> 1);a"         text_info.y=QuantumMargin;
         /*+           Initialize selection information.e
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width; .         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x;I+         state&=(~UpdateConfigurationState);        }o"     if (state & RedrawWidgetState)       { 
         /*%           Redraw List Browser window. 
         */8         XDrawWidgetText(display,window_info,&text_info);:         XDrawBeveledMatte(display,window_info,&list_info);<         XDrawBeveledMatte(display,window_info,&scroll_info);<         XDrawTriangleNorth(display,window_info,&north_info);=         XDrawBeveledButton(display,window_info,&slider_info); <         XDrawTriangleSouth(display,window_info,&south_info);;         XDrawBeveledMatte(display,window_info,&reply_info); 8         XDrawMatteText(display,window_info,&reply_info);=         XDrawBeveledButton(display,window_info,&action_info); =         XDrawBeveledButton(display,window_info,&cancel_info); H         XHighlightWidget(display,window_info,BorderOffset,BorderOffset);         selection_info.id=(~0); !         state|=RedrawActionState;;         state|=RedrawListState;n$         state&=(~RedrawWidgetState);       }       if (state & RedrawListState)       { 
         /*+           Determine slider id and position.;
         */>         if (slider_info.id >= (int) (entries-visible_entries))1           slider_info.id=entries-visible_entries;MG         if ((slider_info.id < 0) || (entries <= (int) visible_entries))y           slider_info.id=0; (         slider_info.y=slider_info.min_y;         if (entries > 0)           slider_info.y+=TK             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/entries;a0         if (slider_info.id != selection_info.id)           {-             /*/               Redraw scroll bar and file names.p             */-             selection_info.id=slider_info.id; 9             selection_info.y=list_info.y+(height >> 3)+2; 5             for (i=0; i < (int) visible_entries; i++) 
             {nG               selection_info.raised=(slider_info.id+i) != list_info.id;c0               selection_info.text=(char *) NULL;/               if ((slider_info.id+i) < entries) D                 selection_info.text=(char *) list[slider_info.id+i];C               XDrawWidgetText(display,window_info,&selection_info);_<               selection_info.y+=(int) selection_info.height;
             }o             /*               Update slider.             */.             if (slider_info.y > expose_info.y)               {<?                 expose_info.height=slider_info.y-expose_info.y;]?                 expose_info.y=slider_info.y-expose_info.height- ,                   slider_info.bevel_width-1;               }.             else               {i?                 expose_info.height=expose_info.y-slider_info.y;g?                 expose_info.y=slider_info.y+slider_info.height+_,                   slider_info.bevel_width+1;               }Q@             XDrawTriangleNorth(display,window_info,&north_info);9             XDrawMatte(display,window_info,&expose_info);tA             XDrawBeveledButton(display,window_info,&slider_info);;@             XDrawTriangleSouth(display,window_info,&south_info);(             expose_info.y=slider_info.y;           }m"         state&=(~RedrawListState);       }t     /*       Wait for next event.     *//     if (north_info.raised && south_info.raised)p=       XIfEvent(display,&event,XScreenEvent,(char *) windows);i     else       {t
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised)v!           if (slider_info.id > 0)d
             {o               /*                 Move slider up.a               */               slider_info.id--;d%               state|=RedrawListState;t
             }          if (!south_info.raised)h'           if (slider_info.id < entries) 
             {E               /*!                 Move slider down.                */               slider_info.id++;B%               state|=RedrawListState;e
             } (         if (event.type != ButtonRelease)           continue;%       }%     switch (event.type)      {        case ButtonPress:        { 5         if (MatteIsActive(slider_info,event.xbutton))            {              /*               Track slider.              */$             slider_info.active=True;             break;           } 4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */&               north_info.raised=False;               slider_info.id--; %               state|=RedrawListState;                break;
             }%4         if (MatteIsActive(south_info,event.xbutton))'           if (slider_info.id < entries)g
             {o               /*!                 Move slider down.t               */&               south_info.raised=False;               slider_info.id++; %               state|=RedrawListState;                break;
             }l5         if (MatteIsActive(scroll_info,event.xbutton))n           {i             /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)2               slider_info.id-=(visible_entries-1);             else2               slider_info.id+=(visible_entries-1);#             state|=RedrawListState;a             break;           }a3         if (MatteIsActive(list_info,event.xbutton))e           {h             unsigned int               id;                /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;$             if ((int) id >= entries)               break;4             (void) strcpy(reply_info.text,list[id]);'             reply_info.highlight=False; .             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+Extent(reply_info.text);<             XDrawMatteText(display,window_info,&reply_info);#             selection_info.id=(~0);s)             if ((int) id == list_info.id)s               {g)                 action_info.raised=False;aE                 XDrawBeveledButton(display,window_info,&action_info);o!                 state|=ExitState;t               }              list_info.id=id;#             state|=RedrawListState;W             break;           }i5         if (MatteIsActive(action_info,event.xbutton))_           {t             /*)               User pressed action button.n             */%             action_info.raised=False;)A             XDrawBeveledButton(display,window_info,&action_info);t             break;           }_5         if (MatteIsActive(cancel_info,event.xbutton))            {d             /*)               User pressed Cancel button.<             */%             cancel_info.raised=False;WA             XDrawBeveledButton(display,window_info,&cancel_info);T             break;           }n5         if (!MatteIsActive(reply_info,event.xbutton))            break;,         if (event.xbutton.button != Button2)           {T             static Timei               click_time;e               /*;               Move text cursor to position of button press..             */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);:             for (i=1; i <= Extent(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;i             else               {-                 /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text);iF                 XSetSelectionOwner(display,XA_PRIMARY,window_info->id,&                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) =="                   window_info->id;               }t<             XDrawMatteText(display,window_info,&reply_info);*             click_time=event.xbutton.time;             break;           }e
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING,d.           window_info->id,event.xbutton.time);         break;       }a       case ButtonRelease:        {i!         if (!window_info->mapped)t           break;         if (!north_info.raised)t           {&             /*&               User released up button.             */#             delay=SuspendTime << 2;p#             north_info.raised=True; @             XDrawTriangleNorth(display,window_info,&north_info);           }          if (!south_info.raised)o           {a             /*(               User released down button.             */#             delay=SuspendTime << 2;B#             south_info.raised=True;c@             XDrawTriangleSouth(display,window_info,&south_info);           }x         if (slider_info.active)            {e             /*#               Stop tracking slider.-             */%             slider_info.active=False;              break;           }g          if (!action_info.raised)           {_8             if (event.xbutton.window == window_info->id)               {f=                 if (MatteIsActive(action_info,event.xbutton))                    {x1                     if (*reply_info.text == '\0')m'                       XBell(display,0);d                     else'                       state|=ExitState;x                   }t               }i$             action_info.raised=True;A             XDrawBeveledButton(display,window_info,&action_info);1           }f          if (!cancel_info.raised)           { 8             if (event.xbutton.window == window_info->id);               if (MatteIsActive(cancel_info,event.xbutton))_                 { (                   *reply_info.text='\0';#                   state|=ExitState;o                 }e$             cancel_info.raised=True;A             XDrawBeveledButton(display,window_info,&cancel_info);i           } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;         break;       }o       case ClientMessage:        {=
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;B         if (*event.xclient.data.l == (int) windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           }iE         if (*event.xclient.data.l != (int) windows->wm_delete_window)W           break;4         if (event.xclient.window == window_info->id)           {)"             *reply_info.text='\0';             state|=ExitState;p             break;           }          break;       }o       case ConfigureNotify:e       {o
         /*&           Update widget configuration.
         */7         if (event.xconfigure.window != window_info->id)y           break;C         if ((event.xconfigure.width == (int) window_info->width) &&,C             (event.xconfigure.height == (int) window_info->height))r           break;         window_info->width=WC           Max(event.xconfigure.width,(int) window_info->min_width);          window_info->height=E           Max(event.xconfigure.height,(int) window_info->min_height);a(         state|=UpdateConfigurationState;         break;       }v       case EnterNotify:        { 6         if (event.xcrossing.window != window_info->id)           break;&         state&=(~InactiveWidgetState);         break;       }s       case Expose:       {_4         if (event.xexpose.window != window_info->id)           break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;t         break;       }        case KeyPress:       {s         static charB!           command[MaxTextExtent];e           static int           length;            static KeySyma           key_symbol;e  1         if (event.xkey.window != window_info->id)            break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; 1         if (AreaIsActive(scroll_info,event.xkey))r           {              /*               Move slider.             */             switch (key_symbol)e
             {                case XK_Home:l               case XK_KP_Home:               { !                 slider_info.id=0;                  break;               }                case XK_Up:.               case XK_KP_Up:               {s!                 slider_info.id--;;                 break;               }.               case XK_Down:                case XK_KP_Down:               {.!                 slider_info.id++;v                 break;               }                case XK_Prior:               case XK_KP_Prior:t               { 0                 slider_info.id-=visible_entries;                 break;               }d               case XK_Next:i               case XK_KP_Next:               {a0                 slider_info.id+=visible_entries;                 break;               }                case XK_End:               case XK_KP_End:                { '                 slider_info.id=entries;t                 break;               } 
             }o#             state|=RedrawListState;l             break;           },E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))M           {              /*               Read new entry.l             */)             if (*reply_info.text == '\0')e               break;%             action_info.raised=False; A             XDrawBeveledButton(display,window_info,&action_info);              state|=ExitState;c             break;           }e'         if (key_symbol == XK_Control_L)n           {               state|=ControlState;             break;           }.!         if (state & ControlState)w           switch (key_symbol)f           {n             case XK_u:             case XK_U:
             {t               /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;                break;
             }w             default:               break;           }e@         XEditText(display,&reply_info,key_symbol,command,state);8         XDrawMatteText(display,window_info,&reply_info);         break;       }m       case KeyRelease:       {e         static char !           command[MaxTextExtent];i           static KeySym;           key_symbol;C  1         if (event.xkey.window != window_info->id)a           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);v'         if (key_symbol == XK_Control_L) !           state&=(~ControlState);n         break;       }        case LeaveNotify:t       {a6         if (event.xcrossing.window != window_info->id)           break;#         state|=InactiveWidgetState;n         break;       }        case MapNotify:        {_         mask&=(~CWX);(         mask&=(~CWY);n         break;       }        case MotionNotify:       {p
         /*/           Discard pending button motion events.t
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));,         if (slider_info.active)            {m             /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0;t3             if (slider_info.y != slider_info.min_y) K               slider_info.id=(entries*(slider_info.y-slider_info.min_y+1))/t8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;)             break;           }i(         if (state & InactiveWidgetState)           break;K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {              /*+               Action button status changed.a             */3             action_info.raised=!action_info.raised;nA             XDrawBeveledButton(display,window_info,&action_info);              break;           }rK         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {              /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised;dA             XDrawBeveledButton(display,window_info,&cancel_info);;             break;           }n         break;       }e       case SelectionClear:       { #         reply_info.highlight=False; 8         XDrawMatteText(display,window_info,&reply_info);         break;       }d       case SelectionNotify:u       {l         Atom           type;            intr           format;            unsigned char            *data;           unsigned long            after,           length;t  
         /*1           Obtain response from primary selection.i
         */5         if (event.xselection.property == (Atom) None)d           break;E         status=XGetWindowProperty(display,event.xselection.requestor,%J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;>         if ((Extent(reply_info.text)+length) >= MaxTextExtent)           XBell(display,0);          else           {              /*5               Insert primary selection in reply text.              */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,                state); <             XDrawMatteText(display,window_info,&reply_info);%             state|=RedrawActionState;%           }          XFree((void *) data);i         break;       }t       case SelectionRequest:       {s         XSelectionEventO           notify;t           XSelectionRequestEvent           *request;n  "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest)); N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           Extent(primary_selection));:$         notify.type=SelectionNotify;         notify.send_event=True;i(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;P         (void) XSendEvent(request->display,request->requestor,False,NoEventMask,           (XEvent *) &notify);       }        default:         break;     }g!   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False);n?   XWithdrawWindow(display,window_info->id,window_info->screen);n(   XCheckRefreshWindows(display,windows); };   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %nO %                                                                             %eO %                                                                             %qO %   X M e n u W i d g e t                                                     %oO %                                                                             %fO %                                                                             %eO %                                                                             %xO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s %tK %  Method XMenuWidget maps a menu and returns the command pointed to by thed$ %  user when the button is released. %o+ %  The format of the XMenuWidget method is:- %dL %      int XMenuWidget(Display *display,XWindows *windows,const char *title,, %        const char **selections,char *item) % + %  A description of each parameter follows:i %wG %    o selection_number: Specifies the number of the selection that thea %      user choose.- %dE %    o display: Specifies a connection to an X server;  returned fromw %      XOpenDisplay. %i; %    o window: Specifies a pointer to a XWindows structure.w %wN %    o title: Specifies a character string that describes the menu selections. %iK %    o selections: Specifies a pointer to one or more strings that compriseC %      the choices in the menu.i %wJ %    o item: Specifies a character array.  The item selected from the menu %      is returned here. %t %X */L Export int XMenuWidget(Display *display,XWindows *windows,const char *title,%   const char **selections,char *item)n {s   Cursor     cursor;e     int      height,e     id,w
     width,     x,     y;     unsigned int     number_selections,     title_height,d     top_offset;w     unsigned longh
     state;     XEvent
     event;  
   XFontStruct      *font_info;x     XSetWindowAttributes     window_attributes;  
   XWidgetInfoc     highlight_info,l     menu_info,     selection_info;.     XWindowChanges     window_changes;C     /*%     Determine Menu widget attributes.o   */&   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL);/!   assert(title != (char *) NULL);B-   assert(selections != (char const **) NULL);,    assert(item != (char *) NULL);&   font_info=windows->widget.font_info;.   windows->widget.width=!submenu_info.active ?2     XTextWidth(font_info,title,Extent(title)) : 0;3   for (id=0; selections[id] != (char *) NULL; id++)S   { F     width=XTextWidth(font_info,selections[id],Extent(selections[id]));,     if (width > (int) windows->widget.width)"       windows->widget.width=width;   }o   number_selections=id;G+   XGetWidgetInfo((char *) NULL,&menu_info); %   title_height=!submenu_info.active ? :     (3*(font_info->descent+font_info->ascent) >> 1)+5 : 2;2   width=XTextWidth(font_info,title,Extent(title));9   height=(3*(font_info->ascent+font_info->descent)) >> 1;    /*     Position Menu widget._   */D   windows->widget.width+=QuantumMargin+(menu_info.bevel_width << 1);2   top_offset=title_height+menu_info.bevel_width-1;?   windows->widget.height=top_offset+number_selections*height+4;l2   windows->widget.min_width=windows->widget.width;4   windows->widget.min_height=windows->widget.height;5   XQueryPosition(display,windows->widget.root,&x,&y);p+   windows->widget.x=x-(QuantumMargin >> 1);g   if (submenu_info.active)     {        windows->widget.x=@         windows->command.x+windows->command.width-QuantumMargin;       toggle_info.raised=True;@       XDrawTriangleEast(display,&windows->command,&toggle_info);     }nI   windows->widget.y=!submenu_info.active ? y-((3*title_height) >> 2) : y;t   if (submenu_info.active)8     windows->widget.y=windows->command.y+submenu_info.y;5   XConstrainWindowPosition(display,&windows->widget);a   /*     Map Menu widget.   */+   window_attributes.override_redirect=True;nH   XChangeWindowAttributes(display,windows->widget.id,CWOverrideRedirect,     &window_attributes);-   window_changes.width=windows->widget.width;_/   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x;u%   window_changes.y=windows->widget.y;=I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,c4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);n   windows->widget.mapped=False;    /*     Respond to X events.   */   selection_info.height=height;N1   cursor=XCreateFontCursor(display,XC_right_ptr);"2   XDefineCursor(display,windows->image.id,cursor);4   XDefineCursor(display,windows->command.id,cursor);3   XDefineCursor(display,windows->widget.id,cursor);t!   state=UpdateConfigurationState;e   do   {d)     if (state & UpdateConfigurationState)        {i
         /*+           Initialize selection information.f
         */1         XGetWidgetInfo((char *) NULL,&menu_info);t          menu_info.bevel_width--;M         menu_info.width=windows->widget.width-((menu_info.bevel_width) << 1); O         menu_info.height=windows->widget.height-((menu_info.bevel_width) << 1);g*         menu_info.x=menu_info.bevel_width;*         menu_info.y=menu_info.bevel_width;6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=menu_info.width;i%         selection_info.height=height;d%         selection_info.x=menu_info.x; &         highlight_info=selection_info;%         highlight_info.bevel_width--;g@         highlight_info.width-=(highlight_info.bevel_width << 1);A         highlight_info.height-=(highlight_info.bevel_width << 1);t5         highlight_info.x+=highlight_info.bevel_width;S+         state&=(~UpdateConfigurationState);v       }i"     if (state & RedrawWidgetState)       { 
         /*           Redraw Menu widget.A
         */!         if (!submenu_info.active)            {              y=title_height;n;             XSetBevelColor(display,&windows->widget,False);cP             XDrawLine(display,windows->widget.id,windows->widget.widget_context,C               selection_info.x,y-1,(int) selection_info.width,y-1); :             XSetBevelColor(display,&windows->widget,True);P             XDrawLine(display,windows->widget.id,windows->widget.widget_context,?               selection_info.x,y,(int) selection_info.width,y);vL             XSetFillStyle(display,windows->widget.widget_context,FillSolid);           } 
         /*           Draw menu selections.)
         */#         selection_info.center=True;s/         selection_info.y=menu_info.bevel_width; +         selection_info.text=(char *) title; !         if (!submenu_info.active)-D           XDrawWidgetText(display,&windows->widget,&selection_info);$         selection_info.center=False;$         selection_info.y=top_offset;6         for (id=0; id < (int) number_selections; id++)	         {m6           selection_info.text=(char *) selections[id];D           XDrawWidgetText(display,&windows->widget,&selection_info);G           highlight_info.y=selection_info.y+highlight_info.bevel_width; &           if (id == selection_info.id)A             XDrawBevel(display,&windows->widget,&highlight_info);k8           selection_info.y+=(int) selection_info.height;	         }l8         XDrawBevel(display,&windows->widget,&menu_info);$         state&=(~RedrawWidgetState);       }n     if (number_selections > 2)       { 
         /*           Redraw Menu line. 
         */A         y=top_offset+selection_info.height*(number_selections-1); 7         XSetBevelColor(display,&windows->widget,False);iL         XDrawLine(display,windows->widget.id,windows->widget.widget_context,?           selection_info.x,y-1,(int) selection_info.width,y-1);o6         XSetBevelColor(display,&windows->widget,True);L         XDrawLine(display,windows->widget.id,windows->widget.widget_context,;           selection_info.x,y,(int) selection_info.width,y);cH         XSetFillStyle(display,windows->widget.widget_context,FillSolid);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);x     switch (event.type)e     {e       case ButtonPress:        { 7         if (event.xbutton.window != windows->widget.id)f           {i             /*               Exit menu.             */<             if (event.xbutton.window == windows->command.id),               XPutBackEvent(display,&event);#             selection_info.id=(~0);              *item='\0';i             state|=ExitState;f             break;           }B&         state&=(~InactiveWidgetState);D         id=(event.xbutton.y-top_offset)/(int) selection_info.height;         selection_info.id=id;t8         if ((id < 0) || (id >= (int) number_selections))           break;
         /*#           Highlight this selection. 
         */=         selection_info.y=top_offset+id*selection_info.height; 4         selection_info.text=(char *) selections[id];B         XDrawWidgetText(display,&windows->widget,&selection_info);E         highlight_info.y=selection_info.y+highlight_info.bevel_width; =         XDrawBevel(display,&windows->widget,&highlight_info);,         break;       }        case ButtonRelease:_       {i$         if (!windows->widget.mapped)           break;8         if (event.xbutton.window == windows->command.id)-           if (!(state & InactiveWidgetState))t             break;
         /*           Exit menu.
         *//         XSetCursorState(display,windows,False);          *item='\0';d         state|=ExitState;d         break;       }        case ConfigureNotify:i       {w
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;F         if ((event.xconfigure.width == (int) windows->widget.width) &&F             (event.xconfigure.height == (int) windows->widget.height))           break;         windows->widget.width=F           Max(event.xconfigure.width,(int) windows->widget.min_width);         windows->widget.height=xH           Max(event.xconfigure.height,(int) windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }n       case EnterNotify:d       { 9         if (event.xcrossing.window != windows->widget.id)e           break;'         if (event.xcrossing.state == 0)U           break;&         state&=(~InactiveWidgetState);H         id=((event.xcrossing.y-top_offset)/(int) selection_info.height);'         if ((selection_info.id >= 0) && :             (selection_info.id < (int) number_selections))           {s             /*)               Unhighlight last selection.w             */(             if (id == selection_info.id)               break;             selection_info.y=dA               top_offset+selection_info.id*selection_info.height;dG             selection_info.text=(char *) selections[selection_info.id];tF             XDrawWidgetText(display,&windows->widget,&selection_info);           } 8         if ((id < 0) || (id >= (int) number_selections))           break;
         /*#           Highlight this selection. 
         */         selection_info.id=id; L         selection_info.y=top_offset+selection_info.id*selection_info.height;C         selection_info.text=(char *) selections[selection_info.id];oB         XDrawWidgetText(display,&windows->widget,&selection_info);E         highlight_info.y=selection_info.y+highlight_info.bevel_width;l=         XDrawBevel(display,&windows->widget,&highlight_info);e         break;       }        case Expose:       {y7         if (event.xexpose.window != windows->widget.id)C           break;%         if (event.xexpose.count != 0)f           break;!         state|=RedrawWidgetState;l         break;       }        case LeaveNotify:        {_9         if (event.xcrossing.window != windows->widget.id)            break;#         state|=InactiveWidgetState;          id=selection_info.id; 8         if ((id < 0) || (id >= (int) number_selections))           break;
         /*%           Unhighlight last selection.t
         */=         selection_info.y=top_offset+id*selection_info.height;          selection_info.id=(~0); 4         selection_info.text=(char *) selections[id];B         XDrawWidgetText(display,&windows->widget,&selection_info);         break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));           if (submenu_info.active):           if (event.xmotion.window == windows->command.id)
             { 1               if (!(state & InactiveWidgetState))y                 {mA                   if (!MatteIsActive(submenu_info,event.xmotion))f                     {r-                       selection_info.id=(~0); #                         *item='\0';e'                       state|=ExitState;o                       break;                     };                 }a               elseC                 if (WindowIsActive(windows->command,event.xmotion))                    { +                     selection_info.id=(~0);                      *item='\0';l%                     state|=ExitState;                      break;                   };
             }c7         if (event.xmotion.window != windows->widget.id)o           break;(         if (state & InactiveWidgetState)           break;D         id=(event.xmotion.y-top_offset)/(int) selection_info.height;'         if ((selection_info.id >= 0) &&y:             (selection_info.id < (int) number_selections))           {              /*)               Unhighlight last selection..             */(             if (id == selection_info.id)               break;             selection_info.y= A               top_offset+selection_info.id*selection_info.height;lG             selection_info.text=(char *) selections[selection_info.id]; F             XDrawWidgetText(display,&windows->widget,&selection_info);           }l         selection_info.id=id; 8         if ((id < 0) || (id >= (int) number_selections))           break;
         /*#           Highlight this selection. 
         */=         selection_info.y=top_offset+id*selection_info.height; 4         selection_info.text=(char *) selections[id];B         XDrawWidgetText(display,&windows->widget,&selection_info);E         highlight_info.y=selection_info.y+highlight_info.bevel_width;.=         XDrawBevel(display,&windows->widget,&highlight_info);          break;       }(       default:         break;     } !   } while (!(state & ExitState));L   XFreeCursor(display,cursor);,   window_attributes.override_redirect=False;H   XChangeWindowAttributes(display,windows->widget.id,CWOverrideRedirect,     &window_attributes);E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);x(   XCheckRefreshWindows(display,windows);   if (submenu_info.active)     {         submenu_info.active=False;       toggle_info.raised=False; @       XDrawTriangleEast(display,&windows->command,&toggle_info);     },P   if ((selection_info.id < 0) || (selection_info.id >= (int) number_selections))     return(~0);d4   (void) strcpy(item,selections[selection_info.id]);   return(selection_info.id); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %rO %                                                                             % O %   X M o n i t o r W i d g e t                                               % O %                                                                             % O %                                                                             %yO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % B %  Method XMonitorWidget displays the progress a task is making inM %  completing a task.  A span of zero toggles the active status.  An inactivee' %  state disables the progress monitor.e %v. %  The format of the XMonitorWidget method is: % O %      void XMonitorWidget(Display *display,XWindows *windows,const char *task, < %        const unsigned int quantum,const unsigned int span) %w+ %  A description of each parameter follows:- %dE %    o display: Specifies a connection to an X server;  returned froms %      XOpenDisplay. %f; %    o window: Specifies a pointer to a XWindows structure.a %d- %    o task: Identifies the task in progress.% %%O %    o quantum: Specifies the quantum position within the span which represents < %      how much progress has been made in completing a task. % > %    o span: Specifies the span relative to completing a task. %  %  */O Export void XMonitorWidget(Display *display,XWindows *windows,const char *task, 5   const unsigned int quantum,const unsigned int span)  {    unsigned int
     width;     XEvent
     event;  &   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL); &   assert(task != (const char *) NULL);   if (span == 0)     return;    /*<     Update image windows if there is a pending expose event.   */K   while (XCheckTypedWindowEvent(display,windows->command.id,Expose,&event)) G     (void) XCommandWidget(display,windows,(char const **) NULL,&event);lI   while (XCheckTypedWindowEvent(display,windows->image.id,Expose,&event))C3     XRefreshWindow(display,&windows->image,&event); H   while (XCheckTypedWindowEvent(display,windows->info.id,Expose,&event))+     if (monitor_info.text != (char *) NULL)i5       XInfoWidget(display,windows,monitor_info.text);t   /*H     Draw progress monitor bar to represent percent completion of a task.   */;   if (!windows->info.mapped || (task != monitor_info.text))f&     XInfoWidget(display,windows,task);G   width=((quantum+1)*(windows->info.width-(monitor_info.x << 1)))/span;S"   if (width == monitor_info.width)     return; !   if (width < monitor_info.width)      {r       monitor_info.raised=True; <       XDrawWidgetText(display,&windows->info,&monitor_info);        monitor_info.raised=False;     }a   monitor_info.width=width;l8   XDrawWidgetText(display,&windows->info,&monitor_info);   XFlush(display); }  l /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %IO %                                                                             %pO %                                                                             % O %   X N o t i c e W i d g e t                                                 %gO %                                                                             %iO %                                                                             % O %                                                                             %xO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %mK %  Method XNoticeWidget displays a Notice widget with a notice to the user. C %  The function returns when the user presses the "Dismiss" button.  % - %  The format of the XNoticeWidget method is:v %,= %      void XNoticeWidget(Display *display,XWindows *windows, 3 %        const char *message,const char *qualifier)  % + %  A description of each parameter follows:i %eE %    o display: Specifies a connection to an X server;  returned fromn %      XOpenDisplay. %e; %    o window: Specifies a pointer to a XWindows structure.i %,G %    o message: Specifies the message to display before terminating the; %      program.t % 9 %    o qualifier: Specifies any qualifier to the message.* %  %  */= Export void XNoticeWidget(Display *display,XWindows *windows,d,   const char *message,const char *qualifier) { $ #define DismissButtonText  "Dismiss" #define Timeout  8     intt     status,e     x,     y;     time_t
     timer;     unsigned int     height, 
     width;     unsigned longf
     state;     XEvent
     event;  
   XFontStructf     *font_info;n     XTextProperty,     window_name;  
   XWidgetInfo      dismiss_info;      XWindowChanges     window_changes;      /*'     Determine Notice widget attributes.    */&   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL);r#   assert(message != (char *) NULL);lC   XDelay(display,SuspendTime << 3);  /* avoid surpise with delay */ (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;J   width=XTextWidth(font_info,DismissButtonText,Extent(DismissButtonText));   if (message != (char *) NULL)tD     if (XTextWidth(font_info,message,Extent(message)) > (int) width):       width=XTextWidth(font_info,message,Extent(message));!   if (qualifier != (char *) NULL)eH     if (XTextWidth(font_info,qualifier,Extent(qualifier)) > (int) width)>       width=XTextWidth(font_info,qualifier,Extent(qualifier));0   height=(font_info->ascent+font_info->descent);   /*     Position Notice widget.e   */.   windows->widget.width=width+4*QuantumMargin;0   windows->widget.min_width=width+QuantumMargin;8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;#   windows->widget.height=12*height;i&   windows->widget.min_height=7*height;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XConstrainWindowPosition(display,&windows->widget);x   /*     Map Notice widget.   *//   (void) strcpy(windows->widget.name,"Notice");oI   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);r   if (status != 0)     {x:       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     }H-   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height;e%   window_changes.x=windows->widget.x;f%   window_changes.y=windows->widget.y;xI   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,x4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;_   XBell(display,0);t   /*     Respond to X events.   */&   timer=time((time_t *) NULL)+Timeout;!   state=UpdateConfigurationState;h   do   {F&     if (time((time_t *) NULL) > timer)       break;)     if (state & UpdateConfigurationState)i       { 
         /*0           Initialize Dismiss button information.
         */8         XGetWidgetInfo(DismissButtonText,&dismiss_info);)         dismiss_info.width=QuantumMargin+iL           XTextWidth(font_info,DismissButtonText,Extent(DismissButtonText));,         dismiss_info.height=(3*height) >> 1;N         dismiss_info.x=(windows->widget.width >> 1)-(dismiss_info.width >> 1);I         dismiss_info.y=windows->widget.height-(dismiss_info.height << 1);e+         state&=(~UpdateConfigurationState);w       }."     if (state & RedrawWidgetState)       {a
         /*           Redraw Notice widget. 
         */<         width=XTextWidth(font_info,message,Extent(message));4         x=(windows->widget.width >> 1)-(width >> 1);6         y=(windows->widget.height >> 1)-(height << 1);P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,0           x,y,(char *) message,Extent(message));'         if (qualifier != (char *) NULL))           {vD             width=XTextWidth(font_info,qualifier,Extent(qualifier));8             x=(windows->widget.width >> 1)-(width >> 1);             y+=height;3             XDrawString(display,windows->widget.id,uF               windows->widget.annotate_context,x,y,(char *) qualifier,!               Extent(qualifier));s           }>C         XDrawBeveledButton(display,&windows->widget,&dismiss_info);XM         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);o$         state&=(~RedrawWidgetState);       }(     /*       Wait for next event.     */E     if (!XCheckIfEvent(display,&event,XScreenEvent,(char *) windows))C       {t
         /*$           Do not block if delay > 0.
         */)         XDelay(display,SuspendTime << 2);g         continue;o       }      switch (event.type)g     {S       case ButtonPress:        { 6         if (MatteIsActive(dismiss_info,event.xbutton))           {              /**               User pressed Dismiss button.             */&             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);-             break;           };         break;       }i       case ButtonRelease:_       {h$         if (!windows->widget.mapped)           break;!         if (!dismiss_info.raised)i           { ;             if (event.xbutton.window == windows->widget.id)a<               if (MatteIsActive(dismiss_info,event.xbutton))!                 state|=ExitState; %             dismiss_info.raised=True; G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);o           }          break;       }i       case ClientMessage:        {_
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;B         if (*event.xclient.data.l == (int) windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent,t'               event.xclient.data.l[1]);y             break;           } E         if (*event.xclient.data.l != (int) windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)t           {n             state|=ExitState;t             break;           }g         break;       }f       case ConfigureNotify:p       {(
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;F         if ((event.xconfigure.width == (int) windows->widget.width) &&F             (event.xconfigure.height == (int) windows->widget.height))           break;         windows->widget.width=F           Max(event.xconfigure.width,(int) windows->widget.min_width);         windows->widget.height= H           Max(event.xconfigure.height,(int) windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }h       case EnterNotify:        {l9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }n       case Expose:       {)7         if (event.xexpose.window != windows->widget.id)f           break;%         if (event.xexpose.count != 0)-           break;!         state|=RedrawWidgetState;.         break;       }o       case KeyPress:       {          static chari!           command[MaxTextExtent];            static KeySyml           key_symbol;f  4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),n/           &key_symbol,(XComposeStatus *) NULL);oE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))r           {r&             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);r             state|=ExitState;d             break;           }f         break;       }d       case LeaveNotify:y       {f9         if (event.xcrossing.window != windows->widget.id)e           break;#         state|=InactiveWidgetState;o         break;       }n       case MotionNotify:       { 
         /*/           Discard pending button motion events.9
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));f(         if (state & InactiveWidgetState)           break;M         if (dismiss_info.raised == MatteIsActive(dismiss_info,event.xmotion))e           {              /*,               Dismiss button status changed.             */5             dismiss_info.raised=!dismiss_info.raised;iG             XDrawBeveledButton(display,&windows->widget,&dismiss_info);i             break;           }          break;       }h       default:         break;     }i!   } while (!(state & ExitState));f)   XSetCursorState(display,windows,False);cE   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);t(   XCheckRefreshWindows(display,windows); }l n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %eO %   X P r e f e r e n c e s W i d g e t                                       % O %                                                                             %rO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %yG %  Method XPreferencesWidget displays a Preferences widget with program J %  preferences.  If the user presses the Apply button, the preferences are? %  stored in a configuration file in the users' home directory.+ %e2 %  The format of the XPreferencesWidget method is: % 8 %      unsigned int XPreferencesWidget(Display *display,8 %        XResourceInfo *resource_info,XWindows *windows) %y+ %  A description of each parameter follows:, %1E %    o display: Specifies a connection to an X server;  returned fromo %      XOpenDisplay. %aK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.n %s; %    o window: Specifies a pointer to a XWindows structure.d %l %& */8 Export unsigned int XPreferencesWidget(Display *display,1   XResourceInfo *resource_info,XWindows *windows)l {a  #define ApplyButtonText  "Apply"L #define CacheButtonText  "%u mega-bytes of memory in the undo edit cache   "" #define CancelButtonText  "Cancel" #define NumberPreferences  7  
   static charT     *Preferences[] =     {--       "display image centered on a backdrop",;        "confirm on program exit",(       "correct image for display gamma",!       "display warning messages",d7       "apply Floyd/Steinberg error diffusion to image", 8       "use a shared colormap for colormapped X visuals",,       "display images as an X server pixmap"     };     char     cache[MaxTextExtent];-     intr     height,      status,B     text_width,l
     width,     x,     y;     register int     i;     unsigned long&
     state;     XEvent
     event;  
   XFontStructu     *font_info;d     XTextProperty_     window_name;  
   XWidgetInfos     apply_info,d     cache_info,B     cancel_info,(     preferences_info[NumberPreferences];     XWindowChanges     window_changes;R     /*,     Determine Preferences widget attributes.   */&   assert(display != (Display *) NULL);2   assert(resource_info != (XResourceInfo *) NULL);'   assert(windows != (XWindows *) NULL);t(   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;K   text_width=XTextWidth(font_info,CacheButtonText,Extent(CacheButtonText)); '   for (i=0; i < NumberPreferences; i++)iQ     if (XTextWidth(font_info,Preferences[i],Extent(Preferences[i])) > text_width)dM       text_width=XTextWidth(font_info,Preferences[i],Extent(Preferences[i]));tF   width=XTextWidth(font_info,ApplyButtonText,Extent(ApplyButtonText));N   if (XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText));   width+=QuantumMargin; 0   height=(font_info->ascent+font_info->descent);   /*      Position Preferences widget.   */K   windows->widget.width=Max((int) (width << 1),text_width)+6*QuantumMargin;r7   windows->widget.min_width=(width << 1)+QuantumMargin; 8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;   windows->widget.height=d=     7*height+NumberPreferences*(height+(QuantumMargin >> 1));.   windows->widget.min_height=~=     7*height+NumberPreferences*(height+(QuantumMargin >> 1));e:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Preferences widget.    */4   (void) strcpy(windows->widget.name,"Preferences");I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);)   if (status != 0)     {(:       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     } -   window_changes.width=windows->widget.width;e/   window_changes.height=windows->widget.height;l%   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y;-I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,o4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);t   windows->widget.mapped=False;    /*     Respond to X events.   */!   state=UpdateConfigurationState;.(   XSetCursorState(display,windows,True);   do   { )     if (state & UpdateConfigurationState))       { 
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1;)>         cancel_info.x=windows->widget.width-cancel_info.width-           (QuantumMargin << 1);tN         cancel_info.y=windows->widget.height-cancel_info.height-QuantumMargin;4         XGetWidgetInfo(ApplyButtonText,&apply_info);         apply_info.width=width; *         apply_info.height=(3*height) >> 1;(         apply_info.x=QuantumMargin << 1;#         apply_info.y=cancel_info.y;          y=height << 1;-         for (i=0; i < NumberPreferences; i++) 	         {i>           XGetWidgetInfo(Preferences[i],&preferences_info[i]);,           preferences_info[i].bevel_width--;7           preferences_info[i].width=QuantumMargin >> 1;_8           preferences_info[i].height=QuantumMargin >> 1;3           preferences_info[i].x=QuantumMargin << 1;r"           preferences_info[i].y=y;)           y+=height+(QuantumMargin >> 1);l	         }d<         preferences_info[0].raised=!resource_info->backdrop;@         preferences_info[1].raised=!resource_info->confirm_exit;A         preferences_info[2].raised=!resource_info->gamma_correct;tD         preferences_info[3].raised=!resource_info->display_warnings;I         preferences_info[4].raised=!resource_info->quantize_info->dither;=M         preferences_info[5].raised=resource_info->colormap != SharedColormap;i>         preferences_info[6].raised=!resource_info->use_pixmap;F         FormatString(cache,CacheButtonText,resource_info->undo_cache);*         XGetWidgetInfo(cache,&cache_info);!         cache_info.bevel_width--; ,         cache_info.width=QuantumMargin >> 1;-         cache_info.height=QuantumMargin >> 1; (         cache_info.x=QuantumMargin << 1;         cache_info.y=y; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       {x
         /*$           Redraw Preferences widget.
         */A         XDrawBeveledButton(display,&windows->widget,&apply_info); B         XDrawBeveledButton(display,&windows->widget,&cancel_info);-         for (i=0; i < NumberPreferences; i++))L           XDrawBeveledButton(display,&windows->widget,&preferences_info[i]);@         XDrawTriangleEast(display,&windows->widget,&cache_info);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset); $         state&=(~RedrawWidgetState);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);r     switch (event.type)d     {        case ButtonPress:,       {e4         if (MatteIsActive(apply_info,event.xbutton))           {r             /*(               User pressed Apply button.             */$             apply_info.raised=False;E             XDrawBeveledButton(display,&windows->widget,&apply_info);              break;           } 5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*)               User pressed Cancel button.              */%             cancel_info.raised=False;SF             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } -         for (i=0; i < NumberPreferences; i++)s?           if (MatteIsActive(preferences_info[i],event.xbutton)) 
             {t               /*2                 User pressed a Preferences button.               */E               preferences_info[i].raised=!preferences_info[i].raised;BP               XDrawBeveledButton(display,&windows->widget,&preferences_info[i]);               break;
             } 4         if (MatteIsActive(cache_info,event.xbutton))           {T             /*(               User pressed Cache button.             */C             x=cache_info.x+cache_info.width+cache_info.bevel_width+(#               (QuantumMargin >> 1);o=             y=cache_info.y+((cache_info.height-height) >> 1);e<             width=XTextWidth(font_info,cache,Extent(cache));J             XClearArea(display,windows->widget.id,x,y,width,height,False);*             resource_info->undo_cache<<=1;0             if (resource_info->undo_cache > 256)*               resource_info->undo_cache=1;J             FormatString(cache,CacheButtonText,resource_info->undo_cache);$             cache_info.raised=False;D             XDrawTriangleEast(display,&windows->widget,&cache_info);             break;           },         break;       }        case ButtonRelease:        {o$         if (!windows->widget.mapped)           break;         if (!apply_info.raised)            {.;             if (event.xbutton.window == windows->widget.id)r:               if (MatteIsActive(apply_info,event.xbutton))!                 state|=ExitState; #             apply_info.raised=True;iE             XDrawBeveledButton(display,&windows->widget,&apply_info); $             apply_info.raised=False;           }s          if (!cancel_info.raised)           {s;             if (event.xbutton.window == windows->widget.id)/;               if (MatteIsActive(cancel_info,event.xbutton)) !                 state|=ExitState; $             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }m         if (!cache_info.raised)            {c#             cache_info.raised=True;fD             XDrawTriangleEast(display,&windows->widget,&cache_info);           }          break;       }t       case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;B         if (*event.xclient.data.l == (int) windows->wm_take_focus)           {rG             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } E         if (*event.xclient.data.l != (int) windows->wm_delete_window)t           break;7         if (event.xclient.window == windows->widget.id)            {t             state|=ExitState;o             break;           }*         break;       }s       case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;F         if ((event.xconfigure.width == (int) windows->widget.width) &&F             (event.xconfigure.height == (int) windows->widget.height))           break;         windows->widget.width=F           Max(event.xconfigure.width,(int) windows->widget.min_width);         windows->widget.height=(H           Max(event.xconfigure.height,(int) windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:l       { 9         if (event.xcrossing.window != windows->widget.id)_           break;&         state&=(~InactiveWidgetState);         break;       }n       case Expose:       { 7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;,         break;       }        case KeyPress:       {          static charp!           command[MaxTextExtent];            static KeySym.           key_symbol;n  4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),M/           &key_symbol,(XComposeStatus *) NULL);eE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))f           { $             apply_info.raised=False;E             XDrawBeveledButton(display,&windows->widget,&apply_info);o             state|=ExitState;k             break;           }l         break;       }        case LeaveNotify:        { 9         if (event.xcrossing.window != windows->widget.id)w           break;#         state|=InactiveWidgetState;(         break;       }n       case MotionNotify:       {e
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));n(         if (state & InactiveWidgetState)           break;I         if (apply_info.raised == MatteIsActive(apply_info,event.xmotion))d           {f             /**               Apply button status changed.             */1             apply_info.raised=!apply_info.raised;tE             XDrawBeveledButton(display,&windows->widget,&apply_info);G             break;           }wK         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))l           {              /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }n         break;       }        default:         break;     }-!   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   if (apply_info.raised)     return(False);   /*;     Save user preferences to the client configuration file.    */6   resource_info->backdrop=!preferences_info[0].raised;:   resource_info->confirm_exit=!preferences_info[1].raised;;   resource_info->gamma_correct=!preferences_info[2].raised; >   resource_info->display_warnings=!preferences_info[3].raised;C   resource_info->quantize_info->dither=!preferences_info[4].raised; )   resource_info->colormap=SharedColormap;t!   if (preferences_info[5].raised) ,     resource_info->colormap=PrivateColormap;8   resource_info->use_pixmap=!preferences_info[6].raised;"   XUserPreferences(resource_info);   return(True);  }D B /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %dO %                                                                             %iO %                                                                             % O %   X T e x t V i e w W i d g e t                                             %TO %                                                                             % O %                                                                             %yO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %d> %  Method XTextViewWidget displays text in a Text View widget. % / %  The format of the XTextViewWidget method is:  % P %      void XTextViewWidget(Display *display,const XResourceInfo *resource_info,E %        XWindows *windows,const unsigned int mono,const char *title,e %        char const **textlist), % + %  A description of each parameter follows:t %sE %    o display: Specifies a connection to an X server;  returned fromi %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.t %p; %    o window: Specifies a pointer to a XWindows structure.t %+8 %    o mono:  Use mono-spaced font when displaying text. %lI %    o title: This character string is displayed at the top of the widgete %      window. % K %    o textlist: This string list is displayed within the Text View widget.  %a %  */P Export void XTextViewWidget(Display *display,const XResourceInfo *resource_info,>   XWindows *windows,const unsigned int mono,const char *title,   char const **textlist) { $ #define DismissButtonText  "Dismiss"     char%     primary_selection[MaxTextExtent];      int      status,c     text_width;r     register int     i;  
   static chary*     mask = CWWidth | CWHeight | CWX | CWY;     unsigned int     height,r
     lines,     visible_lines,
     width;     unsigned longi
     delay,
     state;     XEvent
     event;  
   XFontStructA     *font_info,,     *text_info;      XTextProperty      window_name;  
   XWidgetInfof     dismiss_info,      expose_info,     list_info,     north_info,      scroll_info,     selection_info,t     slider_info,     south_info;_     XWindowChanges     window_changes;f     /*'     Convert text string to a text list.s   */&   assert(display != (Display *) NULL);2   assert(resource_info != (XResourceInfo *) NULL);'   assert(windows != (XWindows *) NULL); '   assert(title != (const char *) NULL);a+   assert(textlist != (char const **) NULL); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);'   if (textlist == (char const **) NULL)      {lF       XNoticeWidget(display,windows,"No text to view:",(char *) NULL);
       return;o     }    /**     Determine Text View widget attributes.   */&   font_info=windows->widget.font_info;!   text_info=(XFontStruct *) NULL;i   if (mono)/4     text_info=XBestFont(display,resource_info,True);(   if (text_info == (XFontStruct *) NULL)(     text_info=windows->widget.font_info;   text_width=0; .   for (i=0; textlist[i] != (char *) NULL; i++)K     if (XTextWidth(text_info,textlist[i],Extent(textlist[i])) > text_width) G       text_width=XTextWidth(text_info,textlist[i],Extent(textlist[i]));(
   lines=i;J   width=XTextWidth(font_info,DismissButtonText,Extent(DismissButtonText));   width+=QuantumMargin; .   height=text_info->ascent+text_info->descent;   /*     Position Text View widget.   */K   windows->widget.width=Min((int) text_width,MaxTextWidth)+5*QuantumMargin; 9   windows->widget.min_width=MinTextWidth+4*QuantumMargin; 8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;   windows->widget.height=oL     Min(Max(lines,3),32)*height+((13*height) >> 1)+((9*QuantumMargin) >> 1);   windows->widget.min_height=;9     3*height+((13*height) >> 1)+((9*QuantumMargin) >> 1);i:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XConstrainWindowPosition(display,&windows->widget);d   /*     Map Text View widget.r   */,   (void) strcpy(windows->widget.name,title);I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);;   if (status != 0)     {W:       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     }o-   window_changes.width=windows->widget.width;d/   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x;c%   window_changes.y=windows->widget.y;]N   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,mask,     &window_changes); )   XMapRaised(display,windows->widget.id);i   windows->widget.mapped=False;    /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info);y,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_lines=0;   delay=SuspendTime << 2; .   height=font_info->ascent+font_info->descent;!   state=UpdateConfigurationState;    do   {i)     if (state & UpdateConfigurationState)e       {          int 
           id;   
         /*(           Initialize button information.
         */8         XGetWidgetInfo(DismissButtonText,&dismiss_info);!         dismiss_info.width=width;a,         dismiss_info.height=(3*height) >> 1;P         dismiss_info.x=windows->widget.width-dismiss_info.width-QuantumMargin-2;P         dismiss_info.y=windows->widget.height-dismiss_info.height-QuantumMargin;
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info); "         scroll_info.bevel_width--;!         scroll_info.width=height;iC         scroll_info.height=dismiss_info.y-((5*QuantumMargin) >> 1); L         scroll_info.x=windows->widget.width-QuantumMargin-scroll_info.width;-         scroll_info.y=(3*QuantumMargin) >> 1; !         scroll_info.raised=False;           scroll_info.trough=True;         north_info=scroll_info;          north_info.raised=True;d8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1;s-         north_info.x+=north_info.bevel_width; -         north_info.y+=north_info.bevel_width;l         south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;l         slider_info.id=id;         slider_info.width-=2;eP         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height=rJ           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;;         visible_lines=(scroll_info.height-(height >> 3)-3)/ <           ((9*(text_info->ascent+text_info->descent)) >> 3);"         if (lines > visible_lines)F           slider_info.height=(visible_lines*slider_info.height)/lines;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);          list_info.raised=False;           list_info.bevel_width--;?         list_info.width=scroll_info.x-((3*QuantumMargin) >> 1);,,         list_info.height=scroll_info.height;"         list_info.x=QuantumMargin;"         list_info.y=scroll_info.y;
         /*+           Initialize selection information. 
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width;nN         selection_info.height=(9*(text_info->ascent+text_info->descent)) >> 3;%         selection_info.x=list_info.x;o+         state&=(~UpdateConfigurationState);s       }m"     if (state & RedrawWidgetState)       { 
         /*"           Redraw Text View window.
         */?         XDrawBeveledMatte(display,&windows->widget,&list_info);eA         XDrawBeveledMatte(display,&windows->widget,&scroll_info);dA         XDrawTriangleNorth(display,&windows->widget,&north_info);aB         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info); C         XDrawBeveledButton(display,&windows->widget,&dismiss_info); M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);l         selection_info.id=(~0);          state|=RedrawListState; $         state&=(~RedrawWidgetState);       }s      if (state & RedrawListState)       {l
         /*+           Determine slider id and position..
         */:         if (slider_info.id >= (int) (lines-visible_lines))-           slider_info.id=lines-visible_lines;.=         if ((slider_info.id < 0) || (lines <= visible_lines))f           slider_info.id=0;r(         slider_info.y=slider_info.min_y;         if (lines != 0)            slider_info.y+=iI             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/lines;_0         if (slider_info.id != selection_info.id)           {o             /*)               Redraw scroll bar and text.              */0             windows->widget.font_info=text_info;N             XSetFont(display,windows->widget.annotate_context,text_info->fid);O             XSetFont(display,windows->widget.highlight_context,text_info->fid); -             selection_info.id=slider_info.id;f9             selection_info.y=list_info.y+(height >> 3)+2;-3             for (i=0; i < (int) visible_lines; i++) 
             {eG               selection_info.raised=(slider_info.id+i) != list_info.id; 0               selection_info.text=(char *) NULL;3               if ((slider_info.id+i) < (int) lines)!H                 selection_info.text=(char *) textlist[slider_info.id+i];H               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             } 0             windows->widget.font_info=font_info;N             XSetFont(display,windows->widget.annotate_context,font_info->fid);O             XSetFont(display,windows->widget.highlight_context,font_info->fid);r             /*               Update slider.             */.             if (slider_info.y > expose_info.y)               { ?                 expose_info.height=slider_info.y-expose_info.y; ?                 expose_info.y=slider_info.y-expose_info.height-a,                   slider_info.bevel_width-1;               }              else               {f?                 expose_info.height=expose_info.y-slider_info.y; ?                 expose_info.y=slider_info.y+slider_info.height+s,                   slider_info.bevel_width+1;               }cE             XDrawTriangleNorth(display,&windows->widget,&north_info);e>             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info);y(             expose_info.y=slider_info.y;           }n"         state&=(~RedrawListState);       }y     /*       Wait for next event.     *//     if (north_info.raised && south_info.raised) =       XIfEvent(display,&event,XScreenEvent,(char *) windows);      else       {a
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised)L!           if (slider_info.id > 0) 
             {a               /*                 Move slider up.y               */               slider_info.id--; %               state|=RedrawListState; 
             }e         if (!south_info.raised)E+           if (slider_info.id < (int) lines) 
             {                /*!                 Move slider down.c               */               slider_info.id++;(%               state|=RedrawListState;x
             }y(         if (event.type != ButtonRelease)           continue;c       }      switch (event.type)y     {w       case ButtonPress:        { 5         if (MatteIsActive(slider_info,event.xbutton))o           {              /*               Track slider.              */$             slider_info.active=True;             break;           } 4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0)(
             {h               /*                 Move slider up.                */&               north_info.raised=False;               slider_info.id--;a%               state|=RedrawListState;e               break;
             } 4         if (MatteIsActive(south_info,event.xbutton))+           if (slider_info.id < (int) lines)l
             {                /*!                 Move slider down.l               */&               south_info.raised=False;               slider_info.id++;n%               state|=RedrawListState;r               break;
             }t5         if (MatteIsActive(scroll_info,event.xbutton))n           {              /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)0               slider_info.id-=(visible_lines-1);             else0               slider_info.id+=(visible_lines-1);#             state|=RedrawListState;e             break;           }t6         if (MatteIsActive(dismiss_info,event.xbutton))           {.             /**               User pressed Dismiss button.             */&             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);              break;           }s3         if (MatteIsActive(list_info,event.xbutton));           {              unsigned int               id;%               static Time%               click_time;                /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= lines)               break;)             if ((int) id != list_info.id)                {r                  list_info.id=id;.                 click_time=event.xbutton.time;                 break;               }              list_info.id=id;?             if (event.xbutton.time >= (click_time+DoubleClick))                { .                 click_time=event.xbutton.time;                 break;               }]*             click_time=event.xbutton.time;             /*4               Become the XA_PRIMARY selection owner.             */D             (void) strcpy(primary_selection,textlist[list_info.id]);E             XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id,r"               event.xbutton.time);M             if (XGetSelectionOwner(display,XA_PRIMARY) != windows->widget.id)                break;#             selection_info.id=(~0);r             list_info.id=id;#             state|=RedrawListState;e             break;           }i         break;       }:       case ButtonRelease:W       {r$         if (!windows->widget.mapped)           break;         if (!north_info.raised)o           {e             /*&               User released up button.             */#             delay=SuspendTime << 2;t#             north_info.raised=True; E             XDrawTriangleNorth(display,&windows->widget,&north_info);)           }          if (!south_info.raised)(           {              /*(               User released down button.             */#             delay=SuspendTime << 2;s#             south_info.raised=True; E             XDrawTriangleSouth(display,&windows->widget,&south_info);            }f         if (slider_info.active)n           {T             /*#               Stop tracking slider.              */%             slider_info.active=False;t             break;           }_!         if (!dismiss_info.raised)e           {T;             if (event.xbutton.window == windows->widget.id) <               if (MatteIsActive(dismiss_info,event.xbutton))!                 state|=ExitState;;%             dismiss_info.raised=True;xG             XDrawBeveledButton(display,&windows->widget,&dismiss_info);            }n         break;       }o       case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;B         if (*event.xclient.data.l == (int) windows->wm_take_focus)           {_G             XSetInputFocus(display,event.xclient.window,RevertToParent,o'               event.xclient.data.l[1]);o             break;           }aE         if (*event.xclient.data.l != (int) windows->wm_delete_window)d           break;7         if (event.xclient.window == windows->widget.id)!           {)             state|=ExitState;h             break;           }c         break;       }s       case ConfigureNotify:;       {k
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;F         if ((event.xconfigure.width == (int) windows->widget.width) &&F             (event.xconfigure.height == (int) windows->widget.height))           break;         windows->widget.width=F           Max(event.xconfigure.width,(int) windows->widget.min_width);         windows->widget.height=,H           Max(event.xconfigure.height,(int) windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }o       case EnterNotify:        {e9         if (event.xcrossing.window != windows->widget.id)t           break;&         state&=(~InactiveWidgetState);         break;       }l       case Expose:       { 7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }t       case KeyPress:       {e         static char !           command[MaxTextExtent];            static int           length;            static KeySym            key_symbol;w  4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),(/           &key_symbol,(XComposeStatus *) NULL);i         *(command+length)='\0';xE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))e           { &             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);R             state|=ExitState;o             break;           }W1         if (AreaIsActive(scroll_info,event.xkey))x           {T             /*               Move slider.             */             switch (key_symbol)_
             {T               case XK_Home:                case XK_KP_Home:               {n!                 slider_info.id=0;r                 break;               }n               case XK_Up:n               case XK_KP_Up:               {o!                 slider_info.id--;                  break;               }F               case XK_Down:x               case XK_KP_Down:               {n!                 slider_info.id++;                  break;               }i               case XK_Prior:               case XK_KP_Prior:w               {i.                 slider_info.id-=visible_lines;                 break;               }t               case XK_Next:=               case XK_KP_Next:               {g.                 slider_info.id+=visible_lines;                 break;               }g               case XK_End:               case XK_KP_End:e               {s%                 slider_info.id=lines;e                 break;               }C
             }o#             state|=RedrawListState;              break;           }          break;       }d       case KeyRelease:         break;       case LeaveNotify:i       {r9         if (event.xcrossing.window != windows->widget.id)s           break;#         state|=InactiveWidgetState;t         break;       }        case MapNotify:w       {i         mask&=(~CWX);          mask&=(~CWY);n         break;       }        case MotionNotify:       {g
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));          if (slider_info.active)n           {i             /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0; 3             if (slider_info.y != slider_info.min_y) I               slider_info.id=(lines*(slider_info.y-slider_info.min_y+1))/t8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;i             break;           }e(         if (state & InactiveWidgetState)           break;M         if (dismiss_info.raised == MatteIsActive(dismiss_info,event.xmotion))e           {e             /*,               Dismiss button status changed.             */5             dismiss_info.raised=!dismiss_info.raised;gG             XDrawBeveledButton(display,&windows->widget,&dismiss_info);d             break;           }          break;       }h       case SelectionClear:       {l         list_info.id=(~0);         selection_info.id=(~0);          state|=RedrawListState;          break;       }*       case SelectionRequest:       {n         XSelectionEventi           notify;r           XSelectionRequestEvent           *request;e  !         if (list_info.id == (~0))w           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest));nN         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           Extent(primary_selection));b$         notify.type=SelectionNotify;         notify.send_event=True;6(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;P         (void) XSendEvent(request->display,request->requestor,False,NoEventMask,           (XEvent *) &notify);       }l       default:         break;     }i!   } while (!(state & ExitState));o-   if (text_info != windows->widget.font_info)e!     XFreeFont(display,text_info); )   XSetCursorState(display,windows,False);iE   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);e(   XCheckRefreshWindows(display,windows); }. #endif