 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                                   X   X                                     % O %                                    X X                                      % O %                                     X                                       % O %                                    X X                                      % O %                                   X   X                                     % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   #if defined(HasX11)  #include "xwindows.h"  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d X I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 8 %  Procedure ReadXImage reads an image from an X window. % * %  The format of the ReadXImage method is: % 5 %      Image *ReadXImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  */5 Export Image *ReadXImage(const ImageInfo *image_info)  { 
   XImportInfo      ximage_info;     XGetImportInfo(&ximage_info); 0   return(XImportImage(image_info,&ximage_info)); }  #else 5 Export Image *ReadXImage(const ImageInfo *image_info)  { F   MagickWarning(MissingDelegateWarning,"X11 library is not available",     image_info->filename);   return((Image *) NULL);  }  #endif   #if defined(HasX11)  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e X I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 5 %  Method WriteXImage writes an image to an X server.  % + %  The format of the WriteXImage method is:  % I %      unsigned int WriteXImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % J %    o status: Method WriteXImage return True if the image is displayed onK %      the X server.  False is returned is there is a memory shortage or if % %      the image file fails to write.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */I Export unsigned int WriteXImage(const ImageInfo *image_info,Image *image)  {    char     *client_name;   	   Display 
     *display;      unsigned long 
     state;     XResourceInfo      resource_info;  
   XrmDatabase      resource_database;     /*     Open X server connection.    */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)K     WriterExit(ResourceLimitWarning,"Unable to connect to X server",image);    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*/     Get user defaults from X resource database.    */+   client_name=SetClientName((char *) NULL); >   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);    resource_info.immutable=True;    if (image_info->delay)0     resource_info.delay=atoi(image_info->delay);   /*     Display image.   */   state=DefaultState; L   (void) XDisplayImage(display,&resource_info,&client_name,1,&image,&state);   XCloseDisplay(display);    return(True);  }  #else I Export unsigned int WriteXImage(const ImageInfo *image_info,Image *image)  { F   MagickWarning(MissingDelegateWarning,"X11 library is not available",     image->filename);    return(False); }  #endif