 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                               X   X   CCCC                                  % O %                                X X   C                                      % O %                                 X    C                                      % O %                                X X   C                                      % O %                               X   X   CCCC                                  % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d X C I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method ReadXCImage creates a constant image and initializes it to theH %  X server color as specified by the filename.  It allocates the memoryI %  necessary for the new Image structure and returns a pointer to the new 	 %  image.  % + %  The format of the ReadXCImage method is:  % 6 %      Image *ReadXCImage(const ImageInfo *image_info) % + %  A description of each parameter follows:  % F %    o image:  Method ReadXCImage returns a pointer to the image afterJ %      creating it. A null image is returned if there is a memory shortage& %      or if the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */6 Export Image *ReadXCImage(const ImageInfo *image_info) {    Image      *image;      int      y;     register int     x;     register PixelPacket     *q;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    if (image->columns == 0)     image->columns=1;    if (image->rows == 0)      image->rows=1;   /*     Initialize Image structure.    */6   (void) strcpy(image->filename,image_info->filename);   image->class=PseudoClass;    image->colors=1;!   image->colormap=(PixelPacket *) 6     AllocateMemory(image->colors*sizeof(PixelPacket));.   if (image->colormap == (PixelPacket *) NULL)F     ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);   /*     Initialize colormap.   */O   (void) QueryColorDatabase((char *) image_info->filename,&image->colormap[0]); '   for (y=0; y < (int) image->rows; y++)    { 0     q=SetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     {        image->indexes[x]=0;       *q=image->colormap[0];,       q->opacity=image->colormap[0].opacity;
       q++;     }      if (!SyncPixelCache(image))        break;   }    return(image); } 