 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            X   X  W   W  DDDD                               % O %                             X X   W   W  D   D                              % O %                              X    W   W  D   D                              % O %                             X X   W W W  D   D                              % O %                            X   X   W W   DDDD                               % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   #if defined(HasX11)  #include "xwindows.h"  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s X W D                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method IsXWD returns True if the image format type, identified by the %  magick string, is XWD.  % , %  The format of the ReadXWDImage method is: % 6 %      unsigned int IsXWD(const unsigned char *magick,# %        const unsigned int length)  % + %  A description of each parameter follows:  % J %    o status:  Method IsXWD returns True if the image format type is XWD. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */P Export unsigned int IsXWD(const unsigned char *magick,const unsigned int length) {    if (length < 8)      return(False);1   if ((magick[1] == 0x00) && (magick[2] == 0x00)) 3     if ((magick[5] == 0x00) && (magick[6] == 0x00)) 5       if ((magick[4] == 0x07) || (magick[7] == 0x07))          return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d X W D I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method ReadXWDImage reads an X Window System window dump image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % , %  The format of the ReadXWDImage method is: % 7 %      Image *ReadXWDImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadXWDImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadXWDImage(const ImageInfo *image_info)  {    Image      *image;   
   IndexPacket 
     index;     int      status,      y;     register int     i,     x;     register PixelPacket     *q;      register unsigned long
     pixel;     unsigned long      lsb_first,     length;      XColor     *colors;     XImage     *ximage;     XWDFileHeader      header;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*       Read in header information.   */7   status=ReadBlob(image,sz_XWDheader,(char *) &header);    if (status == False)L     ReaderExit(CorruptImageWarning,"Unable to read dump file header",image);%   image->columns=header.pixmap_width; #   image->rows=header.pixmap_height;    /*@     Ensure the header byte-order is most-significant byte first.   */   lsb_first=1;   if (*(char *) &lsb_first) 5     MSBFirstOrderLong((char *) &header,sz_XWDheader);    /*:     Check to see if the dump file is in the proper format.   */.   if (header.file_version != XWD_FILE_VERSION)M     ReaderExit(CorruptImageWarning,"XWD file format version mismatch",image); (   if (header.header_size < sz_XWDheader)I     ReaderExit(CorruptImageWarning,"XWD header size is too small",image); )   length=header.header_size-sz_XWDheader; C   image->comments=(char *) AllocateMemory((length+1)*sizeof(char)); '   if (image->comments == (char *) NULL) F     ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);9   status=ReadBlob(image,length,(char *) image->comments);    image->comments[length]='\0';    if (status == False)O     ReaderExit(CorruptImageWarning,"Unable to read window name from dump file", 
       image);    /*     Initialize the X image.    */3   ximage=(XImage *) AllocateMemory(sizeof(XImage));     if (ximage == (XImage *) NULL)F     ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);$   ximage->depth=header.pixmap_depth;&   ximage->format=header.pixmap_format;!   ximage->xoffset=header.xoffset;    ximage->data=(char *) NULL; $   ximage->width=header.pixmap_width;&   ximage->height=header.pixmap_height;'   ximage->bitmap_pad=header.bitmap_pad; /   ximage->bytes_per_line=header.bytes_per_line; '   ximage->byte_order=header.byte_order; )   ximage->bitmap_unit=header.bitmap_unit; 3   ximage->bitmap_bit_order=header.bitmap_bit_order; /   ximage->bits_per_pixel=header.bits_per_pixel; #   ximage->red_mask=header.red_mask; '   ximage->green_mask=header.green_mask; %   ximage->blue_mask=header.blue_mask;    status=XInitImage(ximage);   if (status == False)?     ReaderExit(CorruptImageWarning,"Invalid XWD header",image);    /*     Read colormap.   */   colors=(XColor *) NULL;    if (header.ncolors != 0)     {        XWDColor         color;         colors=(XColor *) E         AllocateMemory((unsigned int) header.ncolors*sizeof(XColor)); $       if (colors == (XColor *) NULL)J         ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);.       for (i=0; i < (int) header.ncolors; i++)       { ;         status=ReadBlob(image,sz_XWDColor,(char *) &color);          if (status == False))           ReaderExit(CorruptImageWarning, =             "Unable to read color map from dump file",image); $         colors[i].pixel=color.pixel;          colors[i].red=color.red;$         colors[i].green=color.green;"         colors[i].blue=color.blue;$         colors[i].flags=color.flags;       }        /*D         Ensure the header byte-order is most-significant byte first.       */       lsb_first=1;       if (*(char *) &lsb_first) 0         for (i=0; i < (int) header.ncolors; i++)	         { M           MSBFirstOrderLong((char *) &colors[i].pixel,sizeof(unsigned long)); O           MSBFirstOrderShort((char *) &colors[i].red,3*sizeof(unsigned short)); 	         }      }    /*     Allocate the pixel buffer.   */    if (ximage->format == ZPixmap)1     length=ximage->bytes_per_line*ximage->height;    else?     length=ximage->bytes_per_line*ximage->height*ximage->depth; E   ximage->data=(char *) AllocateMemory(length*sizeof(unsigned char)); $   if (ximage->data == (char *) NULL)F     ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);-   status=ReadBlob(image,length,ximage->data);    if (status == False)G     ReaderExit(CorruptImageWarning,"Unable to read dump pixmap",image);    /*!     Convert image to MIFF format.    */   image->columns=ximage->width;    image->rows=ximage->height; ?   if ((colors == (XColor *) NULL) || (ximage->red_mask != 0) || <       (ximage->green_mask != 0) || (ximage->blue_mask != 0))     image->class=DirectClass;    else     image->class=PseudoClass;    image->colors=header.ncolors;    if (image_info->ping)      {        if (header.ncolors != 0)         FreeMemory(colors);        CloseBlob(image);        return(image);     }    switch (image->class)    {      case DirectClass:      default:     {        register unsigned long         color;         unsigned long          blue_mask,         blue_shift,          green_mask,          green_shift,         red_mask,          red_shift;         /*:         Determine shift and mask for red, green, and blue.       */        red_mask=ximage->red_mask;       red_shift=0;$       while ((red_mask & 0x01) == 0)       {          red_mask>>=1;          red_shift++;       } $       green_mask=ximage->green_mask;       green_shift=0;&       while ((green_mask & 0x01) == 0)       {          green_mask>>=1;          green_shift++;       } "       blue_mask=ximage->blue_mask;       blue_shift=0; %       while ((blue_mask & 0x01) == 0)        {          blue_mask>>=1;         blue_shift++;        }        /*/         Convert X image to DirectClass packets.        */       if (image->colors != 0) -         for (y=0; y < (int) image->rows; y++) 	         { 6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           { (             pixel=XGetPixel(ximage,x,y);E             index=(unsigned short) ((pixel >> red_shift) & red_mask); 1             q->red=XDownScale(colors[index].red); I             index=(unsigned short) ((pixel >> green_shift) & green_mask); 5             q->green=XDownScale(colors[index].green); G             index=(unsigned short) ((pixel >> blue_shift) & blue_mask); 3             q->blue=XDownScale(colors[index].blue);              q++;           } %           if (!SyncPixelCache(image))              break;)           if (QuantumTick(y,image->rows)) 9             ProgressMonitor(LoadImageText,y,image->rows); 	         } 
       else-         for (y=0; y < (int) image->rows; y++) 	         { 6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           { (             pixel=XGetPixel(ximage,x,y);2             color=(pixel >> red_shift) & red_mask;7             q->red=XDownScale((color*65535L)/red_mask); 6             color=(pixel >> green_shift) & green_mask;;             q->green=XDownScale((color*65535L)/green_mask); 4             color=(pixel >> blue_shift) & blue_mask;9             q->blue=XDownScale((color*65535L)/blue_mask);              q++;           } %           if (!SyncPixelCache(image))              break;)           if (QuantumTick(y,image->rows)) 9             ProgressMonitor(LoadImageText,y,image->rows); 	         }        break;     }      case PseudoClass:      {        /*/         Convert X image to PseudoClass packets.        */%       image->colormap=(PixelPacket *) :         AllocateMemory(image->colors*sizeof(PixelPacket));2       if (image->colormap == (PixelPacket *) NULL)J         ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);-       for (i=0; i < (int) image->colors; i++)        { 9         image->colormap[i].red=XDownScale(colors[i].red); =         image->colormap[i].green=XDownScale(colors[i].green); ;         image->colormap[i].blue=XDownScale(colors[i].blue);        } +       for (y=0; y < (int) image->rows; y++)        { 4         q=SetPixelCache(image,0,y,image->columns,1);&         if (q == (PixelPacket *) NULL)           break;0         for (x=0; x < (int) image->columns; x++)	         { &           index=XGetPixel(ximage,x,y);"           image->indexes[x]=index;%           if (index >= image->colors) K             ReaderExit(CorruptImageWarning,"invalid colormap index",image); &           *q++=image->colormap[index];	         } #         if (!SyncPixelCache(image))            break;'         if (QuantumTick(y,image->rows)) 7           ProgressMonitor(LoadImageText,y,image->rows);        }        break;     }    }    /*     Free image and colormap.   */   if (header.ncolors != 0)     FreeMemory(colors);    FreeMemory(ximage->data);    FreeMemory(ximage);    CloseBlob(image);    return(image); }  #else 7 Export Image *ReadXWDImage(const ImageInfo *image_info)  { F   MagickWarning(MissingDelegateWarning,"X11 library is not available",     image_info->filename);   return((Image *) NULL);  }  #endif   #if defined(HasX11)  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e X W D I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % B %  Method WriteXWDImage writes an image to a file in X window dump %  rasterfile format.  % - %  The format of the WriteXWDImage method is:  % K %      unsigned int WriteXWDImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % H %    o status: Method WriteXWDImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K Export unsigned int WriteXWDImage(const ImageInfo *image_info,Image *image)  {    int      y;     register int     i,     x;     register PixelPacket     *p;      register unsigned char     *q;      unsigned char      *pixels;     unsigned int     bits_per_pixel,      bytes_per_line,      scanline_pad,      status;      unsigned long      lsb_first;     XWDFileHeader      xwd_header;      /*     Open output image file.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);)   TransformRGBImage(image,RGBColorspace);    /*     Initialize XWD file header.    */@   xwd_header.header_size=sz_XWDheader+Extent(image->filename)+1;4   xwd_header.file_version=(CARD32) XWD_FILE_VERSION;,   xwd_header.pixmap_format=(CARD32) ZPixmap;J   xwd_header.pixmap_depth=(CARD32) (image->class == DirectClass ? 24 : 8);2   xwd_header.pixmap_width=(CARD32) image->columns;0   xwd_header.pixmap_height=(CARD32) image->rows;    xwd_header.xoffset=(CARD32) 0;*   xwd_header.byte_order=(CARD32) MSBFirst;I   xwd_header.bitmap_unit=(CARD32) (image->class == DirectClass ? 32 : 8); 0   xwd_header.bitmap_bit_order=(CARD32) MSBFirst;H   xwd_header.bitmap_pad=(CARD32) (image->class == DirectClass ? 32 : 8);8   bits_per_pixel=(image->class == DirectClass ? 24 : 8);4   xwd_header.bits_per_pixel=(CARD32) bits_per_pixel;8   bytes_per_line=(CARD32) ((((xwd_header.bits_per_pixel*:     xwd_header.pixmap_width)+((xwd_header.bitmap_pad)-1))/=     (xwd_header.bitmap_pad))*((xwd_header.bitmap_pad) >> 3)); 4   xwd_header.bytes_per_line=(CARD32) bytes_per_line;"   xwd_header.visual_class=(CARD32)>     (image->class == DirectClass ? DirectColor : PseudoColor);L   xwd_header.red_mask=(CARD32) (image->class == DirectClass ? 0xff0000 : 0);L   xwd_header.green_mask=(CARD32) (image->class == DirectClass ? 0xff00 : 0);I   xwd_header.blue_mask=(CARD32) (image->class == DirectClass ? 0xff : 0); J   xwd_header.bits_per_rgb=(CARD32) (image->class == DirectClass ? 24 : 8);&   xwd_header.colormap_entries=(CARD32)8     (image->class == DirectClass ? 256 : image->colors);G   xwd_header.ncolors=(image->class == DirectClass ? 0 : image->colors); 2   xwd_header.window_width=(CARD32) image->columns;0   xwd_header.window_height=(CARD32) image->rows;   xwd_header.window_x=0;   xwd_header.window_y=0;(   xwd_header.window_bdrwidth=(CARD32) 0;   /*     Write XWD header.    */   lsb_first=1;   if (*(char *) &lsb_first) ?     MSBFirstOrderLong((char *) &xwd_header,sizeof(xwd_header)); <   (void) WriteBlob(image,sz_XWDheader,(char *) &xwd_header);M   (void) WriteBlob(image,Extent(image->filename)+1,(char *) image->filename); "   if (image->class == PseudoClass)     {        XColor         *colors;         XWDColor         color;         /*         Dump colormap to file.       */E       colors=(XColor *) AllocateMemory(image->colors*sizeof(XColor)); $       if (colors == (XColor *) NULL)J         WriterExit(ResourceLimitWarning,"Memory allocation failed",image);-       for (i=0; i < (int) image->colors; i++)        {          colors[i].pixel=i;7         colors[i].red=XUpScale(image->colormap[i].red); ;         colors[i].green=XUpScale(image->colormap[i].green); 9         colors[i].blue=XUpScale(image->colormap[i].blue); 1         colors[i].flags=DoRed | DoGreen | DoBlue;          colors[i].pad=0;!         if (*(char *) &lsb_first)            { F             MSBFirstOrderLong((char *) &colors[i].pixel,sizeof(long));H             MSBFirstOrderShort((char *) &colors[i].red,3*sizeof(short));           }        } -       for (i=0; i < (int) image->colors; i++)        { 4         color.pixel=(unsigned long) colors[i].pixel;          color.red=colors[i].red;$         color.green=colors[i].green;"         color.blue=colors[i].blue;$         color.flags=colors[i].flags;<         (void) WriteBlob(image,sz_XWDColor,(char *) &color);       }        FreeMemory(colors);      }    /*     Allocate memory for pixels.    */   pixels=(unsigned char *)7     AllocateMemory(image->columns*sizeof(PixelPacket)); '   if (pixels == (unsigned char *) NULL) F     WriterExit(ResourceLimitWarning,"Memory allocation failed",image);   /*&     Convert MIFF to XWD raster pixels.   */   scanline_pad=(unsigned int) <     (bytes_per_line-((image->columns*bits_per_pixel) >> 3));'   for (y=0; y < (int) image->rows; y++)    { 0     p=GetPixelCache(image,0,y,image->columns,1);"     if (p == (PixelPacket *) NULL)       break;
     q=pixels; ,     for (x=0; x < (int) image->columns; x++)     { &       if (image->class == PseudoClass)         *q++=image->indexes[x]; 
       else	         { !           *q++=DownScale(p->red); #           *q++=DownScale(p->green); "           *q++=DownScale(p->blue);	         } 
       p++;     } *     for (x=0; x < (int) scanline_pad; x++)
       *q++=0; 5     (void) WriteBlob(image,q-pixels,(char *) pixels); *     if (image->previous == (Image *) NULL)%       if (QuantumTick(y,image->rows)) 5         ProgressMonitor(SaveImageText,y,image->rows);    }    FreeMemory(pixels);    CloseBlob(image);    return(True);  }  #else K Export unsigned int WriteXWDImage(const ImageInfo *image_info,Image *image)  { F   MagickWarning(MissingDelegateWarning,"X11 library is not available",     image->filename);    return(False); }  #endif