 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %          X   X  W   W  IIIII  N   N  DDDD    OOO   W   W  SSSSS             % O %           X X   W   W    I    NN  N  D   D  O   O  W   W  SS                % O %            X    W   W    I    N N N  D   D  O   O  W   W   SSS              % O %           X X   W W W    I    N  NN  D   D  O   O  W W W     SS             % O %          X   X   W W   IIIII  N   N  DDDD    OOO    W W   SSSSS             % O %                                                                             % O %                                                                             % O %                     X11 Utility Methods for ImageMagick                     % O %                                                                             % O %                                                                             % O %                               Software Design                               % O %                                 John Cristy                                 % O %                                  July 1992                                  % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   #if defined(HasX11)  #include "xwindows.h"  /*   X defines. */L #define XGammaPixel(map,gamma,color,dx)  (unsigned long) (map->base_pixel+ \I   ((gamma[(color)->red].red*map->red_max+(1 << (dx-1)))/((1 << dx)-1))* \      map->red_mult+ \O   ((gamma[(color)->green].green*map->green_max+(1 << (dx-1)))/((1 << dx)-1))* \      map->green_mult+ \L   ((gamma[(color)->blue].blue*map->blue_max+(1 << (dx-1)))/((1 << dx)-1))* \     map->blue_mult) I #define XStandardPixel(map,color,dx)  (unsigned long) (map->base_pixel+ \ K   (((color).red*map->red_max+(1 << (dx-1)))/((1 << dx)-1))*map->red_mult+ \ P   (((color).green*map->green_max+(1 << (dx-1)))/((1 << dx)-1))*map->green_mult+\L   (((color).blue*map->blue_max+(1 << (dx-1)))/((1 << dx)-1))*map->blue_mult)   /*   Global declarations. */ static volatile unsigned int   xerror_alert = False;    /*   Method prototypes. */ static void G   XMakeImageLSBFirst(const XResourceInfo *,const XWindowInfo *,Image *,      XImage *,XImage *), G   XMakeImageMSBFirst(const XResourceInfo *,const XWindowInfo *,Image *,      XImage *,XImage *);    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s T r u e                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method IsTrue returns True if the message is "true", "on", "yes" or "1".  % & %  The format of the IsTrue method is: % / %      unsigned int IsTrue(const char *message)  % + %  A description of each parameter follows:  % G %    o option: either True or False depending on the message parameter.  % 9 %    o message: Specifies a pointer to a character array.  %  %  *// Export unsigned int IsTrue(const char *message)  {    if (message == (char *) NULL)      return(False);)   if (Latin1Compare(message,"true") == 0)      return(True); '   if (Latin1Compare(message,"on") == 0)      return(True); (   if (Latin1Compare(message,"yes") == 0)     return(True); &   if (Latin1Compare(message,"1") == 0)     return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X A n n o t a t e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 7 %  Method XAnnotateImage annotates the image with text.  % . %  The format of the XAnnotateImage method is: % 4 %      unsigned int XAnnotateImage(Display *display,K %        const XPixelInfo *pixel,XAnnotateInfo *annotate_info,Image *image)  % + %  A description of each parameter follows:  % A %    o status: Method XAnnotateImage returns True if the image is I %      successfully annotated with text.  False is returned is there is a  %      memory shortage.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % < %    o pixel: Specifies a pointer to a XPixelInfo structure. % G %    o annotate_info: Specifies a pointer to a XAnnotateInfo structure.  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */4 Export unsigned int XAnnotateImage(Display *display,D   const XPixelInfo *pixel,XAnnotateInfo *annotate_info,Image *image) {    GC     annotate_context;      Image      *annotate_image;     int      x,     y;     Pixmap     annotate_pixmap;     register PixelPacket     *q;      unsigned int
     depth,     height, 
     matte,
     width;     Window     root_window;     XGCValues      context_values;      XImage     *annotate_ximage;      /*     Initialize annotated image.    */&   assert(display != (Display *) NULL);'   assert(pixel != (XPixelInfo *) NULL); 2   assert(annotate_info != (XAnnotateInfo *) NULL);"   assert(image != (Image *) NULL);   /*      Initialize annotated pixmap.   */;   root_window=XRootWindow(display,XDefaultScreen(display)); 7   depth=XDefaultDepth(display,XDefaultScreen(display)); I   annotate_pixmap=XCreatePixmap(display,root_window,annotate_info->width, '     annotate_info->height,(int) depth); '   if (annotate_pixmap == (Pixmap) NULL)      return(False);   /*     Initialize graphics info.    */   context_values.background=0;1   context_values.foreground=(unsigned long) (~0); 4   context_values.font=annotate_info->font_info->fid;H   annotate_context=XCreateGC(display,root_window,GCBackground | GCFont |"     GCForeground,&context_values);$   if (annotate_context == (GC) NULL)     return(False);   /*     Draw text to pixmap.   */>   XDrawImageString(display,annotate_pixmap,annotate_context,0,?     (int) annotate_info->font_info->ascent,annotate_info->text, !     Extent(annotate_info->text)); $   XFreeGC(display,annotate_context);   /*!     Initialize annotated X image.    */M   annotate_ximage=XGetImage(display,annotate_pixmap,0,0,annotate_info->width, -     annotate_info->height,AllPlanes,ZPixmap); )   if (annotate_ximage == (XImage *) NULL)      return(False);'   XFreePixmap(display,annotate_pixmap);    /*     Initialize annotated image.    */3   annotate_image=AllocateImage((ImageInfo *) NULL); '   if (annotate_image == (Image *) NULL)      return(False);/   annotate_image->columns=annotate_info->width; -   annotate_image->rows=annotate_info->height;    /*(     Transfer annotated X image to image.   */   width=image->columns;    height=image->rows;    x=0;   y=0;F   (void) XParseGeometry(annotate_info->geometry,&x,&y,&width,&height);#   if (GetPixelCache(image,x,y,1,1))      { 8       annotate_image->background_color=(*image->pixels);!       annotate_image->matte=True;      } 0   for (y=0; y < (int) annotate_image->rows; y++)   { B     q=SetPixelCache(annotate_image,0,y,annotate_image->columns,1);"     if (q == (PixelPacket *) NULL)       break;5     for (x=0; x < (int) annotate_image->columns; x++)      { :       q->opacity=(Quantum) XGetPixel(annotate_ximage,x,y);$       if (q->opacity == Transparent)	         {            /*3             Set this pixel to the background color.            */2           q->red=XDownScale(pixel->box_color.red);6           q->green=XDownScale(pixel->box_color.green);4           q->blue=XDownScale(pixel->box_color.blue);           q->opacity=Opaque;:           if (annotate_info->stencil == ForegroundStencil)
             { 2               *q=annotate_image->background_color;%               q->opacity=Transparent; 
             } 	         } 
       else	         {            /*,             Set this pixel to the pen color.           */2           q->red=XDownScale(pixel->pen_color.red);6           q->green=XDownScale(pixel->pen_color.green);4           q->blue=XDownScale(pixel->pen_color.blue);           q->opacity=Opaque;:           if (annotate_info->stencil == BackgroundStencil)
             { 2               *q=annotate_image->background_color;%               q->opacity=Transparent; 
             } 	         } 
       q++;     } (     if (!SyncPixelCache(annotate_image))       break;   } !   XDestroyImage(annotate_ximage);    /*      Determine annotate geometry.   */F   (void) XParseGeometry(annotate_info->geometry,&x,&y,&width,&height);M   if ((width != annotate_image->columns) || (height != annotate_image->rows))      { 
       char&         image_geometry[MaxTextExtent];         /*         Scale image.       */8       FormatString(image_geometry,"%ux%u",width,height);C       TransformImage(&annotate_image,(char *) NULL,image_geometry);      } $   if (annotate_info->degrees != 0.0)     {        double         normalized_degrees;          Image          *rotate_image;  	       int          rotations;         /*         Rotate image.        */F       rotate_image=RotateImage(annotate_image,annotate_info->degrees);)       if (rotate_image == (Image *) NULL)          return(False);#       DestroyImage(annotate_image); "       annotate_image=rotate_image;       /*9         Annotation is relative to the degree of rotation.        */0       normalized_degrees=annotate_info->degrees;(       while (normalized_degrees < -45.0)"         normalized_degrees+=360.0;?       for (rotations=0; normalized_degrees > 45.0; rotations++) !         normalized_degrees-=90.0;        switch (rotations % 4)       {          default:         case 0:            break;         case 1: 	         {            /*             Rotate 90 degrees.           */'           x-=annotate_image->columns/2; '           y+=annotate_image->columns/2;            break;	         }          case 2: 	         {            /*             Rotate 180 degrees.            */%           x-=annotate_image->columns;            break;	         }          case 3: 	         {            /*             Rotate 270 degrees.            */'           x-=annotate_image->columns/2; >           y-=annotate_image->rows-(annotate_image->columns/2);           break;	         }        }      }    /*"     Composite text onto the image.   */0   for (y=0; y < (int) annotate_image->rows; y++)   { B     q=GetPixelCache(annotate_image,0,y,annotate_image->columns,1);"     if (q == (PixelPacket *) NULL)       break;5     for (x=0; x < (int) annotate_image->columns; x++)      { $       if (q->opacity != Transparent)         q->opacity=Opaque;
       q++;     }    } F   (void) XParseGeometry(annotate_info->geometry,&x,&y,&width,&height);   matte=image->matte; ;   CompositeImage(image,OverCompositeOp,annotate_image,x,y);    image->matte=matte;    DestroyImage(annotate_image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t F o n t                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method XBestFont returns the "best" font.  "Best" is defined as a font J %  specified in the X resource database or a font such that the text widthG %  displayed with the font does not exceed the specified maximum width.  % ) %  The format of the XBestFont method is:  % / %      XFontStruct *XBestFont(Display *display, I %        const XResourceInfo *resource_info,const unsigned int text_font)  % + %  A description of each parameter follows:  % D %    o font: XBestFont returns a pointer to a XFontStruct structure. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % I %    o text_font:  True is font should be mono-spaced (typewriter style).  %  %  */  $ static char **FontToList(char *font) {    char     **fontlist;      register char      *p,      *q;      register int     i;     unsigned int
     fonts;     if (font == (char *) NULL)     return((char **) NULL);    /*$     Convert string to an ASCII list.   */
   fonts=1;   for (p=font; *p != '\0'; p++) 2     if ((*p == ':') || (*p == ';') || (*p == ','))       fonts++;>   fontlist=(char **) AllocateMemory((fonts+1)*sizeof(char *));!   if (fontlist == (char **) NULL)      { B       MagickWarning(ResourceLimitWarning,"Unable to convert font",$         "Memory allocation failed");       return((char **) NULL);      } 	   p=font; !   for (i=0; i < (int) fonts; i++)    {      for (q=p; *q != '\0'; q++)4       if ((*q == ':') || (*q == ';') || (*q == ','))         break;>     fontlist[i]=(char *) AllocateMemory((q-p+1)*sizeof(char));%     if (fontlist[i] == (char *) NULL)        { D         MagickWarning(ResourceLimitWarning,"Unable to convert font",&           "Memory allocation failed");         return((char **) NULL);        } &     (void) strncpy(fontlist[i],p,q-p);     fontlist[i][q-p]='\0';
     p=q+1;   }    fontlist[i]=(char *) NULL;   return(fontlist);  }   / Export XFontStruct *XBestFont(Display *display, B   const XResourceInfo *resource_info,const unsigned int text_font) {    static const char 
     *Fonts[]=      { 9       "-*-helvetica-medium-r-*-*-12-*-*-*-*-*-iso8859-*", =       "-adobe-helvetica-medium-r-*-*-14-*-*-*-*-*-iso8859-*", 9       "-*-helvetica-medium-r-*-*-14-*-*-*-*-*-iso8859-*", 6       "-*-lucida-medium-r-*-*-14-*-*-*-*-*-iso8859-*",
       "9x15",        (char *) NULL      },     *TextFonts[]=      { ;       "-adobe-courier-medium-r-*-*-12-*-*-*-*-*-iso8859-*", ;       "-adobe-courier-medium-r-*-*-14-*-*-*-*-*-iso8859-*", 7       "-*-courier-medium-r-*-*-14-*-*-*-*-*-iso8859-*", 5       "-*-fixed-medium-r-*-*-14-*-*-*-*-*-iso8859-*", 
       "9x15",        (char *) NULL      };     char     *font_name;      register const char      **p;  
   XFontStruct      *font_info;   !   font_info=(XFontStruct *) NULL;     font_name=resource_info->font;   if (text_font)'     font_name=resource_info->text_font; !   if (font_name != (char *) NULL)      { 
       char         **fontlist;          register int
         i;         /*A         Load preferred font specified in the X resource database.        */%       fontlist=FontToList(font_name); %       if (fontlist != (char **) NULL) 	         { 6           for (i=0; fontlist[i] != (char *) NULL; i++)           { 2             if (font_info == (XFontStruct *) NULL)<               font_info=XLoadQueryFont(display,fontlist[i]);$             FreeMemory(fontlist[i]);           }            FreeMemory(fontlist); 	         } ,       if (font_info == (XFontStruct *) NULL)F         MagickWarning(XServerWarning,"Unable to load font",font_name);     }    /*5     Load fonts from list of fonts until one is found.    */
   p=Fonts;   if (text_font)     p=TextFonts;=   if (XDisplayHeight(display,XDefaultScreen(display)) >= 748)      p++;   while (*p != (char *) NULL)    { *     if (font_info != (XFontStruct *) NULL)       break;2     font_info=XLoadQueryFont(display,(char *) *p);     p++;   }    return(font_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t I c o n S i z e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method XBestIconSize returns the "best" icon size.  "Best" is defined as L %  an icon size that maintains the aspect ratio of the image.  If the windowH %  manager has preferred icon sizes, one of the preferred sizes is used. % - %  The format of the XBestIconSize method is:  % L %      void XBestIconSize(Display *display,XWindowInfo *window,Image *image) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */L Export void XBestIconSize(Display *display,XWindowInfo *window,Image *image) {  #define MaxIconSize  96      double     scale_factor;      int      i,     number_sizes;      unsigned int     height,      icon_height,     icon_width, 
     width;     Window     root_window;     XIconSize      *icon_size,      *size_list;      /*G     Determine if the window manager has specified preferred icon sizes.    */&   assert(display != (Display *) NULL);)   assert(window != (XWindowInfo *) NULL); "   assert(image != (Image *) NULL);   window->width=MaxIconSize;   window->height=MaxIconSize;    icon_size=(XIconSize *) NULL;    number_sizes=0; 2   root_window=XRootWindow(display,window->screen);G   if (XGetIconSizes(display,root_window,&size_list,&number_sizes) != 0) @     if ((number_sizes > 0) && (size_list != (XIconSize *) NULL))       icon_size=size_list;&   if (icon_size == (XIconSize *) NULL)     {        /*3         Window manager does not restrict icon size.        */!       icon_size=XAllocIconSize(); *       if (icon_size == (XIconSize *) NULL)	         { L           MagickWarning(ResourceLimitWarning,"Unable to get best icon size",(             "Memory allocation failed");           return; 	         }        icon_size->min_width=1; '       icon_size->max_width=MaxIconSize;        icon_size->min_height=1;(       icon_size->max_height=MaxIconSize;       icon_size->width_inc=1;        icon_size->height_inc=1;     }    /*$     Determine aspect ratio of image.   */   width=image->columns;    height=image->rows;    i=0;   if (window->crop_geometry)F     (void) XParseGeometry(window->crop_geometry,&i,&i,&width,&height);   /*C     Look for an icon size that maintains the aspect ratio of image.    */3   scale_factor=(double) icon_size->max_width/width; =   if (scale_factor > ((double) icon_size->max_height/height)) 7     scale_factor=(double) icon_size->max_height/height; "   icon_width=icon_size->min_width;1   while ((int) icon_width < icon_size->max_width)    { +     if (icon_width >= (scale_factor*width))        break;%     icon_width+=icon_size->width_inc;    } $   icon_height=icon_size->min_height;3   while ((int) icon_height < icon_size->max_height)    { -     if (icon_height >= (scale_factor*height))        break;'     icon_height+=icon_size->height_inc;    }    XFree((void *) icon_size);   window->width=icon_width;    window->height=icon_height;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t P i x e l                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method XBestPixel returns a pixel from an array of pixels that is closestO %  to the requested color.  If the color array is NULL, the colors are obtained  %  from the X server.  % * %  The format of the XBestPixel method is: % O %      void XBestPixel(Display *display,const Colormap colormap,XColor *colors, 2 %        unsigned int number_colors,XColor *color) % + %  A description of each parameter follows:  % I %    o pixel: XBestPixel returns the pixel value closest to the requested 
 %      color.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o colormap: Specifies the ID of the X server colormap.  % 7 %    o colors: Specifies an array of XColor structures.  % F %    o number_colors: Specifies the number of XColor structures in the %      color definition array. % J %    o color: Specifies the desired RGB value to find in the colors array. %  %  */O Export void XBestPixel(Display *display,const Colormap colormap,XColor *colors, +   unsigned int number_colors,XColor *color)  {    double     min_distance;      int      query_server,      status;      long	     mean;      register double      distance_squared;      register int
     distance,      i,     j;     /*<     Find closest representation for the requested RGB color.   */&   assert(display != (Display *) NULL);#   assert(color != (XColor *) NULL); -   status=XAllocColor(display,colormap,color);    if (status != 0)     return; )   query_server=colors == (XColor *) NULL;    if (query_server)      {        /*         Read X server colormap.        */E       colors=(XColor *) AllocateMemory(number_colors*sizeof(XColor)); $       if (colors == (XColor *) NULL)	         { J           MagickWarning(XServerWarning,"Unable to read X server colormap",(             "Memory allocation failed");           return; 	         } -       for (i=0; i < (int) number_colors; i++) *         colors[i].pixel=(unsigned long) i;       if (number_colors > 256)         number_colors=256;:       XQueryColors(display,colormap,colors,number_colors);     }    min_distance=0;    j=0;)   for (i=0; i < (int) number_colors; i++)    { &     mean=(colors[i].red+color->red)/2;,     distance=colors[i].red-(int) color->red;B     distance_squared=(2.0*65536.0+mean)*distance*distance/65536.0;0     distance=colors[i].green-(int) color->green;,     distance_squared+=4.0*distance*distance;.     distance=colors[i].blue-(int) color->blue;G     distance_squared+=(3.0*65536.0-1.0-mean)*distance*distance/65536.0; 6     if ((i == 0) || (distance_squared < min_distance))       { &         min_distance=distance_squared;%         color->pixel=colors[i].pixel;          j=i;       }    } 2   (void) XAllocColor(display,colormap,&colors[j]);   if (query_server)      FreeMemory(colors);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t V i s u a l I n f o                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method XBestVisualInfo returns visual information for a visual that is 9 %  the "best" the server supports.  "Best" is defined as:  % J %    1. Restrict the visual list to those supported by the default screen. % K %    2. If a visual type is specified, restrict the visual list to those of  %       that type. % I %    3. If a map type is specified, choose the visual that matches the id + %       specified by the Standard Colormap.  % F %    4  From the list of visuals, choose one that can display the mostJ %       simultaneous colors.  If more than one visual can display the sameE %       number of simultaneous colors, one is chosen based on a rank.  % / %  The format of the XBestVisualInfo method is:  % 5 %      XVisualInfo *XBestVisualInfo(Display *display, B %        XStandardColormap *map_info,XResourceInfo *resource_info) % + %  A description of each parameter follows:  % J %    o visual_info: XBestVisualInfo returns a pointer to a X11 XVisualInfo %      structure.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %  %  */5 Export XVisualInfo *XBestVisualInfo(Display *display, ;   XStandardColormap *map_info,XResourceInfo *resource_info)  {  #define MaxStandardColormaps  7 6 #define XVisualColormapSize(visual_info) Min( (int) (\N   (visual_info->class == TrueColor) || (visual_info->class == DirectColor) ? \O    visual_info->red_mask | visual_info->green_mask | visual_info->blue_mask : \ 7    visual_info->colormap_size),1 << visual_info->depth)      char     *map_type,     *visual_type;      register int     i;     static int     number_visuals;      static XVisualInfo     visual_template;     unsigned int     visual_mask;  
   XVisualInfo      *visual_info,      *visual_list;      /*,     Restrict visual search by screen number.   */&   assert(display != (Display *) NULL);1   assert(map_info != (XStandardColormap *) NULL); 2   assert(resource_info != (XResourceInfo *) NULL);#   map_type=resource_info->map_type; )   visual_type=resource_info->visual_type;    visual_mask=VisualScreenMask; 1   visual_template.screen=XDefaultScreen(display); G   visual_template.depth=XDefaultDepth(display,XDefaultScreen(display)); ?   if (resource_info->immutable && (resource_info->colors != 0)) D     if ((int) resource_info->colors <= (1 << visual_template.depth))#       visual_mask|=VisualDepthMask; #   if (visual_type != (char *) NULL)      {        /*5         Restrict visual search by class or visual id.        */7       if (Latin1Compare("staticgray",visual_type) == 0) 	         { '           visual_mask|=VisualClassMask; +           visual_template.class=StaticGray; 	         } 
       else8         if (Latin1Compare("grayscale",visual_type) == 0)           { )             visual_mask|=VisualClassMask; ,             visual_template.class=GrayScale;           }          else<           if (Latin1Compare("staticcolor",visual_type) == 0)
             { +               visual_mask|=VisualClassMask; 0               visual_template.class=StaticColor;
             }            else>             if (Latin1Compare("pseudocolor",visual_type) == 0)               { -                 visual_mask|=VisualClassMask; 2                 visual_template.class=PseudoColor;               }              else>               if (Latin1Compare("truecolor",visual_type) == 0)                 { /                   visual_mask|=VisualClassMask; 2                   visual_template.class=TrueColor;                 }                elseB                 if (Latin1Compare("directcolor",visual_type) == 0)                   { 1                     visual_mask|=VisualClassMask; 6                     visual_template.class=DirectColor;                   }                  else@                   if (Latin1Compare("default",visual_type) == 0)                     { 0                       visual_mask|=VisualIDMask;C                       visual_template.visualid=XVisualIDFromVisual( I                         XDefaultVisual(display,XDefaultScreen(display)));                      }                    else6                     if (isdigit((int) (*visual_type)))                       { 2                         visual_mask|=VisualIDMask;1                         visual_template.visualid= ?                           strtol(visual_type,(char **) NULL,0);                        }                      elseM                       MagickWarning(OptionWarning,"Invalid visual specifier", %                         visual_type);      }    /*2     Get all visuals that meet our criteria so far.   */   number_visuals=0; B   visual_list=XGetVisualInfo(display,visual_mask,&visual_template,     &number_visuals); .   visual_mask=VisualScreenMask | VisualIDMask;E   if ((number_visuals == 0) || (visual_list == (XVisualInfo *) NULL))      {        /*<         Failed to get visual;  try using the default visual.       */G       MagickWarning(XServerWarning,"Unable to get visual",visual_type);        visual_template.visualid= M         XVisualIDFromVisual(XDefaultVisual(display,XDefaultScreen(display))); F       visual_list=XGetVisualInfo(display,visual_mask,&visual_template,         &number_visuals); I       if ((number_visuals == 0) || (visual_list == (XVisualInfo *) NULL)) %         return((XVisualInfo *) NULL); :       MagickWarning(XServerWarning,"Using default visual",.         XVisualClassName(visual_list->class));     } &   resource_info->color_recovery=False;N   if ((map_info != (XStandardColormap *) NULL) && (map_type != (char *) NULL))     { 
       Atom         map_property;   
       char          map_name[MaxTextExtent];  	       int 
         j,         number_maps,         status;          Window         root_window;         XStandardColormap          *map_list;         /*<         Choose a visual associated with a standard colormap.       */?       root_window=XRootWindow(display,XDefaultScreen(display));        status=0; .       if (Latin1Compare(map_type,"list") != 0)	         {            /*-             User specified Standard Colormap.            */E           FormatString((char *) map_name,"RGB_%.1024s_MAP",map_type);             Latin1Upper(map_name);C           map_property=XInternAtom(display,(char *) map_name,True); *           if (map_property != (Atom) NULL)O             status=XGetRGBColormaps(display,root_window,&map_list,&number_maps,                map_property);	         } 
       else	         {            static const char ,             *colormap[MaxStandardColormaps]=
             { (               "_HP_RGB_SMOOTH_MAP_LIST",               "RGB_BEST_MAP",                 "RGB_DEFAULT_MAP",               "RGB_GRAY_MAP",                "RGB_RED_MAP",               "RGB_GREEN_MAP",               "RGB_BLUE_MAP",              };             /*3             Choose a standard colormap from a list.            */2           for (i=0; i < MaxStandardColormaps; i++)           { H             map_property=XInternAtom(display,(char *) colormap[i],True);,             if (map_property == (Atom) NULL)               continue; O             status=XGetRGBColormaps(display,root_window,&map_list,&number_maps,                map_property);             if (status != 0)               break;           } P           resource_info->color_recovery=(i == 0);  /* _HP_RGB_SMOOTH_MAP_LIST */	         }        if (status == 0)	         { I           MagickWarning(XServerWarning,"Unable to get Standard Colormap",              map_type);'           return((XVisualInfo *) NULL); 	         }        /*E         Search all Standard Colormaps and visuals for ids that match.        */       *map_info=map_list[0]; #if !defined(PRE_R4_ICCCM)J       visual_template.visualid=XVisualIDFromVisual(visual_list[0].visual);%       for (i=0; i < number_maps; i++) *         for (j=0; j < number_visuals; j++)%           if (map_list[i].visualid == 9               XVisualIDFromVisual(visual_list[j].visual)) 
             { $               *map_info=map_list[i];'               visual_template.visualid= ;                 XVisualIDFromVisual(visual_list[j].visual);                break;
             } 9       if (map_info->visualid != visual_template.visualid) 	         { '           MagickWarning(XServerWarning, D             "Unable to match visual to Standard Colormap",map_type);'           return((XVisualInfo *) NULL); 	         }  #endif0       if (map_info->colormap == (Colormap) NULL)	         { N           MagickWarning(XServerWarning,"Standard Colormap is not initialized",             map_type);'           return((XVisualInfo *) NULL); 	         }        XFree((void *) map_list);      }    else     {        static const unsigned int          rank[]=            {              StaticGray,              GrayScale,             StaticColor,             DirectColor,             TrueColor,             PseudoColor            };         XVisualInfo          *p;          /*C         Pick one visual that displays the most simultaneous colors.        */       visual_info=visual_list;       p=visual_list;(       for (i=1; i < number_visuals; i++)       {          p++;F         if (XVisualColormapSize(p) > XVisualColormapSize(visual_info))           visual_info=p;         elseI           if (XVisualColormapSize(p) == XVisualColormapSize(visual_info)) :             if (rank[p->class] > rank[visual_info->class])               visual_info=p;       } H       visual_template.visualid=XVisualIDFromVisual(visual_info->visual);     }    XFree((void *) visual_list);   /*7     Retrieve only one visual by its screen & id number.    */B   visual_info=XGetVisualInfo(display,visual_mask,&visual_template,     &number_visuals); E   if ((number_visuals == 0) || (visual_info == (XVisualInfo *) NULL)) !     return((XVisualInfo *) NULL);    return(visual_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C h e c k R e f r e s h W i n d o w s                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method XCheckRefreshWindows checks the X server for exposure events forL %  a particular window and updates the area associated withe exposure event. % 4 %  The format of the XCheckRefreshWindows method is: % D %      void XCheckRefreshWindows(Display *display,XWindows *windows) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. %  %  */D Export void XCheckRefreshWindows(Display *display,XWindows *windows) {    XEvent
     event;  &   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL);    XDelay(display,SuspendTime);K   while (XCheckTypedWindowEvent(display,windows->command.id,Expose,&event)) G     (void) XCommandWidget(display,windows,(char const **) NULL,&event); I   while (XCheckTypedWindowEvent(display,windows->image.id,Expose,&event)) 3     XRefreshWindow(display,&windows->image,&event); #   XDelay(display,SuspendTime << 1); K   while (XCheckTypedWindowEvent(display,windows->command.id,Expose,&event)) G     (void) XCommandWidget(display,windows,(char const **) NULL,&event); I   while (XCheckTypedWindowEvent(display,windows->image.id,Expose,&event)) 3     XRefreshWindow(display,&windows->image,&event);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C l i e n t M e s s a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method XClientMessage sends a message to a window with XSendEvent.  TheC %  message is initialized with a particular protocol type and atom.  % 0 %  The format of the XClientMessage function is: % @ %      XClientMessage(display,window,protocol,message,timestamp) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % 9 %    o window: Specifies a pointer to a Window structure.  % ) %    o protocol: Specifies an atom value.  % E %    o message: Specifies an atom value which is the message to send.  % 1 %    o timestamp: Specifies a value of type Time.  %  %  */@ Export void XClientMessage(Display *display,const Window window,>   const Atom protocol,const Atom message,const Time timestamp) {    XClientMessageEvent      client_event;   &   assert(display != (Display *) NULL);"   client_event.type=ClientMessage;   client_event.window=window; %   client_event.message_type=protocol;    client_event.format=32; (   client_event.data.l[0]=(long) message;*   client_event.data.l[1]=(long) timestamp;H   XSendEvent(display,window,False,NoEventMask,(XEvent *) &client_event); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C l i e n t W i n d o w                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method XClientWindow finds a window, at or below the specified window, M %  which has a WM_STATE property.  If such a window is found, it is returned, - %  otherwise the argument window is returned.  % / %  The format of the XClientWindow function is:  % 9 %      client_window=XClientWindow(display,target_window)  % + %  A description of each parameter follows:  % O %    o client_window: XClientWindow returns a window, at or below the specified C %      window, which has a WM_STATE property otherwise the argument ! %      target_window is returned.  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o target_window: Specifies the window to find a WM_STATE property.  %  %  */B Export Window XClientWindow(Display *display,Window target_window) {    Atom
     state,	     type;      int      format,      status;      unsigned char 
     *data;     unsigned long 
     after,     number_items;      Window     client_window;  &   assert(display != (Display *) NULL);-   state=XInternAtom(display,"WM_STATE",True);    if (state == (Atom) NULL)      return(target_window);   type=(Atom) NULL; D   status=XGetWindowProperty(display,target_window,state,0L,0L,False,E     (Atom) AnyPropertyType,&type,&format,&number_items,&after,&data); 3   if ((status == Success) && (type != (Atom) NULL))      return(target_window);?   client_window=XWindowByProperty(display,target_window,state); %   if (client_window == (Window) NULL)      return(target_window);   return(client_window); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i g u r e I m a g e C o l o r m a p                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ; %  Method XConfigureImageColormap creates a new X colormap.  % 7 %  The format of the XConfigureImageColormap method is:  % 5 %      void XConfigureImageColormap(Display *display, E %        XResourceInfo *resource_info,XWindows *windows,Image *image)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */5 Export void XConfigureImageColormap(Display *display, >   XResourceInfo *resource_info,XWindows *windows,Image *image) { 
   Colormap
     colormap;      /*     Make standard colormap.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);I   XMakeStandardColormap(display,windows->visual_info,resource_info,image, +     windows->map_info,windows->pixel_info); '   colormap=windows->map_info->colormap; 9   XSetWindowColormap(display,windows->image.id,colormap); ;   XSetWindowColormap(display,windows->command.id,colormap); :   XSetWindowColormap(display,windows->widget.id,colormap);   if (windows->magnify.mapped)=     XSetWindowColormap(display,windows->magnify.id,colormap);    if (windows->pan.mapped)9     XSetWindowColormap(display,windows->pan.id,colormap); )   XSetCursorState(display,windows,False); A   XClientMessage(display,windows->image.id,windows->im_protocols, -     windows->im_update_colormap,CurrentTime);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n s t r a i n W i n d o w P o s i t i o n                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method XConstrainWindowPosition assures a window is positioned witin the  %  X server boundaries.  % 8 %  The format of the XConstrainWindowPosition method is: % O %      void XConstrainWindowPosition(Display *display,XWindowInfo *window_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % C %    o window_info: Specifies a pointer to a XWindowInfo structure.  %  %  */O Export void XConstrainWindowPosition(Display *display,XWindowInfo *window_info)  {    unsigned int
     limit;  &   assert(display != (Display *) NULL);.   assert(window_info != (XWindowInfo *) NULL);F   limit=XDisplayWidth(display,window_info->screen)-window_info->width;   if (window_info->x < 0)      window_info->x=0;    else%     if (window_info->x > (int) limit)        window_info->x=limit; H   limit=XDisplayHeight(display,window_info->screen)-window_info->height;   if (window_info->y < 0)      window_info->y=0;    else%     if (window_info->y > (int) limit)        window_info->y=limit;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D e l a y                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method XDelay suspends program execution for the number of milliseconds
 %  specified.  % % %  The format of the Delay method is:  % E %      void XDelay(Display *display,const unsigned long milliseconds)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % I %    o milliseconds: Specifies the number of milliseconds to delay before  %      returning.  %  %  */E Export void XDelay(Display *display,const unsigned long milliseconds)  { &   assert(display != (Display *) NULL);   (void) XFlush(display);    if (milliseconds == 0)     return; ; #if !defined(vms) && !defined(macintosh) && !defined(WIN32)  #if defined(sysv)    {  #include <sys/poll.h>   =     (void) poll((struct pollfd *) NULL,0,(int) milliseconds);    }  #else    {      struct timeval       timer;  *     timer.tv_sec=(long) milliseconds/1000;4     timer.tv_usec=(long) (milliseconds % 1000)*1000;O     (void) select(0,(XFD_SET *) NULL,(XFD_SET *) NULL,(XFD_SET *) NULL,&timer);    }  #endif #endif #if defined(vms)   { 	     float        timer;       timer=milliseconds/1000.0;     lib$wait(&timer);    }  #endif #if defined(WIN32)   Sleep(milliseconds); #endif }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D e s t r o y W i n d o w C o l o r s                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method XDestroyWindowColors frees X11 color resources previously saved on= %  a window by XRetainWindowColors or programs like xsetroot.  % 4 %  The format of the XDestroyWindowColors method is: % @ %      void XDestroyWindowColors(Display *display,Window window) % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % 9 %    o window: Specifies a pointer to a Window structure.  %  %  */@ Export void XDestroyWindowColors(Display *display,Window window) {    Atom
     property, 	     type;      int      format,      status;      unsigned char 
     *data;     unsigned long 
     after,     length;      /*E     If there are previous resources on the root window, destroy them.    */&   assert(display != (Display *) NULL);5   property=XInternAtom(display,"_XSETROOT_ID",False);    if (property == (Atom) NULL)     { A       MagickWarning(XServerWarning,"Unable to create X property",          "_XSETROOT_ID");
       return;      } ?   status=XGetWindowProperty(display,window,property,0L,1L,True, ?     (Atom) AnyPropertyType,&type,&format,&length,&after,&data);    if (status != Success)     return; M   if ((type == XA_PIXMAP) && (format == 32) && (length == 1) && (after == 0))      { 6       XKillClient(display,(XID) (*((Pixmap *) data)));/       XDeleteProperty(display,window,property);      }    if (type != None)      XFree((void *) data);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D i s p l a y I m a g e I n f o                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % B %  Method XDisplayImageInfo displays information about an X image. % 1 %  The format of the XDisplayImageInfo method is:  % / %      void XDisplayImageInfo(Display *display, P %        const XResourceInfo *resource_info,XWindows *windows,Image *undo_image, %        Image *image) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % K %    o undo_image: Specifies a pointer to a Image structure;  returned from  %      ReadImage.  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  *// Export void XDisplayImageInfo(Display *display, I   const XResourceInfo *resource_info,XWindows *windows,Image *undo_image,    Image *image)  {    char     filename[MaxTextExtent],
     *text,     **textlist;      FILE
     *file;     int      c,     length;      register char      *p;      register int     i;     unsigned int
     bytes,     levels;   &   assert(display != (Display *) NULL);2   assert(resource_info != (XResourceInfo *) NULL);'   assert(windows != (XWindows *) NULL); "   assert(image != (Image *) NULL);   /*,     Write info about the X server to a file.   */   TemporaryFilename(filename);   file=fopen(filename,"w+");   if (file == (FILE *) NULL)     { M       XNoticeWidget(display,windows,"Unable to display image info",filename); 
       return;      } #   if (resource_info->gamma_correct) 6     if (resource_info->display_gamma != (char *) NULL):       (void) fprintf(file,"Display\n  gamma: %.1024s\n\n",&         resource_info->display_gamma);   /*+     Write info about the X image to a file.    *//   (void) fprintf(file,"X\n  visual: %.1024s\n", ,     XVisualClassName(windows->image.class));D   (void) fprintf(file,"  depth: %d\n",windows->image.ximage->depth);/   if (windows->visual_info->colormap_size != 0) 0     (void) fprintf(file,"  colormap size: %d\n",+       windows->visual_info->colormap_size); /   if (resource_info->colormap== SharedColormap) 5     (void) fprintf(file,"  colormap type: Shared\n");    else6     (void) fprintf(file,"  colormap type: Private\n");I   (void) fprintf(file,"  geometry: %dx%d\n",windows->image.ximage->width, #     windows->image.ximage->height); 4   if (windows->image.crop_geometry != (char *) NULL)5     (void) fprintf(file,"  crop geometry: %.1024s\n", $       windows->image.crop_geometry);-   if (windows->image.pixmap == (Pixmap) NULL) -     (void) fprintf(file,"  type: X Image\n");    else,     (void) fprintf(file,"  type: Pixmap\n");   if (windows->image.shape) ;     (void) fprintf(file,"  non-rectangular shape: True\n");    else<     (void) fprintf(file,"  non-rectangular shape: False\n");#   if (windows->image.shared_memory) 3     (void) fprintf(file,"  shared memory: True\n");    else4     (void) fprintf(file,"  shared memory: False\n");   (void) fprintf(file,"\n");+   if (resource_info->font != (char *) NULL) A     (void) fprintf(file,"Font: %.1024s\n\n",resource_info->font); 0   if (resource_info->text_font != (char *) NULL)K     (void) fprintf(file,"Text font: %.1024s\n\n",resource_info->text_font);    /*.     Write info about the undo cache to a file.   */
   bytes=0;8   for (levels=0; undo_image != (Image *) NULL; levels++)   { P     bytes+=undo_image->list->columns*undo_image->list->rows*sizeof(PixelPacket);$     undo_image=undo_image->previous;   } @   (void) fprintf(file,"Undo Edit Cache\n  levels: %u\n",levels);A   (void) fprintf(file,"  bytes: %umb\n",(bytes+(1 << 19)) >> 20); E   (void) fprintf(file,"  limit: %umb\n\n",resource_info->undo_cache);    /*)     Write info about the image to a file.    */!   DescribeImage(image,file,True);    /*3     Read the information from the file to a string.    */!   (void) fseek(file,0L,SEEK_SET);    length=MaxTextExtent; '   text=(char *) AllocateMemory(length); *   for (p=text; text != (char *) NULL; p++)   {      c=fgetc(file);     if (c == EOF)        break;     if ((p-text+1) >= length)        {          *p='\0';         length<<=1; =         text=(char *) ReallocateMemory((char *) text,length); "         if (text == (char *) NULL)           break;         p=text+Extent(text);       }      *p=(unsigned char) c;    }    (void) fclose(file);   (void) remove(filename);   if (text == (char *) NULL)     { C       XNoticeWidget(display,windows,"Unable to display image info", $         "Memory allocation failed");
       return;      } 
   *p='\0';   textlist=StringToList(text);!   if (textlist != (char **) NULL)      { 
       char         title[MaxTextExtent];          /*D         Display information about the image in the Text View widget.       */E       XWithdrawWindow(display,windows->info.id,windows->info.screen); @       FormatString(title,"Image Info: %.1024s",image->filename);?       XTextViewWidget(display,resource_info,windows,True,title, "         (char const **) textlist);2       for (i=0; textlist[i] != (char *) NULL; i++)          FreeMemory(textlist[i]);       FreeMemory(textlist);      }    FreeMemory(text);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +     X D i t h e r I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method XDitherImage dithers the reference image as required by the HPM %  Color Recovery algorithm.  The color values are quantized to 3 bits of red J %  and green, and 2 bits of blue (3/3/2) and can be used as indices into a %  8-bit X standard colormap.  % , %  The format of the XDitherImage method is: % 5 %      void XDitherImage(Image *image,XImage *ximage)  % + %  A description of each parameter follows:  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  % H %    o ximage: Specifies a pointer to a XImage structure;  returned from %      XCreateImage. %  %  */5 static void XDitherImage(Image *image,XImage *ximage)  {    static const short int     dither_red[2][16]=     { H       {-16,  4, -1, 11,-14,  6, -3,  9,-15,  5, -2, 10,-13,  7, -4,  8},G       { 15, -5,  0,-12, 13, -7,  2,-10, 14, -6,  1,-11, 12, -8,  3, -9}      },     dither_green[2][16]=     { H       { 11,-15,  7, -3,  8,-14,  4, -2, 10,-16,  6, -4,  9,-13,  5, -1},G       {-12, 14, -8,  2, -9, 13, -5,  1,-11, 15, -7,  3,-10, 12, -6,  0}      },     dither_blue[2][16]=      { H       { -3,  9,-13,  7, -1, 11,-15,  5, -4,  8,-14,  6, -2, 10,-16,  4},G       {  2,-10, 12, -8,  0,-12, 14, -6,  3, -9, 13, -7,  1,-11, 15, -5}      };  
   PixelPacket 
     color;     int 
     value,     y;     register char      *q;      register int     i,     j,     x;     register PixelPacket     *p;      unsigned int     scanline_pad;      register unsigned long
     pixel;     unsigned short     *blue_map[2][16],      *green_map[2][16],     *red_map[2][16];     /*(     Allocate and initialize dither maps.   */   for (i=0; i < 2; i++)      for (j=0; j < 16; j++)     { &       red_map[i][j]=(unsigned short *)3         AllocateMemory(256*sizeof(unsigned short)); (       green_map[i][j]=(unsigned short *)3         AllocateMemory(256*sizeof(unsigned short)); '       blue_map[i][j]=(unsigned short *) 3         AllocateMemory(256*sizeof(unsigned short)); 7       if ((red_map[i][j] == (unsigned short *) NULL) || 9           (green_map[i][j] == (unsigned short *) NULL) || 6           (blue_map[i][j] == (unsigned short *) NULL))	         { F           MagickWarning(ResourceLimitWarning,"Unable to dither image",(             "Memory allocation failed");           return; 	         }      }    /*     Initialize dither tables.    */   for (i=0; i < 2; i++)      for (j=0; j < 16; j++)       for (x=0; x < 256; x++)        {          value=x-16;          if (x < 48)            value=x/2+8;          value+=dither_red[i][j];)         red_map[i][j][x]=(unsigned short) @           ((value < 0) ? 0 : (value > MaxRGB) ? MaxRGB : value);         value=x-16;          if (x < 48)            value=x/2+8;"         value+=dither_green[i][j];+         green_map[i][j][x]=(unsigned short) @           ((value < 0) ? 0 : (value > MaxRGB) ? MaxRGB : value);         value=x-32;          if (x < 112)           value=x/2+24; (         value+=(dither_blue[i][j] << 1);*         blue_map[i][j][x]=(unsigned short)@           ((value < 0) ? 0 : (value > MaxRGB) ? MaxRGB : value);       }    /*     Dither image.    */&   scanline_pad=ximage->bytes_per_line-2     ((ximage->width*ximage->bits_per_pixel) >> 3);   i=0;   j=0;   q=ximage->data; '   for (y=0; y < (int) image->rows; y++)    { 0     p=GetPixelCache(image,0,y,image->columns,1);"     if (p == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     { &       color.red=red_map[i][j][p->red];,       color.green=green_map[i][j][p->green];)       color.blue=blue_map[i][j][p->blue]; 1       pixel=(unsigned long) ((color.red & 0xe0) | 5         ((unsigned long) (color.green & 0xe0) >> 3) | 4         ((unsigned long) (color.blue & 0xc0) >> 6));!       *q++=(unsigned char) pixel; 
       p++;
       j++;       if (j == 16)         j=0;     }      q+=scanline_pad;     i++;     if (i == 2) 
       i=0;   }    /*     Free allocated memory.   */   for (i=0; i < 2; i++)      for (j=0; j < 16; j++)     { "       FreeMemory(green_map[i][j]);!       FreeMemory(blue_map[i][j]);         FreeMemory(red_map[i][j]);     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % / %  Method XDrawImage draws a line on the image.  % * %  The format of the XDrawImage method is: % 5 %    status=XDrawImage(display,pixel,draw_info,image)  % + %  A description of each parameter follows:  % = %    o status: Method XDrawImage returns True if the image is E %      successfully drawd with text.  False is returned is there is a  %      memory shortage.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % < %    o pixel: Specifies a pointer to a XPixelInfo structure. % ? %    o draw_info: Specifies a pointer to a XDrawInfo structure.  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */H Export unsigned int XDrawImage(Display *display,const XPixelInfo *pixel,$   XDrawInfo *draw_info,Image *image) {    GC     draw_context;      Image      *draw_image;     int      x,     y;     Pixmap     draw_pixmap;     register PixelPacket     *p,      *q;      unsigned int
     depth,     height, 
     matte,
     width;     Window     root_window;     XGCValues      context_values;      XImage     *draw_ximage;      /*     Initialize drawd image.    */&   assert(display != (Display *) NULL);'   assert(pixel != (XPixelInfo *) NULL); *   assert(draw_info != (XDrawInfo *) NULL);"   assert(image != (Image *) NULL);   /*     Initialize drawd pixmap.   */;   root_window=XRootWindow(display,XDefaultScreen(display)); 7   depth=XDefaultDepth(display,XDefaultScreen(display)); A   draw_pixmap=XCreatePixmap(display,root_window,draw_info->width, #     draw_info->height,(int) depth); #   if (draw_pixmap == (Pixmap) NULL)      return(False);   /*     Initialize graphics info.    */1   context_values.background=(unsigned long) (~0);    context_values.foreground=0;2   context_values.line_width=draw_info->line_width;J   draw_context=XCreateGC(display,root_window,GCBackground | GCForeground |!     GCLineWidth,&context_values);     if (draw_context == (GC) NULL)     return(False);   /*     Clear pixmap.    */G   XFillRectangle(display,draw_pixmap,draw_context,0,0,draw_info->width,      draw_info->height);    /*     Draw line to pixmap.   */)   XSetBackground(display,draw_context,0); <   XSetForeground(display,draw_context,(unsigned long) (~0));9   XSetFillStyle(display,draw_context,FillOpaqueStippled); 7   XSetStipple(display,draw_context,draw_info->stipple);    switch (draw_info->primitive)    {      case PointPrimitive:     default:     { M       XDrawLines(display,draw_pixmap,draw_context,draw_info->coordinate_info, 7         draw_info->number_coordinates,CoordModeOrigin);        break;     }      case LinePrimitive:      { I       XDrawLine(display,draw_pixmap,draw_context,draw_info->line_info.x1, 8         draw_info->line_info.y1,draw_info->line_info.x2,!         draw_info->line_info.y2);        break;     }      case RectanglePrimitive:     { 6       XDrawRectangle(display,draw_pixmap,draw_context,@         draw_info->rectangle_info.x,draw_info->rectangle_info.y,J         draw_info->rectangle_info.width,draw_info->rectangle_info.height);       break;     }       case FillRectanglePrimitive:     { 6       XFillRectangle(display,draw_pixmap,draw_context,@         draw_info->rectangle_info.x,draw_info->rectangle_info.y,J         draw_info->rectangle_info.width,draw_info->rectangle_info.height);       break;     }      case CirclePrimitive:      case EllipsePrimitive:     { 0       XDrawArc(display,draw_pixmap,draw_context,@         draw_info->rectangle_info.x,draw_info->rectangle_info.y,I         draw_info->rectangle_info.width,draw_info->rectangle_info.height,          0,360*64);       break;     }      case FillCirclePrimitive:      case FillEllipsePrimitive:     { 0       XFillArc(display,draw_pixmap,draw_context,@         draw_info->rectangle_info.x,draw_info->rectangle_info.y,I         draw_info->rectangle_info.width,draw_info->rectangle_info.height,          0,360*64);       break;     }      case PolygonPrimitive:     {        XPoint         *coordinate_info;   1       coordinate_info=draw_info->coordinate_info; B       XDrawLines(display,draw_pixmap,draw_context,coordinate_info,7         draw_info->number_coordinates,CoordModeOrigin); 1       XDrawLine(display,draw_pixmap,draw_context, ;         coordinate_info[draw_info->number_coordinates-1].x, ;         coordinate_info[draw_info->number_coordinates-1].y, 3         coordinate_info[0].x,coordinate_info[0].y);        break;     }      case FillPolygonPrimitive:     { O       XFillPolygon(display,draw_pixmap,draw_context,draw_info->coordinate_info, ?         draw_info->number_coordinates,Complex,CoordModeOrigin);        break;     }    }     XFreeGC(display,draw_context);   /*     Initialize X image.    */A   draw_ximage=XGetImage(display,draw_pixmap,0,0,draw_info->width, )     draw_info->height,AllPlanes,ZPixmap); %   if (draw_ximage == (XImage *) NULL)      return(False);#   XFreePixmap(display,draw_pixmap);    /*     Initialize draw image.   *//   draw_image=AllocateImage((ImageInfo *) NULL); #   if (draw_image == (Image *) NULL)      return(False);'   draw_image->columns=draw_info->width; %   draw_image->rows=draw_info->height;    /*$     Transfer drawn X image to image.   */   width=image->columns;    height=image->rows;    x=0;   y=0;B   (void) XParseGeometry(draw_info->geometry,&x,&y,&width,&height);!   p=GetPixelCache(image,x,y,1,1);     if (p != (PixelPacket *) NULL)     { (       draw_image->background_color=(*p);       draw_image->matte=True;      } ,   for (y=0; y < (int) draw_image->rows; y++)   { :     q=SetPixelCache(draw_image,0,y,draw_image->columns,1);"     if (q == (PixelPacket *) NULL)       break;1     for (x=0; x < (int) draw_image->columns; x++)      { *       if (XGetPixel(draw_ximage,x,y) == 0)	         {            /*3             Set this pixel to the background color.            */*           *q=draw_image->background_color;P           q->opacity=draw_info->stencil == OpaqueStencil ? Transparent : Opaque;	         } 
       else	         {            /*,             Set this pixel to the pen color.           */2           q->red=XDownScale(pixel->pen_color.red);6           q->green=XDownScale(pixel->pen_color.green);4           q->blue=XDownScale(pixel->pen_color.blue);P           q->opacity=draw_info->stencil == OpaqueStencil ? Opaque : Transparent;	         } 
       q++;     } $     if (!SyncPixelCache(draw_image))       break;   }    XDestroyImage(draw_ximage);    /*     Determine draw geometry.   */B   (void) XParseGeometry(draw_info->geometry,&x,&y,&width,&height);E   if ((width != draw_image->columns) || (height != draw_image->rows))      { 
       char&         image_geometry[MaxTextExtent];         /*         Scale image.       */8       FormatString(image_geometry,"%ux%u",width,height);?       TransformImage(&draw_image,(char *) NULL,image_geometry);      }     if (draw_info->degrees != 0.0)     {        double         normalized_degrees;          Image          *rotate_image;  	       int          rotations;         /*         Rotate image.        */>       rotate_image=RotateImage(draw_image,draw_info->degrees);)       if (rotate_image == (Image *) NULL)          return(False);       DestroyImage(draw_image);        draw_image=rotate_image;       /*9         Annotation is relative to the degree of rotation.        */,       normalized_degrees=draw_info->degrees;(       while (normalized_degrees < -45.0)"         normalized_degrees+=360.0;?       for (rotations=0; normalized_degrees > 45.0; rotations++) !         normalized_degrees-=90.0;        switch (rotations % 4)       {          default:         case 0:            break;         case 1: 	         {            /*             Rotate 90 degrees.           */#           x-=draw_image->columns/2; #           y+=draw_image->columns/2;            break;	         }          case 2: 	         {            /*             Rotate 180 degrees.            */!           x-=draw_image->columns;            break;	         }          case 3: 	         {            /*             Rotate 270 degrees.            */#           x-=draw_image->columns/2; 6           y-=draw_image->rows-(draw_image->columns/2);           break;	         }        }      }    /*"     Composite text onto the image.   */,   for (y=0; y < (int) draw_image->rows; y++)   { :     q=GetPixelCache(draw_image,0,y,draw_image->columns,1);"     if (q == (PixelPacket *) NULL)       break;1     for (x=0; x < (int) draw_image->columns; x++)      { $       if (q->opacity != Transparent)         q->opacity=Opaque;
       q++;     } $     if (!SyncPixelCache(draw_image))       break;   } B   (void) XParseGeometry(draw_info->geometry,&x,&y,&width,&height);/   if (draw_info->stencil == TransparentStencil) A     CompositeImage(image,ReplaceMatteCompositeOp,draw_image,x,y);    else     {        matte=image->matte; ;       CompositeImage(image,OverCompositeOp,draw_image,x,y);        image->matte=matte;      }    DestroyImage(draw_image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X E r r o r                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % < %  Method XError ignores BadWindow errors for XQueryTree andM %  XGetWindowAttributes, and ignores BadDrawable errors for XGetGeometry, and M %  ignores BadValue errors for XQueryColor.  It returns False in those cases.  %  Otherwise it returns True.  % ( %  The format of the XError function is: %  %      XError(display,error) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % ( %    o error: Specifies the error event. %  %  */6 Export int XError(Display *display,XErrorEvent *error) { &   assert(display != (Display *) NULL);(   assert(error != (XErrorEvent *) NULL);   xerror_alert=True;   switch (error->request_code)   {      case X_GetGeometry:      { +       if (error->error_code == BadDrawable)          return(False);       break;     }      case X_GetWindowAttributes:      case X_QueryTree:      { )       if (error->error_code == BadWindow)          return(False);       break;     }      case X_QueryColors:      { (       if (error->error_code == BadValue)         return(False);       break;     }    }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X F r e e R e s o u r c e s                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % - %  Method XFreeResources frees X11 resources.  % . %  The format of the XFreeResources method is: % E %      void XFreeResources(Display *display,XVisualInfo *visual_info, N %        XStandardColormap *map_info,XPixelInfo *pixel,XFontStruct *font_info,? %        XResourceInfo *resource_info,XWindowInfo *window_info) # %        resource_info,window_info)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % < %    o pixel: Specifies a pointer to a XPixelInfo structure. % A %    o font_info: Specifies a pointer to a XFontStruct structure.  % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  %  %  */E Export void XFreeResources(Display *display,XVisualInfo *visual_info, G   XStandardColormap *map_info,XPixelInfo *pixel,XFontStruct *font_info, 8   XResourceInfo *resource_info,XWindowInfo *window_info) { &   assert(display != (Display *) NULL);2   assert(resource_info != (XResourceInfo *) NULL);*   if (window_info != (XWindowInfo *) NULL)     {        /*         Free X image.        */1       if (window_info->ximage != (XImage *) NULL) +         XDestroyImage(window_info->ximage); +       if (window_info->id != (Window) NULL) 	         {            /*1             Free destroy window and free cursors.            */J           if (window_info->id != XRootWindow(display,visual_info->screen))4             XDestroyWindow(display,window_info->id);9           if (window_info->annotate_context != (GC) NULL) ;             XFreeGC(display,window_info->annotate_context); :           if (window_info->highlight_context != (GC) NULL)<             XFreeGC(display,window_info->highlight_context);7           if (window_info->widget_context != (GC) NULL) 9             XFreeGC(display,window_info->widget_context); 3           XFreeCursor(display,window_info->cursor); 8           XFreeCursor(display,window_info->busy_cursor);	         }      }    /*     Free font.   */(   if (font_info != (XFontStruct *) NULL)!     XFreeFont(display,font_info); -   if (map_info != (XStandardColormap *) NULL)      {        /*!         Free X Standard Colormap.        */3       if (resource_info->map_type == (char *) NULL) B         XFreeStandardColormap(display,visual_info,map_info,pixel);       XFree((void *) map_info);      }    /*     Free X visual info.    */*   if (visual_info != (XVisualInfo *) NULL)      XFree((void *) visual_info);"   if (resource_info->close_server)     XCloseDisplay(display);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X F r e e S t a n d a r d C o l o r m a p                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 6 %  Method XFreeStandardColormap frees an X11 colormap. % 5 %  The format of the XFreeStandardColormap method is:  % 3 %      void XFreeStandardColormap(Display *display, D %        const XVisualInfo *visual_info,XStandardColormap *map_info, %        XPixelInfo *pixel)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % < %    o pixel: Specifies a pointer to a XPixelInfo structure. %  %  */3 Export void XFreeStandardColormap(Display *display, =   const XVisualInfo *visual_info,XStandardColormap *map_info,    XPixelInfo *pixel) {    /*     Free colormap.   */&   assert(display != (Display *) NULL);.   assert(visual_info != (XVisualInfo *) NULL);1   assert(map_info != (XStandardColormap *) NULL);    XFlush(display);,   if (map_info->colormap != (Colormap) NULL)     { N       if (map_info->colormap != XDefaultColormap(display,visual_info->screen))2         XFreeColormap(display,map_info->colormap);
       else)         if (pixel != (XPixelInfo *) NULL) 2           if ((visual_info->class != TrueColor) &&2               (visual_info->class != DirectColor))A             XFreeColors(display,map_info->colormap,pixel->pixels, %               (int) pixel->colors,0);      } %   map_info->colormap=(Colormap) NULL; #   if (pixel != (XPixelInfo *) NULL)      { .       if (pixel->gamma_map != (XColor *) NULL)%         FreeMemory(pixel->gamma_map); '       pixel->gamma_map=(XColor *) NULL; 2       if (pixel->pixels != (unsigned long *) NULL)"         FreeMemory(pixel->pixels);+       pixel->pixels=(unsigned long *) NULL;      }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t A n n o t a t e I n f o                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % B %  Method XGetAnnotateInfo initializes the AnnotateInfo structure. % 0 %  The format of the XGetAnnotateInfo method is: % : %      void XGetAnnotateInfo(XAnnotateInfo *annotate_info) % + %  A description of each parameter follows:  % G %    o annotate_info: Specifies a pointer to a XAnnotateInfo structure.  %  %  */: Export void XGetAnnotateInfo(XAnnotateInfo *annotate_info) {    /*"     Initialize annotate structure.   */2   assert(annotate_info != (XAnnotateInfo *) NULL);   annotate_info->x=0;    annotate_info->y=0;    annotate_info->width=0;    annotate_info->height=0;+   annotate_info->stencil=ForegroundStencil;    annotate_info->degrees=0.0; 0   annotate_info->font_info=(XFontStruct *) NULL;$   annotate_info->text=(char *) NULL;    *annotate_info->geometry='\0';1   annotate_info->previous=(XAnnotateInfo *) NULL; -   annotate_info->next=(XAnnotateInfo *) NULL;    (void) setlocale(LC_ALL,"");#   (void) setlocale(LC_NUMERIC,"C");    XSupportsLocale();   XSetLocaleModifiers(""); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t M a p I n f o                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % B %  Method XGetMapInfo initializes the XStandardColormap structure. % 1 %  The format of the XStandardColormap method is:  % O %      void XGetMapInfo(const XVisualInfo *visual_info,const Colormap colormap, % %        XStandardColormap *map_info)  % + %  A description of each parameter follows:  % ; %    o colormap: Specifies the ID of the X server colormap.  % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % J %    o map_info: Specifies a pointer to a X11 XStandardColormap structure. %  %  */O Export void XGetMapInfo(const XVisualInfo *visual_info,const Colormap colormap,    XStandardColormap *map_info) {    /*     Initialize map info.   */.   assert(visual_info != (XVisualInfo *) NULL);1   assert(map_info != (XStandardColormap *) NULL);    map_info->colormap=colormap;*   map_info->red_max=visual_info->red_mask;4   map_info->red_mult=map_info->red_max != 0 ? 1 : 0;   if (map_info->red_max != 0) +     while ((map_info->red_max & 0x01) == 0)      {        map_info->red_max>>=1;       map_info->red_mult<<=1;      } .   map_info->green_max=visual_info->green_mask;8   map_info->green_mult=map_info->green_max != 0 ? 1 : 0;   if (map_info->green_max != 0) -     while ((map_info->green_max & 0x01) == 0)      {        map_info->green_max>>=1;       map_info->green_mult<<=1;      } ,   map_info->blue_max=visual_info->blue_mask;6   map_info->blue_mult=map_info->blue_max != 0 ? 1 : 0;   if (map_info->blue_max != 0),     while ((map_info->blue_max & 0x01) == 0)     {        map_info->blue_max>>=1;        map_info->blue_mult<<=1;     }    map_info->base_pixel=0;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t I m a g e I n f o                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ? %  Method XGetImportInfo initializes the XImportInfo structure.  % . %  The format of the XGetImportInfo method is: % 4 %      void XGetImportInfo(XImportInfo *ximage_info) % + %  A description of each parameter follows:  % A %    o ximage_info: Specifies a pointer to a ImageInfo structure.  %  %  */4 Export void XGetImportInfo(XImportInfo *ximage_info) { .   assert(ximage_info != (XImportInfo *) NULL);   ximage_info->frame=False;    ximage_info->borders=False;    ximage_info->screen=False;   ximage_info->descend=True;   ximage_info->silent=False; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t P i x e l I n f o                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % @ %  Method XGetPixelPacket initializes the PixelPacket structure. % / %  The format of the XGetPixelPacket method is:  % L %      void XGetPixelPacket(Display *display,const XVisualInfo *visual_info,N %        const XStandardColormap *map_info,const XResourceInfo *resource_info,( %        Image *image,XPixelInfo *pixel) %        pixel)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  % < %    o pixel: Specifies a pointer to a XPixelInfo structure. %  %  */L Export void XGetPixelPacket(Display *display,const XVisualInfo *visual_info,G   const XStandardColormap *map_info,const XResourceInfo *resource_info, !   Image *image,XPixelInfo *pixel)  {    static const char      *PenColors[MaxNumberPens]=     {        "#000000",  /* black */        "#0000ff",  /* blue */       "#00ffff",  /* cyan */       "#00ff00",  /* green */        "#bdbdbd",  /* gray */       "#ff0000",  /* red */        "#ff00ff",  /* magenta */        "#ffff00",  /* yellow */       "#ffffff",  /* white */        "#bdbdbd",  /* gray */       "#bdbdbd"   /* gray */     };  
   Colormap
     colormap;      int      status;      register int     i;     unsigned int     packets;     /*     Initialize pixel info.   */&   assert(display != (Display *) NULL);.   assert(visual_info != (XVisualInfo *) NULL);1   assert(map_info != (XStandardColormap *) NULL); 2   assert(resource_info != (XResourceInfo *) NULL);'   assert(pixel != (XPixelInfo *) NULL);    pixel->colors=0;   if (image != (Image *) NULL)$     if (image->class == PseudoClass)"       pixel->colors=image->colors;>   packets=Max((int) pixel->colors,visual_info->colormap_size)+     MaxNumberPens;.   if (pixel->pixels != (unsigned long *) NULL)     FreeMemory(pixel->pixels);!   pixel->pixels=(unsigned long *) 2     AllocateMemory(packets*sizeof(unsigned long));.   if (pixel->pixels == (unsigned long *) NULL)>     MagickError(ResourceLimitError,"Unable to get pixel info","       "Memory allocation failed");   /*     Set foreground color.    */   colormap=map_info->colormap;6   (void) XParseColor(display,colormap,ForegroundColor,     &pixel->foreground_color);F   status=XParseColor(display,colormap,resource_info->foreground_color,     &pixel->foreground_color);   if (status == 0)B     MagickWarning(XServerWarning,"Color is not known to X server",'       resource_info->foreground_color);     pixel->foreground_color.pixel=8     XStandardPixel(map_info,pixel->foreground_color,16);9   pixel->foreground_color.flags=DoRed | DoGreen | DoBlue;    /*     Set background color.    */6   (void) XParseColor(display,colormap,BackgroundColor,     &pixel->background_color);F   status=XParseColor(display,colormap,resource_info->background_color,     &pixel->background_color);   if (status == 0)B     MagickWarning(XServerWarning,"Color is not known to X server",'       resource_info->background_color);     pixel->background_color.pixel=8     XStandardPixel(map_info,pixel->background_color,16);9   pixel->background_color.flags=DoRed | DoGreen | DoBlue;    /*     Set border color.    */H   (void) XParseColor(display,colormap,BorderColor,&pixel->border_color);B   status=XParseColor(display,colormap,resource_info->border_color,     &pixel->border_color);   if (status == 0)B     MagickWarning(XServerWarning,"Color is not known to X server",#       resource_info->border_color);    pixel->border_color.pixel=4     XStandardPixel(map_info,pixel->border_color,16);5   pixel->border_color.flags=DoRed | DoGreen | DoBlue;    /*     Set matte color.   */-   pixel->matte_color=pixel->background_color; 2   if (resource_info->matte_color != (char *) NULL)     {        /*J         Matte color is specified as a X resource or command line argument.       */E       status=XParseColor(display,colormap,resource_info->matte_color,          &pixel->matte_color);        if (status == 0)F         MagickWarning(XServerWarning,"Color is not known to X server",&           resource_info->matte_color);       pixel->matte_color.pixel= 7         XStandardPixel(map_info,pixel->matte_color,16); 8       pixel->matte_color.flags=DoRed | DoGreen | DoBlue;     }    /*     Set highlight color.   */-   pixel->highlight_color.red=((unsigned long) I     (pixel->matte_color.red*HighlightModulate+(MaxRGB-HighlightModulate)*      65535L)/MaxRGB);/   pixel->highlight_color.green=((unsigned long) K     (pixel->matte_color.green*HighlightModulate+(MaxRGB-HighlightModulate)*      65535L)/MaxRGB);.   pixel->highlight_color.blue=((unsigned long)J     (pixel->matte_color.blue*HighlightModulate+(MaxRGB-HighlightModulate)*     65535L)/MaxRGB);   pixel->highlight_color.pixel= 7     XStandardPixel(map_info,pixel->highlight_color,16); 8   pixel->highlight_color.flags=DoRed | DoGreen | DoBlue;   /*     Set shadow color.    */*   pixel->shadow_color.red=((unsigned long)4     (pixel->matte_color.red*ShadowModulate)/MaxRGB);,   pixel->shadow_color.green=((unsigned long)6     (pixel->matte_color.green*ShadowModulate)/MaxRGB);+   pixel->shadow_color.blue=((unsigned long) 5     (pixel->matte_color.blue*ShadowModulate)/MaxRGB);    pixel->shadow_color.pixel=4     XStandardPixel(map_info,pixel->shadow_color,16);5   pixel->shadow_color.flags=DoRed | DoGreen | DoBlue;    /*     Set depth color.   */)   pixel->depth_color.red=((unsigned long) 3     (pixel->matte_color.red*DepthModulate)/MaxRGB); +   pixel->depth_color.green=((unsigned long) 5     (pixel->matte_color.green*DepthModulate)/MaxRGB); *   pixel->depth_color.blue=((unsigned long)4     (pixel->matte_color.blue*DepthModulate)/MaxRGB);   pixel->depth_color.pixel= 3     XStandardPixel(map_info,pixel->depth_color,16); 4   pixel->depth_color.flags=DoRed | DoGreen | DoBlue;   /*     Set trough color.    */*   pixel->trough_color.red=((unsigned long)4     (pixel->matte_color.red*TroughModulate)/MaxRGB);,   pixel->trough_color.green=((unsigned long)6     (pixel->matte_color.green*TroughModulate)/MaxRGB);+   pixel->trough_color.blue=((unsigned long) 5     (pixel->matte_color.blue*TroughModulate)/MaxRGB);    pixel->trough_color.pixel=4     XStandardPixel(map_info,pixel->trough_color,16);5   pixel->trough_color.flags=DoRed | DoGreen | DoBlue;    /*     Set pen color.   */#   for (i=0; i < MaxNumberPens; i++)    { >     (void) XParseColor(display,colormap,(char *) PenColors[i],       &pixel->pen_colors[i]); E     status=XParseColor(display,colormap,resource_info->pen_colors[i],        &pixel->pen_colors[i]);      if (status == 0)D       MagickWarning(XServerWarning,"Color is not known to X server",&         resource_info->pen_colors[i]);     pixel->pen_colors[i].pixel= 7       XStandardPixel(map_info,pixel->pen_colors[i],16); 8     pixel->pen_colors[i].flags=DoRed | DoGreen | DoBlue;   } +   pixel->box_color=pixel->background_color; +   pixel->pen_color=pixel->foreground_color;    pixel->box_index=0;    pixel->pen_index=1;    /*.     Initialize gamma map to linear brightness.   */*   if (pixel->gamma_map != (XColor *) NULL)!     FreeMemory(pixel->gamma_map); H   pixel->gamma_map=(XColor *) AllocateMemory((MaxRGB+1)*sizeof(XColor));*   if (pixel->gamma_map == (XColor *) NULL)F     MagickWarning(ResourceLimitWarning,"Unable to allocate gamma map","       "Memory allocation failed");     else!       for (i=0; i <= MaxRGB; i++)        { 3         pixel->gamma_map[i].red=(unsigned short) i; 5         pixel->gamma_map[i].green=(unsigned short) i; 4         pixel->gamma_map[i].blue=(unsigned short) i;       }    if (image != (Image *) NULL)     { @       if (resource_info->gamma_correct && (image->gamma != 0.0))	         {            double             blue_gamma,              green_gamma,             red_gamma;  
           int              count;             /*?             Initialize map relative to display and image gamma.            */           red_gamma=1.0;           green_gamma=1.0;           blue_gamma=1.0; B           count=sscanf(resource_info->display_gamma,"%lf,%lf,%lf",1             &red_gamma,&green_gamma,&blue_gamma);            if (count == 1) 
             { $               green_gamma=red_gamma;#               blue_gamma=red_gamma; 
             } "           red_gamma*=image->gamma;$           green_gamma*=image->gamma;#           blue_gamma*=image->gamma; %           for (i=0; i <= MaxRGB; i++)            { 8             pixel->gamma_map[i].red=(short unsigned int)B               ((pow((double) i/MaxRGB,1.0/red_gamma)*MaxRGB)+0.5);:             pixel->gamma_map[i].green=(short unsigned int)D               ((pow((double) i/MaxRGB,1.0/green_gamma)*MaxRGB)+0.5);9             pixel->gamma_map[i].blue=(short unsigned int) C               ((pow((double) i/MaxRGB,1.0/blue_gamma)*MaxRGB)+0.5);            } 	         } &       if (image->class == PseudoClass)	         {            register XColor              *gamma_map;              /*B             Initialize pixel array for images of type PseudoClass.           */%           gamma_map=pixel->gamma_map; 1           for (i=0; i < (int) image->colors; i++)              pixel->pixels[i]= M               XGammaPixel(map_info,gamma_map,image->colormap+i,QuantumDepth); +           for (i=0; i < MaxNumberPens; i++) F             pixel->pixels[image->colors+i]=pixel->pen_colors[i].pixel;'           pixel->colors+=MaxNumberPens; 	         }      }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t R e s o u r c e C l a s s                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method XGetResourceClass queries the X server for the specified resource F %  name or class.  If the resource name or class is not defined in the4 %  database, the supplied default value is returned. % 1 %  The format of the XGetResourceClass method is:  % L %      char *XGetResourceClass(XrmDatabase database,const char *client_name,4 %        const char *keyword,char *resource_default) % + %  A description of each parameter follows:  % L %    o value: Method XGetResourceClass returns the resource value associatedO %      with the name or class.  If none is found, the supplied default value is  %      returned. % = %    o database: Specifies a resource database; returned from  %      XrmGetStringDatabase. % M %    o client_name:  Specifies the application name used to retrieve resource ' %      info from the X server database.  % C %    o keyword: Specifies the keyword of the value being retrieved.  % K %    o resource_default: Specifies the default value to return if the query 1 %      fails to find the specified keyword/class.  %  %  */L Export char *XGetResourceClass(XrmDatabase database,const char *client_name,-   const char *keyword,char *resource_default)  {    char"     resource_class[MaxTextExtent],!     resource_name[MaxTextExtent];      int      status;   
   static char      *resource_type;   
   XrmValue     resource_value;   %   if (database == (XrmDatabase) NULL)      return(resource_default);    *resource_name='\0';   *resource_class='\0';    if (keyword != (char *) NULL)      {        unsigned char 
         c,
         k;         /*.         Initialize resource keyword and class.       */H       FormatString(resource_name,"%.1024s.%.1024s",client_name,keyword);       c=(*client_name); %       if ((c >= XK_a) && (c <= XK_z))          c-=(XK_a-XK_A); 
       else5         if ((c >= XK_agrave) && (c <= XK_odiaeresis)) #           c-=(XK_agrave-XK_Agrave);          else2           if ((c >= XK_oslash) && (c <= XK_thorn))'             c-=(XK_oslash-XK_Ooblique);        k=(*keyword); %       if ((k >= XK_a) && (k <= XK_z))          k-=(XK_a-XK_A); 
       else5         if ((k >= XK_agrave) && (k <= XK_odiaeresis)) #           k-=(XK_agrave-XK_Agrave);          else2           if ((k >= XK_oslash) && (k <= XK_thorn))'             k-=(XK_oslash-XK_Ooblique); J       FormatString(resource_class,"%c%.1024s.%c%.1024s",c,client_name+1,k,         keyword+1);      } M   status=XrmGetResource(database,resource_name,resource_class,&resource_type,      &resource_value);    if (status == False)     return(resource_default);    return(resource_value.addr); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t R e s o u r c e D a t a b a s e                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % B %  Method XGetResourceDatabase creates a new resource database and %  initializes it. % 4 %  The format of the XGetResourceDatabase method is: % 9 %      XrmDatabase XGetResourceDatabase(Display *display, ! %        const char *client_name)  % + %  A description of each parameter follows:  % G %    o database: Method XGetResourceDatabase returns the database after  %      it is initialized.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % M %    o client_name:  Specifies the application name used to retrieve resource ' %      info from the X server database.  %  %  */9 Export XrmDatabase XGetResourceDatabase(Display *display,    const char *client_name) {    char     filename[MaxTextExtent];     register const char      *p;      unsigned char      c;  
   XrmDatabase      resource_database,     server_database;  "   if (display == (Display *) NULL)     return((XrmDatabase) NULL); '   assert(client_name != (char *) NULL);    /*!     Initialize resource database.    */   XrmInitialize();4   XGetDefault(display,(char *) client_name,"dummy");,   resource_database=XrmGetDatabase(display);   /*!     Combine application database.    */#   if (client_name != (char *) NULL)      {        /*         Get basename of client.        */,       p=client_name+(Extent(client_name)-1);.       while ((p > client_name) && (*p != '/'))         p--;       if (*p == '/')         client_name=p+1;     }    c=(*client_name); !   if ((c >= XK_a) && (c <= XK_z))      c-=(XK_a-XK_A);    else1     if ((c >= XK_agrave) && (c <= XK_odiaeresis))        c-=(XK_agrave-XK_Agrave);      else.       if ((c >= XK_oslash) && (c <= XK_thorn))#         c-=(XK_oslash-XK_Ooblique); P   FormatString(filename,"%.1024s%c%.1024s",ApplicationDefaults,c,client_name+1);<   XrmCombineFileDatabase(filename,&resource_database,False);7   if (XResourceManagerString(display) != (char *) NULL)      {        /*          Combine server database.       */L       server_database=XrmGetStringDatabase(XResourceManagerString(display));C       XrmCombineDatabase(server_database,&resource_database,False);      }    /*$     Merge user preferences database.   */L   FormatString(filename,"%.1024s%.1024src",PreferencesDefaults,client_name);   ExpandFilename(filename); <   XrmCombineFileDatabase(filename,&resource_database,False);   return(resource_database); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t R e s o u r c e I n f o                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % B %  Method XGetResourceInfo initializes the ResourceInfo structure. % 0 %  The format of the XGetResourceInfo method is: % D %      void XGetResourceInfo(XrmDatabase database,char *client_name,& %        XResourceInfo *resource_info) % + %  A description of each parameter follows:  % = %    o database: Specifies a resource database; returned from  %      XrmGetStringDatabase. % D %    o client_name:  Specifies the application name used to retrieve0 %      resource info from the X server database. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %  %  */D Export void XGetResourceInfo(XrmDatabase database,char *client_name,   XResourceInfo *resource_info)  {    char     *resource_value;     /*$     Initialize resource info fields.   */2   assert(resource_info != (XResourceInfo *) NULL);,   resource_info->resource_database=database;?   resource_info->image_info=CloneImageInfo((ImageInfo *) NULL); H   resource_info->quantize_info=CloneQuantizeInfo((QuantizeInfo *) NULL);   resource_info->colors=0;#   resource_info->close_server=True; )   resource_info->client_name=client_name; L   resource_value=XGetResourceClass(database,client_name,"backdrop","False");1   resource_info->backdrop=IsTrue(resource_value); L   resource_info->background_color=XGetResourceInstance(database,client_name,"     "background",BackgroundColor);H   resource_info->border_color=XGetResourceInstance(database,client_name,     "borderColor",BorderColor); K   resource_value=XGetResourceClass(database,client_name,"borderWidth","2"); 3   resource_info->border_width=atoi(resource_value); M   resource_value=XGetResourceClass(database,client_name,"colormap","shared"); ,   resource_info->colormap=UndefinedColormap;3   if (Latin1Compare("private",resource_value) == 0) ,     resource_info->colormap=PrivateColormap;2   if (Latin1Compare("shared",resource_value) == 0)+     resource_info->colormap=SharedColormap; 3   if (resource_info->colormap == UndefinedColormap) M     MagickWarning(OptionWarning,"Unrecognized colormap type",resource_value);    resource_value= D     XGetResourceClass(database,client_name,"colorRecovery","False");7   resource_info->color_recovery=IsTrue(resource_value); O   resource_value=XGetResourceClass(database,client_name,"confirmExit","False"); 5   resource_info->confirm_exit=IsTrue(resource_value); I   resource_value=XGetResourceClass(database,client_name,"debug","False"); .   resource_info->debug=IsTrue(resource_value);E   resource_value=XGetResourceClass(database,client_name,"delay","0"); ,   resource_info->delay=atoi(resource_value);   resource_info->display_gamma= A     XGetResourceClass(database,client_name,"displayGamma","2.2");    resource_value= E     XGetResourceClass(database,client_name,"displayWarnings","True"); 9   resource_info->display_warnings=IsTrue(resource_value);    resource_info->font=A     XGetResourceClass(database,client_name,"font",(char *) NULL); H   resource_info->font=XGetResourceClass(database,client_name,"fontList",     resource_info->font);    resource_info->font_name[0]=<     XGetResourceClass(database,client_name,"font1","fixed");   resource_info->font_name[1]=?     XGetResourceClass(database,client_name,"font2","variable");    resource_info->font_name[2]=:     XGetResourceClass(database,client_name,"font3","5x8");   resource_info->font_name[3]=;     XGetResourceClass(database,client_name,"font4","6x10");    resource_info->font_name[4]=?     XGetResourceClass(database,client_name,"font5","7x13bold");    resource_info->font_name[5]=?     XGetResourceClass(database,client_name,"font6","8x13bold");    resource_info->font_name[6]=?     XGetResourceClass(database,client_name,"font7","9x15bold");    resource_info->font_name[7]=<     XGetResourceClass(database,client_name,"font8","10x20");   resource_info->font_name[8]=<     XGetResourceClass(database,client_name,"font9","12x24");   resource_info->font_name[9]=<     XGetResourceClass(database,client_name,"font0","fixed");   resource_info->font_name[10]= <     XGetResourceClass(database,client_name,"font0","fixed");L   resource_info->foreground_color=XGetResourceInstance(database,client_name,"     "foreground",ForegroundColor);O   resource_value=XGetResourceClass(database,client_name,"gammaCorrect","True"); 6   resource_info->gamma_correct=IsTrue(resource_value);G   resource_info->image_geometry=XGetResourceClass(database,client_name,      "geometry",(char *) NULL);L   resource_value=XGetResourceClass(database,client_name,"gravity","Center");   resource_info->gravity=(-1);2   if (Latin1Compare("Forget",resource_value) == 0))     resource_info->gravity=ForgetGravity; 5   if (Latin1Compare("NorthWest",resource_value) == 0) ,     resource_info->gravity=NorthWestGravity;1   if (Latin1Compare("North",resource_value) == 0) (     resource_info->gravity=NorthGravity;5   if (Latin1Compare("NorthEast",resource_value) == 0) ,     resource_info->gravity=NorthEastGravity;0   if (Latin1Compare("West",resource_value) == 0)'     resource_info->gravity=WestGravity; 2   if (Latin1Compare("Center",resource_value) == 0))     resource_info->gravity=CenterGravity; 0   if (Latin1Compare("East",resource_value) == 0)'     resource_info->gravity=EastGravity; 5   if (Latin1Compare("SouthWest",resource_value) == 0) ,     resource_info->gravity=SouthWestGravity;1   if (Latin1Compare("South",resource_value) == 0) (     resource_info->gravity=SouthGravity;5   if (Latin1Compare("SouthEast",resource_value) == 0) ,     resource_info->gravity=SouthEastGravity;2   if (Latin1Compare("Static",resource_value) == 0))     resource_info->gravity=StaticGravity; %   if (resource_info->gravity == (-1))      { N       MagickWarning(OptionWarning,"Unrecognized gravity type",resource_value);+       resource_info->gravity=CenterGravity;      } ?   (void) getcwd(resource_info->home_directory,MaxTextExtent-1); F   resource_info->icon_geometry=XGetResourceClass(database,client_name,"     "iconGeometry",(char *) NULL);J   resource_value=XGetResourceClass(database,client_name,"iconic","False");/   resource_info->iconic=IsTrue(resource_value); D   resource_value=XGetResourceClass(database,client_name,"immutable",E     Latin1Compare(client_name,"PerlMagick") == 0 ? "True" : "False"); 2   resource_info->immutable=IsTrue(resource_value);G   resource_value=XGetResourceClass(database,client_name,"magnify","3"); .   resource_info->magnify=atoi(resource_value);   resource_info->map_type=@     XGetResourceClass(database,client_name,"map",(char *) NULL);G   resource_info->matte_color=XGetResourceInstance(database,client_name,       "mattecolor",(char *) NULL);   resource_info->name=A     XGetResourceClass(database,client_name,"name",(char *) NULL);    resource_info->pen_colors[0]= ;     XGetResourceClass(database,client_name,"pen1","black");    resource_info->pen_colors[1]= :     XGetResourceClass(database,client_name,"pen2","blue");   resource_info->pen_colors[2]= :     XGetResourceClass(database,client_name,"pen3","cyan");   resource_info->pen_colors[3]= ;     XGetResourceClass(database,client_name,"pen4","green");    resource_info->pen_colors[4]= :     XGetResourceClass(database,client_name,"pen5","gray");   resource_info->pen_colors[5]= 9     XGetResourceClass(database,client_name,"pen6","red");    resource_info->pen_colors[6]= =     XGetResourceClass(database,client_name,"pen7","magenta");    resource_info->pen_colors[7]= <     XGetResourceClass(database,client_name,"pen8","yellow");   resource_info->pen_colors[8]= ;     XGetResourceClass(database,client_name,"pen9","white");    resource_info->pen_colors[9]= :     XGetResourceClass(database,client_name,"pen0","gray");    resource_info->pen_colors[10]=:     XGetResourceClass(database,client_name,"pen0","gray");E   resource_value=XGetResourceClass(database,client_name,"pause","0"); ,   resource_info->pause=atoi(resource_value);G   resource_value=XGetResourceClass(database,client_name,"quantum","1"); .   resource_info->quantum=atoi(resource_value);   resource_info->text_font= A     XGetResourceClass(database,client_name,"font",(char *) NULL); B   resource_info->text_font=XGetResourceClass(database,client_name,-     "textFontList",resource_info->text_font);    resource_info->title= B     XGetResourceClass(database,client_name,"title",(char *) NULL);J   resource_value=XGetResourceClass(database,client_name,"undoCache","16");1   resource_info->undo_cache=atoi(resource_value); J   resource_value=XGetResourceClass(database,client_name,"update","False");/   resource_info->update=IsTrue(resource_value); M   resource_value=XGetResourceClass(database,client_name,"usePixmap","False"); 3   resource_info->use_pixmap=IsTrue(resource_value); O   resource_value=XGetResourceClass(database,client_name,"sharedMemory","True"); :   resource_info->use_shared_memory=IsTrue(resource_value);   resource_info->visual_type= C     XGetResourceClass(database,client_name,"visual",(char *) NULL); E   resource_info->window_group=XGetResourceClass(database,client_name, !     "windowGroup",(char *) NULL);    resource_info->window_id= C     XGetResourceClass(database,client_name,"window",(char *) NULL); G   resource_info->write_filename=XGetResourceClass(database,client_name, #     "writeFilename",(char *) NULL); +   resource_info->copy_image=(Image *) NULL;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t R e s o u r c e I n s t a n c e                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method XGetResourceInstance queries the X server for the specified K %  resource name.  If the resource name is not defined in the database, the & %  supplied default value is returned. % 4 %  The format of the XGetResourceInstance method is: % O %      char *XGetResourceInstance(XrmDatabase database,const char *client_name, : %        const char *keyword,const char *resource_default) % + %  A description of each parameter follows:  % D %    o value: Method XGetResourceInstance returns the resource valueI %      associated with the name or class.  If none is found, the supplied ! %      default value is returned.  % = %    o database: Specifies a resource database; returned from  %      XrmGetStringDatabase. % D %    o client_name:  Specifies the application name used to retrieve0 %      resource info from the X server database. % C %    o keyword: Specifies the keyword of the value being retrieved.  % K %    o resource_default: Specifies the default value to return if the query 1 %      fails to find the specified keyword/class.  %  %  */O Export char *XGetResourceInstance(XrmDatabase database,const char *client_name, 3   const char *keyword,const char *resource_default)  {    char     *resource_type, !     resource_name[MaxTextExtent];      int      status;   
   XrmValue     resource_value;   %   if (database == (XrmDatabase) NULL) &     return((char *) resource_default);   *resource_name='\0';   if (keyword != (char *) NULL) F     FormatString(resource_name,"%.1024s.%.1024s",client_name,keyword);L   status=XrmGetResource(database,resource_name,"ImageMagick",&resource_type,     &resource_value);    if (status == False)&     return((char *) resource_default);   return(resource_value.addr); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t S c r e e n D e n s i t y                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method XGetScreenDensity returns the density of the X server screen in  %  dots-per-inch.  % 1 %  The format of the XGetScreenDensity method is:  % 0 %      char *XGetScreenDensity(Display *display) % + %  A description of each parameter follows:  % L %    o density: Method XGetScreenDensity returns the density of the X screen %      in dots-per-inch. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %  %  */0 Export char *XGetScreenDensity(Display *display) {    char     density[MaxTextExtent],      geometry[MaxTextExtent];     double     x_density,     y_density;     int      x,     y;     unsigned int     height, 
     width;     /*-     Set density as determined by screen size.    */+   (void) strcpy(density,PSDensityGeometry); 9   (void) sscanf(density,"%lfx%lf",&x_density,&y_density); )   (void) strcpy(geometry,PSPageGeometry); 7   width=XDisplayWidth(display,XDefaultScreen(display)); 9   height=XDisplayHeight(display,XDefaultScreen(display));    x=0;   y=0;4   (void) GetGeometry(geometry,&x,&y,&width,&height);<   FormatString(density,"%d",(int) (Min(x_density,y_density)*K     (XDisplayHeight(display,XDefaultScreen(display))-40)/(double) height)); &   return(PostscriptGeometry(density)); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t S u b w i n d o w                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Method XGetSubwindow returns the subwindow of a window chosen the, %  user with the pointer and a button press. % - %  The format of the XGetSubwindow method is:  % G %      Window XGetSubwindow(Display *display,Window window,int x,int y)  % + %  A description of each parameter follows:  % L %    o subwindow: Method XGetSubwindow returns NULL if no subwindow is found+ %      otherwise the subwindow is returned.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % / %    o window: Specifies a pointer to a Window.  % G %    o x: the x coordinate of the pointer relative to the origin of the  %      window. % G %    o y: the y coordinate of the pointer relative to the origin of the  %      window. %  %  */G Export Window XGetSubwindow(Display *display,Window window,int x,int y)  {    Window     source_window,     target_window;     int      status, 
     x_offset, 
     y_offset;   &   assert(display != (Display *) NULL);=   source_window=XRootWindow(display,XDefaultScreen(display));    if (window == (Window) NULL)     return(source_window);   target_window=window; 
   for ( ; ; )    { B     status=XTranslateCoordinates(display,source_window,window,x,y,*       &x_offset,&y_offset,&target_window);     if (status != True)        break;'     if (target_window == (Window) NULL)        break;     source_window=window;      window=target_window;      x=x_offset;      y=y_offset;    } %   if (target_window == (Window) NULL)      target_window=window;    return(target_window); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t W i n d o w C o l o r                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method XGetWindowColor returns the color of a pixel interactively chosen  %  from the X server.  % / %  The format of the XGetWindowColor method is:  % @ %      unsigned int XGetWindowColor(Display *display,char *name) % + %  A description of each parameter follows:  % K %    o status: Method XGetWindowColor returns True if the color is obtained B %      from the X server.  False is returned if any errors occurs. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % I %    o name: The name of of the color if found in the X Color Database is ) %      returned in this character string.  %  %  */@ Export unsigned int XGetWindowColor(Display *display,char *name) {    FILE     *database;     int      x,     y;     RectangleInfo      crop_info;     unsigned int     status;      Window
     child,     client_window,     root_window,     target_window;     XColor
     color;     XImage     *ximage;     XWindowAttributes      window_attributes;     /*%     Choose a pixel from the X server.    */&   assert(display != (Display *) NULL);    assert(name != (char *) NULL);2   target_window=XSelectWindow(display,&crop_info);;   root_window=XRootWindow(display,XDefaultScreen(display));    client_window=target_window;#   if (target_window != root_window)      {        unsigned int
         d;         /*         Get client window.       */P       status=XGetGeometry(display,target_window,&root_window,&x,&x,&d,&d,&d,&d);       if (status != 0)	         { =           client_window=XClientWindow(display,target_window); &           target_window=client_window;	         }      }    /*     Verify window is viewable.   */H   status=XGetWindowAttributes(display,target_window,&window_attributes);G   if ((status == False) || (window_attributes.map_state != IsViewable))      return(False);   /*     Get window X image.    */F   XTranslateCoordinates(display,root_window,target_window,crop_info.x,     crop_info.y,&x,&y,&child);D   ximage=XGetImage(display,target_window,x,y,1,1,AllPlanes,ZPixmap);    if (ximage == (XImage *) NULL)     return(False);$   color.pixel=XGetPixel(ximage,0,0);   XDestroyImage(ximage);   /*#     Query X server for pixel color.    */9   XQueryColor(display,window_attributes.colormap,&color); F   FormatString(name,"#%04x%04x%04x",color.red,color.green,color.blue);'   database=fopen(RGBColorDatabase,"r");     if (database != (FILE *) NULL)     { 
       char!         colorname[MaxTextExtent],          text[MaxTextExtent];  	       int 
         blue,          count,         green,         red;         /*1         Match color against the X color database.        */A       while (fgets(text,MaxTextExtent,database) != (char *) NULL)        { K         count=sscanf(text,"%d %d %d %[^\n]\n",&red,&green,&blue,colorname);          if (count != 4)            continue; 3         if ((red == (int) XDownScale(color.red)) && 7             (green == (int) XDownScale(color.green)) && 3             (blue == (int) XDownScale(color.blue)))            { *             (void) strcpy(name,colorname);             break;           }        }        (void) fclose(database);     }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t W i n d o w I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method XGetWindowImage reads an image from the target X window and returns M %  it.  XGetWindowImage optionally descends the window hierarchy and overlays M %  the target image with each child image in an optimized fashion.  Any child G %  window that have the same visual, colormap, and are contained by its  %  parent are exempted.  % / %  The format of the XGetWindowImage method is:  % C %      Image *XGetWindowImage(Display *display,const Window window, = %        const unsigned int borders,const unsigned int level)  % + %  A description of each parameter follows:  % F %    o image: Method XGetWindowImage returns a MIFF image if it can beH %      successfully read from the X window.  A null image is returned if %      any errors occurs.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % = %    o window: Specifies the window to obtain the image from.  % E %    o borders: Specifies whether borders pixels are to be saved with  %      the image.  % E %    o level: Specifies an unsigned integer representing the level of I %      decent in the window hierarchy.  This value must be zero or one on J %      the initial call to XGetWindowImage.  A value of zero returns afterJ %      one call.  A value of one causes the function to descend the windowH %      hierarchy and overlay the target image with each subwindow image. %  %  */C Export Image *XGetWindowImage(Display *display,const Window window, 6   const unsigned int borders,const unsigned int level) {    typedef struct _ColormapInfo   {      Colormap       colormap;   
     XColor       *colors;       struct _ColormapInfo       *next;   } ColormapInfo;      typedef struct _WindowInfo   { 
     Window
       window, 
       parent;   
     Visual       *visual;       Colormap       colormap;        XSegment
       bounds;        RectangleInfo        crop_info;   } WindowInfo;   
   IndexPacket 
     index;     int      display_height,      display_width,     status, 
     x_offset, 
     y_offset;      RectangleInfo      crop_info;     register int     id,      i;     static ColormapInfo +     *colormap_info = (ColormapInfo *) NULL;      static int     max_windows = 0,     number_windows = 0;      static WindowInfo      *window_info;      Window
     child,     root_window;     XWindowAttributes      window_attributes;     /*     Verify window is viewable.   */&   assert(display != (Display *) NULL);A   status=XGetWindowAttributes(display,window,&window_attributes); G   if ((status == False) || (window_attributes.map_state != IsViewable))      return((Image *) NULL);    /*2     Cropping rectangle is relative to root window.   */;   root_window=XRootWindow(display,XDefaultScreen(display)); K   XTranslateCoordinates(display,window,root_window,0,0,&x_offset,&y_offset,      &child);   crop_info.x=x_offset;    crop_info.y=y_offset; *   crop_info.width=window_attributes.width;,   crop_info.height=window_attributes.height;   if (borders)     {        /*          Include border in image.       */2       crop_info.x-=window_attributes.border_width;2       crop_info.y-=window_attributes.border_width;;       crop_info.width+=window_attributes.border_width << 1; <       crop_info.height+=window_attributes.border_width << 1;     }    /*     Crop to root window.   */   if (crop_info.x < 0)     { #       crop_info.width+=crop_info.x;        crop_info.x=0;     }    if (crop_info.y < 0)     { $       crop_info.height+=crop_info.y;       crop_info.y=0;     } ?   display_width=XDisplayWidth(display,XDefaultScreen(display)); :   if ((crop_info.x+(int) crop_info.width) > display_width).     crop_info.width=display_width-crop_info.x;A   display_height=XDisplayHeight(display,XDefaultScreen(display)); <   if ((crop_info.y+(int) crop_info.height) > display_height)0     crop_info.height=display_height-crop_info.y;   /*&     Initialize window info attributes.   */$   if (number_windows >= max_windows)     {        /*.         Allocate or resize window info buffer.       */       max_windows+=1024;-       if (window_info == (WindowInfo *) NULL) "         window_info=(WindowInfo *)9           AllocateMemory(max_windows*sizeof(WindowInfo)); 
       else"         window_info=(WindowInfo *)P           ReallocateMemory((char *) window_info,max_windows*sizeof(WindowInfo));     } )   if (window_info == (WindowInfo *) NULL)      { B       MagickWarning(ResourceLimitWarning,"Unable to read X image",$         "Memory allocation failed");       return((Image *) NULL);      }    id=number_windows++;    window_info[id].window=window;2   window_info[id].visual=window_attributes.visual;6   window_info[id].colormap=window_attributes.colormap;(   window_info[id].bounds.x1=crop_info.x;(   window_info[id].bounds.y1=crop_info.y;@   window_info[id].bounds.x2=crop_info.x+(int) crop_info.width-1;A   window_info[id].bounds.y2=crop_info.y+(int) crop_info.height-1;    crop_info.x-=x_offset;   crop_info.y-=y_offset;&   window_info[id].crop_info=crop_info;   if (level != 0)%     {%       unsigned int         number_children;         Window         *children;         /*%         Descend the window hierarchy.        */L       status=XQueryTree(display,window,&root_window,&window_info[id].parent,$         &children,&number_children);       for (i=0; i < id; i++)@         if ((window_info[i].window == window_info[id].parent) &&@             (window_info[i].visual == window_info[id].visual) &&B             (window_info[i].colormap == window_info[id].colormap))H           if ((window_info[id].bounds.x1 <= window_info[i].bounds.x1) ||H               (window_info[id].bounds.x1 >= window_info[i].bounds.x2) ||H               (window_info[id].bounds.y1 <= window_info[i].bounds.y1) ||F               (window_info[id].bounds.y1 >= window_info[i].bounds.y2))
             {                /*D                 Eliminate windows not circumscribed by their parent.               */               number_windows--;                break;
             } 5       if ((status == True) && (number_children != 0)) 	         { 3           for (i=0; i < (int) number_children; i++) F             (void) XGetWindowImage(display,children[i],False,level+1);#           XFree((void *) children); 	         }      }    if (level <= 1)      {        ColormapInfo         *next;         Image          *composite_image,          *image;   	       int 
         y;         register int
         j,
         x;         register PixelPacket         *q;          register unsigned long         pixel;         unsigned int         import,M         number_colors;         XColor         *colors;         XImage         *ximage;         /*0         Get X image for each window in the list.       */       image=(Image *) NULL; +       for (id=0; id < number_windows; id++)b       {,
         /*8           Does target window intersect top level window?
         */I         import=(window_info[id].bounds.x2 >= window_info[0].bounds.x1) && D           (window_info[id].bounds.x1 <= window_info[0].bounds.x2) &&D           (window_info[id].bounds.y2 >= window_info[0].bounds.y1) &&B           (window_info[id].bounds.y1 <= window_info[0].bounds.y2);
         /*N           Is target window contained by another window with the same colormap?
         */         for (j=0; j < id; j++)B           if ((window_info[id].visual == window_info[j].visual) &&F               (window_info[id].colormap == window_info[j].colormap) &&H               (window_info[id].bounds.x1 >= window_info[j].bounds.x1) &&H               (window_info[id].bounds.y1 >= window_info[j].bounds.y1) &&H               (window_info[id].bounds.x2 <= window_info[j].bounds.x2) &&F               (window_info[id].bounds.y2 <= window_info[j].bounds.y2))             import=False;f           elseD             if ((window_info[id].visual != window_info[j].visual) ||F                 (window_info[id].colormap != window_info[j].colormap))K               if ((window_info[id].bounds.x2 > window_info[j].bounds.x1) && K                   (window_info[id].bounds.x1 < window_info[j].bounds.x2) && K                   (window_info[id].bounds.y2 > window_info[j].bounds.y1) && I                   (window_info[id].bounds.y1 < window_info[j].bounds.y2))                  import=True;         if (!import)           continue;a
         /*           Get X image.
         */8         ximage=XGetImage(display,window_info[id].window,B           window_info[id].crop_info.x,window_info[id].crop_info.y,K           window_info[id].crop_info.width,window_info[id].crop_info.height,            AllPlanes,ZPixmap); &         if (ximage == (XImage *) NULL)           continue; 
         /*%           Initialize window colormap.%
         */         number_colors=0;         colors=(XColor *) NULL;o8         if (window_info[id].colormap != (Colormap) NULL)           {a             ColormapInfo               *p;e               /*7               Search colormap list for window colormap._             */>             number_colors=window_info[id].visual->map_entries;H             for (p=colormap_info; p != (ColormapInfo *) NULL; p=p->next):               if (p->colormap == window_info[id].colormap)                 break;+             if (p == (ColormapInfo *) NULL)-               {b                 /**                   Get the window colormap.                 */O                 colors=(XColor *) AllocateMemory(number_colors*sizeof(XColor)); .                 if (colors == (XColor *) NULL)                   {r*                     XDestroyImage(ximage);+                     return((Image *) NULL);                    }aE                 if ((window_info[id].visual->class != DirectColor) && A                     (window_info[id].visual->class != TrueColor))c9                   for (i=0; i < (int) number_colors; i++)a                   {M&                     colors[i].pixel=i;$                     colors[i].pad=0;                   }                  else                   {%!                     unsigned long%                       blue,                        blue_bit,                        green,                        green_bit,                       red,                       red_bit;                       /*6                       DirectColor or TrueColor visual.                     */                     red=0;                     green=0;                     blue=0; >                     red_bit=window_info[id].visual->red_mask &>                       (~(window_info[id].visual->red_mask)+1);B                     green_bit=window_info[id].visual->green_mask &@                       (~(window_info[id].visual->green_mask)+1);@                     blue_bit=window_info[id].visual->blue_mask &?                       (~(window_info[id].visual->blue_mask)+1); ;                     for (i=0; i < (int) number_colors; i++)e                     {n9                       colors[i].pixel=red | green | blue;e&                       colors[i].pad=0;#                       red+=red_bit; A                       if (red > window_info[id].visual->red_mask)s                         red=0;'                       green+=green_bit;uE                       if (green > window_info[id].visual->green_mask))                          green=0;%                       blue+=blue_bit;aC                       if (blue > window_info[id].visual->blue_mask)p                         blue=0;n                     }e                   }%E                 XQueryColors(display,window_info[id].colormap,colors,%&                  (int) number_colors);                 /*3                   Append colormap to colormap list.                  */H                 p=(ColormapInfo *) AllocateMemory(sizeof(ColormapInfo));/                 if (p == (ColormapInfo *) NULL) )                   return((Image *) NULL); 5                 p->colormap=window_info[id].colormap; !                 p->colors=colors; &                 p->next=colormap_info;                  colormap_info=p;               }              colors=p->colors;            } 
         /*#           Allocate image structure.%
         */:         composite_image=AllocateImage((ImageInfo *) NULL);.         if (composite_image == (Image *) NULL)           {e"             XDestroyImage(ximage);#             return((Image *) NULL);g           }t
         /*)           Convert X image to MIFF format.p
         */;         if ((window_info[id].visual->class != TrueColor) && ;             (window_info[id].visual->class != DirectColor))I-           composite_image->class=PseudoClass;e/         composite_image->columns=ximage->width;s-         composite_image->rows=ximage->height; '         switch (composite_image->class)X	         {e           case DirectClass:p           default:           { "             register unsigned long               color,               index;               unsigned longu               blue_mask,               blue_shift,e               green_mask,                green_shift,               red_mask,A               red_shift;               /*@               Determine shift and mask for red, green, and blue.             */6             red_mask=window_info[id].visual->red_mask;             red_shift=0;*             while ((red_mask & 0x01) == 0)
             {                red_mask>>=1;                red_shift++;
             }d:             green_mask=window_info[id].visual->green_mask;             green_shift=0;,             while ((green_mask & 0x01) == 0)
             {e               green_mask>>=1;;               green_shift++;
             } 8             blue_mask=window_info[id].visual->blue_mask;             blue_shift=0; +             while ((blue_mask & 0x01) == 0) 
             {R               blue_mask>>=1;               blue_shift++;u
             },             /*5               Convert X image to DirectClass packets.t             */'             if ((number_colors != 0) &&,?                 (window_info[id].visual->class == DirectColor))u=               for (y=0; y < (int) composite_image->rows; y++)x               {nP                 q=SetPixelCache(composite_image,0,y,composite_image->columns,1);.                 if (q == (PixelPacket *) NULL)                   break;B                 for (x=0; x < (int) composite_image->columns; x++)                 {t.                   pixel=XGetPixel(ximage,x,y);8                   index=(pixel >> red_shift) & red_mask;7                   q->red=XDownScale(colors[index].red);f<                   index=(pixel >> green_shift) & green_mask;;                   q->green=XDownScale(colors[index].green); :                   index=(pixel >> blue_shift) & blue_mask;9                   q->blue=XDownScale(colors[index].blue); )                   q->opacity=Transparent;                    q++;                 } 5                 if (!SyncPixelCache(composite_image))x                   break;               }e             else=               for (y=0; y < (int) composite_image->rows; y++)a               {UP                 q=SetPixelCache(composite_image,0,y,composite_image->columns,1);.                 if (q == (PixelPacket *) NULL)                   break;B                 for (x=0; x < (int) composite_image->columns; x++)                 { .                   pixel=XGetPixel(ximage,x,y);8                   color=(pixel >> red_shift) & red_mask;=                   q->red=XDownScale((color*65535L)/red_mask);e<                   color=(pixel >> green_shift) & green_mask;A                   q->green=XDownScale((color*65535L)/green_mask);o:                   color=(pixel >> blue_shift) & blue_mask;?                   q->blue=XDownScale((color*65535L)/blue_mask);e)                   q->opacity=Transparent;a                   q++;                 }y5                 if (!SyncPixelCache(composite_image))                    break;               }h             break;           }/           case PseudoClass:(           {l             /*               Create colormap.             */2             composite_image->colors=number_colors;5             composite_image->colormap=(PixelPacket *)eJ               AllocateMemory(composite_image->colors*sizeof(PixelPacket));B             if (composite_image->colormap == (PixelPacket *) NULL)               { &                 XDestroyImage(ximage);.                 DestroyImage(composite_image);'                 return((Image *) NULL);o               }n=             for (i=0; i < (int) composite_image->colors; i++)e
             { =               composite_image->colormap[colors[i].pixel].red=y*                 XDownScale(colors[i].red);?               composite_image->colormap[colors[i].pixel].green=t,                 XDownScale(colors[i].green);>               composite_image->colormap[colors[i].pixel].blue=+                 XDownScale(colors[i].blue);)
             }              /*5               Convert X image to PseudoClass packets.g             */;             for (y=0; y < (int) composite_image->rows; y++)&
             {(N               q=SetPixelCache(composite_image,0,y,composite_image->columns,1);,               if (q == (PixelPacket *) NULL)                 break;@               for (x=0; x < (int) composite_image->columns; x++)               {;,                 index=XGetPixel(ximage,x,y);:                 if (composite_image->class == PseudoClass)4                   composite_image->indexes[x]=index;6                 *q++=composite_image->colormap[index];               }o3               if (!SyncPixelCache(composite_image))/                 break;
             }t             break;           } 	         }o         XDestroyImage(ximage);$         if (image == (Image *) NULL)           {_"             image=composite_image;             continue;            }n
         /*8           Composite any children in back-to-front order.
         */H         XTranslateCoordinates(display,window_info[id].window,window,0,0,&           &x_offset,&y_offset,&child);         x_offset-=crop_info.x;         if (x_offset < 0)o           x_offset=0;          y_offset-=crop_info.y;         if (y_offset < 0)            y_offset=0; @         CompositeImage(image,ReplaceCompositeOp,composite_image,           x_offset,y_offset);        }        /*         Free resources.        */4       while (colormap_info != (ColormapInfo *) NULL)       { !         next=colormap_info->next; *         FreeMemory(colormap_info->colors);"         FreeMemory(colormap_info);         colormap_info=next;;       }        /*1         Free resources and restore initial state.o       */       FreeMemory(window_info);&       window_info=(WindowInfo *) NULL;       max_windows=0;       number_windows=0;l*       colormap_info=(ColormapInfo *) NULL;       return(image);     }s   return((Image *) NULL);  }  o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %;O %                                                                             %aO %                                                                             %iO %   X G e t W i n d o w I n f o                                               %mO %                                                                             %tO %                                                                             %%O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ? %  Method XGetWindowInfo initializes the XWindowInfo structure.  % . %  The format of the XGetWindowInfo method is: % E %      void XGetWindowInfo(Display *display,XVisualInfo *visual_info, N %        XStandardColormap *map_info,XPixelInfo *pixel,XFontStruct *font_info,: %        XResourceInfo *resource_info,XWindowInfo *window) %        resource_info,window) % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %%G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure;e$ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % < %    o pixel: Specifies a pointer to a XPixelInfo structure. %eA %    o font_info: Specifies a pointer to a XFontStruct structure.l % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %  %A */E Export void XGetWindowInfo(Display *display,XVisualInfo *visual_info,sG   XStandardColormap *map_info,XPixelInfo *pixel,XFontStruct *font_info,o3   XResourceInfo *resource_info,XWindowInfo *window)n {p   /*     Initialize window info.c   */&   assert(display != (Display *) NULL);.   assert(visual_info != (XVisualInfo *) NULL);1   assert(map_info != (XStandardColormap *) NULL); '   assert(pixel != (XPixelInfo *) NULL); 2   assert(resource_info != (XResourceInfo *) NULL);)   assert(window != (XWindowInfo *) NULL); "   if (window->id != (Window) NULL)     {c*       XFreeCursor(display,window->cursor);/       XFreeCursor(display,window->busy_cursor); 5       if (window->highlight_stipple != (Pixmap) NULL)*7         XFreePixmap(display,window->highlight_stipple); 2       if (window->shadow_stipple != (Pixmap) NULL)4         XFreePixmap(display,window->shadow_stipple);     }    else     {e       /*.         Initialize these attributes just once.       */       window->id=(Window) NULL;r@       window->x=XDisplayWidth(display,visual_info->screen) >> 1;@       window->y=XDisplayWidth(display,visual_info->screen) >> 1;%       window->ximage=(XImage *) NULL;r*       window->matte_image=(XImage *) NULL;#       window->pixmap=(Pixmap) NULL;t)       window->matte_pixmap=(Pixmap) NULL;        window->mapped=False;W       window->stasis=False;t #if defined(HasSharedMemory))       window->segment_info[0].shmid=(-1);))       window->segment_info[1].shmid=(-1);] #endif     }o   /*>     Initialize these attributes every time function is called.   */%   window->screen=visual_info->screen;t8   window->root=XRootWindow(display,visual_info->screen);%   window->visual=visual_info->visual;)#   window->class=visual_info->class;s#   window->depth=visual_info->depth;i"   window->visual_info=visual_info;   window->map_info=map_info;   window->pixel_info=pixel;"   window->font_info=font_info;8   window->cursor=XCreateFontCursor(display,XC_left_ptr);:   window->busy_cursor=XCreateFontCursor(display,XC_watch);   window->name="\0";!   window->geometry=(char *) NULL;-   window->icon_name="\0";-5   window->icon_geometry=resource_info->icon_geometry;1&   window->crop_geometry=(char *) NULL;   window->flags=PSize;   window->width=1;   window->height=1;m   window->min_width=1;   window->min_height=1;    window->width_inc=1;   window->height_inc=1;_3   window->border_width=resource_info->border_width;S3   window->annotate_context=pixel->annotate_context;*5   window->highlight_context=pixel->highlight_context;f/   window->widget_context=pixel->widget_context; '   window->shadow_stipple=(Pixmap) NULL; *   window->highlight_stipple=(Pixmap) NULL;   window->use_pixmap=True;   window->immutable=False;   window->shape=False;   window->shared_memory=False;   window->data=0;nK   window->mask=CWBackingStore | CWBackPixel | CWBackPixmap | CWBitGravity | K     CWBorderPixel | CWColormap | CWCursor | CWDontPropagate | CWEventMask | 4     CWOverrideRedirect | CWSaveUnder | CWWinGravity;D   window->attributes.background_pixel=pixel->background_color.pixel;5   window->attributes.background_pixmap=(Pixmap) NULL;l/   window->attributes.bit_gravity=ForgetGravity;S-   window->attributes.backing_store=NotUseful;r&   window->attributes.save_under=False;<   window->attributes.border_pixel=pixel->border_color.pixel;1   window->attributes.colormap=map_info->colormap;e+   window->attributes.cursor=window->cursor;l7   window->attributes.do_not_propagate_mask=NoEventMask;r,   window->attributes.event_mask=NoEventMask;-   window->attributes.override_redirect=False;a2   window->attributes.win_gravity=NorthWestGravity;   window->orphan=False;  }* % /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X H i g h l i g h t E l l i p s e                                         % O %                                                                             % O %                                                                             % O %                                                                             %%O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %tI %  Method XHighlightEllipse puts a border on the X server around a regiona %  defined by highlight_info.a %c1 %  The format of the XHighlightEllipse method is:s %e= %      void XHighlightEllipse(Display *display,Window window,TA %        GC annotate_context,const RectangleInfo *highlight_info)o %z+ %  A description of each parameter follows:* %gD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %n9 %    o window: Specifies a pointer to a Window structure.  % ? %    o annotate_context: Specifies a pointer to a GC structure.m % L %    o highlight_info: Specifies a pointer to a RectangleInfo structure.  It: %      contains the extents of any highlighting rectangle. %  %b */= Export void XHighlightEllipse(Display *display,Window window,n:   GC annotate_context,const RectangleInfo *highlight_info) { &   assert(display != (Display *) NULL);"   assert(window != (Window) NULL);(   assert(annotate_context != (GC) NULL);3   assert(highlight_info != (RectangleInfo *) NULL); B   if ((highlight_info->width < 4) || (highlight_info->height < 4))     return;)=   XDrawArc(display,window,annotate_context,highlight_info->x,aG     highlight_info->y,highlight_info->width-1,highlight_info->height-1,L     0,360*64);?   XDrawArc(display,window,annotate_context,highlight_info->x+1,(I     highlight_info->y+1,highlight_info->width-3,highlight_info->height-3,(     0,360*64); }& s /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %iO %                                                                             %SO %                                                                             % O %   X H i g h l i g h t L i n e                                               % O %                                                                             %iO %                                                                             % O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o % F %  Method XHighlightLine puts a border on the X server around a region %  defined by highlight_info.e %t. %  The format of the XHighlightLine method is: %tN %      void XHighlightLine(Display *display,Window window,GC annotate_context,( %        const XSegment *highlight_info) %i+ %  A description of each parameter follows:o %eD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % 9 %    o window: Specifies a pointer to a Window structure.e %c? %    o annotate_context: Specifies a pointer to a GC structure.  % L %    o highlight_info: Specifies a pointer to a RectangleInfo structure.  It: %      contains the extents of any highlighting rectangle. %i %) */N Export void XHighlightLine(Display *display,Window window,GC annotate_context,!   const XSegment *highlight_info)d { &   assert(display != (Display *) NULL);"   assert(window != (Window) NULL);(   assert(annotate_context != (GC) NULL);.   assert(highlight_info != (XSegment *) NULL);?   XDrawLine(display,window,annotate_context,highlight_info->x1, >     highlight_info->y1,highlight_info->x2,highlight_info->y2); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X H i g h l i g h t R e c t a n g l e                                     %%O %                                                                             %BO %                                                                             %sO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l %sK %  Method XHighlightRectangle puts a border on the X server around a region  %  defined by highlight_info.  % 3 %  The format of the XHighlightRectangle method is:o %x? %      void XHighlightRectangle(Display *display,Window window, A %        GC annotate_context,const RectangleInfo *highlight_info)s %e+ %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % 9 %    o window: Specifies a pointer to a Window structure.  % ? %    o annotate_context: Specifies a pointer to a GC structure.. % L %    o highlight_info: Specifies a pointer to a RectangleInfo structure.  It: %      contains the extents of any highlighting rectangle. %m %c */? Export void XHighlightRectangle(Display *display,Window window, :   GC annotate_context,const RectangleInfo *highlight_info) { &   assert(display != (Display *) NULL);"   assert(window != (Window) NULL);(   assert(annotate_context != (GC) NULL);3   assert(highlight_info != (RectangleInfo *) NULL);oB   if ((highlight_info->width < 4) || (highlight_info->height < 4))     return;sC   XDrawRectangle(display,window,annotate_context,highlight_info->x,aH     highlight_info->y,highlight_info->width-1,highlight_info->height-1);E   XDrawRectangle(display,window,annotate_context,highlight_info->x+1,sJ     highlight_info->y+1,highlight_info->width-3,highlight_info->height-3); }s z /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             %aO %                                                                             %cO %                                                                             % O %   X I m p o r t I m a g e                                                   %mO %                                                                             %lO %                                                                             %rO %                                                                             %5O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%. %i: %  Procedure XImportImage reads an image from an X window. %;, %  The format of the XImportImage method is: %sP %      Image *XImportImage(const ImageInfo *image_info,XImportInfo *ximage_info) % + %  A description of each parameter follows:  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %iD %    o ximage_info: Specifies a pointer to an XImportInfo structure. %r %e */P Export Image *XImportImage(const ImageInfo *image_info,XImportInfo *ximage_info) {%
   Colormap     *colormaps;   	   Display 
     *display;      Image      *image;      int      number_colormaps,      number_windows,      status,      x;     RectangleInfo      crop_info;     Window     *children,     client,      prior_target, 	     root,      target;      XTextProperty      window_name;     /*     Open X server connection.    */+   assert(image_info != (ImageInfo *) NULL); .   assert(ximage_info != (XImportInfo *) NULL);0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     { C       MagickWarning(XServerWarning,"Unable to connect to X server",%/         XDisplayName(image_info->server_name));        return((Image *) NULL);n     }l   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);i   /*     Select target window.i   */   crop_info.x=0;   crop_info.y=0;   crop_info.width=0;   crop_info.height=0;y4   root=XRootWindow(display,XDefaultScreen(display));   target=(Window) NULL; 0   if ((image_info->filename != (char *) NULL) &&&       (*image_info->filename != '\0'))     {t:       if (Latin1Compare(image_info->filename,"root") == 0)         target=root;
       else	         {            /*(             Select window by ID or name.           */5           if (isdigit((int) (*image_info->filename)))s4             target=XWindowByID(display,root,(Window)=               strtol(image_info->filename,(char **) NULL,0)); &           if (target == (Window) NULL)D             target=XWindowByName(display,root,image_info->filename);&           if (target == (Window) NULL)M             MagickWarning(OptionWarning,"No window with specified id exists", $               image_info->filename);	         }X     };   /*>     If target window is not defined, interactively select one.   */   prior_target=target;   if (target == (Window) NULL)-     target=XSelectWindow(display,&crop_info);u!   client=target;   /* obsolete */X   if (target != root)u     {        unsigned int
         d;  B       status=XGetGeometry(display,target,&root,&x,&x,&d,&d,&d,&d);       if (status != 0)	         {n           for ( ; ; )            {V             Window               parent;\               /*(               Find window manager frame.             */I             status=XQueryTree(display,target,&root,&parent,&children,&d);e8             if (status && (children != (Window *) NULL))'               XFree((char *) children); I             if (!status || (parent == (Window) NULL) || (parent == root))s               break;             target=parent;           }i           /*             Get client window.           *//           client=XClientWindow(display,target);e"           if (!ximage_info->frame)             target=client;2           if (!ximage_info->frame && prior_target)              target=prior_target;'           XRaiseWindow(display,target);c+           XDelay(display,SuspendTime << 4);f	         }y     }    if (ximage_info->screen)     {i	       intt
         y;         Window         child;         XWindowAttributest         window_attributes;         /*1         Obtain window image directly from screen.o       */E       status=XGetWindowAttributes(display,target,&window_attributes);        if (status == False)	         { L           MagickWarning(XServerWarning,"Unable to read X window attributes","             image_info->filename);!           XCloseDisplay(display);i!           return((Image *) NULL); 	         } B       XTranslateCoordinates(display,target,root,0,0,&x,&y,&child);       crop_info.x=x;       crop_info.y=y;.       crop_info.width=window_attributes.width;0       crop_info.height=window_attributes.height;       if (ximage_info->borders)l	         {r           /*$             Include border in image.           */6           crop_info.x-=window_attributes.border_width;6           crop_info.y-=window_attributes.border_width;?           crop_info.width+=window_attributes.border_width << 1; @           crop_info.height+=window_attributes.border_width << 1;	         }        target=root;     }m   /*J     If WM_COLORMAP_WINDOWS property is set or multiple colormaps, descend.   */   number_windows=0;eI   status=XGetWMColormapWindows(display,target,&children,&number_windows); /   if ((status == True) && (number_windows > 0))a     {         ximage_info->descend=True;        XFree ((char *) children);     } F   colormaps=XListInstalledColormaps(display,target,&number_colormaps);   if (number_colormaps > 0)      {        if (number_colormaps > 1)s"         ximage_info->descend=True;        XFree((char *) colormaps);     }    /*+     Alert the user not to alter the screen.    */   if (!ximage_info->silent)u     XBell(display,0);    /*     Get image by window id.    */   XGrabServer(display); <   image=XGetWindowImage(display,target,ximage_info->borders,"     ximage_info->descend ? 1 : 0);   XUngrabServer(display);r   if (image == (Image *) NULL)A     MagickWarning(XServerWarning,"Unable to read X window image",i       image_info->filename);   else     { :       (void) strcpy(image->filename,image_info->filename);<       if ((crop_info.width != 0) && (crop_info.height != 0))	         {t           Image(             *cropped_image;              /*<             Crop image as defined by the cropping rectangle.           */4           cropped_image=CropImage(image,&crop_info);.           if (cropped_image != (Image *) NULL)
             { "               DestroyImage(image);"               image=cropped_image;
             }a	         }u5       status=XGetWMName(display,target,&window_name);u       if (status == True);	         {m8           if ((image_info->filename != (char *) NULL) &&.               (*image_info->filename == '\0'))
             {t               /**                 Initialize image filename.               */H               (void) strncpy(image->filename,(char *) window_name.value,*                 (int) window_name.nitems);7               image->filename[window_name.nitems]='\0';l
             }&,           XFree((void *) window_name.value);	         }n     }i   if (!ximage_info->silent)=     {a       /*"         Alert the user we're done.       */       XBell(display,0);r       XBell(display,0);      },   XCloseDisplay(display);v   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%NO %                                                                             % O %                                                                             % O %                                                                             %aO %   X I n i t i a l i z e W i n d o w s                                       %dO %                                                                             %uO %                                                                             %!O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % @ %  Method XInitializeWindows initializes the XWindows structure. %s2 %  The format of the XInitializeWindows method is: %r5 %      XWindows *XInitializeWindows(Display *display,(& %        XResourceInfo *resource_info) % + %  A description of each parameter follows:  % M %    o windows: XInitializeWindows returns a pointer to a XWindows structure.r %lE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %  */5 Export XWindows *XInitializeWindows(Display *display,    XResourceInfo *resource_info); {    Window     root_window;  
   XWindows
     *windows;      /*     Allocate windows structure.0   */8   windows=(XWindows *) AllocateMemory(sizeof(XWindows));#   if (windows == (XWindows *) NULL)      {pF       MagickWarning(ResourceLimitWarning,"Unable to create X windows",$         "Memory allocation failed");        return((XWindows *) NULL);     }nH   windows->pixel_info=(XPixelInfo *) AllocateMemory(sizeof(XPixelInfo));H   windows->icon_pixel=(XPixelInfo *) AllocateMemory(sizeof(XPixelInfo));+   windows->icon_resources=(XResourceInfo *) *     AllocateMemory(sizeof(XResourceInfo));5   if ((windows->pixel_info == (XPixelInfo *) NULL) || 5       (windows->icon_pixel == (XPixelInfo *) NULL) || :       (windows->icon_resources == (XResourceInfo *) NULL))     {hF       MagickWarning(ResourceLimitWarning,"Unable to create X windows",$         "Memory allocation failed");        return((XWindows *) NULL);     }u   /*!     Initialize windows structure.i   */   windows->display=display;mB   windows->wm_protocols=XInternAtom(display,"WM_PROTOCOLS",False);J   windows->wm_delete_window=XInternAtom(display,"WM_DELETE_WINDOW",False);D   windows->wm_take_focus=XInternAtom(display,"WM_TAKE_FOCUS",False);B   windows->im_protocols=XInternAtom(display,"IM_PROTOCOLS",False);L   windows->im_remote_command=XInternAtom(display,"IM_REMOTE_COMMAND",False);J   windows->im_update_widget=XInternAtom(display,"IM_UPDATE_WIDGET",False);   windows->im_update_colormap=4     XInternAtom(display,"IM_UPDATE_COLORMAP",False);H   windows->im_former_image=XInternAtom(display,"IM_FORMER_IMAGE",False);D   windows->im_next_image=XInternAtom(display,"IM_NEXT_IMAGE",False);J   windows->im_retain_colors=XInternAtom(display,"IM_RETAIN_COLORS",False);8   windows->im_exit=XInternAtom(display,"IM_EXIT",False);B   windows->dnd_protocols=XInternAtom(display,"DndProtocol",False); #if defined(WIN32)&   XSynchronize(display,IsWindows95()); #endif   if (resource_info->debug)      { !       XSynchronize(display,True);c@       (void) fprintf(stderr,"Version: %.1024s\n",MagickVersion);H       (void) fprintf(stderr,"  timestamp: %ld\n",time((time_t *) NULL));,       (void) fprintf(stderr,"Protocols:\n");8       (void) fprintf(stderr,"  Window Manager: 0x%lx\n",         windows->wm_protocols);;9       (void) fprintf(stderr,"    delete window: 0x%lx\n", #         windows->wm_delete_window);z6       (void) fprintf(stderr,"    take focus: 0x%lx\n",          windows->wm_take_focus);5       (void) fprintf(stderr,"  ImageMagick: 0x%lx\n",u         windows->im_protocols);p:       (void) fprintf(stderr,"    remote command: 0x%lx\n",$         windows->im_remote_command);9       (void) fprintf(stderr,"    update widget: 0x%lx\n", #         windows->im_update_widget);*;       (void) fprintf(stderr,"    update colormap: 0x%lx\n", %         windows->im_update_colormap);y8       (void) fprintf(stderr,"    former image: 0x%lx\n","         windows->im_former_image);6       (void) fprintf(stderr,"    next image: 0x%lx\n",          windows->im_next_image);9       (void) fprintf(stderr,"    retain colors: 0x%lx\n",%#         windows->im_retain_colors); B       (void) fprintf(stderr,"    exit: 0x%lx\n",windows->im_exit);7       (void) fprintf(stderr,"  Drag and Drop: 0x%lx\n",           windows->dnd_protocols);H       (void) fprintf(stderr,"  timestamp: %ld\n",time((time_t *) NULL));     }    /*     Allocate standard colormap.    */-   windows->map_info=XAllocStandardColormap(); -   windows->icon_map=XAllocStandardColormap(); :   if ((windows->map_info == (XStandardColormap *) NULL) ||8       (windows->icon_map == (XStandardColormap *) NULL))H     MagickError(ResourceLimitError,"Unable to create standard colormap","       "Memory allocation failed");.   windows->map_info->colormap=(Colormap) NULL;.   windows->icon_map->colormap=(Colormap) NULL;5   windows->pixel_info->pixels=(unsigned long *) NULL;u1   windows->pixel_info->gamma_map=(XColor *) NULL; 2   windows->pixel_info->annotate_context=(GC) NULL;3   windows->pixel_info->highlight_context=(GC) NULL;p0   windows->pixel_info->widget_context=(GC) NULL;*   windows->font_info=(XFontStruct *) NULL;2   windows->icon_pixel->annotate_context=(GC) NULL;5   windows->icon_pixel->pixels=(unsigned long *) NULL; 1   windows->icon_pixel->gamma_map=(XColor *) NULL;o   /*     Allocate visual.   */,   *windows->icon_resources=(*resource_info);2   windows->icon_resources->map_type=(char *) NULL;1   windows->icon_resources->visual_type="default";y3   windows->icon_resources->colormap=SharedColormap;n   windows->visual_info=d=     XBestVisualInfo(display,windows->map_info,resource_info);,   windows->icon_visual=nG     XBestVisualInfo(display,windows->icon_map,windows->icon_resources);v7   if ((windows->visual_info == (XVisualInfo *) NULL) ||)5       (windows->icon_visual == (XVisualInfo *) NULL))cP     MagickError(XServerError,"Unable to get visual",resource_info->visual_type);   if (resource_info->debug)      {*)       (void) fprintf(stderr,"Visual:\n");w3       (void) fprintf(stderr,"  visual id: 0x%lx\n", (         windows->visual_info->visualid);1       (void) fprintf(stderr,"  class: %.1024s\n",%7         XVisualClassName(windows->visual_info->class)); 3       (void) fprintf(stderr,"  depth: %d planes\n", %         windows->visual_info->depth); ?       (void) fprintf(stderr,"  size of colormap: %d entries\n", -         windows->visual_info->colormap_size); L       (void) fprintf(stderr,"  red, green, blue masks: 0x%lx 0x%lx 0x%lx\n",H         windows->visual_info->red_mask,windows->visual_info->green_mask,)         windows->visual_info->blue_mask); E       (void) fprintf(stderr,"  significant bits in color: %d bits\n", ,         windows->visual_info->bits_per_rgb);H       (void) fprintf(stderr,"  timestamp: %ld\n",time((time_t *) NULL));     }%   /*%     Allocate class and manager hints.    */)   windows->class_hints=XAllocClassHint();i)   windows->manager_hints=XAllocWMHints();n6   if ((windows->class_hints == (XClassHint *) NULL) ||4       (windows->manager_hints == (XWMHints *) NULL))O     MagickError(ResourceLimitError,"Unable to allocate X hints",(char *) NULL);r   /**     Determine group leader if we have one.   */@   root_window=XRootWindow(display,windows->visual_info->screen);)   windows->group_leader.id=(Window) NULL;i3   if (resource_info->window_group != (char *) NULL)o     {e8       if (isdigit((int) (*resource_info->window_group)))I         windows->group_leader.id=XWindowByID(display,root_window,(Window) I           strtol((char *) resource_info->window_group,(char **) NULL,0));a4       if (windows->group_leader.id == (Window) NULL)!         windows->group_leader.id= I           XWindowByName(display,root_window,resource_info->window_group);y     }L   return(windows); }= e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %tO %                                                                             %nO %                                                                             %%O %   X M a k e C u r s o r                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 6 %  Method XMakeCursor creates a crosshairs X11 cursor. % + %  The format of the XMakeCursor method is:  % K %      Cursor XMakeCursor(Display *display,Window window,Colormap colormap, 7 %        char *background_color,char *foreground_color)% %%+ %  A description of each parameter follows:n %nE %    o display: Specifies a connection to an X server;  returned fromW %      XOpenDisplay. %hE %    o window: Specifies the ID of the window for which the cursor isi %      assigned. %TK %    o colormap: Specifies the ID of the colormap from which the backgroundt. %      and foreground color will be retrieved. %nN %    o background_color: Specifies the color to use for the cursor background. %dN %    o foreground_color: Specifies the color to use for the cursor foreground. %i %t */K Export Cursor XMakeCursor(Display *display,Window window,Colormap colormap, 0   char *background_color,char *foreground_color) {  #define scope_height 17  #define scope_x_hot 8f #define scope_y_hot 8a #define scope_width 17     static const unsigned char     scope_bits[] =     {oG       0x80, 0x03, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02,tG       0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x7f, G       0xfc, 0x01, 0x01, 0x00, 0x01, 0x7f, 0xfc, 0x01, 0x80, 0x02, 0x00,sG       0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, .       0x00, 0x80, 0x02, 0x00, 0x80, 0x03, 0x00     },     scope_mask_bits[] =      {sG       0xc0, 0x07, 0x00, 0xc0, 0x07, 0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06,AG       0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06, 0x00, 0xff, 0xfe, 0x01, 0x7f, G       0xfc, 0x01, 0x03, 0x80, 0x01, 0x7f, 0xfc, 0x01, 0xff, 0xfe, 0x01,eG       0xc0, 0x06, 0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06,w.       0x00, 0xc0, 0x07, 0x00, 0xc0, 0x07, 0x00     };     Cursor     cursor;      Pixmap	     mask,%     source;%     XColor     background,%     foreground;%  &   assert(display != (Display *) NULL);"   assert(window != (Window) NULL);&   assert(colormap != (Colormap) NULL);,   assert(background_color != (char *) NULL);,   assert(foreground_color != (char *) NULL);N   source=XCreateBitmapFromData(display,window,(char *) scope_bits,scope_width,     scope_height);E   mask=XCreateBitmapFromData(display,window,(char *) scope_mask_bits,      scope_width,scope_height);;   if ((source == (Pixmap) NULL) || (mask == (Pixmap) NULL))      { L       MagickWarning(XServerWarning,"Unable to create pixmap",(char *) NULL);       return((Cursor) NULL);     }%=   XParseColor(display,colormap,background_color,&background); =   XParseColor(display,colormap,foreground_color,&foreground); I   cursor=XCreatePixmapCursor(display,source,mask,&foreground,&background,i     scope_x_hot,scope_y_hot);a   XFreePixmap(display,source);   XFreePixmap(display,mask);   return(cursor);e }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             % O %                                                                             %fO %                                                                             %aO %   X M a k e I m a g e                                                       %nO %                                                                             %wO %                                                                             %oO %                                                                             %dO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %iJ %  Method XMakeImage creates an X11 image.  If the image size differs from2 %  the X11 image size, the image is first resized. %s* %  The format of the XMakeImage method is: %s0 %      unsigned int XMakeImage(Display *display,M %        const XResourceInfo *resource_info,XWindowInfo *window,Image *image, 0 %        unsigned int width,unsigned int height) %l+ %  A description of each parameter follows:t %d? %    o status: Method XMakeImage returns True if the X image is(N %      successfully created.  False is returned is there is a memory shortage. %oD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %%K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % > %    o window: Specifies a pointer to a XWindowInfo structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  % F %    o width: Specifies the width in pixels of the rectangular area to %      display.  % H %    o height: Specifies the height in pixels of the rectangular area to %      display.  %  %  */0 Export unsigned int XMakeImage(Display *display,F   const XResourceInfo *resource_info,XWindowInfo *window,Image *image,)   unsigned int width,unsigned int height)  {    Image      *transformed_image;%     int%
     depth,     format;%     XImage     *matte_image,      *ximage;  &   assert(display != (Display *) NULL);2   assert(resource_info != (XResourceInfo *) NULL);)   assert(window != (XWindowInfo *) NULL);    assert(width != 0);v   assert(height != 0);4   if ((window->width == 0) || (window->height == 0))     return(False);   /*'     Apply user transforms to the image.p   */8   XDefineCursor(display,window->id,window->busy_cursor);   XFlush(display);   depth=window->depth;   transformed_image=image;*   if (transformed_image != (Image *) NULL)     {a        if (window->crop_geometry)	         {            Image              *cropped_image;              RectangleInfol             crop_info;             /*             Crop image.i           */5           crop_info.width=transformed_image->columns; 3           crop_info.height=transformed_image->rows;l           crop_info.x=0;           crop_info.y=0;C           (void) XParseGeometry(window->crop_geometry,&crop_info.x,e=             &crop_info.y,&crop_info.width,&crop_info.height);w@           cropped_image=CropImage(transformed_image,&crop_info);.           if (cropped_image != (Image *) NULL)
             {%-               if (transformed_image != image)%0                 DestroyImage(transformed_image);.               transformed_image=cropped_image;
             } 	         } 2       if ((width != transformed_image->columns) ||.           (height != transformed_image->rows))	         {            Image              *zoomed_image;             /*             Scale image.           */L           if ((window->pixel_info->colors != 0) || transformed_image->matte)E             zoomed_image=SampleImage(transformed_image,width,height);            elseC             zoomed_image=ZoomImage(transformed_image,width,height); -           if (zoomed_image != (Image *) NULL)%
             {%-               if (transformed_image != image)s0                 DestroyImage(transformed_image);-               transformed_image=zoomed_image;D
             } 	         }        if (window->immutable)1         if (IsMonochromeImage(transformed_image))p           depth=1;'       width=transformed_image->columns;e%       height=transformed_image->rows;r     }    /*     Create X image.    */   ximage=(XImage *) NULL;s+   format=(depth == 1) ? XYBitmap : ZPixmap;  #if defined(HasSharedMemory)   if (window->shared_memory)     {,O       ximage=XShmCreateImage(display,window->visual,depth,format,(char *) NULL, /         &window->segment_info[1],width,height);)<       window->segment_info[1].shmid=shmget(IPC_PRIVATE,(int)B         (ximage->bytes_per_line*ximage->height),IPC_CREAT | 0777);?       window->shared_memory=window->segment_info[1].shmid >= 0;         if (window->shared_memory)0         window->segment_info[1].shmaddr=(char *)3           shmat(window->segment_info[1].shmid,0,0);%     }1 #endif   if (!window->shared_memory)UL     ximage=XCreateImage(display,window->visual,depth,format,0,(char *) NULL,*       width,height,XBitmapPad(display),0);    if (ximage == (XImage *) NULL)     {a       /*!         Unable to create X image.)       */%       if (transformed_image != image)%(         DestroyImage(transformed_image);7       XDefineCursor(display,window->id,window->cursor);        return(False);     }    if (resource_info->debug)      { )       (void) fprintf(stderr,"XImage:\n"); E       (void) fprintf(stderr,"  width, height: %dx%d\n",ximage->width,          ximage->height);=       (void) fprintf(stderr,"  format: %d\n",ximage->format); E       (void) fprintf(stderr,"  byte order: %d\n",ximage->byte_order); H       (void) fprintf(stderr,"  bitmap unit, bit order, pad: %d %d %d\n",I         ximage->bitmap_unit,ximage->bitmap_bit_order,ximage->bitmap_pad); ;       (void) fprintf(stderr,"  depth: %d\n",ximage->depth);%M       (void) fprintf(stderr,"  bytes per line: %d\n",ximage->bytes_per_line); M       (void) fprintf(stderr,"  bits per pixel: %d\n",ximage->bits_per_pixel); L       (void) fprintf(stderr,"  red, green, blue masks: 0x%lx 0x%lx 0x%lx\n",?         ximage->red_mask,ximage->green_mask,ximage->blue_mask);yH       (void) fprintf(stderr,"  timestamp: %ld\n",time((time_t *) NULL));     }t   /*      Allocate X image pixel data.   */ #if defined(HasSharedMemory)   if (window->shared_memory)     {        xerror_alert=False;p3       ximage->data=window->segment_info[1].shmaddr;i-       window->segment_info[1].readOnly=False;w3       XShmAttach(display,&window->segment_info[1]);n       XSync(display,False);        if (xerror_alert) 	         { &           window->shared_memory=False;0           if (window->ximage != (XImage *) NULL)
             { ;               XShmDetach(display,&window->segment_info[1]); #               XSync(display,False);R<               (void) shmdt(window->segment_info[1].shmaddr);F               (void) shmctl(window->segment_info[1].shmid,IPC_RMID,0);1               window->segment_info[1].shmid=(-1);X1               window->ximage->data=(char *) NULL;e
             }A	         }y     }e #endif   if (!window->shared_memory)(     {!%       if (ximage->format == XYBitmap)=         ximage->data=(char *)&N           AllocateMemory(ximage->bytes_per_line*ximage->height*ximage->depth);
       else         ximage->data=(char *)p@           AllocateMemory(ximage->bytes_per_line*ximage->height);     }d$   if (ximage->data == (char *) NULL)     {%       /*&         Unable to allocate pixel data.       */%       if (transformed_image != image) (         DestroyImage(transformed_image);       XDestroyImage(ximage);7       XDefineCursor(display,window->id,window->cursor);        return(False);     } (   if (window->ximage != (XImage *) NULL)     {        /*!         Destroy previous X image.        */ #if defined(HasSharedMemory)-       if (window->segment_info[0].shmid >= 0) 	         { 7           XShmDetach(display,&window->segment_info[0]);            XSync(display,False); 8           (void) shmdt(window->segment_info[0].shmaddr);B           (void) shmctl(window->segment_info[0].shmid,IPC_RMID,0);-           window->segment_info[0].shmid=(-1);t-           window->ximage->data=(char *) NULL;t	         }. #endif0       if (window->ximage->data != (char *) NULL))         FreeMemory(window->ximage->data);d)       window->ximage->data=(char *) NULL;o$       XDestroyImage(window->ximage);     }, #if defined(HasSharedMemory)2   window->segment_info[0]=window->segment_info[1]; #endif   window->ximage=ximage;   matte_image=(XImage *) NULL;*   if (transformed_image != (Image *) NULL)!     if (transformed_image->matte)1       {e
         /*           Create matte image.f
         */E         matte_image=XCreateImage(display,window->visual,1,XYBitmap,0,t<           (char *) NULL,width,height,XBitmapPad(display),0);!         if (resource_info->debug)o           {c4             (void) fprintf(stderr,"Matte Image:\n");P             (void) fprintf(stderr,"  width, height: %dx%d\n",matte_image->width,#               matte_image->height);aN             (void) fprintf(stderr,"  timestamp: %ld\n",time((time_t *) NULL));           } +         if (matte_image != (XImage *) NULL)            {              /*.               Allocate matte image pixel data.             */6             matte_image->data=(char *) AllocateMemory(*               matte_image->bytes_per_line*6               matte_image->height*matte_image->depth);3             if (matte_image->data == (char *) NULL)a               { +                 XDestroyImage(matte_image);e,                 matte_image=(XImage *) NULL;               }            }        }d-   if (window->matte_image != (XImage *) NULL)f     {n       /*         Free matte image.(       */5       if (window->matte_image->data != (char *) NULL)m5         (void) FreeMemory(window->matte_image->data);y.       window->matte_image->data=(char *) NULL;)       XDestroyImage(window->matte_image);t     }i"   window->matte_image=matte_image;,   if (window->matte_pixmap != (Pixmap) NULL)     {s0       XFreePixmap(display,window->matte_pixmap);)       window->matte_pixmap=(Pixmap) NULL;p #if defined(HasShape)s       if (window->shape)N         XShapeCombineMask(display,window->id,ShapeBounding,0,0,None,ShapeSet); #endif     }z   window->stasis=False;-   /*5     Convert runlength-encoded pixels to X image data.r   */*   if (transformed_image != (Image *) NULL)     { N       if ((ximage->byte_order == LSBFirst) || ((ximage->format == XYBitmap) &&2           (ximage->bitmap_bit_order == LSBFirst)))I         XMakeImageLSBFirst(resource_info,window,transformed_image,ximage,)           matte_image);m
       elseI         XMakeImageMSBFirst(resource_info,window,transformed_image,ximage,=           matte_image);i     }n-   if (window->matte_image != (XImage *) NULL)i     {n       /*         Create matte pixmap.       */L       window->matte_pixmap=XCreatePixmap(display,window->id,width,height,1);0       if (window->matte_pixmap != (Pixmap) NULL)	         {;           GC             graphics_context;v             XGCValuesa             context_values;e             /*-             Copy matte image to matte pixmap.)           */&           context_values.background=1;&           context_values.foreground=0;B           graphics_context=XCreateGC(display,window->matte_pixmap,9             GCBackground | GCForeground,&context_values); B           XPutImage(display,window->matte_pixmap,graphics_context,6             window->matte_image,0,0,0,0,width,height);,           XFreeGC(display,graphics_context); #if defined(HasShape)_           if (window->shape)C             XShapeCombineMask(display,window->id,ShapeBounding,0,0,u-               window->matte_pixmap,ShapeSet);e #endif	         }e       } !   if (transformed_image != image)n$     DestroyImage(transformed_image);3   (void) XMakePixmap(display,resource_info,window);_   /*     Restore cursor.n   */3   XDefineCursor(display,window->id,window->cursor);,   return(True);* }  e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)O %                                                                             %tO %                                                                             % O %                                                                             %eO +   X M a k e I m a g e L S B F i r s t                                       % O %                                                                             % O %                                                                             %iO %                                                                             %wO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %nH %  Method XMakeImageLSBFirst initializes the pixel data of an X11 Image.H %  The X image pixels are copied in least-significant bit and byte firstL %  order.  The server's scanline pad is respected.  Rather than using one orL %  two general cases, many special cases are found here to help speed up the %  image conversion. %t2 %  The format of the XMakeImageLSBFirst method is: %VA %      void XMakeMagnifyImage(Display *display,XWindows *windows)  %s+ %  A description of each parameter follows:  %(K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.s % > %    o window: Specifies a pointer to a XWindowInfo structure. %%F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  % H %    o ximage: Specifies a pointer to a XImage structure;  returned from %      XCreateImage. % M %    o matte_image: Specifies a pointer to a XImage structure;  returned from  %      XCreateImage. %  */B static void XMakeImageLSBFirst(const XResourceInfo *resource_info,L   const XWindowInfo *window,Image *image,XImage *ximage,XImage *matte_image) {    int      y;     register int     x;     register PixelPacket     *p;      register unsigned char     bit,	     byte,      *q;      register unsigned long
     pixel;     register XColor%     *gamma_map;%     unsigned int     scanline_pad;      unsigned longt     *pixels;     XStandardColormapa     *map_info;  2   assert(resource_info != (XResourceInfo *) NULL);)   assert(window != (XWindowInfo *) NULL);n"   assert(image != (Image *) NULL);&   scanline_pad=ximage->bytes_per_line-2     ((ximage->width*ximage->bits_per_pixel) >> 3);   map_info=window->map_info;$   pixels=window->pixel_info->pixels;*   gamma_map=window->pixel_info->gamma_map;#   q=(unsigned char *) ximage->data;c   x=0;!   if (ximage->format == XYBitmap)r     {m       register unsigned shorto         polarity;a         unsigned charr         background,m         foreground;.         /*+         Convert image to big-endian bitmap.e       */C       background=(Intensity(window->pixel_info->foreground_color) < G         Intensity(window->pixel_info->background_color) ? 0x80 : 0x00); C       foreground=(Intensity(window->pixel_info->background_color) < G         Intensity(window->pixel_info->foreground_color) ? 0x80 : 0x00);4=       polarity=Intensity(image->colormap[0]) < (MaxRGB >> 1);        if (image->colors == 2)-O         polarity=Intensity(image->colormap[0]) < Intensity(image->colormap[1]);7+       for (y=0; y < (int) image->rows; y++)        { 7         if (!GetPixelCache(image,0,y,image->columns,1))1           break;         bit=0;         byte=0; 0         for (x=0; x < (int) image->columns; x++)	         {            byte>>=1; ,           if (image->indexes[x] == polarity)             byte|=foreground;n           else             byte|=background;e           bit++;           if (bit == 8)]
             {m               *q++=byte;               bit=0;               byte=0;i
             }/	         }0         if (bit != 0)            *q=byte >> (8-bit);          q+=scanline_pad;       }      }    else(     if (window->pixel_info->colors != 0)%       switch (ximage->bits_per_pixel)        {o         case 2:z	         {d           register unsigned int(             nibble;              /*2             Convert to 2 bit color-mapped X image.           *//           for (y=0; y < (int) image->rows; y++)i           {g;             if (!GetPixelCache(image,0,y,image->columns,1))d               break;             nibble=0;k4             for (x=0; x < (int) image->columns; x++)
             {M5               pixel=pixels[image->indexes[x]] & 0x0f;                switch (nibble)e               {                  case 0:i                 { +                   *q=(unsigned char) pixel;                    nibble++;                    break;                 };                 case 1:e                 {e3                   *q|=(unsigned char) (pixel << 2);                    nibble++;a                   break;                 }                  case 2:a                 { 3                   *q|=(unsigned char) (pixel << 4);]                   nibble++;                    break;                 }:                 case 3:-                 { 3                   *q|=(unsigned char) (pixel << 6);h                   q++;                   nibble=0;g                   break;                 }u               }R
             }              q+=scanline_pad;           }c           break;	         }l         case 4:e	         {a           register unsigned int;             nibble;>             /*2             Convert to 4 bit color-mapped X image.           *//           for (y=0; y < (int) image->rows; y++)            {              nibble=0; ;             if (!GetPixelCache(image,0,y,image->columns,1))a               break;4             for (x=0; x < (int) image->columns; x++)
             {]4               pixel=pixels[image->indexes[x]] & 0xf;               switch (nibble)d               {e                 case 0:                  {(+                   *q=(unsigned char) pixel;n                   nibble++;                    break;                 }                  case 1:a                 {f3                   *q|=(unsigned char) (pixel << 4);d                   q++;                   nibble=0;0                   break;                 }n               } 
             }u             q+=scanline_pad;           }[           break;	         }%         case 6:%         case 8:%	         {%           /*2             Convert to 8 bit color-mapped X image.           */.           if (resource_info->color_recovery &&3               resource_info->quantize_info->dither) 
             { )               XDitherImage(image,ximage);                break;
             } /           for (y=0; y < (int) image->rows; y++)            { ;             if (!GetPixelCache(image,0,y,image->columns,1))                break;4             for (x=0; x < (int) image->columns; x++)
             { .               pixel=pixels[image->indexes[x]];)               *q++=(unsigned char) pixel; 
             }%             q+=scanline_pad;           }%           break;	         }%         default:	         {e           register int             k;             register unsigned int:             bytes_per_pixel;             unsigned chare+             channel[sizeof(unsigned long)];l             /*7             Convert to multi-byte color-mapped X image.            */6           bytes_per_pixel=ximage->bits_per_pixel >> 3;/           for (y=0; y < (int) image->rows; y++)            {o;             if (!GetPixelCache(image,0,y,image->columns,1)).               break;4             for (x=0; x < (int) image->columns; x++)
             {p.               pixel=pixels[image->indexes[x]];7               for (k=0; k < (int) bytes_per_pixel; k++)                { 1                 channel[k]=(unsigned char) pixel;D                 pixel>>=8;               }i7               for (k=0; k < (int) bytes_per_pixel; k++)                   *q++=channel[k];
             }              q+=scanline_pad;           }p           break;	         }k       }p     else%       switch (ximage->bits_per_pixel)e       {          case 2:t	         {d           register unsigned inte             nibble;s             /*@             Convert to contiguous 2 bit continuous-tone X image.           *//           for (y=0; y < (int) image->rows; y++)I           {              nibble=0; 8             p=GetPixelCache(image,0,y,image->columns,1);*             if (p == (PixelPacket *) NULL)               break;4             for (x=0; x < (int) image->columns; x++)
             {DC               pixel=XGammaPixel(map_info,gamma_map,p,QuantumDepth);n               pixel&=0xf;                switch (nibble)                {a                 case 0:                  {*+                   *q=(unsigned char) pixel;t                   nibble++;e                   break;                 };                 case 1:i                 {_3                   *q|=(unsigned char) (pixel << 2);G                   nibble++;                    break;                 }w                 case 2:                  { 3                   *q|=(unsigned char) (pixel << 4);y                   nibble++;,                   break;                 }                  case 3:x                 {a3                   *q|=(unsigned char) (pixel << 6);d                   q++;                   nibble=0;l                   break;                 })               }(               p++;
             }p             q+=scanline_pad;           }            break;	         }          case 4: 	         {D           register unsigned int_             nibble;o             /*@             Convert to contiguous 4 bit continuous-tone X image.           *//           for (y=0; y < (int) image->rows; y++)(           {p8             p=GetPixelCache(image,0,y,image->columns,1);*             if (p == (PixelPacket *) NULL)               break;             nibble=0;r4             for (x=0; x < (int) image->columns; x++)
             {gC               pixel=XGammaPixel(map_info,gamma_map,p,QuantumDepth);f               pixel&=0xf;f               switch (nibble)g               {w                 case 0:g                 { +                   *q=(unsigned char) pixel;                    nibble++;l                   break;                 }f                 case 1:i                 {.3                   *q|=(unsigned char) (pixel << 4);-                   q++;                   nibble=0;a                   break;                 }v               }                p++;
             }o             q+=scanline_pad;           },           break;	         }          case 6:-         case 8:i	         {f           /*@             Convert to contiguous 8 bit continuous-tone X image.           */.           if (resource_info->color_recovery &&3               resource_info->quantize_info->dither) 
             {r)               XDitherImage(image,ximage);,               break;
             }i/           for (y=0; y < (int) image->rows; y++),           { 8             p=GetPixelCache(image,0,y,image->columns,1);*             if (p == (PixelPacket *) NULL)               break;4             for (x=0; x < (int) image->columns; x++)
             {oC               pixel=XGammaPixel(map_info,gamma_map,p,QuantumDepth);d)               *q++=(unsigned char) pixel;x               p++;
             }a             q+=scanline_pad;           }            break;	         }w         default:	         {yM           if ((ximage->bits_per_pixel == 32) && (map_info->red_max == 255) && L               (map_info->green_max == 255) && (map_info->blue_max == 255) &&O               (map_info->red_mult == 65536) && (map_info->green_mult == 256) &&,)               (map_info->blue_mult == 1)) 
             {F               /*:                 Convert to 32 bit continuous-tone X image.               */3               for (y=0; y < (int) image->rows; y++)-               {,<                 p=GetPixelCache(image,0,y,image->columns,1);.                 if (p == (PixelPacket *) NULL)                   break;8                 for (x=0; x < (int) image->columns; x++)                 {a:                   *q++=DownScale(gamma_map[p->blue].blue);<                   *q++=DownScale(gamma_map[p->green].green);8                   *q++=DownScale(gamma_map[p->red].red);                   *q++=0;g                   p++;                 }X               }w
             },           elseO             if ((ximage->bits_per_pixel == 32) && (map_info->red_max == 255) && N                 (map_info->green_max == 255) && (map_info->blue_max == 255) &&M                 (map_info->red_mult == 1) && (map_info->green_mult == 256) &&r/                 (map_info->blue_mult == 65536))=               {N                 /*<                   Convert to 32 bit continuous-tone X image.                 */5                 for (y=0; y < (int) image->rows; y++)                  {t>                   p=GetPixelCache(image,0,y,image->columns,1);0                   if (p == (PixelPacket *) NULL)                     break;:                   for (x=0; x < (int) image->columns; x++)                   { :                     *q++=DownScale(gamma_map[p->red].red);>                     *q++=DownScale(gamma_map[p->green].green);<                     *q++=DownScale(gamma_map[p->blue].blue);                     *q++=0;                      p++;                   }S                 }r               }              else               {S                 register int                   k;  %                 register unsigned inte"                   bytes_per_pixel;                   unsigned charr1                   channel[sizeof(unsigned long)];e                   /*@                   Convert to multi-byte continuous-tone X image.                 */<                 bytes_per_pixel=ximage->bits_per_pixel >> 3;5                 for (y=0; y < (int) image->rows; y++)a                 {r>                   p=GetPixelCache(image,0,y,image->columns,1);0                   if (p == (PixelPacket *) NULL)                     break;:                   for (x=0; x < (int) image->columns; x++)                   {iI                     pixel=XGammaPixel(map_info,gamma_map,p,QuantumDepth);e=                     for (k=0; k < (int) bytes_per_pixel; k++)n                     {I7                       channel[k]=(unsigned char) pixel;                         pixel>>=8;                     }i=                     for (k=0; k < (int) bytes_per_pixel; k++) &                       *q++=channel[k];                     p++;                   }r"                   q+=scanline_pad;                 }                }d           break;	         }(       } %   if (matte_image != (XImage *) NULL)      {0       /*         Initialize matte image.        *//       scanline_pad=matte_image->bytes_per_line- @         ((matte_image->width*matte_image->bits_per_pixel) >> 3);,       q=(unsigned char *) matte_image->data;+       for (y=0; y < (int) image->rows; y++)        { 4         p=GetPixelCache(image,0,y,image->columns,1);&         if (p == (PixelPacket *) NULL)           break;         bit=0;         byte=0;*0         for (x=0; x < (int) image->columns; x++)	         {-           byte>>=1;2(           if (p->opacity == Transparent)             byte|=0x80;            bit++;           if (bit == 8)*
             {                *q++=byte;               bit=0;               byte=0;)
             }e           p++;	         }d         if (bit != 0)            *q=byte >> (8-bit);L         q+=scanline_pad;       }      }r }i e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             % O %                                                                             %iO %                                                                             %iO +   X M a k e I m a g e M S B F i r s t                                       %tO %                                                                             % O %                                                                             %%O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method XMakeImageMSBFirst initializes the pixel data of an X11 Image.N %  The X image pixels are copied in most-significant bit and byte first order.L %  The server's scanline pad is also respected. Rather than using one or twoN %  general cases, many special cases are found here to help speed up the image %  conversion. % 2 %  The format of the XMakeImageMSBFirst method is: % H %      XMakeImageMSBFirst(resource_info,window,image,ximage,matte_image) % + %  A description of each parameter follows:% %%K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.r %o> %    o window: Specifies a pointer to a XWindowInfo structure. %eF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %tH %    o ximage: Specifies a pointer to a XImage structure;  returned from %      XCreateImage. % M %    o matte_image: Specifies a pointer to a XImage structure;  returned from  %      XCreateImage. %  %o */B static void XMakeImageMSBFirst(const XResourceInfo *resource_info,L   const XWindowInfo *window,Image *image,XImage *ximage,XImage *matte_image) {    inty     y;     register int     x;     register PixelPacket     *p;s     register unsigned char     bit,	     byte,e     *q;      register unsigned long
     pixel;     register XColor      *gamma_map;f     unsigned int     scanline_pad;      unsigned longe     *pixels;     XStandardColormapG     *map_info;  2   assert(resource_info != (XResourceInfo *) NULL);)   assert(window != (XWindowInfo *) NULL);F"   assert(image != (Image *) NULL);&   scanline_pad=ximage->bytes_per_line-2     ((ximage->width*ximage->bits_per_pixel) >> 3);   map_info=window->map_info;$   pixels=window->pixel_info->pixels;*   gamma_map=window->pixel_info->gamma_map;#   q=(unsigned char *) ximage->data;    x=0;!   if (ximage->format == XYBitmap)      {        register unsigned short          polarity;          unsigned char          background,          foreground;          /*+         Convert image to big-endian bitmap.        */C       background=(Intensity(window->pixel_info->foreground_color) < G         Intensity(window->pixel_info->background_color) ? 0x01 : 0x00); C       foreground=(Intensity(window->pixel_info->background_color) < G         Intensity(window->pixel_info->foreground_color) ? 0x01 : 0x00); =       polarity=Intensity(image->colormap[0]) < (MaxRGB >> 1);%       if (image->colors == 2)%O         polarity=Intensity(image->colormap[0]) < Intensity(image->colormap[1]); +       for (y=0; y < (int) image->rows; y++)        { 7         if (!GetPixelCache(image,0,y,image->columns,1))_           break;         bit=0;         byte=0;I0         for (x=0; x < (int) image->columns; x++)	         {e           byte<<=1;f,           if (image->indexes[x] == polarity)             byte|=foreground;o           else             byte|=background;            bit++;           if (bit == 8)r
             {                *q++=byte;               bit=0;               byte=0;i
             }u	         }          if (bit != 0)a           *q=byte << (8-bit);          q+=scanline_pad;       }r     }i   else(     if (window->pixel_info->colors != 0)%       switch (ximage->bits_per_pixel)n       {X         case 2:r	         {            register unsigned int              nibble;c             /*2             Convert to 2 bit color-mapped X image.           *//           for (y=0; y < (int) image->rows; y++)e           {i;             if (!GetPixelCache(image,0,y,image->columns,1))D               break;             nibble=0; 4             for (x=0; x < (int) image->columns; x++)
             { 4               pixel=pixels[image->indexes[x]] & 0xf;               switch (nibble)D               {                  case 0:                  {U2                   *q=(unsigned char) (pixel << 6);                   nibble++;X                   break;                 }m                 case 1:                  {g3                   *q|=(unsigned char) (pixel << 4);=                   nibble++;                    break;                 }                  case 2:                  {f3                   *q|=(unsigned char) (pixel << 2);>                   nibble++;y                   break;                 }f                 case 3:o                 { ,                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;t                   break;                 }i               }-
             }e             q+=scanline_pad;           }t           break;	         }          case 4:,	         {-           register unsigned inte             nibble;w             /*2             Convert to 4 bit color-mapped X image.           *//           for (y=0; y < (int) image->rows; y++)o           {F;             if (!GetPixelCache(image,0,y,image->columns,1))(               break;             nibble=0; 4             for (x=0; x < (int) image->columns; x++)
             {(4               pixel=pixels[image->indexes[x]] & 0xf;               switch (nibble)u               {p                 case 0:                  { 2                   *q=(unsigned char) (pixel << 4);                   nibble++;L                   break;                 }e                 case 1:)                 {(,                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;%                   break;                 }                } 
             }              q+=scanline_pad;           }            break;	         }          case 6:          case 8: 	         {            /*2             Convert to 8 bit color-mapped X image.           */.           if (resource_info->color_recovery &&3               resource_info->quantize_info->dither) 
             { )               XDitherImage(image,ximage);                break;
             } /           for (y=0; y < (int) image->rows; y++)            { ;             if (!GetPixelCache(image,0,y,image->columns,1))%               break;4             for (x=0; x < (int) image->columns; x++)
             {r.               pixel=pixels[image->indexes[x]];)               *q++=(unsigned char) pixel; 
             }d             q+=scanline_pad;           }n           break;	         }S         default:	         {            register int             k;             register unsigned int              bytes_per_pixel;             unsigned chare+             channel[sizeof(unsigned long)];              /*2             Convert to 8 bit color-mapped X image.           */6           bytes_per_pixel=ximage->bits_per_pixel >> 3;/           for (y=0; y < (int) image->rows; y++)            {n;             if (!GetPixelCache(image,0,y,image->columns,1))                break;4             for (x=0; x < (int) image->columns; x++)
             {d.               pixel=pixels[image->indexes[x]];4               for (k=bytes_per_pixel-1; k >= 0; k--)               {r1                 channel[k]=(unsigned char) pixel;                  pixel>>=8;               };7               for (k=0; k < (int) bytes_per_pixel; k++)F                  *q++=channel[k];
             }r             q+=scanline_pad;           }o           break;	         }l       }_     else%       switch (ximage->bits_per_pixel)_       {o         case 2:e	         {f           register unsigned int              nibble;_             /*5             Convert to 4 bit continuous-tone X image.c           *//           for (y=0; y < (int) image->rows; y++)x           { 8             p=GetPixelCache(image,0,y,image->columns,1);*             if (p == (PixelPacket *) NULL)               break;             nibble=0;e4             for (x=0; x < (int) image->columns; x++)
             {)C               pixel=XGammaPixel(map_info,gamma_map,p,QuantumDepth);                pixel&=0xf;                switch (nibble)s               {p                 case 0:U                 { 2                   *q=(unsigned char) (pixel << 6);                   nibble++;%                   break;                 }                  case 1:                  { 3                   *q|=(unsigned char) (pixel << 4);                    nibble++;                    break;                 }                  case 2:                  { 3                   *q|=(unsigned char) (pixel << 2);                    nibble++;                    break;                 }                  case 3:                  { ,                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;                    break;                 }%               }%               p++;
             }%             q+=scanline_pad;           }e           break;	         }I         case 4: 	         {r           register unsigned intd             nibble;              /*5             Convert to 4 bit continuous-tone X image.            *//           for (y=0; y < (int) image->rows; y++)            {X8             p=GetPixelCache(image,0,y,image->columns,1);*             if (p == (PixelPacket *) NULL)               break;             nibble=0;/4             for (x=0; x < (int) image->columns; x++)
             {-C               pixel=XGammaPixel(map_info,gamma_map,p,QuantumDepth);e               pixel&=0xf;e               switch (nibble)l               {f                 case 0:a                 {(2                   *q=(unsigned char) (pixel << 4);                   nibble++;m                   break;                 }a                 case 1:a                 {o,                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;t                   break;                 }                }%               p++;
             }%             q+=scanline_pad;           }            break;	         }          case 6:          case 8: 	         {            /*5             Convert to 8 bit continuous-tone X image.            */.           if (resource_info->color_recovery &&3               resource_info->quantize_info->dither) 
             { )               XDitherImage(image,ximage);                break;
             } /           for (y=0; y < (int) image->rows; y++)            { 8             p=GetPixelCache(image,0,y,image->columns,1);*             if (p == (PixelPacket *) NULL)               break;4             for (x=0; x < (int) image->columns; x++)
             {%C               pixel=XGammaPixel(map_info,gamma_map,p,QuantumDepth);S)               *q++=(unsigned char) pixel;a               p++;
             }s             q+=scanline_pad;           }a           break;	         }r         default:	         {nM           if ((ximage->bits_per_pixel == 32) && (map_info->red_max == 255) && L               (map_info->green_max == 255) && (map_info->blue_max == 255) &&O               (map_info->red_mult == 65536) && (map_info->green_mult == 256) &&m)               (map_info->blue_mult == 1))i
             {t               /*:                 Convert to 32 bit continuous-tone X image.               */3               for (y=0; y < (int) image->rows; y++)a               { <                 p=GetPixelCache(image,0,y,image->columns,1);.                 if (p == (PixelPacket *) NULL)                   break;8                 for (x=0; x < (int) image->columns; x++)                 {                    *q++=0;f8                   *q++=DownScale(gamma_map[p->red].red);<                   *q++=DownScale(gamma_map[p->green].green);:                   *q++=DownScale(gamma_map[p->blue].blue);                   p++;                 }m               }>
             }i           elseO             if ((ximage->bits_per_pixel == 32) && (map_info->red_max == 255) && N                 (map_info->green_max == 255) && (map_info->blue_max == 255) &&M                 (map_info->red_mult == 1) && (map_info->green_mult == 256) &&m/                 (map_info->blue_mult == 65536))n               {)                 /*<                   Convert to 32 bit continuous-tone X image.                 */5                 for (y=0; y < (int) image->rows; y++)                  {%>                   p=GetPixelCache(image,0,y,image->columns,1);0                   if (p == (PixelPacket *) NULL)                     break;:                   for (x=0; x < (int) image->columns; x++)                   {                      *q++=0; <                     *q++=DownScale(gamma_map[p->blue].blue);>                     *q++=DownScale(gamma_map[p->green].green);:                     *q++=DownScale(gamma_map[p->red].red);                     p++;                   }                  }                }              else               {                  register int                   k;  %                 register unsigned int%"                   bytes_per_pixel;                   unsigned char 1                   channel[sizeof(unsigned long)];o                   /*@                   Convert to multi-byte continuous-tone X image.                 */<                 bytes_per_pixel=ximage->bits_per_pixel >> 3;5                 for (y=0; y < (int) image->rows; y++)o                 {u>                   p=GetPixelCache(image,0,y,image->columns,1);0                   if (p == (PixelPacket *) NULL)                     break;:                   for (x=0; x < (int) image->columns; x++)                   {eI                     pixel=XGammaPixel(map_info,gamma_map,p,QuantumDepth);%:                     for (k=bytes_per_pixel-1; k >= 0; k--)                     { 7                       channel[k]=(unsigned char) pixel;                         pixel>>=8;                     } =                     for (k=0; k < (int) bytes_per_pixel; k++) &                       *q++=channel[k];                     p++;                   } "                   q+=scanline_pad;                 }                }            break;	         }        } %   if (matte_image != (XImage *) NULL)      {        /*         Initialize matte image.        *//       scanline_pad=matte_image->bytes_per_line- @         ((matte_image->width*matte_image->bits_per_pixel) >> 3);,       q=(unsigned char *) matte_image->data;+       for (y=0; y < (int) image->rows; y++)e       {t4         p=GetPixelCache(image,0,y,image->columns,1);&         if (p == (PixelPacket *) NULL)           break;         bit=0;         byte=0; 0         for (x=0; x < (int) image->columns; x++)	         {o           byte<<=1; (           if (p->opacity == Transparent)             byte|=0x01;s           bit++;           if (bit == 8) 
             {p               *q++=byte;               bit=0;               byte=0;.
             }s           p++;	         }e         if (bit != 0)s           *q=byte << (8-bit);m         q+=scanline_pad;       }f     }a }y i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %eO %                                                                             % O %                                                                             %.O %   X M a k e M a g n i f y I m a g e                                         %uO %                                                                             % O %                                                                             %xO %                                                                             %/O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %gM %  Method XMakeMagnifyImage magnifies a region of an X image and displays it.# %f1 %  The format of the XMakeMagnifyImage method is:  % ) %      XMakeMagnifyImage(display,windows)  %g+ %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned fromk %      XOpenDisplay. %i< %    o windows: Specifies a pointer to a XWindows structure. %s %t */A Export void XMakeMagnifyImage(Display *display,XWindows *windows)C {r0 #define Swap(x,y) ((x)^=(y), (y)^=(x), (x)^=(y))     register int     x,     y;     register unsigned char     *p,l     *q;      register unsigned int)     j,     k,     l;  
   static char      text[MaxTextExtent];     static unsigned intt     previous_magnify = 0;-     static XWindowInfo     magnify_window;i     unsigned int     height,)     i,     magnify,     scanline_pad, 
     width;     XColor
     color;     XImage     *ximage;     /*     Check boundary conditions.   */&   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL);    magnify=1;+   for (i=1; i < windows->magnify.data; i++)o     magnify<<=1;I   while ((magnify*windows->image.ximage->width) < windows->magnify.width),     magnify<<=1;K   while ((magnify*windows->image.ximage->height) < windows->magnify.height)e     magnify<<=1;*   while (magnify > windows->magnify.width)     magnify>>=1;+   while (magnify > windows->magnify.height)k     magnify>>=1;"   if (magnify != previous_magnify)     {        unsigned int         status;          XTextProperty,         window_name;         /*8         New magnify factor:  update magnify window name.       */
       i=0;'       while ((1 << i) <= (int) magnify)l         i++;:       FormatString(windows->magnify.name,"Magnify %uX",i);N       status=XStringListToTextProperty(&windows->magnify.name,1,&window_name);       if (status != 0)	         { ?           XSetWMName(display,windows->magnify.id,&window_name); C           XSetWMIconName(display,windows->magnify.id,&window_name);e,           XFree((void *) window_name.value);	         }6     }i   previous_magnify=magnify;o   ximage=windows->image.ximage; '   width=windows->magnify.ximage->width;s)   height=windows->magnify.ximage->height;>!   if ((windows->magnify.x < 0) ||r;       (windows->magnify.x >= windows->image.ximage->width))o9     windows->magnify.x=windows->image.ximage->width >> 1;W.   x=windows->magnify.x-((width/magnify) >> 1);   if (x < 0)     x=0;   else2     if (x > (int) (ximage->width-(width/magnify)))$       x=ximage->width-width/magnify;!   if ((windows->magnify.y < 0) ||e<       (windows->magnify.y >= windows->image.ximage->height)):     windows->magnify.y=windows->image.ximage->height >> 1;/   y=windows->magnify.y-((height/magnify) >> 1);    if (y < 0)     y=0;   else4     if (y > (int) (ximage->height-(height/magnify)))&       y=ximage->height-height/magnify;4   q=(unsigned char *) windows->magnify.ximage->data;7   scanline_pad=windows->magnify.ximage->bytes_per_line-W;     ((width*windows->magnify.ximage->bits_per_pixel) >> 3);i!   if (ximage->bits_per_pixel < 8)t     {r       register unsigned char         background,t
         byte,          foreground,l         p_bit,         q_bit;         register unsigned inti         plane;         XPixelInfo         *pixel_info;  -       pixel_info=windows->magnify.pixel_info;l'       switch (ximage->bitmap_bit_order)3       {B         case LSBFirst:	         {(           /*)             Magnify little-endian bitmap.M           */           background=0x00;           foreground=0x80;)           if (ximage->format == XYBitmap)p
             {oC               background=(Intensity(pixel_info->foreground_color) <RG                 Intensity(pixel_info->background_color) ? 0x80 : 0x00);-C               foreground=(Intensity(pixel_info->background_color) <nG                 Intensity(pixel_info->foreground_color) ? 0x80 : 0x00);=-               if (windows->magnify.depth > 1)h,                 Swap(background,foreground);
             }d+           for (i=0; i < height; i+=magnify)o           {B             /*+               Propogate pixel magnify rows.>             */'             for (j=0; j < magnify; j++)o
             { H               p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+2                 ((x*ximage->bits_per_pixel) >> 3);6               p_bit=(x*ximage->bits_per_pixel) & 0x07;               q_bit=0;               byte=0;).               for (k=0; k < width; k+=magnify)               {x                 /*2                   Propogate pixel magnify columns.                 */+                 for (l=0; l < magnify; l++)a                 {p                   /*-                     Propogate each bit plane.                    */N                   for (plane=0; (int) plane < ximage->bits_per_pixel; plane++)                   {i                     byte>>=1;o5                     if (*p & (0x01 << (p_bit+plane))).'                       byte|=foreground;_                     else'                       byte|=background;u                     q_bit++;#                     if (q_bit == 8))                       {."                         *q++=byte;                          q_bit=0;                         byte=0;e                       }e                   }                  }m.                 p_bit+=ximage->bits_per_pixel;                 if (p_bit == 8)i                   {_                     p++;                     p_bit=0;                   }r                 if (q_bit != 0)i'                   *q=byte >> (8-q_bit);a                  q+=scanline_pad;               }r
             }o             y++;           }            break;	         }          case MSBFirst:         default:	         {)           /*&             Magnify big-endian bitmap.           */           background=0x00;           foreground=0x01;)           if (ximage->format == XYBitmap)-
             { C               background=(Intensity(pixel_info->foreground_color) <hG                 Intensity(pixel_info->background_color) ? 0x01 : 0x00);pC               foreground=(Intensity(pixel_info->background_color) <RG                 Intensity(pixel_info->foreground_color) ? 0x01 : 0x00);a-               if (windows->magnify.depth > 1)o,                 Swap(background,foreground);
             }e+           for (i=0; i < height; i+=magnify)            {e             /*+               Propogate pixel magnify rows.a             */'             for (j=0; j < magnify; j++)m
             {iH               p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+2                 ((x*ximage->bits_per_pixel) >> 3);6               p_bit=(x*ximage->bits_per_pixel) & 0x07;               q_bit=0;               byte=0;_.               for (k=0; k < width; k+=magnify)               {                  /*2                   Propogate pixel magnify columns.                 */+                 for (l=0; l < magnify; l++)                  {                    /*-                     Propogate each bit plane.                    */N                   for (plane=0; (int) plane < ximage->bits_per_pixel; plane++)                   {_                     byte<<=1;a5                     if (*p & (0x80 >> (p_bit+plane)))e'                       byte|=foreground;a                     else'                       byte|=background;=                     q_bit++;#                     if (q_bit == 8)s                       { "                         *q++=byte;                          q_bit=0;                         byte=0;o                       }                    }i                 }a.                 p_bit+=ximage->bits_per_pixel;                 if (p_bit == 8)                    {u                     p++;                     p_bit=0;                   }                  if (q_bit != 0) '                   *q=byte << (8-q_bit);                   q+=scanline_pad;               } 
             }l             y++;           }o           break;	         }        }a     }-   else#     switch (ximage->bits_per_pixel)m     {l
       case 6: 
       case 8:p       { 
         /*            Magnify 8 bit X image.
         */)         for (i=0; i < height; i+=magnify) 	         {e           /*)             Propogate pixel magnify rows.p           */%           for (j=0; j < magnify; j++)M           { F             p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+0               ((x*ximage->bits_per_pixel) >> 3);,             for (k=0; k < width; k+=magnify)
             {                /*0                 Propogate pixel magnify columns.               */)               for (l=0; l < magnify; l++)                  *q++=(*p);               p++;
             }              q+=scanline_pad;           }            y++;	         }          break;       }        default:       {          register unsigned int            bytes_per_pixel,           m;  
         /*%           Magnify multi-byte X image. 
         */4         bytes_per_pixel=ximage->bits_per_pixel >> 3;)         for (i=0; i < height; i+=magnify)%	         {%           /*)             Propogate pixel magnify rows.e           */%           for (j=0; j < magnify; j++)r           {hF             p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+0               ((x*ximage->bits_per_pixel) >> 3);,             for (k=0; k < width; k+=magnify)
             {u               /*0                 Propogate pixel magnify columns.               */)               for (l=0; l < magnify; l++)n3                 for (m=0; m < bytes_per_pixel; m++)d                    *q++=(*(p+m));!               p+=bytes_per_pixel; 
             }s             q+=scanline_pad;           }v           y++;	         }          break;       }i     }r   /*#     Copy X image to magnify pixmap.m   */.   x=windows->magnify.x-((width/magnify) >> 1);   if (x < 0).     x=(width >> 1)-windows->magnify.x*magnify;   else2     if (x > (int) (ximage->width-(width/magnify)))@       x=(ximage->width-windows->magnify.x)*magnify-(width >> 1);     else
       x=0;/   y=windows->magnify.y-((height/magnify) >> 1);s   if (y < 0)/     y=(height >> 1)-windows->magnify.y*magnify;    else4     if (y > (int) (ximage->height-(height/magnify)))B       y=(ximage->height-windows->magnify.y)*magnify-(height >> 1);     else
       y=0;   if ((x != 0) || (y != 0))a3     XFillRectangle(display,windows->magnify.pixmap,a:       windows->magnify.annotate_context,0,0,width,height);N   XPutImage(display,windows->magnify.pixmap,windows->magnify.annotate_context,6     windows->magnify.ximage,0,0,x,y,width-x,height-y);4   if ((magnify > 1) && ((magnify <= (width >> 1)) &&"       (magnify <= (height >> 1))))     {        RectangleInfoe         highlight_info;/         /*         Highlight center pixel..       */3       highlight_info.x=windows->magnify.width >> 1;f4       highlight_info.y=windows->magnify.height >> 1;#       highlight_info.width=magnify;a$       highlight_info.height=magnify;5       XDrawRectangle(display,windows->magnify.pixmap, M         windows->magnify.highlight_context,highlight_info.x,highlight_info.y,u8         highlight_info.width-1,highlight_info.height-1);       if (magnify > 2)7         XDrawRectangle(display,windows->magnify.pixmap,k?           windows->magnify.annotate_context,highlight_info.x+1, M           highlight_info.y+1,highlight_info.width-3,highlight_info.height-3);o     }K   /*     Show center pixel color.   */   color.pixel=K     XGetPixel(windows->image.ximage,windows->magnify.x,windows->magnify.y);R:   XQueryColor(display,windows->map_info->colormap,&color);"   if (windows->magnify.depth > 12)0     FormatString(text," %+d%+d  (%3u,%3u,%3u) ",B       windows->magnify.x,windows->magnify.y,XDownScale(color.red),6       XDownScale(color.green),XDownScale(color.blue));   else4     FormatString(text," %+d%+d  (%3u,%3u,%3u) %lu ",B       windows->magnify.x,windows->magnify.y,XDownScale(color.red),B       XDownScale(color.green),XDownScale(color.blue),color.pixel);P   height=windows->magnify.font_info->ascent+windows->magnify.font_info->descent;6   x=windows->magnify.font_info->max_bounds.width >> 1;5   y=windows->magnify.font_info->ascent+(height >> 2); 3   XDrawImageString(display,windows->magnify.pixmap, =     windows->magnify.annotate_context,x,y,text,Extent(text)); H   FormatString(text," #%04x%04x%04x ",color.red,color.green,color.blue);   y+=height;3   XDrawImageString(display,windows->magnify.pixmap,%=     windows->magnify.annotate_context,x,y,text,Extent(text));a   /*     Refresh magnify window.    */"   magnify_window=windows->magnify;   magnify_window.x=0;X   magnify_window.y=0;D:   XRefreshWindow(display,&magnify_window,(XEvent *) NULL); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %lO %                                                                             % O %                                                                             % O %   X M a k e P i x m a p                                                     %sO %                                                                             %eO %                                                                             % O %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %a, %  Method XMakePixmap creates an X11 pixmap. %a+ %  The format of the XMakePixmap method is:( %pL %      void XMakeStandardColormap(Display *display,XVisualInfo *visual_info,O %        XResourceInfo *resource_info,Image *image,XStandardColormap *map_info,  %        XPixelInfo *pixel)  % + %  A description of each parameter follows:l %tA %    o status: Method XMakePixmap returns True if the X pixmap is*N %      successfully created.  False is returned is there is a memory shortage. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %lD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %l> %    o window: Specifies a pointer to a XWindowInfo structure. %o %s */M unsigned int XMakePixmap(Display *display,const XResourceInfo *resource_info,c   XWindowInfo *window) {e   unsigned int     height,c
     width;  &   assert(display != (Display *) NULL);2   assert(resource_info != (XResourceInfo *) NULL);*   assert(window != (XWindowInfo  *) NULL);&   if (window->pixmap != (Pixmap) NULL)     {e       /*"         Destroy previous X pixmap.       */*       XFreePixmap(display,window->pixmap);#       window->pixmap=(Pixmap) NULL;s     }/   if (!window->use_pixmap)     return(False);(   if (window->ximage == (XImage *) NULL)     return(False);   /*     Display busy cursor.   */8   XDefineCursor(display,window->id,window->busy_cursor);   XFlush(display);   /*     Create pixmap.   */   width=window->ximage->width;    height=window->ximage->height;N   window->pixmap=XCreatePixmap(display,window->id,width,height,window->depth);&   if (window->pixmap == (Pixmap) NULL)     {        /*"         Unable to allocate pixmap.       */7       XDefineCursor(display,window->id,window->cursor);        return(False);     }    /*     Copy X image to pixmap.    */ #if defined(HasSharedMemory)   if (window->shared_memory)P     XShmPutImage(display,window->pixmap,window->annotate_context,window->ximage,!       0,0,0,0,width,height,True);  #endif   if (!window->shared_memory) M     XPutImage(display,window->pixmap,window->annotate_context,window->ximage,%       0,0,0,0,width,height);   if (resource_info->debug)t     {u)       (void) fprintf(stderr,"Pixmap:\n");eE       (void) fprintf(stderr,"  width, height: %ux%u\n",width,height);aH       (void) fprintf(stderr,"  timestamp: %ld\n",time((time_t *) NULL));     }d   /*     Restore cursor.r   */3   XDefineCursor(display,window->id,window->cursor);a   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             %_O %                                                                             %vO %                                                                             %sO %   X M a k e S t a n d a r d C o l o r m a p                                 %nO %                                                                             %iO %                                                                             %gO %                                                                             %*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %eA %  Method XMakeStandardColormap creates an X11 Standard Colormap.s %t5 %  The format of the XMakeStandardColormap method is:- %cE %      XMakeStandardColormap(display,visual_info,resource_info,image,e %        map_info,pixel) %t+ %  A description of each parameter follows:  %oD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %oG %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure;h$ %      returned from XGetVisualInfo. %tK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure., %lF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.a %,L %    o map_info: If a Standard Colormap type is specified, this structure is8 %      initialized with info from the Standard Colormap. %-< %    o pixel: Specifies a pointer to a XPixelInfo structure. %f %d */  8 static int IntensityCompare(const void *x,const void *y) {t   DiversityPacket)
     *color_1,v
     *color_2;t      color_1=(DiversityPacket *) x;    color_2=(DiversityPacket *) y;>   return((int) Intensity(*color_2)-(int) Intensity(*color_1)); }X  9 static int PopularityCompare(const void *x,const void *y)  {    DiversityPacketi
     *color_1,r
     *color_2;       color_1=(DiversityPacket *) x;    color_2=(DiversityPacket *) y;4   return((int) color_2->count-(int) color_1->count); }   L Export void XMakeStandardColormap(Display *display,XVisualInfo *visual_info,H   XResourceInfo *resource_info,Image *image,XStandardColormap *map_info,   XPixelInfo *pixel) {e
   Colormap
     colormap;,     int      status;l     register int     i;     register PixelPacket     *q;i     register XColoro     *gamma_map;y     unsigned int     number_colors,     retain_colors;     unsigned short     gray_value;n     XColor
     color,     *colors,     *p;-  &   assert(display != (Display *) NULL);.   assert(visual_info != (XVisualInfo *) NULL);1   assert(map_info != (XStandardColormap *) NULL);a2   assert(resource_info != (XResourceInfo *) NULL);'   assert(pixel != (XPixelInfo *) NULL);a/   if (resource_info->map_type != (char *) NULL)r     {-       /*=         Standard Colormap is already defined (i.e. xstdcmap).;       */G       XGetPixelPacket(display,visual_info,map_info,resource_info,image,"         pixel);o9       number_colors=(unsigned int) (map_info->base_pixel+iN         (map_info->red_max+1)*(map_info->green_max+1)*(map_info->blue_max+1));J       if ((map_info->red_max*map_info->green_max*map_info->blue_max) != 0)>         if (!image->matte && !resource_info->color_recovery &&3             resource_info->quantize_info->dither &&r4             ((int) number_colors < MaxColormapSize))           {n             Imaget               *map_image;n               /*<               Improve image appearance with error diffusion.             */8             map_image=AllocateImage((ImageInfo *) NULL);,             if (map_image == (Image *) NULL)F               MagickError(ResourceLimitError,"Unable to dither image",,                 "Memory allocation failed");-             map_image->columns=number_colors;d             map_image->rows=1;             /*(               Initialize colormap image.             */@             q=SetPixelCache(map_image,0,0,map_image->columns,1);*             if (q != (PixelPacket *) NULL)               {u7                 for (i=0; i < (int) number_colors; i++)o                 {(                   q->red=0;r-                   if (map_info->red_max != 0)g$                     q->red=(Quantum)J                       (((i/map_info->red_mult)*MaxRGB)/map_info->red_max);                   q->green=0;(/                   if (map_info->green_max != 0)-D                     q->green=(Quantum) ((((i/map_info->green_mult) %L                       (map_info->green_max+1))*MaxRGB)/map_info->green_max);                   q->blue=0;.                   if (map_info->blue_max != 0)%                     q->blue=(Quantum) O                       (((i % map_info->green_mult)*MaxRGB)/map_info->blue_max);c)                   q->opacity=Transparent;E                   q++;                 }t1                 (void) SyncPixelCache(map_image);y6                 (void) MapImage(image,map_image,True);               } M             XGetPixelPacket(display,visual_info,map_info,resource_info,image,e               pixel);o%             image->class=DirectClass; $             DestroyImage(map_image);           }        if (resource_info->debug)a	         {f8           (void) fprintf(stderr,"Standard Colormap:\n");M           (void) fprintf(stderr,"  colormap id: 0x%lx\n",map_info->colormap);eH           (void) fprintf(stderr,"  red, green, blue max: %lu %lu %lu\n",F             map_info->red_max,map_info->green_max,map_info->blue_max);I           (void) fprintf(stderr,"  red, green, blue mult: %lu %lu %lu\n",rI             map_info->red_mult,map_info->green_mult,map_info->blue_mult);rL           (void) fprintf(stderr,"  timestamp: %ld\n",time((time_t *) NULL));	         }e
       return;b     } O   if ((visual_info->class != DirectColor) && (visual_info->class != TrueColor))i(     if ((image->class == DirectClass) ||;         ((int) image->colors > visual_info->colormap_size))y       {          QuantizeInfo           quantize_info;  
         /*9           Image has more colors than the visual supports.a
         */6         quantize_info=(*resource_info->quantize_info);?         quantize_info.number_colors=visual_info->colormap_size;o3         (void) QuantizeImage(&quantize_info,image);n       }a   /**     Free previous and create new colormap.   */<   XFreeStandardColormap(display,visual_info,map_info,pixel);9   colormap=XDefaultColormap(display,visual_info->screen);aI   if (visual_info->visual != XDefaultVisual(display,visual_info->screen))tN     colormap=XCreateColormap(display,XRootWindow(display,visual_info->screen),=       visual_info->visual,visual_info->class == DirectColor ?)       AllocAll : AllocNone);"   if (colormap == (Colormap) NULL)H     MagickError(XServerError,"Unable to create colormap",(char *) NULL);   /*1     Initialize the map and pixel info structures.o   */-   XGetMapInfo(visual_info,colormap,map_info);aJ   XGetPixelPacket(display,visual_info,map_info,resource_info,image,pixel);   gamma_map=pixel->gamma_map;n   /*B     Allocating colors in server colormap is based on visual class.   */   switch (visual_info->class)w   {)     case StaticGray:     case StaticColor:t     {e       /*F         Define Standard Colormap for StaticGray or StaticColor visual.       */"       number_colors=image->colors;       colors=(XColor *)eB         AllocateMemory(visual_info->colormap_size*sizeof(XColor));$       if (colors == (XColor *) NULL)=         MagickError(XServerError,"Unable to create colormap",1&           "Memory allocation failed");       p=colors;e+       color.flags=DoRed | DoGreen | DoBlue;s,       if (visual_info->class == StaticColor)/         for (i=0; i < (int) image->colors; i++)t	         {tD           color.red=XUpScale(gamma_map[image->colormap[i].red].red);J           color.green=XUpScale(gamma_map[image->colormap[i].green].green);G           color.blue=XUpScale(gamma_map[image->colormap[i].blue].blue);16           status=XAllocColor(display,colormap,&color);           if (status == 0)
             {s>               colormap=XCopyColormapAndFree(display,colormap);3               XAllocColor(display,colormap,&color);s
             }t'           pixel->pixels[i]=color.pixel;i           *p++=color;r	         }u
       else/         for (i=0; i < (int) image->colors; i++),	         {rI           gray_value=Intensity(gamma_map[Intensity(image->colormap[i])]); )           color.red=XUpScale(gray_value);r+           color.green=XUpScale(gray_value);)*           color.blue=XUpScale(gray_value);6           status=XAllocColor(display,colormap,&color);           if (status == 0)
             {d>               colormap=XCopyColormapAndFree(display,colormap);3               XAllocColor(display,colormap,&color);e
             }c'           pixel->pixels[i]=color.pixel;)           *p++=color;f	         }g       break;     }      case GrayScale:%     case PseudoColor:%     {%       unsigned int         colormap_type;         /*E         Define Standard Colormap for GrayScale or PseudoColor visual.        */"       number_colors=image->colors;       colors=(XColor *) B         AllocateMemory(visual_info->colormap_size*sizeof(XColor));$       if (colors == (XColor *) NULL)C         MagickError(ResourceLimitError,"Unable to create colormap", &           "Memory allocation failed");       /*#         Preallocate our GUI colors.        */D       (void) XAllocColor(display,colormap,&pixel->foreground_color);D       (void) XAllocColor(display,colormap,&pixel->background_color);@       (void) XAllocColor(display,colormap,&pixel->border_color);?       (void) XAllocColor(display,colormap,&pixel->matte_color);rC       (void) XAllocColor(display,colormap,&pixel->highlight_color);t@       (void) XAllocColor(display,colormap,&pixel->shadow_color);?       (void) XAllocColor(display,colormap,&pixel->depth_color); @       (void) XAllocColor(display,colormap,&pixel->trough_color);'       for (i=0; i < MaxNumberPens; i++)yC         (void) XAllocColor(display,colormap,&pixel->pen_colors[i]);m       /*D         Determine if image colors will "fit" into X server colormap.       */,       colormap_type=resource_info->colormap;N       status=XAllocColorCells(display,colormap,False,(unsigned long *) NULL,0,%         pixel->pixels,image->colors);e       if (status != 0)&         colormap_type=PrivateColormap;*       if (colormap_type == SharedColormap)	         {            DiversityPacket              *diversity;   
           intc             y;             register int             x;             unsigned short             index;             XColor             *server_colors;e             /*P             Define Standard colormap for shared GrayScale or PseudoColor visual.           */'           diversity=(DiversityPacket *)rB             AllocateMemory(image->colors*sizeof(DiversityPacket));4           if (diversity == (DiversityPacket *) NULL)G             MagickError(ResourceLimitError,"Unable to create colormap", *               "Memory allocation failed");1           for (i=0; i < (int) image->colors; i++)            {i4             diversity[i].red=image->colormap[i].red;8             diversity[i].green=image->colormap[i].green;6             diversity[i].blue=image->colormap[i].blue;2             diversity[i].index=(unsigned short) i;!             diversity[i].count=0;            }%/           for (y=0; y < (int) image->rows; y++)%           {%;             if (!GetPixelCache(image,0,y,image->columns,1))                break;4             for (x=0; x < (int) image->columns; x++)3               diversity[image->indexes[x]].count++;            }            /*0             Sort colors by decreasing intensity.           */I           qsort((void *) diversity,image->colors,sizeof(DiversityPacket), D             (int (*)(const void *, const void *)) IntensityCompare);J           for (i=0; i < (int) image->colors; i+=Max(image->colors >> 4,2))J             diversity[i].count<<=4;  /* increase this colors popularity *//           diversity[image->colors-1].count<<=4;%I           qsort((void *) diversity,image->colors,sizeof(DiversityPacket),uE             (int (*)(const void *, const void *)) PopularityCompare);T           /*             Allocate colors.           */           p=colors;i/           color.flags=DoRed | DoGreen | DoBlue;h0           if (visual_info->class == PseudoColor)3             for (i=0; i < (int) image->colors; i++) 
             {p'               index=diversity[i].index; L               color.red=XUpScale(gamma_map[image->colormap[index].red].red);               color.green=H                 XUpScale(gamma_map[image->colormap[index].green].green);O               color.blue=XUpScale(gamma_map[image->colormap[index].blue].blue); :               status=XAllocColor(display,colormap,&color);               if (status == 0)                 break;/               pixel->pixels[index]=color.pixel;i               *p++=color;,
             }e           else3             for (i=0; i < (int) image->colors; i++)y
             {D'               index=diversity[i].index;a               gray_value=eH                 Intensity(gamma_map[Intensity(image->colormap[index])]);-               color.red=XUpScale(gray_value);M/               color.green=XUpScale(gray_value);p.               color.blue=XUpScale(gray_value);:               status=XAllocColor(display,colormap,&color);               if (status == 0)                 break;/               pixel->pixels[index]=color.pixel;                *p++=color; 
             }            /*#             Read X server colormap.            */"           server_colors=(XColor *)F             AllocateMemory(visual_info->colormap_size*sizeof(XColor));/           if (server_colors == (XColor *) NULL) G             MagickError(ResourceLimitError,"Unable to create colormap", *               "Memory allocation failed");8           for (x=0; x < visual_info->colormap_size; x++)5             server_colors[x].pixel=(unsigned long) x; 6           XQueryColors(display,colormap,server_colors,7             (int) Min(visual_info->colormap_size,256));%           /*;             Select remaining colors from X server colormap.o           */0           if (visual_info->class == PseudoColor)0             for (; i < (int) image->colors; i++)
             { '               index=diversity[i].index;dL               color.red=XUpScale(gamma_map[image->colormap[index].red].red);               color.green=H                 XUpScale(gamma_map[image->colormap[index].green].green);O               color.blue=XUpScale(gamma_map[image->colormap[index].blue].blue);nF               XBestPixel(display,colormap,server_colors,(unsigned int)3                 visual_info->colormap_size,&color);o/               pixel->pixels[index]=color.pixel;o               *p++=color;r
             }o           else0             for (; i < (int) image->colors; i++)
             {G'               index=diversity[i].index;w               gray_value=wH                 Intensity(gamma_map[Intensity(image->colormap[index])]);-               color.red=XUpScale(gray_value);D/               color.green=XUpScale(gray_value);p.               color.blue=XUpScale(gray_value);F               XBestPixel(display,colormap,server_colors,(unsigned int)3                 visual_info->colormap_size,&color);d/               pixel->pixels[index]=color.pixel;,               *p++=color; 
             }!?           if ((int) image->colors < visual_info->colormap_size) 
             {                /*C                 Fill up colors array-- more choices for pen colors.                */N               retain_colors=Min(visual_info->colormap_size-image->colors,256);5               for (i=0; i < (int) retain_colors; i++)%&                 *p++=server_colors[i];+               number_colors+=retain_colors; 
             } $           FreeMemory(server_colors);            FreeMemory(diversity);           break;	         }        /*M         Define Standard colormap for private GrayScale or PseudoColor visual.        */       if (status == 0)	         {            /*P             Not enough colormap entries in the colormap-- Create a new colormap.           */+           colormap=XCreateColormap(display, I             XRootWindow(display,visual_info->screen),visual_info->visual,              AllocNone); *           if (colormap == (Colormap) NULL)A             MagickError(XServerError,"Unable to create colormap",o               (char *) NULL);o&           map_info->colormap=colormap;?           if ((int) image->colors < visual_info->colormap_size)t
             {                /*K                 Retain colors from the default colormap to help lessens ther-                 effects of colormap flashing.t               */N               retain_colors=Min(visual_info->colormap_size-image->colors,256);%               p=colors+image->colors;y5               for (i=0; i < (int) retain_colors; i++)                {p+                 p->pixel=(unsigned long) i;o                 p++;               } #               XQueryColors(display,i>                 XDefaultColormap(display,visual_info->screen),:                 colors+image->colors,(int) retain_colors);               /*A                 Transfer colors from default to private colormap.                */O               XAllocColorCells(display,colormap,False,(unsigned long *) NULL,0,;-                 pixel->pixels,retain_colors);e%               p=colors+image->colors; 5               for (i=0; i < (int) retain_colors; i++)l               { *                 p->pixel=pixel->pixels[i];                 p++;               }oP               XStoreColors(display,colormap,colors+image->colors,retain_colors);+               number_colors+=retain_colors;r
             } K           XAllocColorCells(display,colormap,False,(unsigned long *) NULL,0, )             pixel->pixels,image->colors);,	         }o       /*!         Store the image colormap.(       */       p=colors; +       color.flags=DoRed | DoGreen | DoBlue;a,       if (visual_info->class == PseudoColor)/         for (i=0; i < (int) image->colors; i++)n	         {aD           color.red=XUpScale(gamma_map[image->colormap[i].red].red);J           color.green=XUpScale(gamma_map[image->colormap[i].green].green);G           color.blue=XUpScale(gamma_map[image->colormap[i].blue].blue); '           color.pixel=pixel->pixels[i];,           *p++=color;.	         }p
       else/         for (i=0; i < (int) image->colors; i++)d	         {AI           gray_value=Intensity(gamma_map[Intensity(image->colormap[i])]); )           color.red=XUpScale(gray_value);r+           color.green=XUpScale(gray_value);r*           color.blue=XUpScale(gray_value);'           color.pixel=pixel->pixels[i];o           *p++=color;0	         }o:       XStoreColors(display,colormap,colors,image->colors);       break;     }a     case TrueColor:L     case DirectColor:      default:     {T       unsigned int         linear_colormap;         /*E         Define Standard Colormap for TrueColor or DirectColor visual.*       */K       number_colors=(unsigned int) ((map_info->red_max*map_info->red_mult)+,3         (map_info->green_max*map_info->green_mult)+ 4         (map_info->blue_max*map_info->blue_mult)+1);/       linear_colormap=(number_colors > 4096) || G         (((int) (map_info->red_max+1) == visual_info->colormap_size) && I          ((int) (map_info->green_max+1) == visual_info->colormap_size) &&uG          ((int) (map_info->blue_max+1) == visual_info->colormap_size));r       if (linear_colormap)1         number_colors=visual_info->colormap_size;f       /*         Allocate color array.        */E       colors=(XColor *) AllocateMemory(number_colors*sizeof(XColor));%$       if (colors == (XColor *) NULL)C         MagickError(ResourceLimitError,"Unable to create colormap", &           "Memory allocation failed");       /*%         Initialize linear color ramp.        */       p=colors; +       color.flags=DoRed | DoGreen | DoBlue;        if (linear_colormap)/         for (i=0; i < (int) number_colors; i++) 	         { (           color.blue=(unsigned short) 0;&           if (map_info->blue_max != 0)'             color.blue=((unsigned long) H               (((i % map_info->green_mult)*65535L)/map_info->blue_max));!           color.green=color.blue;%           color.red=color.blue;%8           color.pixel=XStandardPixel(map_info,color,16);           *p++=color;a	         } 
       else/         for (i=0; i < (int) number_colors; i++)l	         { '           color.red=(unsigned short) 0;e%           if (map_info->red_max != 0)a&             color.red=((unsigned long)C               (((i/map_info->red_mult)*65535L)/map_info->red_max)); '           color.green=(unsigned int) 0; '           if (map_info->green_max != 0) F             color.green=((unsigned long) ((((i/map_info->green_mult) %E               (map_info->green_max+1))*65535L)/map_info->green_max));s(           color.blue=(unsigned short) 0;&           if (map_info->blue_max != 0)'             color.blue=((unsigned long)cH               (((i % map_info->green_mult)*65535L)/map_info->blue_max));8           color.pixel=XStandardPixel(map_info,color,16);           *p++=color;u	         } 0       if ((visual_info->class == DirectColor) &&F           (colormap != XDefaultColormap(display,visual_info->screen)))<         XStoreColors(display,colormap,colors,number_colors);
       else/         for (i=0; i < (int) number_colors; i++)g3           XAllocColor(display,colormap,&colors[i]);.       break;     }z   }rO   if ((visual_info->class != DirectColor) && (visual_info->class != TrueColor))t     {        /*8         Set foreground, background, border, etc. pixels.       */7       XBestPixel(display,colormap,colors,number_colors,o"         &pixel->foreground_color);7       XBestPixel(display,colormap,colors,number_colors, "         &pixel->background_color);*       if (pixel->background_color.pixel ==(           pixel->foreground_color.pixel)	         {            /*9             Foreground and background colors must differ.o           */E           pixel->background_color.red=(~pixel->foreground_color.red);a(           pixel->background_color.green=-             (~pixel->foreground_color.green); '           pixel->background_color.blue= ,             (~pixel->foreground_color.blue);;           XBestPixel(display,colormap,colors,number_colors,t&             &pixel->background_color);	         } 7       XBestPixel(display,colormap,colors,number_colors,d         &pixel->border_color);7       XBestPixel(display,colormap,colors,number_colors,t         &pixel->matte_color); 7       XBestPixel(display,colormap,colors,number_colors,n!         &pixel->highlight_color); 7       XBestPixel(display,colormap,colors,number_colors,i         &pixel->shadow_color);7       XBestPixel(display,colormap,colors,number_colors,L         &pixel->depth_color);e7       XBestPixel(display,colormap,colors,number_colors,F         &pixel->trough_color);'       for (i=0; i < MaxNumberPens; i++)        { 9         XBestPixel(display,colormap,colors,number_colors, !           &pixel->pen_colors[i]);pB         pixel->pixels[image->colors+i]=pixel->pen_colors[i].pixel;       }i0       pixel->colors=image->colors+MaxNumberPens;     }.   FreeMemory(colors);f   if (resource_info->debug)i     {d4       (void) fprintf(stderr,"Standard Colormap:\n");I       (void) fprintf(stderr,"  colormap id: 0x%lx\n",map_info->colormap);mD       (void) fprintf(stderr,"  red, green, blue max: %lu %lu %lu\n",B         map_info->red_max,map_info->green_max,map_info->blue_max);E       (void) fprintf(stderr,"  red, green, blue mult: %lu %lu %lu\n",dE         map_info->red_mult,map_info->green_mult,map_info->blue_mult);.H       (void) fprintf(stderr,"  timestamp: %ld\n",time((time_t *) NULL));     }  }r i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;O %                                                                             %eO %                                                                             %rO %                                                                             %,O %   X M a k e W i n d o w                                                     %hO %                                                                             %nO %                                                                             %*O %                                                                             %2O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%f %), %  Method XMakeWindow creates an X11 window. %d+ %  The format of the XMakeWindow method is:W %oL %      void XMakeWindow(Display *display,Window parent,char **argv,int argc,Q %        XClassHint *class_hint,XWMHints *manager_hints,XWindowInfo *window_info)i %        window_info)W %i+ %  A description of each parameter follows:  %oD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %[0 %    o parent: Specifies the parent window_info. %t7 %    o argv: Specifies the application's argument list.b %s/ %    o argc: Specifies the number of arguments.. % E %    o class_hint: Specifies a pointer to a X11 XClassHint structure.r %iF %    o manager_hints: Specifies a pointer to a X11 XWMHints structure. %tG %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.; %  %d */L Export void XMakeWindow(Display *display,Window parent,char **argv,int argc,J   XClassHint *class_hint,XWMHints *manager_hints,XWindowInfo *window_info) {  #define MinWindowSize  64c     Atom     atom_list[2];X     int(     gravity,     status;,     static XTextProperty     icon_name,     window_name;     XSizeHints     *size_hints;     /*     Set window info hints.   */&   assert(display != (Display *) NULL);.   assert(window_info != (XWindowInfo *) NULL);   size_hints=XAllocSizeHints();o(   if (size_hints == (XSizeHints *) NULL)=     MagickError(ResourceLimitError,"Unable to make X window", "       "Memory allocation failed");.   size_hints->flags=(long) window_info->flags;   size_hints->x=window_info->x;1   size_hints->y=window_info->y; '   size_hints->width=window_info->width;>)   size_hints->height=window_info->height;    if (window_info->immutable)      {m       /*&         Window size cannot be changed.       */.       size_hints->min_width=size_hints->width;0       size_hints->min_height=size_hints->height;.       size_hints->max_width=size_hints->width;0       size_hints->max_height=size_hints->height;"       size_hints->flags|=PMinSize;"       size_hints->flags|=PMaxSize;     }    else     {v       /*#         Window size can be changed.e       */3       size_hints->min_width=window_info->min_width; 5       size_hints->min_height=window_info->min_height; $       size_hints->flags|=PResizeInc;3       size_hints->width_inc=window_info->width_inc;l5       size_hints->height_inc=window_info->height_inc;  #if !defined(PRE_R4_ICCCM)#       size_hints->flags|=PBaseSize;b3       size_hints->base_width=size_hints->width_inc; 5       size_hints->base_height=size_hints->height_inc;g #endif     }o   gravity=NorthWestGravity; -   if (window_info->geometry != (char *) NULL)      {w
       char(         default_geometry[MaxTextExtent],          geometry[MaxTextExtent];  	       int          flags;         register charo         *p;n         /*          User specified geometry.       */>       FormatString(default_geometry,"%dx%d",size_hints->width,         size_hints->height);4       (void) strcpy(geometry,window_info->geometry);       p=geometry;b       while (Extent(p) > 0)        {r0         if (!isspace((int) (*p)) && (*p != '%'))           p++;         else           (void) strcpy(p,p+1);        }wN       flags=XWMGeometry(display,window_info->screen,geometry,default_geometry,K         window_info->border_width,size_hints,&size_hints->x,&size_hints->y,u9         &size_hints->width,&size_hints->height,&gravity);o8       if ((flags & WidthValue) && (flags & HeightValue))"         size_hints->flags|=USSize;/       if ((flags & XValue) && (flags & YValue))w	         {i(           size_hints->flags|=USPosition;'           window_info->x=size_hints->x;l'           window_info->y=size_hints->y;a	         }_     }. #if !defined(PRE_R4_ICCCM)"   size_hints->win_gravity=gravity;!   size_hints->flags|=PWinGravity;f #endif'   if (window_info->id == (Window) NULL)nO     window_info->id=XCreateWindow(display,parent,window_info->x,window_info->y,xG       window_info->width,window_info->height,window_info->border_width,nK       window_info->depth,InputOutput,window_info->visual,window_info->mask,n        &window_info->attributes);   else     {f       unsigned int
         mask;          XEvent         sans_event;          XWindowChanges         window_changes;n         /*;         Window already exists;  change relevant attributes.p       */H       XChangeWindowAttributes(display,window_info->id,window_info->mask,"         &window_info->attributes);       mask=ConfigureNotify; O       while (XCheckTypedWindowEvent(display,window_info->id,mask,&sans_event));%&       window_changes.x=window_info->x;&       window_changes.y=window_info->y;.       window_changes.width=window_info->width;0       window_changes.height=window_info->height;       mask=CWWidth | CWHeight;*       if (window_info->flags & USPosition)         mask|=CWX | CWY;L       XReconfigureWMWindow(display,window_info->id,window_info->screen,mask,         &window_changes);=     }m'   if (window_info->id == (Window) NULL) J     MagickError(XServerError,"Unable to create window",window_info->name);F   status=XStringListToTextProperty(&window_info->name,1,&window_name);   if (status == 0)>     MagickError(XServerError,"Unable to create text property",       window_info->name);eI   status=XStringListToTextProperty(&window_info->icon_name,1,&icon_name);o   if (status == 0)>     MagickError(XServerError,"Unable to create text property",       window_info->icon_name);2   if (window_info->icon_geometry != (char *) NULL)     {n	       inta         flags,         height,          width;         /*%         User specified icon geometry.        */$       size_hints->flags|=USPosition;O       flags=XWMGeometry(display,window_info->screen,window_info->icon_geometry, :         (char *) NULL,0,size_hints,&manager_hints->icon_x,8         &manager_hints->icon_y,&width,&height,&gravity);/       if ((flags & XValue) && (flags & YValue)) /         manager_hints->flags|=IconPositionHint;e     } M   XSetWMProperties(display,window_info->id,&window_name,&icon_name,argv,argc, )     size_hints,manager_hints,class_hint);    if (window_name.nitems != 0)&     XFree((void *) window_name.value);   if (icon_name.nitems != 0)$     XFree((void *) icon_name.value);=   atom_list[0]=XInternAtom(display,"WM_DELETE_WINDOW",False);.:   atom_list[1]=XInternAtom(display,"WM_TAKE_FOCUS",False);7   XSetWMProtocols(display,window_info->id,atom_list,2);d   XFree((void *) size_hints);&   if (window_info->shape)w     {n #if defined(HasShape)s	       int          error_base,b         event_base;s         /*4         Can we apply a non-rectangular shaping mask?       */P       window_info->shape&=XShapeQueryExtension(display,&error_base,&event_base); #else        window_info->shape=False;i #endif     }r!   if (window_info->shared_memory)      {i #if defined(HasSharedMemory)       /*5         Can we we use shared memory with this window?.       */>       window_info->shared_memory&=XShmQueryExtension(display); #elseg'       window_info->shared_memory=False;e #endif     }[ }. u /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%bO %                                                                             % O %                                                                             % O %                                                                             %(O %   X P r o g r e s s M o n i t o r                                           %lO %                                                                             %rO %                                                                             % O %                                                                             %.O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %;D %  Method XProgressMonitor displays the progress a task is making in %  completing a task.  % 0 %  The format of the XProgressMonitor method is: % I %      void XProgressMonitor(const char *task,const unsigned int quantum, ! %        const unsigned int span)N %)+ %  A description of each parameter follows:a %;- %    o task: Identifies the task in progress.  %tO %    o quantum: Specifies the quantum position within the span which represents(< %      how much progress has been made in completing a task. %n> %    o span: Specifies the span relative to completing a task. %m %- */I Export void XProgressMonitor(const char *task,const unsigned int quantum,    const unsigned int span) {e
   XWindows
     *windows;p  '   windows=XSetWindows((XWindows *) ~0); #   if (windows == (XWindows *) NULL):     return; =   XMonitorWidget(windows->display,windows,task,quantum,span);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             %_O %                                                                             % O %                                                                             %nO %   X Q u e r y C o l o r D a t a b a s e                                     %&O %                                                                             %fO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method XQueryColorDatabase looks up a RGB values for a color given in the %  target string.  %l3 %  The format of the XQueryColorDatabase method is:  % I %      unsigned int XQueryColorDatabase(const char *target,XColor *color)  % + %  A description of each parameter follows:p %eI %    o status:  Method XQueryColorDatabase returns True if the RGB values C %      of the target color is defined, otherwise False is returned.o %yE %    o target: Specifies the color to lookup in the X color database.  % Q %    o color: A pointer to an PixelPacket structure.  The RGB value of the target ' %      color is returned as this value.  %  %  */I Export unsigned int XQueryColorDatabase(const char *target,XColor *color)  { 
   Colormap
     colormap;      intG     status;e     static Display      *display = (Display *) NULL;     XColor     xcolor;      /*"     Initialize color return value.   */#   assert(color != (XColor *) NULL);f   color->red=0;    color->green=0;-   color->blue=0;(   color->flags=DoRed | DoGreen | DoBlue;5   if ((target == (char *) NULL) || (*target == '\0'))      target=BackgroundColor;[   /*-     Let the X server define the color for us.e   */"   if (display == (Display *) NULL)(     display=XOpenDisplay((char *) NULL);"   if (display == (Display *) NULL)     {aL       MagickWarning(XServerWarning,"Color is not known to X server",target);       return(False);     } =   colormap=XDefaultColormap(display,XDefaultScreen(display));,?   status=XParseColor(display,colormap,(char *) target,&xcolor);c   if (status == False)J     MagickWarning(XServerWarning,"Color is not known to X server",target);   else     {        color->red=xcolor.red;        color->green=xcolor.green;       color->blue=xcolor.blue;        color->flags=xcolor.flags;     }-   return(status != 0); }5 r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %pO %                                                                             %3O %                                                                             %+O %   X Q u e r y P o s i t i o n                                               % O %                                                                             % O %                                                                             %aO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %iK %  Method XQueryPosition gets the pointer coordinates relative to a window.  %(. %  The format of the XQueryPosition method is: % N %      void XQueryPosition(Display *display,const Window window,int *x,int *y) % + %  A description of each parameter follows:  %nE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %o/ %    o window: Specifies a pointer to a Window.  % N %    o x: Return the x coordinate of the pointer relative to the origin of the %      window. %nN %    o y: Return the y coordinate of the pointer relative to the origin of the %      window. %. %e */N Export void XQueryPosition(Display *display,const Window window,int *x,int *y) {    int      x_root,      y_root;e     unsigned int	     mask;      Window     root_window;  &   assert(display != (Display *) NULL);"   assert(window != (Window) NULL);   assert(x != (int *) NULL);   assert(y != (int *) NULL);P   (void) XQueryPointer(display,window,&root_window,&root_window,&x_root,&y_root,     x,y,&mask);  }p t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;O %                                                                             %oO %                                                                             %iO %                                                                             % O %   X R e f r e s h W i n d o w                                               %oO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%x %f: %  Method XRefreshWindow refreshes an image in a X window. % . %  The format of the XRefreshWindow method is: % F %      void XRefreshWindow(Display *display,const XWindowInfo *window, %        const XEvent *event)e %p+ %  A description of each parameter follows:_ %sE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %o> %    o window: Specifies a pointer to a XWindowInfo structure. %eH %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.; %  %  */F Export void XRefreshWindow(Display *display,const XWindowInfo *window,   const XEvent *event) {o   int      x,     y;     unsigned int     height,i
     width;  &   assert(display != (Display *) NULL);)   assert(window != (XWindowInfo *) NULL);e(   if (window->ximage == (XImage *) NULL)     return;%   if (event != (XEvent *) NULL)%     {%       /*-         Determine geometry from expose event.        */       x=event->xexpose.x;        y=event->xexpose.y; !       width=event->xexpose.width; #       height=event->xexpose.height;a     }    else     {        XEvent         sans_event;          /*A         Refresh entire window; discard outstanding expose events.        */
       x=0;
       y=0;       width=window->width;       height=window->height;L       while (XCheckTypedWindowEvent(display,window->id,Expose,&sans_event));     }    /*     Check boundary conditions.   */:   if ((window->ximage->width-(x+window->x)) < (int) width).     width=window->ximage->width-(x+window->x);<   if ((window->ximage->height-(y+window->y)) < (int) height)0     height=window->ximage->height-(y+window->y);   /*     Refresh image.   */F   XSetClipMask(display,window->annotate_context,window->matte_pixmap);&   if (window->pixmap != (Pixmap) NULL)     {e       if (window->depth > 1)M         XCopyArea(display,window->pixmap,window->id,window->annotate_context,s4           x+window->x,y+window->y,width,height,x,y);
       elseO         XCopyPlane(display,window->pixmap,window->id,window->highlight_context, 7           x+window->x,y+window->y,width,height,x,y,1L);n     }a   else     {o #if defined(HasSharedMemory)        if (window->shared_memory)A         XShmPutImage(display,window->id,window->annotate_context, H           window->ximage,x+window->x,y+window->y,x,y,width,height,True); #endif!       if (!window->shared_memory) M         XPutImage(display,window->id,window->annotate_context,window->ximage,u4           x+window->x,y+window->y,x,y,width,height);     }e6   XSetClipMask(display,window->annotate_context,None);   XFlush(display); }_ o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%uO %                                                                             %oO %                                                                             %lO %                                                                             %lO %   X R e m o t e C o m m a n d                                               % O %                                                                             % O %                                                                             %>O %                                                                             %FO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%! %PL %  Method XRemoteCommand forces a remote display(1) to display the specified %  image filename. % . %  The format of the XRemoteCommand method is: % ? %      void XRemoteCommand(Display *display,const char *window,i %        const char *filename) % + %  A description of each parameter follows:u %iD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %)7 %    o window: Specifies the name or id of an X window.w %a; %    o filename: The name of the image filename to display.  %i %w */? Export void XRemoteCommand(Display *display,const char *window,_   const char *filename)  {i   Atom     remote_atom;     Window     remote_window,     root_window;  $   assert(filename != (char *) NULL);"   if (display == (Display *) NULL)(     display=XOpenDisplay((char *) NULL);"   if (display == (Display *) NULL)     {iC       MagickWarning(XServerWarning,"Unable to connect to X server",i         (char *) NULL);d
       return;w     }l8   remote_atom=XInternAtom(display,"IM_PROTOCOLS",False);   remote_window=(Window) NULL;;   root_window=XRootWindow(display,XDefaultScreen(display));l   if (window != (char *) NULL)     {=       /*G         Search window hierarchy and identify any clients by name or ID.r       */#       if (isdigit((int) (*window)))w>         remote_window=XWindowByID(display,root_window,(Window)4           strtol((char *) window,(char **) NULL,0));)       if (remote_window == (Window) NULL)w@         remote_window=XWindowByName(display,root_window,window);     }w%   if (remote_window == (Window) NULL)hE     remote_window=XWindowByProperty(display,root_window,remote_atom);a%   if (remote_window == (Window) NULL)x     {-I       MagickWarning(XServerWarning,"Unable to connect to remote Display",i         (char *) NULL);m
       return;i     }i   /*     Send remote command.   */=   remote_atom=XInternAtom(display,"IM_REMOTE_COMMAND",False);p@   XChangeProperty(display,remote_window,remote_atom,XA_STRING,8,A     PropModeReplace,(unsigned char *) filename,Extent(filename));t   XSync(display,False);  }o m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %iO %                                                                             %sO %                                                                             %iO %   X R e t a i n W i n d o w C o l o r s                                     %eO %                                                                             %rO %                                                                             %tO %                                                                             %dO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%> %hI %  Method XRetainWindowColors sets X11 color resources on a window.  This%I %  preserves the colors associated with an image displayed on the window.  % 3 %  The format of the XRetainWindowColors method is:  % E %      void XRetainWindowColors(Display *display,const Window window)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % > %    o window: Specifies a pointer to a XWindowInfo structure. %  %  */E Export void XRetainWindowColors(Display *display,const Window window)  {    Atom
     property;      Pixmap     pixmap;      /*     Put property on the window.    */&   assert(display != (Display *) NULL);"   assert(window != (Window) NULL);5   property=XInternAtom(display,"_XSETROOT_ID",False);s   if (property == (Atom) NULL)     {iA       MagickWarning(XServerWarning,"Unable to create X property",s         "_XSETROOT_ID");
       return;p     }s-   pixmap=XCreatePixmap(display,window,1,1,1);e   if (pixmap == (Pixmap) NULL)     {oN       MagickWarning(XServerWarning,"Unable to create X pixmap",(char *) NULL);
       return;t     }sG   XChangeProperty(display,window,property,XA_PIXMAP,32,PropModeReplace,a!     (unsigned char *) &pixmap,1); -   XSetCloseDownMode(display,RetainPermanent);t }  s /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %xO %                                                                             %xO %                                                                             %;O %   X S e l e c t W i n d o w                                                 % O %                                                                             %<O %                                                                             %oO %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %hM %  Method XSelectWindow allows a user to select a window using the mouse.  If_H %  the mouse moves, a cropping rectangle is drawn and the extents of the4 %  rectangle is returned in the crop_info structure. % / %  The format of the XSelectWindow function is:  % 5 %      target_window=XSelectWindow(display,crop_info)  % + %  A description of each parameter follows:  % 3 %    o window: XSelectWindow returns the window id.  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o crop_info: Specifies a pointer to a RectangleInfo structure.  It 6 %      contains the extents of any cropping rectangle. %  %  */F Export Window XSelectWindow(Display *display,RectangleInfo *crop_info) { ) #define MinimumCropArea  (unsigned int) 9%     Cursor     target_cursor;     GC     annotate_context;      intt     presses,     status,o
     x_offset,e
     y_offset;e     Window     root_window,     target_window;     XEvent
     event;     XGCValues      context_values;l     /*     Initialize graphic context.C   */&   assert(display != (Display *) NULL);.   assert(crop_info != (RectangleInfo *) NULL);;   root_window=XRootWindow(display,XDefaultScreen(display));tI   context_values.background=XBlackPixel(display,XDefaultScreen(display));iI   context_values.foreground=XWhitePixel(display,XDefaultScreen(display));i#   context_values.function=GXinvert;    context_values.plane_mask=:     context_values.background ^ context_values.foreground;1   context_values.subwindow_mode=IncludeInferiors; N   annotate_context=XCreateGC(display,root_window,GCBackground | GCForeground |2     GCFunction | GCSubwindowMode,&context_values);$   if (annotate_context == (GC) NULL)     return(False);   /*)     Grab the pointer using target cursor.U   */0   target_cursor=XMakeCursor(display,root_window,G     XDefaultColormap(display,XDefaultScreen(display)),"white","black");i>   status=XGrabPointer(display,root_window,False,(unsigned int)J     (ButtonPressMask | ButtonReleaseMask | ButtonMotionMask),GrabModeSync,9     GrabModeAsync,root_window,target_cursor,CurrentTime);    if (status != GrabSuccess)     { M       MagickWarning(XServerWarning,"Unable to grab the mouse",(char *) NULL);        return(False);     }    /*     Select a window.   */   crop_info->width=0;    crop_info->height=0;   presses=0;   target_window=(Window) NULL;
   x_offset=0; 
   y_offset=0;    do   { @     if ((crop_info->width*crop_info->height) >= MinimumCropArea)G       XDrawRectangle(display,root_window,annotate_context,crop_info->x, =         crop_info->y,crop_info->width-1,crop_info->height-1);%     /*       Allow another event.     */2     XAllowEvents(display,SyncPointer,CurrentTime);J     XWindowEvent(display,root_window,ButtonPressMask | ButtonReleaseMask |       ButtonMotionMask,&event);f@     if ((crop_info->width*crop_info->height) >= MinimumCropArea)G       XDrawRectangle(display,root_window,annotate_context,crop_info->x,n=         crop_info->y,crop_info->width-1,crop_info->height-1);n     switch (event.type)s     {        case ButtonPress:        {iD         target_window=XGetSubwindow(display,event.xbutton.subwindow,+           event.xbutton.x,event.xbutton.y);e+         if (target_window == (Window) NULL)p$           target_window=root_window;&         x_offset=event.xbutton.x_root;&         y_offset=event.xbutton.y_root;         crop_info->x=x_offset;         crop_info->y=y_offset;         crop_info->width=0;l         crop_info->height=0;         presses++;         break;       }f       case ButtonRelease:s       {l         presses--;         break;       }(       case MotionNotify:       {o
         /*/           Discard pending button motion events.f
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));)%         crop_info->x=event.xmotion.x;y%         crop_info->y=event.xmotion.y;-
         /*$           Check boundary conditions.
         */$         if (crop_info->x < x_offset)B           crop_info->width=(unsigned int) (x_offset-crop_info->x);         else           {tD             crop_info->width=(unsigned int) (crop_info->x-x_offset);"             crop_info->x=x_offset;           }%$         if (crop_info->y < y_offset)C           crop_info->height=(unsigned int) (y_offset-crop_info->y);          else           { E             crop_info->height=(unsigned int) (crop_info->y-y_offset); "             crop_info->y=y_offset;           }        }        default:         break;     }    } <   while ((target_window == (Window) NULL) || (presses > 0));&   XUngrabPointer(display,CurrentTime);%   XFreeCursor(display,target_cursor); $   XFreeGC(display,annotate_context);=   if ((crop_info->width*crop_info->height) < MinimumCropArea)      {        crop_info->width=0;%       crop_info->height=0;     }%:   if ((crop_info->width != 0) && (crop_info->height != 0))     target_window=root_window;   return(target_window); }X o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             %iO %                                                                             %oO %                                                                             %pO %   X S i g n a l H a n d l e r                                               % O %                                                                             % O %                                                                             %IO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %sK %  Method XSignalHandler is called if the program execution is interrupted.e %x. %  The format of the XSignalHandler method is: %e? %      void XSetCursorState(Display *display,XWindows *windows,N" %        const unsigned int state) %e %r */ void XSignalHandler(int status)% { 
   XWindows
     *windows;f  '   windows=XSetWindows((XWindows *) ~0);N#   if (windows == (XWindows *) NULL)g     return;a #if defined(HasSharedMemory)0   if (windows->image.segment_info[0].shmid >= 0)     {r;       (void) shmdt(windows->image.segment_info[0].shmaddr);iE       (void) shmctl(windows->image.segment_info[0].shmid,IPC_RMID,0);      }(2   if (windows->magnify.segment_info[0].shmid >= 0)     {L=       (void) shmdt(windows->magnify.segment_info[0].shmaddr);(G       (void) shmctl(windows->magnify.segment_info[0].shmid,IPC_RMID,0);      }e #endif   Exit(status);* }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_O %                                                                             % O %                                                                             %WO %                                                                             %;O %   X S e t C u r s o r S t a t e                                             %,O %                                                                             % O %                                                                             %nO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%! %oF %  Method XSetCursorState sets the cursor state to busy, otherwise the% %  cursor are reset to their default.d % 0 %  The format of the XXSetCursorState method is: % - %      XSetCursorState(display,windows,state)  % + %  A description of each parameter follows:i %wE %    o display: Specifies a connection to an X server;  returned fromp %      XOpenDisplay. %&< %    o windows: Specifies a pointer to a XWindows structure. % F %    o state: An unsigned integer greater than 0 sets the cursor state@ %      to busy, otherwise the cursor are reset to their default. %r %; */? Export void XSetCursorState(Display *display,XWindows *windows,    const unsigned int state)  { &   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL);m   if (state)     {tJ       XDefineCursor(display,windows->image.id,windows->image.busy_cursor);F       XDefineCursor(display,windows->pan.id,windows->pan.busy_cursor);N       XDefineCursor(display,windows->magnify.id,windows->magnify.busy_cursor);N       XDefineCursor(display,windows->command.id,windows->command.busy_cursor);     }i   else     { E       XDefineCursor(display,windows->image.id,windows->image.cursor);oA       XDefineCursor(display,windows->pan.id,windows->pan.cursor);gI       XDefineCursor(display,windows->magnify.id,windows->magnify.cursor); I       XDefineCursor(display,windows->command.id,windows->command.cursor); H       XDefineCursor(display,windows->command.id,windows->widget.cursor);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);a     }t   windows->info.mapped=False;  }p f /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             % O %                                                                             % O %                                                                             %bO %   X S e t W i n d o w s                                                     %1O %                                                                             % O %                                                                             %uO %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %iF %  Method XSetWindows sets the X windows structure if the windows infoF %  is specified.  Otherwise the current windows structure is returned. %t+ %  The format of the XSetWindows method is:> % 4 %      XWindows *XSetWindows(XWindows *windows_info) %e+ %  A description of each parameter follows:l %aD %    o windows: Method XSetWindows returns a pointer to the XWindows %      structure.o %iL %    o windows_info: Initialize the Windows structure with this information. %S */4 Export XWindows *XSetWindows(XWindows *windows_info) {g   static XWindows !     *windows = (XWindows *) NULL;   &   if (windows_info != (XWindows *) ~0)     windows=windows_info;a   return(windows); }n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%vO %                                                                             % O %                                                                             %dO %                                                                             %nO %   X U s e r P r e f e r e n c e s                                           % O %                                                                             %eO %                                                                             %tO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%m %_K %  Method XUserPreferences saves the preferences in a configuration file inn %  the users' home directory.  % 0 %  The format of the XUserPreferences method is: %(: %      void XUserPreferences(XResourceInfo *resource_info) %i+ %  A description of each parameter follows:n %.K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %  %  */: Export void XUserPreferences(XResourceInfo *resource_info) {    char     cache[MaxTextExtent],/     *client_name,a     filename[MaxTextExtent],     specifier[MaxTextExtent],p     *value;u  
   XrmDatabase      preferences_database;%     /*;     Save user preferences to the client configuration file.    */2   assert(resource_info != (XResourceInfo *) NULL);+   client_name=SetClientName((char *) NULL); 0   preferences_database=XrmGetStringDatabase("");9   FormatString(specifier,"%.1024s.backdrop",client_name); 3   value=resource_info->backdrop ? "True" : "False"; >   XrmPutStringResource(&preferences_database,specifier,value);9   FormatString(specifier,"%.1024s.colormap",client_name); I   value=resource_info->colormap == SharedColormap ? "Shared" : "Private"; >   XrmPutStringResource(&preferences_database,specifier,value);<   FormatString(specifier,"%.1024s.confirmExit",client_name);7   value=resource_info->confirm_exit ? "True" : "False"; >   XrmPutStringResource(&preferences_database,specifier,value);@   FormatString(specifier,"%.1024s.displayWarnings",client_name);;   value=resource_info->display_warnings ? "True" : "False";e>   XrmPutStringResource(&preferences_database,specifier,value);7   FormatString(specifier,"%.1024s.dither",client_name);r@   value=resource_info->quantize_info->dither ? "True" : "False";>   XrmPutStringResource(&preferences_database,specifier,value);=   FormatString(specifier,"%.1024s.gammaCorrect",client_name);X8   value=resource_info->gamma_correct ? "True" : "False";>   XrmPutStringResource(&preferences_database,specifier,value);:   FormatString(specifier,"%.1024s.undoCache",client_name);5   FormatString(cache,"%u",resource_info->undo_cache);i>   XrmPutStringResource(&preferences_database,specifier,cache);:   FormatString(specifier,"%.1024s.usePixmap",client_name);5   value=resource_info->use_pixmap ? "True" : "False"; >   XrmPutStringResource(&preferences_database,specifier,value);L   FormatString(filename,"%.1024s%.1024src",PreferencesDefaults,client_name);   ExpandFilename(filename);i4   XrmPutFileDatabase(preferences_database,filename); }- o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             %eO %                                                                             % O %                                                                             % O %   X V i s u a l C l a s s N a m e                                           % O %                                                                             %-O %                                                                             %nO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %IG %  Method XVisualClassName returns the visual class name as a characterM
 %  string. %"0 %  The format of the XVisualClassName method is: %p. %      char *XVisualClassName(const int class) %e+ %  A description of each parameter follows:E %LL %    o visual_type: XVisualClassName returns the visual class as a character %      string. %w) %    o class: Specifies the visual class.X %M %" */. Export char *XVisualClassName(const int class) {a   switch (class)   {l*     case StaticGray: return("StaticGray");(     case GrayScale: return("GrayScale");,     case StaticColor: return("StaticColor");,     case PseudoColor: return("PseudoColor");(     case TrueColor: return("TrueColor");,     case DirectColor: return("DirectColor");   }c!   return("unknown visual class");i }  0 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %dO %                                                                             %fO %                                                                             %zO %   X W a r n i n g                                                           %eO %                                                                             %-O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %dA %  Method XWarning displays a warning message in a Notice widget.  % ( %  The format of the XWarning method is: %xD %      void XWarning(const unsigned int warning,const char *message, %        const char *qualifier)  %i+ %  A description of each parameter follows:s %r7 %    o warning: Specifies the numeric warning category.a %cG %    o message: Specifies the message to display before terminating thet %      program.f %n9 %    o qualifier: Specifies any qualifier to the message.d %o %o */D Export void XWarning(const unsigned int warning,const char *message,   const char *qualifier) {a   char     text[MaxTextExtent];  
   XWindows
     *windows;d     if (message == (char *) NULL)A     return;o   (void) strcpy(text,message);   (void) strcat(text,":");'   windows=XSetWindows((XWindows *) ~0);XB   XNoticeWidget(windows->display,windows,text,(char *) qualifier); }t r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             %-O %                                                                             %CO %                                                                             %xO %   X W i n d o w B y I D                                                     %)O %                                                                             %tO %                                                                             %iO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%= %aL %  Method XWindowByID locates a child window with a given ID.  If not windowK %  with the given name is found, 0 is returned.   Only the window specifieds# %  and its subwindows are searched.o %e- %  The format of the XWindowByID function is:s %I+ %      child=XWindowByID(display,window,id)e %r+ %  A description of each parameter follows:a %f? %    o child: XWindowByID returns the window with the specifiedL; %      id.  If no windows are found, XWindowByID returns 0.o %eL %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % 4 %    o id: Specifies the id of the window to locate. %  %  */D Export Window XWindowByID(Display *display,const Window root_window,   const unsigned long id)C {s   RectangleInfou     rectangle_info;      register int     i;     unsigned int     number_children;     Window
     child,     *children,     window;,  &   assert(display != (Display *) NULL);'   assert(root_window != (Window) NULL);    if (id == 0)3     return(XSelectWindow(display,&rectangle_info));0   if (root_window == id)     return(id);_P   if (!XQueryTree(display,root_window,&child,&child,&children,&number_children))     return((Window) NULL);   window=(Window) NULL;c+   for (i=0; i < (int) number_children; i++)n   {i     /*+       Search each child and their children.p     *//     window=XWindowByID(display,children[i],id);a      if (window != (Window) NULL)       break;   }h"   if (children != (Window *) NULL)     XFree((void *) children);n   return(window);l }_ t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %iO %                                                                             % O %   X W i n d o w B y N a m e                                                 %iO %                                                                             %DO %                                                                             %rO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %eH %  Method XWindowByName locates a window with a given name on a display.I %  If no window with the given name is found, 0 is returned. If more than K %  one window has the given name, the first one is returned.  Only root and  %  its children are searched.  % / %  The format of the XWindowByName function is:  % 5 %      window=XWindowByName(display,root_window,name)  % + %  A description of each parameter follows:  % 3 %    o window: XWindowByName returns the window id.  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % 8 %    o root_window: Specifies the id of the root window. % 8 %    o name: Specifies the name of the window to locate. %  %  */F Export Window XWindowByName(Display *display,const Window root_window,   const char *name)  {k   register int     i;     unsigned int     number_children;     Window     *children,
     child,     window;r     XTextPropertyy     window_name;  &   assert(display != (Display *) NULL);'   assert(root_window != (Window) NULL);A    assert(name != (char *) NULL);8   if (XGetWMName(display,root_window,&window_name) != 0)<     if (Latin1Compare((char *) window_name.value,name) == 0)       return(root_window);P   if (!XQueryTree(display,root_window,&child,&child,&children,&number_children))     return((Window) NULL);   window=(Window) NULL; +   for (i=0; i < (int) number_children; i++)    {      /*+       Search each child and their children.      */3     window=XWindowByName(display,children[i],name);s      if (window != (Window) NULL)       break;   } "   if (children != (Window *) NULL)     XFree((void *) children);a   return(window);r }a r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %rO %                                                                             %2O %                                                                             % O %   X W i n d o w B y P r o p e r y                                           %xO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%c %xI %  Method XWindowByProperty locates a child window with a given property.6J %  If no window with the given name is found, 0 is returned.  If more thanJ %  one window has the given property, the first one is returned.  Only the4 %  window specified and its subwindows are searched. % 3 %  The format of the XWindowByProperty function is:L % 7 %      child=XWindowByProperty(display,window,property)( %o+ %  A description of each parameter follows:h %*H %    o child: XWindowByProperty returns the window id with the specifiedG %      property.  If no windows are found, XWindowByProperty returns 0.e %tL %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %t@ %    o property: Specifies the property of the window to locate. %  %  */E Export Window XWindowByProperty(Display *display,const Window window,;   const Atom property) {L   Atom	     type;e     intp     format,b     status;o     unsigned char 
     *data;     unsigned int     i,     number_children;     unsigned longi
     after,     number_items;&     Window
     child,     *children,     parent,)	     root;P  &   assert(display != (Display *) NULL);"   assert(window != (Window) NULL);"   assert(property != (Atom) NULL);M   status=XQueryTree(display,window,&root,&parent,&children,&number_children);    if (status == 0)     return((Window) NULL);   type=(Atom) NULL;    child=(Window) NULL;C   for (i=0; (i < number_children) && (child == (Window) NULL); i++)    { G     status=XGetWindowProperty(display,children[i],property,0L,0L,False, G       (Atom) AnyPropertyType,&type,&format,&number_items,&after,&data);      if (data != NULL)        XFree((void *) data); 5     if ((status == Success) && (type != (Atom) NULL))        child=children[i];   } C   for (i=0; (i < number_children) && (child == (Window) NULL); i++) :     child=XWindowByProperty(display,children[i],property);"   if (children != (Window *) NULL)     XFree((void *) children);e   return(child); }f #endif