 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %              M   M   OOO    GGGG  RRRR   IIIII  FFFFF  Y   Y                % O %              MM MM  O   O  G      R   R    I    F       Y Y                 % O %              M M M  O   O  G GG   RRRRR    I    FFF      Y                  % O %              M   M  O   O  G   G  R R      I    F        Y                  % O %              M   M   OOO    GGG   R  R   IIIII  F        Y                  % O %                                                                             % O %                                                                             % O %               Transmogrify an Image or Sequence of Images.                  % O %                                                                             % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                            December 1992                                    % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  `Mogrify' applies one or more image transforms to an image or sequence of- %   images and overwrites the original image.  % ) %  The Mogrify program command syntax is:  % > %  Usage: mogrify [options ...] file [ [options ...] file ...] %  %  Where options include: / %    -antialias           remove pixel-aliasing : %    -blur factor         apply a filter to blur the image? %    -border geometry     surround image with a border of color & %    -bordercolor color   border color; %    -box color           color for annotation bounding box J %    -cache threshold     megabytes of memory available to the pixel cache5 %    -charcoal factor     simulate a charcoal drawing ? %    -colorize value      colorize the image with the pen color A %    -colors value        preferred number of colors in the image 4 %    -colorspace type     alternate image colorspace5 %    -comment string      annotate image with comment 3 %    -compress type       type of image compression > %    -contrast            enhance or reduce the image contrastJ %    -crop geometry       preferred size and location of the cropped image2 %    -cycle amount        cycle the image colormap> %    -delay value         display the next image after pausingF %    -density geometry    vertical and horizontal density of the image, %    -depth value         depth of the image? %    -despeckle           reduce the speckles within an image", A %    -display server      obtain image or font from this X server - %    -dispose method      GIF disposal method H %    -dither              apply Floyd/Steinberg error diffusion to imageE %    -draw string         annotate the image with a graphic primitive E %    -edge factor         apply a filter to detect edges in the image ) %    -emboss              emboss an image I %    -enhance             apply a digital filter to enhance a noisy image D %    -equalize            perform histogram equalization to an image@ %    -filter type         use this filter when resizing an image> %    -flip                flip image in the vertical direction@ %    -flop                flop image in the horizontal direction6 %    -font name           X11 font for displaying text+ %    -format type         image format type B %    -frame geometry      surround image with an ornamental borderJ %    -fuzz distance       colors within this distance are considered equal3 %    -gamma value         level of gamma correction A %    -geometry geometry   perferred size or location of the image ? %    -implode amount      implode image pixels about the center 9 %    -interlace type      None, Line, Plane, or Partition 4 %    -label name          assign a label to an image1 %    -layer type          Red, Green, Blue, Matte 1 %    -linewidth value     width of line in pixels K %    -loop iterations     add Netscape loop extension to your GIF animation L %    -map filename        transform image colors to match this set of colorsB %    -matte               store matte channel if the image has one< %    -median radius       apply a median filter to the imageB %    -modulate value      vary the brightness, saturation, and hue< %    -monochrome          transform image to black and whiteK %    -negate              replace every pixel with its complementary color  9 %    -noise               add or reduce noise in an image J %    -normalize           transform image to span the full range of colors< %    -opaque color        change this color to the pen color> %    -page geometry       size and location of an image canvas2 %    -paint radius        simulate an oil paintingG %    -pen color           color for annotating or changing opaque color 6 %    -pointsize value     pointsize of Postscript font9 %    -quality value       JPEG/MIFF/PNG compression level K %    -raise value         lighten/darken image edges to create a 3-D effect A %    -region geometry     apply options to a portion of the image B %    -roll geometry       roll an image vertically or horizontally; %    -rotate degrees      apply Paeth rotation to the image 9 %    -sample geometry     scale image with pixel sampling , %    -scene value         image scene numberC %    -seed value          pseudo-random number generator seed value * %    -segment values      segment an imageF %    -shade degrees       shade the image using a distant light source= %    -sharpen factor      apply a filter to sharpen the image K %    -shear geometry      slide one edge of the image along the X or Y axis 3 %    -size geometry       width and height of image F %    -solarize threshold   negate all pixels above the threshold levelB %    -spread amount       displace image pixels by a random amount= %    -swirl degrees       swirl image pixels about the center K %    -texture filename    name of texture to tile onto the image background - %    -threshold value     threshold the image F %    -transparent color   make this color transparent within the image@ %    -treedepth value     depth of the color classification treeJ %    -units type          PixelsPerInch, PixelsPerCentimeter, or UndefinedD %    -verbose             print detailed information about the image5 %    -view                FlashPix viewing transforms : %    -wave geometry       alter an image along a sine wave % D %  By default, the image format of `file' is determined by its magicF %  number.  To specify a particular image format, precede the filenameG %  with an image format name and a colon (i.e. ps:image) or specify the H %  image type as the filename suffix (i.e. image.ps).  Specify 'file' as$ %  '-' for standard input or output. %  %  */   /*   Include declarations.  */ #include "magick/magick.h" #include "magick/defines.h"    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 4 %  Method Usage displays the program command syntax. % % %  The format of the Usage method is:  % * %      void Usage(const char *client_name) % J %    o client_name: a character string representing the name of the client %      program.  %  %  */* static void Usage(const char *client_name) {    const char     **p;     static const char      *options[]=      { 3       "-antialias           remove pixel-aliasing", >       "-blur factor         apply a filter to blur the image",C       "-border geometry     surround image with a border of color", *       "-bordercolor color   border color",?       "-box color           color for annotation bounding box", N       "-cache threshold     megabytes of memory available to the pixel cache",9       "-charcoal factor     simulate a charcoal drawing", C       "-colorize value      colorize the image with the pen color", E       "-colors value        preferred number of colors in the image", 8       "-colorspace type     alternate image colorspace",9       "-comment string      annotate image with comment", 7       "-compress type       type of image compression", B       "-contrast            enhance or reduce the image contrast",N       "-crop geometry       preferred size and location of the cropped image",6       "-cycle amount        cycle the image colormap",B       "-delay value         display the next image after pausing",J       "-density geometry    vertical and horizontal density of the image",0       "-depth value         depth of the image",A       "-despeckle           reduce the speckles within an image", E       "-display server      obtain image or font from this X server", 1       "-dispose method      GIF disposal method", L       "-dither              apply Floyd/Steinberg error diffusion to image",I       "-draw string         annotate the image with a graphic primitive", I       "-edge factor         apply a filter to detect edges in the image", -       "-emboss              emboss an image", M       "-enhance             apply a digital filter to enhance a noisy image", H       "-equalize            perform histogram equalization to an image",D       "-filter type         use this filter when resizing an image",B       "-flip                flip image in the vertical direction",D       "-flop                flop image in the horizontal direction",:       "-font name           X11 font for displaying text",/       "-format type         image format type", F       "-frame geometry      surround image with an ornamental border",N       "-fuzz distance       colors within this distance are considered equal",7       "-gamma value         level of gamma correction", E       "-geometry geometry   perferred size or location of the image", C       "-implode amount      implode image pixels about the center", =       "-interlace type      None, Line, Plane, or Partition", 8       "-label name          assign a label to an image",5       "-layer type          Red, Green, Blue, Matte", 5       "-linewidth value     width of line in pixels", O       "-loop iterations     add Netscape loop extension to your GIF animation", P       "-map filename        transform image colors to match this set of colors",F       "-matte               store matte channel if the image has one",@       "-median radius       apply a median filter to the image",F       "-modulate value      vary the brightness, saturation, and hue",@       "-monochrome          transform image to black and white",O       "-negate              replace every pixel with its complementary color ", >       "-noise               add or reduce noise in an image.",N       "-normalize           transform image to span the full range of colors",@       "-opaque color        change this color to the pen color",B       "-page geometry       size and location of an image canvas",6       "-paint radius        simulate an oil painting",K       "-pen color           color for annotating or changing opaque color", :       "-pointsize value     pointsize of Postscript font",=       "-quality value       JPEG/MIFF/PNG compression level", O       "-raise value         lighten/darken image edges to create a 3-D effect", E       "-region geometry     apply options to a portion of the image", F       "-roll geometry       roll an image vertically or horizontally",?       "-rotate degrees      apply Paeth rotation to the image", =       "-sample geometry     scale image with pixel sampling", 0       "-scene number        image scene number",G       "-seed value          pseudo-random number generator seed value", .       "-segment values      segment an image",J       "-shade degrees       shade the image using a distant light source",A       "-sharpen factor      apply a filter to sharpen the image", O       "-shear geometry      slide one edge of the image along the X or Y axis", 7       "-size geometry       width and height of image", J       "-solarize threshold   negate all pixels above the threshold level",F       "-spread amount       displace image pixels by a random amount",A       "-swirl degrees       swirl image pixels about the center", O       "-texture filename    name of texture to tile onto the image background", 1       "-threshold value     threshold the image", J       "-transparent color   make this color transparent within the image",D       "-treedepth value     depth of the color classification tree",N       "-units type          PixelsPerInch, PixelsPerCentimeter, or Undefined",H       "-verbose             print detailed information about the image",9       "-view                FlashPix viewing transforms", >       "-wave geometry       alter an image along a sine wave",       (char *) NULL      };  4   (void) printf("Version: %.1024s\n",MagickVersion);:   (void) printf("Copyright: %.1024s\n\n",MagickCopyright);   (void) printf(F     "Usage: %.1024s [-options ...] file [ [-options ...] file ...]\n",     client_name); /   (void) printf("\nWhere options include: \n"); +   for (p=options; *p != (char *) NULL; p++) $     (void) printf("  %.1024s\n",*p);   (void) printf(M     "\nBy default, the image format of `file' is determined by its magic\n");    (void) printf(M     "number.  To specify a particular image format, precede the filename\n");    (void) printf(N     "with an image format name and a colon (i.e. ps:image) or specify the\n");   (void) printf(O     "image type as the filename suffix (i.e. image.ps).  Specify 'file' as\n"); 7   (void) printf("'-' for standard input or output.\n");     ListMagickInfo((FILE *) NULL);"   ListDelegateInfo((FILE *) NULL);
   Exit(0); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %    M a i n                                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */ int main(int argc,char **argv) {    char     *client_name,      filename[MaxTextExtent],     *format,     *option;     double	     sans;      ImageInfo      image_info;      Image      *image;      int      gravity,     x;     register Image     *p;      register int     i;     unsigned int     global_colormap,
     scene,     status;      /*&     Initialize command line arguments.   */   ReadCommandlLine(argc,&argv); #   client_name=SetClientName(*argv); &   (void) ExpandFilenames(&argc,&argv);   if (argc < 2)      Usage(client_name);    /*     Set defaults.    */   format=(char *) NULL;    global_colormap=False;   image=(Image *) NULL;    GetImageInfo(&image_info);
   scene=0;   status=False;    /*     Parse command line.    */   for (i=1; i < argc; i++)   {      option=argv[i]; G     if ((Extent(option) > 1) && ((*option == '-') || (*option == '+')))        switch (*(option+1))       {          case 'a': 	         { 3           if (strncmp("antialias",option+1,3) == 0) 
             { 4               image_info.antialias=(*option == '-');               break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'b': 	         { 4           if (strncmp("background",option+1,5) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)O                     MagickError(OptionError,"Missing background color",option); 4                   (void) QueryColorDatabase(argv[i],2                     &image_info.background_color);                 }                break;
             } .           if (strncmp("blur",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))E                     MagickError(OptionError,"Missing factor",option);                  }                break;
             } 0           if (strncmp("border",option+1,7) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } 5           if (strncmp("bordercolor",option+1,7) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)K                     MagickError(OptionError,"Missing border color",option); N                   (void) QueryColorDatabase(argv[i],&image_info.border_color);                 }                break;
             } -           if (strncmp("box",option+1,3) == 0) 
             { +               image_info.box=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     MagickError(OptionError,"Missing box color",option);>                   (void) CloneString(&image_info.box,argv[i]);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'c': 	         { /           if (strncmp("cache",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))H                     MagickError(OptionError,"Missing threshold",option);                 }                break;
             } 2           if (strncmp("charcoal",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))E                     MagickError(OptionError,"Missing factor",option);                  }                break;
             } 2           if (strncmp("colorize",option+1,7) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))D                     MagickError(OptionError,"Missing value",option);                 }                break;
             } 0           if (strncmp("colors",option+1,7) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     MagickError(OptionError,"Missing colors",option);                  }                break;
             } 4           if (strncmp("colorspace",option+1,7) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; <                   image_info.colorspace=UndefinedColorspace;8                   if (Latin1Compare("cmyk",option) == 0)9                     image_info.colorspace=CMYKColorspace; 8                   if (Latin1Compare("gray",option) == 0)9                     image_info.colorspace=GRAYColorspace; 8                   if (Latin1Compare("ohta",option) == 0)9                     image_info.colorspace=OHTAColorspace; 7                   if (Latin1Compare("rgb",option) == 0) 8                     image_info.colorspace=RGBColorspace;8                   if (Latin1Compare("srgb",option) == 0)9                     image_info.colorspace=sRGBColorspace; ?                   if (Latin1Compare("transparent",option) == 0) @                     image_info.colorspace=TransparentColorspace;7                   if (Latin1Compare("xyz",option) == 0) 8                     image_info.colorspace=XYZColorspace;9                   if (Latin1Compare("ycbcr",option) == 0) :                     image_info.colorspace=YCbCrColorspace;7                   if (Latin1Compare("ycc",option) == 0) 8                     image_info.colorspace=YCCColorspace;7                   if (Latin1Compare("yiq",option) == 0) 8                     image_info.colorspace=YIQColorspace;9                   if (Latin1Compare("ypbpr",option) == 0) :                     image_info.colorspace=YPbPrColorspace;7                   if (Latin1Compare("yuv",option) == 0) 8                     image_info.colorspace=YUVColorspace;C                   if (image_info.colorspace == UndefinedColorspace) N                     MagickError(OptionError,"Invalid colorspace type",option);                 }                break;
             } 1           if (strncmp("comment",option+1,4) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)F                     MagickError(OptionError,"Missing comment",option);                 }                break;
             } 2           if (strncmp("compress",option+1,5) == 0)
             { 3               image_info.compression=NoCompression; !               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; >                   image_info.compression=UndefinedCompression;8                   if (Latin1Compare("None",option) == 0)9                     image_info.compression=NoCompression; 8                   if (Latin1Compare("BZip",option) == 0);                     image_info.compression=BZipCompression; 7                   if (Latin1Compare("Fax",option) == 0) :                     image_info.compression=FaxCompression;:                   if (Latin1Compare("Group4",option) == 0)=                     image_info.compression=Group4Compression; 8                   if (Latin1Compare("JPEG",option) == 0);                     image_info.compression=JPEGCompression; 7                   if (Latin1Compare("LZW",option) == 0) :                     image_info.compression=LZWCompression;D                   if (Latin1Compare("RunlengthEncoded",option) == 0)G                     image_info.compression=RunlengthEncodedCompression; 7                   if (Latin1Compare("Zip",option) == 0) :                     image_info.compression=ZipCompression;E                   if (image_info.compression == UndefinedCompression) O                     MagickError(OptionError,"Invalid compression type",option);                  }                break;
             } 2           if (strncmp("contrast",option+1,3) == 0)             break;.           if (strncmp("crop",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } /           if (strncmp("cycle",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     MagickError(OptionError,"Missing amount",option);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'd': 	         { /           if (strncmp("delay",option+1,3) == 0) 
             { -               image_info.delay=(char *) NULL; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))D                     MagickError(OptionError,"Missing delay",option);?                   image_info.delay=PostscriptGeometry(argv[i]);                  }                break;
             } 1           if (strncmp("density",option+1,3) == 0) 
             { /               image_info.density=(char *) NULL; !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option); B                   (void) CloneString(&image_info.density,argv[i]);                 }                break;
             } /           if (strncmp("depth",option+1,3) == 0) 
             { ,               image_info.depth=QuantumDepth;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))J                     MagickError(OptionError,"Missing image depth",option);1                   image_info.depth=atoi(argv[i]);                  }                break;
             } 3           if (strncmp("despeckle",option+1,3) == 0)              break;5           if (Latin1Compare("display",option+1) == 0) 
             { 3               image_info.server_name=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)J                     MagickError(OptionError,"Missing server name",option);F                   (void) CloneString(&image_info.server_name,argv[i]);                 }                break;
             } 1           if (strncmp("dispose",option+1,5) == 0) 
             { /               image_info.dispose=(char *) NULL; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     MagickError(OptionError,"Missing method",option); A                   image_info.dispose=PostscriptGeometry(argv[i]);                  }                break;
             } 0           if (strncmp("dither",option+1,3) == 0)
             { 1               image_info.dither=(*option == '-');                break;
             } .           if (strncmp("draw",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     MagickError(OptionError,"Missing primitive",option);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'e': 	         { .           if (strncmp("edge",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))E                     MagickError(OptionError,"Missing factor",option);                  }                break;
             } 0           if (strncmp("emboss",option+1,2) == 0)             break;1           if (strncmp("enhance",option+1,2) == 0)              break;2           if (strncmp("equalize",option+1,2) == 0)             break;@           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'f': 	         { 0           if (strncmp("filter",option+1,3) == 0)
             { !               if (*option == '-')                  {                    FilterType                     filter;                      i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; )                   filter=UndefinedFilter; 9                   if (Latin1Compare("Point",option) == 0) '                     filter=PointFilter; 7                   if (Latin1Compare("Box",option) == 0) %                     filter=BoxFilter; <                   if (Latin1Compare("Triangle",option) == 0)*                     filter=TriangleFilter;;                   if (Latin1Compare("Hermite",option) == 0) )                     filter=HermiteFilter; ;                   if (Latin1Compare("Hanning",option) == 0) )                     filter=HanningFilter; ;                   if (Latin1Compare("Hamming",option) == 0) )                     filter=HammingFilter; <                   if (Latin1Compare("Blackman",option) == 0)*                     filter=BlackmanFilter;<                   if (Latin1Compare("Gaussian",option) == 0)*                     filter=GaussianFilter;=                   if (Latin1Compare("Quadratic",option) == 0) +                     filter=QuadraticFilter; 9                   if (Latin1Compare("Cubic",option) == 0) '                     filter=CubicFilter; :                   if (Latin1Compare("Catrom",option) == 0)(                     filter=CatromFilter;<                   if (Latin1Compare("Mitchell",option) == 0)*                     filter=MitchellFilter;;                   if (Latin1Compare("Lanczos",option) == 0) )                     filter=LanczosFilter; :                   if (Latin1Compare("Bessel",option) == 0)(                     filter=BesselFilter;8                   if (Latin1Compare("Sinc",option) == 0)&                     filter=SincFilter;0                   if (filter == UndefinedFilter)J                     MagickError(OptionError,"Invalid filter type",option);                 }                break;
             } .           if (strncmp("flip",option+1,3) == 0)             break;.           if (strncmp("flop",option+1,3) == 0)             break;.           if (strncmp("font",option+1,3) == 0)
             { ,               image_info.font=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)H                     MagickError(OptionError,"Missing font name",option);?                   (void) CloneString(&image_info.font,argv[i]);                  }                break;
             } 0           if (strncmp("format",option+1,3) == 0)
             { #               format=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)I                     MagickError(OptionError,"Missing image type",option); 6                   (void) CloneString(&format,argv[i]);<                   (void) strcpy(image_info.filename,format);9                   (void) strcat(image_info.filename,":"); 2                   SetImageInfo(&image_info,False);1                   if (*image_info.magick == '\0') P                     MagickError(OptionError,"Unrecognized image format",format);                 }                break;
             } /           if (strncmp("frame",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } .           if (strncmp("fuzz",option+1,2) == 0)
             {                 image_info.fuzz=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     MagickError(OptionError,"Missing distance",option); 0                   image_info.fuzz=atoi(argv[i]);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'g': 	         { /           if (strncmp("gamma",option+1,2) == 0) 
             {                i++;>               if ((i == argc) || !sscanf(argv[i],"%lf",&sans))@                 MagickError(OptionError,"Missing value",option);               break;
             } 2           if (strncmp("geometry",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } 1           if (strncmp("gravity",option+1,2) == 0) 
             { $               gravity=ForgetGravity;!               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; =                   if (Latin1Compare("NorthWest",option) == 0) -                     gravity=NorthWestGravity; 9                   if (Latin1Compare("North",option) == 0) )                     gravity=NorthGravity; =                   if (Latin1Compare("NorthEast",option) == 0) -                     gravity=NorthEastGravity; 8                   if (Latin1Compare("West",option) == 0)(                     gravity=WestGravity;:                   if (Latin1Compare("Center",option) == 0)*                     gravity=CenterGravity;8                   if (Latin1Compare("East",option) == 0)(                     gravity=EastGravity;=                   if (Latin1Compare("SouthWest",option) == 0) -                     gravity=SouthWestGravity; 9                   if (Latin1Compare("South",option) == 0) )                     gravity=SouthGravity; =                   if (Latin1Compare("SouthEast",option) == 0) -                     gravity=SouthEastGravity; /                   if (gravity == ForgetGravity) K                     MagickError(OptionError,"Invalid gravity type",option);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'h': 	         { .           if (strncmp("help",option+1,2) == 0)
             { !               Usage(client_name);                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'i': 	         { 1           if (strncmp("implode",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))E                     MagickError(OptionError,"Missing amount",option);                  }                break;
             } 3           if (strncmp("interlace",option+1,3) == 0) 
             { /               image_info.interlace=NoInterlace; !               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; :                   image_info.interlace=UndefinedInterlace;8                   if (Latin1Compare("None",option) == 0)5                     image_info.interlace=NoInterlace; 8                   if (Latin1Compare("Line",option) == 0)7                     image_info.interlace=LineInterlace; 9                   if (Latin1Compare("Plane",option) == 0) 8                     image_info.interlace=PlaneInterlace;=                   if (Latin1Compare("Partition",option) == 0) <                     image_info.interlace=PartitionInterlace;A                   if (image_info.interlace == UndefinedInterlace) M                     MagickError(OptionError,"Invalid interlace type",option);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'l': 	         { /           if (strncmp("label",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)I                     MagickError(OptionError,"Missing label name",option);                  }                break;
             } /           if (strncmp("layer",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    LayerType                      layer;                     i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; '                   layer=UndefinedLayer; 7                   if (Latin1Compare("Red",option) == 0) #                     layer=RedLayer; 9                   if (Latin1Compare("Green",option) == 0) %                     layer=GreenLayer; 8                   if (Latin1Compare("Blue",option) == 0)$                     layer=BlueLayer;9                   if (Latin1Compare("Matte",option) == 0) %                     layer=MatteLayer; .                   if (layer == UndefinedLayer)I                     MagickError(OptionError,"Invalid layer type",option);                  }                break;
             } 3           if (strncmp("linewidth",option+1,2) == 0) 
             { %               image_info.linewidth=0; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))C                     MagickError(OptionError,"Missing size",option); 5                   image_info.linewidth=atoi(argv[i]);                  }                break;
             } .           if (strncmp("loop",option+1,2) == 0)
             { 2               image_info.iterations=(char *) NULL;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))I                     MagickError(OptionError,"Missing iterations",option); D                   image_info.iterations=PostscriptGeometry(argv[i]);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'm': 	         { -           if (strncmp("map",option+1,3) == 0) 
             { /               global_colormap=(*option == '+'); !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     MagickError(OptionError,"Missing file name",option);                 }                break;
             } 3           if (Latin1Compare("matte",option+1) == 0)              break;4           if (strncmp("mattecolor",option+1,6) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)J                     MagickError(OptionError,"Missing matte color",option);M                   (void) QueryColorDatabase(argv[i],&image_info.matte_color);                  }                break;
             } 2           if (strncmp("modulate",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))D                     MagickError(OptionError,"Missing value",option);                 }                break;
             } 4           if (strncmp("monochrome",option+1,4) == 0)
             { 5               image_info.monochrome=(*option == '-');                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'n': 	         { 0           if (strncmp("negate",option+1,3) == 0)             break;.          if (strncmp("noise",option+1,3) == 0)
             { !               if (*option == '+')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; ?                   if ((Latin1Compare("Uniform",option) != 0) && @                       (Latin1Compare("Gaussian",option) != 0) &&F                       (Latin1Compare("Multiplicative",option) != 0) &&?                       (Latin1Compare("Impulse",option) != 0) && A                       (Latin1Compare("Laplacian",option) != 0) && =                       (Latin1Compare("Poisson",option) != 0)) I                     MagickError(OptionError,"Invalid noise type",option);                  }                break;
             } 3           if (strncmp("normalize",option+1,3) == 0)              break;@           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'o': 	         { 0           if (strncmp("opaque",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)K                     MagickError(OptionError,"Missing opaque color",option);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'p': 	         { .           if (strncmp("page",option+1,3) == 0)
             { ,               image_info.page=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)L                     MagickError(OptionError,"Missing page geometry",option);>                   image_info.page=PostscriptGeometry(argv[i]);                 }                break;
             } /           if (strncmp("paint",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     MagickError(OptionError,"Missing radius",option);                  }                break;
             } -           if (strncmp("pen",option+1,2) == 0) 
             { +               image_info.pen=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     MagickError(OptionError,"Missing pen color",option);>                   (void) CloneString(&image_info.pen,argv[i]);                 }                break;
             } 3           if (strncmp("pointsize",option+1,2) == 0) 
             { &               image_info.pointsize=12;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))C                     MagickError(OptionError,"Missing size",option); 5                   image_info.pointsize=atof(argv[i]);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'q': 	         { 1           if (strncmp("quality",option+1,2) == 0) 
             { $               image_info.quality=75;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     MagickError(OptionError,"Missing quality",option);3                   image_info.quality=atoi(argv[i]);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'r': 	         { /           if (strncmp("raise",option+1,2) == 0) 
             {                i++;:               if ((i == argc) || !sscanf(argv[i],"%d",&x))F                 MagickError(OptionError,"Missing bevel width",option);               break;
             } 0           if (strncmp("region",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } .           if (strncmp("roll",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } 0           if (strncmp("rotate",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))F                     MagickError(OptionError,"Missing degrees",option);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 's': 	         { 0           if (strncmp("sample",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } /           if (strncmp("scene",option+1,3) == 0) 
             {                scene=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))K                     MagickError(OptionError,"Missing scene number",option); &                   scene=atoi(argv[i]);                 }                break;
             } .           if (strncmp("seed",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))D                     MagickError(OptionError,"Missing value",option);                 } 2               srand((unsigned int) atoi(argv[i]));               break;
             } 1           if (strncmp("segment",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))H                     MagickError(OptionError,"Missing threshold",option);                 }                break;
             } /           if (strncmp("shade",option+1,5) == 0) 
             {                i++;:               if ((i == argc) || !sscanf(argv[i],"%d",&x))B                 MagickError(OptionError,"Missing azimuth",option);               break;
             } 1           if (strncmp("sharpen",option+1,5) == 0) 
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))E                     MagickError(OptionError,"Missing factor",option);                  }                break;
             } /           if (strncmp("shear",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } .           if (strncmp("size",option+1,2) == 0)
             { ,               image_info.size=(char *) NULL;!               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option); ?                   (void) CloneString(&image_info.size,argv[i]);                  }                break;
             } 2           if (strncmp("solarize",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))H                     MagickError(OptionError,"Missing threshold",option);                 }                break;
             } 0           if (strncmp("spread",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     MagickError(OptionError,"Missing amount",option);                  }                break;
             } /           if (strncmp("swirl",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))F                     MagickError(OptionError,"Missing degrees",option);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 't': 	         { 1           if (strncmp("texture",option+1,5) == 0) 
             { /               image_info.texture=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)G                     MagickError(OptionError,"Missing filename",option); B                   (void) CloneString(&image_info.texture,argv[i]);                 }                break;
             } 3           if (strncmp("threshold",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))D                     MagickError(OptionError,"Missing value",option);                 }                break;
             } 5           if (strncmp("transparent",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)P                     MagickError(OptionError,"Missing transparent color",option);                 }                break;
             } 3           if (strncmp("treedepth",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))D                     MagickError(OptionError,"Missing depth",option);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'u': 	         { /           if (strncmp("units",option+1,3) == 0) 
             { 3               image_info.units=UndefinedResolution; !               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; 7                   image_info.units=UndefinedResolution; A                   if (Latin1Compare("PixelsPerInch",option) == 0) =                     image_info.units=PixelsPerInchResolution; G                   if (Latin1Compare("PixelsPerCentimeter",option) == 0) C                     image_info.units=PixelsPerCentimeterResolution;                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'v': 	         { 1           if (strncmp("verbose",option+1,2) == 0) 
             { 2               image_info.verbose=(*option == '-');               break;
             } .           if (strncmp("view",option+1,3) == 0)
             { ,               image_info.view=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)M                     MagickError(OptionError,"Missing view transform",option); ?                   (void) CloneString(&image_info.view,argv[i]);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'w': 	         { 2           if (Latin1Compare("wave",option+1) == 0)
             {                i++;:               if ((i == argc) || !sscanf(argv[i],"%d",&x))D                 MagickError(OptionError,"Missing amplitude",option);               break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case '?': 	         {            Usage(client_name);            break;	         }          default:	         { @           MagickError(OptionError,"Unrecognized option",option);           break;	         }        }      else       { 
         /*L           Option is a file name: begin by reading image from specified file.
         */3         (void) strcpy(image_info.filename,argv[i]); %         image=ReadImage(&image_info); $         if (image == (Image *) NULL)           {              if (*option == '-')                break;             else               continue;            }          if (scene != 0)            image->scene=scene; $         if (format != (char *) NULL)           {              register char                *p;                /*G               Modify filename to include a user specified image format.              */8             p=image->filename+Extent(image->filename)-1;<             while ((*p != '.') && (p > (image->filename+1)))               p--;             p++;4             if (Latin1Compare(p,image->magick) == 0)&               (void) strcpy(p,format);             else               { J                 FormatString(image_info.filename,"%.1024s:%.1024s",format,#                   image->filename); C                 (void) strcpy(image->filename,image_info.filename);                }            } 
         /*H           Transmogrify image as defined by the image processing options.
         */1         MogrifyImages(&image_info,i,argv,&image);          if (global_colormap)C           (void) MapImages(image,(Image *) NULL,image_info.dither); 
         /*-           Write transmogrified image to disk. 
         */$         if (format != (char *) NULL)4           AppendImageFormat(format,image->filename);         else3           if (strcmp(image_info.filename,"-") != 0) 
             { 6               (void) strcpy(filename,image->filename);.               LocaleFilename(image->filename);
             } 5         for (p=image; p != (Image *) NULL; p=p->next) 	         { 5           (void) strcpy(p->filename,image->filename);            p->scene=scene++; 	         } '         SetImageInfo(&image_info,True); 5         for (p=image; p != (Image *) NULL; p=p->next) 	         { +           status=WriteImage(&image_info,p); 5           if ((status == False) || image_info.adjoin)              break;	         } 5         for (p=image; p != (Image *) NULL; p=p->next)            scene--;         if (image_info.verbose) ,           DescribeImage(image,stderr,False);;         if ((format == (char *) NULL) && (status != False)) :           if (Latin1Compare(image_info.filename,"-") != 0)
             { &               (void) remove(filename);6               (void) rename(image->filename,filename);
             }          DestroyImage(image);       }      }    if (image == (Image *) NULL)H     MagickError(OptionError,"Missing an image file name",(char *) NULL);   DestroyImages(image);    DestroyDelegateInfo();   DestroyMagickInfo();   FreeMemory(argv);    Exit(status ? 0 : errno);    return(False); } 