/******************************************************************************
Module name: FileStreams.cpp
Written by: Jeffrey Richter
Notices: Copyright (c) 1998 Jeffrey Richter
******************************************************************************/


#define STRICT
#include <windows.h>


///////////////////////////////////////////////////////////////////////////////


int WINAPI WinMain (HINSTANCE hinstExe,
   HINSTANCE hinstPrev, LPSTR pszCmdLine, int nCmdShow) {

	LPCTSTR pszFile         = __TEXT("D:\\StreamTest.tst");
	LPCTSTR pszFirstStream  = __TEXT("D:\\StreamTest.tst:FirstStream");
	LPCTSTR pszCopyStream   = __TEXT("D:\\StreamTest.tst:CopyStream");
	LPCTSTR pszRenameStream = __TEXT("D:\\StreamTest.tst:RenameStream");
	LPCTSTR pszMoveStream   = __TEXT("D:\\StreamTest.tst:MoveStream");

	char szDataToWrite[] = "This is some data";
	char szDataToRead[100] = { 0 };
	HANDLE hfile;
	DWORD cb;


	// NOTE: In a real application, you do not have to open and 
	// close each stream's handle repeatedly as I've done below.


	// Create a file with no data in its unnamed stream and no named streams
   hfile = CreateFile(pszFile, GENERIC_WRITE, 
		0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	CloseHandle(hfile);
	// TEST: DIR (file should exist)

	// Add a named stream to the file 
	// (NOTE: Step above does NOT have to execute first)
   hfile = CreateFile(pszFirstStream, GENERIC_WRITE, 
		0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	CloseHandle(hfile);
	// TEST: MORE < C:\StreamTest.txt (nothing should be displayed)
	// TEST: MORE < C:\StreamTest.txt:FirstStream (nothing should be displayed)

	// Put some data in the named stream
   hfile = CreateFile(pszFirstStream, GENERIC_WRITE, 
		0, NULL, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL);
	WriteFile(hfile, (PVOID) szDataToWrite, strlen(szDataToWrite), &cb, NULL);
	CloseHandle(hfile);
	// TEST: MORE < C:\StreamTest.txt (nothing should be displayed)
	// TEST: MORE < C:\StreamTest.txt:FirstStream (text should be displayed)

	// Get the size of the named stream
   hfile = CreateFile(pszFirstStream, 0, 0, NULL, OPEN_EXISTING, 0, NULL);
	DWORD dwSize = GetFileSize(hfile, NULL);
	CloseHandle(hfile);
	// TEST: dwSize should be the correct number of bytes

	// Read the contents of the named stream
   hfile = CreateFile(pszFirstStream, GENERIC_READ, 
		0, NULL, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL);
	ReadFile(hfile, (PVOID) szDataToRead, sizeof(szDataToRead), &cb, NULL);
	CloseHandle(hfile);
	// TEST: szDataToRead should contain "This is some data"


	// Make a copy of the named stream to another named stream
	CopyFile(pszFirstStream, pszCopyStream, FALSE);
	// TEST: MORE < C:\StreamTest.txt:CopyStream (text should be displayed)


	// NOTE: CopyFile doesn't always behave as expected; see below
	// 1st param	2nd param    Result
	// ----------- -----------  --------------------------------------------
	// UnnamedStrm	UnnamedStrm  Complete file copy with all streams
	// UnnamedStrm NamedStrm    UnnamedStrm copied to NamedStrm
	// NamedStrm   UnnamedStrm  File deleted; NamedStrm copied to UnnamedStrm
	// NamedStrm   NamedStrm    NamedStrm copied to NamedStrm
	

	// Delete all the data in a stream
   hfile = CreateFile(pszCopyStream, GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 0, NULL);
   SetFilePointer(hfile, 0, NULL, FILE_BEGIN);
   SetEndOfFile(hfile);
   CloseHandle(hfile);
	// TEST: MORE < C:\StreamTest.txt:CopyStream (nothing displayed)

	// Delete the first named stream
	DeleteFile(pszFirstStream);
	// TEST: MORE < C:\StreamTest.txt:FirstStream (error should occur)
	// TEST: DIR (file should exist)

	// Delete the contents of the unnamed stream
   hfile = CreateFile(pszFile, GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 0, NULL);
   SetFilePointer(hfile, 0, NULL, FILE_BEGIN);
   SetEndOfFile(hfile);
   CloseHandle(hfile);
	// TEST: MORE < C:\StreamTest.txt (nothing should display)
	// TEST: DIR (file should exist)
	
	// Delete the file and all of its streams
	DeleteFile(pszFile);
	// TEST: MORE < C:\StreamTest.txt (error should occur)
	// TEST: DIR (file should NOT exist)

	
	// Unfortunately, the Win32 function MoveFile does not support the 
	// moving/renaming of streams. This function only works on complete files.
	// There is no documented way to move/rename a stream.

	// The Win32 Backup functions can be used to enumerate the streams within a 
	// file. But they are very hard to work with and their performance is poor
	// because the function also read the stream's data.

   return(0);
}


///////////////////////////////// End Of File /////////////////////////////////
