/*	RC6 Encryption Plugin for Back Orifice 2000    
	Copyright (C) 1999, Maw~

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	The author of this program may be contacted at maw@wynne.demon.co.uk. 
*/

#include "MyRC6.hpp"
#include <string.h>
#include <stdlib.h>

void RC6_HashKey(RC6Keys *Keys)
{
	unsigned __int64 tmp[3];
	int len;
	char *Buf;

	len = strlen(Keys->StrKey);

	Buf = (char*)malloc(len+24);

	// The two required hashes (each 192-bits) are generated thusly:
	// Hash 1 = Hash of the key as a string
	// Hash 2 = Hash of the key with Hash 1 tacked on

	tiger((unsigned char*)Keys->StrKey, len,tmp); 
	memcpy(Keys->KeyHash, tmp, KEY_HASH_SIZE/2);

	strcpy(Buf, Keys->StrKey);
	memcpy(&Buf[len], tmp, 24);

	tiger((unsigned char*)Buf, len+24,tmp); 
	memcpy(Keys->KeyHash+24, tmp, 24);

	memcpy(&Buf[len], tmp, 24);
	tiger((unsigned char*)Buf, len+24,tmp); 
	memcpy(Keys->LastBlock, tmp, 16);
	memcpy(Keys->DCLastBlock, tmp, 16);

	free(Buf);
}

void RC6_BuildSubKeys(RC6Keys *Keys)
{

	if (!Keys->StrKey) return;
	RC6_HashKey(Keys);

	__int32 i, j, A, B, s, v;
	__int32 *L;

	L = (__int32*)Keys->KeyHash;

	Keys->S[0]=P32;
	for (i=1;i<TWORPLUSFOUR;i++)
		Keys->S[i] = Keys->S[i-1]+Q32;

	A=B=i=j=0;
	v = 3 * __max(KEY_HASH_WORDS, TWORPLUSFOUR);
	for (s=1;s<=v;s++)
	{
		A = Keys->S[i]=_rotl( (Keys->S[i]+A+B), 3);
		B = L[j] = _rotl( (L[j]+A+B), A+B);
		i = (i+1)%TWORPLUSFOUR;
		j = (j+1)%KEY_HASH_WORDS;
	}
}

void RC6_EncryptBlock(RC6Keys *Keys, __int32 *Plain, __int32 *Cipher)
{
	__int32 A,B,C,D;
	__int32 t,u, Tmp;

	if (Keys->Flags & RC6_CBC)
	{
		A = Plain[0] ^ Keys->LastBlock[0];
		B = Plain[1] ^ Keys->LastBlock[1];
		C = Plain[2] ^ Keys->LastBlock[2];
		D = Plain[3] ^ Keys->LastBlock[3];
	}
	else
	{
		A = Plain[0];
		B = Plain[1];
		C = Plain[2];
		D = Plain[3];
	}

	B+=Keys->S[0];
	D+=Keys->S[1];

	for (__int32 i=1;i<=RC6_ROUNDS;i++)
	{
		t = _rotl(B * (2*B+1), LG_B2_W);
		u = _rotl(D * (2*D+1), LG_B2_W);
		A = _rotl(A ^ t, u) + Keys->S[2*i];
		C = _rotl(C ^ u, t) + Keys->S[2*i+1];
		Tmp = A;
		A=B;
		B=C;
		C=D;
		D=Tmp;
	}
	A+= Keys->S[RC6_ROUNDS * 2 + 2];
	C+= Keys->S[RC6_ROUNDS * 2 + 3];
	if (Keys->Flags & RC6_CBC)
	{
		Keys->LastBlock[0] = Cipher[0] = A;
		Keys->LastBlock[1] = Cipher[1] = B;
		Keys->LastBlock[2] = Cipher[2] = C;
		Keys->LastBlock[3] = Cipher[3] = D;
	}
	else
	{
		Cipher[0] = A;
		Cipher[1] = B;
		Cipher[2] = C;
		Cipher[3] = D;
	}
}

void RC6_DecryptBlock(RC6Keys *Keys, __int32 *Cipher, __int32 *Plain)
{
	__int32 A,B,C,D;
	__int32 t,u, Tmp, LB[4];

	if (Keys->Flags & RC6_CBC)
	{
		memcpy(LB, Keys->DCLastBlock, 16);
		Keys->DCLastBlock[0] = A = Cipher[0];
		Keys->DCLastBlock[1] = B = Cipher[1];
		Keys->DCLastBlock[2] = C = Cipher[2];
		Keys->DCLastBlock[3] = D = Cipher[3];
	}
	else
	{
		A = Cipher[0];
		B = Cipher[1];
		C = Cipher[2];
		D = Cipher[3];
	}

	C-=Keys->S[RC6_ROUNDS * 2 + 3];
	A-=Keys->S[RC6_ROUNDS * 2 + 2];

	for (__int32 i=RC6_ROUNDS;i>0;i--)
	{
		Tmp=D;
		D=C;
		C=B;
		B=A;
		A=Tmp;
		u = _rotl(D * (2*D+1), LG_B2_W);
		t = _rotl(B * (2*B+1), LG_B2_W);
		C = _rotr(C - Keys->S[2*i+1], t) ^ u;
		A = _rotr(A - Keys->S[2*i], u) ^ t;
	}
	D-= Keys->S[1];
	B-= Keys->S[0];
	if (Keys->Flags & RC6_CBC)
	{
		Plain[0]=A ^ LB[0];
		Plain[1]=B ^ LB[1];
		Plain[2]=C ^ LB[2];
		Plain[3]=D ^ LB[3];
	}
	else
	{
		Plain[0]=A;
		Plain[1]=B;
		Plain[2]=C;
		Plain[3]=D;
	}
}
/*
#include <iostream.h>

void main()
{
	RC6Keys Keys;

	Keys.StrKey = new char [20];
	strcpy(Keys.StrKey, "TESTTEST");

	RC6_BuildSubKeys(&Keys);

	__int32 PlainText[4];
	memset(PlainText,0,16);
	RC6_EncryptBlock(&Keys, PlainText, PlainText);
	RC6_DecryptBlock(&Keys, PlainText, PlainText);

	for (int i=0;i<4;i++)
		if (PlainText[i]) cout << "Failed\n";

	delete Keys.StrKey;
}
*/