/*	RC6 Encryption Plugin for Back Orifice 2000    
	Copyright (C) 1999, Maw~

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	The author of this program may be contacted at maw@wynne.demon.co.uk. 
*/
#ifndef __MYRC6_HPP
#define __MYRC6_HPP

#define RC6_ROUNDS	20
#define RC6_WBITS	32
#define LG_B2_W		5
#define P32			0xB7E15163
#define Q32			0x9E3779B9
#define KEY_HASH_SIZE	48			// = 384 bits
#define KEY_HASH_WORDS	12			// 48/4
#define TWORPLUSFOUR	44			// Two R Plus Four

extern "C" void tiger(unsigned char*, unsigned __int64, unsigned __int64*);

#define RC6_CBC 1

struct RC6Keys
{
	char *StrKey;
	unsigned char KeyHash[KEY_HASH_SIZE];
	__int32 S[TWORPLUSFOUR];

	int Flags;
	__int32 LastBlock[4];
	__int32 DCLastBlock[4];
};

void RC6_HashKey(RC6Keys *Keys);
void RC6_BuildSubKeys(RC6Keys *Keys);
void RC6_EncryptBlock(RC6Keys *Keys, __int32 *Plain, __int32 *Cipher);
void RC6_DecryptBlock(RC6Keys *Keys, __int32 *Cipher, __int32 *Plain);

#endif // __MYRC6_HPP

