$! findwinprinters.com
$! 18-FEB-1999, David Mathog, Biology Division, Caltech
$! 
$! Simple wrapper that goes around SMBCLIENT to let users discover
$! the names of printers on windows machines.  They have the option
$! of adding any printers found to their SYS$LOGIN:WINPRINT.DAT file.
$!
$! P1 is the name of the windows machine
$! P2 is the username to access it with
$! P3 is the password
$!
$!************************************************************
$!
$!
$!
$ on error then exit
$ on warning then exit
$ if (P1 .eqs. "")
$ then
$   type sys$Input

Usage:

  $ findwinprinters P1 P2 P3
  
  P1 is the name of the windows machine
  P2 is the username to access it with
  P3 is the password

If any printers are found, the user will be prompted
to see if they want to add that as an entry to 
their SYS$LOGIN:WINPRINT.DAT file.

$ endif
$!
$! list all known printers
$!
$ write sys$output "Here are your current Windows printers"
$ sstring = "!"
$ gosub findprinter
$!
$!
$ time = f$time()
$   killstring = f$cvtime(time,,"hour") + -
    f$cvtime(time,,"minute") + -
    f$cvtime(time,,"second") +  -
    f$cvtime(time,,"hundredth")
$   theoutfile = "KILL_" + killstring + ".txt"
$ define/user sys$output 'theoutfile'
$ smbclient "-L" "''P1'" "-U" "''P2'" "-c" "''P3';exit"
$ open/read ifil 'theoutfile'
$ isprint:
$   read/error=doneout/end=doneout ifil string
$   slen = f$length(string)
$   if(slen .lt. 23)then goto isprint
$   frag= f$extract(16,7,string)
$   if(frag .eqs. "Printer")
$   then
$     winprinter = f$extract(1,15,string)
$     winprinter = f$edit(winprinter,"TRIM")
$     description = f$extract(24,slen-23,string)
$     description = f$edit(description,"TRIM")
$     write sys$output "Printers discovered:"
$     write sys$output " "
$     write sys$output "  name:        ",winprinter
$     write sys$output "  description :",description
$     write sys$output " "
$     inquire isyes "Add this printer to your WINPRINT.DAT file?(y,n [n])"
$     frag = f$extract(0,1,isyes)
$     frag = f$edit(frag,"UPCASE")
$     if(frag .eqs. "Y")
$     then
$       frag = f$edit(winprinter,"COLLAPSE")
$       thename = frag
$       inquire isname "Name for this printer [''frag'])"
$       if(isname .nes. "")then thename = isname
$!
$! force one to exist, and force the protections on it
$!
$       append/new sys$input sys$login:winprint.dat
$       set file/prot=(w,g) sys$Login:winprint.dat
$       open/append ofil sys$login:winprint.dat
$       write ofil "''thename',''P1',''winprinter',''P2',''P3'"
$       close ofil
$     endif
$   endif 
$   goto isprint
$ doneout:
$ close ifil
$ delete 'theoutfile';
$ exit
$!
$! routine to find printers
$!
$ findprinter:
$ open/read/error=nowinprint ifil sys$login:winprint.dat
$!
$! make the file safe, no matter what the user did
$!
$ set file/prot=(w,g) sys$Login:winprint.dat
$ sstring =f$edit(sstring,"UPCASE")
$ write sys$output  " "
$ ploop:
$    read/end=donefind/error=donefind ifil string
$    if(f$extract(0,1,string) .eqs."!")then goto ploop
$    shortname   == f$element(0,",",string)
$    winbox      == f$element(1,",",string)
$    winprinter  == f$element(2,",",string)
$    winuser     == f$element(3,",",string)
$    winpassword == f$element(4,",",string)
$!
$! return first one if search string is empty
$!
$! list them if search string is "!", else, look for a match
$!
$    if(sstring .eqs. "!")
$    then
$      write sys$output string
$    else
$      shortname=f$edit(shortname,"UPCASE")
$      if(shortname .eqs. sstring)
$      then
$        close ifil
$        return
$      endif
$    endif
$    goto ploop
$ nowinprint:
$ type sys$input

You do not have a SYS$LOGIN:WINPRINT.DAT file yet.

$ return
$!
$ donefind:
$   write sys$output  " "
$   close ifil
$   return
