$! printwindows.com
$! 18-FEB-1999, David Mathog, Biology Division, Caltech
$! 
$! Simple wrapper that goes around SMBCLIENT to let users print
$! a single file to a Windows connected printer.  It gets its
$! access data from a file stored in the users home directory.
$! This file is referenced via SYS$LOGIN:WINPRINT.DAT.
$!
$! P1 is the name of the file to print. If it doesn't end in ".ps" it is assumed to
$!    be text and is converted to postscript before it is sent. If not
$!    supplied a usuage message is output.
$! P2 is the name of the printer to use.  If not supplied, the first 
$!    printer on the list is used.
$!
$!************************************************************
$!
$!
$!
$ on error then exit
$ on warning then exit
$ if (P1 .eqs. "")
$ then
$   type sys$Input

Usage:

  $ printwindows  P1 P2
  
  P1 is the name of a file to print.  If it does not end in ".ps"
     it will be converted to text before it is printed.
  P2 is the name of a Windows printer to print to.  If not specified
     the first printer in your WINPRINT.DAT file will be used.

Now listing printers from your SYS$LOGIN:WINPRINT.DAT file:

$!
$! list all known printer
$!
$   sstring = "!"
$   gosub findprinter
$   exit
$ else
$   sstring = "''P2'"
$   gosub findprinter
$ endif
$!
$! maybe convert the file, maybe not
$!
$ if (f$parse(P1,,,"TYPE") .eqs. ".PS")
$ then
$   thepsfile = "''P1'"
$   thekillfile = ""
$ else
$   time = f$time()
$   killstring = f$cvtime(time,,"hour") + -
    f$cvtime(time,,"minute") + -
    f$cvtime(time,,"second") +  -
    f$cvtime(time,,"hundredth")
$   thepsfile = "KILL_" + killstring + ".ps"
$   thekillfile = thepsfile
$   convert/document 'P1'/form=text 'thepsfile'/form=ps
$ endif
$ smbclient "\\''winbox'\''winprinter'" "-P" "-U" "''winuser'" "-c" "''winpassword';print ''thepsfile';exit"
$ if(thekillfile .nes. "")then delete 'thekillfile';
$ exit
$!
$! routine to find printers
$!
$ findprinter:
$ open/read/error=nowinprint ifil sys$login:winprint.dat
$!
$! make the file safe, no matter what the user did
$!
$ set file/prot=(w,g) sys$Login:winprint.dat
$ sstring =f$edit(sstring,"UPCASE,COLLAPSE")
$ ploop:
$    read/end=donefind/error=donefind ifil string
$    if(f$extract(0,1,string) .eqs."!")then goto ploop
$    shortname   = f$element(0,",",string)
$    winbox      = f$element(1,",",string)
$    winprinter  = f$element(2,",",string)
$    winuser     = f$element(3,",",string)
$    winpassword = f$element(4,",",string)
$!
$! return first one if search string is empty
$!
$    if(sstring .eqs. "")
$    then
$      close ifil
$      return
$    endif
$!
$! list them if search string is "!", else, look for a match
$!
$    if(sstring .eqs. "!")
$    then
$      write sys$output string
$    else
$      shortname=f$edit(shortname,"UPCASE,COLLAPSE")
$      if(shortname .eqs. sstring)
$      then
$        close ifil
$        return
$      endif
$    endif
$    goto ploop
$ nowinprint:
$ type sys$input

Fatal error.  You do not have a SYS$LOGIN:WINPRINT.DAT file, so
it was impossible to figure out which Windows printer to use.
Create one with this syntax (EXACTLY!)

!any comment lines
shortname1,winbox,winprinter,winuser,winpassword
!clearer example, hopefully
bi666,MyWNT,HPLaser,frank,a_password

Be sure to set protection so that only you
can read this file since it will contain the 
passwords for remote systems.  Ie

  SET FILE/PROTECTION=(w,g) SYS$LOGIN:WINPRINT.DAT

$ exit
$!
$ donefind:
$   close ifil
$   if(sstring .eqs. "!")then exit
$   write sys$output "Fatal error, the printer ''SSTRING' was not included in your SYS$LOGIN:WINPRINT.DAT file"  
$   exit
