 /*  *  MOST:  line.c   *D  *  Modified for C SWING and GOPHER compatibility by Foteos MacridesG  *                                                MACRIDES@SCI.WFEB.EDU   */    #include <stdio.h> #include "buffer.h"  #include "externs.h" #include "display.h" #include "line.h"     extern int COLUMN; extern unsigned char *M_POS; extern int M_FLAG; extern int W_LINE; extern int TAB_R;  extern int ESC_NUM;    #define MAX_LINE_LEN 512   /*> **  take 16 binary characters and put them in displayable form */, int ascii_format_line(char *buff, char *str) {      int i,ii,j,k,ch,di,flag;     char num_str[4];       ii = 0;      di = 40;
     flag = 1;   5     for (i = 35;i<=di;i++) str[i] = ' ';  /* a gap */           for (j = 0; j < 4; j++)        { 
           !           for (k = 0; k < 4; k++) 
             {                  i = 4 * j + k;                 ch = buff[i];                  if (MOST_V_OPT)                    { B                       if (((ch < 32) && (ch >= 0)) || (ch == 127))                         { ,                             str[ii++] = '^';*                             if (ch == 127).                               str[ii++] = '?';                              else3                               str[ii++] = ch + '@'; .                             str[i + di] = '.';                         } &                       else if (ch < 0)                         { +                             ch = ch + 256;  8                             sprintf(num_str,"%02X", ch);3                             str[ii++] = num_str[0]; 3                             str[ii++] = num_str[1]; .                             str[i + di] = '.';                         }                        else                         { ,                             str[ii++] = ' ';+                             str[ii++] = ch; -                             str[i + di] = ch;                          }                    }                  else                   { "                       if (ch < 32)                         { 6                             if (ch < 0) ch = ch + 256;.                             str[i + di] = '.';                         } *                       else str[i+di] = ch;                       2                       sprintf(num_str,"%02X", ch);-                       str[ii++] = num_str[0]; -                       str[ii++] = num_str[1];                    }                               } /* k */            str[ii++] = ' ';       } 
     di += 16;      str[di] = '\0';      return(di);  }         /*2 **  analyse ASCII line for bolding or underlining,7 **  expansion of tabs, or selective indentation display  */$ int analyse_line(unsigned char *beg,A                  unsigned char *end, char *out, char *attributes)  { 4     int test, ii, fold, ii_max, j, ok, esc_flag = 0;5     unsigned char *b,*e,*b1,*e1,ch,attr,at_esc = ' ';   
     test = 0;      ii = 0;      ii_max = 0; 
     fold = 0;      if (MOST_W_OPT)        {            if (W_LINE) 
             {                  esc_flag = 1; 4                 if      (ESC_NUM == 1) at_esc = 'b';4                 else if (ESC_NUM == 4) at_esc = 'u';4                 else if (ESC_NUM == 7) at_esc = 'r';"                 else esc_flag = 0;
             }            if (M_FLAG) 
             {                  b = beg;                 e = end; 		b1 = beg_of_line1();$                 e1 = end_of_line1();
             }        }        /*6     **  while character attributes need to be assigned     */B     while(ch = *beg, (beg <= end) && (ch != '\n') && (ch != '\0'))       {            beg++;;           if (ii > ii_max) /* beyond previous high       */ @             fold = 0;      /* so turn off bolding via ^M */     E           attr = ' '; /* turn off underlining or bolding attribute */              /*+           **  set up bolding of line via ^M            */*           if (!MOST_V_OPT && ch == '\015')
             {                  if (beg <= end)                    {                        fold = 1; P                       if (ii > ii_max) ii_max = ii - 1; /* ^M contributes nil */A                       if (out[0] == '\007' || out[0] == '\013' || +                           out[0] == '\014')                            ii = 1;                       else                           ii = 0;/                       if (MOST_W_OPT && W_LINE)                          { O                            if (*b1 != '\007' && *b1 != '\013' && *b1 != '\014') 9                                 beg = M_POS - b1 + b + 1;                             else 5                                 beg = M_POS - b1 + b; (                            if (beg > e1)                              {.                                  beg = e1 + 1;                              }                         }                    } 
             }              /*E           **  set up bolding or underlining of character if '\b' (^H)            */8           else if (!MOST_V_OPT && ch == '\b' && ii != 0)
             {                  test = 1;                  ii--; 
             } 
                      /*B           **  set up or turn off bolding, underlining or reversing;           **  invoked via an <ESC>[#m found within the line            */@           else if (!MOST_V_OPT && ch == '\033' && *beg == '[' &&=                    (*(beg + 1) == '0' || *(beg + 1) == '1' || >                     *(beg + 1) == '4' || *(beg + 1) == '7') &&&                     *(beg + 2) == 'm')
             {                  beg++;                 esc_flag = 1; 3                 if      (*beg == '1') at_esc = 'b'; 3                 else if (*beg == '4') at_esc = 'u'; 3                 else if (*beg == '7') at_esc = 'r';                  else                   { #                       at_esc = ' '; #                       esc_flag = 0;                    }                  beg += 2; 
             } @           else if (!MOST_V_OPT && ch == '\033' && *beg == '[' &&%                    *(beg + 1) == 'm') 
             {                  beg += 2;                  at_esc = ' ';                  esc_flag = 0; 
             }              /*2           **  expand tabs to 8 spaces if '\t' (^I)           */>           else if (ch == '\t' && (!MOST_T_OPT || !MOST_V_OPT))
             { )                 if (MOST_W_OPT && W_LINE)                    { "                       if (ii == 0)"                         j = TAB_R;                       else8                         j = 8 * (ii/8 + 1) - ii + TAB_R;                   }                  else?                   j = 8 * (ii/8 + 1) - ii;  /* 8 column tabs */                  while(j--)                   { $                       out[ii] = ' ';-                       attributes[ii++] = ' ';                    } 
             }                         /*6           **  assign bolding or underlining attributes)           **  invoked via ^M or '\b' (^H)            */            else if (test || fold)
             {                  test = 0; I                 if (ch == out[ii])       /* overstrike, therefore bold */                    attr = 'b'; 8                 else if (out[ii] == '_') /* underline */                   attr = 'u';   &                 if (fold && ch == ' ')M                   ii++;                  /* space, therefore no overstrike */                  else                   { C                       attributes[ii] = attr; /* assign attribute */ %                       out[ii++] = ch;                    }                  
             }              /*A           **  assign bolding, underlining or reversing attributes ;           **  invoked via an <ESC>[#m found within the line            */           else if (esc_flag)
             { ?                 attributes[ii] = at_esc; /* assign attribute */                  out[ii++] = ch; 
             }              /*6           **  no bold, underline, or reverse attribute           */           else
             {                  out[ii] = ch; (                 attributes[ii++] = attr;
             }              /*2           **  handle overstriking of wrapped lines-           **  via ^M if it is in a later linet           */4           if (!MOST_V_OPT && MOST_W_OPT && M_FLAG &&( 	      (beg <= M_POS && beg == end + 1))
             {i                 if (!W_LINE)                   {"&                       beg = M_POS + 1;/                       end = M_POS - b1 + e + 1;e 		      if (end > e1) end = e1;;                   }                  else                   {NJ                       if (*b1 != '\007' && *b1 != '\013' && *b1 != '\014')4                            beg = M_POS - b1 + b + 1;                       else0                            beg = M_POS - b1 + b;2                       if (beg > e1) beg = end + 1;                       else                         {j5                             end = M_POS - b1 + e + 1;;3                             if (end > e1) end = e1;;                         }[                   }                  fold = 1;                   ii_max = ii - 1;;                 if (out[0] == '\007' || out[0] == '\013' || %                     out[0] == '\014')                       ii = 1;                 else                      ii = 0;
             }i       } /* while */      if (fold) ii = ii_max + 1;       /*9     **  omit lines indented more than SELECTIVE_I_DISPLAY      */:     if ((beg > end) && SELECTIVE_I_DISPLAY && !MOST_W_OPT)       {e           ok = 1; "           if (*beg == '\n') beg++;%           while ((*beg <= ' ') && ok) 
             { (                 if (*beg != '\n') beg++;&                 if (beg >= EOB) break;%                 if ((*beg == '\n') ||iD                     (apparant_distance(beg) >= SELECTIVE_I_DISPLAY))                   {                        ok = 0;                    } 
             }            if (!ok)
             {                  ok = 3;                  while(ok--)                    {[%                       out[ii] = '.';  -                       attributes[ii++] = ' ';                    } 
             } !       } /* SELECTIVE_I_DISPLAY */        out[ii] = '\0';      return(ii);f }h     /** **  output a formatted line to the display */9 void output(char *line, int len, char *attr, char d_char)  {      intiK       i,ii,k, bold,b_len,n_len, s_len, u_len, r_len, work_len, j, mark, ok,2)       quit, count, max_col, save, dollar; #     char ch, at, out[MAX_LINE_LEN];t:     char *n_str, *b_str, *s_str, *u_str, *r_str, work[40];  <     b_str = "\033[1m";     /* 'bold'      escape sequence */     b_len = strlen(b_str);<     u_str = "\033[4m";     /* 'underline' escape sequence */     u_len = strlen(u_str);<     r_str = "\033[7m";     /* 'reverse'   escape sequence */     r_len = strlen(r_str);<     n_str = "\033[m";      /* 'normal'    escape sequence */     n_len = strlen(n_str);<     s_str = "\033[%dC";    /* 'd'x'space' escape sequence */     s_len = strlen(s_str);  
     i = 0;     ii = 0;e
     bold = 0;i
     quit = 0;m8     ok = 0;  /* 1 if ok to start filling the out line */(     max_col = COLUMN + SCREEN_WIDTH - 1;     count = 0;     dollar = 0;        /*=     **  while characters in the line still need to be counted      */I     while (ch = line[i], (i <= len) && ch != '\0' && ch != '\n' && !quit)        {            /*           **  increment count            */           count++;             /*E           **  if count is in window, ok to start filling the out line ,           **  if count exceeds window, break           */&           if (count >= COLUMN) ok = 1;%           if (count > max_col) break;h
                      /*=           **  if not Verbose mode act on character attributes            */           if (!MOST_V_OPT)
             {                  /*J                 **  does bold, underline, or reverse need to be turned on?                 */                 at = attr[i]; >                 if ((at != ' ') && (!bold || count == COLUMN))                   {_                       bold = 1; 7                       /* u, b and r have same length */ 9                       if (ok) for (j = 0; j < b_len; j++)f                         {-*                             if (at == 'b')3                               out[ii++] = b_str[j]; /                             else if (at == 'u') 3                               out[ii++] = u_str[j];l                              else3                               out[ii++] = r_str[j];                          }                                           }&                   /*K                 **  does bold, underline, or reverse need to be turned off?                  */-                 else if ((at == ' ') && bold)                    {                        bold = 0;eO                       if (ok) for (j = 0; j < n_len; j++) out[ii++] = n_str[j];;                   }                    /*<                 **  if it's not an always-explicit escape or5                 **  control character, don't count itf                 */-                 if ((ch < ' ' || ch > 126) &&OI                     (ch != '\007') && (ch != '\013') && (ch != '\014') && #                     (ch != '\033'))                    {                        count--;                   }n'             } /* if not Verbose mode */i
                      /*2           **  if ch is a space or series of spaces1           **  put spaces into out line if ok, and 1           **  assess whether dollar should be set            */           if (ch == ' ')
             {'                 j = 0;                 mark = ii;3                 /* we always make this loop once */s8                 while ((i <= len) && (line[i++] == ' '))                   {                        j++;.                       if (ok) out[ii++] = ' ';                   } &                 if (i > len) quit = 1;                 i = i - 2;                 save = count; B                 count += j - 1;  /* counted one at top of while */                                  if (!ok)                   { *                       if (count >= COLUMN)                         { #                             ok = 1; 3                             j = count - COLUMN + 1; "                             k = j;8                             while (k--) out[ii++] = ' ';                         }=                   }                  $                 if (count > max_col)                   {                        quit = 1; )                       j = max_col - save;                    }                  <                 if (ok && (j > s_len) && (count < max_col))                    {                         ii = mark;,                       sprintf(work,s_str,j);.                       work_len = strlen(work);I                       for (j = 0; j < work_len; j++) out[ii++] = work[j];b                   } )                 else if (count > max_col)                    { (                       dollar = mark + j;                   } $             } /* if ch is a space */
                      /*F           **  else, if ok to fill line and ch is ^G, ^K, ^L, a VerboseK           **  control character, or an escape that was not followed by [#m, 5 	  **  display the control char as reverse video char            */+           else if (ok && ((ch == '\007') || +                           (ch == '\013') || +                           (ch == '\014') ||e+                           (ch == '\033') || A                          ((ch < ' ' || ch > 126) && MOST_V_OPT)))/
             {u)                 for (j=0; j < r_len; j++)h'                   out[ii++] = r_str[j];                  if (ch == 127)"                   out[ii++] = '?';                 else'                   out[ii++] = ch + '@';<%                 if (count == max_col) 
 		  bold = 1;  		else+                   for (j=0; j < n_len; j++)t)                     out[ii++] = n_str[j];*
             } 
                      /*)           ** else if ok to fill line and o(           **   ( (ch is not a space) and5           **     (ch is not a Verbose control char) ) !           ** put ch into out line            */           else if (ok)
             {                  out[ii++] = ch;k
             }l                                  i++;       } /* while */           if (dollar)        {&           bold = 1;            ii = dollar;#           for (j=0; j < r_len; j++) !             out[ii++] = r_str[j];            out[ii++] = d_char;        } #     else if (ok && count > max_col)n       {  	  ii--;           if (ok && bold) %             for (j=0; j < n_len; j++) #               out[ii++] = n_str[j];            bold = 1; #           for (j=0; j < r_len; j++) !             out[ii++] = r_str[j];            out[ii++] = d_char;;       }      out[ii] = '\0';      if (ii) fputs(out,stdout);     (     if (ok && bold) fputs(n_str,stdout); } /* output */     /*2 **  have an ASCII or binary line prepared/analyzed% **  and then call the output function  */ void most_display_line() {      unsigned char *beg, *end;1     int i, len, v, t;      char buff[16];N     char the_line[MAX_LINE_LEN],  *p, the_attr[MAX_LINE_LEN], *line,*attr, ch;       line = the_line;     attr = the_attr;  @     /* This needs to be fixed for files with really big lines */     /*     **  ASCII line     */     if (!MOST_B_OPT)       {            /*-           **  fetch beginning and end of line;0           **  and set the right margin character           */N           if(extract_line(&beg, &end) && MOST_W_OPT) ch = '\\'; else ch = '>';           len = end - beg + 1;             /*!           **  if line is too longg-           **  set Verbose and display of tabs            */!           if (len > MAX_LINE_LEN)e
             {;                 v = MOST_V_OPT;n                 t = MOST_T_OPT;r                 MOST_V_OPT = 1;D                 MOST_T_OPT = 1; $                 line = (char *) beg;
             }              /*F           **  else have line analyzed for character display attributes           */8           else len = analyse_line(beg, end, line, attr);       }        /*     **  binary linei     */     else       {            ch = '$';            i = 0;           beg = C_POS;           end = C_POS + 16;n#           if (end > EOB) end = EOB;a5           while(beg < end) buff[i++] = (char) *beg++;n&           while(i < 15) buff[i++] = 0;1           len = ascii_format_line(buff,the_line);n.           i = 0; while(i<132) attr[i++] = ' ';       }c          /*      **  call the output function     */     output(line,len,attr, ch);       /*H     **  restore Verbose and tab display options for too-long ASCII lines     */     if (len > MAX_LINE_LEN)        {            MOST_V_OPT = v;i           MOST_T_OPT = t;        }t }n     /*A **  given a position in a line, return apparant distance from bol $ **  expanding tabs, etc... up to pos */) int apparant_distance(unsigned char *pos)  { 
     int i;.     unsigned char *cur_pos, *save_pos, ch, *e;     extern int W_LINE;     extern int TAB_R;s       cur_pos = C_POS;     save_pos = pos;0     C_POS = pos;     pos = beg_of_line();     e = end_of_line();     C_POS = cur_pos;  
     i = 1;&     while(ch = *pos, pos++ < save_pos)       {            /*1           **  ^H (underline/overstrike character)o           */(           if (!MOST_V_OPT && ch == '\b')
             {                  if (i > 1) i--; 
             }              /*"           **  ^M (overstrike line)           *//           else if (!MOST_V_OPT && ch == '\015') 
             {g!                 if (i > 1) i = 1;u
             }o             /*6           **  underline, bold, or reverse via <ESC>[#m           */A           else if (!MOST_V_OPT && ch == '\033' && pos <= e - 2 &&r!                    *pos == '[' &&e=                    (*(pos + 1) == '1' || *(pos + 1) == '4' || >                     *(pos + 1) == '7' || *(pos + 1) == '0') &&%                    *(pos + 2) == 'm')              i -= 3; A           else if (!MOST_V_OPT && ch == '\033' && pos <= e - 1 &&u4                    *pos == '[' && *(pos + 1) == 'm')             i -= 2;              /*            **  ^I (8 column tabs)           */>           else if (ch == '\t' && (!MOST_T_OPT || !MOST_V_OPT))
             { )                 if (MOST_W_OPT && W_LINE)                    { !                       if (i == 1) #                         i += TAB_R;'                       else<                         i = 8 * ((i - 1)/8 + 1) + 1 + TAB_R;                   }                  else.                   i = 8 * ((i - 1)/8 + 1) + 1;
             }              /*+           **  other escape or control chars            */(           else if (ch < ' ' || ch > 126)
             {                  /*D                 **  ^G (bell) , ^K (vertical tab), ^L (formfeed) andH                 **  ^[ (escape) not followed by [#m are always displayed*                 **  (as reverse video ch),E                 **  otherwise non-Verbose control chars have no widthy                 */A                 if (MOST_V_OPT || ch == '\007' || ch == '\013' || ?                                   ch == '\014' || ch == '\033')                    {0                       i++;                   } 
             }            /*           **  text character           */           else i++;        }      return (i);  }i