 /*  *  MOST:  main.c   *D  *  Modified for C SWING and GOPHER compatibility by Foteos MacridesG  *                                                MACRIDES@SCI.WFEB.EDU   */   " #define __MOST_VERSION__ "3.2.1FM" #define __MOST_USAGE__ \K         "most [-bchklnstvw] [+line] [+/string] [+s] [+d] file1 [file2 ...]"  /*K ** == Changes from original 3.01 to my 3.02 by Harry Flowers 08 Apr 1992 ==  **I **  Several bug fixes: now resets origin mode, disables and restores wrap I **      (which fixes the problem with the last line display when it's the J **      same as the terminal width), doesn't display annoying continuationK **      character on lines the same length as the screen width, and the key J **      mapping was changed so that "?" is help and the backslash "\" doesK **      the search in reverse direction (makes sense since the forwardslash 4 **      "/" does a search in the forward direction). **K ** == Changes from Harry's 3.02 to 3.02FM by Foteos Macrides 10-Oct-1992 ==  **M **  Created standalone and "for CSWING" compatible code.  For the standalone, K **      compile main.c with STANDALONE defined, then link/exe=most.exe that N **      object with those in the CSWING library which did not have it defined.N **      All quit/exit handling after a widow has been displayed is now done inM **      exit_cmd().  For the standalone, on exit the system prompt appears in M **      the most_message space, i.e., there is no scrolling due to a carriage N **      return and everything which was displayed before the exit can still be
 **      seen. N **  Implemented reading of MOST_SWITCHES and MOST_EDITOR logicals, if defined,! **      in the "for CSWING" code. L **  Changed command keys to be the same or homologous to those of CSWING and9 **      documented all commands in the quick help screen. K **  Also modified SWING_8.C and SWING_38.C so that you can call MOST with a C **      set of "selected" files and use all its windowing features. , **  Added lots of informative most_messages.O **  Implemented spawning if not captive, with an appropriate message otherwise. N **      Spawned editors are now available as in CSWING.  If MOST_EDITOR is notM **      defined, the editor defined in CSWING will be used, and if that's not L **      defined either, an "editor not defined" most_message will be issued.; **      EDT is still the default editor for the standalone. J **  Renamed some switches and toggles so that switches are all MOST_ch_OPTN **      and toggles have informative names.  Made case-sensitivity of searchesN **      a regular (-c) rather than extended (+c) switch.  Eliminated any case-I **      sensitivity for switch, toggle, or command letters throughout the  **      program.K **  If a new file is fetched from within MOST (^KG), it is now added to the K **      ring buffer, along with those from the command line or CSWING call. I **  Replaced the $ with reversed video > as the indicator of "more to the L **      right" and modified to maintain a full screen width to the > even ifH **      non-printing control characters or escape sequences are present.L **      Replaced ^ch with reversed-ch as the indicator of control charactersJ **      in Verbose ASCII mode (^ch is still used in binary mode).  Cntrl-LL **      (linefeed) and cntrl-G (bell) are always displayed rather than acted **      on in ASCII mode. H **  Replaced the \ with reversed video \ as the indicator of wrap columnI **      and improved but did not perfect handling of bolded or underlined . **      characters via ^H or ^M in Wrap mode).F **  Provided a MOST.DOC_FM with the switch/command changes documented. **E ** == Changes from 3.02FM to 3.03FM by Foteos Macrides 28-Nov-1992 ==  **F **  Fixed bug in initialization of SEARCH_STR when called from CSWING.8 **  Fixed bug getting last line of files in Binary mode.) **  Fixed bug in initialization of marks. G **  Modified Wrap mode to maintain a full screen width to the \ even if H **      non-printing control characters or escape sequences are present,I **      and to not wrap the last character in lines that are equal to the  **      screen width. I **  Corrected handling of underlining, bolding or reversing via ^H, ^M or L **      <ESC>[#m (# = 1, 4, or 7) and debugged problems with tab expansions.L **  Fixed searches to work properly in ASCII and Binary modes.  Searches areO **      disabled when the Selective Indentation Display is set, and appropriate ; **      most_messages are issued if searches are requested. 0 **  Added lots more informational most_messages. **  Updated MOST.DOC_FM. **E ** == Changes from 3.03FM to 3.04FM by Foteos Macrides 29-Jan-1993 ==  **K **  Added SecureMode extended switch (+s or +S) for use of MOST with gopher M **      client.  Disables spawning, editing (so that a SecureMode user cannot L **      fill the disk with junk copies of gopher's temporary files), and newL **      file fetches (so that only the file(s) specified on the command lineJ **      can be read).  If this version of MOST is used as the pager in theJ **      gopher client, modify display_file() in the client's ourutils.c toF **      include this switch in the pager command when the client is in **      SecureMode. J **  On VMS systems, ^M (RETURN) is now a Next Page command (as in MAIL and. **     ANU-NEWS), else it is a Scroll command.I **  Modified editor definition checks to handle inclusions of qualifiers.  **  Updated MOST.DOC_FM. **F ** == Changes from 3.04FM to 3.2.0FM by Foteos Macrides 05-Mar-1993 == **J **  Coordinated this code (as much as possible) with John Davis' MOST v3.2K **      update (FTPed from pacific.mps.ohio-state.edu in tmp/most directory L **      on 09-Feb-1993), and Martin Egger's mods to that for compiling on anH **      alpha (FTPed from ubeclu.unibe.ch as [.tools]most32_alpha.zip onG **      09-Feb-1993).  Then stripped it down, reorganized/redid it, and J **      labelled it for ease of future maintenance.  Verified compilation,/ **      linking, and execution with DECC/Alpha. J **  Incorporated keypad commands and EDT-style paging and search commands.J **      PF1 and ^X are synomyms for GOLD.  GOLD numbers and characters canI **      be entered on either the keypad or keyboard.  All previous multi- M **      character commands which began with a control character or escape are M **      now GOLD commands.  Made ^U an erase command for prompt strings.  The L **      minibuffer now handles control characters with reverse video (rather7 **      than ^ch) in prompt string entries and recalls. M **  Modified to show both the help summary (Quick Help) and MOST.DOC_FM (Full I **      Help) via single-key vs. GOLD Help commands (don't have to choose N **      just one type of help or the other at compile time).  If the MOST_HELPL **      logical is not defined, looks for MOST.DOC_FM in the directory whereH **      MOST.EXE is defined as a foreign command.  Added a -h qualifier.I **      $ most -h   puts up MOST.DOC_FM (if it's found, else a message to / **      define MOST_HELP), with SecureMode set. J **  Improved exit handling if terminal characteristics were modified whileL **      using MOST.  Tweeked up the extended commands (were ESC X, I changedM **      that to GOLD RETURN), added routine for single system command spawns, H **      and documented them.  They're disabled in SecureMode.  If the CDK **      (change default dir) extended command is used, CSWING's default dir G **      will be restored upon quiting from MOST.  Also made sure the +d 4 **      extended switch cannot be set in SecureMode.H **  Improved handling of wildcarded filenames and translations of searchM **      lists when entered on the command line or at the get new file prompt. L **  Fixed some "esoteric bugs" or "non-intuitive behavior" (according to ourG **      users 8-) in search routines.  Appear to work perfectly now for L **      search strings that include bolded, underlined, or reversed words or **      substrings. I **  Added a "naive" switch (-n) for displaying a message or title instead J **      of the device:[directory]filespec in the status line.  Messages orI **      titles can be set via a MOST_PROMPT logical.  Editing is disabledGM **      in naive mode.  Tweeked up piping of input to MOST from command files 0 **      (read the doc file for more about this).M **  Modified to handle ^[[m and ^[[0m equivalently.  Deals intelligently withkG **      status and minibuffer lines that would overrun the screen.  TheeI **      summary help now prompts for a RETURN and goes on to another pageeL **      if it doesn't fit in one screen (rather than trashing the subsequent **      MOST display).B **  Updated summary help (Quick Help) and MOST.DOC_FM (Full Help). **G ** == Changes from 3.2.0FM to 3.2.1FM by Foteos Macrides 15-Oct-1993 ==s **I **  Eliminated attach back to parent feature.  Spawns are now always to a H **      subprocess.  Otherwise, if the standalone MOST was invoked via aE **      system() call, MOST's spawn command sent you back to the mainsD **      program instead of invoking DCL, and left a dead subprocess.$ **  Updated MOST.DOC_FM (Full Help). **H **      [This is the prominent modification notice required; see below.] */ /*9                Most ---- a more/less paging type program.l  J     Copyright (C) 1991 by John E. Davis. (davis@pacific.ms.ohio-state.edu)  ;                    The following disclaimer from GNU emacs.a  ,                                  NO WARRANTY  K   BECAUSE THIS PROGRAM IS LICENSED FREE OF CHARGE, WE PROVIDE ABSOLUTELY NO G WARRANTY, TO THE EXTENT PERMITTED BY APPLICABLE STATE LAW.  EXCEPT WHEN L OTHERWISE STATED IN WRITING, JOHN E. DAVIS AND/OR OTHER PARTIES PROVIDE THISJ PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED,L INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY ANDH FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY ANDL PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE,E YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.i  M  IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL JOHN E. DAVIS, AND/OR ANYaL OTHER PARTY WHO MAY MODIFY AND REDISTRIBUTE THIS PROGRAM AS PERMITTED BELOW,I BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY LOST PROFITS, LOST MONIES, OREL OTHER SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE ORI INABILITY TO USE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEINGeL RENDERED INACCURATE OR LOSSES SUSTAINED BY THIRD PARTIES OR A FAILURE OF THEJ PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS) THIS PROGRAM, EVEN IF YOU HAVEN BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, OR FOR ANY CLAIM BY ANY OTHER PARTY.  6                         GENERAL PUBLIC LICENSE TO COPY  K   1. You may copy and distribute verbatim copies of this source file as youuL receive it, in any medium, provided that you conspicuously and appropriatelyI publish on each copy a valid copyright notice "Copyright (C) 1990 John E.eI Davis"; and include following the copyright notice a verbatim copy of the C above disclaimer of warranty and of this License.  You may charge ai= distribution fee for the physical act of transferring a copy.n  >   2. You may modify your copy or copies of this source file orC any portion of it, and copy and distribute such modifications under H the terms of Paragraph 1 above, provided that you also do the following:  B     a) cause the modified files to carry prominent notices stating>     that you changed the files and the date of any change; and  B     b) cause the whole of any work that you distribute or publish,@     that in whole or in part contains or is a derivative of thisC     program or any part thereof, to be licensed at no charge to allh?     third parties on terms identical to those contained in this0I     License Agreement (except that you may choose to grant more extensive F     warranty protection to some or all third parties, at your option).  @     c) You may charge a distribution fee for the physical act ofB     transferring a copy, and you may at your option offer warranty%     protection in exchange for a fee.a  G Mere aggregation of another unrelated program with this program (or itscJ derivative) on a volume of a storage or distribution medium does not bring1 the other program under the scope of these terms.i  I   3. You may copy and distribute this program (or a portion or derivativebK of it, under Paragraph 2) in object code or executable form under the terms K of Paragraphs 1 and 2 above provided that you also do one of the following:   D     a) accompany it with the complete corresponding machine-readable=     source code, which must be distributed under the terms ofp!     Paragraphs 1 and 2 above; or,e  B     b) accompany it with a written offer, valid for at least three=     years, to give any third party free (except for a nominalg<     shipping charge) a complete machine-readable copy of theC     corresponding source code, to be distributed under the terms ofo!     Paragraphs 1 and 2 above; or,*  E     c) accompany it with the information you received as to where theeD     corresponding source code may be obtained.  (This alternative is?     allowed only for noncommercial distribution and only if youtB     received the program in object code or executable form alone.)  J For an executable file, complete source code means all the source code forI all modules it contains; but, as a special exception, it need not includerG source code for modules which are standard libraries that accompany theo3 operating system on which the executable file runs.h  F   4. You may not copy, sublicense, distribute or transfer this programG except as expressly provided under this License Agreement.  Any attempt N otherwise to copy, sublicense, distribute or transfer this program is void andD your rights to use the program under this License agreement shall beF automatically terminated.  However, parties who have received computerD software programs from you with this License Agreement will not haveL their licenses terminated so long as such parties remain in full compliance.  G In other words, you are welcome to use, share and improve this program.yA You are forbidden to forbid anyone else to use, share and improve ; what you give them.   Help stamp out software-hoarding!  */n    ' char *MOST_VERSION = __MOST_VERSION__ ;k #include <stdio.h>
 #ifdef VMS #include <stat.h>o #elsew #include <sys/types.h> #include <sys/stat.h>r #endif #include "externs.h" #include "window.h"m #include "buffer.h"g #include "file.h"i #include "sysdep.h"c #include "most.h"i #include "display.h"  O int MOST_B_OPT      = 0;     /* display binary File                          */bO int MOST_C_OPT      = 0;     /* case-sensitive searches                      */eO int MOST_D_OPT      = 0;     /* delete file mode  (see ':D')                 */ O int MOST_H_OPT      = 0;     /* for -h switch:  most most.doc_fm             */ O int MOST_K_OPT      = 0;     /* display 8 bit unformatted (Kanji)            */rO int MOST_L_OPT      = 0;     /* use ^L (formfeed) to clear screen            */ O int MOST_N_OPT      = 0;     /* use naive prompt instead of file name        */ O int MOST_S_OPT      = 0;     /* squeeze multiple blank lines to one          */ O int MOST_T_OPT      = 0;     /* display tab as ^I-- valid only with V option */hO int MOST_V_OPT      = 0;     /* display control chars                        */ O int MOST_W_OPT      = 0;     /* wrap lines                                   */aO int STARTING_LINE   = 1;     /* starting line for initial display            */dO int EDT_DIRECTION   = 1;     /* for toggling EDT-style FORWARD/REVERSE       */bO int SEARCH_DIR      = 1;     /* for toggling direction of string searches    */oO char SEARCH_STR[136];        /* for setting starting line based on a string  */lO int SELECTIVE_I_DISPLAY = 0; /* selective indentation display                */ O int NEXT_RING_FILE  = 1;     /* for cycling through file ring                */ O int SecureMode      = 0;     /* for disabling spawn, edit, and get new file  */ O char MOST_DOCFILE[136];      /* full filespec for most.doc_fm                */l  
 #ifdef VMS #ifndef isalphac #define isalpha(x) \F       (((x >= 'A') && (x <= 'Z'))||((x >= 'a') && (x <= 'z')) ? 1 : 0) #endif #endif  $ void do_extended_switches(char *str) {.
     int i;     char ch,numstr[7];     
     i = 0;     ch = *(++str);     if ( ch == '/')b       {.#           strcpy(SEARCH_STR,++str);0       }e$     else if (ch >= '0' && ch <= '9')       {s(           while (ch >= '0' && ch <= '9')
             {e!                 numstr[i++] = ch;f                 ch = *(++str);
             }            numstr[i] = '\0';r4           (void) sscanf(numstr,"%d",&STARTING_LINE);       }.     else if (isalpha(ch))(       {p           while (isalpha(ch)) 
             {e/                 if ((ch == 'D') || (ch == 'd'))c@                   MOST_D_OPT = 1;   /* delete file mode       */4                 else if ((ch == 'S') || (ch == 's'))2 		  SecureMode = 1;   /* no spawning or editing */ 		ch = *(++str);
             }m       }y          else       { :           fprintf(stderr,"switch '+%s' not valid.\n",str);            /* exit(0); */ return;       }  }        void do_switches(char *str)f {t       while (*str != '\0')       {            switch (*str++)-
             {g               case 'b':                case 'B':nB                 MOST_B_OPT = 1; break;  /* binary display 8 bit */               case 'c':r               case 'C': E                 MOST_C_OPT = 1; break;  /* case-sensitive searches */S 	      case 'h': 	      case 'H':0 		MOST_H_OPT = 1; break;  /* most most.doc_fm */               case 'k':T               case 'K':IH 	        MOST_K_OPT = 1; break;  /* display 8 bit unformatted (Kanji) */               case 'l':                case 'L': D                 MOST_L_OPT = 1; break;  /* use ^L to clear screen */               case 'n':                case 'N': L                 MOST_N_OPT = 1; break;  /* use naive prompt w/o file name */               case 's':V               case 'S':TG                 MOST_S_OPT = 1; break;  /* replace multiple blank linesTA                                            with one blank line */                case 't':Y               case 'T':O?                 MOST_T_OPT = 1; break;  /* display tabs as ^I-- 8 		                           meaningful only with 'v' */               case 'v':G               case 'V': 4                 MOST_V_OPT = 1; break;  /* verbose--J                                            display control chars as ^ch */               case 'w':E               case 'W': A 	        MOST_W_OPT = 1; break;  /* wrap long lines in display */ 
             }        }A }E     * void find_most_docfile(char *most_program) {      char *most_docfile;L
     int i;     '     most_docfile = getenv("MOST_HELP");a     if (most_docfile == NULL)a       {e)           static char tempname[L_tmpnam];c           struct stat statb;    	  head(most_program, tempname);# 	  strcat(tempname, "most.doc_fm");E# 	  if (0 == stat(tempname, &statb))  	    {  	       most_docfile = tempname; 	    }       }o     if (most_docfile != NULL)        {c,          strcat(MOST_DOCFILE, most_docfile);
 #ifdef VMS3          for (i = 0; i < strlen(MOST_DOCFILE); i++)p9               MOST_DOCFILE[i] = toupper(MOST_DOCFILE[i]); 	          s #endif       }      else           MOST_DOCFILE[0] = '\0'; }d    8 #ifdef STANDALONE  /*** Code for standalone version ***/ /*8 **  Definition of editor used if MOST_EDITOR not defined- **  (presently VMS-specific, defaults to EDT)  */' globaldef char editor_defn[41] = "EDT";t   /*# **  Definition for captive accounts " **  make it = 1 to prohibit spawns */ globaldef int captive = 0;    int main(int argc, char *argv[]) {l     char *MOST_PROGRAM;t-     char file[136], *switches, filename[136];      int file_i,quit,i,piped,j;     unsigned long context;     extern int isatty(int);e       MOST_PROGRAM = argv[0];i$     find_most_docfile(MOST_PROGRAM);     SEARCH_STR[0] = '\0';f     piped = 0;'     switches = getenv("MOST_SWITCHES");m2     if (switches !=  NULL)  do_switches(switches);
           
     i = 1;     if (argc > 1)        {n           quit = 0;t'           while ((!quit) && (i < argc))l
             {e&                 if (argv[i][0] == '-'))                   do_switches(argv[i++]);t+                 else if (argv[i][0] == '+')i2                   do_extended_switches(argv[i++]);                 else quit = 1;
             }        }           if (MOST_H_OPT)        {r"          if (strlen(MOST_DOCFILE)) 	   {g)               strcpy(file, MOST_DOCFILE);  	      SecureMode = 1; 	   }  	 else 	   {,  	      fprintf(stderr, "\n%s\n",P "Set the environment variable 'MOST_HELP' to point to the most.doc_fm file.\n");               exit(0); 	   }t       }      else if (i == argc)p       { F           if (isatty(0))   /* 1 if stdin is a terminal, 0 otherwise */
             {                  fprintf(stderr,e2                         "MOST(%s)\n  Usage: %s\n",%                         MOST_VERSION, (                         __MOST_USAGE__);                          exit(0);
             }t*           /* assume input is from stdin */9           file[0] = '\0';  /* tells most this is stdin */e           piped = 1;       }      else       strcpy(file,argv[i]);e  #     if (SecureMode) MOST_D_OPT = 0;s     NUM_FILES = 0;     context = 0;       if (!piped && !MOST_H_OPT)       {t           file_i = i;r
 #ifdef VMS           while(i < argc)l
             {cH                 if (argv[i][0] == '.') strcpy(file,"*"); else *file = 0;1                 strcat(file,unix2vms(argv[i++]));eB                 while (expand_file_name(file, filename, &context))                   { ,                       FILE_RING[NUM_FILES] =?                           (char*) malloc(strlen(filename) + 1);u?                       strcpy(FILE_RING[NUM_FILES++], filename);H                   }a 		if (context)$ 		      lib$find_file_end(&context);
             }r           if (NUM_FILES)&             strcpy(file,FILE_RING[0]); 	  elsea             fprintf(stderr,oD 	            "%%MOST-W-NOFILES, File %s not found\n", argv[file_i]);      #elsed           j = 0;           NUM_FILES = argc - i;            while (i < argc)
             {w+                 FILE_RING[j++] = argv[i++];_
             } N           if (!NUM_FILES) fprintf(stderr,"File %s not found\n", argv[file_i]); #endif       }<  9     if (NUM_FILES || MOST_H_OPT) quit = 0; else quit = 1;h     if (!quit || piped)        {"           /*, 	  ** get size, set up esc sequences, etc...           */ 	  if (!get_terminfo());
             { =                fputs("Failed to get terminal info.", stderr);                 exit(0);s
             }  	  if (!init_most_tty())
             {;C                fputs("Failed to initialize the terminal.", stderr);O                exit(0); 
             }m           /*)           **  we're all set, let's do it!/           */#           most(file,STARTING_LINE);        }L     exit(0);+ } /*** End code for standalone version ***/     , #else  /*** Code for (CSWING) interface ***/ /*5 **  most_args[] is an array of (optionally) switches, 7 **  (optionally) extended switches, and the (required)   **  filename(s).1 **  See most_files() in SWING_38.C for more info.y */  4 void most_less(int num_most_args, char *most_args[]) {t     char *MOST_PROGRAM; -     char file[136], *switches, filename[136];p'     static int sought_most_docfile = 0;*      int file_i,quit,i,piped,j,k;     unsigned long context;     extern int isatty(int);D       /*B     **  intitialize options and toggles for each call to interface     */O     MOST_B_OPT      = 0;     /* display binary File                          */CO     MOST_C_OPT      = 0;     /* case-sensitive searches                      */TO     MOST_D_OPT      = 0;     /* delete file mode  (see ':D')                 */RO     MOST_H_OPT      = 0;     /* for -h switch:  most most.doc_fm             */eO     MOST_K_OPT      = 0;     /* display 8 bit unformatted (Kanji)            */_O     MOST_L_OPT      = 0;     /* use ^L (formfeed) to clear screen            */VO     MOST_N_OPT      = 0;     /* use naive prompt instead of file name        */xO     MOST_S_OPT      = 0;     /* selective display                            */rO     MOST_T_OPT      = 0;     /* display tab as ^I-- valid only with V option */rO     MOST_V_OPT      = 0;     /* verbose-- display control chars as ^ch       */eO     MOST_W_OPT      = 0;     /* wrap lines                                   */hO     STARTING_LINE   = 1;     /* starting line for initial display            */=O     EDT_DIRECTION   = 1;     /* for toggling EDT-style FORWARD/REVERSE       */(O     SEARCH_DIR      = 1;     /* for toggling direction of string searches    */ O     SEARCH_STR[0] = '\0';    /* for setting starting line based on a string  */hO     SELECTIVE_I_DISPLAY = 0; /* selective indentation display                */ O     NEXT_RING_FILE  = 1;     /* for cycling through file ring                */wO     SecureMode      = 0;     /* for disabling both spawning and editing      */        if (!sought_most_docfile)"       {%
 #ifdef VMS5          if ((MOST_PROGRAM = getenv("most")) != NULL) H 	   while (*MOST_PROGRAM == '$' || *MOST_PROGRAM == ' ') MOST_PROGRAM++; #else           MOST_PROGRAM = NULL;  #endif)          find_most_docfile(MOST_PROGRAM);  	 sought_most_docfile = 1;       }T          piped = 0;'     switches = getenv("MOST_SWITCHES");'2     if (switches !=  NULL)  do_switches(switches);  
     i = 0;
     quit = 0;s*     while ((!quit) && (i < num_most_args))       {:%           if (most_args[i][0] == '-')t(             do_switches(most_args[i++]);*           else if (most_args[i][0] == '+')1             do_extended_switches(most_args[i++]);            else quit = 1;       }        NUM_FILES = 0;     context = 0;       if (MOST_H_OPT)^       {r"          if (strlen(MOST_DOCFILE)) 	   { )               strcpy(file, MOST_DOCFILE);O 	      SecureMode = 1; 	      MOST_D_OPT = 0; 	   }  	 else 	   {e  	      fprintf(stderr, "\n%s\n",P "Set the environment variable 'MOST_HELP' to point to the most.doc_fm file.\n");               return;  	   }        }n     else       {          file_i = i;Y
 #ifdef VMS          while(i < num_most_args)           { I             if (most_args[i][0] == '.') strcpy(file,"*"); else *file = 0;n2             strcat(file,unix2vms(most_args[i++]));>             while (expand_file_name(file, filename, &context))               { L                 FILE_RING[NUM_FILES] = (char*) malloc(strlen(filename) + 1);9                 strcpy(FILE_RING[NUM_FILES++], filename);                }p 	    if (context)l% 	        lib$find_file_end(&context);            }_         if (NUM_FILES)&             strcpy(file,FILE_RING[0]);         else             fprintf(stderr,(F 	         "%%MOST-W-NOFILES, File %s not found\n", most_args[file_i]); #else          j = 0;&         NUM_FILES = num_most_args - i;!         while (i < num_most_args)s           {e,             FILE_RING[j++] = most_args[i++];           }          if (!NUM_FILES)e> 	    fprintf(stderr,"File %s not found\n", most_args[file_i]); #endif       }   #     if (SecureMode) MOST_D_OPT = 0;i  9     if (NUM_FILES || MOST_H_OPT) quit = 0; else quit = 1;p     if (!quit || piped)I       {o           /*, 	  ** get size, set up esc sequences, etc...           */ 	  if (!get_terminfo()) 
             {S=                fputs("Failed to get terminal info.", stderr);i                return;
             }d 	  if (!init_most_tty())
             {uC                fputs("Failed to initialize the terminal.", stderr);                 return; c
             }e           /*)           **  we're all set, let's do it!;           */#           most(file,STARTING_LINE);*       }R     return;r }l2 #endif   /*** End code for (CSWING) interface ***/