 /*  *  MOST:  window.c   *D  *  Modified for C SWING and GOPHER compatibility by Foteos MacridesG  *                                                MACRIDES@SCI.WFEB.EDU   */    #include <stdio.h> #include <ctype.h> #include "externs.h" #include "window.h"  #include "line.h"  #include "display.h" #include "sysdep.h"    Window *WIN; Window *TOP_WIN; int COLUMN = 1;  int BEEP_MINI_B = 0; int MINIBUFFER_SELECTED = 0;
 int CURS_ROW; 
 int CURS_COL;  unsigned char *CURS_POS;  * int read_string(char *str, int prompt_len) {      char ch, chn;      int i, max_length, ii;  /     max_length = SCREEN_WIDTH - prompt_len - 1;      i = strlen(str);     do         {            ch = getkey(); top:      switch (ch)  	  {#           case '\012': case '\015':            /**           ** ^J or ^M terminate the string#           ** (also KP ENTER, below)            */
             {                 break; "             } /** KB terminate **/                        case '\b': case 127: 	  /* 9 	  ** backspace or delete remove the preceding character, %           ** (also LEFT_ARROW, below)  	  */ 
             {                 if (i > 0)                   {+                     fputs("\b \b", stdout);                      i--;                  }                /* .                ** nothing to delete, ring bell                */ *                else fputc('\007', stdout);                break; )             } /** backspace or delete **/              case '\007': 	  /*  	  ** ^G aborts  	  */  	    {5                fputc('\007', stdout); /* ring bell */                 return(-1);             } /** abort **/              case '\025': 	  /* + 	  ** ^U erases currently displayed string. - 	  **    Will treat as abort if no characters . 	  **    are entered before RETURN of KP ENTER 	  */ 
             {                 while (i)                  {+                     fputs("\b \b", stdout);                      i--;                  }                break;              } /** erase **/  	      	  case '\033':  	  /* . 	  ** ESC, get another character and check for( 	  **      keypad or function key entry,! 	  **      else treat as 'ESC ch'  	  */ 
             {                 ii = 0;"                if (i < max_length)                  {-                     fputs("\033[7m", stdout); & 	            fputc((ch + '@'),stdout);-                     fputs("\033[m",  stdout); "                     str[i++] = ch;                     ii++;                   }                                 ch = getkey();                 switch (ch)                {                case 'O':                /* #                **  check for KP key                 */                   {'                     if (i < max_length)                        { 7                          fputc(str[i++] = 'O', stdout);                           ii++;                       }   *                     switch (ch = getkey())                     {                      case 'M':                      /*7                     ** KP ENTER was pressed originally, #                     ** so terminate                      */                       { "                          i  -= ii; 			 ch = '\015';%                          goto bottom; ,                       } /** KP terminate **/                       <                     case 'P': case 'Q': case 'R': case 'S':                      /*                      ** PF1 - PF4                     */                       { "                          i  -= ii;#                          while (ii)                             {5                               fputs("\b \b", stdout); #                               ii--;                             }.                          fputc('\007',stdout);%                          goto bottom; (                       } /** PF1 - PF4 */                       <                     case 'w': case 'x': case 'y': case 'l': <                     case 't': case 'u': case 'v': case 'm': 2                     case 'q': case 'r': case 's': 2                     case 'p':           case 'n':                      /*:                     ** other KP key was pressed originally                     */                       { "                          i  -= ii;#                          while (ii)                             {5                               fputs("\b \b", stdout); #                               ii--;                             },                          if (i < max_length)C                               fputc(str[i++] = (ch -= 64), stdout);                           else 4                               fputc('\007', stdout);%                          goto bottom; 4                       } /** KP key, not KP ENTER **/                                            default:                       { "                          goto top;6                       } /** ESC O and not a KP key **/                     }                      break;"                  } /*** ESC O ***/                                       case '[':                /* 1                ** ESC [, put it out and check for 1                **        an arrow or function key                 */                   {'                     if (i < max_length)                        { 7                          fputc(str[i++] = '[', stdout);                           ii++;                       }   *                     switch (ch = getkey())                     { ;                     case 'A': case 'B': case 'C': case 'D':                      /*:                     ** an ARROW key was pressed originally                     */                       { @                          if (ch == 'D') /* LEFT_ARROW deletes */                            {&                               i -= ii;(                               while (ii)!                                 { :                                    fputs("\b \b", stdout);(                                    ii--;!                                 } (                               if (i > 0)!                                 { :                                    fputs("\b \b", stdout);'                                    i--; !                                 } "                               else9                                    fputc('\007', stdout); *                               goto bottom;                            }1                          else /** others beep **/                             {&                               i -= ii;(                               while (ii)!                                 { :                                    fputs("\b \b", stdout);(                                    ii--;!                                 } 4                               fputc('\007', stdout);*                               goto bottom;                            })                       } /** ARROW key **/                        E                     case '1': case '2': case '3': case '4': case '5': ;                     case '6': case '7': case '8': case '9':                      /*.                     ** check for function keys                     */                       { ,                          if (i < max_length)                            {;                               fputc(str[i++] = ch, stdout); #                               ii++;                             }                             "                          chn = ch;4                          if ((ch = getkey()) == '~')                            {&                               i -= ii;(                               while (ii)!                                 { :                                    fputs("\b \b", stdout);(                                    ii--;!                                 } 4                               fputc('\007', stdout);*                               goto bottom;.                            } /** ESC [ # ~ **/L                          else if (isalnum(ch) && (chn == '1' || chn == '2'))                            {1                               if (i < max_length) !                                 { @                                    fputc(str[i++] = ch, stdout);(                                    ii++;!                                 }                            9                               if ((ch = getkey()) == '~')h!                                 {i+                                    i -= ii;;-                                    while (ii)M&                                      {?                                         fputs("\b \b", stdout); -                                         ii--; &                                      }9                                    fputc('\007', stdout); /                                    goto bottom;h4                                 } /** ESC [ ## ~ **/"                               else!                                 {t,                                    goto top;5                                 } /** ESC [ ## ch **/k                            }                          else                             {'                               goto top;e/                            } /** ESC [ # ch **/,                          break; 6                       } /** check for function key **/                                              default:                       {}"                          goto top;)                       } /** ESC [ ch **/                       }                      break;:                  } /** check for arrow or function key **/                                   default:                   {                     goto top;c.                  } /** ESC ch, not O nor [ **/                }                break;*             } /** ESC **/:                        case '`':            /*           ** backquoted insert           */
             { #                if (i >= max_length)R                  {*                     fputc('\007', stdout);                      goto bottom;                  }                ch = getkey();                 str[i++] = ch;e.                if ((ch < ' ') || (ch == 127))                   {@                     if (ch == 127) ch = '?'; else ch = ch + '@';A                     fputs("\033[7m", stdout); /* reverse video */ %                     fputc(ch,stdout);;B                     fputs("\033[m",  stdout); /* restore normal */                  }                else                   {&                     fputc(ch, stdout);                  }                break; '             } /** backquoted insert **/                         default:           /*           ** single character            */
             { #                if (i >= max_length)                   {*                     fputc('\007', stdout);                      goto bottom;                  }N                if ((ch < ' ' || ch == 127) && (ch != '\012' && ch != '\015'))                   {"                     str[i++] = ch;@                     if (ch == 127) ch = '?'; else ch = ch + '@';A                     fputs("\033[7m", stdout); /* reverse video */ %                     fputc(ch,stdout);KB                     fputs("\033[m",  stdout); /* restore normal */                  }5                else if (ch != '\012' && ch != '\015')                   {1                     fputc(str[i++] = ch, stdout);                   }                break;/&             } /** single character **/           }' bottom:   fflush(stdout);'       } )     while (ch != '\012' && ch != '\015');P            /**     ** if str was erased and not replaced,     ** treat as abort      */     if (i == 0 && strlen(str))       { ) 	  fputc('\007', stdout); /* ring bell */  	  return(-1);       }      /*'     ** else terminate and return length-     */     str[i] = '\0';     return(i); }     & void most_message(char *what, int how) {      strcpy(MINI_BUF,what);$     if (strlen(what) > SCREEN_WIDTH)%        MINI_BUF[SCREEN_WIDTH] = '\0'; 3     if (how) BEEP_MINI_B = 1; else BEEP_MINI_B = 0;  }    void select_minibuffer() {a$     if (MINIBUFFER_SELECTED) return;     MINIBUFFER_SELECTED = 1;'     set_scroll_region(1,SCREEN_HEIGHT);      goto_rc(SCREEN_HEIGHT,1);      fflush(stdout);  }    void exit_minibuffer() {r%     if (!MINIBUFFER_SELECTED) return;      MINIBUFFER_SELECTED = 0;)     set_scroll_region(WIN->top,WIN->bot);      fflush(stdout);  }   - /* put out string, reversing control chars */ % void nicely_puts(char *str, FILE *fp)  {      while (*str != '\0')       { ,           if ((*str < ' ') || (*str == 127))
             {)$                 fputs("\033[7m",fp);J                 if (*str != 127) fputc(*str + '@',fp); else fputc('?',fp); 		fputs("\033[m", fp);
             }t           else fputc(*str,fp);           str++;       }  }    void put_message() {T     select_minibuffer();     delete_line(1); *     if (BEEP_MINI_B) fputc('\007',stdout);     BEEP_MINI_B = 0;B     if (*MINI_BUF != '\0') nicely_puts((char *) MINI_BUF, stdout);     exit_minibuffer(); }   0 /* puts 'what in the minibuffer to be edited. */" /* returns number of chars read */2 int read_from_minibuffer(char *prompt, char *what) {*     int i, prompt_length;c     char str[136];          str[0] = '\0';     select_minibuffer();  >     if ((prompt_length = strlen(prompt)) < (SCREEN_WIDTH - 2))          fputs(prompt, stdout);      else       { *          prompt_length = SCREEN_WIDTH - 2;,          for (i = 0; i < prompt_length; i++)$            fputc(prompt[i], stdout);       }        if (*what != '\0')       { A          if ((prompt_length + strlen(what)) < (SCREEN_WIDTH - 1))             {'               nicely_puts(what,stdout);r               strcpy(str,what);             }
          else             {H               for (i = 0; i < ((SCREEN_WIDTH - 1) - prompt_length); i++)                 { *                    fputc(what[i], stdout);$                    str[i] = what[i];                 }                str[i] = '\0';           }b       }o       fflush(stdout); (     i = read_string(str, prompt_length);      if (i > 0) strcpy(what,str);     delete_line(1);      exit_minibuffer();     return(i); }         void clear_minibuffer()u {"     MINI_BUF[0] = '\0';      BEEP_MINI_B = 0;     put_message(); }      int get_scroll(int *line)  { H     /* line is the line we want at the topo of the window if possible */#     int dtop, dbot,n,top,bot,wsize;        top = WIN->beg_line;G     wsize = WIN->bot - WIN->top; /* actually 1 less than window size */      bot = top + wsize;  #     if ((*line == 1) && (top == 1));       { +           most_message("Top of Buffer.",1);            return(0);       }      (     /* handles endof file in a window */,     if ((bot > NUM_LINES) && *line > C_LINE)       {            *line = top;+           most_message("End of Buffer.",1);            return(0);       }      0     if (NUM_LINES <= wsize)     /* short file */       {            *line = 1;<           most_message("Entire Buffer is in the window.",1);           return(0);       }a       dtop = top - 1;      dbot = NUM_LINES - bot;e     n = *line - top;       if ((n>0) && (dbot < n))       {*           n = dbot;e           *line = top + n;3           if (!n) most_message("End of buffer.",1);        }l'     else if ((n < 0) && (dtop + n < 0))        {            n = -dtop;3           if (!n) most_message("Top of buffer.",1);            *line = n + top;       }}     return(n); }      void update_window(int line) {c+     int n,max_n, save_line, save_col, npos;g     unsigned char *save_pos;       if (COLUMN != WIN->col)        { %           if (COLUMN < 1) COLUMN = 1; !           if (COLUMN != WIN->col) 
             { O                 save_pos = CURS_POS; save_line = CURS_ROW; save_col = CURS_COL;                   redraw_window();!                 update_status(0); 4                 WIN->curs_pos = CURS_POS = save_pos;6                 WIN->curs_line = CURS_ROW = save_line;4                 WIN->curs_col = CURS_COL = save_col;
             }            return;h       })            n = get_scroll(&line);      max_n = WIN->bot - WIN->top;     if (abs(n) > max_n)        {            goto_line(line);           redraw_window();           update_status(0);            return;        }i     if (!n) return;        goto_rc(1,1);      forward_line(n);     WIN->beg_pos = C_POS;      WIN->beg_line = C_LINE;'       if (n>0)       {            npos = 1;            delete_nlines(n);i1           goto_rc(WIN->bot - WIN->top - n + 2,1);(&           forward_line(max_n - n + 1);       }      else       {            npos = 0;(7           CURS_ROW = 1; CURS_COL = 1; CURS_POS = C_POS;            n = -n;            reverse_index(n);        }      n = n - 1;     most_display_line();     while(n--)       {            forward_line(1);           fputc('\n',stdout);            most_display_line();       }      if (npos)        { 
           0           CURS_ROW = C_LINE - WIN->beg_line + 1;)           CURS_COL = 1; CURS_POS = C_POS;        }S          C_POS = WIN->beg_pos;      C_LINE = WIN->beg_line;      update_status(0);      fflush(stdout);  }   8 /* updates current window as well as scroll lock ones */J /* Although current window is update in an absolute fashion, scroll locked,    ones are updated in a relative fashion */ void update_windows(int line)  {      int dline,flg;     Window *w;          dline = line - C_LINE;     update_window(line);     if (!WIN->lock) return;      flg = 0;     w = WIN;$     while(WIN = WIN->next, WIN != w)       {f           if (WIN->lock)
             {                  flg = 1;                  set_window(WIN);&                 line = C_LINE + dline;$                 update_window(line);
             }        }      WIN = w;     if (flg) set_window(WIN);  }      void redraw_window() {      int n,t;     t = WIN->top;      if (t == 1) clear_window();      goto_rc(1, 1);     n = WIN->bot - WIN->top;;     if ((C_LINE + n) > NUM_LINES) goto_line(NUM_LINES - n); 4     WIN->curs_pos = CURS_POS = WIN->beg_pos = C_POS;     WIN->beg_line = C_LINE;      WIN->col = COLUMN;!     WIN->curs_col = CURS_COL = 1;|"     WIN->curs_line = CURS_ROW = 1;     if (t != 1) delete_line(1);)     most_display_line();     while(n--)       {            fputc('\n',stdout);v%           if (t != 1) delete_line(1);t3           if (forward_line(1)) most_display_line();s       }*                   C_POS = WIN->beg_pos;      C_LINE = WIN->beg_line;  }   3 /* associates current window with current buffer */  void save_win_flags(Window *w) {      w->flags = 0;u,     if (MOST_V_OPT) w->flags |= _MOST_V_OPT;,     if (MOST_B_OPT) w->flags |= _MOST_B_OPT;,     if (MOST_T_OPT) w->flags |= _MOST_T_OPT;,     if (MOST_W_OPT) w->flags |= _MOST_W_OPT;-     if (MOST_S_OPT) w->flags |= _MOST_SQ_OPT;      w->n_lines = NUM_LINES;;%     w->display = SELECTIVE_I_DISPLAY;  }h   void window_buffer() {      WIN->beg_line = C_LINE;      WIN->beg_pos = C_POS;      WIN->col = COLUMN;     WIN->buf = BUF;      SELECTIVE_I_DISPLAY = 0;     save_win_flags(WIN); }    void clear_window(), {d     int i,n;     i = WIN->top;      n = WIN->bot - WIN->top;     if (i == 1)        {t8           goto_rc(WIN->bot - WIN->top + 1,SCREEN_WIDTH);           clr_bos();       }h     else       { &           goto_rc(i - WIN->top + 1,1);           delete_line(1);c           while(n--)
             { #                 fputc('\n',stdout);                  delete_line(1);'
             }u       })           goto_rc(i - WIN->top + 1,1);     fflush(stdout);  }    void restore_win_flags() {d*     MOST_V_OPT = WIN->flags & _MOST_V_OPT;*     MOST_B_OPT = WIN->flags & _MOST_B_OPT;*     MOST_T_OPT = WIN->flags & _MOST_T_OPT;*     MOST_W_OPT = WIN->flags & _MOST_W_OPT;+     MOST_S_OPT = WIN->flags & _MOST_SQ_OPT;      NUM_LINES = WIN->n_lines;i'     SELECTIVE_I_DISPLAY = WIN->display;  }     " Window *make_window(int r1,int r2) {f
     int i;     Window *new;,     new = (Window *) malloc(sizeof(Window));'     new->status = (char *) malloc(136);B>     for (i = 0; i <= SCREEN_WIDTH; i++) new->status[i] = '\0';     new->col = COLUMN;     new->top = r1;     new->bot = r2;     new->lock = 0;     save_win_flags(new);     return(new); }h   void init_display()e {_
     int i;4     fputs("\033[?6h",stdout); /* relative origins */5     TOP_WIN = WIN = make_window(1,SCREEN_HEIGHT - 2);N      WIN->prev = WIN->next = WIN;
     cls();*     set_scroll_region(WIN->top, WIN->bot);     goto_rc(1,1);s     fflush(stdout);  }h   void reset_display() { 8     fputs("\033[?6l",stdout);   /* normal origin mode */'     set_scroll_region(1,SCREEN_HEIGHT);;     goto_rc(SCREEN_HEIGHT,1);2     fflush(stdout);p }e  # void update_status1(int new_status)p {      char str[30], ch;      static char new[136];      int i,ii,r,x,line_p = 60;o       r = WIN->bot + 1;      goto_rc(r,1);;       i = ii = 0;)9     if (WIN->lock) new[ii++] = '*'; else new[ii++] = ' ';N     ?     while(ch = WIN->buf->file[i++], ch != '\0') new[ii++] = ch;o  '     while(ii < line_p) new[ii++] = ' ';   @     x = (C_LINE + WIN->bot - WIN->top) * 100; x = x / NUM_LINES;  9     /* for files with end of file above the bottom row */ 9     /*   (due to window manipulations)                 */      if (x > 100) x = 100;t0     sprintf(str,"(%d,%d) %d%%",C_LINE,COLUMN,x);;     i = 0; while(ch = str[i++], ch != '\0') new[ii++] = ch;)  -     while(ii < SCREEN_WIDTH) new[ii++] = '-';S     new[SCREEN_WIDTH] = '\0';(     set_attribute(7);h     if (new_status)u       fputs(new,stdout);     else)       smart_puts(new,WIN->status,stdout);i     set_attribute(0);l     strcpy(WIN->status,new); }   " void update_status(int new_status) {h       C_LINE = WIN->beg_line;c     C_POS = WIN->beg_pos;}'     set_scroll_region(1,SCREEN_HEIGHT);      update_status1(new_status);H)     set_scroll_region(WIN->top,WIN->bot);      fflush(stdout);  }f  H /* splits window-- no screen update, does not affect scrolling region */ int split_window() {[     Window *new, *old;     int b2,t2,b1, line;s       b2 = WIN->bot;'     b1 = (WIN->bot + WIN->top) / 2 - 1;      t2 = b1 + 2;2     if ((b1 == WIN->top) || (t2 == b2)) return(0);  )     /* line is top line of new window. */e)     line = WIN->beg_line + t2 - WIN->top;P     old = WIN;     WIN->bot = b1;     new = make_window(t2,b2);      /* add to ring */e     WIN->next->prev = new;     new->next = WIN->next;     new->prev = WIN;     WIN->next = new;       new->beg_line = line;z     new->buf = BUF;o;     /* new window status line is at same position as old */s$     strcpy(new->status,WIN->status);     return(1); }         void two_windows() {f
     int line;      Window *new, *old;      if (!split_window()) return;       old = WIN;     new = WIN->next;     line = new->beg_line; /     if (line + new->bot - new->top > NUM_LINES)a       {f           other_window(1);?           /* since split window left new window undefined... */t           C_POS = old->beg_pos;n!           C_LINE = old->beg_line;i3           if (NUM_LINES <= new->bot - new->top + 1);
             { +                 C_LINE = new->beg_line = 1;t0                 C_POS = new->beg_pos = BUF->beg;                  redraw_window();!                 update_status(0); 
             } $           else if (line > NUM_LINES)
             {e;                 goto_line(NUM_LINES - new->bot + new->top);o%                 WIN->beg_pos = C_POS; '                 WIN->beg_line = C_LINE;o                  redraw_window();!                 update_status(0);c             }    s           else
             {                   goto_line(line);%                 WIN->beg_pos = C_POS; '                 WIN->beg_line = C_LINE; ?                 update_window(NUM_LINES - new->bot + new->top);p
             }s           WIN->curs_line = 1; !           WIN->curs_col = COLUMN;w            WIN->curs_pos = C_POS;           other_window(-1);I       }o     else       {_           WIN = new;4           (void) forward_line(line - old->beg_line);           new->beg_pos = C_POS;_!           new->beg_line = C_LINE;u           new->curs_line = 1; !           new->curs_col = COLUMN;-            new->curs_pos = C_POS;           update_status(0);            WIN = old;       }    w     update_status(1);a }s   void expand_window1(int dn)  {      int l, save_top, save_line;      unsigned char *save_pos;  L     /* l is line after last line of current window (where status line is) */0     l = WIN->beg_line + WIN->bot - WIN->top + 1;     save_top = WIN->top;     WIN->top = WIN->bot + 1;     WIN->bot = WIN->bot + dn;e*     set_scroll_region(WIN->top, WIN->bot);     if (l > NUM_LINES)       {            clear_window();1       }S     else       { ?           /* should add something here for smarter scrolling...;F              if ((WIN->next->BUF == BUF) && (l >= WIN->next->beg_line)7              && (l <= (WIN->next->beg_line + WIN->next)d              */                             save_line = C_LINE;            save_pos = C_POS;-           goto_line(l);            redraw_window();-           WIN->beg_line = C_LINE = save_line; *           WIN->beg_pos = C_POS = save_pos;       }      WIN->top = save_top;*     set_scroll_region(WIN->top, WIN->bot); }    void one_window()o {      Window *w, *tmp;
     int diff;t     !     if (WIN->next == WIN) return;a     w = WIN;     WIN = WIN->next;3     /* delete other windows preserving the ring! */      while(WIN != w)        {i2           free_window_buffer(); /* needs a ring */           tmp = WIN->next;B           /* if this is the bottom window, save its status line */<           if (tmp == TOP_WIN) strcpy(w->status,WIN->status);            tmp->prev = WIN->prev;            WIN->prev->next = tmp;           free(WIN);           WIN = tmp;       }      WIN = w;3     /* slide the window to the top and expand it */      diff = WIN->top - 1;
     if (diff),       { 1           set_scroll_region(1,SCREEN_HEIGHT - 2);            goto_rc(1,1);I           delete_nlines(diff);           WIN->top = 1;o           WIN->bot -=  diff;           TOP_WIN = WIN;       }o1     expand_window1(SCREEN_HEIGHT - 2 - WIN->bot);c     update_status(0);c }_  
            void set_window(Window *w) {R     WIN = w;     CURS_ROW = WIN->curs_line;     CURS_COL = WIN->curs_col;h     CURS_POS = WIN->curs_pos;p     C_LINE = WIN->beg_line;      C_POS = WIN->beg_pos;t     COLUMN = WIN->col;     BUF = WIN->buf;_     switch_to_buffer(BUF);)     set_scroll_region(WIN->top,WIN->bot);I     restore_win_flags();     fflush(stdout);n }i   void other_window(int n) {o     if (!n) return;d     WIN->beg_pos = C_POS;0     WIN->curs_pos = CURS_POS;s     WIN->curs_line = CURS_ROW;     WIN->curs_col = CURS_COL;      WIN->beg_line = C_LINE;|     save_win_flags(WIN);     if (n < 0)"       while (n++) WIN = WIN->prev;     else"       while (n--) WIN = WIN->next;     set_window(WIN); }s      , /* kills window by moving lower window up */ void delete_as_top_window()  {I     int t1,t2,b1,b2;     t1 = WIN->top;     t2 = WIN->next->top;     b1 = WIN->bot;     b2 = WIN->next->bot;      WIN->prev->next = WIN->next;      WIN->next->prev = WIN->prev;  0     /* scroll contents of window below to top */     set_scroll_region(t1,b2);      goto_rc(1,1);t     delete_nlines(t2 - t1);;     other_window(1);     WIN->top = t1;     WIN->bot = b2 - t2 + t1;"     expand_window1(b2 - WIN->bot);     update_status(0);  }l  E /* free buffer for this window if no other windows are viewing it. */  void free_window_buffer()  {      Window *w;     int f = 1;     w = WIN;     WIN = w->next;     while((WIN != w) && f)       {a:           if (!strcmp(WIN->buf->file,w->buf->file)) f = 0;           WIN = WIN->next;       }      WIN = w;     if (f) free(WIN->buf); }      void delete_window() {M     int new_b, old_b;O     Window *w;          w = WIN;!     if (WIN->next == WIN) return;E     free_window_buffer();s     if (WIN->next != TOP_WIN)n       {1           if (WIN == TOP_WIN)i
             { '                 delete_as_top_window(); >                 TOP_WIN = WIN;  /* not anymore, this one is */
             }+           else#             delete_as_top_window(); 
                      free(w);           return;        }a     old_b = WIN->top - 2;u     new_b = WIN->bot;i     other_window(-1);n"     expand_window1(new_b - old_b);<     strcpy(WIN->status,w->status); /* share the same line */          WIN->next = w->next;     WIN->next->prev = WIN;     free(w);     update_status(0);I }b   void redraw_display()  {      Window *w;     int n,t;6     fputs("\033[?6h",stdout);   /* relative origins */'     set_scroll_region(1,SCREEN_HEIGHT);o
     cls();     save_win_flags(WIN);     w = WIN;     do       {u           WIN = WIN->next;           t = WIN->top;            goto_rc(t, 1);           C_POS = WIN->beg_pos; !           C_LINE = WIN->beg_line;I           COLUMN = WIN->col;%           switch_to_buffer(WIN->buf);c           restore_win_flags();"           n = WIN->bot - WIN->top;           most_display_line();           while(n--)
             {_#                 fputc('\n',stdout);N9                 if (forward_line(1)) most_display_line();*
             } !           C_LINE = WIN->beg_line;            C_POS = WIN->beg_pos;a           update_status1(1);       }      while(WIN != w);     set_window(w); }"   void toggle_lock() {      WIN->lock = !(WIN->lock);      update_status(0);  } 