#ifndef __IF_ARP_LOADED
#define __IF_ARP_LOADED 1
/****************************************************************************
**
**  <if_arp.h> - Structures for the Address Resolution Protocol
**
*****************************************************************************
**  Header is nonstandard
*****************************************************************************
**
**  Copyright Digital Equipment Corporation 1993, 1995. All rights reserved.
**
**  Restricted Rights: Use, duplication, or disclosure by the U.S.
**  Government is subject to restrictions as set forth in subparagraph
**  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
**  52.227-14 Alt. III, as applicable.
**
**  This software is proprietary to and embodies the confidential
**  technology of Digital Equipment Corporation. Possession, use, or
**  copying of this software and media is authorized only pursuant to a
**  valid written license from Digital or an authorized sublicensor.
**
******************************************************************************
**
**  Copyright (c) 1982, 1993 Regents of the University of California.
**  All rights reserved.  The Berkeley software License Agreement
**  specifies the terms and conditions for redistribution.
**
**      if_arp.h           8.1 (Berkeley) 6/10/93
**
******************************************************************************
*/

/*
**  All includes of other header files must be done prior to altering the
**  pointer size mode.
*/
#include <socket.h>


#pragma __nostandard
#ifdef __cplusplus
    extern "C" {
#endif


/*
**  Ensure that regardless of user /pointer_size usage, we begin processing
**  using a 32 bit pointer context.
*/
#if __INITIAL_POINTER_SIZE
#   if (__VMS_VER < 70000000) || !defined __ALPHA
#      error " Pointer size usage not permitted before OpenVMS Alpha V7.0"
#   endif
#   pragma __pointer_size __save
#   pragma __pointer_size 32
#endif


/*
**  All structures should be member aligned on natural boundaries
*/
#pragma __member_alignment __save
#pragma __member_alignment


/*
**  External model of relaxed refdef
*/
#pragma __extern_model __save
#pragma __extern_model __relaxed_refdef


/*
**  Address Resolution Protocol.
**
**  See RFC 826 for protocol description.  ARP packets are variable in
**  size; the arphdr structure defines the fixed-length portion.  Protocol
**  type values are the same as those for 10 Mb/s Ethernet.  It is followed
**  by the variable-sized fields ar_sha, arp_spa, arp_tha and arp_tpa in
**  that order, according to the lengths specified.  Field names used
**  correspond to RFC 826.
*/
struct  arphdr {
    u_short ar_hrd;         /* format of hardware address */
    u_short ar_pro;         /* format of protocol address */
    u_char  ar_hln;         /* length of hardware address */
    u_char  ar_pln;         /* length of protocol address */
    u_short ar_op;          /* one of: */

/*
**  The remaining fields are variable in size, according to the sizes above.
**
**      u_char  ar_sha[];          sender hardware address
**      u_char  ar_spa[];          sender protocol address
**      u_char  ar_tha[];          target hardware address
**      u_char  ar_tpa[];          target protocol address
*/
};

#define ARPHRD_ETHER    1       /* ar_hrd - ethernet hardware address    */
#define ARPHRD_802      6       /* ar_hrd - 802 net hardware address     */
#define ARPOP_REQUEST   1       /* ar_op  - request to resolve address   */
#define ARPOP_REPLY     2       /* ar_op  - response to previous request */


/*
**  For indexing into arbitrary ha/pa ARP headers
*/
#define AR_SHA(ah)      ((u_char *)((ah)+1))
#define AR_SPA(ah)      (AR_SHA(ah)+(ah)->ar_hln)
#define AR_THA(ah)      (AR_SPA(ah)+(ah)->ar_pln)
#define AR_TPA(ah)      (AR_THA(ah)+(ah)->ar_hln)


/*
**  ARP ioctl request
*/
struct arpreq {
    struct sockaddr arp_pa;       /* protocol address */
    struct sockaddr arp_ha;       /* hardware address */
    int arp_flags;                /* flags            */
};


/*
**  arp_flags and at_flags field values
*/
#define ATF_INUSE       0x01    /* entry in use                           */
#define ATF_COM         0x02    /* completed entry (enaddr valid)         */
#define ATF_PERM        0x04    /* permanent entry                        */
#define ATF_PUBL        0x08    /* publish entry (respond for other host) */
#define ATF_USETRAILERS 0x10    /* has requested trailers                 */
#define ATF_USE802      0x20    /* host using 802 framing                 */
#define ATF_STALE       0x0100  /* entry needs to be refreshed            */
#define ATF_DEAD        0x0200  /* entry (host) failed to refresh         */

#define ATF_CANTCHANGE  (0xff00|ATF_INUSE|ATF_COM)


/*
**  Restore the users pointer context
*/
#if __INITIAL_POINTER_SIZE
#   pragma __pointer_size __restore
#endif

#ifdef __cplusplus
    }
#endif
#pragma __member_alignment __restore
#pragma __extern_model __restore
#pragma __standard
#endif  /* __IF_ARP_LOADED  */
