#ifndef __IOCTL_LOADED
#define __IOCTL_LOADED 1
/****************************************************************************
**
**  <ioctl.h> - I/O controls for special files
**
*****************************************************************************
**  Header is nonstandard
*****************************************************************************
**
**  Copyright Digital Equipment Corporation 1993, 1995. All rights reserved.
**
**  Restricted Rights: Use, duplication, or disclosure by the U.S.
**  Government is subject to restrictions as set forth in subparagraph
**  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
**  52.227-14 Alt. III, as applicable.
**
**  This software is proprietary to and embodies the confidential
**  technology of Digital Equipment Corporation. Possession, use, or
**  copying of this software and media is authorized only pursuant to a
**  valid written license from Digital or an authorized sublicensor.
**
******************************************************************************
**
**  Copyright (c) 1982, 1994 Regents of the University of California.
**  All rights reserved.  The Berkeley software License Agreement
**  specifies the terms and conditions for redistribution.
**
**      ioctl.h          8.6 (Berkeley) 3/28/94
**
******************************************************************************
*/
 
/*
**  All includes of other header files must be done prior to altering the
**  pointer size mode.
*/
#include <if.h>
#include <if_arp.h>
#include <types.h>


#pragma __nostandard
#ifdef __cplusplus
    extern "C" {
#endif


/*
**  The OpenVMS V7.0 release added a second implementation of the socket 
**  functions which is compatible with BSD 4.4.  Define a local to be 
**  used throughout the remaining header file which reflects which 
**  implementation is being used.
**
**  An application program enables this support by defining _SOCKADDR_LEN
**  prior to including this header file.
*/
#ifdef _SOCKADDR_LEN
#   if (__VMS_VER < 70000000)
#      error " BSD 4.4 Socket package not available before OpenVMS V7.0"
#      undef _SOCKADDR_LEN
#   endif
#endif


/*
**  Ensure that regardless of user /pointer_size usage, we begin processing
**  using a 32 bit pointer context.
*/
#if __INITIAL_POINTER_SIZE
#   if (__VMS_VER < 70000000) || !defined __ALPHA
#      error " Pointer size usage not permitted before OpenVMS Alpha V7.0"
#   endif
#   pragma __pointer_size __save
#   pragma __pointer_size 32
#endif


/*
**  All structures should be member aligned on natural boundaries
*/
#pragma __member_alignment __save
#pragma __member_alignment


/*
**  External names follow the "relaxed_refdef" model
*/
#pragma __extern_model __save
#pragma __extern_model __relaxed_refdef


/*
**  Define Page Size
*/
#ifdef __ALPHA
#   define NBPG 8192
#else
#   define NBPG 512
#endif


/*
**  Ioctl's have the command encoded in the lower word, and the size of
**  any in or out parameters in the upper word.  The high 3 bits of the
**  upper word are used to encode the in/out status of the parameter.
*/
#define IOCPARM_MASK    0x1fff          /* parameter length, at most 13 bits */
#define IOCPARM_LEN(x)  (((x) >> 16) & IOCPARM_MASK)
#define IOCBASECMD(x)   ((x) & ~(IOCPARM_MASK << 16))
#define IOCGROUP(x)     (((x) >> 8) & 0xff)

#define IOCPARM_MAX     NBPG            /* max size of ioctl, mult. of NBPG */
#define IOC_VOID        0x20000000      /* no parameters */
#define IOC_OUT         0x40000000      /* copy out parameters */
#define IOC_IN          0x80000000      /* copy in parameters */
#define IOC_INOUT       (IOC_IN|IOC_OUT)
#define IOC_DIRMASK     0xe0000000      /* mask for IN/OUT/VOID */

#define _IOC(inout,group,num,len) (inout | ((len & IOCPARM_MASK) << 16) | ((group) << 8) | (num))
#define _IO(g,n)        _IOC(IOC_VOID,  (g), (n), 0)
#define _IOR(g,n,t)     _IOC(IOC_OUT,   (g), (n), sizeof(t))
#define _IOW(g,n,t)     _IOC(IOC_IN,    (g), (n), sizeof(t))
/* this should be _IORW, but stdio got there first */
#define _IOWR(g,n,t)    _IOC(IOC_INOUT, (g), (n), sizeof(t))


/*
**  For terminal drivers
*/
#define FIONREAD   _IOR('f', 127, int)     /* get number of bytes to read */
#define FIONBIO    _IOW('f', 126, int)     /* set/clear non-blocking i/o  */
#define FIOASYNC   _IOW('f', 125, int)     /* set/clear async i/o         */


/* 
** Socket ioctl's. 
*/
#define SIOCSHIWAT _IOW('s',  0, int)    /* set high watermark */
#define SIOCGHIWAT _IOR('s',  1, int)    /* get high watermark */
#define SIOCSLOWAT _IOW('s',  2, int)    /* set low watermark  */
#define SIOCGLOWAT _IOR('s',  3, int)    /* get low watermark  */
#define SIOCATMARK _IOR('s',  7, int)    /* at oob mark?       */
#define SIOCSPGRP  _IOW('s',  8, pid_t)  /* set process group  */
#define SIOCGPGRP  _IOR('s',  9, pid_t)  /* get process group  */

#define SIOCSIFADDR    _IOW('i', 12, struct ifreq) /* set ifnet address */
#define SIOCSIFDSTADDR _IOW('i', 14, struct ifreq) /* set p-p address */
#define SIOCSIFFLAGS   _IOW('i', 16, struct ifreq) /* set ifnet flags */
#define SIOCGIFFLAGS   _IOWR('i',17, struct ifreq) /* get ifnet flags */
#define SIOCSIFBRDADDR _IOW('i', 19, struct ifreq) /* set broadcast addr */
#define SIOCSIFNETMASK _IOW('i', 22, struct ifreq) /* set net addr mask */
#define SIOCGIFMETRIC  _IOWR('i',23, struct ifreq) /* get IF metric */
#define SIOCSIFMETRIC  _IOW('i', 24, struct ifreq) /* set IF metric */
#define SIOCDIFADDR    _IOW('i', 25, struct ifreq) /* delete IF addr */
#define SIOCAIFADDR    _IOW('i', 26, struct ifaliasreq)/* add/chg IF alias */
#define SIOCPIFADDR    _IOW('i', 29, struct ifaliasreq)/* set primary addr */
#define SIOCSARP       _IOW('i', 30, struct arpreq)    /* set arp entry */
#define SIOCDARP       _IOW('i', 32, struct arpreq)    /* delete arp entry */
#define SIOCARPREQ     _IOWR('i',40, struct ifreq)     /* arp request pkt */
#define SIOCIFRESET    _IOW('i',47, struct ifreq)      /* Reset interface */
#define SIOCEEUPDATE   _IOW('i',48, struct ifeeprom)   /* Write EEPROM */

#define SIOCADDMULTI   _IOW('i', 49, struct ifreq) /* add m'cast addr */
#define SIOCDELMULTI   _IOW('i', 50, struct ifreq) /* del m'cast addr */


/*
**  Added by choosing arbitrary numbers
*/
#define SIOCENABLBACK   _IOW('i', 60, struct ifreq)     /* Enable loopback */
#define SIOCDISABLBACK  _IOW('i', 61, struct ifreq)     /* Disable loopback */
#define SIOCRPHYSADDR   _IOWR('i', 62, struct ifdevea)  /* Read Phys addr */
#define SIOCSPHYSADDR   _IOWR('i', 63, struct ifdevea)  /* Set addr */
#define SIOCIFSETCHAR   _IOWR('i', 64, struct ifchar)   /* Set characteristic */
#define SIOCSMACSPEED   _IOW('i', 65, struct ifreq)     /* Set MAC speed */
#define SIOCRMACSPEED   _IOWR('i', 66, struct ifreq)    /* Read MAC speed */
#define SIOCSIPMTU      _IOW('i', 67, struct ifreq)     /* Set intf. IP MTU */
#define SIOCRIPMTU      _IOWR('i', 68, struct ifreq)    /* Read intf. IP MTU */


#ifdef _SOCKADDR_LEN

    /*
    **  BSD 4.4 sockaddr format accepted and returned
    */
#   define OSIOCGIFADDR     _IOWR('i',13, struct ifreq)  /* get ifnet address */
#   define SIOCGIFADDR      _IOWR('i',33, struct ifreq)  /* get ifnet address */
#   define OSIOCGIFDSTADDR  _IOWR('i',15, struct ifreq)  /* get p-p address   */
#   define SIOCGIFDSTADDR   _IOWR('i',34, struct ifreq)  /* get p-p address   */
#   define OSIOCGIFBRDADDR  _IOWR('i',18, struct ifreq)  /* get broadcast adr */
#   define SIOCGIFBRDADDR   _IOWR('i',35, struct ifreq)  /* get broadcast adr */
#   define OSIOCGIFCONF     _IOWR('i',20, struct ifconf) /* get ifnet list    */
#   define SIOCGIFCONF      _IOWR('i',36, struct ifconf) /* get ifnet list    */
#   define OSIOCGIFNETMASK  _IOWR('i',21, struct ifreq)  /* get net addr mask */
#   define SIOCGIFNETMASK   _IOWR('i',37, struct ifreq)  /* get net addr mask */
#   define OSIOCGARP        _IOWR('i',31, struct arpreq) /* get arp entry     */
#   define SIOCGARP         _IOWR('i',38, struct arpreq) /* get arp entry     */

#else

    /*
    **  BSD 4.3 sockaddr format
    */
#   define SIOCGIFADDR      _IOWR('i',13, struct ifreq)  /* get ifnet address */
#   define SIOCGIFDSTADDR   _IOWR('i',15, struct ifreq)  /* get p-p address   */
#   define SIOCGIFBRDADDR   _IOWR('i',18, struct ifreq)  /* get broadcast adr */
#   define SIOCGIFCONF      _IOWR('i',20, struct ifconf) /* get ifnet list    */
#   define SIOCGIFNETMASK   _IOWR('i',21, struct ifreq)  /* get net addr mask */
#   define SIOCGARP         _IOWR('i',31, struct arpreq) /* get arp entry     */

#endif


/*
**  This section is for functions and declarations which do support 64 bit
**  pointers being passed (or returned).
**
**  The function ioctl passes a numeric "request code" followed by an 
**  argument pointer.  Since this request code could specify both input
**  and output arguments, and since the DEC C RTL does not interpret these
**  arguments, they are restricted from being in high memory.
*/
#if __VMS_VER >= 70000000
    int ioctl (int __sd, int __r, void * __argp);
#endif


/*
**  Restore the users pointer context
*/
#if __INITIAL_POINTER_SIZE
#   pragma __pointer_size __restore
#endif

#ifdef __cplusplus
    }
#endif

#pragma __member_alignment __restore
#pragma __extern_model __restore
#pragma __standard
#endif  /* __IOCTL_LOADED  */
