###########################################################################
# MMS/MMK file for Samba for VMS
# by Eckart Meyer 1995-1999
# derived from
# Makefile for Samba SMB client/server for unix
# Copyright Andrew Tridgell 1992-1999
###########################################################################

O = OBJ_$(__ARCH)
EXE = EXE_$(__ARCH)
OLB = OLB_$(__ARCH)
LIS = LIS_$(__ARCH)
MAP = MAP_$(__ARCH)
.SUFFIXES
.SUFFIXES : .$(EXE) .$(OLB) .$(O) .C

# Add any optimisation or debugging flags here
#FLAGS1 = /DEBUG/NOOPTIMIZE/LIST=$*.$(LIS)/SHOW=ALL
FLAGS1 = /DEBUG/NOOPTIMIZE $(CDEBUG)
#FLAGS1 = $(CDEBUG)
#LIBS1 = /DEBUG
LIBS1 = $(LDEBUG)

.IFDEF __SOCKETSHR__
TCPIP = ,SOCKETSHR.OPT/OPT
.ELSE
.IFDEF __DECC__
TCPIP =
.ELSE
TCPIP = ,SYS$LIBRARY:UCX$IPC/LIB
.ENDIF
.ENDIF

.IFDEF __DECC__
CRTL =
.ELSE
CRTL = ,VAXCRTL.OPT/OPT
.ENDIF

.IFDEF __ALPHA__
LINK = LINK/EXE=$*.$(EXE)
SYSEXE = /SYSEXE
.ELSE
LINK = LINK/EXE=$*.$(EXE)
SYSEXE = ,SYS$SYSTEM:SYS.STB/SELECTIVE_SEARCH
DECC_VAX_VEC = [.vms]decc$crtl_vec_vax.obj_vax
.ENDIF

#LIBS2 = $(CRTL) $(TCPIP)
LIBS2 = $(CRTL) $(TCPIP) ,[.vms]samba_lib.opt_$(__ARCH)/opt

LIBR = LIBRARY/REPLACE

DEFINES =
#FLAGSM = /DEFINE=(MODULE_NAME=$(MODULE)$(DEFINES))
FLAGSM = # /DEFINE=($(DEFINES))
FLAGS2 = /OBJ=$*.$(O)
LIBSM =
#LIBSM = /map=$*.$(MAP)/cross
#LIBSM = /debug

#CC = $(CC)/DECC conf.h+
#CC = $(CC)/DECC
#CFLAGS  = $(__CFLAGS) $(FLAGS2) $(FLAGSM) $(FLAGS1)
CFLAGS = $(FLAGS2)
LIBS = $(LIBS1) $(LIBSM) $(LIBS2)

SPROGS = smbd nmbd
PROGS1 = smbclient testparm testprns smbstatus smbpasswd 
PROGS = $(PROGS1) nmblookup make_smbcodepage
SCRIPTS = smbtar addtosmbpass


.FIRST
	@ show default
	cc := $(CC)/DECC$(__CFLAGS) $(FLAGSM) $(FLAGS1)
.IFDEF SAMBA_SETUP_DONE
.ELSE
	@ write sys$output ""
	@ write sys$output "Type ""@[.vms]setup"" and then try again"
	@ write sys$output ""
	@ a = samba_setup_done	! produces an error an stops mms
.ENDIF

.c.$(O) : $(INCLUDES)
	$(CC) $*.c $(CFLAGS) 
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)

all : $(SPROGS) $(PROGS)
	-@ !

INCLUDES1 = version.h local.h includes.h smb.h 
INCLUDES2 = trans2.h 
INCLUDES = $(INCLUDES1) $(INCLUDES2)

QUOTAOBJS = noquotas

######################################################################
# object file lists
######################################################################

#VMSOBJ = vms_sup.$(O) vms_dir.$(O) get.$(O) stat.$(O) getopt.$(O) priv.$(O) \
#	setuid.$(O) setuser.$(O) hpwd.$(O) stm_read.$(O) posixtim.$(O) \
#	tcp.$(O) utime.$(O)

VMS_OBJ = [.vms]utime.$(O) [.vms]posixtim.$(O) [.vms]stm_read.$(O) \
	[.vms]pwd.$(O) [.vms]cvt_filespec.$(O) [.vms]vms_sup.$(O) \
	[.vms]stat.$(O) [.vms]hpwd.$(O) [.vms]setuser.$(O) [.vms]setuid.$(O)

LIB_OBJ = $(VMS_OBJ)

.INCLUDE [.vms]modules.mms

#
# Some handy targets
#

smbd :		[.bin]smbd.$(EXE)
	-@ !

#smbrun :	[.bin]smbrun.$(EXE)
#	-@ !

nmblookup :	[.bin]nmblookup.$(EXE)
	-@ !

nmbd :		[.bin]nmbd.$(EXE)
	-@ !

smbclient :	[.bin]smbclient.$(EXE)
	-@ !

smbstatus :	[.bin]smbstatus.$(EXE)
	-@ !

testparm :	[.bin]testparm.$(EXE)
	-@ !

testprns :	[.bin]testprns.$(EXE)
	-@ !

make_smbcodepage :	[.bin]make_smbcodepage.$(EXE)
	-@ !

smbpasswd :	[.bin]smbpasswd.$(EXE)
	-@ !

decc_rtl :	[.bin]decc_rtl.$(EXE)
	-@ !
#
# Rules for the excutables
#

[.bin]smbd.$(EXE) :	$(SMBD_OBJ)
	$(LINK) [.smbd]server.$(O),[.bin]samba.$(OLB)/lib $(LIBS) $(SYSEXE)

#[.bin]smbrun.$(EXE) :	smbrun.$(O)
#	$(LINK) smbrun.$(O) $(LIBS)

[.bin]nmblookup.$(EXE) : $(NMBLOOKUP_OBJ)
	$(LINK) [.utils]nmblookup.$(O),[.bin]samba.$(OLB)/lib $(LIBS)

[.bin]nmbd.$(EXE) :	$(NMBD_OBJ) 
	$(LINK) [.nmbd]nmbd.$(O),[.bin]samba.$(OLB)/lib $(LIBS)

[.bin]smbclient.$(EXE) : $(CLIENT_OBJ)
	$(LINK) [.client]client.$(O),[.bin]samba.$(OLB)/lib $(LIBS)

[.bin]smbstatus.$(EXE) :	$(STATUS_OBJ) 
	$(LINK) [.utils]status.$(O),[.bin]samba.$(OLB)/lib $(LIBS)

[.bin]testparm.$(EXE) :	$(TESTPARM_OBJ)
	$(LINK) [.utils]testparm.$(O),[.bin]samba.$(OLB)/lib $(LIBS)

[.bin]testprns.$(EXE) :	$(TESTPRNS_OBJ)
	$(LINK) [.utils]testprns.$(O),[.bin]samba.$(OLB)/lib $(LIBS)

[.bin]make_smbcodepage.$(EXE) :	$(MAKE_SMBCODEPAGE_OBJ)
	$(LINK) [.utils]make_smbcodepage.$(O),[.bin]samba.$(OLB)/lib $(LIBS)

[.bin]smbpasswd.$(EXE) : $(SMBPASSWD_OBJ)
	$(LINK) [.utils]smbpasswd.$(O),[.bin]samba.$(OLB)/lib $(LIBS)

[.vms]decc$crtl_vec_vax.obj_vax : [.vms]decc$crtl_vec_vax.mar
	$Macro /obj=$*.obj_vax $<

[.bin]decc_rtl.$(EXE) : $(DECC_VAX_VEC)
	$(LINK) /share sys$disk:[.vms]c$$main,LNK$LIBRARY/lib,sys$disk:[.vms]decc$crtl_vec_$(__ARCH)/opt
	$define/system/exec SAMBA_CRTL SYS$DISK:$*.$(EXE)

#
# Special handling for some modules
# they override rules included in modrul.mms (see below)
#

[.lib]system.$(O) :	[.lib]system.c
	$(CC) $*.c $(CFLAGS) /WARNING=DISABLE=($(__WARNING_DISABLE),PTRMISMATCH)
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)

[.lib]util_sock.$(O) :	[.lib]util_sock.c
	$(CC) $*.c $(CFLAGS) /WARNING=DISABLE=($(__WARNING_DISABLE),PTRMISMATCH)
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)

[.lib]util_file.$(O) :	[.lib]util_file.c
	$(CC) $*.c $(CFLAGS) /DEFINE=($(DEFINES) "do_file_lock=do_file_lock")
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)

[.lib]util.$(O) :	[.lib]util.c
	$(CC) $*.c $(CFLAGS) /DEFINE=($(DEFINES) "fcntl_lock=dummy_fcntl_lock")
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)

[.param]loadparm.$(O) :	[.param]loadparm.c
	$(CC) $*.c $(CFLAGS) /DEFINE=($(DEFINES) "lp_share_modes=dummy_lp_share_modes","lp_locking=dummy_lp_locking")
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)

[.smbd]oplock.$(O) :	[.smbd]oplock.c
	$(CC) $*.c $(CFLAGS) /WARNING=DISABLE=($(__WARNING_DISABLE),PTRMISMATCH)
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)

[.smbd]server.$(O) :	[.smbd]server.c
	$(CC) $*.c $(CFLAGS) /WARNING=DISABLE=($(__WARNING_DISABLE),PTRMISMATCH)
	$(LIBR) [.bin]samba.$(OLB) $*.$(O) /noglobal

[.nmbd]nmbd.$(O) :	[.nmbd]nmbd.c
	$(CC) $*.c $(CFLAGS) 
	$(LIBR) [.bin]samba.$(OLB) $*.$(O) /noglobal

[.nmbd]nmbd_winsserver.$(O) :	[.nmbd]nmbd_winsserver.c
	$(CC) $*.c $(CFLAGS) /DEFINE=($(DEFINES) "CatchChild(A)=dummy_true(A)","fork(A)=FALSE")
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)

[.nmbd]nmbd_synclists.$(O) :	[.nmbd]nmbd_synclists.c
	$(CC) $*.c $(CFLAGS) /DEFINE=($(DEFINES) "CatchChild(A)=dummy_true(A)","fork(A)=FALSE")
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)

[.utils]nmblookup.$(O) :	[.utils]nmblookup.c
	$(CC) $*.c $(CFLAGS) 
	$(LIBR) [.bin]samba.$(OLB) $*.$(O) /noglobal

[.utils]status.$(O) :	[.utils]status.c
	$(CC) $*.c $(CFLAGS) 
	$(LIBR) [.bin]samba.$(OLB) $*.$(O) /noglobal

[.utils]testparm.$(O) :	[.utils]testparm.c
	$(CC) $*.c $(CFLAGS) 
	$(LIBR) [.bin]samba.$(OLB) $*.$(O) /noglobal

[.utils]testprns.$(O) :	[.utils]testprns.c
	$(CC) $*.c $(CFLAGS) 
	$(LIBR) [.bin]samba.$(OLB) $*.$(O) /noglobal

[.utils]make_smbcodepage.$(O) :	[.utils]make_smbcodepage.c
	$(CC) $*.c $(CFLAGS) 
	$(LIBR) [.bin]samba.$(OLB) $*.$(O) /noglobal

[.printing]printing.$(O) : [.printing]printing.c
	$(CC) $*.c $(CFLAGS) /DEFINE=($(DEFINES) \
		"get_printqueue=dummy_get_printqueue" \
		,"string_sub=vms_printing_string_sub")
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)

[.client]client.$(O) :	[.client]client.c
	$(CC) $*.c $(CFLAGS)
	$(LIBR) [.bin]samba.$(OLB) $*.$(O) /noglobal

[.utils]smbpasswd.$(O) :	[.utils]smbpasswd.c
	$(CC) $*.c $(CFLAGS) 
	$(LIBR) [.bin]samba.$(OLB) $*.$(O) /noglobal
#
# Rules for all modules.
# I assumed the built-in rule .c.o (see above) would do, but it seems
# that MMK (and MMS?) doesn't like subdirectory names. So we have one
# rule for each module (automatically generated).
#

.INCLUDE [.vms]modrul.mms

#
# VMS support modules
#

[.vms]vms_sup.$(O) :	[.vms]vms_sup.c
	$(CC) $*.c $(CFLAGS)
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)

vms_dir.$(O) :	[.vms]vms_dir.c
	$(CC) [.vms]vms_dir.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O)

get.$(O) :	[.vms]get.c
	$(CC) [.vms]get.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O)

[.vms]stat.$(O) :	[.vms]stat.c
	$(CC) $*.c $(CFLAGS)
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)

getopt.$(O) :	[.vms]getopt.c
	$(CC) [.vms]getopt.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O)

[.vms]hpwd.$(O) :	[.vms]hpwd.c
	$(CC) $*.c $(CFLAGS)
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)

priv.$(O) :	[.vms]priv.c
	$(CC) [.vms]priv.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O)

[.vms]setuid.$(O) :	[.vms]setuid.c
	$(CC) $*.c $(CFLAGS)
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)

[.vms]setuser.$(O) :	[.vms]setuser.mar
	MACRO/OBJ=$*.$(O) [.vms]setuser.mar
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)

[.vms]stm_read.$(O) :	[.vms]stm_read.c
	$(CC) $*.c $(CFLAGS)
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)

[.vms]posixtim.$(O) : [.vms]posixtim.c
	$(CC) $*.c $(CFLAGS) /DEFINE=($(DEFINES) "stat=vms_stat","fstat=vms_fstat","_VMS_V6_SOURCE")
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)

tcp.$(O) :	[.vms]tcp.c
	$(CC) [.vms]tcp.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O)

[.vms]utime.$(O) : [.vms]utime.c
	$(CC) $*.c $(CFLAGS)
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)

[.vms]pwd.$(O) : [.vms]pwd.c
	$(CC) $*.c $(CFLAGS)
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)

[.vms]cvt_filespec.$(O) : [.vms]cvt_filespec.c
	$(CC) $*.c $(CFLAGS)
	$(LIBR) [.bin]samba.$(OLB) $*.$(O)
#	$(LINK) [.vms]cvt_filespec.$(O),[.bin]samba.$(OLB)/lib $(LIBS)
