/* 
   Unix SMB/Netbios implementation.
   Version 2.0.
   Copyright (C) Andrew Tridgell 1994-1999

   This file is part of the port to OpenVMS
   Extra definitions for VMS
   Copyright (C) Eckart Meyer 1996-1999
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*	incl.h
 *	V2.0			IfN/Mey
 *
 *	Copyright E. Meyer <meyer@ifn.ing.tu-bs.de>
 *+
 * Some missing structures and definitions.
 *-
 */

/*
 * ino_t must be defined different in any case
 */
#define __DEV_T 1
typedef int dev_t;    
#define __INO_T 1
typedef unsigned int ino_t;

#include <types.h>
/* ============== from types.h ================= */
/*
**  ISO POSIX-1 typedefs
*/

/* 
**  Used for device IDs.
*/
#if !defined __DEV_T
#   define __DEV_T 1
/*    typedef char * dev_t;     */
    typedef int dev_t;
#endif

/*  
**  Used for group IDs.
*/
#if !defined __GID_T
#   define __GID_T 1
    typedef unsigned short gid_t;    
#endif

/* 
**  Used for file serial numbers.
*/
#if !defined __INO_T
#   define __INO_T 1
    typedef unsigned int ino_t;
#endif

/*  
**  Used for some file attributes.
*/
#if !defined __MODE_T
#   define __MODE_T 1
    typedef unsigned short mode_t;  
#endif

/* 
**  Used for link counts.
*/
#if !defined __NLINK_T
#   define __NLINK_T 1
    typedef int nlink_t;
#endif

/* 
**  Used for file sizes.
*/
#if !defined __OFF_T
#   define __OFF_T 1
    typedef int off_t;    
#endif

/* 
** Used for process IDs and process group IDs.
*/
#if !defined __PID_T
#   define __PID_T 1
    typedef int pid_t; 
#endif

/*
** Used for sizes of objects.
*/
#if !defined __SIZE_T
#   define __SIZE_T 1
    typedef unsigned int size_t;
#endif

/*
** Used for a count of bytes or an error indication.
*/
#if !defined __SSIZE_T
#   define __SSIZE_T 1
    typedef int ssize_t;
#endif

/*
** Used for user IDs.
*/
#if !defined __UID_T
#   define __UID_T 1
    typedef unsigned int uid_t;
#endif


/*	 
**  X/Open XPG4 typedefs, also defined in DECC V4
*/	 
#if defined _XOPEN_SOURCE || !defined _POSIX_C_SOURCE

/* 
**  Used for time in seconds.
*/
#   ifndef __TIME_T
#	define __TIME_T 1
	typedef unsigned long int time_t;
#   endif

#endif


#include <stat.h>
/* ============== from stat.h ================= */
/*
 * Our own definition of struct stat
 */
/*
 **  Do not naturally align data structures
 */
#pragma __member_alignment __save
#pragma __nomember_alignment

#define SMB_STRUCT_STAT struct samba_stat
struct  samba_stat
{
/*        __dev_t      st_dev;          /* pointer to physical device name */
        dev_t      st_dev;          /* pointer to physical device name */
/*        __ino_t      st_ino[3];       /* 3 words to receive fid */
	ino_t        st_ino;          /* one long	IfN/Mey */
	short        _st_ino3;        /* and one short  IFN/Mey */
        __mode_t     st_mode;         /* file "mode" i.e. prot, dir, reg, etc. */
        __nlink_t    st_nlink;        /* for compatibility - not really used */
        __uid_t      st_uid;          /* from ACP - QIO uic field */
        __gid_t      st_gid;          /* group number extracted from st_uid */
#if defined _XOPEN_SOURCE || !defined _POSIX_C_SOURCE
/*        __dev_t      st_rdev;         /* for compatibility - always zero */
        dev_t      st_rdev;         /* for compatibility - always zero */
#else
        __dev_t      st_fill1;
#endif

#ifdef _DECC_V4_SOURCE
        unsigned int st_size;         /* file size in bytes, was unsigned */
#else
        __off_t      st_size;         /* file size in bytes */
#endif
        __time_t     st_atime;        /* file access time; always same as st_mtime */
        __time_t     st_mtime;        /* last modification time */
        __time_t     st_ctime;        /* file creation time */
#ifndef _POSIX_C_SOURCE
        char         st_fab_rfm;      /* record format */
        char         st_fab_rat;      /* record attributes */
        char         st_fab_fsz;      /* fixed header size */
        unsigned int st_fab_mrs;      /* record size */
#else
        char         st_fill2[3];
        unsigned int st_fill3;
#endif
};
#pragma __member_alignment __restore

#include <socket.h>
/* ============== from socket.h ================= */

#if !defined __FD_SET && !defined _XOPEN_SOURCE_EXTENDED
#   define __FD_SET 1
#   ifndef FD_SETSIZE
#      define FD_SETSIZE      32
#   endif
    typedef long fd_mask;
#   define NBBY    8                            /* bits per byte */
#   define NFDBITS (sizeof(fd_mask) * NBBY)     /* bits per mask */
#   define FD_SET(__n, __p)   ((__p)->fds_bits[(__n)/NFDBITS] |= (1 << ((__n) % NFDBITS)))
#   define FD_CLR(__n, __p)   ((__p)->fds_bits[(__n)/NFDBITS] &= ~(1 << ((__n) % NFDBITS)))
#   define FD_ISSET(__n, __p) ((__p)->fds_bits[(__n)/NFDBITS] & (1 << ((__n) % NFDBITS)))
#   define __howmany(__x, __y)   (((__x)+((__y)-1))/(__y))

    typedef struct fd_set {                            /* descriptor set */        
       fd_mask fds_bits[__howmany(FD_SETSIZE, NFDBITS)];
    } fd_set;

#   ifdef __ALPHA
#      if __INITIAL_POINTER_SIZE == 64
#         pragma __pointer_size 64
#      endif
       void *__MEMSET(void *__s, int __c, size_t __n);
#      define FD_ZERO(__p) __MEMSET((__p), 0, sizeof(*(__p)))
#      if __INITIAL_POINTER_SIZE == 64
#         pragma __pointer_size 32
#      endif
#   else
	void _MOVC5(unsigned short __srclen, const char *__src, char __fill, 
		unsigned short __destlen, char *__dest, ...);
#	define FD_ZERO(__p) _MOVC5(0, 0, 0, sizeof(*(__p)), (char *)(__p))
#   endif

#endif

#include <fcntl.h>
/* ============== from fcntl.h ================= */

/*	  
**  `cmd' values for fcntl()
*/	  
# define F_DUPFD	0
# define F_GETFD	1
# define F_SETFD	2
# define F_GETFL	3
# define F_SETFL	4
/* #if HAVE_FCNTL_LOCK /**/
# define F_GETLK	7
# define F_SETLK	8
# define F_SETLKW	9

/*	  
**  File descriptor flags used for fcntl()
*/	  
# define FD_CLOEXEC	1

/*	  
**  `l_type' values for record locking with fcntl()
*/	  
# define F_RDLCK	1
# define F_WRLCK	2
# define F_UNLCK	3
/* #endif /* HAVE_FCNTL_LOCK */

#if 0
/*	  
**  `oflag' values for open()
*/	  
# define O_CREAT	0x00000200
# define O_TRUNC	0x00000400
# define O_EXCL		0x00000800
# define O_NOCTTY	0x00080000

/*	  
**  File status flags used for open() and fcntl()
*/	  
/* # define O_NONBLOCK	0x00000004 */
# define O_NDELAY	O_NONBLOCK
# define O_APPEND	0x00000008
# define O_DSYNC	0x00004000
# define O_FSYNC	0x00008000
# define O_SYNC		O_FSYNC

/*	  
**  File access modes used for open() and fcntl()
*/	  
# define O_RDONLY	0
# define O_WRONLY	1
# define O_RDWR		2

/*	  
**  Mask for use with file access modes
*/	  
# define O_ACCMODE	(O_RDONLY|O_WRONLY|O_RDWR)
#endif

#if __CRTL_VER < 70000000
# define O_NONBLOCK	0x00000004
#endif

int fcntl(int __fd, int __cmd, ...);

#include <unistd.h>
/* ============== from unistd.h ================= */

#if __DECC_VER < 50200000  ||  __CRTL_VER < 70000000
#include <unixio.h>
#include <unixlib.h>
int ftruncate (int __filedes, __off_t __length );
int rmdir (char *__path);
#endif

int getgroups(int __gidsetsize, gid_t __grouplist[]);
int seteuid  (uid_t);

char *crypt(const char *__key, const char *__salt);

#include <signal.h>
/* ============== from signal.h ================= */

#if __DECC_VER < 50200000  ||  __CRTL_VER < 70000000
#define SIGCHLD 20
#endif

/* ============== from time.h ================= */
#if __CRTL_VER < 70000000 || defined _VMS_V6_SOURCE
        int gettimeofday (struct timeval *__tp, void *__tzp);
#endif

/* ============== other ================= */

char *getpass(char *__prompt);

/* ============== Samba for VMS ================= */

char *vms_get_unix_path(const char *vmsfile);
char *vms_get_filespec(const char *vmsfile);
char *vms_get_filedir(const char *vmsfile);
char *vms_encode_filespec(const char *unixfile, int dirflag);
char *vms_decode_filespec(const char *unixfile);
