 /*  #    Unix SMB/Netbios implementation.     Version 2.0. *    Copyright (C) Andrew Tridgell 1994-1999  +    This file is part of the port to OpenVMS     User database routines.'    Copyright (C) Eckart Meyer 1996-1999      G    This program is free software; you can redistribute it and/or modify G    it under the terms of the GNU General Public License as published by D    the Free Software Foundation; either version 2 of the License, or&    (at your option) any later version.     B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.      D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free Software<    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ /*	pwd.c  *	V1.0			21-Feb-1999	IfN/Mey   *.  *	Copyright E. Meyer <meyer@ifn.ing.tu-bs.de>  *+   * Samba VMS support.   * getpwnam, getpwgrp etc.  *-   */    #include <includes.h>  #include <descrip.h> #include <ssdef.h> #include <starlet.h> #include <prvdef.h>  #include <uaidef.h>    struct uai {0 	char name[13];		/* must be at first position */ 	unsigned long uic;  	unsigned long priv[2];  	struct id *id_list; 	char dir[256];  	char password[9]; 	struct uai *next; };   struct id {  	unsigned long uic;  	unsigned long attr; };   struct itemdesc {    short int buffer_length;   short int item_code;   char *buffer;    short int *ret_length;   };     extern int DEBUGLEVEL;  M /**************************************************************************** ?  copy_pw - copy from DEC-C passwd to our extended passwd struct M  ***************************************************************************/ = static copy_pw(struct passwd * my_pw, struct passwd * vms_pw)  { " 	my_pw->pw_name = vms_pw->pw_name;  	my_pw->pw_uid = vms_pw->pw_uid;  	my_pw->pw_gid = vms_pw->pw_gid;  	my_pw->pw_dir = vms_pw->pw_dir;$ 	my_pw->pw_shell = vms_pw->pw_shell; 	my_pw->pw_passwd = NULL;  	my_pw->pw_comment = NULL; 	my_pw->pw_gecos = NULL; /*!  * Samba needs SYSTEM to be [0,0]   */ 1 	if (strcasecmp(vms_pw->pw_name,"SYSTEM") == 0) {  		my_pw->pw_uid = 0; 		my_pw->pw_gid = 0; 	} }     M /****************************************************************************   get_user_identifiers M  ***************************************************************************/ 9 static struct id *get_user_identifiers(unsigned long uic)  {  	unsigned long sts;  	unsigned long ctx;  	struct id *id_list; 	struct id holder; 	struct id id; 	int count;    	holder.uic = uic; 	holder.attr = 0;   2 	id_list = (struct id *)malloc(sizeof(struct id));# 	if (id_list == NULL) return(NULL);    	count = 0; 	 	ctx = 0;   D 	while ( (sts=sys$find_held(&holder, &id.uic, &id.attr, &ctx))&1 ) {) 		id_list = (struct id *)realloc(id_list, % 					sizeof(struct id) * (count+2) ); $ 		if (id_list == NULL) return(NULL); 		id_list[count].uic = id.uic;  		id_list[count].attr = id.attr;7 		DEBUG(6,("  identifier %d = %08X\n",count+1,id.uic)); 
 		count++; 	}   	id_list[count].uic = -1; : 	DEBUG(6,("  uic %08X holds %d identifiers\n",uic,count)); 	return(id_list);  }        static struct uai *cuai = NULL; M /****************************************************************************    get_uai - get UAI info from VMSM  ***************************************************************************/ * static struct uai *get_uai(char *username) {  	short int iosb[4], lgth[6];
 	long int st; 	 	struct {  		struct itemdesc id[6];
 		int eol;
 	} itmlst;	 	struct {  		int size;  		char *ptr; 	} namedesc; 	char defdir[64];  	char defdev[64];  	char usrnam[14]; 	 	char *p;   : 	DEBUG (3,("get_uai: for username = \"%s\"\n", username));  # 	if (!cuai) {	/* first time init */ 2 		cuai = (struct uai *)malloc(sizeof(struct uai)); 	}6 	else {		/* return memory used by previous contents */) 		if (cuai->id_list) free(cuai->id_list);  	}+ 	StrCpy(cuai->name, username);	/* Preset */   # 	itmlst.id[0].item_code = UAI$_PWD;   	itmlst.id[0].buffer_length = 8;& 	itmlst.id[0].buffer = cuai->password;$ 	itmlst.id[0].ret_length = &lgth[0];  & 	itmlst.id[1].item_code = UAI$_DEFDIR;! 	itmlst.id[1].buffer_length = 64;  	itmlst.id[1].buffer = defdir;$ 	itmlst.id[1].ret_length = &lgth[1];  & 	itmlst.id[2].item_code = UAI$_DEFDEV;! 	itmlst.id[2].buffer_length = 64;  	itmlst.id[2].buffer = defdev;$ 	itmlst.id[2].ret_length = &lgth[2];  # 	itmlst.id[3].item_code = UAI$_UIC;   	itmlst.id[3].buffer_length = 4;+ 	itmlst.id[3].buffer = (char *) &cuai->uic; $ 	itmlst.id[3].ret_length = &lgth[3];  $ 	itmlst.id[4].item_code = UAI$_PRIV;  	itmlst.id[4].buffer_length = 8;+ 	itmlst.id[4].buffer = (char *) cuai->priv; $ 	itmlst.id[4].ret_length = &lgth[4];  ( 	itmlst.id[5].item_code = UAI$_USERNAME;! 	itmlst.id[5].buffer_length = 12; " 	itmlst.id[5].buffer = cuai->name;$ 	itmlst.id[5].ret_length = &lgth[5];   	itmlst.eol = 0;  " 	namedesc.size = strlen(username); 	namedesc.ptr = username; 4 	st = sys$getuai(0, 0, &namedesc, &itmlst, 0, 0, 0);* 	if ((st != SS$_NORMAL) && !(st & 0x01)) {= 		DEBUG (3,("get_uai: sys$getuai error: %08X %d\n", st, st));  		return(NULL);  	}  P 	for (p = cuai->name + lgth[5] - 1; p >= cuai->name && *p == ' ';--p) *p = '\0'; 	cuai->password[8] = '\0'; 	defdir[defdir[0]+1] = '\0'; 	defdev[defdev[0]+1] = '\0';< 	pstrcat(defdev + 1, defdir +1 );	/* append dir to device */! 	p = vms_get_unix_path(defdev+1);  	StrCpy(cuai->dir, p);4 	DEBUG (5,("get_uai: login dir = %s\n", cuai->dir));  1 	cuai->id_list = get_user_identifiers(cuai->uic);  #if 0  	if (uai_head == NULL) { 		cuai->next = NULL; 		uai_head = cuai; 	} 	else {  		cuai->next = uai_head; 		uai_head = cuai; 	} #endif  B DEBUG    (3,("get_uai: $getuai returns UIC = %08X\n", cuai->uic));J DEBUGADD (3,("         priv = %08X %08X\n", cuai->priv[0],cuai->priv[1])); 	return(cuai); }        #ifdef getpwnam  #undef getpwnam / struct passwd * getpwnam (const char * __name);  #endif   static char pw_dir[256] = ""; > static struct passwd password_struct = {NULL,0,0,pw_dir,NULL};M /**************************************************************************** $  getpwnam - return user data by nameM  ***************************************************************************/ - struct passwd *vms_getpwnam(const char *name)  {  	struct passwd *pw;  	struct uai *puai;	 	char *p;    	p = (char *)name;- DEBUG (3,("getpwnam: name = \"%s\"\n",name));   $ 	if (strcasecmp(name,"root") == 0) { 		p = "SYSTEM";  	}$ if (strcasecmp(name,"meyer") == 0) { printf("meyer!!!!\n"); } & 	if (password_struct.pw_name == NULL  4 	|| strcasecmp(name,password_struct.pw_name) != 0) { 		pw = getpwnam(p);  		if (!pw) return(NULL);  		copy_pw(&password_struct, pw); 		puai = get_uai(pw->pw_name);- 		password_struct.pw_passwd = puai->password;  		StrCpy(pw_dir, puai->dir);" 		password_struct.pw_dir = pw_dir; 	} 	return(&password_struct); }      #ifdef getpwuid  #undef getpwuid ' struct passwd * getpwuid (uid_t __uid);  #endifM /**************************************************************************** #  getpwuid - return user data by uid M  ***************************************************************************/ & struct passwd *vms_getpwuid(uid_t uid) {  	struct passwd *pw;  	struct uai *puai; /*!  * Samba needs SYSTEM to be [0,0]   */ 7 	if (uid == 0) uid = 0x00010004L;	/* SYSTEM is [1,4] */ + DEBUG (3,("getpwuid: uid = [%08X]\n",uid)); & 	if (password_struct.pw_name == NULL  % 	||  uid != password_struct.pw_uid) {  		pw = getpwuid(uid);  		if (!pw) return(NULL);  		copy_pw(&password_struct, pw); 		puai = get_uai(pw->pw_name);- 		password_struct.pw_passwd = puai->password;  		StrCpy(pw_dir, puai->dir);" 		password_struct.pw_dir = pw_dir; 	} 	return(&password_struct); }      static struct group user_grp;  static char gr_name[32];M /**************************************************************************** $  getprgid - return group data by gidM  ***************************************************************************/ % struct group *vms_getgrgid(gid_t gid)  { " 	struct dsc$descriptor_s dsc_name; 	unsigned short namlen;  	unsigned long sts;  	unsigned long id;  " 	dsc_name.dsc$a_pointer = gr_name;- 	dsc_name.dsc$w_length = sizeof(gr_name) - 1; & 	dsc_name.dsc$b_class = DSC$K_CLASS_S;& 	dsc_name.dsc$b_dtype = DSC$K_DTYPE_T;$ 	id = ((gid&0xFFFF) << 16) | 0xFFFF;/ 	sts = sys$idtoasc(id,&namlen,&dsc_name,0,0,0);  	if (!(sts&1)) return(NULL); 	gr_name[namlen] = '\0'; 	user_grp.gr_name = gr_name;/ 	user_grp.gr_passwd = NULL;	/* not supported */  	user_grp.gr_gid = gid; - 	user_grp.gr_mem = NULL;		/* not supported */  	return(&user_grp);  }     M /**************************************************************************** $  getprnam - return user data by nameM  ***************************************************************************/ , struct group *vms_getgrnam(const char *name) { " 	struct dsc$descriptor_s dsc_name; 	unsigned long sts;  	unsigned long id;  ' 	dsc_name.dsc$a_pointer = (char *)name; & 	dsc_name.dsc$w_length = strlen(name);& 	dsc_name.dsc$b_class = DSC$K_CLASS_S;& 	dsc_name.dsc$b_dtype = DSC$K_DTYPE_T;$ 	sts = sys$asctoid(&dsc_name,&id,0); 	if (!(sts&1)) return(NULL); 	id = (id >> 16) & 0xFFFF;! 	user_grp.gr_name = (char *)name; / 	user_grp.gr_passwd = NULL;	/* not supported */  	user_grp.gr_gid = id;- 	user_grp.gr_mem = NULL;		/* not supported */  	return(&user_grp);  }      static gid_t user_gid;M /****************************************************************************   initgroups - dummy for now...M  ***************************************************************************/ - int vms_initgroups(char *name, gid_t basegid)  {  	user_gid = basegid;
 	return 0; }     M /**************************************************************************** /  getgroups - VMS users belong to one group only   .  The value is taken from the last getpw* call.M  ***************************************************************************/ 4 int vms_getgroups(int gidsetsize, gid_t grouplist[]) {  	if (gidsetsize > 0) {( 		grouplist[0] = password_struct.pw_gid; 	} 	return(1);  }     M /****************************************************************************   setgroups - dummyM  ***************************************************************************/ . int vms_setgroups(int ngroups, gid_t gidset[]) {  	return(0);  }       
 #ifdef getuid 
 #undef getuid  #define getuid __unix_getuid uid_t getuid();  #endifM /****************************************************************************   getuid - get uic from VMSM  ***************************************************************************/  uid_t vms_getuid() {  	uid_t uid;  	uid = getuid();C 	if (uid == 0x00010004L  ||  uid == 0x00010001L) uid = 0x00000000L; 
 	return(uid);  }     
 #ifdef getgid 
 #undef getgid  gid_t getgid();  #endifM /**************************************************************************** %  getgid - get uic group part from VMS M  ***************************************************************************/  gid_t vms_getgid() {  	gid_t gid;  	gid = getgid();
 	return(gid);  }     M /****************************************************************************   setgid - dummy M  ***************************************************************************/  int vms_setgid(gid_t uid)  {  	return(0);  }       M /****************************************************************************   grant_identifiersM  ***************************************************************************/ 1 static void grant_identifiers(struct id *id_list)  {  	unsigned long sts;    	if (id_list == NULL) return;  	while(id_list->uic != -1) {6 		DEBUG(6,("  grant identifier %08X\n",id_list->uic));% 		sts = sys$grantid(0,0,id_list,0,0);  		id_list++; 	} }   M /****************************************************************************   revoke_identifiers M  ***************************************************************************/ 2 static void revoke_identifiers(struct id *id_list) {  	unsigned long sts;    	if (id_list == NULL) return;  	while(id_list->uic != -1) {7 		DEBUG(6,("  revoke identifier %08X\n",id_list->uic)); % 		sts = sys$revokid(0,0,id_list,0,0);  		id_list++; 	} }       6 static void copy_uai(struct uai *dst, struct uai *src) {  	int count;  	struct id *id_list;  * 	if (src == NULL  ||  dst == NULL) return;$ 	memcpy(dst,src,sizeof(struct uai));  2 	id_list = (struct id *)malloc(sizeof(struct id)); 	if (id_list == NULL) return;    	count = 0;   * 	while ( src->id_list[count].uic != -1 ) {) 		id_list = (struct id *)realloc(id_list, % 					sizeof(struct id) * (count+2) );  		if (id_list == NULL) break; / 		id_list[count].uic = src->id_list[count].uic; 1 		id_list[count].attr = src->id_list[count].attr; N 		DEBUGADD(6,("copy_uai: identifier %d = %08X\n",count+1,id_list[count].uic));
 		count++; 	}   	id_list[count].uic = -1; 2 	DEBUGADD(6,("   copied %d identifiers\n",count)); 	dst->id_list = id_list; }   % static struct uai current_uai = {""};  static struct uai *pnew_uai;  M /**************************************************************************** :  vms_setuid_1 - called by setuid - lookup old and new userM  ***************************************************************************/ @ int vms_setuid_1(uid_t uid, char **new_username, uid_t *new_uid) {  	struct passwd *pw;  	int st;
 	struct dsc {  		int size;  		char *ptr; 	}; 8 	long sys_set_username(void *);		/* These are the ... */C 	long sys_set_uic(unsigned int *);	/* ...kernel hacking routines */  	unsigned long tmpprv[2];   , 	DEBUG (3,("vms_setuid: uid = %08X\n",uid)); /*  * Current UAI  */ ! 	if (*current_uai.name == '\0') { 1 		struct passwd *pw = vms_getpwuid(vms_getuid()); ? 		if (!cuai) return(-1);	/* vms_getpwuid implicitly set cuai */  		copy_uai(&current_uai,cuai); 	} /*
  * New UAI  */  	if (uid == 0) { 		*new_uid = 0x00010004; 	} 	else {  		*new_uid = uid;  	} /*'  * If same than current, nothing to do.   */ , 	if (*new_uid == current_uai.uic) return(0);   	if (uid == 0) { 		pnew_uai = get_uai("SYSTEM");  	} 	else {  		pw = getpwuid(*new_uid); 		if (!pw) return(-1);" 		pnew_uai = get_uai(pw->pw_name); 	} 	if (!pnew_uai) return(-1); E 	DEBUG (3,("vms_setuid: uid = %08X, username = \"%s\", uic = %08X\n", * 		*new_uid,pnew_uai->name,pnew_uai->uic)); /*-  * Set new use user name, UIC and privileges.   *=  *	- clear all privs and set CMKRNL for setting username/uic.   */  	tmpprv[0] = 0xFFFFFFFF; 	tmpprv[1] = 0xFFFFFFFF;Q #if 0 /* since we enable *all* privileges, we don't needd to clear them before */ : 	st = sys$setprv(0,tmpprv,0,0);	/* clear all privileges */" 	if (st != SS$_NORMAL) return(-1); 	tmpprv[0] = PRV$M_CMKRNL; 	tmpprv[1] = 0;  #endif@ 	st = sys$setprv(1,tmpprv,0,0);	/* enable to set USERNAME/UIC */" 	if (st != SS$_NORMAL) return(-1); /*4  *	- revoke current user's identifiers and setup new  */ ) 	revoke_identifiers(current_uai.id_list); & 	grant_identifiers(pnew_uai->id_list);   /*  * Return new name and uid  */   	*new_username = pnew_uai->name; 	return(1);  }      int vms_setuid_2() {  	int st; 	unsigned long tmpprv[2];  /*.  * New UAI is now current - free old resource!  */ 4 	if (current_uai.id_list) free(current_uai.id_list);! 	copy_uai(&current_uai,pnew_uai);  /*-  *	- clear privileges required for hacking...   */ 7 	st = sys$setprv(0,tmpprv,0,0);	/* reset those privs */ " 	if (st != SS$_NORMAL) return(-1); /*   *	- finally set new users privs  */ S DEBUG (3,("vms_setuid: privs = %08X %08X\n",pnew_uai->priv[0], pnew_uai->priv[1])); B 	st = sys$setprv(1,pnew_uai->priv,0,0);	/* set new user's privs */" 	if (st != SS$_NORMAL) return(-1);   	if (DEBUGLEVEL >= 8) {  		sys$setprv(0,0,0,tmpprv); C DEBUG (8,("            privs = %08X %08X\n",tmpprv[0], tmpprv[1]));  	} 	return(0);  }        static char result[64]; M /****************************************************************************   crypt  H  Special version. We need to know the username here since the salt valueE  is not taken from the given argument, but from the UAI. Since a user0G  name is provided by the caller we use the user last seen by the getpw* %  routines. Seems to work for samba...rM  ***************************************************************************/e. char *crypt(const char *key, const char *salt) {   	short int st, iosb[4], lgth[3];	 	struct {i 		struct itemdesc id[3];
 		int eol;
 	} itmlst;	 	struct {e 		int size;  		char *ptr;. 	} outdesc, fullnamedesc, namedesc, passwdesc; 	long encrypt, ssalt;s 	char username[64];o	 	char *p;w	 	char *q;u 	long lgi$hpwd();A 	char *login_name;  
 	encrypt = 0;  	ssalt = 0;   $ 	itmlst.id[0].item_code = UAI$_SALT;  	itmlst.id[0].buffer_length = 2;' 	itmlst.id[0].buffer = (char *) &ssalt; $ 	itmlst.id[0].ret_length = &lgth[0];  ' 	itmlst.id[1].item_code = UAI$_ENCRYPT;o  	itmlst.id[1].buffer_length = 1;) 	itmlst.id[1].buffer = (char *) &encrypt;,$ 	itmlst.id[1].ret_length = &lgth[1];  ( 	itmlst.id[2].item_code = UAI$_USERNAME;! 	itmlst.id[2].buffer_length = 64;y  	itmlst.id[2].buffer = username;$ 	itmlst.id[2].ret_length = &lgth[2];   	itmlst.eol = 0;   	login_name = cuai->name;c$ 	namedesc.size = strlen(login_name); 	namedesc.ptr = login_name;e7 	DEBUG (3,  ("crypt: username = \"%s\"\n",login_name)); B 	if ((st=sys$getuai(0,0,&namedesc,&itmlst,0,0,0)) != SS$_NORMAL) {3 		DEBUG (0,("sys$getuai error %08X %d\n", st, st));i 		result[0] = '\0';o 		return(result);  	} 	outdesc.size = 8; 	outdesc.ptr = result;' 	passwdesc.ptr = malloc(strlen(key)+1);dG 	for(p=(char *)key, q=passwdesc.ptr;*p != '\0';p++) *q++ = toupper(*p);r 	*q = '\0';n 	passwdesc.size = strlen(key);5 	DEBUG (100,("crypt: key = \"%s\"\n",passwdesc.ptr));* /* 	fullnamedesc.size = lgth[2];* 	fullnamedesc.ptr = username;C */( 	fullnamedesc.size = strlen(login_name); 	fullnamedesc.ptr = login_name;*D 	st = lgi$hpwd(&outdesc, &passwdesc, encrypt, ssalt, &fullnamedesc); 	free(passwdesc.ptr);  	result[8] = '\0';8 	DEBUG    (3,("crypt: result=%08X\n",*((int *)result)));E 	DEBUGADD (3,("crypt: passwd=%08X\n",*((int *)cuai->password))); /**/i 	return(result); }=  